/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.JavaInfoCmd;
import tcl.lang.JavaInvoke;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.reflect.PkgInvoker;

class FuncSig
extends InternalRep {
    static Hashtable allDeclMethTable = new Hashtable();
    Class targetCls;
    PkgInvoker pkgInvoker;
    Object func;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Object;

    protected InternalRep duplicate() {
        return new FuncSig(this.targetCls, this.pkgInvoker, this.func);
    }

    static FuncSig get(Interp interp, Class cls, TclObject signature, TclObject[] argv, int startIdx, int count) throws TclException {
        Executable match;
        boolean isConstructor = cls == null;
        int sigLength = TclList.getLength((Interp)interp, (TclObject)signature);
        String methodName = null;
        if (sigLength == 0) {
            throw new TclException(interp, "bad signature \"" + signature + "\"");
        }
        if (isConstructor) {
            cls = JavaInvoke.getClassByName(interp, TclList.index((Interp)interp, (TclObject)signature, (int)0).toString());
        } else {
            methodName = TclList.index((Interp)interp, (TclObject)signature, (int)0).toString();
        }
        if (sigLength > 1 || sigLength == 1 && count == 0) {
            int sigNumArgs = sigLength - 1;
            Class[] paramTypes = new Class[sigNumArgs];
            int i = 0;
            while (i < sigNumArgs) {
                String clsName = TclList.index((Interp)interp, (TclObject)signature, (int)(i + 1)).toString();
                paramTypes[i] = JavaInvoke.getClassByName(interp, clsName);
                ++i;
            }
            if (isConstructor) {
                try {
                    match = cls.getDeclaredConstructor(paramTypes);
                }
                catch (NoSuchMethodException e) {
                    if (sigLength > 1) {
                        throw new TclException(interp, "no such constructor \"" + signature + "\"");
                    }
                    throw new TclException(interp, "can't find constructor with " + count + " argument(s) for class \"" + cls.getName() + "\"");
                }
            } else {
                match = FuncSig.lookupMethod(interp, cls, methodName, paramTypes, signature);
            }
        } else {
            match = FuncSig.matchSignature(interp, cls, signature, methodName, isConstructor, argv, startIdx, count);
        }
        FuncSig sig = new FuncSig(cls, PkgInvoker.getPkgInvoker(cls), match);
        signature.setInternalRep(sig);
        return sig;
    }

    static Method lookupMethod(Interp interp, Class cls, String methodName, Class[] paramTypes, TclObject signature) throws TclException {
        Method[] methods = FuncSig.getAllDeclaredMethods(cls);
        boolean foundSameName = false;
        int i = 0;
        while (i < methods.length) {
            if (methodName.equals(methods[i].getName())) {
                foundSameName = true;
                Class<?>[] pt = methods[i].getParameterTypes();
                if (pt.length == paramTypes.length) {
                    boolean good = true;
                    int j = 0;
                    while (j < pt.length) {
                        if (pt[j] != paramTypes[j]) {
                            good = false;
                            break;
                        }
                        ++j;
                    }
                    if (good) {
                        return methods[i];
                    }
                }
            }
            ++i;
        }
        if (paramTypes.length > 0 || !foundSameName) {
            throw new TclException(interp, "no such method \"" + signature + "\" in class " + cls.getName());
        }
        throw new TclException(interp, "can't find method \"" + signature + "\" with " + paramTypes.length + " argument(s) for class \"" + cls.getName() + "\"");
    }

    static Object matchSignature(Interp interp, Class cls, TclObject signature, String methodName, boolean isConstructor, TclObject[] argv, int startIdx, int argv_count) throws TclException {
        boolean foundSameName;
        block52: {
            StringBuffer sb;
            int j;
            Class<?>[] match_classes;
            int i;
            Vector<Executable> match_vector;
            block57: {
                block53: {
                    Class c;
                    foundSameName = false;
                    match_vector = new Vector<Executable>();
                    boolean debug = false;
                    Executable[] funcs = isConstructor ? cls.getDeclaredConstructors() : FuncSig.getAllDeclaredMethods(cls);
                    i = 0;
                    while (i < funcs.length) {
                        block51: {
                            Class<?>[] paramTypes;
                            block50: {
                                block49: {
                                    if (!isConstructor) break block49;
                                    paramTypes = ((Constructor)funcs[i]).getParameterTypes();
                                    break block50;
                                }
                                Method method = (Method)funcs[i];
                                if (!methodName.equals(method.getName())) break block51;
                                foundSameName = true;
                                paramTypes = method.getParameterTypes();
                            }
                            if (paramTypes.length == argv_count) {
                                match_vector.addElement(funcs[i]);
                            }
                        }
                        ++i;
                    }
                    if (match_vector.size() == 1) {
                        return match_vector.elementAt(0);
                    }
                    if (match_vector.size() <= 1) break block52;
                    Class[] argv_classes = new Class[argv_count];
                    i = 0;
                    while (i < argv_count) {
                        TclObject tobj = argv[startIdx + i];
                        boolean isJavaObj = true;
                        c = null;
                        try {
                            c = ReflectObject.getClass(interp, tobj);
                        }
                        catch (TclException e) {
                            isJavaObj = false;
                        }
                        argv_classes[i] = isJavaObj ? c : (class$Ljava$lang$String != null ? class$Ljava$lang$String : FuncSig.class$("java.lang.String"));
                        ++i;
                    }
                    i = 0;
                    while (i < match_vector.size()) {
                        match_classes = isConstructor ? ((Constructor)match_vector.elementAt(i)).getParameterTypes() : ((Method)match_vector.elementAt(i)).getParameterTypes();
                        boolean exact = true;
                        j = 0;
                        while (j < argv_count) {
                            if (match_classes[j] != argv_classes[j]) {
                                exact = false;
                                break;
                            }
                            ++j;
                        }
                        if (exact) {
                            return match_vector.elementAt(i);
                        }
                        ++i;
                    }
                    i = match_vector.size() - 1;
                    while (i >= 0) {
                        match_classes = isConstructor ? ((Constructor)match_vector.elementAt(i)).getParameterTypes() : ((Method)match_vector.elementAt(i)).getParameterTypes();
                        j = 0;
                        while (j < argv_count) {
                            if (match_classes[j].isPrimitive() && argv_classes[j] == null || argv_classes[j] != null && match_classes[j] != argv_classes[j] && !match_classes[j].isAssignableFrom(argv_classes[j])) {
                                match_vector.removeElementAt(i);
                                break;
                            }
                            ++j;
                        }
                        --i;
                    }
                    if (match_vector.size() == 1) {
                        return match_vector.elementAt(0);
                    }
                    if (match_vector.size() > 1) {
                        Class[][] argv_classes_lookup = new Class[argv_count][];
                        Vector class_vector = new Vector();
                        i = 0;
                        while (i < argv_count) {
                            c = argv_classes[i];
                            if (c != null) {
                                j = 0;
                                while (j < i) {
                                    if (c == argv_classes_lookup[j][0]) {
                                        argv_classes_lookup[i] = argv_classes_lookup[j];
                                    }
                                    ++j;
                                }
                                while (c != null) {
                                    class_vector.addElement(null);
                                    FuncSig.addInterfaces(c, class_vector);
                                    c = c.getSuperclass();
                                }
                                class_vector.removeElementAt(0);
                                Object[] classes = new Class[class_vector.size()];
                                class_vector.copyInto(classes);
                                argv_classes_lookup[i] = classes;
                                class_vector.removeAllElements();
                            }
                            ++i;
                        }
                        int[] super_steps = new int[match_vector.size()];
                        int[] total_steps = new int[match_vector.size()];
                        boolean[] trim_matches = new boolean[match_vector.size()];
                        j = 0;
                        while (j < argv_count) {
                            int min_super_step = Integer.MAX_VALUE;
                            int min_total_step = Integer.MAX_VALUE;
                            Class min_class = class$Ljava$lang$Object != null ? class$Ljava$lang$Object : FuncSig.class$("java.lang.Object");
                            i = 0;
                            while (i < match_vector.size()) {
                                match_classes = isConstructor ? ((Constructor)match_vector.elementAt(i)).getParameterTypes() : ((Method)match_vector.elementAt(i)).getParameterTypes();
                                Class<?> match_to = match_classes[j];
                                Class[] arg_classes = argv_classes_lookup[j];
                                if (arg_classes == null) {
                                    super_steps[i] = Integer.MAX_VALUE;
                                    total_steps[i] = Integer.MAX_VALUE;
                                } else {
                                    int super_step = 0;
                                    int total_step = 0;
                                    while (total_step < arg_classes.length) {
                                        Class c2 = arg_classes[total_step];
                                        if (c2 == null) {
                                            ++super_step;
                                        } else if (c2 == match_to) {
                                            super_steps[i] = super_step;
                                            total_steps[i] = total_step;
                                            if (super_step > min_super_step || c2.isInterface() && min_class != (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : FuncSig.class$("java.lang.Object")) && !min_class.isInterface()) break;
                                            min_class = c2;
                                            min_super_step = super_step;
                                            if (total_step >= min_total_step) break;
                                            min_total_step = total_step;
                                            break;
                                        }
                                        ++total_step;
                                    }
                                }
                                ++i;
                            }
                            i = match_vector.size() - 1;
                            while (i >= 0) {
                                if (super_steps[i] > min_super_step || super_steps[i] == min_super_step && total_steps[i] > min_total_step) {
                                    trim_matches[i] = true;
                                }
                                --i;
                            }
                            ++j;
                        }
                        i = match_vector.size() - 1;
                        while (i >= 0) {
                            if (trim_matches[i]) {
                                match_vector.removeElementAt(i);
                            }
                            --i;
                        }
                    }
                    if (match_vector.size() == 1) {
                        return match_vector.elementAt(0);
                    }
                    sb = new StringBuffer(100);
                    sb.append("ambiguous ");
                    if (isConstructor) {
                        sb.append("constructor");
                    } else {
                        sb.append("method");
                    }
                    sb.append(" signature");
                    if (match_vector.size() != 0) break block53;
                    sb.append(", could not choose between ");
                    funcs = isConstructor ? cls.getDeclaredConstructors() : FuncSig.getAllDeclaredMethods(cls);
                    i = 0;
                    while (i < funcs.length) {
                        block56: {
                            Class<?>[] paramTypes;
                            block55: {
                                block54: {
                                    if (!isConstructor) break block54;
                                    paramTypes = ((Constructor)funcs[i]).getParameterTypes();
                                    break block55;
                                }
                                Method method = (Method)funcs[i];
                                if (!methodName.equals(method.getName())) break block56;
                                foundSameName = true;
                                paramTypes = method.getParameterTypes();
                            }
                            if (paramTypes.length == argv_count) {
                                match_vector.addElement(funcs[i]);
                            }
                        }
                        ++i;
                    }
                    break block57;
                }
                sb.append(", assignable signatures are ");
            }
            TclObject siglist = TclList.newInstance();
            siglist.preserve();
            i = 0;
            while (i < match_vector.size()) {
                TclObject cur_siglist = TclList.newInstance();
                cur_siglist.preserve();
                if (isConstructor) {
                    Constructor con = (Constructor)match_vector.elementAt(i);
                    TclList.append((Interp)interp, (TclObject)cur_siglist, (TclObject)TclString.newInstance(con.getName()));
                    match_classes = con.getParameterTypes();
                } else {
                    Method meth = (Method)match_vector.elementAt(i);
                    TclList.append((Interp)interp, (TclObject)cur_siglist, (TclObject)TclString.newInstance(meth.getName()));
                    match_classes = meth.getParameterTypes();
                }
                j = 0;
                while (j < argv_count) {
                    Class<?> c = match_classes[j];
                    TclList.append((Interp)interp, (TclObject)cur_siglist, (TclObject)TclString.newInstance(JavaInfoCmd.getNameFromClass(c)));
                    ++j;
                }
                TclList.append((Interp)interp, (TclObject)siglist, (TclObject)cur_siglist);
                cur_siglist.release();
                ++i;
            }
            sb.append(siglist.toString());
            siglist.release();
            throw new TclException(interp, sb.toString());
        }
        if (isConstructor) {
            throw new TclException(interp, "can't find constructor with " + argv_count + " argument(s) for class \"" + cls.getName() + "\"");
        }
        if (!foundSameName) {
            throw new TclException(interp, "no such method \"" + signature + "\" in class " + cls.getName());
        }
        throw new TclException(interp, "can't find method \"" + signature + "\" with " + argv_count + " argument(s) for class \"" + cls.getName() + "\"");
    }

    private static void addInterfaces(Class cls, Vector v) {
        v.addElement(cls);
        Class<?>[] interfaces = cls.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            FuncSig.addInterfaces(interfaces[i], v);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    static Method[] getAllDeclaredMethods(Class cls) {
        void var1_1;
        void var3_3;
        Object[] methods = (Method[])allDeclMethTable.get(cls);
        if (methods != null) {
            return methods;
        }
        Vector vec = new Vector();
        Class c = cls;
        while (var3_3 != null) {
            FuncSig.mergeMethods(c, c.getDeclaredMethods(), vec);
            Class<?>[] interfaces = c.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                FuncSig.mergeMethods(interfaces[i], interfaces[i].getMethods(), vec);
                ++i;
            }
            c = c.isInterface() ? (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : FuncSig.class$("java.lang.Object")) : c.getSuperclass();
        }
        FuncSig.sortMethods(vec);
        methods = new Method[vec.size()];
        vec.copyInto(methods);
        allDeclMethTable.put(cls, methods);
        return var1_1;
    }

    private static void mergeMethods(Class c, Method[] methods, Vector vec) {
        int i = 0;
        while (i < methods.length) {
            boolean sameSigExists = false;
            Method newMeth = methods[i];
            int j = 0;
            while (j < vec.size()) {
                Method oldMeth = (Method)vec.elementAt(j);
                if (FuncSig.methodSigEqual(oldMeth, newMeth)) {
                    int oldRank;
                    sameSigExists = true;
                    Class<?> oldCls = oldMeth.getDeclaringClass();
                    int newRank = FuncSig.getMethodRank(c, newMeth);
                    if (newRank <= (oldRank = FuncSig.getMethodRank(oldCls, oldMeth))) break;
                    vec.setElementAt(newMeth, j);
                    break;
                }
                ++j;
            }
            if (!sameSigExists) {
                vec.addElement(newMeth);
            }
            ++i;
        }
    }

    private static boolean methodSigEqual(Method method1, Method method2) {
        Class<?>[] param2;
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        Class<?>[] param1 = method1.getParameterTypes();
        if (param1.length != (param2 = method2.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < param1.length) {
            if (param1[i] != param2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void sortMethods(Vector vec) {
        boolean debug = false;
        int insize = vec.size();
        int i = 1;
        while (i < vec.size()) {
            int c = i;
            Method cm = (Method)vec.elementAt(c);
            String cms = FuncSig.getMethodDescription(cm);
            int j = c - 1;
            while (j >= 0) {
                Method jm = (Method)vec.elementAt(j);
                String jms = FuncSig.getMethodDescription(jm);
                if (cms.compareTo(jms) > 0) break;
                vec.setElementAt(jm, c);
                vec.setElementAt(cm, j);
                c = j--;
            }
            ++i;
        }
        if (insize != vec.size()) {
            throw new RuntimeException("lost elements");
        }
    }

    private static String getMethodDescription(Method m) {
        StringBuffer sb = new StringBuffer(50);
        sb.append(m.getName());
        Class<?>[] params = m.getParameterTypes();
        sb.append('(');
        int i = 0;
        while (i < params.length) {
            sb.append(JavaInfoCmd.getNameFromClass(params[i]));
            if (i < params.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(") returns ");
        Class<?> ret = m.getReturnType();
        sb.append(JavaInfoCmd.getNameFromClass(ret));
        return sb.toString();
    }

    private static int getMethodRank(Class declaringCls, Method method) {
        int methMod = method.getModifiers();
        if (Modifier.isPrivate(methMod)) {
            return 0;
        }
        int clsMod = declaringCls.getModifiers();
        if (Modifier.isPublic(methMod) && Modifier.isPublic(clsMod)) {
            return 2;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    FuncSig(Class cls, PkgInvoker p, Object f) {
        this.targetCls = cls;
        this.pkgInvoker = p;
        this.func = f;
    }
}

