/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import tcl.lang.AssocData;
import tcl.lang.BackSlashResult;
import tcl.lang.BgErrorMgr;
import tcl.lang.BlendExtension;
import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.DebugInfo;
import tcl.lang.Env;
import tcl.lang.Expression;
import tcl.lang.Extension;
import tcl.lang.FileUtil;
import tcl.lang.Notifier;
import tcl.lang.PackageCmd;
import tcl.lang.Parser;
import tcl.lang.Procedure;
import tcl.lang.ReflectObject;
import tcl.lang.RegexpCmd;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;
import tcl.lang.Util;
import tcl.lang.VarTrace;

public class Interp {
    Hashtable reflectIDTable;
    Hashtable reflectObjTable;
    long reflectObjCount;
    private Thread primaryThread;
    private static final int MAX_ERR_LENGTH = 200;
    static final String TCL_VERSION = "8.0";
    static final String TCL_PATCH_LEVEL = "8.0";
    protected int cmdCount;
    Hashtable cmdTable = new Hashtable();
    Hashtable interpChanTable;
    private Notifier notifier;
    Hashtable assocDataTab;
    private File workingDir;
    CallFrame frame;
    CallFrame varFrame = this.frame = this.newCallFrame();
    CallFrame globalFrame = this.frame;
    String scriptFile = "";
    int nestLevel = 0;
    int maxNestingDepth = 1000;
    int evalFlags;
    int flags;
    int termOffset;
    Expression expr = new Expression();
    int noEval = 0;
    boolean randSeedInit;
    long randSeed;
    String errorInfo;
    String errorCode;
    protected int returnCode;
    protected boolean deleted;
    protected boolean errInProgress;
    protected boolean errAlreadyLogged;
    protected boolean errCodeSet;
    int errorLine;
    private TclObject m_result;
    private TclObject m_nullResult;
    Hashtable packageTable;
    String packageUnknown;
    TclObject[][][] parserObjv;
    int[] parserObjvUsed;
    TclToken[] parserTokens;
    int parserTokensUsed;
    protected DebugInfo dbg;
    static /* synthetic */ Class class$java$lang$Class;

    public Interp() {
        this.workingDir = new File(Util.tryGetSystemProperty("user.dir", "."));
        this.primaryThread = Thread.currentThread();
        this.notifier = Notifier.getNotifierForThread(this.primaryThread);
        this.notifier.preserve();
        this.assocDataTab = null;
        this.randSeedInit = false;
        ReflectObject.init((Interp)this);
        this.errorLine = 0;
        this.deleted = false;
        this.errInProgress = false;
        this.errAlreadyLogged = false;
        this.errCodeSet = false;
        this.returnCode = 0;
        this.dbg = this.initDebugInfo();
        this.packageTable = new Hashtable();
        this.packageUnknown = null;
        Parser.init(this);
        TclParse.init(this);
        this.m_nullResult = TclString.newInstance((String)"");
        this.m_nullResult.preserve();
        this.m_result = this.m_nullResult;
        this.interpChanTable = TclIO.getInterpChanTable(this);
        Util.setupPrecisionTrace(this);
        this.createCommands();
        try {
            this.setVar("tcl_platform", "platform", "java", 1);
            this.setVar("tcl_platform", "javaVersion", Util.tryGetSystemProperty("java.version", "?"), 1);
            this.setVar("tcl_platform", "byteOrder", "bigEndian", 1);
            this.setVar("tcl_platform", "os", Util.tryGetSystemProperty("os.name", "?"), 1);
            this.setVar("tcl_platform", "osVersion", Util.tryGetSystemProperty("os.version", "?"), 1);
            this.setVar("tcl_platform", "machine", Util.tryGetSystemProperty("os.arch", "?"), 1);
            this.setVar("tcl_version", "8.0", 1);
            this.setVar("tcl_patchLevel", "8.0", 1);
            this.setVar("tcl_library", "resource:/tcl/lang/library", 1);
            if (Util.isWindows()) {
                this.setVar("tcl_platform", "host_platform", "windows", 1);
            } else if (Util.isMac()) {
                this.setVar("tcl_platform", "host_platform", "macintosh", 1);
            } else {
                this.setVar("tcl_platform", "host_platform", "unix", 1);
            }
            Env.initialize(this);
            this.pkgProvide("Tcl", "8.0");
            this.evalResource("/tcl/lang/library/init.tcl");
        }
        catch (TclException e) {
            System.out.println(this.getResult());
            e.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
    }

    public void dispose() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        if (this.nestLevel > 0) {
            throw new TclRuntimeError("dispose() called with active evals");
        }
        if (this.notifier != null) {
            this.notifier.release();
            this.notifier = null;
        }
        TclObject errorInfoObj = null;
        TclObject errorCodeObj = null;
        try {
            errorInfoObj = this.getVar("errorInfo", null, 2049);
            if (errorInfoObj != null) {
                errorInfoObj.preserve();
            }
            if ((errorCodeObj = this.getVar("errorCode", null, 2049)) != null) {
                errorCodeObj.preserve();
            }
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
        this.globalFrame.dispose();
        this.varFrame = this.frame = this.newCallFrame();
        this.globalFrame = this.frame;
        try {
            if (errorInfoObj != null) {
                this.setVar("errorInfo", null, errorInfoObj, 1);
                errorInfoObj.release();
            }
            if (errorCodeObj != null) {
                this.setVar("errorCode", null, errorCodeObj, 1);
                errorCodeObj.release();
            }
        }
        catch (TclException tclException) {}
        if (this.cmdTable != null) {
            Enumeration e = this.cmdTable.keys();
            while (e.hasMoreElements()) {
                String cmdName = (String)e.nextElement();
                this.deleteCommand(cmdName);
            }
            this.cmdTable = null;
        }
        this.expr = null;
        while (this.assocDataTab != null) {
            Hashtable table = this.assocDataTab;
            this.assocDataTab = null;
            Enumeration e = table.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                AssocData data = (AssocData)table.get(key);
                data.disposeAssocData(this);
                table.remove(key);
            }
        }
        this.globalFrame.dispose();
        this.frame = null;
        this.varFrame = null;
        this.globalFrame = null;
        this.resetResult();
    }

    protected void finalize() {
        this.dispose();
    }

    protected void createCommands() {
        Extension.loadOnDemand((Interp)this, (String)"after", (String)"tcl.lang.AfterCmd");
        Extension.loadOnDemand((Interp)this, (String)"append", (String)"tcl.lang.AppendCmd");
        Extension.loadOnDemand((Interp)this, (String)"array", (String)"tcl.lang.ArrayCmd");
        Extension.loadOnDemand((Interp)this, (String)"break", (String)"tcl.lang.BreakCmd");
        Extension.loadOnDemand((Interp)this, (String)"case", (String)"tcl.lang.CaseCmd");
        Extension.loadOnDemand((Interp)this, (String)"catch", (String)"tcl.lang.CatchCmd");
        Extension.loadOnDemand((Interp)this, (String)"cd", (String)"tcl.lang.CdCmd");
        Extension.loadOnDemand((Interp)this, (String)"close", (String)"tcl.lang.CloseCmd");
        Extension.loadOnDemand((Interp)this, (String)"continue", (String)"tcl.lang.ContinueCmd");
        Extension.loadOnDemand((Interp)this, (String)"concat", (String)"tcl.lang.ConcatCmd");
        Extension.loadOnDemand((Interp)this, (String)"eof", (String)"tcl.lang.EofCmd");
        Extension.loadOnDemand((Interp)this, (String)"eval", (String)"tcl.lang.EvalCmd");
        Extension.loadOnDemand((Interp)this, (String)"error", (String)"tcl.lang.ErrorCmd");
        if (!Util.isMac()) {
            Extension.loadOnDemand((Interp)this, (String)"exec", (String)"tcl.lang.ExecCmd");
        }
        Extension.loadOnDemand((Interp)this, (String)"exit", (String)"tcl.lang.ExitCmd");
        Extension.loadOnDemand((Interp)this, (String)"expr", (String)"tcl.lang.ExprCmd");
        Extension.loadOnDemand((Interp)this, (String)"fblocked", (String)"tcl.lang.FblockedCmd");
        Extension.loadOnDemand((Interp)this, (String)"fconfigure", (String)"tcl.lang.FconfigureCmd");
        Extension.loadOnDemand((Interp)this, (String)"file", (String)"tcl.lang.FileCmd");
        Extension.loadOnDemand((Interp)this, (String)"flush", (String)"tcl.lang.FlushCmd");
        Extension.loadOnDemand((Interp)this, (String)"for", (String)"tcl.lang.ForCmd");
        Extension.loadOnDemand((Interp)this, (String)"foreach", (String)"tcl.lang.ForeachCmd");
        Extension.loadOnDemand((Interp)this, (String)"format", (String)"tcl.lang.FormatCmd");
        Extension.loadOnDemand((Interp)this, (String)"gets", (String)"tcl.lang.GetsCmd");
        Extension.loadOnDemand((Interp)this, (String)"global", (String)"tcl.lang.GlobalCmd");
        Extension.loadOnDemand((Interp)this, (String)"glob", (String)"tcl.lang.GlobCmd");
        Extension.loadOnDemand((Interp)this, (String)"if", (String)"tcl.lang.IfCmd");
        Extension.loadOnDemand((Interp)this, (String)"incr", (String)"tcl.lang.IncrCmd");
        Extension.loadOnDemand((Interp)this, (String)"info", (String)"tcl.lang.InfoCmd");
        Extension.loadOnDemand((Interp)this, (String)"list", (String)"tcl.lang.ListCmd");
        Extension.loadOnDemand((Interp)this, (String)"join", (String)"tcl.lang.JoinCmd");
        Extension.loadOnDemand((Interp)this, (String)"lappend", (String)"tcl.lang.LappendCmd");
        Extension.loadOnDemand((Interp)this, (String)"lindex", (String)"tcl.lang.LindexCmd");
        Extension.loadOnDemand((Interp)this, (String)"linsert", (String)"tcl.lang.LinsertCmd");
        Extension.loadOnDemand((Interp)this, (String)"llength", (String)"tcl.lang.LlengthCmd");
        Extension.loadOnDemand((Interp)this, (String)"lrange", (String)"tcl.lang.LrangeCmd");
        Extension.loadOnDemand((Interp)this, (String)"lreplace", (String)"tcl.lang.LreplaceCmd");
        Extension.loadOnDemand((Interp)this, (String)"lsearch", (String)"tcl.lang.LsearchCmd");
        Extension.loadOnDemand((Interp)this, (String)"lsort", (String)"tcl.lang.LsortCmd");
        Extension.loadOnDemand((Interp)this, (String)"namespace", (String)"tcl.lang.NamespaceCmd");
        Extension.loadOnDemand((Interp)this, (String)"open", (String)"tcl.lang.OpenCmd");
        Extension.loadOnDemand((Interp)this, (String)"package", (String)"tcl.lang.PackageCmd");
        Extension.loadOnDemand((Interp)this, (String)"proc", (String)"tcl.lang.ProcCmd");
        Extension.loadOnDemand((Interp)this, (String)"puts", (String)"tcl.lang.PutsCmd");
        Extension.loadOnDemand((Interp)this, (String)"pwd", (String)"tcl.lang.PwdCmd");
        Extension.loadOnDemand((Interp)this, (String)"read", (String)"tcl.lang.ReadCmd");
        Extension.loadOnDemand((Interp)this, (String)"regsub", (String)"tcl.lang.RegsubCmd");
        Extension.loadOnDemand((Interp)this, (String)"rename", (String)"tcl.lang.RenameCmd");
        Extension.loadOnDemand((Interp)this, (String)"return", (String)"tcl.lang.ReturnCmd");
        Extension.loadOnDemand((Interp)this, (String)"scan", (String)"tcl.lang.ScanCmd");
        Extension.loadOnDemand((Interp)this, (String)"seek", (String)"tcl.lang.SeekCmd");
        Extension.loadOnDemand((Interp)this, (String)"set", (String)"tcl.lang.SetCmd");
        Extension.loadOnDemand((Interp)this, (String)"socket", (String)"tcl.lang.SocketCmd");
        Extension.loadOnDemand((Interp)this, (String)"source", (String)"tcl.lang.SourceCmd");
        Extension.loadOnDemand((Interp)this, (String)"split", (String)"tcl.lang.SplitCmd");
        Extension.loadOnDemand((Interp)this, (String)"string", (String)"tcl.lang.StringCmd");
        Extension.loadOnDemand((Interp)this, (String)"subst", (String)"tcl.lang.SubstCmd");
        Extension.loadOnDemand((Interp)this, (String)"switch", (String)"tcl.lang.SwitchCmd");
        Extension.loadOnDemand((Interp)this, (String)"tell", (String)"tcl.lang.TellCmd");
        Extension.loadOnDemand((Interp)this, (String)"time", (String)"tcl.lang.TimeCmd");
        Extension.loadOnDemand((Interp)this, (String)"trace", (String)"tcl.lang.TraceCmd");
        Extension.loadOnDemand((Interp)this, (String)"unset", (String)"tcl.lang.UnsetCmd");
        Extension.loadOnDemand((Interp)this, (String)"update", (String)"tcl.lang.UpdateCmd");
        Extension.loadOnDemand((Interp)this, (String)"uplevel", (String)"tcl.lang.UplevelCmd");
        Extension.loadOnDemand((Interp)this, (String)"upvar", (String)"tcl.lang.UpvarCmd");
        Extension.loadOnDemand((Interp)this, (String)"vwait", (String)"tcl.lang.VwaitCmd");
        Extension.loadOnDemand((Interp)this, (String)"while", (String)"tcl.lang.WhileCmd");
        try {
            new BlendExtension().init(this);
            RegexpCmd.init(this);
        }
        catch (TclException e) {
            System.out.println(this.getResult());
            e.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
    }

    public void setAssocData(String name, AssocData data) {
        if (this.assocDataTab == null) {
            this.assocDataTab = new Hashtable();
        }
        this.assocDataTab.put(name, data);
    }

    public void deleteAssocData(String name) {
        if (this.assocDataTab == null) {
            return;
        }
        this.assocDataTab.remove(name);
    }

    public AssocData getAssocData(String name) {
        if (this.assocDataTab == null) {
            return null;
        }
        return (AssocData)this.assocDataTab.get(name);
    }

    public void backgroundError() {
        BgErrorMgr mgr = (BgErrorMgr)this.getAssocData("tclBgError");
        if (mgr == null) {
            mgr = new BgErrorMgr(this);
            this.setAssocData("tclBgError", mgr);
        }
        mgr.addBgError();
    }

    final TclObject setVar(TclObject nameObj, TclObject value, int flags) throws TclException {
        return this.varFrame.setVar(nameObj, value, flags);
    }

    public final TclObject setVar(String name, TclObject value, int flags) throws TclException {
        return this.varFrame.setVar(name, value, flags);
    }

    public final TclObject setVar(String name1, String name2, TclObject value, int flags) throws TclException {
        return this.varFrame.setVar(name1, name2, value, flags);
    }

    final void setVar(String name, String strValue, int flags) throws TclException {
        this.varFrame.setVar(name, TclString.newInstance((String)strValue), flags);
    }

    final void setVar(String name1, String name2, String strValue, int flags) throws TclException {
        this.varFrame.setVar(name1, name2, TclString.newInstance((String)strValue), flags);
    }

    final TclObject getVar(TclObject nameObj, int flags) throws TclException {
        return this.varFrame.getVar(nameObj, flags);
    }

    public final TclObject getVar(String name, int flags) throws TclException {
        return this.varFrame.getVar(name, flags);
    }

    public final TclObject getVar(String name1, String name2, int flags) throws TclException {
        return this.varFrame.getVar(name1, name2, flags);
    }

    final void unsetVar(TclObject nameObj, int flags) throws TclException {
        this.varFrame.unsetVar(nameObj, flags);
    }

    public final void unsetVar(String name, int flags) throws TclException {
        this.varFrame.unsetVar(name, flags);
    }

    public final void unsetVar(String name1, String name2, int flags) throws TclException {
        this.varFrame.unsetVar(name1, name2, flags);
    }

    void traceVar(TclObject nameObj, VarTrace trace, int flags) throws TclException {
        this.varFrame.traceVar(nameObj, trace, flags);
    }

    public void traceVar(String name, VarTrace trace, int flags) throws TclException {
        this.varFrame.traceVar(name, trace, flags);
    }

    public void traceVar(String part1, String part2, VarTrace trace, int flags) throws TclException {
        this.varFrame.traceVar(part1, part2, trace, flags);
    }

    void untraceVar(TclObject nameObj, VarTrace trace, int flags) {
        this.varFrame.untraceVar(nameObj, trace, flags);
    }

    public void untraceVar(String name, VarTrace trace, int flags) {
        this.varFrame.untraceVar(name, trace, flags);
    }

    public void untraceVar(String part1, String part2, VarTrace trace, int flags) {
        this.varFrame.untraceVar(part1, part2, trace, flags);
    }

    public void createCommand(String cmdName, Command cmd) {
        Command oldCmd = (Command)this.cmdTable.get(cmdName);
        if (oldCmd != null && oldCmd instanceof CommandWithDispose) {
            ((CommandWithDispose)oldCmd).disposeCmd();
        }
        this.cmdTable.put(cmdName, cmd);
    }

    public int deleteCommand(String cmdName) {
        Command cmd = (Command)this.cmdTable.get(cmdName);
        if (cmd == null) {
            return -1;
        }
        this.cmdTable.remove(cmdName);
        if (cmd instanceof CommandWithDispose) {
            ((CommandWithDispose)cmd).disposeCmd();
        }
        return 0;
    }

    public Command getCommand(String name) {
        return (Command)this.cmdTable.get(name);
    }

    public static boolean commandComplete(String string) {
        return Parser.commandComplete(string, string.length());
    }

    public final TclObject getResult() {
        return this.m_result;
    }

    public final void setResult(TclObject r) {
        if (r == null) {
            throw new NullPointerException("Interp.setResult() called with null TclObject argument.");
        }
        if (this.m_result != this.m_nullResult) {
            this.m_result.release();
        }
        this.m_result = r;
        this.m_result.preserve();
    }

    public final void setResult(String r) {
        if (r == null) {
            this.resetResult();
        } else {
            this.setResult(TclString.newInstance((String)r));
        }
    }

    public final void setResult(int r) {
        this.setResult(TclInteger.newInstance((int)r));
    }

    public final void setResult(double r) {
        this.setResult(TclDouble.newInstance((double)r));
    }

    public final void setResult(boolean r) {
        this.setResult(TclBoolean.newInstance((boolean)r));
    }

    public final void resetResult() {
        if (this.m_result != this.m_nullResult) {
            this.m_result.release();
            this.m_result = this.m_nullResult;
        }
        this.errAlreadyLogged = false;
        this.errInProgress = false;
        this.errCodeSet = false;
    }

    void appendElement(String string) throws TclException {
        TclObject result = this.getResult();
        result.preserve();
        result = result.takeExclusive();
        TclList.append(this, result, TclString.newInstance((String)string));
        this.setResult(result.toString());
        result.release();
    }

    public void eval(String string, int flags) throws TclException {
        CharPointer script = new CharPointer(string);
        Parser.eval2(this, script.array, script.index, script.length(), flags);
    }

    public void eval(String script) throws TclException {
        this.eval(script, 0);
    }

    public void eval(TclObject tobj, int flags) throws TclException {
        this.eval(tobj.toString(), flags);
    }

    public void evalFile(String s) throws TclException {
        String fileContent = this.readScriptFromFile(s);
        if (fileContent == null) {
            throw new TclException(this, "couldn't read file \"" + s + "\"");
        }
        String oldScript = this.scriptFile;
        this.scriptFile = s;
        try {
            this.pushDebugStack(s, 1);
            this.eval(fileContent, 0);
        }
        finally {
            Object var5_4 = null;
            this.scriptFile = oldScript;
            this.popDebugStack();
        }
    }

    void evalURL(URL context, String s) throws TclException {
        String fileContent = this.readScriptFromURL(context, s);
        if (fileContent == null) {
            throw new TclException(this, "cannot read URL \"" + s + "\"");
        }
        String oldScript = this.scriptFile;
        this.scriptFile = s;
        try {
            this.eval(fileContent, 0);
        }
        finally {
            Object var6_5 = null;
            this.scriptFile = oldScript;
        }
    }

    private String readScriptFromFile(String s) {
        FileInputStream fs;
        try {
            File sourceFile = FileUtil.getNewFileObj(this, s);
            fs = new FileInputStream(sourceFile);
        }
        catch (TclException tclException) {
            this.resetResult();
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        try {
            try {
                byte[] charArray = new byte[fs.available()];
                fs.read(charArray);
                String string = new String(charArray);
                Object var6_7 = null;
                this.closeInputStream(fs);
                return string;
            }
            catch (IOException iOException) {
                String string = null;
                Object var6_8 = null;
                this.closeInputStream(fs);
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.closeInputStream(fs);
            throw throwable;
        }
    }

    private String readScriptFromURL(URL context, String s) {
        URL url;
        Object content = null;
        try {
            url = new URL(context, s);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        try {
            content = url.getContent();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        if (content instanceof String) {
            return (String)content;
        }
        if (content instanceof InputStream) {
            InputStream fs = (InputStream)content;
            try {
                try {
                    byte[] charArray = new byte[fs.available()];
                    fs.read(charArray);
                    String string = new String(charArray);
                    Object var8_9 = null;
                    this.closeInputStream(fs);
                    return string;
                }
                catch (IOException iOException) {
                    String string = null;
                    Object var8_10 = null;
                    this.closeInputStream(fs);
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                this.closeInputStream(fs);
                throw throwable;
            }
        }
        return null;
    }

    private void closeInputStream(InputStream fs) {
        try {
            fs.close();
        }
        catch (IOException iOException) {}
    }

    void evalResource(String resName) throws TclException {
        InputStream stream = (class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = Interp.class$("java.lang.Class"))).getResourceAsStream(resName);
        if (stream == null) {
            throw new TclException(this, "cannot read resource \"" + resName + "\"");
        }
        try {
            try {
                if ((System.getProperty("java.version").equals("1.2beta4") || System.getProperty("java.version").equals("1.2fcs")) && stream.getClass().getName().equals("java.util.zip.ZipFile$1")) {
                    int used = 0;
                    int size = stream.available() * 4;
                    byte[] byteArray = new byte[size];
                    int cur = stream.read();
                    while (cur != -1) {
                        if (used >= size) {
                            byte[] oldArray = byteArray;
                            int new_size = size * 2;
                            byteArray = new byte[new_size];
                            System.arraycopy(oldArray, 0, byteArray, 0, used);
                            oldArray = null;
                            size = new_size;
                        }
                        byteArray[used++] = (byte)cur;
                        cur = stream.read();
                    }
                    this.eval(new String(byteArray, 0, used), 0);
                } else {
                    int num = stream.available();
                    byte[] byteArray = new byte[num];
                    int offset = 0;
                    while (num > 0) {
                        int readLen = stream.read(byteArray, offset, num);
                        offset += readLen;
                        num -= readLen;
                    }
                    this.eval(new String(byteArray), 0);
                }
            }
            catch (IOException iOException) {
                Object var4_13 = null;
                this.closeInputStream(stream);
                return;
            }
            Object var4_14 = null;
            this.closeInputStream(stream);
        }
        catch (Throwable throwable) {
            Object var4_15 = null;
            this.closeInputStream(stream);
            throw throwable;
        }
    }

    static BackSlashResult backslash(String s, int i, int len) {
        CharPointer script = new CharPointer(s.substring(0, len));
        script.index = i;
        return Parser.backslash(script.array, script.index);
    }

    public void setErrorCode(TclObject code) {
        try {
            this.setVar("errorCode", null, code, 1);
            this.errCodeSet = true;
        }
        catch (TclException tclException) {}
    }

    public void addErrorInfo(String message) {
        boolean flags = false;
        if (!this.errInProgress) {
            this.errInProgress = true;
            try {
                this.setVar("errorInfo", null, this.getResult().toString(), 1);
            }
            catch (TclException tclException) {}
            if (!this.errCodeSet) {
                try {
                    this.setVar("errorCode", null, "NONE", 1);
                }
                catch (TclException tclException) {}
            }
        }
        try {
            this.setVar("errorInfo", null, message, 5);
        }
        catch (TclException tclException) {}
    }

    protected int updateReturnInfo() {
        int code = this.returnCode;
        this.returnCode = 0;
        if (code == 1) {
            try {
                this.setVar("errorCode", null, this.errorCode != null ? this.errorCode : "NONE", 1);
            }
            catch (TclException tclException) {}
            this.errCodeSet = true;
            if (this.errorInfo != null) {
                try {
                    this.setVar("errorInfo", null, this.errorInfo, 1);
                }
                catch (TclException tclException) {}
                this.errInProgress = true;
            }
        }
        return code;
    }

    protected CallFrame newCallFrame(Procedure proc, TclObject[] argv) throws TclException {
        return new CallFrame(this, proc, argv);
    }

    protected CallFrame newCallFrame() {
        return new CallFrame(this);
    }

    File getWorkingDir() {
        if (this.workingDir == null) {
            try {
                String dirName = this.getVar("env", "HOME", 0).toString();
                this.workingDir = FileUtil.getNewFileObj(this, dirName);
            }
            catch (TclException tclException) {
                this.resetResult();
            }
            this.workingDir = new File(Util.tryGetSystemProperty("user.home", "."));
        }
        return this.workingDir;
    }

    void setWorkingDir(String dirName) throws TclException {
        File dirObj = FileUtil.getNewFileObj(this, dirName);
        try {
            dirObj = new File(dirObj.getCanonicalPath());
        }
        catch (IOException iOException) {}
        if (!dirObj.isDirectory()) {
            throw new TclException(this, "couldn't change working directory to \"" + dirObj.getName() + "\": no such file or directory");
        }
        this.workingDir = dirObj;
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    public final void pkgProvide(String name, String version) throws TclException {
        PackageCmd.pkgProvide(this, name, version);
    }

    public final String pkgRequire(String pkgname, String version, boolean exact) throws TclException {
        return PackageCmd.pkgRequire(this, pkgname, version, exact);
    }

    protected DebugInfo initDebugInfo() {
        return new DebugInfo(null, 1);
    }

    void pushDebugStack(String fileName, int lineNumber) {
    }

    void popDebugStack() throws TclRuntimeError {
    }

    String getScriptFile() {
        return this.dbg.fileName;
    }

    int getArgLineNumber(int index) {
        return 0;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

