/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class IncrCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int increment;
        int oldValue;
        if (argv.length != 2 && argv.length != 3) {
            throw new TclNumArgsException(interp, 1, argv, "varName ?increment?");
        }
        TclObject tobj = interp.getVar(argv[1], 0);
        try {
            oldValue = TclInteger.get((Interp)interp, (TclObject)tobj);
        }
        catch (TclException e) {
            interp.addErrorInfo("\n    (reading value of variable to increment)");
            throw e;
        }
        if (argv.length == 2) {
            increment = 1;
        } else {
            try {
                increment = TclInteger.get((Interp)interp, (TclObject)argv[2]);
            }
            catch (TclException e) {
                interp.addErrorInfo("\n    (reading increment)");
                throw e;
            }
        }
        TclObject newValObj = TclInteger.newInstance((int)(oldValue + increment));
        interp.setVar(argv[1], newValObj, 0);
        interp.setResult(newValObj);
    }

    IncrCmd() {
    }
}

