#!/bin/sh

# Link one dynamically loadable extension (an object file); or
# combine several object files into one dynamically loadable extension
# and resolve against libraries.
#
# Arguments are the output file and one or more object files and libraries.

if [ $# = 0 ]; then
    echo Usage: "$0: output-file object-files [libraries]"
    exit 1
fi

output=$1
shift

ld -r -o $output @obj_ldflags@ @xflag@ $*
chmod 644 $output
