#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************



CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine compte (X, Y, outcd)


******************************************************************
*                                                                *
*  Subroutine Compute_outcode                                    *
*                                                                *
*     This routine computes the bit-wise position code, used     *
*     by the clipping routine. The routine uses a set of 'ifs'   *
*     to see if a point is less than or greater than the         *
*     window's minimum or maximum X & Y points.                  *
*                                                                *
*                       1000                                     *
*               -------------------                              *
*               |  Window:        |                              *
*               |                 |                              *
*         0001  |       0000      | 0010                         *
*               |                 |                              *
*               |                 |                              *
*               -------------------                              *
*                       0100              ----                   *
*                                   --->  |P1|  <---             *
*                                         ----                   *
*                                                                *
*         If 'P1' was the XY point in question, it would         *
*         have a position or outcode of (0110). The point        *
*         is less than the window's Ymin and greater than        *
*         the window's Xmax.                                     *
*                                                                *
******************************************************************


        Real           WXmax, WXmin, WYmax, WYmin
        Common /windw/ WXmax, WXmin, WYmax, WYmin
        Save   /windw/

        Real    X, Y
        Integer outcd


*       (* Set the initial outcd, or position number, to 0000.
*          Located within the window. *)
        outcd = 0000

*       (* Update the code position using the following position
*          codes. *)
        IF (Y .GT. WYmax) outcd = outcd + 1000
        IF (Y .LT. WYmin) outcd = outcd + 0100
        IF (X .GT. WXmax) outcd = outcd + 0010
        IF (X .LT. WXmin) outcd = outcd + 0001

        RETURN
        END
