/* Maarten Boekhold (boekhold@cindy.et.tudelft.nl) oktober 1995 */

#include <sys/types.h>

/*
 * routine to change little endian long to host long
 */
long get_long(u_char *cp)
{
        long ret;

        ret = *cp++;
        ret += ((*cp++)<<8);
        ret += ((*cp++)<<16);
        ret += ((*cp++)<<24);

        return ret;
}

void put_long(u_char *cp, long lval)
{
        *cp++ = lval & 0xff;
        *cp++ = (lval >> 8) & 0xff;
        *cp++ = (lval >> 16) & 0xff;
        *cp++ = (lval >> 24) & 0xff;
}

/*
 * routine to change little endian short to host short
 */
short get_short(u_char *cp)
{
        short ret;

        ret = *cp++;
        ret += ((*cp++)<<8);

        return ret;
}

void put_short(u_char *cp, short sval)
{
        *cp++ = sval & 0xff;
        *cp++ = (sval >> 8) & 0xff;
}
