.bp
.SH
.ce
ANNOTATIONS
.SH
Overview
.LP
The MTV data format allows plot annotations to be attached to sets of
data.  Annotations are specified in the data-file or data-stream as strings
beginning with the "@" character.  
Multiple annotations can be attached in
each dataset.   Furthermore, each annotation can be specified in data (world)
coordinates or in plot coordinates.  
.LP
The format for annotations is as follows:
.KS
.TS
box, tab(|), center;
cfB s s s s
lfI lfI lfI lfI lfI
lfI lfI lfI lfI lfI
l l l l l.
MTVDAT Annotation Types 
_
First|Keyword|Arguments|
Character|||
=
@|rectangle|x1=<> y1=<> [z1=<>] x2=<> y2=<> [z2=<>]|<annotation-properties>
@|line     |x1=<> y1=<> [z1=<>] x2=<> y2=<> [z2=<>]|<annotation-properties>     
@|arrow    |x1=<> y1=<> [z1=<>] x2=<> y2=<> [z2=<>]|<annotation-properties>    
@|point    |x1=<> y1=<> [z1=<>]|<annotation-properties>
@|text     |x1=<> y1=<> [z1=<>] label=<>|<annotation-properties>
.TE
.KE
.LP
.so annot_pr.tms
.bp
.SH
Resource Specification
.RS
.SH
.ul
Lines
.IP "\fBlinelabel\fP" 12
Specifies a label (legend) to be placed to the left of the plot.
For contour-curves, the label is placed at various locations 
on the curve itself.
Default is a blank string.
.IP "\fBlinewidth\fP" 12
Specifies the width of the line to be used in drawing the curve.
Default is 1.
.IP "\fBlinetype\fP" 12
Specifies the type of line-pattern to be used in drawing the curve.
Line-patterns include solid lines, dashed lines and dotted lines.
See Curve Property Table for details.  Default is 1 (solid line).
.IP "\fBlinecolor\fP" 12
Specifies the color to be used in drawing the curve.
Colors are approximated by gray-scales for black-and-white Postscript
plots.
Default is 1 (yellow). 
.SH
.ul
Markers
.IP "\fBmarkersize\fP" 12
Specifies the size of markers on the curve.  The default value is 1, which
is the smallest size.
.IP "\fBmarkertype\fP" 12
Specifies the markertype to be used in drawing the points on the curve.
The default value is 0, in which case markers are not plotted.
.IP "\fBmarkercolor\fP"
Specifies the color to be used in drawing the markers.
Colors are approximated by gray-scales for black-and-white Postscript
plots.
Default is 1 (yellow).
.SH
.ul
Fills
.IP "\fBfilltype\fP" 12
Specifies the filltype to be used in drawing the curve. 
The default is 0, in which case only the outline of the curve is drawn.
.br
Note: The \fIfilltype\fP is ignored if the Dataset Resource \fBapplyfill\fP
is \fBFalse\fP.
.IP "\fBfillcolor\fP" 12
Specifies the color to be used in the fill-pattern.
Colors are approximated by gray-scales for black-and-white Postscript
plots.
Default is 1 (yellow).
.SH
.ul
Miscellaneous
.IP "\fBabsolute\fP" 12
Specifies if the position of the annotation is specified in world
coordinates or in plot coordinates.  Defaults to \fBFalse\fP, in which case
world coordinates are assumed.  If \fIabsolute=True\fP, then the annotations
are specified by their position on a page - the coordinates must be given
such that \fI0 < x <1\fP and \fI0 < y < 1\fP; 
the actual position of the annotation is obtained
from \fIx \(mu width\fP,\fIy \(mu height\fP, where \fIwidth\fP and
\fIheight\fP are the dimensions of the page/plot.
This latter scheme however has the disadvantage that the position of an
annotation in an X11 plot is slightly different from that on a Postscript
plot.
.IP "\fBclip\fP" 12
Specifies if the annotation is to be clipped against the plot boundaries.
Defaults to \fBTrue\fP, in which case, the annotation is not drawn if the
point(s) to which it is attached fall outside the plot boundaries.
.bp
.SH
Examples
.LP
The following shows an example file containing a CURVE2D dataset containing
one curve and several annotations.
The resultant plot is appended to the end of this appendix.
.sp
.ps 9
.vs 10
.nr PS 9
.nr VS 10
.sp
.nf
.lg 0
.cs 1 20
.so annot.mtv
.cs 1
.lg 1
.fi
.sp 1
\l'7.0i'
.nr PS 11
.nr VS 13
