# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Iterable, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from ..._serialization import Serializer
from .._vendor import KeyVaultClientMixinABC, _convert_request, _format_url_section

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_get_certificates_request(
    *, maxresults: Optional[int] = None, include_pending: Optional[bool] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates")

    # Construct parameters
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int", maximum=25, minimum=1)
    if include_pending is not None:
        _params["includePending"] = _SERIALIZER.query("include_pending", include_pending, "bool")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_certificate_request(certificate_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/{certificate-name}")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_set_certificate_contacts_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/contacts")

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_certificate_contacts_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/contacts")

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_certificate_contacts_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/contacts")

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_certificate_issuers_request(*, maxresults: Optional[int] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/issuers")

    # Construct parameters
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int", maximum=25, minimum=1)
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_set_certificate_issuer_request(issuer_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/issuers/{issuer-name}")
    path_format_arguments = {
        "issuer-name": _SERIALIZER.url("issuer_name", issuer_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_update_certificate_issuer_request(issuer_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/issuers/{issuer-name}")
    path_format_arguments = {
        "issuer-name": _SERIALIZER.url("issuer_name", issuer_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_certificate_issuer_request(issuer_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/issuers/{issuer-name}")
    path_format_arguments = {
        "issuer-name": _SERIALIZER.url("issuer_name", issuer_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_certificate_issuer_request(issuer_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/issuers/{issuer-name}")
    path_format_arguments = {
        "issuer-name": _SERIALIZER.url("issuer_name", issuer_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_create_certificate_request(certificate_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/{certificate-name}/create")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str", pattern=r"^[0-9a-zA-Z-]+$"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_import_certificate_request(certificate_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/{certificate-name}/import")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str", pattern=r"^[0-9a-zA-Z-]+$"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_certificate_versions_request(
    certificate_name: str, *, maxresults: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/{certificate-name}/versions")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int", maximum=25, minimum=1)
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_certificate_policy_request(certificate_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/{certificate-name}/policy")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_update_certificate_policy_request(certificate_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/{certificate-name}/policy")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_update_certificate_request(certificate_name: str, certificate_version: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/{certificate-name}/{certificate-version}")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
        "certificate-version": _SERIALIZER.url("certificate_version", certificate_version, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_certificate_request(certificate_name: str, certificate_version: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/{certificate-name}/{certificate-version}")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
        "certificate-version": _SERIALIZER.url("certificate_version", certificate_version, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_update_certificate_operation_request(certificate_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/{certificate-name}/pending")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_certificate_operation_request(certificate_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/{certificate-name}/pending")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_certificate_operation_request(certificate_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/{certificate-name}/pending")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_merge_certificate_request(certificate_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/{certificate-name}/pending/merge")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_backup_certificate_request(certificate_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/{certificate-name}/backup")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_restore_certificate_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/certificates/restore")

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_deleted_certificates_request(
    *, maxresults: Optional[int] = None, include_pending: Optional[bool] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/deletedcertificates")

    # Construct parameters
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int", maximum=25, minimum=1)
    if include_pending is not None:
        _params["includePending"] = _SERIALIZER.query("include_pending", include_pending, "bool")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_deleted_certificate_request(certificate_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/deletedcertificates/{certificate-name}")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_purge_deleted_certificate_request(certificate_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/deletedcertificates/{certificate-name}")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_recover_deleted_certificate_request(certificate_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/deletedcertificates/{certificate-name}/recover")
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class KeyVaultClientOperationsMixin(KeyVaultClientMixinABC):  # pylint: disable=too-many-public-methods
    @distributed_trace
    def get_certificates(
        self,
        vault_base_url: str,
        maxresults: Optional[int] = None,
        include_pending: Optional[bool] = None,
        **kwargs: Any
    ) -> Iterable["_models.CertificateItem"]:
        """List certificates in a specified key vault.

        The GetCertificates operation returns the set of certificates resources in the specified key
        vault. This operation requires the certificates/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :param include_pending: Specifies whether to include certificates which are not completely
         provisioned. Default value is None.
        :type include_pending: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CertificateItem or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_3.models.CertificateItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificateListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_certificates_request(
                    maxresults=maxresults,
                    include_pending=include_pending,
                    api_version=api_version,
                    template_url=self.get_certificates.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("CertificateListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    get_certificates.metadata = {"url": "/certificates"}  # type: ignore

    @distributed_trace
    def delete_certificate(
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> _models.DeletedCertificateBundle:
        """Deletes a certificate from a specified key vault.

        Deletes all versions of a certificate object along with its associated policy. Delete
        certificate cannot be used to remove individual versions of a certificate object. This
        operation requires the certificates/delete permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedCertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.DeletedCertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DeletedCertificateBundle]

        request = build_delete_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.delete_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DeletedCertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_certificate.metadata = {"url": "/certificates/{certificate-name}"}  # type: ignore

    @overload
    def set_certificate_contacts(
        self, vault_base_url: str, contacts: _models.Contacts, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Contacts:
        """Sets the certificate contacts for the specified key vault.

        Sets the certificate contacts for the specified key vault. This operation requires the
        certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param contacts: The contacts for the key vault certificate. Required.
        :type contacts: ~azure.keyvault.v7_3.models.Contacts
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def set_certificate_contacts(
        self, vault_base_url: str, contacts: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Contacts:
        """Sets the certificate contacts for the specified key vault.

        Sets the certificate contacts for the specified key vault. This operation requires the
        certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param contacts: The contacts for the key vault certificate. Required.
        :type contacts: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def set_certificate_contacts(
        self, vault_base_url: str, contacts: Union[_models.Contacts, IO], **kwargs: Any
    ) -> _models.Contacts:
        """Sets the certificate contacts for the specified key vault.

        Sets the certificate contacts for the specified key vault. This operation requires the
        certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param contacts: The contacts for the key vault certificate. Is either a model type or a IO
         type. Required.
        :type contacts: ~azure.keyvault.v7_3.models.Contacts or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Contacts]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(contacts, (IO, bytes)):
            _content = contacts
        else:
            _json = self._serialize.body(contacts, "Contacts")

        request = build_set_certificate_contacts_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.set_certificate_contacts.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Contacts", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    set_certificate_contacts.metadata = {"url": "/certificates/contacts"}  # type: ignore

    @distributed_trace
    def get_certificate_contacts(self, vault_base_url: str, **kwargs: Any) -> _models.Contacts:
        """Lists the certificate contacts for a specified key vault.

        The GetCertificateContacts operation returns the set of certificate contact resources in the
        specified key vault. This operation requires the certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Contacts]

        request = build_get_certificate_contacts_request(
            api_version=api_version,
            template_url=self.get_certificate_contacts.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Contacts", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_certificate_contacts.metadata = {"url": "/certificates/contacts"}  # type: ignore

    @distributed_trace
    def delete_certificate_contacts(self, vault_base_url: str, **kwargs: Any) -> _models.Contacts:
        """Deletes the certificate contacts for a specified key vault.

        Deletes the certificate contacts for a specified key vault certificate. This operation requires
        the certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Contacts]

        request = build_delete_certificate_contacts_request(
            api_version=api_version,
            template_url=self.delete_certificate_contacts.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Contacts", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_certificate_contacts.metadata = {"url": "/certificates/contacts"}  # type: ignore

    @distributed_trace
    def get_certificate_issuers(
        self, vault_base_url: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> Iterable["_models.CertificateIssuerItem"]:
        """List certificate issuers for a specified key vault.

        The GetCertificateIssuers operation returns the set of certificate issuer resources in the
        specified key vault. This operation requires the certificates/manageissuers/getissuers
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CertificateIssuerItem or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_3.models.CertificateIssuerItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificateIssuerListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_certificate_issuers_request(
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_certificate_issuers.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("CertificateIssuerListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    get_certificate_issuers.metadata = {"url": "/certificates/issuers"}  # type: ignore

    @overload
    def set_certificate_issuer(
        self,
        vault_base_url: str,
        issuer_name: str,
        parameter: _models.CertificateIssuerSetParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Sets the specified certificate issuer.

        The SetCertificateIssuer operation adds or updates the specified certificate issuer. This
        operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer set parameter. Required.
        :type parameter: ~azure.keyvault.v7_3.models.CertificateIssuerSetParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def set_certificate_issuer(
        self,
        vault_base_url: str,
        issuer_name: str,
        parameter: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Sets the specified certificate issuer.

        The SetCertificateIssuer operation adds or updates the specified certificate issuer. This
        operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer set parameter. Required.
        :type parameter: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def set_certificate_issuer(
        self,
        vault_base_url: str,
        issuer_name: str,
        parameter: Union[_models.CertificateIssuerSetParameters, IO],
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Sets the specified certificate issuer.

        The SetCertificateIssuer operation adds or updates the specified certificate issuer. This
        operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer set parameter. Is either a model type or a IO type.
         Required.
        :type parameter: ~azure.keyvault.v7_3.models.CertificateIssuerSetParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.IssuerBundle]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameter, (IO, bytes)):
            _content = parameter
        else:
            _json = self._serialize.body(parameter, "CertificateIssuerSetParameters")

        request = build_set_certificate_issuer_request(
            issuer_name=issuer_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.set_certificate_issuer.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("IssuerBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    set_certificate_issuer.metadata = {"url": "/certificates/issuers/{issuer-name}"}  # type: ignore

    @overload
    def update_certificate_issuer(
        self,
        vault_base_url: str,
        issuer_name: str,
        parameter: _models.CertificateIssuerUpdateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Updates the specified certificate issuer.

        The UpdateCertificateIssuer operation performs an update on the specified certificate issuer
        entity. This operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer update parameter. Required.
        :type parameter: ~azure.keyvault.v7_3.models.CertificateIssuerUpdateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_certificate_issuer(
        self,
        vault_base_url: str,
        issuer_name: str,
        parameter: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Updates the specified certificate issuer.

        The UpdateCertificateIssuer operation performs an update on the specified certificate issuer
        entity. This operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer update parameter. Required.
        :type parameter: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_certificate_issuer(
        self,
        vault_base_url: str,
        issuer_name: str,
        parameter: Union[_models.CertificateIssuerUpdateParameters, IO],
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Updates the specified certificate issuer.

        The UpdateCertificateIssuer operation performs an update on the specified certificate issuer
        entity. This operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer update parameter. Is either a model type or a IO type.
         Required.
        :type parameter: ~azure.keyvault.v7_3.models.CertificateIssuerUpdateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.IssuerBundle]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameter, (IO, bytes)):
            _content = parameter
        else:
            _json = self._serialize.body(parameter, "CertificateIssuerUpdateParameters")

        request = build_update_certificate_issuer_request(
            issuer_name=issuer_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_certificate_issuer.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("IssuerBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_certificate_issuer.metadata = {"url": "/certificates/issuers/{issuer-name}"}  # type: ignore

    @distributed_trace
    def get_certificate_issuer(self, vault_base_url: str, issuer_name: str, **kwargs: Any) -> _models.IssuerBundle:
        """Lists the specified certificate issuer.

        The GetCertificateIssuer operation returns the specified certificate issuer resources in the
        specified key vault. This operation requires the certificates/manageissuers/getissuers
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.IssuerBundle]

        request = build_get_certificate_issuer_request(
            issuer_name=issuer_name,
            api_version=api_version,
            template_url=self.get_certificate_issuer.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("IssuerBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_certificate_issuer.metadata = {"url": "/certificates/issuers/{issuer-name}"}  # type: ignore

    @distributed_trace
    def delete_certificate_issuer(self, vault_base_url: str, issuer_name: str, **kwargs: Any) -> _models.IssuerBundle:
        """Deletes the specified certificate issuer.

        The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from
        the vault. This operation requires the certificates/manageissuers/deleteissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.IssuerBundle]

        request = build_delete_certificate_issuer_request(
            issuer_name=issuer_name,
            api_version=api_version,
            template_url=self.delete_certificate_issuer.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("IssuerBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_certificate_issuer.metadata = {"url": "/certificates/issuers/{issuer-name}"}  # type: ignore

    @overload
    def create_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: _models.CertificateCreateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Creates a new certificate.

        If this is the first version, the certificate resource is created. This operation requires the
        certificates/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to create a certificate. Required.
        :type parameters: ~azure.keyvault.v7_3.models.CertificateCreateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Creates a new certificate.

        If this is the first version, the certificate resource is created. This operation requires the
        certificates/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to create a certificate. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: Union[_models.CertificateCreateParameters, IO],
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Creates a new certificate.

        If this is the first version, the certificate resource is created. This operation requires the
        certificates/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to create a certificate. Is either a model type or a IO type.
         Required.
        :type parameters: ~azure.keyvault.v7_3.models.CertificateCreateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificateOperation]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CertificateCreateParameters")

        request = build_create_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateOperation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_certificate.metadata = {"url": "/certificates/{certificate-name}/create"}  # type: ignore

    @overload
    def import_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: _models.CertificateImportParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Imports a certificate into a specified key vault.

        Imports an existing valid certificate, containing a private key, into Azure Key Vault. This
        operation requires the certificates/import permission. The certificate to be imported can be in
        either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key
        as well as x509 certificates. Key Vault will only accept a key in PKCS#8 format.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to import the certificate. Required.
        :type parameters: ~azure.keyvault.v7_3.models.CertificateImportParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def import_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Imports a certificate into a specified key vault.

        Imports an existing valid certificate, containing a private key, into Azure Key Vault. This
        operation requires the certificates/import permission. The certificate to be imported can be in
        either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key
        as well as x509 certificates. Key Vault will only accept a key in PKCS#8 format.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to import the certificate. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def import_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: Union[_models.CertificateImportParameters, IO],
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Imports a certificate into a specified key vault.

        Imports an existing valid certificate, containing a private key, into Azure Key Vault. This
        operation requires the certificates/import permission. The certificate to be imported can be in
        either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key
        as well as x509 certificates. Key Vault will only accept a key in PKCS#8 format.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to import the certificate. Is either a model type or a IO
         type. Required.
        :type parameters: ~azure.keyvault.v7_3.models.CertificateImportParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificateBundle]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CertificateImportParameters")

        request = build_import_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.import_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    import_certificate.metadata = {"url": "/certificates/{certificate-name}/import"}  # type: ignore

    @distributed_trace
    def get_certificate_versions(
        self, vault_base_url: str, certificate_name: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> Iterable["_models.CertificateItem"]:
        """List the versions of a certificate.

        The GetCertificateVersions operation returns the versions of a certificate in the specified key
        vault. This operation requires the certificates/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CertificateItem or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_3.models.CertificateItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificateListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_certificate_versions_request(
                    certificate_name=certificate_name,
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_certificate_versions.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("CertificateListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    get_certificate_versions.metadata = {"url": "/certificates/{certificate-name}/versions"}  # type: ignore

    @distributed_trace
    def get_certificate_policy(
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> _models.CertificatePolicy:
        """Lists the policy for a certificate.

        The GetCertificatePolicy operation returns the specified certificate policy resources in the
        specified key vault. This operation requires the certificates/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in a given key vault. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificatePolicy or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificatePolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificatePolicy]

        request = build_get_certificate_policy_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.get_certificate_policy.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificatePolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_certificate_policy.metadata = {"url": "/certificates/{certificate-name}/policy"}  # type: ignore

    @overload
    def update_certificate_policy(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_policy: _models.CertificatePolicy,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificatePolicy:
        """Updates the policy for a certificate.

        Set specified members in the certificate policy. Leave others as null. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given vault. Required.
        :type certificate_name: str
        :param certificate_policy: The policy for the certificate. Required.
        :type certificate_policy: ~azure.keyvault.v7_3.models.CertificatePolicy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificatePolicy or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificatePolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_certificate_policy(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_policy: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificatePolicy:
        """Updates the policy for a certificate.

        Set specified members in the certificate policy. Leave others as null. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given vault. Required.
        :type certificate_name: str
        :param certificate_policy: The policy for the certificate. Required.
        :type certificate_policy: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificatePolicy or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificatePolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_certificate_policy(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_policy: Union[_models.CertificatePolicy, IO],
        **kwargs: Any
    ) -> _models.CertificatePolicy:
        """Updates the policy for a certificate.

        Set specified members in the certificate policy. Leave others as null. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given vault. Required.
        :type certificate_name: str
        :param certificate_policy: The policy for the certificate. Is either a model type or a IO type.
         Required.
        :type certificate_policy: ~azure.keyvault.v7_3.models.CertificatePolicy or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificatePolicy or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificatePolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificatePolicy]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(certificate_policy, (IO, bytes)):
            _content = certificate_policy
        else:
            _json = self._serialize.body(certificate_policy, "CertificatePolicy")

        request = build_update_certificate_policy_request(
            certificate_name=certificate_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_certificate_policy.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificatePolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_certificate_policy.metadata = {"url": "/certificates/{certificate-name}/policy"}  # type: ignore

    @overload
    def update_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_version: str,
        parameters: _models.CertificateUpdateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Updates the specified attributes associated with the given certificate.

        The UpdateCertificate operation applies the specified update on the given certificate; the only
        elements updated are the certificate's attributes. This operation requires the
        certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given key vault. Required.
        :type certificate_name: str
        :param certificate_version: The version of the certificate. Required.
        :type certificate_version: str
        :param parameters: The parameters for certificate update. Required.
        :type parameters: ~azure.keyvault.v7_3.models.CertificateUpdateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Updates the specified attributes associated with the given certificate.

        The UpdateCertificate operation applies the specified update on the given certificate; the only
        elements updated are the certificate's attributes. This operation requires the
        certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given key vault. Required.
        :type certificate_name: str
        :param certificate_version: The version of the certificate. Required.
        :type certificate_version: str
        :param parameters: The parameters for certificate update. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_version: str,
        parameters: Union[_models.CertificateUpdateParameters, IO],
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Updates the specified attributes associated with the given certificate.

        The UpdateCertificate operation applies the specified update on the given certificate; the only
        elements updated are the certificate's attributes. This operation requires the
        certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given key vault. Required.
        :type certificate_name: str
        :param certificate_version: The version of the certificate. Required.
        :type certificate_version: str
        :param parameters: The parameters for certificate update. Is either a model type or a IO type.
         Required.
        :type parameters: ~azure.keyvault.v7_3.models.CertificateUpdateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificateBundle]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CertificateUpdateParameters")

        request = build_update_certificate_request(
            certificate_name=certificate_name,
            certificate_version=certificate_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_certificate.metadata = {"url": "/certificates/{certificate-name}/{certificate-version}"}  # type: ignore

    @distributed_trace
    def get_certificate(
        self, vault_base_url: str, certificate_name: str, certificate_version: str, **kwargs: Any
    ) -> _models.CertificateBundle:
        """Gets information about a certificate.

        Gets information about a specific certificate. This operation requires the certificates/get
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given vault. Required.
        :type certificate_name: str
        :param certificate_version: The version of the certificate. This URI fragment is optional. If
         not specified, the latest version of the certificate is returned. Required.
        :type certificate_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificateBundle]

        request = build_get_certificate_request(
            certificate_name=certificate_name,
            certificate_version=certificate_version,
            api_version=api_version,
            template_url=self.get_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_certificate.metadata = {"url": "/certificates/{certificate-name}/{certificate-version}"}  # type: ignore

    @overload
    def update_certificate_operation(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_operation: _models.CertificateOperationUpdateParameter,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Updates a certificate operation.

        Updates a certificate creation operation that is already in progress. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param certificate_operation: The certificate operation response. Required.
        :type certificate_operation: ~azure.keyvault.v7_3.models.CertificateOperationUpdateParameter
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_certificate_operation(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_operation: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Updates a certificate operation.

        Updates a certificate creation operation that is already in progress. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param certificate_operation: The certificate operation response. Required.
        :type certificate_operation: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_certificate_operation(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_operation: Union[_models.CertificateOperationUpdateParameter, IO],
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Updates a certificate operation.

        Updates a certificate creation operation that is already in progress. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param certificate_operation: The certificate operation response. Is either a model type or a
         IO type. Required.
        :type certificate_operation: ~azure.keyvault.v7_3.models.CertificateOperationUpdateParameter or
         IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificateOperation]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(certificate_operation, (IO, bytes)):
            _content = certificate_operation
        else:
            _json = self._serialize.body(certificate_operation, "CertificateOperationUpdateParameter")

        request = build_update_certificate_operation_request(
            certificate_name=certificate_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_certificate_operation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateOperation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_certificate_operation.metadata = {"url": "/certificates/{certificate-name}/pending"}  # type: ignore

    @distributed_trace
    def get_certificate_operation(
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> _models.CertificateOperation:
        """Gets the creation operation of a certificate.

        Gets the creation operation associated with a specified certificate. This operation requires
        the certificates/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificateOperation]

        request = build_get_certificate_operation_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.get_certificate_operation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateOperation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_certificate_operation.metadata = {"url": "/certificates/{certificate-name}/pending"}  # type: ignore

    @distributed_trace
    def delete_certificate_operation(
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> _models.CertificateOperation:
        """Deletes the creation operation for a specific certificate.

        Deletes the creation operation for a specified certificate that is in the process of being
        created. The certificate is no longer created. This operation requires the certificates/update
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificateOperation]

        request = build_delete_certificate_operation_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.delete_certificate_operation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateOperation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_certificate_operation.metadata = {"url": "/certificates/{certificate-name}/pending"}  # type: ignore

    @overload
    def merge_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: _models.CertificateMergeParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Merges a certificate or a certificate chain with a key pair existing on the server.

        The MergeCertificate operation performs the merging of a certificate or certificate chain with
        a key pair currently available in the service. This operation requires the certificates/create
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to merge certificate. Required.
        :type parameters: ~azure.keyvault.v7_3.models.CertificateMergeParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def merge_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Merges a certificate or a certificate chain with a key pair existing on the server.

        The MergeCertificate operation performs the merging of a certificate or certificate chain with
        a key pair currently available in the service. This operation requires the certificates/create
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to merge certificate. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def merge_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: Union[_models.CertificateMergeParameters, IO],
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Merges a certificate or a certificate chain with a key pair existing on the server.

        The MergeCertificate operation performs the merging of a certificate or certificate chain with
        a key pair currently available in the service. This operation requires the certificates/create
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to merge certificate. Is either a model type or a IO type.
         Required.
        :type parameters: ~azure.keyvault.v7_3.models.CertificateMergeParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificateBundle]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CertificateMergeParameters")

        request = build_merge_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.merge_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    merge_certificate.metadata = {"url": "/certificates/{certificate-name}/pending/merge"}  # type: ignore

    @distributed_trace
    def backup_certificate(
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> _models.BackupCertificateResult:
        """Backs up the specified certificate.

        Requests that a backup of the specified certificate be downloaded to the client. All versions
        of the certificate will be downloaded. This operation requires the certificates/backup
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupCertificateResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.BackupCertificateResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.BackupCertificateResult]

        request = build_backup_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.backup_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("BackupCertificateResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    backup_certificate.metadata = {"url": "/certificates/{certificate-name}/backup"}  # type: ignore

    @overload
    def restore_certificate(
        self,
        vault_base_url: str,
        parameters: _models.CertificateRestoreParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Restores a backed up certificate to a vault.

        Restores a backed up certificate, and all its versions, to a vault. This operation requires the
        certificates/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param parameters: The parameters to restore the certificate. Required.
        :type parameters: ~azure.keyvault.v7_3.models.CertificateRestoreParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def restore_certificate(
        self, vault_base_url: str, parameters: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CertificateBundle:
        """Restores a backed up certificate to a vault.

        Restores a backed up certificate, and all its versions, to a vault. This operation requires the
        certificates/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param parameters: The parameters to restore the certificate. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def restore_certificate(
        self, vault_base_url: str, parameters: Union[_models.CertificateRestoreParameters, IO], **kwargs: Any
    ) -> _models.CertificateBundle:
        """Restores a backed up certificate to a vault.

        Restores a backed up certificate, and all its versions, to a vault. This operation requires the
        certificates/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param parameters: The parameters to restore the certificate. Is either a model type or a IO
         type. Required.
        :type parameters: ~azure.keyvault.v7_3.models.CertificateRestoreParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificateBundle]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CertificateRestoreParameters")

        request = build_restore_certificate_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.restore_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    restore_certificate.metadata = {"url": "/certificates/restore"}  # type: ignore

    @distributed_trace
    def get_deleted_certificates(
        self,
        vault_base_url: str,
        maxresults: Optional[int] = None,
        include_pending: Optional[bool] = None,
        **kwargs: Any
    ) -> Iterable["_models.DeletedCertificateItem"]:
        """Lists the deleted certificates in the specified vault currently available for recovery.

        The GetDeletedCertificates operation retrieves the certificates in the current vault which are
        in a deleted state and ready for recovery or purging. This operation includes deletion-specific
        information. This operation requires the certificates/get/list permission. This operation can
        only be enabled on soft-delete enabled vaults.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :param include_pending: Specifies whether to include certificates which are not completely
         provisioned. Default value is None.
        :type include_pending: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeletedCertificateItem or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_3.models.DeletedCertificateItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DeletedCertificateListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_deleted_certificates_request(
                    maxresults=maxresults,
                    include_pending=include_pending,
                    api_version=api_version,
                    template_url=self.get_deleted_certificates.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("DeletedCertificateListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    get_deleted_certificates.metadata = {"url": "/deletedcertificates"}  # type: ignore

    @distributed_trace
    def get_deleted_certificate(
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> _models.DeletedCertificateBundle:
        """Retrieves information about the specified deleted certificate.

        The GetDeletedCertificate operation retrieves the deleted certificate information plus its
        attributes, such as retention interval, scheduled permanent deletion and the current deletion
        recovery level. This operation requires the certificates/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedCertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.DeletedCertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DeletedCertificateBundle]

        request = build_get_deleted_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.get_deleted_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DeletedCertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_deleted_certificate.metadata = {"url": "/deletedcertificates/{certificate-name}"}  # type: ignore

    @distributed_trace
    def purge_deleted_certificate(  # pylint: disable=inconsistent-return-statements
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> None:
        """Permanently deletes the specified deleted certificate.

        The PurgeDeletedCertificate operation performs an irreversible deletion of the specified
        certificate, without possibility for recovery. The operation is not available if the recovery
        level does not specify 'Purgeable'. This operation requires the certificate/purge permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_purge_deleted_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.purge_deleted_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    purge_deleted_certificate.metadata = {"url": "/deletedcertificates/{certificate-name}"}  # type: ignore

    @distributed_trace
    def recover_deleted_certificate(
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> _models.CertificateBundle:
        """Recovers the deleted certificate back to its current version under /certificates.

        The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The
        operation is applicable in vaults enabled for soft-delete, and must be issued during the
        retention interval (available in the deleted certificate's attributes). This operation requires
        the certificates/recover permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the deleted certificate. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_3.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.3"))  # type: Literal["7.3"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CertificateBundle]

        request = build_recover_deleted_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.recover_deleted_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    recover_deleted_certificate.metadata = {"url": "/deletedcertificates/{certificate-name}/recover"}  # type: ignore
