# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Amount(_serialization.Model):
    """The amount.

    :ivar currency: The type of currency being used for the value.
    :vartype currency: str
    :ivar value: Amount value.
    :vartype value: float
    """

    _attribute_map = {
        "currency": {"key": "currency", "type": "str"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, currency: Optional[str] = None, value: Optional[float] = None, **kwargs):
        """
        :keyword currency: The type of currency being used for the value.
        :paramtype currency: str
        :keyword value: Amount value.
        :paramtype value: float
        """
        super().__init__(**kwargs)
        self.currency = currency
        self.value = value


class ErrorResponse(_serialization.Model):
    """Describes the format of Error response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorResponseBody(_serialization.Model):
    """Error response indicates that the service is not able to process the incoming request. The reason is provided in the error message.

    :ivar error: The details of the error.
    :vartype error: ~azure.mgmt.education.models.ErrorResponse
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponse"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponse"] = None, **kwargs):
        """
        :keyword error: The details of the error.
        :paramtype error: ~azure.mgmt.education.models.ErrorResponse
        """
        super().__init__(**kwargs)
        self.error = error


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.education.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class GrantDetails(Resource):
    """Grant details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.education.models.SystemData
    :ivar offer_cap: Offer Cap.
    :vartype offer_cap: ~azure.mgmt.education.models.Amount
    :ivar effective_date: Grant Effective Date.
    :vartype effective_date: ~datetime.datetime
    :ivar offer_type: Grant Offer Type. Known values are: "Student" and "Academic".
    :vartype offer_type: str or ~azure.mgmt.education.models.GrantType
    :ivar expiration_date: Expiration Date.
    :vartype expiration_date: ~datetime.datetime
    :ivar status: Grant status. Known values are: "Active" and "Inactive".
    :vartype status: str or ~azure.mgmt.education.models.GrantStatus
    :ivar allocated_budget: allocated budget.
    :vartype allocated_budget: ~azure.mgmt.education.models.Amount
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "offer_cap": {"readonly": True},
        "effective_date": {"readonly": True},
        "offer_type": {"readonly": True},
        "expiration_date": {"readonly": True},
        "status": {"readonly": True},
        "allocated_budget": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "offer_cap": {"key": "properties.offerCap", "type": "Amount"},
        "effective_date": {"key": "properties.effectiveDate", "type": "iso-8601"},
        "offer_type": {"key": "properties.offerType", "type": "str"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "status": {"key": "properties.status", "type": "str"},
        "allocated_budget": {"key": "properties.allocatedBudget", "type": "Amount"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.offer_cap = None
        self.effective_date = None
        self.offer_type = None
        self.expiration_date = None
        self.status = None
        self.allocated_budget = None


class GrantListResponse(_serialization.Model):
    """List of Grants info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of labs.
    :vartype value: list[~azure.mgmt.education.models.GrantDetails]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GrantDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class InviteCodeGenerateRequest(_serialization.Model):
    """invite code generate request.

    :ivar max_student_count: the total number of students that can be accepted to the lab.
    :vartype max_student_count: float
    """

    _attribute_map = {
        "max_student_count": {"key": "maxStudentCount", "type": "float"},
    }

    def __init__(self, *, max_student_count: Optional[float] = None, **kwargs):
        """
        :keyword max_student_count: the total number of students that can be accepted to the lab.
        :paramtype max_student_count: float
        """
        super().__init__(**kwargs)
        self.max_student_count = max_student_count


class JoinRequestDetails(Resource):
    """join requests.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.education.models.SystemData
    :ivar first_name: First Name.
    :vartype first_name: str
    :ivar last_name: Last Name.
    :vartype last_name: str
    :ivar email: join request email.
    :vartype email: str
    :ivar status: Join request status. Known values are: "Pending" and "Denied".
    :vartype status: str or ~azure.mgmt.education.models.JoinRequestStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "first_name": {"key": "properties.firstName", "type": "str"},
        "last_name": {"key": "properties.lastName", "type": "str"},
        "email": {"key": "properties.email", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
    }

    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email: Optional[str] = None,
        status: Optional[Union[str, "_models.JoinRequestStatus"]] = None,
        **kwargs
    ):
        """
        :keyword first_name: First Name.
        :paramtype first_name: str
        :keyword last_name: Last Name.
        :paramtype last_name: str
        :keyword email: join request email.
        :paramtype email: str
        :keyword status: Join request status. Known values are: "Pending" and "Denied".
        :paramtype status: str or ~azure.mgmt.education.models.JoinRequestStatus
        """
        super().__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.email = email
        self.status = status


class JoinRequestList(_serialization.Model):
    """list of join requests.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of requests.
    :vartype value: list[~azure.mgmt.education.models.JoinRequestDetails]
    :ivar next_link: the link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JoinRequestDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class LabDetails(Resource):  # pylint: disable=too-many-instance-attributes
    """Lab details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.education.models.SystemData
    :ivar display_name: Lab Display Name.
    :vartype display_name: str
    :ivar budget_per_student: Default monetary cap for each student in this lab.
    :vartype budget_per_student: ~azure.mgmt.education.models.Amount
    :ivar description: Detail description of this lab.
    :vartype description: str
    :ivar expiration_date: Default expiration date for each student in this lab.
    :vartype expiration_date: ~datetime.datetime
    :ivar effective_date: Lab creation date.
    :vartype effective_date: ~datetime.datetime
    :ivar status: The status of this lab. Known values are: "Active", "Deleted", and "Pending".
    :vartype status: str or ~azure.mgmt.education.models.LabStatus
    :ivar max_student_count: the total number of students that can be accepted to the lab.
    :vartype max_student_count: float
    :ivar invitation_code: invitation code for redeemable lab.
    :vartype invitation_code: str
    :ivar currency_properties_total_allocated_budget_currency: The type of currency being used for
     the value.
    :vartype currency_properties_total_allocated_budget_currency: str
    :ivar value_properties_total_allocated_budget_value: Amount value.
    :vartype value_properties_total_allocated_budget_value: float
    :ivar currency_properties_total_budget_currency: The type of currency being used for the value.
    :vartype currency_properties_total_budget_currency: str
    :ivar value_properties_total_budget_value: Amount value.
    :vartype value_properties_total_budget_value: float
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "effective_date": {"readonly": True},
        "status": {"readonly": True},
        "max_student_count": {"readonly": True},
        "invitation_code": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "budget_per_student": {"key": "properties.budgetPerStudent", "type": "Amount"},
        "description": {"key": "properties.description", "type": "str"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "effective_date": {"key": "properties.effectiveDate", "type": "iso-8601"},
        "status": {"key": "properties.status", "type": "str"},
        "max_student_count": {"key": "properties.maxStudentCount", "type": "float"},
        "invitation_code": {"key": "properties.invitationCode", "type": "str"},
        "currency_properties_total_allocated_budget_currency": {
            "key": "properties.totalAllocatedBudget.currency",
            "type": "str",
        },
        "value_properties_total_allocated_budget_value": {
            "key": "properties.totalAllocatedBudget.value",
            "type": "float",
        },
        "currency_properties_total_budget_currency": {"key": "properties.totalBudget.currency", "type": "str"},
        "value_properties_total_budget_value": {"key": "properties.totalBudget.value", "type": "float"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        budget_per_student: Optional["_models.Amount"] = None,
        description: Optional[str] = None,
        expiration_date: Optional[datetime.datetime] = None,
        currency_properties_total_allocated_budget_currency: Optional[str] = None,
        value_properties_total_allocated_budget_value: Optional[float] = None,
        currency_properties_total_budget_currency: Optional[str] = None,
        value_properties_total_budget_value: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword display_name: Lab Display Name.
        :paramtype display_name: str
        :keyword budget_per_student: Default monetary cap for each student in this lab.
        :paramtype budget_per_student: ~azure.mgmt.education.models.Amount
        :keyword description: Detail description of this lab.
        :paramtype description: str
        :keyword expiration_date: Default expiration date for each student in this lab.
        :paramtype expiration_date: ~datetime.datetime
        :keyword currency_properties_total_allocated_budget_currency: The type of currency being used
         for the value.
        :paramtype currency_properties_total_allocated_budget_currency: str
        :keyword value_properties_total_allocated_budget_value: Amount value.
        :paramtype value_properties_total_allocated_budget_value: float
        :keyword currency_properties_total_budget_currency: The type of currency being used for the
         value.
        :paramtype currency_properties_total_budget_currency: str
        :keyword value_properties_total_budget_value: Amount value.
        :paramtype value_properties_total_budget_value: float
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.budget_per_student = budget_per_student
        self.description = description
        self.expiration_date = expiration_date
        self.effective_date = None
        self.status = None
        self.max_student_count = None
        self.invitation_code = None
        self.currency_properties_total_allocated_budget_currency = currency_properties_total_allocated_budget_currency
        self.value_properties_total_allocated_budget_value = value_properties_total_allocated_budget_value
        self.currency_properties_total_budget_currency = currency_properties_total_budget_currency
        self.value_properties_total_budget_value = value_properties_total_budget_value


class LabListResult(_serialization.Model):
    """List of labs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of labs.
    :vartype value: list[~azure.mgmt.education.models.LabDetails]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LabDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.education.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.education.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.education.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs):
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.education.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.education.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class RedeemRequest(_serialization.Model):
    """redeem request.

    All required parameters must be populated in order to send to Azure.

    :ivar redeem_code: redeem code. Required.
    :vartype redeem_code: str
    :ivar first_name: first name of requester. Required.
    :vartype first_name: str
    :ivar last_name: last name of requester. Required.
    :vartype last_name: str
    """

    _validation = {
        "redeem_code": {"required": True},
        "first_name": {"required": True},
        "last_name": {"required": True},
    }

    _attribute_map = {
        "redeem_code": {"key": "redeemCode", "type": "str"},
        "first_name": {"key": "firstName", "type": "str"},
        "last_name": {"key": "lastName", "type": "str"},
    }

    def __init__(self, *, redeem_code: str, first_name: str, last_name: str, **kwargs):
        """
        :keyword redeem_code: redeem code. Required.
        :paramtype redeem_code: str
        :keyword first_name: first name of requester. Required.
        :paramtype first_name: str
        :keyword last_name: last name of requester. Required.
        :paramtype last_name: str
        """
        super().__init__(**kwargs)
        self.redeem_code = redeem_code
        self.first_name = first_name
        self.last_name = last_name


class StudentDetails(Resource):  # pylint: disable=too-many-instance-attributes
    """Student details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.education.models.SystemData
    :ivar first_name: First Name.
    :vartype first_name: str
    :ivar last_name: Last Name.
    :vartype last_name: str
    :ivar email: Student Email.
    :vartype email: str
    :ivar role: Student Role. Known values are: "Student" and "Admin".
    :vartype role: str or ~azure.mgmt.education.models.StudentRole
    :ivar budget: Student Budget.
    :vartype budget: ~azure.mgmt.education.models.Amount
    :ivar subscription_id: Subscription Id.
    :vartype subscription_id: str
    :ivar expiration_date: Date this student is set to expire from the lab.
    :vartype expiration_date: ~datetime.datetime
    :ivar status: Student Lab Status. Known values are: "Active", "Disabled", "Expired", "Pending",
     and "Deleted".
    :vartype status: str or ~azure.mgmt.education.models.StudentLabStatus
    :ivar effective_date: Date student was added to the lab.
    :vartype effective_date: ~datetime.datetime
    :ivar subscription_alias: Subscription alias.
    :vartype subscription_alias: str
    :ivar subscription_invite_last_sent_date: subscription invite last sent date.
    :vartype subscription_invite_last_sent_date: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "subscription_id": {"readonly": True},
        "status": {"readonly": True},
        "effective_date": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "first_name": {"key": "properties.firstName", "type": "str"},
        "last_name": {"key": "properties.lastName", "type": "str"},
        "email": {"key": "properties.email", "type": "str"},
        "role": {"key": "properties.role", "type": "str"},
        "budget": {"key": "properties.budget", "type": "Amount"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "status": {"key": "properties.status", "type": "str"},
        "effective_date": {"key": "properties.effectiveDate", "type": "iso-8601"},
        "subscription_alias": {"key": "properties.subscriptionAlias", "type": "str"},
        "subscription_invite_last_sent_date": {"key": "properties.subscriptionInviteLastSentDate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email: Optional[str] = None,
        role: Optional[Union[str, "_models.StudentRole"]] = None,
        budget: Optional["_models.Amount"] = None,
        expiration_date: Optional[datetime.datetime] = None,
        subscription_alias: Optional[str] = None,
        subscription_invite_last_sent_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword first_name: First Name.
        :paramtype first_name: str
        :keyword last_name: Last Name.
        :paramtype last_name: str
        :keyword email: Student Email.
        :paramtype email: str
        :keyword role: Student Role. Known values are: "Student" and "Admin".
        :paramtype role: str or ~azure.mgmt.education.models.StudentRole
        :keyword budget: Student Budget.
        :paramtype budget: ~azure.mgmt.education.models.Amount
        :keyword expiration_date: Date this student is set to expire from the lab.
        :paramtype expiration_date: ~datetime.datetime
        :keyword subscription_alias: Subscription alias.
        :paramtype subscription_alias: str
        :keyword subscription_invite_last_sent_date: subscription invite last sent date.
        :paramtype subscription_invite_last_sent_date: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.email = email
        self.role = role
        self.budget = budget
        self.subscription_id = None
        self.expiration_date = expiration_date
        self.status = None
        self.effective_date = None
        self.subscription_alias = subscription_alias
        self.subscription_invite_last_sent_date = subscription_invite_last_sent_date


class StudentLabDetails(Resource):  # pylint: disable=too-many-instance-attributes
    """Student lab details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.education.models.SystemData
    :ivar display_name: Student lab Display Name.
    :vartype display_name: str
    :ivar description: Detail description of this lab.
    :vartype description: str
    :ivar expiration_date: Date the lab will expire and by default will be the expiration date for
     each student in this lab.
    :vartype expiration_date: ~datetime.datetime
    :ivar role: Student Role. Known values are: "Student" and "Admin".
    :vartype role: str or ~azure.mgmt.education.models.StudentRole
    :ivar budget: Student Budget.
    :vartype budget: ~azure.mgmt.education.models.Amount
    :ivar subscription_id: Subscription Id.
    :vartype subscription_id: str
    :ivar status: Student Lab Status. Known values are: "Active", "Disabled", "Expired", "Pending",
     and "Deleted".
    :vartype status: str or ~azure.mgmt.education.models.StudentLabStatus
    :ivar effective_date: User Added Date.
    :vartype effective_date: ~datetime.datetime
    :ivar lab_scope: Lab Scope.
     /providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default.
    :vartype lab_scope: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "expiration_date": {"readonly": True},
        "role": {"readonly": True},
        "budget": {"readonly": True},
        "subscription_id": {"readonly": True},
        "status": {"readonly": True},
        "effective_date": {"readonly": True},
        "lab_scope": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "role": {"key": "properties.role", "type": "str"},
        "budget": {"key": "properties.budget", "type": "Amount"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "effective_date": {"key": "properties.effectiveDate", "type": "iso-8601"},
        "lab_scope": {"key": "properties.labScope", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.expiration_date = None
        self.role = None
        self.budget = None
        self.subscription_id = None
        self.status = None
        self.effective_date = None
        self.lab_scope = None


class StudentLabListResult(_serialization.Model):
    """List of labs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of labs.
    :vartype value: list[~azure.mgmt.education.models.StudentLabDetails]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StudentLabDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class StudentListResult(_serialization.Model):
    """List of students.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of students.
    :vartype value: list[~azure.mgmt.education.models.StudentDetails]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StudentDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.education.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.education.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.education.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.education.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
