# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential

from ._configuration import AzureMapsResourceProviderConfiguration
from .operations import AccountsOperations
from .operations import MapsOperations
from .operations import PrivateAtlasesOperations
from .operations import CreatorsOperations
from . import models


class AzureMapsResourceProvider(object):
    """Resource Provider.

    :ivar accounts: AccountsOperations operations
    :vartype accounts: azure.mgmt.maps.operations.AccountsOperations
    :ivar maps: MapsOperations operations
    :vartype maps: azure.mgmt.maps.operations.MapsOperations
    :ivar private_atlases: PrivateAtlasesOperations operations
    :vartype private_atlases: azure.mgmt.maps.operations.PrivateAtlasesOperations
    :ivar creators: CreatorsOperations operations
    :vartype creators: azure.mgmt.maps.operations.CreatorsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = AzureMapsResourceProviderConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.accounts = AccountsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.maps = MapsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.private_atlases = PrivateAtlasesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.creators = CreatorsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> AzureMapsResourceProvider
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
