// Variables defining mesh densities
fm=0.01;
cm=0.1;

// 4 points defining the domain corners
Point(1) = {0, 0, 0, cm};
Point(2) = {1, 2, 0, cm};
Point(3) = {0, 2, 0, cm};
Point(4) = {1, 0, 0, cm};

// points needed for creating the circles
Point(5) = {0.5, 0.35, 0, fm};
Point(6) = {0.5, 0.45, 0, fm};
Point(7) = {0.5, 0.4, 0, fm};

// 4 lines defining the domain boundaries
Line(1) = {1, 3};
Line(2) = {3, 2};
Line(3) = {2, 4};
Line(4) = {4, 1};

// the circles
Circle(5) = {6, 5, 6};
Circle(6) = {7, 5, 7};

// the flow domain
Line Loop(7) = {1, 2, 3, 4}; // rectangle
Line Loop(8) = {5};          // closes larger circle
Plane Surface(9) = {7, 8};   // combines the both to one surface

// the cylinder wall
Line Loop(10) = {6}; // closes smaller circle
Plane Surface(11) = {8, 10}; // combines circles

// assignment of groups
Physical Surface(12) = {9}; // the flow domain
Physical Surface(13) = {11}; // the solid wall
Physical Line(14) = {4}; // S
Physical Line(15) = {2}; // N
Physical Line(16) = {1}; // W
Physical Line(17) = {3}; // E
Physical Line(18) = {5}; // outer circle
Physical Line(19) = {6}; // inner circle

