 /*
  * Khoros: $Id: vgettilt.h,v 1.2 1991/10/02 00:04:22 khoros Exp $
  */

 /*
  * $Log: vgettilt.h,v $
 * Revision 1.2  1991/10/02  00:04:22  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgettilt.h
 >>>>            Author: Scott Wilson, Donna Koechner
 >>>> Date Last Updated: Thu Sep 26 11:12:04 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vgettilt_h_
#define _vgettilt_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vgettilt Argument Structure
*
****************************************************************/

typedef struct _vgettilt  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  output ASCII file (Required outfile)
 */
char	*f_file;	/* output ASCII file FILENAME */
int	 f_flag;	/* output ASCII file FLAG */

/*
 *  statistics operation masking image (Optional infile)
 */
char	*m_file;	/* statistics operation masking image FILENAME */
int	 m_flag;	/* statistics operation masking image FLAG */

}  vgettilt_struct;

vgettilt_struct *vgettilt;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(img1) \
        if ((img1 = readimage(vgettilt->i_file)) == NULL) exit(1)

#define READMASK(img2) \
        if (vgettilt->m_flag) img2 = readimage(vgettilt->m_file); \
        if (vgettilt->m_flag && (img2 == NULL)) exit(1)

#define CHECKINPUT(program, img1) \
        (void) proper_num_images(program,img1,1,TRUE); \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE); \
        (void) proper_num_bands(program,img1,1,TRUE)

#define MATCHINPUT(program, img1, img2) \
        if(vgettilt->m_flag) \
        { \
        (void) match_num_images(program,img1,img2,TRUE); \
        (void) match_num_bands(program,img1,img2,TRUE); \
        (void) match_map_enable(program,img1,img2,TRUE); \
        (void) matchsize(program,img1,img2,TRUE); \
        (void) matchtype(program,img1,img2,TRUE); \
        }

/* -include_macros_end */

#endif
