 /*
  * Khoros: $Id: fits2viff.h,v 1.1 1991/05/10 15:52:54 khoros Exp $
  */

 /*
  * $Log: fits2viff.h,v $
 * Revision 1.1  1991/05/10  15:52:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: fits2viff.h
 >>>>            Author: Robin Corbet, PSU
 >>>> Date Last Updated: Sat Mar  2 14:27:47 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _fits2viff_h_
#define _fits2viff_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    fits2viff Argument Structure
*
****************************************************************/

typedef struct _fits2viff  {

/*
 *  input FITS data file (Required infile)
 */
char	*i_file;	/* input FITS data file FILENAME */
int	 i_flag;	/* input FITS data file FLAG */

/*
 *  resulting output image (viff file) (Required outfile)
 */
char	*o_file;	/* resulting output image (viff file) FILENAME */
int	 o_flag;	/* resulting output image (viff file) FLAG */

/*
 * lets user chose color space model (Required integer toggle - )
 */
int	 c_toggle;		/* lets user chose color space model INT TOGGLE */
int	 c_flag;		/* lets user chose color space model FLAG */

}  fits2viff_struct;

fits2viff_struct *fits2viff;

/* -include_additions */
#include "file_formats/fits.h"
/* -include_additions_end */

/* -include_macros */
#define READINPUT(fits_image) \
    fits_image = read_fits(fits2viff->i_file); \
    if(fits_image == NULL){ \
        (void) fprintf(stderr,"fits2viff: Image could not be read\n"); \
        exit(1); \
    }
/* -include_macros_end */

#endif
