 /*
  * Khoros: $Id: set_cm.c,v 1.1 1991/05/10 15:41:35 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: set_cm.c,v 1.1 1991/05/10 15:41:35 khoros Exp $";
#endif

 /*
  * $Log: set_cm.c,v $
 * Revision 1.1  1991/05/10  15:41:35  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

/*
#
# FILE NAME:	set_cm.c
# 
# AUTHORS:	Tom Sauer
# 
# DATE:		12/19/89
# 
# DESCRIPTION:	set color space model
# 
# MODIFICATIONS:
# 
*/

/*INCLUDE*/
#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "viff.h"	 	
#include <stdio.h>

#define LENGTH 512

/**************************************************************
*
* MODULE NAME: set_color_space_model
*
*     PURPOSE: sets the color space model as defined below.
*
*		0 = VFF_CM_NONE
*		1 = VFF_CM_ntscRGB
*		2 = VFF_CM_ntscCMY
*		3 = VFF_CM_ntscYIQ
*		4 = VFF_CM_HSV
*		5 = VFF_CM_HLS
*		6 = VFF_CM_IHS
*		7 = VFF_CM_cieRGB
*		8 = VFF_CM_cieXYZ
*		9 = VFF_CM_cieUVW
*		10 = VFF_CM_cieucsUVW
*		11 = VFF_CM_cieucsSOW
*		12 = VFF_CM_cieucsLab
*		13 = VFF_CM_cieucsLuv
*		14 = VFF_CM_GENERIC
*		15 = VFF_CM_VFF_CM_genericRGb
*
*
*
*       INPUT:  image -- the source image
*
*      OUTPUT: 	image -- changed image header 
*
* CALLED FROM: 
*
* ROUTINES CALLED: 
*
**************************************************************/
set_color_space_model(image, model)

struct xvimage *image;
int model;
{

   switch(model) { 
     case 0: 
       image->color_space_model = VFF_CM_NONE;
       break;
     case 1:
       image->color_space_model = VFF_CM_ntscRGB;
       break;
     case 2:
       image->color_space_model = VFF_CM_ntscCMY;
       break;
     case 3:
       image->color_space_model = VFF_CM_ntscYIQ;
       break;
     case 4:
       image->color_space_model = VFF_CM_HSV;
       break;
     case 5:
       image->color_space_model = VFF_CM_HLS;
       break;
     case 6:
       image->color_space_model = VFF_CM_IHS;
       break;
     case 7:
       image->color_space_model = VFF_CM_cieRGB;
       break;
     case 8:
       image->color_space_model = VFF_CM_cieXYZ;
       break;
     case 9:
       image->color_space_model = VFF_CM_cieUVW;
       break;
     case 10:
       image->color_space_model = VFF_CM_cieucsUVW;
       break;
     case 11:
       image->color_space_model = VFF_CM_cieucsSOW;
       break;
     case 12:
       image->color_space_model = VFF_CM_cieucsLab;
       break;
     case 13:
       image->color_space_model = VFF_CM_cieucsLuv;
       break;
     case 14:
       image->color_space_model = VFF_CM_GENERIC;
       break;
     case 15: 
       image->color_space_model = VFF_CM_genericRGB;
       break;
   } 

}
