/******************************************************************************
* Cagd_err.c - handler for all cagd library fatal errors.		      *
*******************************************************************************
* Written by Gershon Elber, May. 91.					      *
******************************************************************************/

#include "cagd_loc.h"

typedef struct CagdErrorStruct {
    CagdFatalErrorType ErrorNum;
    char *ErrorDesc;
} CagdErrorStruct;

static CagdErrorStruct ErrMsgs[] =
{
    { CAGD_ERR_180_ARC,			"Attempt to construct a 180 degrees arc" },
    { CAGD_ERR_AFD_NO_SUPPORT,		"No support for such AFD operation." },
    { CAGD_ERR_ALLOC_ERR,		"Memory allocation error" },
    { CAGD_ERR_BSPLINE_NO_SUPPORT,	"Bspline basis type is not supported" },
    { CAGD_ERR_BZR_CRV_EXPECT,		"Bezier curve is expected" },
    { CAGD_ERR_BZR_SRF_EXPECT,		"Bezier surface is expected" },
    { CAGD_ERR_BSP_CRV_EXPECT,		"Bspline curve is expected" },
    { CAGD_ERR_BSP_SRF_EXPECT,		"Bspline surface is expected" },
    { CAGD_ERR_CRV_FAIL_CMPT,		"Cannot make curves compatible" },
    { CAGD_ERR_CRVS_INCOMPATIBLE,	"Curves for requested operation are incompatible" },
    { CAGD_ERR_CUBIC_EXPECTED,		"Cubic polynomial expected." },
    { CAGD_ERR_DEGEN_ALPHA,		"Degenerated Alpha matrix" },
    { CAGD_ERR_DIR_NOT_CONST_UV,	"Dir is not one of CONST_U/V_DIR" },
    { CAGD_ERR_DIR_NOT_VALID,		"Dir is not valid" },
    { CAGD_ERR_INDEX_NOT_IN_MESH,	"Index is out of mesh range" },
    { CAGD_ERR_KNOT_NOT_ORDERED,	"Provided knots are not in ascending order" },
    { CAGD_ERR_LIN_NO_SUPPORT,		"Order below linear is not supported" },
    { CAGD_ERR_NO_CROSS_PROD,		"No cross product for scalar surface" },
    { CAGD_ERR_NOT_ENOUGH_MEM,		"Not enough memory, exit" },
    { CAGD_ERR_NOT_IMPLEMENTED,		"Not implemented" },
    { CAGD_ERR_NUM_KNOT_MISMATCH,	"Number of knots does not match" },
    { CAGD_ERR_OUT_OF_RANGE,		"Data is out of range." },
    { CAGD_ERR_PARSER_STACK_OV,		"Parser Internal stack overflow.." },
    { CAGD_ERR_POWER_NO_SUPPORT,	"Power basis type is not supported" },
    { CAGD_ERR_PT_OR_LEN_MISMATCH,	"PtType or Length mismatch" },
    { CAGD_ERR_POLYNOMIAL_EXPECTED,	"Polynomial Crv/Srf expected." },
    { CAGD_ERR_RATIONAL_EXPECTED,	"Rational Crv/Srf expected." },
    { CAGD_ERR_SCALAR_EXPECTED,		"Scalar entity expected" },
    { CAGD_ERR_SRF_FAIL_CMPT,		"Cannot make surfaces compatible" },
    { CAGD_ERR_SRFS_INCOMPATIBLE,	"Surfaces for requested operation are incompatible" },
    { CAGD_ERR_UNDEF_CRV,		"Undefined curve type" },
    { CAGD_ERR_UNDEF_SRF,		"Undefined surface type" },
    { CAGD_ERR_UNDEF_GEOM,		"Undefined geometry type" },
    { CAGD_ERR_UNSUPPORT_PT,		"Unsupported point type" },
    { CAGD_ERR_T_NOT_IN_CRV,		"Given t is not in curve's parametric domain" },
    { CAGD_ERR_U_NOT_IN_SRF,		"Given u is not in u surface's parametric domain" },
    { CAGD_ERR_V_NOT_IN_SRF,		"Given v is not in v surface's parametric domain" },
    { CAGD_ERR_WRONG_DOMAIN,		"Given parameter is not in domain" },
    { CAGD_ERR_W_NOT_SAME,		"Weights are not identical" },
    { CAGD_ERR_WRONG_CRV,		"Provided curve type is wrong" },
    { CAGD_ERR_WRONG_INDEX,		"Provided index is wrong" },
    { CAGD_ERR_WRONG_ORDER,		"Provided order is wrong" },
    { CAGD_ERR_WRONG_SRF,		"Provided surface type is wrong" },
    { CAGD_ERR_WRONG_PT_TYPE,		"Provided point type is wrong" },
    { CAGD_ERR_CANNOT_COMP_VEC_FIELD,	"Cannot compute vec field/normal" },
    { CAGD_ERR_CANNOT_COMP_NORMAL,	"Cannot compute normal" },
    { CAGD_ERR_REPARAM_NOT_MONOTONE,	"Reparametrization is not monotone" },
    { CAGD_ERR_RATIONAL_NO_SUPPORT,	"Rational function is not supported" },
    { CAGD_ERR_NO_SOLUTION,		"No solution" },
    { CAGD_ERR_TOO_COMPLEX,		"Too complex" },
    { CAGD_ERR_REF_LESS_ORIG,		"Refined object smaller than original" },
    { CAGD_ERR_ONLY_2D_OR_3D,		"Only two or three dimensions are supported" },
    { CAGD_ERR_DOMAIN_TOO_SMALL,	"Parametric domain is too small" },
    { CAGD_ERR_PERIODIC_EXPECTED,	"Periodic geometry expected" },
    { CAGD_ERR_PERIODIC_NO_SUPPORT,	"Periodic geometry is not supported" },
    { CAGD_ERR_OPEN_EC_EXPECTED,	"Open end conditions expected" },

    { CAGD_ERR_UNDEFINE_ERR,		NULL }
};

/*****************************************************************************
* DESCRIPTION:                                                               M
* Returns a string describing a the given error. Errors can be raised by     M
* any member of this cagd library as well as other users. Raised error will  M
* cause an invokation of CagdFatalError function which decides how to handle M
* this error. CagdFatalError can for example, invoke this routine with the   M
* error type, print the appropriate message and quit the program.            M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrorNum:   Type of the error that was raised.                           M
*                                                                            *
* RETURN VALUE:                                                              M
*   char *:     A string describing the error type.                          M
*                                                                            *
* KEYWORDS:                                                                  M
*   CagdDescribeError, error handling                                        M
*****************************************************************************/
char *CagdDescribeError(CagdFatalErrorType ErrorNum)
{
    int i = 0;

    for ( ; ErrMsgs[i].ErrorDesc != NULL; i++)
	if (ErrorNum == ErrMsgs[i].ErrorNum)
	    return ErrMsgs[i].ErrorDesc;

    return "Undefined error";
}
