/* SCCS @(#)win4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                          win4.c                                      */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   win4.c                                              */
/*                                                                      */
/* DESCRIPTION  :   global functions of LaboImage                       */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include "define.h"
#include "global.h"
#include "libwidgets/widgetstructure.h"

#include "win4.h"
#include "LaboImage.layout.h"
#include "dentiste4.h"
#include "convert4.h"

extern Display *gDisplay;
extern char 	gLogname[80];

int	power_2();
int	element();
int     statis();
char    *get_time();
struct  description desc;      /* descripteur d'un fichier-image */

struct description_memoire dir_desc[MAX_IMAGE];
                               /* tableau de descripteurs de plans-image */
                               /* en memoire  
                           */
struct description_memoire buffer_desc[2];


struct directoire_image  dir_image[MAX_IMAGE] = 
     {0, NULL,   0, NULL,   0, NULL,   0, NULL,   0, NULL,
      0, NULL,   0, NULL,   0, NULL,   0, NULL,   0, NULL};
                               /* tableau de pointeurs sur plans-image + */
                               /* indicateur de disponibilite            */

struct directoire_image buffer_image[2];

struct directoire_image dir_vecteur[MAX_VECTEUR] =
     {0, NULL,   0, NULL,   0, NULL,   0, NULL,   0, NULL,
      0, NULL,   0, NULL,   0, NULL,   0, NULL,   0, NULL};


struct description_vecteur dir_desc_vect[MAX_VECTEUR];


int     index_image[8];  /* [0],[2],[4],[6] numero des plans-image de depart */
                         /* pour chaque manipulation                         */
                         /* [1],[3],[5],[7] numero des plans-image d'arrivee */
                         /* pour chaque manipulation                         */
int 	index_vect[4];   /* meme principe */

char	buf[100];

char  repertoire_image[100];
char  repertoire_save[100];

unsigned char code2[4] = {31, 95, 159, 223},
              code3[8] = {15, 47, 79, 111, 143, 175, 207, 239};

extern char *errortabs[];




/* voir UINXClasslib/UINPane.cc
void UINPane::HandleInput(WCallback* wcb)
{
  XEvent* ev = (XEvent *) ((XmDrawingAreaCallbackStruct *)
                           wcb->Data())->event;

  switch(ev->type)
    {
    case KeyPress:
      {
        XKeyEvent *kev = (XKeyEvent *)ev;
        UINPoint pt(kev->x, kev->y);

        char  myChar[1];
        int i = XLookupString(kev, myChar, 1, 0, 0);
fprintf(stderr,"UINPane::KeyPressed  i = %d   k = %d\n", i, myChar[0]-
;
        if ( i == 1)
          if (gFocus !=0)
            gFocus->KeyPressed(myChar[0], pt, parseModifier(kev->stat-
));
      }
*/
/*****************************************************************************/
/*									     */
/* nom	    : element							     */
/*									     */
/* fonction : retourne la taille en byte d'un element de l'image en fonction */
/*            du type de celle-ci.                                           */
/*								             */
/* entrees  : i                         : type de l'image		     */
/*									     */
/* globales : neant                                                          */
/*								             */
/* 
return   : la taille en bytes d'un element d'un plan-image d'une image    */
/*	      de type i.						     */
/*									     */
/* routines : neant                                                          */
/*									     */
/*****************************************************************************/
 

int element(i)

    int i;

{
    switch (i) {
        case -1:
	case 0 : return (1); break; /* unsigned char */
        case 1 : return (2); break; /* short */
        case 2 :  /* integer */
        case 3 :  /* float */
        case 4 :  /* cmplx cart */
        case 5 :  /* cmplx pol */
                 return (4); break;
        case 6 : return (1);
    }
}


/*****************************************************************************/
/*									     */
/* nom      : statis							     */
/*									     */
/* fonction : calcule min, max, moyenne et ecart type d'une image	     */
/*                                                                           */
/* entrees  : unsigned char *image    : plan-image a traiter		     */
/*            short type,nli,nco      : type,nb lignes,nb colonnes de l'image*/
/*            float *mmin,*mmax,*mu,*ecart : min, max, moyenne, ecart type   */
/*								             */
/* globales : neant                                                          */
/*                                                                           */
/* return   : neant                                                          */
/*									     */
/* routines : neant                                                          */
/*                                                                           */
/*****************************************************************************/
 
int statis (image, type, nli, nco, mmin, mmax, mu, ecart)
    unsigned char *image;
    short type, nli, nco;
    float *mmin, *mmax, *mu, *ecart;
{
    register unsigned char *b;
    register short *s;
    register int *i, n;
    register float *ff;
    register float   t, q, f, r;
    int     taille;

    taille = nli * nco; 
    t = 0;
    switch (type){
	case -1:
	case 0:
	    b = (unsigned char *) image; 
            *mmin = *mmax = *mu = (float ) *b;
	    b++;
	    for ( n = 2 ; n <= taille ; n++ ) {
		f = (float) *b;  b++;
		if ( f > *mmax ) *mmax = f;
		else if ( f < *mmin ) *mmin = f;
		q = f - *mu;
		r = q / n;
		*mu = *mu + r;
		t = t + ( n - 1 ) * q * r;
	    }
	    break;
	case 1:
	    s = (short *) image;
	    *mmin = *mmax = *mu = (float) *s;
	    s++;
	    for ( n = 2 ; n <= taille ; n++ ) {
		f = (float) *s;  s++;
		if ( f > *mmax ) *mmax = f;
		else if ( f < *mmin ) *mmin = f;
		q = f - *mu;
		r = q / n;
		*mu = *mu + r;
		t = t + ( n - 1 ) * q * r;
	    }
	    break;
	case 2:
	    i = (int *) image;
	    *mmin = *mmax = *mu = (float) *i;
	    i++;
	    for ( n = 2 ; n <= taille ; n++ ) {
		f = (float) *i;  i++;
		if ( f > *mmax ) *mmax = f;
		else if ( f < *mmin ) *mmin = f;
		q = f - *mu;
		r = q / n;
		*mu = *mu + r;
		t = t + ( n - 1 ) * q * r;
	    }
	    break;
	case 3:
	    ff = (float *) image;
            *mmin = *mmax = *mu = *ff;
	    ff++;
	    for ( n = 2 ; n <= taille ; n++ ) {
		f = *ff;  ff++;
		if ( f > *mmax ) *mmax = f;
		else if ( f < *mmin ) *mmin = f;
		q = f - *mu;
		r = q / n;
		*mu = *mu + r;
		t = t + ( n - 1 ) * q * r;
	    }
	    break;
    }
    *ecart = (float) sqrt (t / (taille-1));    
}


/*****************************************************************************/
/*									     */
/* nom      : get_time							     */
/*									     */
/* fonction : retourne la date et l'heure sous forme d'un string             */
/*                                                                           */
/* entrees  : neant                                                          */
/*							                     */
/* globales : neant                                                          */
/*									     */
/* return   : char *date                : string contenant date et heure     */
/*									     */
/* routines : neant                                                          */
/*									     */
/*****************************************************************************/
     
char *get_time()

{
    struct  timeval tp;
    struct  timezone tzp;
    char    *date;
    long    clock;
    
    gettimeofday (&tp,&tzp);
    clock = tp.tv_sec;
    date = (char *) calloc (26,sizeof(char));
    strcpy (date, asctime (localtime(&clock)));
    return (date);
}


/****************************************************************************/


int power_2 (s)

    short s;

    {
    unsigned short us = (unsigned short)s;
    if (s < 2) return(FALSE);
    else {
        for (; (us & 01) == 0; us >>= 1);
        if (us == 01) return(TRUE); else return(FALSE);
    }
}



/*********************************************************************/
/* procedures pour ecrire dans le help-window in the desired format  */
/*********************************************************************/
void format_to_windowsize(filename,line)
 char filename[30];
 char **line;
{
 int i, j, k, car;
 char *nline;
 FILE *fp;

 free(*line);
 fp=fopen(filename, "r");
 if (fp == NULL){
    *line = NULL;
    return;
 }
 nline = (char *)calloc(1,(sizeof(char)));

 j=1;
 k=0;
 car = getc(fp);
 while (car  != EOF)
 {
     nline= (char *) realloc(nline,(k+1)*sizeof(char));
     *(nline + k)= car;
     ++k; j++;

     if ((j < 53) && (car == '\n'))
       j=0;
     else if ((j > 43) && 
	      ((car == ' ') || (car == '.')|| (car == ',')))
     {
       nline= (char *) realloc(nline,(k+1)*sizeof(char));
       *(nline + k)= '\n';
       ++k;
       j=0;
     }
     car=getc(fp);
 }
 nline= (char *) realloc(nline,(k+1)*sizeof(char));
 *(nline + k)='\n';
 nline= (char *) realloc(nline,(k+2)*sizeof(char));
 *(nline + k+1)='\n';
 nline= (char *) realloc(nline,(k+3)*sizeof(char));
 *(nline + k+2)='\0';

 *line = nline;

 fclose(fp);
}



/*****************************************************************************/
/*                							     */
/* nom      : write_master						     */
/*									     */
/* fonction : ecrit le message pointe par buf dans la fenetre                */
/*            de commande et met a jour le log-file "image.log"  	     */
/*									     */
/* entrees  : char *buff                 : message a ecrire                   */
/*									     */
/*****************************************************************************/

int write_master (buff)
    char * buff;
{
  int n;
  Arg args[4];
  XmTextPosition position;
  FILE *log_name;

  if (buff == NULL) 
      return 0;
  else 
  {
    position = XmTextGetLastPosition (Comment_Area); 
    XmTextInsert(Comment_Area, position, buff);

    XmTextShowPosition(Comment_Area, XmTextGetLastPosition(Comment_Area));

    if ((log_name = fopen(gLogname,"a")) != NULL)
    {  
      fwrite(buff, strlen(buff), 1, log_name);
      fclose(log_name);
    }
    return(0);
  }
}


/*****************************************************************************/
/*                							     */
/* nom      : write_help						     */
/*									     */
/* fonction : ecrit le message help pointe par buf dans la fenetre           */
/*            de help						  	     */
/*									     */
/* entrees  : char *buf                 : message a ecrire                   */
/*									     */
/*								             */
/*****************************************************************************/
int write_help(filename)
char filename[60];
{
  char * buff;
  int i;
  XmTextPosition position;

  format_to_windowsize(filename,&buff);

  if (buff == NULL) 
      return (0);
  else 
  {
    position = XmTextGetLastPosition (Help_Area);
    XmTextInsert(Help_Area, position, buff);

    XmTextShowPosition(Help_Area, XmTextGetLastPosition(Help_Area));

    free(buff);
    return(0);
  }
}


/*****************************************************************************/
/*                							     */
/* nom      : write_erreur						     */
/*									     */
/* fonction : selectionne le message d'erreur a ecrire dans la fenetre       */
/*            de commande et l'Ecrit.				  	     */
/*									     */
/* entrees  : int no                    : numero du message d'erreur a ecrire*/
/*									     */
/* globales : char *buf  		: message d'erreur a imprimer        */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : write_master						     */
/*								             */
/*****************************************************************************/

void write_erreur (no)  
    int no;
{
    XBell(gDisplay, 10);
    strcpy (buf, " *** ");
    switch (no) {
        case 1 : strcat (buf,errortabs[0]); break;
        case 2 : strcat (buf,errortabs[1]); break;
        case 3 : strcat (buf,errortabs[2]); break;
        case 4 : strcat (buf,errortabs[3]); break;
        case 5 : strcat (buf,errortabs[4]); break;
        case 6 : strcat (buf,errortabs[5]); break;
        case 9 : strcat (buf,errortabs[6]); break;
        case 10: strcat (buf,errortabs[7]); break;
        case 11: strcat (buf,errortabs[8]); break;
        case 12: strcat (buf,errortabs[9]); break;
        case 13: strcat (buf,errortabs[10]);break;
        case 14: strcat (buf,errortabs[11]);break;
        case 15: strcat (buf,errortabs[12]);break;
	case 16: strcat (buf,errortabs[13]);break;
	case 17: strcat (buf,errortabs[14]);break;
	case 18: strcat (buf,errortabs[15]);break;
	case 19: strcat (buf,errortabs[16]);break;
	case 20: strcat (buf,errortabs[17]);break;
        case 21: strcat (buf,errortabs[18]);break;
	case 30: strcat (buf,errortabs[19]);break;
        case 40: strcat (buf,errortabs[55]);break;
	case 90: strcat (buf,errortabs[20]);break;
	case 91: strcat (buf,errortabs[21]);break;
	case 92: strcat (buf,errortabs[56]);break;
	case 93: strcat (buf,errortabs[57]);break;
	case 94: strcat (buf,errortabs[58]);break;
	case 95: strcat (buf,errortabs[59]);break;
	case 96: strcat (buf,errortabs[60]);break;
	case 97: strcat (buf,errortabs[61]);break;
	case 98: strcat (buf,errortabs[62]);break;
	case 99: strcat (buf,errortabs[63]);break;
	case 100: strcat (buf,errortabs[64]); break;
	case 101: strcat (buf,errortabs[65]); break;
	case 102: strcat (buf,errortabs[66]); break;
	case 103: strcat (buf,errortabs[67]); break;
	case 104: strcat (buf,errortabs[68]); break;
	case 105: strcat (buf,errortabs[69]); break;  
 	case 106: strcat (buf,errortabs[70]); break; 
	case 107: strcat (buf,errortabs[71]); break; 
	case 900: strcat (buf,errortabs[22]); break;
	case 910: strcat (buf,errortabs[23]); break;
	case 911: strcat (buf,errortabs[24]); break;
	case 912: strcat (buf,errortabs[25]); break;
	case 920: strcat (buf,errortabs[26]); break;
	case 930: strcat (buf,errortabs[27]); break;
	case 931: strcat (buf,errortabs[28]); break;
	case 940: strcat (buf,errortabs[29]); break;
	case 941: strcat (buf,errortabs[30]); break;
	case 942: strcat (buf,errortabs[31]); break;
	case 950: strcat (buf,errortabs[32]); break;
	case 951: strcat (buf,errortabs[33]); break;
	case 952: strcat (buf,errortabs[34]); break;
	case 953: strcat (buf,errortabs[35]); break;
	case 954: strcat (buf,errortabs[36]); break;
	case 955: strcat (buf,errortabs[37]); break;
	case 956: strcat (buf,errortabs[38]); break;
	case 957: strcat (buf,errortabs[39]); break;
	case 958: strcat (buf,errortabs[40]); break;
	case 959: strcat (buf,errortabs[41]); break;
	case 960: strcat (buf,errortabs[42]); break;
	case 970: strcat (buf,errortabs[30]); break;
	case 971: strcat (buf,errortabs[43]); break;
	case 972: strcat (buf,errortabs[44]); break;
	case 973: strcat (buf,errortabs[45]); break;
	case 974: strcat (buf,errortabs[46]); break;
	case 975: strcat (buf,errortabs[47]); break;
	case 976: strcat (buf,errortabs[48]); break;
	case 977: strcat (buf,errortabs[49]); break;
	case 978: strcat (buf,errortabs[50]); break;
	case 979: strcat (buf,errortabs[51]); break;
	case 980: strcat (buf,errortabs[52]); break;
	case 981: strcat (buf,errortabs[53]); break;
	case 982: strcat (buf,errortabs[54]); break;
	case 983: strcat (buf,errortabs[72]); break;
	case 984: strcat (buf,errortabs[75]); break;
	case 985: strcat (buf,errortabs[76]); break;
	case 986: strcat (buf,errortabs[77]); break;
	case 987: strcat (buf,errortabs[78]); break;
	case 988: strcat (buf,errortabs[73]); break;
    }
    strcpy (buf, strcat (buf, "\n"));
    write_master (buf);
    write_master (NULL);
    return;
}



/*****************************************************************************/
/*                							     */
/* nom      : init_color    						     */
/*									     */
/* fonction : construit une table de couleur RGB avec 3 bits R,              */
/*            3 bits G, 2 bits B.                               	     */
/*									     */
/* entrees  : unsigned char color[3][256] : table de couleur RGB             */
/*									     */
/* globales : neant					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

Colormap init_color ()
  
{
    Colormap my_colormap;
    XColor Colors[MAXCOLORS];
    int i=0, r, g, b;

    my_colormap = 
       XCreateColormap (gDisplay, DefaultRootWindow (gDisplay),
			DefaultVisual(gDisplay, DefaultScreen(gDisplay)),
			AllocAll);

    for (r=0; r<8; r++)
        for (g=0; g<8; g++)
            for (b=0; b<4; b++) {
		Colors[i].red = code3[r] * 257;
                Colors[i].green = code3[g] * 257;
                Colors[i].blue = code2[b] * 257;
		Colors[i].pixel = i;
		Colors[i].flags = DoRed|DoGreen|DoBlue;
                i++;
	    }

    XStoreColors (gDisplay, my_colormap, Colors, MAXCOLORS);
    return (my_colormap);
}

/*****************************************************************************/
/*                							     */
/* nom      : init_color_lin						     */
/*									     */
/* fonction : construit une table de couleur RGB pour 256 niveaux de gris    */
/*            lineaires.                                                     */
/*									     */
/* entrees  : unsigned char color[3][256] : table de couleur RGB             */
/*									     */
/* globales : neant					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

Colormap init_color_lin ()

{
    Colormap my_colormap;
    XColor Colors[MAXCOLORS];
    int i;
    
    my_colormap = 
       XCreateColormap (gDisplay, DefaultRootWindow (gDisplay),
			DefaultVisual(gDisplay, DefaultScreen(gDisplay)),
			AllocAll);

    for ( i = 0 ; i < MAXCOLORS ; i++) {
	Colors[i].red = Colors[i].green = Colors[i].blue = i * 257;
  	Colors[i].pixel = i;
	Colors[i].flags = DoRed|DoGreen|DoBlue;
    } 
    XStoreColors(gDisplay, my_colormap, Colors, MAXCOLORS);
    return (my_colormap);
}



/*****************************************************************************/
/*                							     */
/* nom      : init_color_lin_I						     */
/*									     */
/* fonction : construit une table de couleur RGB pour 256 niveaux de gris    */
/*            lineaires, mais inversee.                                                     */
/*									     */
/* entrees  : unsigned char color[3][256] : table de couleur RGB             */
/*									     */
/* globales : neant					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

Colormap init_color_lin_I ()

{
    Colormap my_colormap;
    XColor Colors[MAXCOLORS];
    int i,j;
    
    my_colormap = 
       XCreateColormap (gDisplay, DefaultRootWindow (gDisplay),
			DefaultVisual(gDisplay, DefaultScreen(gDisplay)),
			AllocAll);

    for ( i = 0, j = MAXCOLORS-1 ; i < MAXCOLORS ; i++,j--) {
	Colors[i].red = Colors[i].green = Colors[i].blue = i * 257;
  	Colors[i].pixel = j;
	Colors[i].flags = DoRed|DoGreen|DoBlue;
    } 
    XStoreColors(gDisplay, my_colormap, Colors, MAXCOLORS);
    return (my_colormap);
}

/*****************************************************************************/
/*                							     */
/* nom      : init_color_log						     */
/*									     */
/* fonction : construit une table de couleur RGB pour 256 niveaux de gris    */
/*            logarithmiques.                                                */
/*									     */
/* entrees  : unsigned char color[3][256] : table de couleur RGB             */
/*									     */
/* globales : neant					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

Colormap init_color_log ()

{
    Colormap my_colormap;
    XColor Colors[MAXCOLORS];
    int i;
    float e = exp(1.0);

    my_colormap = 
       XCreateColormap (gDisplay, DefaultRootWindow (gDisplay),
			DefaultVisual(gDisplay, DefaultScreen(gDisplay)),
			AllocAll);

    for ( i = 0 ; i < MAXCOLORS ; i++) {
	Colors[i].red = Colors[i].green = Colors[i].blue =  
	  (65535.0 * log (1.0 + (float)(i * 257) / 65535.0 * (e - 1.0)));
	Colors[i].pixel = i;
	Colors[i].flags = DoRed|DoGreen|DoBlue;
    } 
    XStoreColors(gDisplay, my_colormap, Colors, MAXCOLORS);
    return (my_colormap);
}



/*****************************************************************************/
/*                							     */
/* nom      : init_color_log_I						     */
/*									     */
/* fonction : construit une table de couleur RGB pour 256 niveaux de gris    */
/*            logarithmiques.                                                */
/*									     */
/* entrees  : unsigned char color[3][256] : table de couleur RGB             */
/*									     */
/* globales : neant					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

Colormap init_color_log_I ()

{
    Colormap my_colormap;
    XColor Colors[MAXCOLORS];
    int i,j;
    float e = exp(1.0);

    my_colormap = 
       XCreateColormap (gDisplay, DefaultRootWindow (gDisplay),
			DefaultVisual(gDisplay, DefaultScreen(gDisplay)),
			AllocAll);

    for ( i = 0, j = MAXCOLORS-1 ; i < MAXCOLORS ; i++, j--) {
	Colors[i].red = Colors[i].green = Colors[i].blue =  
	  (65535.0 * log (1.0 + (float)(i * 257) / 65535.0 * (e - 1.0)));
	Colors[i].pixel = j;
	Colors[i].flags = DoRed|DoGreen|DoBlue;
    } 
    XStoreColors(gDisplay, my_colormap, Colors, MAXCOLORS);
    return (my_colormap);
}


/*****************************************************************************/
/*                							     */
/* nom      : init_seuil						     */
/*									     */
/* fonction : construit une table de couleur RGB binaire (seuil = 128)	     */
/*            lineaires.                                                     */
/*									     */
/* entrees  : unsigned char Thr[3][256] : table de couleur RGB		     */
/*									     */
/* globales : neant					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

Colormap init_seuil (Threshold)
    int Threshold;

{
    Colormap my_colormap;
    XColor Colors[MAXCOLORS];
    int i;

    my_colormap = 
       XCreateColormap (gDisplay, DefaultRootWindow (gDisplay),
			DefaultVisual(gDisplay, DefaultScreen(gDisplay)),
			AllocAll);

    for ( i = 0 ; i < Threshold; i++) {
     Colors[i].red = Colors[i].green = Colors[i].blue = 0;
     Colors[i].flags = DoRed|DoGreen|DoBlue;
     Colors[i].pixel = i;
    }
    for ( i = Threshold; i < MAXCOLORS; i++) {
     Colors[i].red = Colors[i].green = Colors[i].blue = 65535;
     Colors[i].flags = DoRed|DoGreen|DoBlue;
     Colors[i].pixel = i;
    }
    XStoreColors (gDisplay, my_colormap, Colors, MAXCOLORS);
  
    return (my_colormap);
}


/*****************************************************************************/
/*                							     */
/* nom      : init_color    						     */
/*									     */
/* fonction : construit une table de couleur RGB avec 3 bits R,              */
/*            3 bits G, 2 bits B.                               	     */
/*									     */
/* entrees  : unsigned char color[3][256] : table de couleur RGB             */
/*									     */
/* globales : neant					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

Colormap init_color_profile ()
{
    Colormap my_colormap;
    XColor Colors[MAXCOLORS];
    int N;

    my_colormap = 
       XCreateColormap (gDisplay, DefaultRootWindow (gDisplay),
			DefaultVisual(gDisplay, DefaultScreen(gDisplay)),
			AllocAll);

    Colors[0].red = Colors[0].green = Colors[0].blue = 255 * 257;
    Colors[0].pixel = 0;
    Colors[0].flags = DoRed|DoGreen|DoBlue;
    
    for (N = 1 ; N < 256 ; N++)
    {
       Colors[N].red = Colors[N].green = Colors[N].blue = (N+1) * 257;
       Colors[N].pixel = N;
       Colors[N].flags = DoRed|DoGreen|DoBlue;
       for (N = 0 ; N < MAX_PROFIL ; N++) {
       Colors[N+2].red = Colors[N+2].green = 
                    Colors[N+2].blue = (128 + (random() % 100)) * 257;
       Colors[N+2].pixel = N+2;
       Colors[N+2].flags = DoRed|DoGreen|DoBlue;
       }
     }

    XStoreColors (gDisplay, my_colormap, Colors, MAXCOLORS);
    return (my_colormap);
}


void proc_libere (mode)
    int mode;
{
    int i;
    switch (mode){
	case 0: /* liberer tous les plans */
		sprintf(buf, mastertabs[1]);
		write_master(buf);
		for (i=0; i<MAX_IMAGE; i++)
		    if (dir_image[i].image != NULL){
			free(dir_image[i].image);
			dir_image[i].image = NULL;
		    }
	    break;
	case 1: /* liberer 1 plan */
		sprintf (buf, mastertabs[2]);
		write_master(buf);
		sprintf (buf, "no %d\n\0", index_image[0]);
		write_master(buf);
		if (dir_image[index_image[0]].image != NULL){
		    free(dir_image[index_image[0]].image);
		    dir_image[index_image[0]].image = NULL;
		}
	    break;
	case 2: /* liberer tous les vecteurs */
		sprintf(buf, mastertabs[3]);
		write_master(buf);
		for (i=0; i<MAX_VECTEUR; i++)
		    liberer_vecteur(i);  /*voir fichier dentiste.c*/
	    break;
	case 3: /* liberer 1 vecteur */
		sprintf (buf, mastertabs[4]);
		write_master(buf);
		sprintf (buf, "no %d\n\0", index_vect[0]);
		write_master(buf);
		liberer_vecteur(index_vect[0]);
	    break;
    }    
}


/*****************************************************************************/
/*									     */
/* nom      : gen_bandes						     */
/*									     */
/* fonction : declenche la construction d'une image-bandes a niveaux de gris */
/*            et construit une image 256x256 composee de bandes verticales   */
/*	      de niveaux de gris etale entre blanc et noir.		     */
/*                                                                           */
/* entrees  : int nbr_bandes		: nbr de bandes de couleur differente*/
/*                                                                           */
/*****************************************************************************/

int gen_bandes (image, nbr_bandes)
    unsigned char **image;
    int nbr_bandes;
{
    int i, j, n, largeur;
    unsigned char valeur, *d, *ima;

    d = (unsigned char *) malloc (256); 

    /* Allocation of memory space for the resultant image */
    ima = *image = (unsigned char *) malloc (256 * 256);

    if (!*image) return (-1);

    largeur = (int) (256 / nbr_bandes);
    j = 0;
    for (n = 0; n < nbr_bandes; n++) {
        valeur = (unsigned char) (n * largeur); 
        for (i = 0; i < largeur; i++) {
            d[j++] = valeur;
	}
    }
    for (j = 0; j < 256; j++) {
	for (i = 0; i < 256; i++) {
	    *ima = d[i];
            ima++;
	}
    }
    free(d);
    return 0;
}



/**************************************************************************/
/* lib/xor.c                                                              */
/**************************************************************************/


GC xs_create_xor_gc(w)
   Widget            w;
{
  XGCValues values;
  GC        gc;
  Arg       wargs[10];
  /*
   * Get the colors used by the widget.
   */

/*
  XtSetArg(wargs[0], XtNforeground, &values.foreground);
  XtSetArg(wargs[1], XtNbackground, &values.background);
  XtGetValues(w, wargs,2);
*/
  /*
   * Set the fg to the XOR of the fg and bg, so if it is
   * XOR'ed with bg, the result will be fg and vice-versa.
   * This effectively achieves inverse video for the line.
   */
/*
  values.foreground = values.foreground ^ values.background;
*/
  /*
   * Set the rubber band gc to use XOR mode and draw 
   * a dashed line.
   */
/*  values.line_style = LineOnOffDash;*/
  values.function   = GXxor;
  gc = XtGetGC(w, GCForeground | GCBackground | 
               GCFunction, &values);
  return gc;
}


GC xs_create_and_gc(w)
   Widget            w;
{
  XGCValues values;
  GC        gc;
  Arg       wargs[10];
  /*
   * Get the colors used by the widget.
   */

  values.function   = GXand;
  gc = XtGetGC(w, GCForeground | GCBackground | 
               GCFunction, &values);
  return gc;
}


GC xs_create_notand_gc(w)
   Widget            w;
{
  XGCValues values;
  GC        gc;
  Arg       wargs[10];
  /*
   * Get the colors used by the widget.
   */

  values.function   = GXandReverse;
  gc = XtGetGC(w, GCForeground | GCBackground | 
               GCFunction, &values);
  return gc;
}


/****************************************************************/
/*								*/
/*  nom	:	free_liste_pts					*/
/*								*/
/*  fonction:	libere la liste des points pointee par pptr .   */
/*								*/
/*  entrees :	ptr_point   pptr                                */
/*								*/
/*  globales:   ---                                             */ 
/*                                                              */
/*  return  :	---						*/
/*								*/
/*  routines:	---		 				*/
/*								*/ 
/****************************************************************/

void 
free_liste_pts(pptr)
ptr_point   *pptr;
{
    ptr_point   p;

    while (*pptr != NULL)
    {
	p = *pptr;
	*pptr = (*pptr) -> next;
	cfree(p);
    }
}

