/* SCCS @(#)pre_pro.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                            pre_pro.layout.c                          */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   pre_pro.layout.c                                    */
/*                                                                      */
/* DESCRIPTION  :   Interface for preprocessing operations              */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "libwidgets/widgetstructure.h"
#include "pre_pro.layout.h"

#include "LaboMorphoBin.callback.h"

#define MAX_ARGS 100

#define PREPRO_HISTO_EQUA 1
#define PREPRO_CORRECT_BACKGROUND 2
#define PRO_TRANSFORMS_COMPLEX 31
#define PRO_TRANSFORMS_COMPLEX_inv 32
#define PRO_TRANSFORMS_COMPLEX_opt 33
#define PRO_TRANSFORMS_COMPLEX_opt_inv 34
#define PRO_TRANSFORMS_REAL 41
#define PRO_TRANSFORMS_REAL_opt 42
#define PRO_CONVOL_CREATE_MASK 5
#define PRO_CONVOL_WITH_IMAGE 61
#define PRO_CORREL_WITH_IMAGE 62
#define PRO_EDGES_SOBEL_RAC 71
#define PRO_EDGES_SOBEL_ABS 72
#define PRO_EDGES_LAPLA_1 73
#define PRO_EDGES_LAPLA_2 74
#define PRO_EDGES_LAPLA_3 75
#define PRO_EDGES_ROBER_RAC 76
#define PRO_EDGES_ROBER_ABS 77
#define PRO_EDGES_FREI 78
#define PRO_EDGES_MERO 79
#define PRO_EDGES_ZERO 70

#define PREPRO_ENHANC_MEDIAN 8
#define PREPRO_ENHANC_HIGH_PASS 9
#define PREPRO_HAMMING 10
#define PREPRO_HANNING  11
#define PREPRO_GAUSSIAN 12
#define PRO_LAPLACIAN_PERCENTIL_HISTO 13
#define PRO_DYNAMIC_THRESHOLD 14
#define PRO_CONVOL_WITH_MASK 15
#define PRO_CORREL_WITH_MASK 16
#define PRO_EDGES_RIDGE_RIDING 17

#define PRO_ERO_SPHERE 80
#define PRO_ERO_CONE 81
#define PRO_ERO_CYLINDER 82
#define PRO_ERO_GAUSS 83
#define PRO_DILA_SPHERE 84
#define PRO_DILA_CONE 85
#define PRO_DILA_CYLINDER 86
#define PRO_DILA_GAUSS 87
#define PRO_OPEN_SPHERE 88
#define PRO_OPEN_CONE 89
#define PRO_OPEN_CYLINDER 90
#define PRO_OPEN_GAUSS 91
#define PRO_CLOS_SPHERE 92
#define PRO_CLOS_CONE 93
#define PRO_CLOS_CYLINDER 94
#define PRO_CLOS_GAUSS 95
#define PRO_ERO_PLAN 96
#define PRO_DILA_PLAN 97
#define PRO_OPEN_PLAN 98
#define PRO_CLOS_PLAN 99


#define MEASHISTCAL 200
#define MEASHISTSHO 201
#define MEASHISTPRINT 202

#define MEASIMASTAT 203

#define MEASCOLOF8 210
#define MEASCOLOF4 211
#define MEASCOLOC8 212
#define MEASCOLOC4 213
#define MEASCOLOSAVE 214

#define MEASPOWCAL 215
#define MEASPOWCUT 216

#define GEL_INIT 300
#define GEL_SHOW 301

#define ROI_SAVE_DISPLAY 310

#define ROI_LIRE_ZONE 320

#define REG_GROWING 400
#define REG_GROWING_SAVE_CONTOUR 401
#define REG_GROWING_SAVE_REGION 402

extern XmFontList gFontlist, gSmall_fontlist; 
extern Widget gLabowidget;

static void Create_One_planeinput_One_planeoutput();
static void Create_One_planeinput_Two_planeoutput();
static void Create_Two_planeinput_One_planeoutput();
static void Create_Two_planeinput_Two_planeoutput();
static void Create_One_planeinput();
static void Create_One_planeoutput();

/********************************************************
/   Creation Function for PRE_PRO_options_widget 
/*******************************************************/

Widget
build_PRE_PRO_options_widget(PRE_PRO_options, option, message)
	Widget PRE_PRO_options;
	int option;
	char *message;
{
	Widget PRE_PRO_options_widget;
	Widget options_separator;
	Widget PRE_PRO_options_separator;
	Widget PRE_PRO_options_command;
	Widget options_CANCEL;
	Widget options_OK;
	Widget options_HELP;
	Widget PRE_PRO_options_form1;
	Widget selectplaneinput;
	Widget selectplaneoutput;
        xs_struc_paramprepro * StrucParametres;
	Widget file_selection;
	Arg args[MAX_ARGS];
	int n;

	/* Creating PRE_PRO_options_widget Widget */ 

	n = 0;
	if ((option == PREPRO_CORRECT_BACKGROUND) || 
	(option == PREPRO_ENHANC_MEDIAN) ||
	(option == PREPRO_ENHANC_HIGH_PASS) ||
	((option >= PRO_LAPLACIAN_PERCENTIL_HISTO) && 
	 (option <= PRO_EDGES_RIDGE_RIDING)) ||
	((option >= PRO_ERO_SPHERE) && (option <= PRO_CLOS_GAUSS)) ||
	((option >= 130) && (option <= 137)) ||	
	((option >= 140) && (option <= 142)) ||	
	((option >= 150) && (option <= 154)) ||
	((option >= 180) && (option <= 194)) ||
	(option == MEASHISTSHO) || (option == MEASHISTCAL) || 
	(option ==  PRO_CONVOL_CREATE_MASK)) { 
	  XtSetArg(args[n],XmNwidth,560); n++;
	  XtSetArg(args[n],XmNheight,357); n++; 
	}
	else if ((option == MEASPOWCUT) ||
		 (option == PREPRO_HAMMING) ||
		 (option == PREPRO_HANNING) || 
		 (option == PREPRO_GAUSSIAN)){ 
	  XtSetArg(args[n],XmNwidth,590); n++;
	  XtSetArg(args[n],XmNheight,380); n++; 
	}

	else if (option == MEASPOWCAL) 
	{	
	  XtSetArg(args[n],XmNwidth,560); n++; 
	  XtSetArg(args[n],XmNheight,200); n++; 
	}
	else if (option == GEL_INIT) 
	{   
	  XtSetArg(args[n],XmNwidth,700); n++;  
	  XtSetArg(args[n],XmNheight,150); n++; 
	}
	else if ((option == MEASHISTPRINT) || (option == MEASCOLOSAVE))
	{
	  XtSetArg(args[n],XmNwidth,850); n++; 
	  XtSetArg(args[n],XmNheight,330); n++;
	}
	else if ((option == MEASIMASTAT) || (option == ROI_SAVE_DISPLAY) || 
		 (option == ROI_LIRE_ZONE) || (option == REG_GROWING) ||
		 (option == REG_GROWING_SAVE_CONTOUR) ||
		 (option == REG_GROWING_SAVE_REGION))
	{  
	  XtSetArg(args[n],XmNwidth,300); n++;
	  XtSetArg(args[n],XmNheight,150); n++;
	}
	else 
	{
	  XtSetArg(args[n],XmNwidth,340); n++;
	  XtSetArg(args[n],XmNheight,350); n++;
	}

	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNx,69); n++;
	XtSetArg(args[n],XmNy,124); n++;
	XtSetArg(args[n],XmNdialogTitle, 
		XmStringLtoRCreate(message, XmSTRING_DEFAULT_CHARSET)); n++;

	PRE_PRO_options_widget =
		XmCreateFormDialog(gLabowidget,"PRE_PRO_options_widget",args,n);

        if ((option != MEASHISTPRINT) && (option != MEASCOLOSAVE))
	{
	  /* Creating PRE_PRO_options_command Widget */ 

	  n = 0;
	  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

	  PRE_PRO_options_command = 
	      XmCreateForm(PRE_PRO_options_widget,
		          "PRE_PRO_options_command",args,n);
	  XtManageChild(PRE_PRO_options_command);

	  /* Creating options_CANCEL Widget */ 

	  n = 0;
	  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		   XmStringLtoRCreate(paneltabs[398],
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition,68); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,96); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	  options_CANCEL = 
	        XmCreatePushButton(PRE_PRO_options_command,
				   "options_CANCEL",args,n);
	  XtManageChild(options_CANCEL);

	  /* Adding Callbacks for options_CANCEL */ 

	  XtAddCallback(options_CANCEL,
	       XmNactivateCallback,PRE_PRO_options_CANCEL_callb,
			PRE_PRO_options_widget);

	  /* Creating options_OK Widget */ 

	  n = 0;
	  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNfontList,gFontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("OK",
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition,4); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,32); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	  options_OK = 
	    XmCreatePushButton(PRE_PRO_options_command,"options_OK",args,n);
	  XtManageChild(options_OK);


	  /* Creating options_HELP Widget */ 

	  n = 0;
	  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[312],
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition,36); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,64); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNsensitive, False); n++;

	  options_HELP = 
	  XmCreatePushButton(PRE_PRO_options_command,"options_HELP",args,n);
	  XtManageChild(options_HELP);


	  /* Creating PRE_PRO_options_separator Widget */ 

	  n = 0;
	  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	  XtSetArg(args[n],XmNbottomWidget, PRE_PRO_options_command); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	  PRE_PRO_options_separator = 
		XmCreateSeparator(PRE_PRO_options_widget,
				  "PRE_PRO_options_separator",args,n);

	  XtManageChild(PRE_PRO_options_separator);
	}
	
	if ((option == PREPRO_CORRECT_BACKGROUND) ||
	    ((option >= PREPRO_ENHANC_MEDIAN) && 
	     (option <= PRO_EDGES_RIDGE_RIDING)) || 
	    ((option >= PRO_ERO_SPHERE) && (option <= PRO_CLOS_GAUSS)) ||
	    ((option >= 130) && (option <= 137)) ||
	    ((option >= 140) && (option <= 142)) ||	
	    ((option >= 150) && (option <= 154)) ||
	    ((option >= 180) && (option <= 194)) ||
	    (option == MEASHISTSHO) || (option == MEASPOWCAL) ||  
	    (option == MEASHISTCAL) ||
	    (option == MEASPOWCUT) || (option == PRO_CONVOL_CREATE_MASK) ||
	    (option == GEL_INIT)) 
	{

	  /* Creating options_separator Widget */ 

	  n = 0;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	  XtSetArg(args[n],XmNbottomWidget,PRE_PRO_options_command); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition,54); n++; 
	  XtSetArg(args[n],XmNorientation,XmVERTICAL); n++;

	  options_separator =  
	          XmCreateSeparator(PRE_PRO_options_widget,
				    "options_separator",args,n);
	  XtManageChild(options_separator);
	}

	/* Creating PRE_PRO_options_form1 Widget */ 

	n = 0;
        if ((option == MEASHISTPRINT) || (option == MEASCOLOSAVE))
	{
	  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	}
        else
	{
	  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	  XtSetArg(args[n],XmNbottomWidget,PRE_PRO_options_separator); n++;
	}
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	PRE_PRO_options_form1 = 
	  XmCreateForm(PRE_PRO_options_widget,"PRE_PRO_options_form1",args,n);
	XtManageChild(PRE_PRO_options_form1);


switch (option) {
 case GEL_INIT:

  /* Creating StrucParametres Widget */ 

  StrucParametres =     
	build_GEL1D_param_widget(PRE_PRO_options_form1);

   n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_One_planeinput(PRE_PRO_options_form1, options_OK, paneltabs[105]);
  break;


  case 130: case 133: case 136: case 137: case 140: case 141: case 142:
  case 150: case 151: case 152: case 153: case 154: case 180:
  case 181: case 182: case 190: case 191: case 192: case 193: case 194:

  /* Creating StrucParametres Widget */ 

  StrucParametres =     
	build_MORPHO_param_widget(PRE_PRO_options_form1, 1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_One_planeinput_One_planeoutput(PRE_PRO_options_form1, options_OK, 
					paneltabs[105], paneltabs[105]);
  break;

  case PREPRO_HISTO_EQUA: ;
  case PRO_EDGES_SOBEL_RAC: ;
  case PRO_EDGES_SOBEL_ABS: ;
  case PRO_EDGES_LAPLA_1: ;
  case PRO_EDGES_LAPLA_2: ;
  case PRO_EDGES_LAPLA_3: ;
  case PRO_EDGES_ROBER_RAC: ;
  case PRO_EDGES_ROBER_ABS: ;
  case PRO_EDGES_FREI: ;
  case PRO_EDGES_MERO: ;
  case PRO_EDGES_ZERO: 
  case 120: case 143: case 161: case 162: case 163: case 170: case 171:
  case 172: case 173: case 174: case 175: case 176: case 177:
  case MEASCOLOF8: case MEASCOLOF4: case MEASCOLOC8: case MEASCOLOC4:
  
  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
  build_SelectionPlane(PRE_PRO_options_form1, options_OK, paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_SelectionPlaneout(PRE_PRO_options_form1, options_OK,
			  paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);
  break;


  case 132: case 135:

  /* Creating StrucParametres Widget */ 

  StrucParametres =     
	build_MORPHO_param_widget(PRE_PRO_options_form1, 2);

   n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_One_planeinput_One_planeoutput(PRE_PRO_options_form1, options_OK, 
					paneltabs[105], paneltabs[105]);
  break;

  case PRO_DYNAMIC_THRESHOLD:

  /* Creating StrucParametres Widget */ 

  StrucParametres =             
	build_PRO_dynamic_threshold_param_widget(PRE_PRO_options_form1);

   n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56 ); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_One_planeinput_Two_planeoutput(PRE_PRO_options_form1, options_OK, 
			     paneltabs[105], paneltabs[86], paneltabs[87]);
  break;
  

  case PREPRO_ENHANC_MEDIAN:

  /* Creating StrucParametres Widget */ 

  StrucParametres =                                 
	build_PREPRO_median_filter_param_widget(PRE_PRO_options_form1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56 ); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_One_planeinput_One_planeoutput(PRE_PRO_options_form1, options_OK, 
					paneltabs[105], paneltabs[105]);
  break;

  case PREPRO_ENHANC_HIGH_PASS:

  /* Creating StrucParametres Widget */ 

  StrucParametres =                                      
	build_PREPRO_high_pass_filter_param_widget(PRE_PRO_options_form1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56 ); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_One_planeinput_One_planeoutput(PRE_PRO_options_form1, options_OK, 
					paneltabs[105], paneltabs[105]);
  break;

  case PRO_LAPLACIAN_PERCENTIL_HISTO:

  /* Creating StrucParametres Widget */ 

  StrucParametres =                         
	build_PRO_threshold_laplac_param_widget(PRE_PRO_options_form1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56 ); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_One_planeinput_One_planeoutput(PRE_PRO_options_form1, options_OK, 
					paneltabs[105], paneltabs[105]);
  break;

  case PRO_CONVOL_WITH_MASK: ;
  case PRO_CORREL_WITH_MASK: ;

  /* Creating StrucParametres Widget */ 

  StrucParametres =         
	build_PRO_create_mask_param_widget(PRE_PRO_options_form1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56 ); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_One_planeinput_One_planeoutput(PRE_PRO_options_form1, options_OK, 
					paneltabs[105], paneltabs[105]);
  break;

  case PRO_EDGES_RIDGE_RIDING:

  /* Creating StrucParametres Widget */ 

  StrucParametres =     
	build_PRO_edge_ridge_riding_param_widget(PRE_PRO_options_form1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56 ); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_One_planeinput_One_planeoutput(PRE_PRO_options_form1, options_OK, 
					paneltabs[105], paneltabs[105]);
  break;

  case PREPRO_HAMMING:

  /* Creating StrucParametres Widget */ 

  StrucParametres =       
	build_PREPRO_hamming_param_widget(PRE_PRO_options_form1);

   n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56 ); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_Two_planeinput_Two_planeoutput(PRE_PRO_options_form1, options_OK,
	    paneltabs[77], paneltabs[78], paneltabs[77], paneltabs[78]);
  break;

  case PREPRO_HANNING:

  /* Creating StrucParametres Widget */ 

  StrucParametres =     
      build_PREPRO_hanning_param_widget(PRE_PRO_options_form1);

   n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56 ); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_Two_planeinput_Two_planeoutput(PRE_PRO_options_form1, options_OK,
	    paneltabs[77], paneltabs[78], paneltabs[77], paneltabs[78]);
  break;

  case PREPRO_GAUSSIAN:

  /* Creating StrucParametres Widget */ 

  StrucParametres =      
	  build_PREPRO_gaussian_param_widget(PRE_PRO_options_form1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56 ); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_Two_planeinput_Two_planeoutput(PRE_PRO_options_form1, options_OK,
	    paneltabs[77], paneltabs[78], paneltabs[77], paneltabs[78]);
  break;

  case PRO_TRANSFORMS_COMPLEX:
  case PRO_TRANSFORMS_COMPLEX_inv:
  case PRO_TRANSFORMS_COMPLEX_opt:
  case PRO_TRANSFORMS_COMPLEX_opt_inv:

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
  build_Selection2Planes(PRE_PRO_options_form1, options_OK, 
			 paneltabs[77], paneltabs[78], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
     build_Selection2Planesout(PRE_PRO_options_form1, options_OK, 
			       paneltabs[77], paneltabs[78]);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);

  break;

  case PREPRO_CORRECT_BACKGROUND: 

  /* Creating StrucParametres Widget */ 

  StrucParametres =      
	  build_PREPRO_median_filter_param_widget(PRE_PRO_options_form1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56 ); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_One_planeinput_Two_planeoutput(PRE_PRO_options_form1, options_OK, 
			     paneltabs[105], paneltabs[86], paneltabs[87]);
  break;

  case PRO_TRANSFORMS_REAL: ;
  case PRO_TRANSFORMS_REAL_opt: ;

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
  build_SelectionPlane(PRE_PRO_options_form1, options_OK, 
		       paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,40); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_Selection2Planesout(PRE_PRO_options_form1, options_OK, 
			    paneltabs[77], paneltabs[78]);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,41); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);
  break;


  case PRO_CONVOL_WITH_IMAGE: ;
  case PRO_CORREL_WITH_IMAGE: 

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
  build_Selection2Planes(PRE_PRO_options_form1, options_OK, paneltabs[69], 
		       paneltabs[70], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_SelectionPlaneout(PRE_PRO_options_form1, options_OK, 
			  paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);
  break;


  case PRO_CONVOL_CREATE_MASK:

  /* Creating StrucParametres Widget */ 

  StrucParametres =         
	build_PRO_create_mask_param_widget(PRE_PRO_options_form1);

   n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_One_planeoutput(PRE_PRO_options_form1, options_OK, paneltabs[105]);
  break;


  case PRO_ERO_GAUSS:
  case PRO_DILA_GAUSS:
  case PRO_OPEN_GAUSS:
  case PRO_CLOS_GAUSS:
  case PRO_ERO_SPHERE:
  case PRO_DILA_SPHERE:
  case PRO_OPEN_SPHERE:
  case PRO_CLOS_SPHERE:
  case PRO_ERO_CONE:
  case PRO_DILA_CONE:
  case PRO_OPEN_CONE:
  case PRO_CLOS_CONE:
  case PRO_ERO_CYLINDER:
  case PRO_DILA_CYLINDER:
  case PRO_OPEN_CYLINDER:
  case PRO_CLOS_CYLINDER:


  /* Creating StrucParametres Widget */ 

  if ((option == PRO_ERO_CYLINDER) || (option == PRO_DILA_CYLINDER) ||
      (option == PRO_OPEN_CYLINDER) || (option == PRO_CLOS_CYLINDER))
    StrucParametres =     
	build_PRO_gsm_cone(PRE_PRO_options_form1, 0);
  else if ((option == PRO_ERO_CONE) || (option == PRO_DILA_CONE) ||
           (option == PRO_OPEN_CONE) || (option == PRO_CLOS_CONE))
    StrucParametres =     
	build_PRO_gsm_cone(PRE_PRO_options_form1, 1);
  else if ((option == PRO_ERO_SPHERE) || (option == PRO_DILA_SPHERE) ||
           (option == PRO_OPEN_SPHERE) || (option == PRO_CLOS_SPHERE))
    StrucParametres =     
	build_PRO_gsm_sphere(PRE_PRO_options_form1);
  else
    StrucParametres =     
	build_PRO_gsm_gaussian(PRE_PRO_options_form1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56 ); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_One_planeinput_One_planeoutput(PRE_PRO_options_form1, options_OK, 
					paneltabs[105], paneltabs[105]);
  break;


  case PRO_ERO_PLAN:
  case PRO_DILA_PLAN:
  case PRO_OPEN_PLAN:
  case PRO_CLOS_PLAN:
  case 121: case 122: case 123: case 124:

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
  build_Selection2Planes(PRE_PRO_options_form1, options_OK,
			 paneltabs[105], paneltabs[85], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_SelectionPlaneout(PRE_PRO_options_form1, options_OK, 
			  paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);

  break;


  case 131: case 134:

  /* Creating StrucParametres Widget */ 

  StrucParametres =     
	build_MORPHO_param_widget(PRE_PRO_options_form1, 1);

   n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56 ); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_Two_planeinput_One_planeoutput(PRE_PRO_options_form1, options_OK,
			      paneltabs[69], paneltabs[70], paneltabs[105]);
  break;

  case MEASHISTCAL:

  /* Creating StrucParametres Widget */ 

  StrucParametres = build_Meahiscal_param_widget(PRE_PRO_options_form1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56 ); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;


  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
  build_SelectionPlane(PRE_PRO_options_form1, options_OK, paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectvectoroutput Widget */ 

  selectplaneoutput = 
  build_SelectionPlaneout(PRE_PRO_options_form1, options_OK, 
			  paneltabs[105], 1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);

  break;


  case MEASHISTSHO :

  /* Creating StrucParametres Widget */ 

  StrucParametres = build_Meahissho_param_widget(PRE_PRO_options_form1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 56 ); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  /* Creating selectvectorinput Widget */ 

  selectplaneinput = 
  build_SelectionPlane(PRE_PRO_options_form1, options_OK, paneltabs[105], 1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  break;

  case MEASCOLOSAVE :
  case MEASHISTPRINT :
  {
    char savefile[100];
    Widget separator1, separator2;
    
    /* Creating separator1 Widget */ 

    n = 0;
    XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
    XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
    XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
    XtSetArg(args[n],XmNleftPosition,35); n++; 
    XtSetArg(args[n],XmNorientation,XmVERTICAL); n++;

    separator1 =  
    XmCreateSeparator(PRE_PRO_options_form1,"separator1",args,n);
    XtManageChild(separator1);

      /* Creating StrucParametres Widget */ 

    if (option == MEASCOLOSAVE)
      StrucParametres = build_MEAS_param_widget(PRE_PRO_options_form1);
    else
      StrucParametres = build_Meahissho_param_widget(PRE_PRO_options_form1);

    n = 0;
    XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
    XtSetArg(args[n],XmNleftPosition, 36); n++;
    XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
    XtSetArg(args[n],XmNrightPosition, 60); n++;
    XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
    XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
    XtSetValues(StrucParametres->parent, args, n);
    XtManageChild(StrucParametres->parent);

    StrucParametres->GenerParamparent = PRE_PRO_options_widget;
    
    /* Creating separator2 Widget */ 

    n = 0;
    XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
    XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
    XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
    XtSetArg(args[n],XmNleftPosition, 61); n++; 
    XtSetArg(args[n],XmNorientation,XmVERTICAL); n++;

    separator2 =  
    XmCreateSeparator(PRE_PRO_options_form1,"separator2",args,n);
    XtManageChild(separator2);

    /* Creating file_selection Widget */ 

    n = 0;
    XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
    XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
    XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
    XtSetArg(args[n],XmNleftPosition, 62); n++;
    XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

    if (strcmp (repertoire_save, "") == 0)
		strcpy(repertoire_save, getenv("HOME"));

    XtSetArg(args[n],XmNdirMask,
		XmStringLtoRCreate(repertoire_save,
			XmSTRING_DEFAULT_CHARSET)); n++;
    XtSetArg(args[n],XmNfilterLabelString,
		XmStringLtoRCreate(paneltabs[268],
			XmSTRING_DEFAULT_CHARSET)); n++;
    XtSetArg(args[n],XmNlistLabelString,
		XmStringLtoRCreate(paneltabs[270],
			XmSTRING_DEFAULT_CHARSET)); n++;
    XtSetArg(args[n],XmNbuttonFontList, gFontlist); n++;
    XtSetArg(args[n],XmNlabelFontList, gFontlist); n++;
    XtSetArg(args[n],XmNtextFontList, gSmall_fontlist); n++;

    file_selection = XmCreateFileSelectionBox(PRE_PRO_options_form1,
			"file_selection",args,n);
        
    sprintf (savefile, "%s/image_save", repertoire_save);
    XmTextSetString (XmFileSelectionBoxGetChild 
	     (file_selection, XmDIALOG_TEXT), savefile);


    /* help button unsensitive! */
    XtSetSensitive(XmFileSelectionBoxGetChild 
	   (file_selection, XmDIALOG_HELP_BUTTON), False);

    XtAddCallback(XmFileSelectionBoxGetChild 
			(file_selection, XmDIALOG_CANCEL_BUTTON),
    XmNactivateCallback,PRE_PRO_options_CANCEL_callb,PRE_PRO_options_widget);

    StrucParametres->Generparent = file_selection;
    XtManageChild (file_selection);

    if (option == MEASCOLOSAVE)  /* Creating selectplaneinput Widget */ 
      selectplaneinput = 
      build_SelectionPlane(PRE_PRO_options_form1, 
			 XmFileSelectionBoxGetChild 
			   (file_selection, XmDIALOG_OK_BUTTON), 
			   paneltabs[105], 0);
    else  /* Creating selectvectorinput Widget */ 
      selectplaneinput = 
      build_SelectionPlane(PRE_PRO_options_form1, 
			 XmFileSelectionBoxGetChild 
			   (file_selection, XmDIALOG_OK_BUTTON), 
			   paneltabs[105], 1);
	
    n = 0;
    XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
    XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
    XtSetArg(args[n],XmNrightPosition, 34); n++;
    XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
    XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
    XtSetValues(selectplaneinput, args, n);
    XtManageChild(selectplaneinput);
    }
  
    break;

  case MEASIMASTAT :  
  case ROI_LIRE_ZONE :
  case REG_GROWING :

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
  build_SelectionPlane(PRE_PRO_options_form1, options_OK, paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  break;

  case ROI_SAVE_DISPLAY :
  case REG_GROWING_SAVE_CONTOUR :
  case REG_GROWING_SAVE_REGION :

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_SelectionPlaneout(PRE_PRO_options_form1, options_OK, 
			  paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);

  break;

  case MEASPOWCAL :

  /* Creating StrucParametres Widget */ 

  StrucParametres = build_MEAS_power_param_widget(PRE_PRO_options_form1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 55); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_One_planeoutput(PRE_PRO_options_form1, options_OK, paneltabs[105]);
  break;

  case MEASPOWCUT :

  /* Creating StrucParametres Widget */ 

  StrucParametres = build_MEAS_cut_freq_param_widget(PRE_PRO_options_form1);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 55); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(StrucParametres->parent, args, n);
  XtManageChild(StrucParametres->parent);

  StrucParametres->GenerParamparent = PRE_PRO_options_widget;

  Create_Two_planeinput_Two_planeoutput(PRE_PRO_options_form1, options_OK, 
	       paneltabs[77], paneltabs[78], paneltabs[77], paneltabs[78]);
  break;

  default: break;
}
	
 /* Adding Callbacks for options_OK */ 

 switch (option) {
  case GEL_INIT:
	XtAddCallback(options_OK, 
	XmNactivateCallback,GEL_init_OK_callb, StrucParametres); 
		break;	  
  case PREPRO_HISTO_EQUA : 
	XtAddCallback(options_OK, 
	XmNactivateCallback,PRE_PRO_histo_equa_OK_callb, PRE_PRO_options_widget); 
		break;
  case PREPRO_CORRECT_BACKGROUND : 
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_correct_background_OK_callb, 
				StrucParametres); 
		break;

  case PRO_TRANSFORMS_COMPLEX : 
	XtAddCallback(options_OK, XmNactivateCallback, 
		      PRE_PRO_transf_fourier_OK_callb, 1); 
		break;
  case PRO_TRANSFORMS_COMPLEX_inv : 
	XtAddCallback(options_OK, XmNactivateCallback, 
		      PRE_PRO_transf_fourier_OK_callb, -1); 
		break;
  case PRO_TRANSFORMS_COMPLEX_opt : 
	XtAddCallback(options_OK, XmNactivateCallback, 
		      PRE_PRO_transf_fourier_OK_callb, 2); 
		break;
  case PRO_TRANSFORMS_COMPLEX_opt_inv : 
	XtAddCallback(options_OK, XmNactivateCallback, 
		      PRE_PRO_transf_fourier_OK_callb, -2); 
		break;
  case PRO_TRANSFORMS_REAL : 
	XtAddCallback(options_OK, XmNactivateCallback, 
		      PRE_PRO_transf_fourier_OK_callb, 10); 
		break;
  case PRO_TRANSFORMS_REAL_opt : 
	XtAddCallback(options_OK, XmNactivateCallback, 
		      PRE_PRO_transf_fourier_OK_callb, 20); 
		break;

  case PRO_CONVOL_CREATE_MASK : 
        StrucParametres->type_operation = 3;
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_convol_OK_callb, StrucParametres); 
		break;
  case PRO_CONVOL_WITH_IMAGE : 
        StrucParametres = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));
        StrucParametres->type_operation = 2;
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_convol_OK_callb,StrucParametres); 
		break;
  case PRO_CORREL_WITH_IMAGE :
        StrucParametres = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));
        StrucParametres->type_operation = 12;
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_convol_OK_callb,StrucParametres); 
		break;
  case PRO_CONVOL_WITH_MASK :
        StrucParametres->type_operation = 1; 
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_convol_OK_callb, StrucParametres); 
		break;
  case PRO_CORREL_WITH_MASK :
        StrucParametres->type_operation = 11;
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_convol_OK_callb, StrucParametres); 
		break;

  case PRO_EDGES_SOBEL_RAC:
	XtAddCallback(options_OK,
	XmNactivateCallback, PRE_PRO_edges_sobel_OK_callb, 1);  
		break;
  case PRO_EDGES_SOBEL_ABS: 
	XtAddCallback(options_OK,
	XmNactivateCallback, PRE_PRO_edges_sobel_OK_callb, 2);  
		break;
  case PRO_EDGES_LAPLA_1:
	XtAddCallback(options_OK,
	XmNactivateCallback, PRE_PRO_edges_laplace_OK_callb, 0);  
		break;
  case PRO_EDGES_LAPLA_2: 
	XtAddCallback(options_OK,
	XmNactivateCallback, PRE_PRO_edges_laplace_OK_callb, 1);
		break;
  case PRO_EDGES_LAPLA_3: 
	XtAddCallback(options_OK,
	XmNactivateCallback, PRE_PRO_edges_laplace_OK_callb, 2);
		break;
  case PRO_EDGES_ROBER_RAC: 
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_edges_roberts_OK_callb, 1); 
		break; 
  case PRO_EDGES_ROBER_ABS: 
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_edges_roberts_OK_callb, 2);  
		break;
  case PRO_EDGES_FREI: 
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_edges_frei_chen_OK_callb, NULL);  
		break;
  case PRO_EDGES_MERO: 
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_edges_mero_vassy_OK_callb, NULL);  
		break;
  case PRO_EDGES_ZERO: 
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_edges_zero_cross_OK_callb, NULL);  
		break;
  case PREPRO_ENHANC_MEDIAN : 
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_enhanc_median_OK_callb,
				StrucParametres); 
		break;
  case PREPRO_ENHANC_HIGH_PASS : 
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_enhanc_high_pass_OK_callb,
			       StrucParametres); 
		break;
  case PREPRO_HAMMING : 
        StrucParametres->type_operation = 1;
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_hamming_OK_callb,StrucParametres); 
		break;
  case PREPRO_HANNING  : 
        StrucParametres->type_operation = 3;
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_hamming_OK_callb,StrucParametres); 
		break;
  case PREPRO_GAUSSIAN : 
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_gaussian_OK_callb,StrucParametres); 
		break;
  case PRO_LAPLACIAN_PERCENTIL_HISTO : 
	XtAddCallback(options_OK,
	XmNactivateCallback, 
		      PRE_PRO_lapl_percent_histo_OK_callb,StrucParametres); 
		break;
  case PRO_DYNAMIC_THRESHOLD : 
	XtAddCallback(options_OK,
	XmNactivateCallback,
		PRE_PRO_dynamic_thres_OK_callb, StrucParametres); 
		break;
  case PRO_EDGES_RIDGE_RIDING :
	XtAddCallback(options_OK,
	XmNactivateCallback,
		      PRE_PRO_edges_ridge_riding_OK_callb, StrucParametres); 
		break;
  case PRO_ERO_SPHERE :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_ero_sphere_OK_callb,StrucParametres); 
		break;
  case PRO_ERO_CONE :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_ero_cone_OK_callb,StrucParametres); 
		break;
  case PRO_ERO_CYLINDER :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_ero_cylinder_OK_callb,StrucParametres); 
		break;
  case PRO_ERO_GAUSS :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_ero_gauss_OK_callb,StrucParametres); 
		break;
  case PRO_DILA_SPHERE :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_dila_sphere_OK_callb,StrucParametres); 
		break;
  case PRO_DILA_CONE :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_dila_cone_OK_callb,StrucParametres); 
		break;
  case PRO_DILA_CYLINDER :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_dila_cylinder_OK_callb,StrucParametres); 
		break;
  case PRO_DILA_GAUSS :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_dila_gauss_OK_callb,StrucParametres); 
		break;
  case PRO_OPEN_SPHERE :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_open_sphere_OK_callb,StrucParametres); 
		break;
  case PRO_OPEN_CONE :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_open_cone_OK_callb,StrucParametres); 
		break;
  case PRO_OPEN_CYLINDER :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_open_cylinder_OK_callb,StrucParametres); 
		break;
  case PRO_OPEN_GAUSS :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_open_gauss_OK_callb,StrucParametres); 
		break;
  case PRO_CLOS_SPHERE :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_clos_sphere_OK_callb,StrucParametres); 
		break;
  case PRO_CLOS_CONE :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_clos_cone_OK_callb,StrucParametres); 
		break;
  case PRO_CLOS_CYLINDER :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_clos_cylinder_OK_callb,StrucParametres); 
		break;
  case PRO_CLOS_GAUSS :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_clos_gauss_OK_callb,StrucParametres); 
		break;
  case PRO_ERO_PLAN :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_ero_plan_OK_callb,PRE_PRO_options_widget); 
		break;
  case PRO_DILA_PLAN :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_dila_plan_OK_callb,PRE_PRO_options_widget); 
		break;
  case PRO_OPEN_PLAN :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_open_plan_OK_callb,PRE_PRO_options_widget); 
		break;
  case PRO_CLOS_PLAN :
	XtAddCallback(options_OK,
	XmNactivateCallback,PRE_PRO_clos_plan_OK_callb,PRE_PRO_options_widget); 
		break;
  case 120 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Logical_compl_actcall,PRE_PRO_options_widget); 
		break;
  case 121 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Logical_inter_actcall,PRE_PRO_options_widget); 
		break;
  case 122 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Logical_uni_actcall,PRE_PRO_options_widget); 
		break;
  case 123 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Logical_sym_actcall,PRE_PRO_options_widget); 
		break;
  case 124 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Logical_diff_actcall,PRE_PRO_options_widget); 
		break;
  case 130 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_ero_actcall,StrucParametres); 
		break;
  case 131 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_cond_ero_actcall,StrucParametres); 
		break;
  case 132 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_lin_ero_actcall,StrucParametres); 
		break;
  case 133 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_dil_actcall,StrucParametres); 
		break;
  case 134 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_cond_dila_actcall,StrucParametres); 
		break;
  case 135 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_lin_dil_actcall,StrucParametres); 
		break;
  case 136 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_opening_actcall,StrucParametres); 
		break;
  case 137 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_closing_actcall,StrucParametres); 
		break;
  case 140 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_thin_homL_actcall,StrucParametres); 
		break;
  case 141 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_thin_homD_actcall,StrucParametres); 
		break;
  case 142 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_thin_prun_actcall,StrucParametres); 
		break;
  case 143 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_thin_bound_actcall,PRE_PRO_options_widget); 
		break;
  case 150 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_thick_isol_actcall,StrucParametres); 
		break;
  case 151 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_thick_homL_actcall,StrucParametres); 
		break;
  case 152 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_thick_homD_actcall,StrucParametres); 
		break;
  case 153 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_thick_thickE_actcall,StrucParametres); 
		break;
  case 154 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Simple_thick_thickC_actcall,StrucParametres); 
		break;
  case 161 :
	XtAddCallback(options_OK,
	XmNactivateCallback,hit_miss_end_points_actcall,PRE_PRO_options_widget); 
		break;
  case 162 :
	XtAddCallback(options_OK,
	XmNactivateCallback,hit_miss_isol_actcall,PRE_PRO_options_widget); 
		break;
  case 163 :
	XtAddCallback(options_OK,
	XmNactivateCallback,hit_miss_triple_actcall,PRE_PRO_options_widget); 
		break;
  case 170 :
	XtAddCallback(options_OK,
	XmNactivateCallback,high_bound_actcall,PRE_PRO_options_widget); 
		break;
  case 171 :
	XtAddCallback(options_OK,
	XmNactivateCallback,high_elimin_actcall,PRE_PRO_options_widget); 
		break;
  case 172 :
	XtAddCallback(options_OK,
	XmNactivateCallback,high_fill_actcall,PRE_PRO_options_widget); 
		break;
  case 173 :
	XtAddCallback(options_OK,
	XmNactivateCallback,high_hom_skel_actcall,PRE_PRO_options_widget); 
		break;
  case 174 :
	XtAddCallback(options_OK,
	XmNactivateCallback,high_hom_mark_actcall,PRE_PRO_options_widget); 
		break;
  case 175 :
	XtAddCallback(options_OK,
	XmNactivateCallback,high_pseudo_actcall,PRE_PRO_options_widget); 
		break;
  case 176 :
	XtAddCallback(options_OK,
	XmNactivateCallback,high_strong_actcall,PRE_PRO_options_widget); 
		break;
  case 177 :
	XtAddCallback(options_OK,
	XmNactivateCallback,high_skele_actcall,PRE_PRO_options_widget); 
		break;
  case 180 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Cond_thin_homL_actcall,StrucParametres); 
		break;
  case 181 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Cond_thin_homD_actcall,StrucParametres); 
		break;
  case 182 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Cond_thin_prun_actcall,StrucParametres); 
		break;
  case 190 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Cond_thick_isol_actcall,StrucParametres); 
		break;
  case 191 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Cond_thick_homL_actcall,StrucParametres); 
		break;
  case 192 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Cond_thick_homD_actcall,StrucParametres); 
		break;
  case 193 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Cond_thick_thickE_actcall,StrucParametres); 
		break;
  case 194 :
	XtAddCallback(options_OK,
	XmNactivateCallback,Cond_thick_thickC_actcall,StrucParametres); 
		break;
  case MEASHISTCAL: StrucParametres->type_operation = 0;
	XtAddCallback(options_OK,
	XmNactivateCallback,MEAS_hist_OK_callb, StrucParametres); 
		break;
  case MEASHISTSHO : StrucParametres->type_operation = 1;
	XtAddCallback(options_OK,
	XmNactivateCallback,MEAS_hist_OK_callb,StrucParametres); 
		break;
  case MEASHISTPRINT : StrucParametres->type_operation = 2;
	XtAddCallback(XmFileSelectionBoxGetChild 
		          (file_selection, XmDIALOG_OK_BUTTON),
	XmNactivateCallback,MEAS_hist_OK_callb,StrucParametres); 
		break;
  case MEASIMASTAT :
	XtAddCallback(options_OK,
	XmNactivateCallback,MEAS_ima_sta_OK_callb,PRE_PRO_options_widget); 
		break;
  case MEASCOLOF8 :
	XtAddCallback(options_OK,
	XmNactivateCallback,MEAS_ima_col_OK_callb, 1); 
		break;
  case MEASCOLOF4 :
	XtAddCallback(options_OK,
	XmNactivateCallback,MEAS_ima_col_OK_callb, 2); 
		break;
  case MEASCOLOC8 :
	XtAddCallback(options_OK,
	XmNactivateCallback,MEAS_ima_col_OK_callb, 3); 
		break;
  case MEASCOLOC4 :
	XtAddCallback(options_OK,
	XmNactivateCallback,MEAS_ima_col_OK_callb, 4); 
		break;
  case MEASCOLOSAVE :
	XtAddCallback(XmFileSelectionBoxGetChild 
		          (file_selection, XmDIALOG_OK_BUTTON),
	XmNactivateCallback,MEAS_ima_save_OK_callb,StrucParametres); 
		break;
  case MEASPOWCAL :
	XtAddCallback(options_OK,
	XmNactivateCallback,MEAS_pow_cal_OK_callb,StrucParametres); 
		break;
  case MEASPOWCUT :
	XtAddCallback(options_OK,
	XmNactivateCallback,MEAS_cut_freq_OK_callb,StrucParametres); 
		break;
  case ROI_SAVE_DISPLAY: 
	XtAddCallback(options_OK,
	XmNactivateCallback, ROI_save_display_OK_callb,PRE_PRO_options_widget); 
		break;
  case ROI_LIRE_ZONE:
	XtAddCallback(options_OK,
	XmNactivateCallback, ROI_lire_zone_OK_callb,PRE_PRO_options_widget); 
		break;
  case REG_GROWING:
	XtAddCallback(options_OK,
	XmNactivateCallback, Reg_growing_OK_callb,PRE_PRO_options_widget); 
		break;
  case REG_GROWING_SAVE_CONTOUR:
	XtAddCallback(options_OK,
	XmNactivateCallback, Reg_growing_save_contour_OK_callb,PRE_PRO_options_widget); 
		break;
  case REG_GROWING_SAVE_REGION:
	XtAddCallback(options_OK,
	XmNactivateCallback, Reg_growing_save_region_OK_callb,PRE_PRO_options_widget); 
		break;
  default : break;
	}

return (PRE_PRO_options_widget);
}


static void 
Create_One_planeinput_One_planeoutput(PRE_PRO_options_form1, options_OK, message1, message2)
Widget PRE_PRO_options_form1, options_OK;
char *message1, *message2;
{
  Widget selectplaneinput;
  Widget selectplaneoutput;
  Arg args[MAX_ARGS];
  int n;
  
  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
  build_SelectionPlane(PRE_PRO_options_form1, options_OK, message1, 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_SelectionPlaneout(PRE_PRO_options_form1, options_OK, 
			  message2, 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);

}

  
static void
Create_One_planeinput_Two_planeoutput(PRE_PRO_options_form1, options_OK, message1, message2, message3)
Widget PRE_PRO_options_form1, options_OK;
char *message1, *message2, *message3;
{ 
  Widget selectplaneinput;
  Widget selectplaneoutput;
  Arg args[MAX_ARGS];
  int n;

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
     build_SelectionPlane(PRE_PRO_options_form1, options_OK, 
			  message1, 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,40); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput =
    build_Selection2Planesout(PRE_PRO_options_form1, options_OK, 
			      message2, message3);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,41); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);

}

 
  
static void
Create_Two_planeinput_One_planeoutput(PRE_PRO_options_form1, options_OK, message1, message2, message3)
Widget PRE_PRO_options_form1, options_OK;
char *message1, *message2, *message3;
{ 
  Widget selectplaneinput;
  Widget selectplaneoutput;
  Arg args[MAX_ARGS];
  int n;

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
  build_Selection2Planes(PRE_PRO_options_form1, options_OK, 
			 message1, message2, 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition,53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_SelectionPlaneout(PRE_PRO_options_form1, options_OK, 
			  message3, 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition,53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);

}

 
static void
Create_Two_planeinput_Two_planeoutput(PRE_PRO_options_form1, options_OK, message1, message2, message3, message4)
Widget PRE_PRO_options_form1, options_OK;
char *message1, *message2, *message3, *message4;
{ 
  Widget selectplaneinput;
  Widget selectplaneoutput;
  Arg args[MAX_ARGS];
  int n;

  /* Creating selectplaneinput Widget */ 

  selectplaneinput =
   build_Selection2Planes(PRE_PRO_options_form1, options_OK, 
			  message1, message2, 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput =
  build_Selection2Planesout(PRE_PRO_options_form1, options_OK, 
			    message3, message4);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);

}


static void
Create_One_planeinput(PRE_PRO_options_form1, options_OK, message)
Widget PRE_PRO_options_form1, options_OK;
char *message;
{ 
  Widget selectplaneinput;
  Widget selectplaneoutput;
  Arg args[MAX_ARGS];
  int n;

   /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
    build_SelectionPlane(PRE_PRO_options_form1, options_OK, message, 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

}

  
static void
Create_One_planeoutput(PRE_PRO_options_form1, options_OK, message)
Widget PRE_PRO_options_form1, options_OK;
char *message;
{ 
  Widget selectplaneinput;
  Widget selectplaneoutput;
  Arg args[MAX_ARGS];
  int n;

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput =
    build_SelectionPlaneout(PRE_PRO_options_form1, options_OK, 
			    message, 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);
}

