/* SCCS @(#)progsmcone.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       progsmcone.layout.c                            */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   progsmcone.layout.c                                 */
/*                                                                      */
/* DESCRIPTION  :   Processing Gray Scale Morphology                    */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "progsmcone.layout.h"
#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;

/********************************************************
/   Creation Function for PRO_gsm_cone 
/*******************************************************/

xs_struc_paramprepro
* build_PRO_gsm_cone(progsmcone, cone)
	Widget progsmcone;
        int cone;
{
	Widget PRO_gsm_cone;
	Widget Radius_text;
	Widget PRO_cone;
	Widget min_label;
	Widget Label_2;
	Widget height_Label;
	Widget height_Text;
	xs_struc_paramprepro *Paramprepro;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating PRO_gsm_cone Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,233); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,214); n++;
	XtSetArg(args[n],XmNx,16); n++;
	XtSetArg(args[n],XmNy,5); n++;

	PRO_gsm_cone = XmCreateForm(progsmcone,"PRO_gsm_cone",args,n);
	XtManageChild(PRO_gsm_cone);

	Paramprepro->parent = PRO_gsm_cone;

	/* Creating Radius_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,30); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,68); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,45); n++;
	XtSetArg(args[n],XmNvalue, "2"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	Radius_text = XmCreateText(PRO_gsm_cone,"Radius_text",args,n);
	XtManageChild(Radius_text);

	Paramprepro->line = Radius_text;

	/* Creating PRO_cone Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	if (cone == 1)
	   XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[218],
			XmSTRING_DEFAULT_CHARSET)); 
	else
	   XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[224],
			XmSTRING_DEFAULT_CHARSET)); 
	n++;
	

	PRO_cone = XmCreateLabel(PRO_gsm_cone,"PRO_cone",args,n);
	XtManageChild(PRO_cone);

	/* Creating min_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0 <",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,28); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,45); n++;

	min_label = XmCreateLabel(PRO_gsm_cone,"min_label",args,n);
	XtManageChild(min_label);

	/* Creating Label_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[216],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,30); n++;

	Label_2 = XmCreateLabel(PRO_gsm_cone,"Label_2",args,n);
	XtManageChild(Label_2);

	/* Creating height_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[217],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,65); n++;

	height_Label = XmCreateLabel(PRO_gsm_cone,"height_Label",args,n);
	XtManageChild(height_Label);

	/* Creating height_Text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,height_Label); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,65); n++;
	XtSetArg(args[n],XmNvalue, "4"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	height_Text = XmCreateText(PRO_gsm_cone,"height_Text",args,n);
	XtManageChild(height_Text);

	Paramprepro->colon = height_Text;

	return(Paramprepro);
}
