/* SCCS @(#)auxgoptra.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       auxgoptra.layout.c                             */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   auxgoptra.layout.c                                  */
/*                                                                      */
/* DESCRIPTION  :   Geometric operations parameter (translation)        */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "auxgoptra.layout.h"

#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;

#define AUX_GEOM_TRAN 41
#define AUX_GEOM_SCALS 42
#define AUX_GEOM_SCALF 43


static void 
param_SET_trans_callb (options_OK, Paramprepro, callData)
     Widget options_OK;
     xs_struc_paramprepro *Paramprepro;
     caddr_t callData;
{
  char stitre[30];

  sprintf (stitre, "%d", (int)(dir_desc[index_image[0]].ncolonne/2)); 
  XmTextSetString (Paramprepro->colon, stitre);
  sprintf (stitre, "%d", (int)(dir_desc[index_image[0]].nligne/2)); 
  XmTextSetString (Paramprepro->line, stitre);
}


static void 
param_SET_scal_callb (options_OK, Paramprepro, callData)
     Widget options_OK;
     xs_struc_paramprepro *Paramprepro;
     caddr_t callData;
{
  char stitre[30];

  sprintf (stitre, "%d", dir_desc[index_image[0]].ncolonne * 2); 
  XmTextSetString (Paramprepro->colon, stitre);
  sprintf (stitre, "%d", dir_desc[index_image[0]].nligne * 2); 
  XmTextSetString (Paramprepro->line, stitre);
}


/********************************************************
/   Creation Function for AUX_geom_trans 
/*******************************************************/

xs_struc_paramprepro
* build_AUX_geom_trans(auxgoptra, operation)
	Widget auxgoptra;
        int operation;
{
	Widget AUX_geom_trans;
	Widget param_SET;
	Widget Y_Text;
	Widget Y_Label;
	Widget X_Label;
	Widget X_Text;
	Widget pix_label1;
	Widget pixel_label2;
	xs_struc_paramprepro *Paramprepro;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating AUX_geom_trans Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,168); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,147); n++;
	XtSetArg(args[n],XmNx,31); n++;
	XtSetArg(args[n],XmNy,8); n++;

	AUX_geom_trans = XmCreateForm(auxgoptra,"AUX_geom_trans",args,n);
	XtManageChild(AUX_geom_trans);

	Paramprepro->parent = AUX_geom_trans;

	if ((operation == AUX_GEOM_TRAN) || (operation == AUX_GEOM_SCALS))
	{
	  /* Creating param_SET Widget */ 

	  n = 0;
	  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNbottomPosition,96); n++;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		   XmStringLtoRCreate(paneltabs[106],
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition, 20); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition, 80); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition, 84); n++;


	  param_SET = XmCreatePushButton(AUX_geom_trans, 
					 "param_SET",args,n);

	  XtManageChild(param_SET);

	  /* Adding Callbacks for param_SET */ 

	  if (operation == AUX_GEOM_TRAN)
	    XtAddCallback(param_SET,XmNactivateCallback,
			param_SET_trans_callb, Paramprepro);
	  else
	    XtAddCallback(param_SET,XmNactivateCallback,
			param_SET_scal_callb, Paramprepro);

	}

	/* Creating Y_Text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,25); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,60); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,55); n++;
	if (operation == AUX_GEOM_SCALF)
 	  XtSetArg(args[n],XmNvalue, "2"); n++;
 	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	Y_Text = XmCreateText(AUX_geom_trans,"Y_Text",args,n);
	XtManageChild(Y_Text);

	Paramprepro->colon = Y_Text;

	/* Creating Y_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Y :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,19); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,55); n++;

	Y_Label = XmCreateLabel(AUX_geom_trans,"Y_Label",args,n);
	XtManageChild(Y_Label);

	/* Creating X_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("X :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,19); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,30); n++;

	X_Label = XmCreateLabel(AUX_geom_trans,"X_Label",args,n);
	XtManageChild(X_Label);

	/* Creating X_Text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,25); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,60); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,30); n++;
	if (operation == AUX_GEOM_SCALF)
 	  XtSetArg(args[n],XmNvalue, "2"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	X_Text = XmCreateText(AUX_geom_trans,"X_Text",args,n);
	XtManageChild(X_Text);

	Paramprepro->line = X_Text;

	/* Creating pix_label1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("pixels",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,63); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,30); n++;

	pix_label1 = XmCreateLabel(AUX_geom_trans,"pix_label1",args,n);
	XtManageChild(pix_label1);

	/* Creating pixel_label2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("pixels",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,63); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,55); n++;

	pixel_label2 = XmCreateLabel(AUX_geom_trans,"pixel_label2",args,n);
	XtManageChild(pixel_label2);

	return(Paramprepro);
}
