/* SCCS @(#)lecture4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      lecture4.c                                      */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   lecture4.c                                          */
/*                                                                      */
/* DESCRIPTION  :   Read operations                                     */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <strings.h>
#include <dirent.h>

#include <pixrect/pixrect.h>
#include <pixrect/pr_io.h>
#include <pixrect/memvar.h>

#include <rasterfile.h>

#include "win4.h"
#include "desctool4.h"
#include "libwidgets/widgetstructure.h"
#include "i_olim.layout.h"
     
extern char *strtok();

extern	char	dirname_in[60], dirname_out[60];
extern  *Histogramme[MAX_IMAGE];


extern int read_desc();  
extern char *find_name ();


struct fname *lire_fname (filename, mode)
char *filename;
int  mode;
{   
    static struct fname *fn;
    char *name = (char *) malloc(strlen (filename) + 20);  /*80*/
    fn = (struct fname *) malloc (sizeof (struct fname));

    switch (mode) {
	case 5:
	case 10 : {  /*standard*/
	    if (strcmp(filename, "") == 0){
		fn->fpdesc = NULL;
		fn->fpim = NULL;
		return(fn);
	    }
	    strcpy (name, filename);
	    strcat (name, ".des");
	    if ((fn->fpdesc = fopen (name, "r")) == NULL){
		free(name);
		return(fn);
	    }
	    if (mode == 10) {
		strcpy (name, filename);
		strcat (name, ".ima");
		if ((fn->fpim = fopen (name, "r")) == NULL){
		    free(name);
		    return(fn);
		}
	    }
	    strcpy (fn->filename, filename);
	    break;
	}
	case 20 : { /* sauvetage image standard */
	    if (strcmp(filename, "") == 0){
		fn->fpdesc = NULL;
		fn->fpim = NULL;
		return(fn);
	    }
	    strcpy (name, filename);
	    strcat (name, ".des");
	    if ((fn->fpdesc = fopen (name, "w")) == NULL){
		free(name);
		return(fn);
	    }
	    else{
		strcpy (name, filename);
		strcat (name, ".ima");
		if ((fn->fpim = fopen (name, "w")) == NULL){
		    free(name);
		    return(fn);
		}
		else strcpy (fn->filename, filename);
	    }
	    break; 
	}
	case 21 : { /* sauvetage image laser */
	    if (strcmp(filename, "") == 0){
		fn->fpdesc = NULL;
		fn->fpim = NULL;
		return(fn);
	    }
	    strcpy (name, filename);
	    strcat (name, ".ps");
	    if ((fn->fpim = fopen (name, "w")) == NULL){
		free(name);
		return(fn);
	    }
	    else strcpy (fn->filename, filename);
	    break; 
	}
	case 30 : { /* lecture image raster */
	    if (strcmp(filename, "") == 0){
		fn->fpdesc = NULL;
		fn->fpim = NULL;
		return(fn);
	    }
	    if ((fn->fpim = fopen (filename, "rb")) == NULL){
		free(name);
		return(fn);
	    }
	    else strcpy (fn->filename, filename);
	    break; 
	}
	case 31 : { /* sauvetage image raster */
	    if (strcmp(filename, "") == 0){
		fn->fpdesc = NULL;
		fn->fpim = NULL;
		return(fn);
	    }
	    strcpy (name, filename);
	    strcat (name, ".rf");
	    if ((fn->fpim = fopen (name, "wb")) == NULL){
		free(name);
		return(fn);
	    }
	    else strcpy (fn->filename, filename);
	    break; 
	}
    }
    return(fn); 
}


struct fname *lire_repertoire_gel (dirname, mode)
char *dirname;
int mode;
{   
    DIR  *dfd;
    char *name = (char *) malloc(strlen (dirname) + 20); /*80*/
    static struct fname *fn;

    fn = (struct fname *) malloc (sizeof (struct fname));
    switch(mode){
	case 0:  /*lecture d'un gel contenu dans un repertoire*/
	  if ((dfd = opendir (dirname)) == NULL){  
/* faire ici un test pour voir si repertoire existe sinon le creer!!*/
		fn->fpdesc = NULL;
		fn->fpim = NULL;
		free (name);
		return(fn);
    	  }
	  else closedir (dfd);
          strcpy (name, dirname);
          strcat (name, "/meldata");
          if ((fn->fpdesc = fopen (name, "r")) == NULL){
 	    free(name);
	    return(fn);
          }
	    else{
                strcpy (name, dirname);
                strcat (name, "/data.ave");
                if ((fn->fpim = fopen (name, "r")) == NULL){
	           free(name);
	           return(fn);
                }
                else strcpy (fn->filename, dirname); 
	    }
	  break;
	case 1:  /*sauvegarde d'un gel dans un repertoire cree ou a creer*/
 	  if ((dfd = opendir (dirname)) == NULL){
	        strcpy (name , "mkdir ");
		strcat (name, dirname);
		system (name);
	  }
	  else closedir(dfd);
	  strcpy (name, dirname);
	  strcat (name, "/meldata");

	  if ((fn->fpdesc = fopen (name, "w")) == NULL){
		free(name);
		return(fn);
	  }
	  else{ 
		strcpy (name, dirname);
		strcat (name, "/data.ave");

		if ((fn->fpim = fopen (name, "w")) == NULL){
		    free(name);
		    return(fn);
		}
		else strcpy (fn->filename, dirname);
	    }
	    break; 
 	}
 free (name);
 return(fn); 
}   




/*****************************************************************************/
/*                							     */
/* nom      : lire_plan_image 						     */
/*									     */
/* fonction : lit un plan-image d'une image standard stockee dans le         */
/*	      fichier fp.						     */
/*									     */
/* entrees  : int indice		: (indice)eme plan d'une image       */
/*	      int index                 : indice de stockage dans	     */
/*					  dir_image et dir_desc		     */
/*	      int taille		: taille en bytes du plan-image      */
/*	      FILE *fp			: fichier contenant l'image	     */
/*									     */
/* globales : desc			: descripteur de fichier image       */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/


static 
int lire_plan_image (indice, index, taille, fn)
    int indice, index, taille;
    struct fname *fn;
{
    unsigned char *image;
    int k;

    image = (unsigned char *)malloc(taille);
    if (image == NULL) 
    {
      fclose(fn->fpim);
      fclose(fn->fpdesc);
      write_erreur(900);
      return(-1);
    }
    k = fread (image, taille, 1, fn->fpim);
    if (dir_image[index].image != NULL)
        free (dir_image[index].image);
    dir_image[index].image = image;
    strcpy (dir_desc[index].date, desc.date);       
    strcpy (dir_desc[index].comment, desc.comment); 
    strcpy (dir_desc[index].filename, fn->filename);
    dir_desc[index].type = desc.type;
        /* desc.type a ete prepare pour l'appel a cette procedure */
    dir_desc[index].ncolonne = desc.ncolonne;
    dir_desc[index].nligne = desc.nligne;
    dir_desc[index].mmin = desc.mini[indice];
    dir_desc[index].mmax = desc.maxi[indice];
    dir_desc[index].mu = desc.mu[indice];
    dir_desc[index].ecart = desc.ecart[indice];
    if (Histogramme[index] != NULL)
	free(Histogramme[index]);
    Histogramme[index] = NULL;
    return(0);
}


/*****************************************************************************/ 

int lecture_standard (fn, fflag)
    struct  fname   *fn; 
    int fflag;
{
    int     n,taille,elem, p, k;
    FILE  *fp;
    char filedesc[80], filedeschome[80];
    char *pdate;
    
    elem = element (desc.type);
    taille = desc.nligne * desc.ncolonne * elem;

    switch (desc.type) {
	case -1:
        case 0 :
        case 1 :
        case 2 :
        case 3 :
            if (lire_plan_image (0, index_image[1], taille, fn) < 0)
	      return(-1);
            if (fflag == IO_LOAD_BSTANDARD) 
	               statis ( dir_image[index_image[1]].image, 
				dir_desc[index_image[1]].type, 
				dir_desc[index_image[1]].nligne,
				dir_desc[index_image[1]].ncolonne,
				&(dir_desc[index_image[1]].mmin), 
				&(dir_desc[index_image[1]].mmax), 
				&(dir_desc[index_image[1]].mu), 
				&(dir_desc[index_image[1]].ecart));
            break;
        case 4 : 
        case 5 : 
            desc.type = 3;     /* les 2 plans-image sont des float */ 
            if (lire_plan_image (0, index_image[1], taille, fn) < 0)
	      return(-1);
            if (lire_plan_image (1, index_image[3], taille, fn) < 0)
	      return(-1);
	    if (fflag == IO_LOAD_BSTANDARD){
               statis (dir_image[index_image[1]].image, 
                     dir_desc[index_image[1]].type, 
	             dir_desc[index_image[1]].nligne, 
                     dir_desc[index_image[1]].ncolonne,
                     &(dir_desc[index_image[1]].mmin), 
                     &(dir_desc[index_image[1]].mmax), 
	             &(dir_desc[index_image[1]].mu), 
                     &(dir_desc[index_image[1]].ecart));

               statis (dir_image[index_image[3]].image, 
                    dir_desc[index_image[3]].type, 
	            dir_desc[index_image[3]].nligne,
                    dir_desc[index_image[3]].ncolonne,
                    &(dir_desc[index_image[3]].mmin), 
                    &(dir_desc[index_image[3]].mmax), 
	            &(dir_desc[index_image[3]].mu), 
                    &(dir_desc[index_image[3]].ecart));
	    }
            break;
        case 6 : 
            desc.type = 0;     /* les 3 plans-image sont des bytes */
            if (lire_plan_image (0, index_image[1], taille, fn) < 0)
	      return(-1);
            if (lire_plan_image (1, index_image[3], taille, fn) < 0)
	      return(-1);
            if (lire_plan_image (2, index_image[5], taille, fn) < 0)
	      return(-1);
	    if (fflag == IO_LOAD_BSTANDARD)
	    {
		statis (dir_image[index_image[1]].image, 
                     dir_desc[index_image[1]].type, 
	             dir_desc[index_image[1]].nligne, 
                     dir_desc[index_image[1]].ncolonne,
                     &(dir_desc[index_image[1]].mmin), 
                     &(dir_desc[index_image[1]].mmax), 
	             &(dir_desc[index_image[1]].mu), 
                     &(dir_desc[index_image[1]].ecart));
		statis (dir_image[index_image[3]].image, 
                    dir_desc[index_image[3]].type, 
	            dir_desc[index_image[3]].nligne,
                    dir_desc[index_image[3]].ncolonne,
                    &(dir_desc[index_image[3]].mmin), 
                    &(dir_desc[index_image[3]].mmax), 
	            &(dir_desc[index_image[3]].mu), 
                    &(dir_desc[index_image[3]].ecart));
		statis (dir_image[index_image[5]].image, 
                    dir_desc[index_image[5]].type, 
	            dir_desc[index_image[5]].nligne,
                    dir_desc[index_image[5]].ncolonne,
                    &(dir_desc[index_image[5]].mmin), 
                    &(dir_desc[index_image[5]].mmax), 
	            &(dir_desc[index_image[5]].mu), 
                    &(dir_desc[index_image[5]].ecart));
	    }
            break;
    }

    fclose (fn->fpim);
    fclose(fn->fpdesc);

    if (fflag  == IO_LOAD_BSTANDARD){
	desc.mini[0]=dir_desc[index_image[1]].mmin;
	desc.maxi[0]=dir_desc[index_image[1]].mmax;
	desc.mu[0]=dir_desc[index_image[1]].mu;
	desc.ecart[0]=dir_desc[index_image[1]].ecart;
	if (desc.type > 3){
	    desc.mini[1]=dir_desc[index_image[3]].mmin;
	    desc.maxi[1]=dir_desc[index_image[3]].mmax;
	    desc.mu[1]=dir_desc[index_image[3]].mu;
	    desc.ecart[1]=dir_desc[index_image[3]].ecart;
	}
	else desc.mini[1]=desc.maxi[1]=desc.mu[1]=desc.ecart[1]=0;
	if (desc.type > 5){
	    desc.mini[2]=dir_desc[index_image[5]].mmin;
	    desc.maxi[2]=dir_desc[index_image[5]].mmax;
	    desc.mu[2]=dir_desc[index_image[5]].mu;
	    desc.ecart[2]=dir_desc[index_image[5]].ecart;
	}
	else desc.mini[2]=desc.maxi[2]=desc.mu[2]=desc.ecart[2]=0;
	desc.mini[3]=desc.maxi[3]=desc.mu[3]=desc.ecart[3]=0;
	desc.mini[4]=desc.maxi[4]=desc.mu[4]=desc.ecart[4]=0;
	desc.mini[5]=desc.maxi[5]=desc.mu[5]=desc.ecart[5]=0;
        strcpy (desc.comment, dir_desc[index_image[1]].comment);

	if (dir_desc[index_image[1]].date[0] == '\0'){
	    strcpy (desc.date, (char *)get_time());
	}
	else{
	    pdate = dir_desc[index_image[1]].date;
	    while (*pdate == ' ') pdate++;
	    strcpy (desc.date, pdate);
	}
	strcpy(filedesc,fn->filename);
	strcat(filedesc,".des");

	if ((fp = fopen (filedesc, "w")) == NULL)
	{
	  sprintf(filedesc, "%s/%s", getenv("HOME"), find_name (filedesc));
	  if ((fp = fopen(filedesc,"w")) == NULL)
	  {
	    write_erreur(985);
	    return(-1);
	  }
	}
	write_desc(fp, desc);
	fclose (fp); 
	sprintf(buf, mastertabs[124], filedesc);
	write_master(buf);
    }
    return (1);
}


/*****************************************************************************/
/*                							     */
/* nom      : lire_filelts 						     */
/*									     */
/* fonction : lit dans le fichier fp_lts une image stockee selon le format   */
/*	      du "laboratoire de traitement des signaux".		     */
/*									     */
/* entrees  : neant						             */
/*									     */
/* globales : dir_image					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : statis							     */
/*								             */
/*****************************************************************************/

int lire_filelts(noarr, info)
int	noarr;			/*plan-image*/
struct	lecture_lts *info;
{
    int taille;
    register int i, j;
    unsigned char *im;

    fseek (info->fp_lts, (long)(info->header), 0);
    taille = info->nlignes * info->nvaleur;
    im = (unsigned char *) malloc (taille);
    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
    dir_image[noarr].image = (unsigned char *)im;
    for (j=0; j<info->nlignes; j++) {
	for (i=0; i<info->nvaleur; i++) {
	    fseek (info->fp_lts, (long)(info->bytes_sautes), 1);
	    fread (im, sizeof(*im), 1, info->fp_lts);
            im++;
	}
        fseek (info->fp_lts, (long)(info->nbytes - 
			      info->nvaleur * (info->bytes_sautes + 1)), 1);
    }
    fclose (info->fp_lts);
    dir_desc[noarr].type = 0;
    dir_desc[noarr].nligne = info->nlignes;
    dir_desc[noarr].ncolonne = info->nvaleur;
    strcpy (dir_desc[noarr].date, (char *) get_time());	    /* date et heure */
    strcpy (dir_desc[noarr].filename, info->filename);	    /* nom fichier */
    statis (dir_image[noarr].image, 
	    dir_desc[noarr].type, 
	    dir_desc[noarr].nligne, 
	    dir_desc[noarr].ncolonne,
            &(dir_desc[noarr].mmin), 
	    &(dir_desc[noarr].mmax), 
	    &(dir_desc[noarr].mu), 
	    &(dir_desc[noarr].ecart));
    if (Histogramme[noarr] != NULL)
	free(Histogramme[noarr]);
    Histogramme[noarr] = NULL;
    return(1);
}



/*****************************************************************************/
/*                							     */
/* nom      : lire_filergb 						     */
/*									     */
/* fonction : lit dans le fichier fp_lts une image RGB (chaque point a ses   */
/*	      trois composantes consecutives) et stocke :		     */
/*	      le plan R dans dir_image[index_image[1]].image		     */
/*	      le plan G dans dir_image[index_image[3]].image		     */
/*	      le plan B dans dir_image[index_image[5]].image		     */
/*	      et met a jour le descripteur des plans-images		     */
/*									     */
/* entrees  : neant						             */
/*									     */
/* globales : dir_image					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : statis							     */
/*								             */
/*****************************************************************************/

int lire_filergb(imR, imG, imB, info)
int imR, imG, imB;   /*plans images choisis*/
struct lecture_lts *info;

{
    register int taille, i, j;
    unsigned char *r, *g, *b, t, *d;
    
    fseek (info->fp_lts, (long)(info->header), 0);
    taille = info->nlignes * info->nvaleur;

    r = (unsigned char *) malloc (taille);
    g = (unsigned char *) malloc (taille);
    b = (unsigned char *) malloc (taille);
    if (dir_image[imR].image != NULL)
       free(dir_image[imR].image);
    if (dir_image[imG].image != NULL)
       free(dir_image[imG].image);
    if (dir_image[imB].image != NULL)
       free(dir_image[imB].image);
    dir_image[imR].image = r;
    dir_image[imG].image = g;
    dir_image[imB].image = b;

    for (j=0; j<info->nlignes; j++) {
	for (i=0; i<info->nvaleur; i++) {
            fread (r, sizeof(*r), 1, info->fp_lts);
	    fread (g, sizeof(*g), 1, info->fp_lts);
	    fread (b, sizeof(*b), 1, info->fp_lts);
            r++; g++; b++;
	}
        fseek (info->fp_lts, (long)(info->nbytes - info->nvaleur * 3), 1);
    }

    fclose (info->fp_lts);
    dir_desc[imR].type = 0;     /* type byte */
    dir_desc[imR].nligne = info->nlignes;
    dir_desc[imR].ncolonne = info->nvaleur;
    strcpy (dir_desc[imR].date, (char *) get_time());	    /* date et heure */
    strcpy (dir_desc[imR].filename, info->filename);	    /* nom fichier */
    dir_desc[imG] = dir_desc[imB] = dir_desc[imR];
    statis (dir_image[imR].image, dir_desc[imR].type, 
	    dir_desc[imR].nligne, dir_desc[imR].ncolonne,
            &(dir_desc[imR].mmin), &(dir_desc[imR].mmax),
	    &(dir_desc[imR].mu), &(dir_desc[imR].ecart));
    statis (dir_image[imG].image, dir_desc[imG].type, 
	    dir_desc[imG].nligne, dir_desc[imG].ncolonne,
            &(dir_desc[imG].mmin), &(dir_desc[imG].mmax),
	    &(dir_desc[imG].mu), &(dir_desc[imG].ecart));
    statis (dir_image[imB].image, dir_desc[imB].type, 
	    dir_desc[imB].nligne, dir_desc[imB].ncolonne,
            &(dir_desc[imB].mmin), &(dir_desc[imB].mmax),
	    &(dir_desc[imB].mu), &(dir_desc[imB].ecart));
    if (Histogramme[imR] != NULL)
	free(Histogramme[imR]);
    Histogramme[imR] = NULL;
    if (Histogramme[imG] != NULL)
	free(Histogramme[imG]);
    Histogramme[imG] = NULL;
    if (Histogramme[imB] != NULL)
	free(Histogramme[imB]);
    Histogramme[imB] = NULL;
    return(1);

}




/*****************************************************************************/
/* function which reads a raster file and stores the  image                  */
/* onto a memory plane                                                       */
/*****************************************************************************/

int lecture_rasterfile(fnras)
    struct fname *fnras;
{
    FILE *fp, *fpm;
    char *frdesname,desname[60], imname[60], mapname[60];
    struct pixrect *ppixrect;
    struct mpr_data *pr_data;
    colormap_t colormaploc;
    unsigned char map[3] [256];
    struct description descy;
    unsigned char *imageraster;
    char filename[60];

    colormaploc.map[0] = map[0];
    colormaploc.map[1] = map[1];
    colormaploc.map[2] = map[2];

    ppixrect = pr_load(fnras->fpim, &colormaploc);
    fclose(fnras->fpim);

    if (ppixrect == NULL){
      sprintf(buf, mastertabs[146]);
      write_master(buf);
      return(-1);
    }
    if (ppixrect->pr_depth != 8){
      sprintf(buf, mastertabs[147]);
      write_master(buf);
      return(-1);
    }
    else descy.type = 0;
    descy.nligne = ppixrect->pr_size.y;
    descy.ncolonne = ppixrect->pr_size.x;
    strcpy(descy.comment,"");
    strcpy(descy.date,"");
    pr_data = mpr_d(ppixrect);
    strcpy(imname, fnras->filename);
    strcat(imname, ".");
    frdesname = strtok(imname, ".");
    sprintf(mapname, "%s.map", frdesname);
    sprintf(desname, "%s.des", frdesname);
    sprintf(imname, "%s.ima", frdesname);
    if ((fpm = fopen(mapname , "wb")) == NULL)
    {
      sprintf(mapname, "%s/%s", getenv("HOME"), find_name (mapname));
      if ((fpm = fopen(mapname,"wb")) == NULL)
      {
	write_erreur(40);
	return(-1);
      }
    }
    fwrite(colormaploc.map[0], 256, 1, fpm);
    fwrite(colormaploc.map[1], 256, 1, fpm);
    fwrite(colormaploc.map[2], 256, 1, fpm);
    fclose(fpm);

    imageraster =(unsigned char *) malloc(descy.nligne *descy.ncolonne * sizeof(unsigned char));
    if (!(descy.ncolonne & 0x01))
      memcpy(imageraster,pr_data->md_image,
	     descy.nligne * descy.ncolonne * sizeof(unsigned char));
    else
      {
	int y;
	unsigned char *Adrs=(unsigned char *)pr_data->md_image, *Adrd=imageraster;
	for (y = 0 ; y < descy.nligne ; y++ , Adrd += descy.ncolonne ,Adrs += descy.ncolonne+1)
	  memcpy(Adrd, Adrs, descy.ncolonne);
      }
    pr_destroy(ppixrect);
    if ((fp = fopen(imname , "wb")) == NULL)
    {
      sprintf(imname, "%s/%s", getenv("HOME"), find_name (imname));
      if ((fp = fopen(imname,"wb")) == NULL)
      {
	write_erreur(40);
	return(-1);
      }
    }

    fwrite(imageraster, descy.ncolonne, descy.nligne, fp);
    fclose(fp);

    if (dir_image[index_image[1]].image != NULL)
      free (dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageraster;
    strcpy (dir_desc[index_image[1]].date, descy.date);
    strcpy (dir_desc[index_image[1]].filename, imname);
    dir_desc[index_image[1]].type = descy.type;
    dir_desc[index_image[1]].ncolonne = descy.ncolonne;
    dir_desc[index_image[1]].nligne = descy.nligne;
    dir_desc[index_image[1]].mmin = descy.mini[0];
    dir_desc[index_image[1]].mmax = descy.maxi[0];
    dir_desc[index_image[1]].mu = descy.mu[0];
    dir_desc[index_image[1]].ecart = descy.ecart[0];
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type,
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax),
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));
    descy.mini[0]=dir_desc[index_image[1]].mmin;
    descy.maxi[0]=dir_desc[index_image[1]].mmax;
    descy.mu[0]=dir_desc[index_image[1]].mu;
    descy.ecart[0]=dir_desc[index_image[1]].ecart;
    descy.mini[1]=descy.maxi[1]=descy.mu[1]=descy.ecart[1]=0;
    descy.mini[2]=descy.maxi[2]=descy.mu[2]=descy.ecart[2]=0;
    descy.mini[3]=descy.maxi[3]=descy.mu[3]=descy.ecart[3]=0;
    descy.mini[4]=descy.maxi[4]=descy.mu[4]=descy.ecart[4]=0;
    descy.mini[5]=descy.maxi[5]=descy.mu[5]=descy.ecart[5]=0;

    if ((fp = fopen(desname , "w")) == NULL)
    {
      sprintf(desname, "%s/%s", getenv("HOME"), find_name (desname));
      if ((fp = fopen(desname,"w")) == NULL)
      {
	write_erreur(40);
	return(-1);
      }
    }

    if (write_desc(fp, descy) != 1){
      write_erreur(40);
      return(-1);
    }

    fclose(fp);
    return(1);
}
