/* SCCS @(#)mvoisin.c	1.1  12/2/92 */
/*****************************************************************************/
/* module mvoisin.c							     */
/*									     */
/* Author: Markus Buchi							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1988							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

x0_voisins(nl,image,liste_point)
/* met a jour les voisins dans image avec la liste  'liste_point' */
int nl;
short **image;
unsigned short **liste_point;
{
    unsigned short **liste,*c_liste,x;
    register unsigned short dep;
    int i;
    short *p_av,*p_ap,*q,*s,*r;
  /*  (*pf) ();   */

    liste = liste_point;
    for(i=1;i<=nl;i++)
       {
           p_av = *image++;      /* ligne precedente */
           p_ap = *(image + 1);  /* ligne suivante */
           c_liste = *liste++;
           while( *c_liste != 0 )
              {
		  dep = (*c_liste & 0177760);
                  dep = dep / 16;                   /* numero de la colonne */
                  q = p_av + dep;
                  r = *image + dep;
                  s = p_ap + dep;
                  x = *c_liste++ & 017;         /* 4 bits de poids faible */
                  switch(x)
                    {
                        case 1  : /* x0_a_vois(q,r) */
                                  *q = *q & ~02000;             /* bit 11 -> 0 */
                                  *(q-1) = *(q-1) & ~020000;    /* bit 14 -> 0 */
                                  *(r-1) = *(r-1) & ~0400;      /* bit 9 -> 0 */
                                  break;
                        case 2  : /* x0_b_vois(q,r) */
                                  *q = *q & ~04000;             /* bit 12 -> 0 */
                                  *(r+1) = *(r+1) & ~0100;      /* bit 7 -> 0 */
                                  break;
                        case 3  : /* x0_ab_vois(q,r) */
                                  *q = *q & ~06000;             /* bits 11 + 12 -> 0 */
                                  *(q-1) = *(q-1) & ~020000;    /* bit 14 -> 0 */
                                  *(r-1) = *(r-1) & ~0400;      /* bit 9 -> 0 */
                                  *(r+1) = *(r+1) & ~0100;      /* bit 7 -> 0 */
                                  break;
                        case 4  : /* x0_c_vois(r,s) */
                                  *(r-1) = *(r-1) & ~010000;    /* bit 13 -> 0 */
                                  *s = *s & ~020;               /* bit 5 -> 0 */
                                  break;
                        case 5  : /* x0_ac_vois(q,r,s) */
                                  *q = *q & ~02000;             /* bit 11 -> 0 */
                                  *(q-1) = *(q-1) & ~020000;    /* bit 14 -> 0 */
                                  *(r-1) = *(r-1) & ~010400;    /* bit 9 + 13 -> 0 */
                                  *s = *s & ~020;               /* bit 5 -> 0 */
                                  break;
                        case 6  : /* x0_bc_vois(q,r,s) */
                                  *q = *q & ~04000;             /* bit 12 -> 0 */
                                  *(r+1) = *(r+1) & ~0100;      /* bit 7 -> 0 */
                                  *(r-1) = *(r-1) & ~010000;    /* bit 13 -> 0 */
                                  *s = *s & ~020;               /* bit 5 -> 0 */
                                  break;
                        case 7  : /* x0_abc_vois(q,r,s) */
                                  *q = *q & ~06000;             /* bits 11 + 12 -> 0 */
                                  *(q-1) = *(q-1) & ~020000;    /* bit 14 -> 0 */
                                  *(r-1) = *(r-1) & ~010400;    /* bits 9 + 13 -> 0 */
                                  *(r+1) = *(r+1) & ~0100;      /* bit 7 -> 0 */
                                  *s = *s & ~020;               /* bit 5 -> 0 */
                                  break;
                        case 8  : /* x0_d_vois(r,s) */
                                  *(r+1) = *(r+1) & ~0200;      /* bit 8 -> 0 */
                                  *s = *s & ~01000;             /* bit 10 -> 0 */
                                  *(s+1) = *(s+1) & ~040;       /* bit 6 -> 0 */
                                  break;
                        case 9  : /* x0_ad_vois(q,r,s) */
                                  *q = *q & ~02000;             /* bit 11 -> 0 */
                                  *(q-1) = *(q-1) & ~020000;    /* bit 14 -> 0 */
                                  *(r-1) = *(r-1) & ~0400;      /* bit 9 -> 0 */
                                  *(r+1) = *(r+1) & ~0200;      /* bit 8 -> 0 */
                                  *s = *s & ~01000;             /* bit 10 -> 0 */
                                  *(s+1) = *(s+1) & ~040;       /* bit 6 -> 0 */
                                  break;
                        case 10 : /* x0_bd_vois(q,r,s) */
                                  *q = *q & ~04000;             /* bit 12 -> 0 */
                                  *(r+1) = *(r+1) & ~0300;      /* bits 7 + 8  -> 0 */
                                  *s = *s & ~01000;             /* bit 10 -> 0 */
                                  *(s+1) = *(s+1) & ~040;       /* bit 6 -> 0 */
                                  break;
                        case 11 : /* x0_abd_vois(q,r,s) */
                                  *q = *q & ~06000;             /* bits 11 + 12 -> 0 */
                                  *(q-1) = *(q-1) & ~020000;    /* bit 14 -> 0 */
                                  *(r-1) = *(r-1) & ~0400;      /* bit 9 -> 0 */
                                  *(r+1) = *(r+1) & ~0300;      /* bits 7 + 8 -> 0 */
                                  *s = *s & ~01000;             /* bit 10 -> 0 */
                                  *(s+1) = *(s+1) & ~040;       /* bit 6 -> 0 */
                                  break;
                        case 12 : /* x0_cd_vois(r,s) */
                                  *(r-1) = *(r-1) & ~010000;    /* bit 13 -> 0 */
                                  *(r+1) = *(r+1) & ~0200;      /* bit 8 -> 0 */
                                  *s = *s & ~01020;             /* bits 5 + 10 -> 0 */
                                  *(s+1) = *(s+1) & ~040;       /* bit 6 -> 0 */
                                  break;
                        case 13 : /* x0_acd_vois(q,r,s) */
                                  *q = *q & ~02000;             /* bit 11 -> 0 */                
                                  *(q-1) = *(q-1) & ~020000;    /* bit 14 -> 0 */
                                  *(r-1) = *(r-1) & ~010400;    /* bits 9 + 13 -> 0 */
                                  *(r+1) = *(r+1) & ~0200;      /* bit 8 -> 0 */
                                  *s = *s & ~01020;             /* bits 5 + 10 -> 0 */
                                  *(s+1) = *(s+1) & ~040;       /* bit 6 -> 0 */
                                  break;
                        case 14 : /* x0_bcd_vois(q,r,s) */
                                  *q = *q & ~04000;             /* bit 12 -> 0 */
                                  *(r+1) = *(r+1) & ~0300;      /* bits 7 + 8 -> 0 */
                                  *(r-1) = *(r-1) & ~010000;    /* bit 13 -> 0 */
                                  *s = *s & ~01020;             /* bits 5 + 10 -> 0 */
                                  *(s+1) = *(s+1) & ~040;       /* bit 6 -> 0 */
                                  break;
                        case 15 : /* x0_abcd_vois(q,r,s) */
                                  *q = *q & ~06000;             /* bits 11 + 12 -> 0 */
                                  *(q-1) = *(q-1) & ~020000;    /* bit 14 -> 0 */
                                  *(r-1) = *(r-1) & ~010400;    /* bit 9 + 13 -> 0 */
                                  *(r+1) = *(r+1) & ~0300;      /* bits 7 + 8 -> 0 */
                                  *s = *s & ~01020;             /* bits 5 + 10 -> 0 */
                                  *(s+1) = *(s+1) & ~040;       /* bit 6 -> 0 */
                                  break;
		    }
	      }
       }


}

/*************************************************************/



x1_voisins(nl,image,liste_point)
/* met a jour les voisins dans image avec la liste  'liste_point' */
int nl;
short **image;
unsigned short **liste_point;
{
    unsigned short **liste,*c_liste,x;
    register unsigned short dep;
    int i;
    short *p_av,*p_ap,*q,*s,*r;

    liste = liste_point;
    for(i=1;i<=nl;i++)
       {
           p_av = *image++;      /* ligne precedente */
           p_ap = *(image + 1);  /* ligne suivante */
           c_liste = *liste++;
           while( *c_liste != 0 )
              {
		  dep = (*c_liste & 0177760);
                  dep = dep / 16;                   /* numero de la colonne */
                  q = p_av + dep;
                  r = *image + dep;
                  s = p_ap + dep;
                  x = *c_liste++ & 017;         /* 4 bits de poids faible */
                  switch(x)
                    {
                        case 1  : /* x1_a_vois(q,r) */
                                  *q = *q | 02000;             /* bit 11 -> 1 */
                                  *(q-1) = *(q-1) | 020000;    /* bit 14 -> 1 */
                                  *(r-1) = *(r-1) | 0400;      /* bit 9 -> 1 */
                                  break;    

                        case 2  : /* x1_b_vois(q,r) */
                                  *q = *q | 04000;             /* bit 12 -> 1 */
                                  *(r+1) = *(r+1) | 0100;      /* bit 7 -> 1 */
                                  break;

                        case 3  : /* x1_ab_vois(q,r) */
                                  *q = *q | 06000;             /* bits 11 + 12 -> 1 */
                                  *(q-1) = *(q-1) | 020000;    /* bit 14 -> 1 */
                                  *(r-1) = *(r-1) | 0400;      /* bit 9 -> 1 */
                                  *(r+1) = *(r+1) | 0100;      /* bit 7 -> 1 */
                                  break;

                       case 4  : /* x1_c_vois(r,s) */
                                 *(r-1) = *(r-1) | 010000;    /* bit 13 -> 1 */
                                 *s = *s | 020;               /* bit 5 -> 1 */
                                 break;

                       case 5  : /* x1_ac_vois(q,r,s) */
                                 *q = *q | 02000;             /* bit 11 -> 1 */
                                 *(q-1) = *(q-1) | 020000;    /* bit 14 -> 1 */
                                 *(r-1) = *(r-1) | 010400;    /* bit 9 + 13 -> 1 */
                                 *s = *s | 020;               /* bit 5 -> 1 */
                                 break;

                       case 6  : /* x1_bc_vois(q,r,s) */
                                 *q = *q | 04000;             /* bit 12 -> 1 */
                                 *(r+1) = *(r+1) | 0100;      /* bit 7 -> 1 */
                                 *(r-1) = *(r-1) | 010000;    /* bit 13 -> 1 */
                                 *s = *s | 020;               /* bit 5 -> 1 */
                                 break;

                       case 7  : /* x1_abc_vois(q,r,s) */
                                 *q = *q | 06000;             /* bits 11 + 12 -> 1 */
                                 *(q-1) = *(q-1) | 020000;    /* bit 14 -> 1 */
                                 *(r-1) = *(r-1) | 010400;    /* bits 9 + 13 -> 1 */
                                 *(r+1) = *(r+1) | 0100;      /* bit 7 -> 1 */
                                 *s = *s | 020;               /* bit 5 -> 1 */
                                 break;

                       case 8  : /* x1_d_vois(r,s) */
                                 *(r+1) = *(r+1) | 0200;      /* bit 8 -> 1 */
                                 *s = *s | 01000;             /* bit 10 -> 1 */
                                 *(s+1) = *(s+1) | 040;       /* bit 6 -> 1 */
                                 break;

                       case 9  : /* x1_ad_vois(q,r,s) */
                                 *q = *q | 02000;             /* bit 11 -> 1 */
                                 *(q-1) = *(q-1) | 020000;    /* bit 14 -> 1 */
                                 *(r-1) = *(r-1) | 0400;      /* bit 9 -> 1 */
                                 *(r+1) = *(r+1) | 0200;      /* bit 8 -> 1 */
                                 *s = *s | 01000;             /* bit 10 -> 1 */
                                 *(s+1) = *(s+1) | 040;       /* bit 6 -> 1 */
                                 break;

                       case 10 : /* x1_bd_vois(q,r,s) */
                                 *q = *q | 04000;             /* bit 12 -> 1 */
                                 *(r+1) = *(r+1) | 0300;      /* bits 7 + 8  -> 1 */
                                 *s = *s | 01000;             /* bit 10 -> 1 */
                                 *(s+1) = *(s+1) | 040;       /* bit 6 -> 1 */
                                 break;

                       case 11 : /* x1_abd_vois(q,r,s) */
                                 *q = *q | 06000;             /* bits 11 + 12 -> 1 */
                                 *(q-1) = *(q-1) | 020000;    /* bit 14 -> 1 */
                                 *(r-1) = *(r-1) | 0400;      /* bit 9 -> 1 */
                                 *(r+1) = *(r+1) | 0300;      /* bits 7 + 8 -> 1 */      
                                 *s = *s | 01000;             /* bit 10 -> 1 */
                                 *(s+1) = *(s+1) | 040;       /* bit 6 -> 1 */
                                 break;

                       case 12 : /* x1_cd_vois(r,s) */
                                 *(r-1) = *(r-1) | 010000;    /* bit 13 -> 1 */
                                 *(r+1) = *(r+1) | 0200;      /* bit 8 -> 1 */
                                 *s = *s | 01020;             /* bits 5 + 10 -> 1 */
                                 *(s+1) = *(s+1) | 040;       /* bit 6 -> 1 */
                                 break;

                       case 13 : /* x1_acd_vois(q,r,s) */
                                 *q = *q | 02000;             /* bit 11 -> 1 */
                                 *(q-1) = *(q-1) | 020000;    /* bit 14 -> 1 */
                                 *(r-1) = *(r-1) | 010400;    /* bits 9 + 13 -> 1 */
                                 *(r+1) = *(r+1) | 0200;      /* bit 8 -> 1 */
                                 *s = *s | 01020;             /* bits 5 + 10 -> 1 */
                                 *(s+1) = *(s+1) | 040;       /* bit 6 -> 1 */
                                 break;

                       case 14 : /* x1_bcd_vois(q,r,s) */
                                 *q = *q | 04000;             /* bit 12 -> 1 */
                                 *(r+1) = *(r+1) | 0300;      /* bits 7 + 8 -> 1 */
                                 *(r-1) = *(r-1) | 010000;    /* bit 13 -> 1 */
                                 *s = *s | 01020;             /* bits 5 + 10 -> 1 */
                                 *(s+1) = *(s+1) | 040;       /* bit 6 -> 1 */
                                 break;

                       case 15 : /* x1_abcd_vois(q,r,s) */
                                 *q = *q | 06000;             /* bits 11 + 12 -> 1 */
                                 *(q-1) = *(q-1) | 020000;    /* bit 14 -> 1 */
                                 *(r-1) = *(r-1) | 010400;    /* bit 9 + 13 -> 1 */
                                 *(r+1) = *(r+1) | 0300;      /* bits 7 + 8 -> 1 */
                                 *s = *s | 01020;             /* bits 5 + 10 -> 1 */
                                 *(s+1) = *(s+1) | 040;       /* bit 6 -> 1 */
                                 break;
		    }
	      }
       }


}




/*****************************************************************************/

