/* SCCS @(#)profile.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       profile.layout.c                               */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   profile.layout.c                                    */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Profile on Image)                        */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "../libwidgets/widgetstructure.h"
#include "profile.layout.h"

#define MAX_ARGS 100

extern XmFontList gFontlist;
extern Display *gDisplay;

extern void track_mouse_profile();
extern void keep_sensitive_button();

extern char *roitabs[];

/********************************************************
/   Creation Function for profile_widget 
/*******************************************************/

Widget
build_profile_widget(profile, data_display)
	Widget profile;
	xs_struc_display_menu * data_display;
{
	Widget profile_widget;
	Widget separator;
	Widget command;
	Widget HELP;
	Widget QUIT;
	Widget profile_command;
	Widget CREATE;
	Widget SHOW;
	Widget GET_PROFILE;
	Widget ScrolledWindow_profile;
	Widget drawing_profile;
	Widget profile_param;
	Widget label_p1;
	Widget label_p2;
	Widget label_p3;
	Widget label_p4;
	Widget label_p5;
	Widget label_p6;
	char message[25];
	Arg args[MAX_ARGS];
	int n;

	/* Creating profile_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNwidth, 520); n++;
	XtSetArg(args[n],XmNheight,320); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNx,0); n++;
	XtSetArg(args[n],XmNy,0); n++;
	XtSetArg(args[n],XmNdialogTitle, 
		 XmStringLtoRCreate(paneltabs[63], 
				    XmSTRING_DEFAULT_CHARSET)); n++;

	profile_widget = 
	   XmCreateFormDialog(profile,"profile_widget",args,n);

	/* Creating command Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

	command = XmCreateForm(profile_widget,"command",args,n);
	XtManageChild(command);

	/* Creating QUIT Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[313],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,60); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,96); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	QUIT = XmCreatePushButton(command,"QUIT",args,n);
	XtManageChild(QUIT);

	/* Adding Callbacks for QUIT */ 

	XtAddCallback(QUIT,XmNactivateCallback, 
		      profile_QUIT_callb, data_display);
	XtAddCallback(QUIT,XmNactivateCallback, 
		      keep_sensitive_button, profile);

	/* Creating HELP Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[312],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,4); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNsensitive,False); n++;

	HELP = XmCreatePushButton(command,"HELP",args,n);
	XtManageChild(HELP);

	/* Adding Callbacks for HELP */

	XtAddCallback (HELP, XmNactivateCallback, 
		       profile_HELP_callb, profile_widget);


	/* Creating separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,command); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	separator = XmCreateSeparator(profile_widget,"separator",args,n);
	XtManageChild(separator);

	/* Creating profile_command Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget, separator); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	profile_command = 
	   XmCreateForm(profile_widget,"profile_command",args,n);

  	/* Creating SHOW Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("REDISPLAY",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,10); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,90); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 25); n++;
	XtSetArg(args[n],XmNsensitive, False); n++;

	SHOW = XmCreatePushButton(profile_command,"SHOW",args,n);
	XtManageChild(SHOW);

	/* Adding Callbacks for SHOW */ 

	XtAddCallback(SHOW,XmNactivateCallback, 
		      profile_SHOW_callb, data_display);


  	/* Creating CREATE Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,10); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,90); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 10); n++;

	CREATE = XmCreatePushButton(profile_command,"CREATE",args,n);
	XtManageChild(CREATE);

	/* Adding Callbacks for CREATE */ 

	XtAddCallback(CREATE,XmNactivateCallback, 
		      profile_CREATE_callb, data_display);
	XtAddCallback(CREATE,XmNactivateCallback, 
		      profile_CREATE_2callb, SHOW);


  	/* Creating GET_PROFILE Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("GET PROFILE",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,10); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,90); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 40); n++;

	GET_PROFILE = XmCreatePushButton(profile_command,"GET_PROFILE",args,n);
	XtManageChild(GET_PROFILE);

	/* Adding Callbacks for GET_PROFILE */ 

	XtAddCallback(GET_PROFILE,XmNactivateCallback, 
		      profile_GET_PROFILE_callb, data_display);

	XtManageChild(profile_command);


	/* Creating profile_param Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget, separator); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	profile_param = 
	   XmCreateForm(profile_widget,"profile_param",args,n);

	/* Creating label_p1 Widget */ 
        sprintf (message, "P1 (    ,    ) Val:     ");
	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,6); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,94); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,10); n++;
	label_p1 = XmCreateLabel(profile_param,"label_p1",args,n);
	XtManageChild(label_p1);

	data_display->label_profile[0] = label_p1;

	/* Creating label_p2 Widget */ 

        sprintf (message, "P2 (    ,    ) Val:     ");
	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,6); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,94); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,20); n++;
	label_p2 = XmCreateLabel(profile_param,"label_p2",args,n);
	XtManageChild(label_p2);

	data_display->label_profile[1] = label_p2;

	/* Creating label_p3 Widget */ 

        sprintf (message, "  Distance:          pixels  ");
	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,6); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,94); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,30); n++;
	label_p3 = XmCreateLabel(profile_param,"label_p3",args,n);
	XtManageChild(label_p3);

	data_display->label_profile[2] = label_p3;

	/* Creating label_p4 Widget */ 

        sprintf (message, "Angle:          degrees");
	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,6); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,94); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,40); n++;
	label_p4 = XmCreateLabel(profile_param,"label_p4",args,n);
	XtManageChild(label_p4);

	data_display->label_profile[3] = label_p4;

	XtManageChild(profile_param);

	/* Creating label_p5 Widget */ 
        sprintf (message, "  X:     Y:     ");
	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,6); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,94); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,65); n++;
	label_p5 = XmCreateLabel(profile_param,"label_p5",args,n);
	XtManageChild(label_p5);

	data_display->label_profile[4] = label_p5;


	/* Creating label_p6 Widget */ 
        sprintf (message, " Val:      ");
	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,6); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,94); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,75); n++;
	label_p6 = XmCreateLabel(profile_param,"label_p6",args,n);
	XtManageChild(label_p6);

	data_display->label_profile[5] = label_p6;


	/* Creating ScrolledWindow_profile Widget */ 

	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNrightWidget, profile_param); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNleftWidget, profile_command);n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNbottomWidget, separator); n++;
	XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC);n++;
	ScrolledWindow_profile = 
	       XtCreateManagedWidget("ScrolledWindow_profile", 
				     xmScrolledWindowWidgetClass,
				     profile_widget, args, n);

	n = 0;
	/* Ses dimensions sont definies a la creation du profil ! */
	drawing_profile = 
	    XtCreateWidget("drawing_profile", xmDrawingAreaWidgetClass,
				  ScrolledWindow_profile, args, n);
	data_display->Drawing_Area_profile = drawing_profile;
	
	XtManageChild(drawing_profile);

	XtAddEventHandler(drawing_profile, PointerMotionMask, FALSE,
                          track_mouse_profile, data_display);

	n = 0;
	XtSetArg(args[n], XmNworkWindow, drawing_profile); n++;
	XtSetValues(ScrolledWindow_profile, args, n);
	XtManageChild(ScrolledWindow_profile);
	
	return(profile_widget);
}
