/* SCCS @(#)displayplane.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       displayplane.callback.c                        */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   displayplane.callback.c                             */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Display Image)                           */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "../libwidgets/widgetstructure.h"
#include "displayplane.h"
#include "displayplane.callback.h"
#include "DISPLAYmenu.layout.h"

extern Display *gDisplay;
extern GC default_gc;

extern int PixelEditTool_Open_Flag;

/******************************************************
/   activateCallback for Widget  conv_CANCEL 
/*****************************************************/

void
QUIT_callb (menu_QUIT, shell_display, callData)
	Widget menu_QUIT;
	Widget shell_display;
	caddr_t callData;
{
  XtDestroyWidget (shell_display);
  PixelEditTool_Open_Flag = FALSE;
}



void
freeColormap (menu_QUIT, my_colormap, callData)
	Widget menu_QUIT;
	Colormap my_colormap;
	caddr_t callData;
{
	XFreeColormap (gDisplay, my_colormap);
}


void redisplay (w, pixmap_draw, call_data)
Widget w;
Pixmap pixmap_draw;
XmDrawingAreaCallbackStruct *call_data;
{
  XExposeEvent *event = (XExposeEvent *) call_data->event;
  XCopyArea (XtDisplay(w), pixmap_draw, XtWindow (w), default_gc, 
	     event->x, event->y, event->width, event->height, 
	     event->x, event->y);
}



void dans_histo (w, histoparam, call_data)
Widget w;
xs_struc_histo * histoparam;
XmDrawingAreaCallbackStruct *call_data;
{
    struct description_vecteur *info_hist;
    struct histogr *ih;
    int no_barre, i, n;
    float delta, pct;
    char * rep;
    Arg args[MAX_ARGS];

XButtonPressedEvent *event = (XButtonPressedEvent *) call_data->event;
  switch (event->type){
    case ButtonPress:
	rep = (char *)malloc(40);
	info_hist = histoparam->dv;
	ih = (struct histogr *)info_hist->prive;
	no_barre =  event->x / ih->larg_barre;
	delta = (info_hist->b_max - info_hist->b_min + 1) / info_hist->ncase; 
	pct = 0.0;
	for (i=0; i<=no_barre; i++)
	    pct += (float)*(ih->tab_hist + i);
	pct = pct / info_hist->total * 100.0;
	n = 0;
	sprintf (rep, "%.0f-%.0f", info_hist->b_min + delta * no_barre, 
				   info_hist->b_min + delta * (no_barre + 1) - 1);
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(rep, XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues (histoparam->level , args, n);
	n = 0;
	sprintf (rep, "%.4f%%", 
		(float)(*(ih->tab_hist+no_barre)) / info_hist->total * 100.0);
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(rep, XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues (histoparam->percent , args, n);
	n = 0;
	sprintf (rep, "%.4f%%", (float) pct);
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(rep, XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues (histoparam->percent_tot , args, n);

/*XDrawPoint (XtDisplay(w), data->Pix, data->gc, event->x, event->y);
 faire un redisplay sinon les points ne s'affichent pas!*/
       break;
    default: break;
  }
}

