/* SCCS @(#)DISPLAYmenu.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                            DISPLAYmenu.layout.c                      */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   DISPLAYmenu.layout.c                                */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Display Menu)                            */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/


#include "../libwidgets/widgetstructure.h"
#include "DISPLAYmenu.layout.h"

#define MAX_ARGS 100

extern XmFontList gFontlist;
extern Pixel      gthistle;

extern char *disptabs[];

/*******************************************************
/   Creation Function for Display_Menu 
/*******************************************************/

void
build_Display_Menu(DISPLAYmenu, data_display)
	Widget DISPLAYmenu;
	xs_struc_display_menu * data_display;
{
	Widget Display_Menu;
	Widget Display_menu_label;
	Widget Separator_12;
	Widget Calliper_button;
	Widget Statistics_button;
	Widget Threshold_button;
	Widget Region_Interest_button;
	Widget Save_Color_Table_button;
	Widget Pixel_Edit_button;
	Widget Profile_button;
	Widget Separator_13;
	Widget Preferences_button;
	Widget PulldownMenu_Pref;
	Widget Coord_top_down;
	Widget Coord_left_right;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Display_Menu Widget */ 

	Display_Menu = CreatePulldownMenu(DISPLAYmenu,"Display_Menu",NULL,0);

	/* Creating Display_menu_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNbackground, gthistle); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[56],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Display_menu_label = XmCreateLabel(Display_Menu,"Display_menu_label",args,n);
	XtManageChild(Display_menu_label);

	/* Creating Separator_12 Widget */ 

	Separator_12 = XmCreateSeparator(Display_Menu,"Separator_12",NULL,0);
	XtManageChild(Separator_12);

	/* Creating Calliper_button Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(disptabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Calliper_button = 
	   XmCreatePushButton(Display_Menu,"Calliper_button",args,n);
	XtManageChild(Calliper_button);

	/* Adding Callbacks for Calliper_button */ 

	XtAddCallback(Calliper_button, XmNactivateCallback,
		      Calliper_actcall, data_display);

	/* Creating Statistics_button Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(disptabs[5],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Statistics_button = 
	   XmCreatePushButton(Display_Menu,"Statistics_button",args,n);
	XtManageChild(Statistics_button);

	/* Adding Callbacks for Statistics_button */ 

	XtAddCallback(Statistics_button, XmNactivateCallback,
		      statistics_actcall, data_display->im_desc);

	/* Creating Threshold_button Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(disptabs[6],
			XmSTRING_DEFAULT_CHARSET)); n++;
	if ((data_display->colormap == 5) || (data_display->colormap == 6))
	{
	  XtSetArg(args[n],XmNsensitive, False); n++;
	}

	Threshold_button = 
	   XmCreatePushButton(Display_Menu,"Threshold_button",args,n);
	XtManageChild(Threshold_button);

	/* Adding Callbacks for Threshold_button */ 

	XtAddCallback(Threshold_button, XmNactivateCallback,
		      Threshold_actcall,data_display);

	/* Creating Region_Interest_button Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(disptabs[7],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Region_Interest_button = 
		XmCreatePushButton(Display_Menu,"Region_Interest_button",args,n);
	XtManageChild(Region_Interest_button);

	/* Adding Callbacks for Region_Interest_button */ 

	XtAddCallback(Region_Interest_button, XmNactivateCallback,
		      RegionInterest_actcall,data_display);

	/* Creating Save_Color_Table_button Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(disptabs[8],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Save_Color_Table_button = 
	    XmCreatePushButton(Display_Menu,
			       "Save_Color_Table_button",args,n);

	XtManageChild(Save_Color_Table_button);

	/* Adding Callbacks for Save_Color_Table_button */ 

	XtAddCallback(Save_Color_Table_button, XmNactivateCallback,
		      Save_Color_Table_actcall, data_display);

	/* Creating Pixel_Edit_button Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(disptabs[9],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Pixel_Edit_button = 
	   XmCreatePushButton(Display_Menu,"Pixel_Edit_button",args,n);
	XtManageChild(Pixel_Edit_button);

	/* Adding Callbacks for Pixel_Edit_button */ 

	XtAddCallback(Pixel_Edit_button,XmNactivateCallback,
		      Pixel_Edit_actcall,data_display);

	/* Creating Profile_button Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(disptabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Profile_button = 
	   XmCreatePushButton(Display_Menu,"Profile_button",args,n);

	XtManageChild(Profile_button);

	/* Adding Callbacks for Profile_button */ 

	XtAddCallback(Profile_button,XmNactivateCallback,
		      Profile_actcall,data_display);


	/* Creating Separator_13 Widget */ 

	Separator_13 = XmCreateSeparator(Display_Menu,"Separator_13",NULL,0);
	XtManageChild(Separator_13);


	/* Creating Preferences_button Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(disptabs[10],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Preferences_button = 
		XmCreateCascadeButton(Display_Menu,"Preferences_button",args,n);
	XtManageChild(Preferences_button);

	/* Creating PulldownMenu_Pref Widget */ 

	PulldownMenu_Pref = 
	     CreatePulldownMenu(Preferences_button,"PulldownMenu_Pref",NULL,0);

	/* Creating Coord_top_down Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(disptabs[11],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Coord_top_down = 
		XmCreatePushButton(PulldownMenu_Pref,"Coord_top_down",args,n);
	XtManageChild(Coord_top_down);

	/* Adding Callbacks for Coord_top_down */ 

	XtAddCallback(Coord_top_down,
	    XmNactivateCallback, Coord_top_down_actcall, data_display);


	/* Creating Coord_left_right Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(disptabs[15],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Coord_left_right = 
		XmCreatePushButton(PulldownMenu_Pref,"Coord_left_right",args,n);
	XtManageChild(Coord_left_right);

	/* Adding Callbacks for Coord_left_right */ 

	XtAddCallback(Coord_left_right,
	    XmNactivateCallback, Coord_left_right_actcall, data_display);

}
