/*****************************************************************************/
/* module fromto.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

#include <suntool/sunview.h>
#include <suntool/panel.h>

#include "define.h"
#include "structure.h"
#include "global.h"

Frame	    frame_fromto;
Panel	    panel_fromto;
Panel_item  nodep1, nodep2, nodep3, nodep4, noarr1, noarr2, noarr3, noarr4;
int	    row;

extern char *paneltabs[];


static Panel_setting lire_no (item, event)
    Panel_item	item;
    Event	*event;
{
    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
        window_return (NULL);
        window_destroy (frame_fromto);
        return; 
    }
    else { 
        if (event_id(event) == '\t') 
	    return(PANEL_NEXT);
	else {
	    if (nodep1 != NULL)
		if ((int)panel_get(item, PANEL_CLIENT_DATA) == 0)     
		index_image[0] = atoi((char *)panel_get(nodep1, PANEL_VALUE));
		else
		index_vect[0] = atoi((char *)panel_get(nodep1, PANEL_VALUE));
	    if (nodep2 != NULL)     
		if ((int)panel_get(item, PANEL_CLIENT_DATA) == 0)     
		index_image[2] = atoi((char *)panel_get(nodep2, PANEL_VALUE));
		else
		index_vect[2] = atoi((char *)panel_get(nodep2, PANEL_VALUE));
	    if (nodep3 != NULL)     
		index_image[4] = atoi((char *)panel_get(nodep3, PANEL_VALUE));
	    if (nodep4 != NULL)     
		index_image[6] = atoi((char *)panel_get(nodep4, PANEL_VALUE));
	    if (noarr1 != NULL)     
		if ((int)panel_get(item, PANEL_CLIENT_DATA) == 0)     
		index_image[1] = atoi((char *)panel_get(noarr1, PANEL_VALUE));
		else
		index_vect[1] = atoi((char *)panel_get(noarr1, PANEL_VALUE));
	    if (noarr2 != NULL)     
		if ((int)panel_get(item, PANEL_CLIENT_DATA) == 0)     
		index_image[3] = atoi((char *)panel_get(noarr2, PANEL_VALUE));
		else
		index_vect[3] = atoi((char *)panel_get(noarr2, PANEL_VALUE));
	    if (noarr3 != NULL)     
		index_image[5] = atoi((char *)panel_get(noarr3, PANEL_VALUE));
	    if (noarr4 != NULL)     
		index_image[7] = atoi((char *)panel_get(noarr4, PANEL_VALUE));
            window_return(NULL);
	    window_destroy (frame_fromto);
	     return;
	}
    }
}

int creer_item (mode, item, row, finq)
    Panel_item	*item;
    int		mode, *row;
    char	*finq;
{
    char question[35];

    if (mode == 0) strcpy (question, paneltabs[69]);
    else strcpy (question, paneltabs[70]);
    strcat (question, finq);
    *item = panel_create_item (panel_fromto, PANEL_TEXT,
                    PANEL_SHOW_ITEM, TRUE,
		    PANEL_LABEL_X, ATTR_COL(1),
		    PANEL_LABEL_Y, ATTR_ROW(*row),
                    PANEL_VALUE_DISPLAY_LENGTH, 20,
                    PANEL_VALUE_STORED_LENGTH, 20,
                    PANEL_LABEL_STRING, question,
                    PANEL_VALUE, "",
                    PANEL_NOTIFY_STRING, "\r\n\t\03",
                    PANEL_NOTIFY_PROC, lire_no,
                    0);
    if (mode==0) panel_set (*item, PANEL_CLIENT_DATA, 0, 0);
    else panel_set (*item, PANEL_CLIENT_DATA, 1, 0);
    (*row)++;
}

int fromto (mode, question)
    int	mode, question;
{
    Panel_item	im_libre, im_occupe, titre_dep, titre_arr;
    char    rep_libre[48], rep_occupe [48], nbr[4];
    int	    i;

    if (descr_file(flag_debug) >= 2){

    frame_fromto = window_create(frame, FRAME , WIN_X, 500 , WIN_Y, 500 ,
                             FRAME_NO_CONFIRM, TRUE, 0);
    panel_fromto = window_create(frame_fromto, PANEL, 
                       PANEL_LABEL_BOLD, TRUE, 0);

    strcpy(rep_libre, paneltabs[71]);
    strcpy(rep_occupe, paneltabs[72]);
    for (i = 0; i < MAX_IMAGE; i++) {
        if (dir_image[i].flag_reserve == LIBRE) {
            /* considere seulement les plans-image non reserves */
            /* par le systeme de traitement d'images            */
            strcpy (nbr, "");
            sprintf (nbr, " %d ", i);
	    if (dir_image[i].image == NULL) strcat (rep_libre, nbr); 
            else strcat (rep_occupe, nbr);
	}
    }    
    strcat (rep_libre, "\n");
    strcat (rep_occupe, "\n");
    im_libre = panel_create_item (panel_fromto, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(0),
		       PANEL_LABEL_Y, ATTR_ROW(0),
                       PANEL_LABEL_STRING, rep_libre,
                       0);
    im_occupe = panel_create_item (panel_fromto, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(0),
		       PANEL_LABEL_Y, ATTR_ROW(1),
                       PANEL_LABEL_STRING, rep_occupe,
                       0);
    row = 3;
    nodep1 = NULL;  nodep2 = NULL;  nodep3 = NULL, nodep4 = NULL;
    noarr1 = NULL;  noarr2 = NULL;  noarr3 = NULL, noarr4 = NULL;
    if (mode == FROMTO || mode == FROM){
        titre_dep = panel_create_item (panel_fromto, PANEL_MESSAGE,
		    PANEL_SHOW_ITEM, TRUE,
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_Y, ATTR_ROW(row),
		    PANEL_LABEL_STRING, paneltabs[73], 0);
	row++;
	switch (question) {
	    case RGB :	creer_item (0, &nodep1, &row,paneltabs[74]);
			creer_item (0, &nodep2, &row, paneltabs[75]);
			creer_item (0, &nodep3, &row, paneltabs[76]);
			break;
	    case COMPL12: 
	    case COMPL1:creer_item (0, &nodep1, &row, paneltabs[77]);
			creer_item (0, &nodep2, &row, paneltabs[78]);
			break; 
	    case COMPL21:
	    case COMPL2:creer_item (0, &nodep1, &row, paneltabs[79]);
			creer_item (0, &nodep2, &row, paneltabs[80]);
			break; 
	    case COMPL142:
			creer_item (0, &nodep1, &row, paneltabs[81]);
			creer_item (0, &nodep2, &row, paneltabs[82]);
			creer_item (0, &nodep3, &row, paneltabs[83]);
			creer_item (0, &nodep4, &row, paneltabs[84]);
			break;
	    case CONDI:	creer_item (0, &nodep1, &row, paneltabs[85]);
			break; 
	    case DEF21:	creer_item (0, &nodep1, &row, "1:");
			creer_item (0, &nodep2, &row, "2:");
			break; 
            case REFERENC :
	    case DEFCOMPL1:
	    case DEFAUT:creer_item (0, &nodep1, &row, ":");
			break; 
	}
    }
    if (mode == FROMTO || mode == TO){
        titre_arr = panel_create_item (panel_fromto, PANEL_MESSAGE,
			    PANEL_SHOW_ITEM, TRUE,
			    PANEL_LABEL_X, ATTR_COL(0),
			    PANEL_LABEL_Y, ATTR_ROW(row),
			    PANEL_LABEL_STRING, paneltabs[100], 0);
	row++;
	switch (question) {
	    case RGB :	creer_item (0, &noarr1, &row, paneltabs[74]);
			creer_item (0, &noarr2, &row, paneltabs[75]);
			creer_item (0, &noarr3, &row, paneltabs[76]);
			break; 
	    case DEFCOMPL1:
	    case COMPL142:
	    case COMPL21:
	    case COMPL1:creer_item (0, &noarr1, &row, paneltabs[77]);
			creer_item (0, &noarr2, &row, paneltabs[78]);
			break; 
	    case COMPL12:
	    case COMPL2:creer_item (0, &noarr1, &row, paneltabs[79]);
			creer_item (0, &noarr2, &row, paneltabs[80]);
			break; 
	    case CONDI:	creer_item (0, &noarr1, &row, paneltabs[81]);
			break; 
            case REFERENC :
			creer_item (0, &noarr1, &row, paneltabs[86]);
			creer_item (0, &noarr2, &row, paneltabs[87]);
			break; 
	    case DEF21:	
	    case DEFAUT:creer_item (0, &noarr1, &row, ":");
			break; 
	}
    }
    if (flag_exec == MANUEL || flag_exec == PARAM_AUTO){
	char *val;
	val = (char *)malloc(3);
	if (nodep1 != NULL) 
	    panel_set_value(nodep1,sprintf(val,"%d",macro_cour->from[0]));
	if (nodep2 != NULL) 
	    panel_set_value(nodep2,sprintf(val,"%d",macro_cour->from[1]));
	if (nodep3 != NULL) 
	    panel_set_value(nodep3,sprintf(val,"%d",macro_cour->from[2]));
	if (nodep4 != NULL) 
	    panel_set_value(nodep4,sprintf(val,"%d",macro_cour->from[3]));
	if (noarr1 != NULL) 
	    panel_set_value(noarr1,sprintf(val,"%d",macro_cour->to[0]));
	if (noarr2 != NULL) 
	    panel_set_value(noarr2,sprintf(val,"%d",macro_cour->to[1]));
	if (noarr3 != NULL) 
	    panel_set_value(noarr3,sprintf(val,"%d",macro_cour->to[2]));
	if (noarr4 != NULL) 
	    panel_set_value(noarr4,sprintf(val,"%d",macro_cour->to[3]));
	free(val);
    }
    if (nodep1 != NULL)
	window_set (panel_fromto, PANEL_CARET_ITEM, nodep1, 0);
    else
	window_set (panel_fromto, PANEL_CARET_ITEM, noarr1, 0);
    window_fit (panel_fromto);
    window_fit (frame_fromto);
    window_loop (frame_fromto);
    return(0);
    }
    else {
	flag_break = TRUE;
	write_erreur (30);
	return(1);
    }

}

int fromto_vect (mode, question)
    int	mode, question;
{
    Panel_item	vect_libre, vect_occupe, titre_dep, titre_arr;
    char    rep_libre[48], rep_occupe [48], nbr[4];
    int	    i;

    frame_fromto = window_create(frame, FRAME , WIN_X, 500 , WIN_Y, 500 ,
                             FRAME_NO_CONFIRM, TRUE, 0);
    panel_fromto = window_create(frame_fromto, PANEL, 
                       PANEL_LABEL_BOLD, TRUE, 0);

    strcpy(rep_libre, paneltabs[88]);
    strcpy(rep_occupe, paneltabs[89]);
    for (i = 0; i < MAX_IMAGE; i++) {
        if (dir_vecteur[i].flag_reserve == LIBRE) {
            /* considere seulement les plans-image non reserves */
            /* par le systeme de traitement d'images            */
            strcpy (nbr, "");
            sprintf (nbr, " %d ", i);
	    if (dir_vecteur[i].image == NULL) strcat (rep_libre, nbr); 
            else strcat (rep_occupe, nbr);
	}
    }    
    strcat (rep_libre, "\n");
    strcat (rep_occupe, "\n");
    vect_libre = panel_create_item (panel_fromto, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(0),
		       PANEL_LABEL_Y, ATTR_ROW(0),
                       PANEL_LABEL_STRING, rep_libre,
                       0);
    vect_occupe = panel_create_item (panel_fromto, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(0),
		       PANEL_LABEL_Y, ATTR_ROW(1),
                       PANEL_LABEL_STRING, rep_occupe,
                       0);
    row = 3;
    nodep1 = NULL;  nodep2 = NULL;  nodep3 = NULL, nodep4 = NULL;
    noarr1 = NULL;  noarr2 = NULL;  noarr3 = NULL, noarr4 = NULL;
    if (mode == FROMTO || mode == FROM){
        titre_dep = panel_create_item (panel_fromto, PANEL_MESSAGE,
		    PANEL_SHOW_ITEM, TRUE,
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_Y, ATTR_ROW(row),
		    PANEL_LABEL_STRING, paneltabs[90], 0);
	row++;
	switch (question) {
	    case DEFAUT:creer_item (1, &nodep1, &row, ":");
			break; 
	}
    }
    if (mode == FROMTO || mode == TO){
        titre_arr = panel_create_item (panel_fromto, PANEL_MESSAGE,
			    PANEL_SHOW_ITEM, TRUE,
			    PANEL_LABEL_X, ATTR_COL(0),
			    PANEL_LABEL_Y, ATTR_ROW(row),
			    PANEL_LABEL_STRING, paneltabs[101], 0);
	row++;
	switch (question) {
	    case DEFAUT:creer_item (1, &noarr1, &row, ":");
			break; 
	}
    }
    if (flag_exec == MANUEL || flag_exec == PARAM_AUTO){
	char *val;
	val = (char *)malloc(3);
	if (nodep1 != NULL) 
	    panel_set_value(nodep1,sprintf(val,"%d",macro_cour->from[0]));
	if (noarr1 != NULL) 
	    panel_set_value(noarr1,sprintf(val,"%d",macro_cour->to[0]));
	free(val);
    }
    if (nodep1 != NULL)
	window_set (panel_fromto, PANEL_CARET_ITEM, nodep1, 0);
    else
	window_set (panel_fromto, PANEL_CARET_ITEM, noarr1, 0);
    window_fit (panel_fromto);
    window_fit (frame_fromto);
    window_loop (frame_fromto);
    return(0);
}
