/*****************************************************************************/
/* module rehaus.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <math.h>

#include "define.h"
#include "type.h"
#include "structure.h"
#include "global.h"
 
/* extern	egpr_();	*SPIDER* edge preserving smoothing operation */

int	*histequalize();  	/*egalisation histo*/
int     *SlideWindow();		/*filtre median*/

int	flag_conv, flag_autoconvert;


Frame frame_median;
Panel panel_median;
Panel_item nbr_lin, nbr_col, ftitre;
    

extern void hproc_smoothing();
extern void hproc_egal_histo();
extern void hproc_filtre_median();
extern int *conv_int();
extern void write_erreur();
extern struct commande *new_commande();

static Panel_setting lire_filtreparam();

/*****************************************************************************/

caddr_t proc_smoothing (m, mi)

    Menu m;
    Menu_item mi;

{
    int ligne, colonne;
    unsigned char *temp;
    int	*image;

    if (flag_bother){
	hproc_smoothing();
	return;
    }
    if (flag_help) hproc_smoothing();
    if (!flag_creer){
        sprintf (buf, mastertabs[221]);
	write_master(buf);	
    }
    if (flag_exec == FROMTO_AUTO || flag_exec == AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (!flag_creer){
        sprintf (buf, "%d --> %d\n",
                     index_image[0], index_image[1]);
	 write_master (buf);
    }
    if (flag_creer){
	struct commande *com;
        com = (struct commande *)new_commande(&macro_cour);
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
        sprintf(com->nom, "EDGPRS");
        com->code = 170;
	write_macro(com->nom);
        sprintf(buf, " FROM %d TO %d\n", index_image[0], index_image[1]);
        write_macro(buf);
    }
    else {
        switch (dir_desc[index_image[0]].type){
	    case -1:
	    case 0:
	    case 1:flag_conv = TRUE;
		   image = (int *) conv_int (index_image[0]);
		   break;
	    case 2:flag_conv = FALSE;
		   image = (int *)dir_image[index_image[0]].image;
		   break;
	    case 3:
	    case 4:
	    case 5:flag_autoconvert = TRUE;
		   autoconvert_integer(index_image[0]);
		   image = (int *) buffer_image[0].image;
		   break;
	}
	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	    dir_desc[index_image[1]].type = 2;
	    ligne = (int)dir_desc[index_image[1]].nligne;
	    colonne = (int)dir_desc[index_image[1]].ncolonne;
	    temp = (unsigned char *) malloc (ligne * colonne * 
		    element(dir_desc[index_image[1]].type));

#if SPIDER == 1
/*
	    egpr_(image,temp,&colonne,&ligne);
*/
#else
	    write_erreur (90);
#endif

	    if (dir_image[index_image[1]].image != NULL)
		free (dir_image[index_image[1]].image);
	    dir_image[index_image[1]].image = temp;
	    statis (dir_image[index_image[1]].image,
		    dir_desc[index_image[1]].type, 
		    dir_desc[index_image[1]].nligne,
		    dir_desc[index_image[1]].ncolonne,
		    &(dir_desc[index_image[1]].mmin),
		    &(dir_desc[index_image[1]].mmax), 
		    &(dir_desc[index_image[1]].mu),
		    &(dir_desc[index_image[1]].ecart));
	    if (flag_conv) free(image);
    }
}

/*****************************************************************************/

caddr_t proc_egal_histo (m, mi)

    Menu m;
    Menu_item mi;

{
    int ngro, ngrn;
    int ligne, colonne;
    int *temp;
    int	*image;

    if (flag_bother){
	hproc_egal_histo();
	return;
    }
    
    if (flag_help) hproc_egal_histo();
    if (!flag_creer){
        sprintf (buf, mastertabs[222]);
	 write_master(buf);	
    }
    if (flag_exec == FROMTO_AUTO || flag_exec == AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (!flag_creer){
	sprintf (buf, "%d --> %d\n", index_image[0], index_image[1]);
    write_master (buf);
    }
    if (flag_creer) {
	struct commande *com;
	com = (struct commande *)new_commande(&macro_cour);
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	sprintf(com->nom, "PREHEQ");
	com->code = 180;
        write_macro(com->nom);
	sprintf(buf, " FROM %d TO %d\n", index_image[0],
		    index_image[1]);
	write_macro(buf);
    }
    else {
        switch (dir_desc[index_image[0]].type){
	    case -1:
	    case 0:
	    case 1:flag_conv = TRUE;
		   image = (int *) conv_int (index_image[0]);
		   break;
	    case 2:flag_conv = FALSE;
		   image = (int *)dir_image[index_image[0]].image;
		   break;
	    case 3:
	    case 4:
	    case 5:flag_autoconvert = TRUE;
		   autoconvert_integer(index_image[0]);
		   image = (int *) buffer_image[0].image;
		   break;
	}
	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	    dir_desc[index_image[1]].type = 2;
	    ngro=(int)dir_desc[index_image[0]].mmax + 1; 
	    ngrn = 256;
	    ligne = (int)dir_desc[index_image[1]].nligne;
	    colonne = (int)dir_desc[index_image[1]].ncolonne;
	    temp = histequalize(image, colonne, ligne,  ngro, ngrn);
	    if (dir_image[index_image[1]].image != NULL)
		free (dir_image[index_image[1]].image);
	    dir_image[index_image[1]].image = (unsigned char *)temp;
	    if ((flag_conv == TRUE) || (flag_autoconvert == TRUE))
		 free (image);
	    statis (dir_image[index_image[1]].image,
		    dir_desc[index_image[1]].type, 
		    dir_desc[index_image[1]].nligne,
		    dir_desc[index_image[1]].ncolonne,
		    &(dir_desc[index_image[1]].mmin),
		    &(dir_desc[index_image[1]].mmax), 
		    &(dir_desc[index_image[1]].mu),
		    &(dir_desc[index_image[1]].ecart));
	}
}
/*****************************************************************************/

static Panel_setting lire_filtreparam(item, event)
    Panel_item item;
    Event *event;
{
   int f;
   static struct filmed filpara = {0, 0};

    if (event_id(event) == CTRLC){
	flag_break = TRUE;
	window_return(NULL);
	window_destroy(frame_median);
	return;
    }
    if (event_id(event) == '\t') 
	return(PANEL_NEXT);
    else {
        f = atoi ((char *) panel_get (nbr_lin, PANEL_VALUE));
	if (f == 0) {
	    panel_set_value (item, "");
	    return;
	   }
	else filpara.nlin = f;
	f = atoi ((char *) panel_get (nbr_col, PANEL_VALUE));	
	if (f == 0) {
	   panel_set_value (item, "");
	   return;
	}
	else filpara.ncol = f;
        window_return(&filpara);
	window_destroy (frame_median);
	return;
    }
}

    
/*****************************************************************************/
struct filmed *median_panel()
{
    char repc[5], repl[5];
    struct filmed *film;

    frame_median = window_create(frame, FRAME, 
				 WIN_X, 500, WIN_Y, 500,
				 FRAME_NO_CONFIRM, TRUE, 0);
    panel_median = window_create(frame_median, PANEL, 
				 PANEL_LABEL_BOLD, TRUE, 0);
    strcpy(repc,"");
    strcpy(repl,"");

    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	film = (struct filmed *)(macro_cour->param);
    else film = NULL;

    ftitre = panel_create_item(panel_median, PANEL_MESSAGE,
			       PANEL_LABEL_X, ATTR_COL(0),
			       PANEL_LABEL_Y, ATTR_ROW(0),
			       PANEL_LABEL_STRING, paneltabs[431],
			       0);
    nbr_col = panel_create_item(panel_median, PANEL_TEXT,
				PANEL_LABEL_X,ATTR_COL(1),
				PANEL_LABEL_Y,ATTR_ROW(1),
				PANEL_VALUE_DISPLAY_LENGTH, 20,
				PANEL_VALUE_STORED_LENGTH, 20,
				PANEL_LABEL_STRING,paneltabs[432],
				PANEL_VALUE,(film != NULL ? 
		      (char *)sprintf(repc,"%d",film->ncol) : "\0"),
				PANEL_NOTIFY_STRING,"\r\n\t\03",
				PANEL_NOTIFY_PROC,lire_filtreparam,
				0);			
    nbr_lin = panel_create_item(panel_median,PANEL_TEXT,
				PANEL_LABEL_X,ATTR_COL(1),
				PANEL_LABEL_Y,ATTR_ROW(2),
				PANEL_VALUE_DISPLAY_LENGTH, 20,
				PANEL_VALUE_STORED_LENGTH, 20,
				PANEL_LABEL_STRING,paneltabs[433],
				PANEL_VALUE,(film != NULL ? 
		      (char *)sprintf(repl,"%d",film->nlin) : "\0"),
				PANEL_NOTIFY_STRING,"\r\n\t\03",
				PANEL_NOTIFY_PROC,lire_filtreparam,
				0);

    window_fit(panel_median);
    window_fit(frame_median);
    window_set(panel_median, PANEL_CARET_ITEM, nbr_lin, 0);
    film = (struct filmed *)window_loop(frame_median);
    return(film);
}


/*****************************************************************************/

caddr_t proc_median (m, mi)

    Menu m;
    Menu_item mi;

{
    int ngr;
    int ligne, colonne;
    unsigned char *temp;
    struct filmed *ffilm, *copyfilm;
    struct commande *com;
    int	*image;

    if (flag_bother){
	hproc_filtre_median();
	return;
    }
    if (flag_help) hproc_filtre_median();
    if (!flag_creer){
        sprintf (buf, mastertabs[223]);
	write_master(buf);
    }
    if (flag_exec == FROMTO_AUTO || flag_exec == AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	ffilm = (struct filmed*) malloc(sizeof (*ffilm));
	*ffilm = *((struct filmed *)macro_cour->param);
    }
    else  ffilm = median_panel();
    if (flag_break){
	interruption();
	return;
    }
    if ((ffilm->ncol == 0) && (ffilm->nlin == 0)){
	write_erreur(96);
	return;
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *) new_commande(&macro_cour);
	strcpy(com->nom, "PREENHMFI");
	com->code = 181;
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	sprintf(buf, "%s FROM %d TO %d WITH %d %d\n",
		com->nom, index_image[0], index_image[1],
		ffilm->ncol, ffilm->nlin);
	write_macro(buf);
	copyfilm = (struct filmed *) malloc(sizeof(*copyfilm));
	*copyfilm = *ffilm;
	com->param = (char *)copyfilm;
    }
    else {
	sprintf (buf, "%dx%d: %d --> %d\n", ffilm->ncol, ffilm->nlin, index_image[0], index_image[1]);
	write_master (buf);	
	if (dir_image[index_image[0]].image == NULL){
	    write_erreur(0);
	    return;
	}
        switch (dir_desc[index_image[0]].type){
	    case -1:
	    case 0:
	    case 1:flag_conv = TRUE;
		   image = (int *) conv_int (index_image[0]);
		   break;
	    case 2:flag_conv = FALSE;
		   image = (int *)dir_image[index_image[0]].image;
		   break;
	    case 3:
	    case 4:
	    case 5:flag_autoconvert = TRUE;
		   autoconvert_integer(index_image[0]);
		   image = (int *) buffer_image[0].image;
		   break;
	}
	dir_desc[index_image[1]] = dir_desc[index_image[0]];
	dir_desc[index_image[1]].type = 2;
        ngr=(int)dir_desc[index_image[0]].mmax + 1; 
        ligne = (int)dir_desc[index_image[1]].nligne;
        colonne = (int)dir_desc[index_image[1]].ncolonne;
        temp = (unsigned char *) SlideWindow(image, colonne, ligne,
				     ffilm->ncol, ffilm->nlin, ngr);
	if (dir_image[index_image[1]].image != NULL)
	     free (dir_image[index_image[1]].image);
        dir_image[index_image[1]].image = temp;
	if ((flag_conv == TRUE) || (flag_autoconvert == TRUE))
		 free (image);
 
        statis (dir_image[index_image[1]].image,
                dir_desc[index_image[1]].type, 
	        dir_desc[index_image[1]].nligne,
	        dir_desc[index_image[1]].ncolonne,
		&(dir_desc[index_image[1]].mmin),
		&(dir_desc[index_image[1]].mmax), 
	        &(dir_desc[index_image[1]].mu),
		&(dir_desc[index_image[1]].ecart));
    }
}
/*****************************************************************************/


int *histequalize(InImage, DimX, DimY, InGrayLevels, OutGrayLevels)
  int *InImage, DimX, DimY;
  int InGrayLevels, OutGrayLevels;
{
    float *IdealImageHist, *InImageHist, *OutImageHist; 
    int *TransfTable, CountInGray;
    float value, InVal, Rmin, diff, sumc;
    int i, j, index1, index2, StopLoop, sum, size, histindex;
    int errorpix, InVali;
    int *OutImage;

/* 
    get an ideally equalized histogram in IdealHist 
*/

   IdealImageHist=(float *) calloc(OutGrayLevels, sizeof(float));
   InImageHist=(float *) calloc(InGrayLevels, sizeof(float));
   value = (float) 1.0/OutGrayLevels;
   for (i=0; (i < OutGrayLevels); ++i)
      *(IdealImageHist+i)= value;
   size = DimX*DimY;    

   CountInGray = InGrayLevels;
/* 
  make histogram of input image 
*/

   for(i=0; (i < size); i++){
       histindex = (int) *(InImage + i);
       histindex = (histindex < 0) ? 0 : histindex;
       histindex = (histindex > InGrayLevels) ? InGrayLevels : histindex;          
       *(InImageHist + histindex) += 1.00;
   }

/*
  normalize histogram of input image 
*/

   
sumc=0;
   for(i=0; (i < CountInGray); ++i){
       sumc += *(InImageHist + i);
      }
   for(i=0; (i < CountInGray); ++i)
       *(InImageHist + i) = (*(InImageHist + i) / sumc );

/*
       construct transformation table: 
       --first make cumulative distributions : 
*/

   sumc=0;
   for(i=0; (i < CountInGray); ++i){
       sumc += *(InImageHist + i);
       *(InImageHist + i)= sumc;  
   }
   sumc=0;
   for(i=0; (i < OutGrayLevels); ++i){
       sumc += *(IdealImageHist + i);
       *(IdealImageHist + i)= sumc;
   } 

/* now construct the transformation table  TransTable[] 
*/
 
   TransfTable = (int*) calloc(InGrayLevels , sizeof(int));

       index1=0;
       index2=1;
       for (i=0; (i < CountInGray); i++){
           Rmin=100.00;
           j=index1;
           InVal= *(InImageHist + i);
           StopLoop = FALSE;
           while ((!StopLoop) && (j < OutGrayLevels)){
	       diff= fabs(InVal - *(IdealImageHist + j));
               if (diff > Rmin) {
                   StopLoop=TRUE;
	       }
               else{
                     index2=j;
                     Rmin= diff;
	       }
               j += 1;
	   }
           *(TransfTable + i) = index2;
	   if (i > CountInGray){
	       --i;
	   }
           index1= index2 ;
       }

/* create new image with gray-scale transformation
*/

    OutImage=(int *) calloc(size , sizeof(int));
    for (i=0; (i < size); ++i){ 
       InVali= *(InImage + i);
       InVali = (InVali < 0) ? 0 : InVali;
       InVali = (InVali > InGrayLevels) ? InGrayLevels : InVali;  
       *(OutImage + i) = *(TransfTable + InVali);
    }

 free(IdealImageHist);
 free(InImageHist);
 free(TransfTable);
 return(OutImage);

}
  

/* ***************************************************************** */

/* Procdure implementing the fast 2-D median filtering algorithm as 
   described by T.S.HUANG ,G.J.YANG, G.Y.TANG in IEEE Transactions ASSP
   Vol-27 No.1
*/
/* ***************************************************************** */



int *SlideWindow(Image, DimX, DimY, Wx, Wy, hues)
int DimX, DimY, Wx, Wy, *Image, hues;
{
    int  *Histogram,*ValRet, AC, OC;
    int  Median, MedianTot, LessThanMedCount,MedEstim;
    int HalfWx,HalfWy, l, m, n , buf1, bufX,p, l1, limW, i, j, k;
    int *IWind, *ImageR;;


    Histogram=(int*) calloc(hues,sizeof(int));
    ImageR=(int*) calloc(DimX*DimY,sizeof(int));
    if (ImageR==NULL){
        return(NULL);
    }
    HalfWx= Wx/2;
    HalfWy= Wy/2;
    MedEstim=(Wx*Wy)/2;

    /* Padding  around the sides */
    buf1=DimY-HalfWy;
    for(j=0; j<HalfWy; ++j){
       for(i=0; i<DimX; ++i){
          *(ImageR+j*DimX+i)=  *(Image+j*DimX+i);
          *(ImageR+DimX*(buf1+j)+i)=  *(Image+DimX*(buf1+j)+i);
       }  
    }
    buf1=DimX-HalfWx;
    for(j=0; j < HalfWx; ++j){
       for(i=0; i < DimY; ++i){
          *(ImageR+i*DimX+j)= *(Image+i*DimX+j);
          *(ImageR+DimX*i+j+buf1)= *(Image+DimX*i+j+buf1);
       }  
    }

    /* Application of the Median Filter */

    bufX=DimX*HalfWy + HalfWx + 1;
    for(j=0; j <= (DimY - Wy); ++j){
/* 
   initialisation of the histogram with the 1st window on the row 
   along which the window slides.
*/
         MedianTot = 0;
         limW = j+Wy;
         for(i=0; i<hues; ++i)
            *(Histogram + i)=0; 
	 for(k=0; k < Wx; ++k){
            for(i=j; i < limW; ++i){ 
               p = *(Image + DimX*i + k); 
               p = (p < 0) ? 0 : p; 
               p = (p > hues) ? hues : p; 
               *(Histogram + p) += 1;
               MedianTot += 1;
            }
	 }
         MedianTot /= 2;
         k=0;
         i= 0;
         while (k <= MedEstim){
             k += *(Histogram + i);
             ++i;
         } 
         Median=i-1;
         LessThanMedCount=k- *(Histogram + i - 1); 
         buf1= DimX*(j+HalfWy)+HalfWx;
         /* 
            readjustement of the median along the row as the window
            changes, accounting only for the column which gets
            removed and the one which gets added.
         */
         *(ImageR + buf1)= Median;
         for(k=Wx; k<DimX; ++k)
         {
           for(i=j; i < (j+ Wy); ++i){  /* column */
              m=DimX*i+k; 
              OC= *(Image+m-Wx);
              *(Histogram + OC) -= 1;
              if (OC < Median) LessThanMedCount -= 1;
              AC= *(Image+m);
              *(Histogram + AC) += 1;
              if (AC < Median) LessThanMedCount += 1;
	   }

           if  (LessThanMedCount > MedEstim)
              do{
		  Median -= 1;
                  LessThanMedCount -=  Histogram[Median] ;
	      }while (LessThanMedCount >= MedEstim);
           else  while ((LessThanMedCount+Histogram[Median]) <= MedEstim){
	             LessThanMedCount +=  Histogram[Median] ;
                     Median += 1;
 	        }

           buf1 += 1;
           *(ImageR+ buf1)=Median;
   	 }
    }
  
   return(ImageR);
      

    
}








 
