/*****************************************************************************/
/* module affiche.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include <suntool/scrollbar.h>
#include <suntool/textsw.h>
#include <sys/file.h>

#include "define.h"
#include "structure.h"
#include "global.h"

#define max(x,y) (((x) > (y)) ? (x) : (y))
#define min(x,y) (((x) < (y)) ? (x) : (y))
	
extern	int	flag_chablon;
extern	Frame	last_fr, master;
extern	Canvas	last_can;
extern	Menu	mimage;
extern	unsigned char code2[4], code3[8];

extern	void	saisie_pts();
/*
extern	void	entree_zone_proc();
*/

extern void hproc_gris_lin();
extern void hproc_gris_log();
extern void hproc_couleur_rgb();
extern void hproc_rgb_reporterreur();
extern void hproc_report_erreur();
extern void hproc_seuil();


/*****************************************************************************/

void imprimer_stat (can)
    Canvas can;

{
    Frame   finfo, fowner;
    Textsw  tinfo;
    char    *buf, *line, *titre;
    struct image_ecran *im_desc;

    fowner = (Frame)window_get(can, WIN_OWNER, 0);
    titre = (char *)window_get(fowner, FRAME_LABEL, 0);
    
    finfo = window_create(NULL, FRAME, FRAME_NO_CONFIRM, TRUE,
			  FRAME_LABEL, titre,
                          0, 0);
    tinfo = window_create (finfo, TEXTSW,
			  WIN_WIDTH, 320, WIN_HEIGHT, 250, 
                          TEXTSW_SCROLLBAR, NULL, 
                          TEXTSW_IGNORE_LIMIT, TEXTSW_INFINITY, 0);
    window_fit (finfo);

    im_desc = (struct image_ecran *) window_get (can, WIN_CLIENT_DATA, 0);
    window_set (tinfo, WIN_CLIENT_DATA, im_desc, 0);

    /* remplissage de la fenetre contenant les statistiques */
    buf = (char *) malloc (500);
    line = (char *) malloc (80);
    strcpy (buf, "\0");
    strcat (buf,paneltabs[8]);
    strcat (buf, sprintf (line,paneltabs[9],im_desc->ncolonne));
    strcat (buf, sprintf (line,paneltabs[10], im_desc->nligne));
    strcat (buf, sprintf (line,paneltabs[11], im_desc->type));
    strcat (buf, sprintf (line,paneltabs[12]));
    if (im_desc->nbr_plan == 1) {
        strcat(buf,sprintf(line,"   Min : %.4f\n\0", im_desc->mini[0]));
        strcat(buf,sprintf(line,"   Max : %.4f\n\0", im_desc->maxi[0]));
        strcat(buf,sprintf(line,paneltabs[13],im_desc->mu[0]));
        strcat(buf,sprintf(line,paneltabs[14],im_desc->ecart[0]));
    }
    else {
        /* 3 plans pour l'affichage : RGB */
        strcat (buf, sprintf (line,"   Min : %.2f  %.2f  %.2f\n\0",  
            im_desc->mini[0], im_desc->mini[1], im_desc->mini[2]));
        strcat (buf, sprintf (line,"   Max : %.2f  %.2f  %.2f\n\0",  
            im_desc->maxi[0], im_desc->maxi[1], im_desc->maxi[2]));
        strcat (buf, sprintf (line,paneltabs[15], im_desc->mu[0], im_desc->mu[1], im_desc->mu[2]));
        strcat (buf, sprintf (line,paneltabs[16], im_desc->ecart[0], im_desc->ecart[1], im_desc->ecart[2]));
    }
    textsw_insert (tinfo, buf, strlen(buf));
    window_set (tinfo, TEXTSW_READ_ONLY, TRUE, 0);
    free (buf);
    window_set (finfo, WIN_SHOW, TRUE, 0);
}

/*****************************************************************************/
/*									     */
/* nom      : information						     */
/*									     */
/* fonction : affiche ou cache le panneau contenant les statistiques	     */
/*	      d'une image.					             */
/*                                                                           */
/* entrees  : Canvas can		: canvas contenant l'image           */
/*            Evant event	        : evenements		             */
/*                                                                           */
/* globales : neant						    	     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : neant							     */
/*									     */
/*****************************************************************************/

void information (can, event)
    Canvas can;
    Event *event;

{
    int	select, plan;

    if (event_id(event) == MS_RIGHT && event_is_down(event) == TRUE){
	    select = (int) menu_show (mimage, can, event, 0);
	    if (select == 1)
		imprimer_stat (can);
	    else if ((select >= 128) && (select <= 139))
		profils_proc(can,select);
	    else
		entree_zone_proc (can, select);
    }
}

/*****************************************************************************/
/*                							     */
/* nom      : ouvrir_fenetre						     */
/*									     */
/* fonction : ouvre  melanie 8 ou 12 bits et la stocke dans		     */
/*            le tableau pointe par image_r.On calcule egalement les	     */
/*            statistiques de l'image et on les stocke dans desc	     */
/*									     */
/* entrees  : Pixwin **pw               : adresse du pixwin associe au canvas*/
/*	      int nbr_plan		: nbr de plan pour l'affichage	     */
/*									     */
/* globales : neant				  		             */
/*									     */
/* return   : pointeur sur le canvas contenant l'image		             */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

Canvas ouvrir_fenetre (pw, nbr_plan)

    Pixwin **pw;
    int nbr_plan;

{
    int fli,fco, i;
    char titre[80];
    Frame  fr = NULL;
    Canvas can = NULL;
    struct image_ecran *im_desc;
    
    struct pixrect *pix = NULL;

    im_desc = (struct image_ecran *) malloc (sizeof(struct image_ecran));
    fli = (int) dir_desc[index_image[0]].nligne;
    fco = (int) dir_desc[index_image[0]].ncolonne;
    /* on construit le frame et le canvas qui contiendront une image */ 
    descr_file(flag_debug);
    i = open ("/dev/fb", O_RDONLY);
    if (i==-1) perror ("open dev/fb : ");
    else close(i);
    pix = pr_open ("/dev/fb");
    if (pix == NULL) perror ("pr_open /dev/fb : ");
    else pr_close(pix);
    if (nbr_plan == 3)
	sprintf (titre, "[%d-%d-%d] %s\0", 
	    index_image[0], index_image[2], index_image[4], 
	    dir_desc[index_image[0]].filename);
    else
	sprintf (titre, "[%d] %s\0", index_image[0],
	    dir_desc[index_image[0]].filename);
    fr = window_create (NULL, FRAME, FRAME_LABEL, titre,
			FRAME_NO_CONFIRM, TRUE,
                        FRAME_EMBOLDEN_LABEL, TRUE, 
/*                         WIN_WIDTH, fco + 15,  */   /* 45 = margin + scrollbar */
/*                         WIN_HEIGHT, fli + 15, */
                        WIN_SHOW, TRUE,
                        0, 0);
    if (fr == NULL) printf ("probleme-frame\n");
    descr_file(flag_debug);
    i = open ("/dev/fb", O_RDONLY);
    if (i==-1) perror ("open /dev/fb : ");
    else close(i);
    pix = pr_open ("/dev/fb");
    if (pix == NULL) perror ("pr_open /dev/fb : ");
    else pr_close(pix);
    can = window_create (fr, CANVAS, /* WIN_SHOW, TRUE, */
                         CANVAS_AUTO_EXPAND, FALSE,
                         CANVAS_AUTO_SHRINK, FALSE,
                         CANVAS_AUTO_CLEAR, TRUE,
                         CANVAS_FIXED_IMAGE, FALSE,
                         CANVAS_WIDTH, fco,
                         CANVAS_HEIGHT, fli,
                         WIN_WIDTH, min(1140,fco + 15),     
                         WIN_HEIGHT, min(900,fli + 15),
                         WIN_EVENT_PROC, information,
                         0); 
    if (can == NULL) printf ("probleme-canvas\n");
    window_fit (can); 
    window_fit (fr);

    if (flag_chablon == TRUE) {
	flag_chablon = 2;
	window_set (can, WIN_EVENT_PROC, saisie_pts, 0);
	last_fr = fr;
	last_can = can;
	cree_fenetre_mono();
    }

    im_desc->nligne = dir_desc[index_image[0]].nligne;
    im_desc->ncolonne = dir_desc[index_image[0]].ncolonne;
    switch (dir_desc[index_image[0]].type) {
        case -1: strcpy (im_desc->type, " byte 'binaire'"); break;
	case 0 : strcpy (im_desc->type, " byte"); break;
	case 1 : strcpy (im_desc->type, " short"); break;
	case 2 : strcpy (im_desc->type, " integer"); break;
	case 3 : strcpy (im_desc->type, " float"); break;
    }
    im_desc->nbr_plan = (short) nbr_plan;
    im_desc->n_plan = index_image[0];
    for (i=0; i<nbr_plan; i++) {
	im_desc->maxi[i] = dir_desc[index_image[2*i]].mmax;    
	im_desc->mini[i] = dir_desc[index_image[2*i]].mmin;    
	im_desc->mu[i] = dir_desc[index_image[2*i]].mu;
	im_desc->ecart[i] = dir_desc[index_image[2*i]].ecart;    
    }
    /* on met dans les "donnees privees" du canvas le descripteur de l'image*/
    window_set (can, WIN_CLIENT_DATA, im_desc, 0);
    *pw = canvas_pixwin (can);
/*
    pw_write(*pw, 0, 0, (int)window_get(can, CANVAS_WIDTH),
             (int)window_get(can, CANVAS_HEIGHT), PIX_SRC, 0, 0, 0);
*/
    return (can);
}

/*****************************************************************************/
/*                							     */
/* nom      : affiche_image_color					     */
/*									     */
/* fonction : affiche une image avec 256 niveaux de gris lineaires ou	     */
/*	      logarithmiques dans un canvas				     */
/*									     */
/* entrees  : unsigned char *image      : pointeur sur image a afficher	     */
/*	      int table			: table de couleur a utiliser	     */
/*									     */
/* globales : description_memoire dir_desc				     */
/*            int index_image[6]					     */
/*	      unsigned char nivgrislin[3][256]				     */
/*	      unsigned_char nivgrislog[3][256]				     */
/*									     */
/* return   : neant						             */
/*								             */
/* routines : write_erreur						     */
/*								             */
/*****************************************************************************/

affiche_image_color (image, table)

    unsigned char *image;
    int table;

{
    unsigned char *d;
    short *s;  
    int *i, shift;
    float *f;
    register int j, jj, taille;
    register float facteur, fmin;
    
    Canvas can;
    Scrollbar barvert, barhoriz;
    Pixwin *pw;
    struct pixrect *source_pixrect;

    can = (Canvas)ouvrir_fenetre (&pw, 1);

    if (table == LOG) {
        pw_setcmsname (pw,"log");
	pw_putcolormap (pw,0,256,nivgrislog[0],nivgrislog[1],nivgrislog[2]);
    }
    else if (table == LIN) {
        pw_setcmsname (pw,"lin");
        pw_putcolormap (pw,0,256,nivgrislin[0],nivgrislin[1],nivgrislin[2]); 
    }
    window_set (can, CANVAS_RETAINED, TRUE,
                WIN_VERTICAL_SCROLLBAR, barvert = scrollbar_create(0),
                WIN_HORIZONTAL_SCROLLBAR, barhoriz = scrollbar_create(0), 0);
    scrollbar_paint_clear (barvert);
    scrollbar_paint_clear (barhoriz);
    
 /*   sprintf (buf, "SHIFT = %d\n\0", shift); */
/*
    shift = (int) (mpr_linebytes(dir_desc[index_image[0]].ncolonne,8)
		 - dir_desc[index_image[0]].ncolonne); 
*/
    shift = dir_desc[index_image[0]].ncolonne & 03;
    shift = (4 - shift) & 03;

 /*   write_master (buf); */
    if ((source_pixrect=mem_create(dir_desc[index_image[0]].ncolonne+shift,
	dir_desc[index_image[0]].nligne,8))==NULL)
    {
        write_erreur(3);
        return;
    }
    d = (unsigned char *) mpr_d(source_pixrect)->md_image;

    taille = dir_desc[index_image[0]].ncolonne * dir_desc[index_image[0]].nligne;

    if (dir_desc[index_image[0]].type == 0 
	|| dir_desc[index_image[0]].type == -1) {
        if (shift != 0) {
            for (jj=0; jj<dir_desc[index_image[0]].nligne; jj++){
                for (j=0; j<dir_desc[index_image[0]].ncolonne; j++){
                    *d = *image;
                    d++;  image++;
                }
                d += shift;
            }            
        }
        else{
            for (j=0; j<taille; j++) {
                *d = *image;
                d++;  image++;
            }
        }
    }
    else {
        /* on initialise un pointeur du type desire sur l'image */
        switch ( dir_desc[index_image[0]].type) {
	    case 1: s = (short *) image; break;
	    case 2: i = (int *) image; break;
            case 3: f = (float *) image; break;
        }
        facteur = MAXBYTE / (dir_desc[index_image[0]].mmax -
                             dir_desc[index_image[0]].mmin); 
        fmin = dir_desc[index_image[0]].mmin;
        if (shift != 0){
            for (jj=0; jj<dir_desc[index_image[0]].nligne; jj++) {
                for (j=0; j<dir_desc[index_image[0]].ncolonne; j++) {
                    switch (dir_desc[index_image[0]].type) {
                         case 1 : *d = (unsigned char) ((*s - fmin) * facteur);
	                         s++;  break;
                         case 2 : *d = (unsigned char) ((*i - fmin) * facteur);
				 i++;  break;
                         case 3 : *d = (unsigned char) ((*f - fmin) * facteur);
				 f++;  break;
                    }
                    d++;
                }
                d+=shift;
            }
            
        }
        else {
            for (j=0; j<taille; j++) {
                switch (dir_desc[index_image[0]].type) {
                    case 1 : *d = (unsigned char) ((*s - fmin) * facteur); 
                             s++;  break;
                    case 2 : *d = (unsigned char) ((*i - fmin) * facteur); 
                             i++;  break;
                    case 3 : *d = (unsigned char) ((*f - fmin) * facteur); 
                             f++;  break;
                }
                d++;
            }
        }
    }
/*
    if (dir_desc[index_image[0]].ncolonne & 1) 
    pw_write(pw, 0, 0, dir_desc[index_image[0]].ncolonne+1,
	     dir_desc[index_image[0]].nligne,
             PIX_SRC, source_pixrect, 0, 0);
    else
*/
    pw_write(pw, 0, 0, dir_desc[index_image[0]].ncolonne+shift,
	     dir_desc[index_image[0]].nligne,
             PIX_SRC, source_pixrect, 0, 0);
}

/*****************************************************************************/
/*                							     */
/* nom      : affiche_image						     */
/*									     */
/* fonction : affiche une image en noir et blanc dans un canvas		     */
/*	      en appliquant un seuil ou	Floyd-Steinberg			     */
/*									     */
/* entrees  : unsigned char *image      : pointeur sur image a afficher	     */
/*	      int methode		: 1=seuil 2=repport d'erreur	     */
/*	      float seuil		: valeur du seuil pour l'affichage   */
/*									     */
/* globale  : unsigned char nivgrislin[3][256]				     */
/*									     */
/* return   : neant						             */
/*								             */
/* routines : write_erreur						     */
/*								             */
/*****************************************************************************/

int affiche_image(methode,no,seuil)

    int methode,no;
    float seuil;

{

    float *f,ff,point,*err1,*err2,rr,e;
    register int x,y,xx;
    int *i;
    unsigned char *b, *image;
    short *s;
    
    Canvas can;
    Scrollbar barvert, barhoriz;
    Pixwin *pw;
    struct pixrect *source_pixrect;

    image = (unsigned char *)dir_image[no].image;
    
    err1 = (float *) malloc((dir_desc[no].ncolonne + 1) * sizeof(*err1));
    err2 = (float *) malloc((dir_desc[no].ncolonne + 1) * sizeof(*err2));

    if ((source_pixrect = 
    mem_create(dir_desc[no].ncolonne,dir_desc[no].nligne,1))==NULL){
        write_erreur(3);
        return;
    }
    can = (Canvas)ouvrir_fenetre (&pw, 1);
    pw_setcmsname(pw,"mono");
    pw_putcolormap(pw,0,256,nivgrislin[0],nivgrislin[1],nivgrislin[2]); 
    window_set (can, CANVAS_RETAINED, TRUE,
                WIN_VERTICAL_SCROLLBAR, barvert = scrollbar_create(0),
                WIN_HORIZONTAL_SCROLLBAR, barhoriz = scrollbar_create(0), 0);
    scrollbar_paint_clear (barvert);
    scrollbar_paint_clear (barhoriz);

       /* on initialise un pointeur du type desire sur l'image */

    switch ( dir_desc[no].type) {
	case -1:
        case 0: b = (unsigned char *) image; break;
	case 1:	s = (short *) image; break;
	case 2: i = (int *) image; break;
        case 3: f = (float *) image; break;
   }
   if ( methode == 1) {

         /* methode du seuil */ 

      for ( y = 0 ; y < dir_desc[no].nligne ; y++)
            for ( x = 0 ; x < dir_desc[no].ncolonne ; x++) {
                switch (dir_desc[no].type) {
		    case -1:
	            case 0: point = (float) *b; b++ ; break;
        	    case 1: point = (float) *s; s++ ; break;
                    case 2: point = (float) *i; i++ ; break;
		    case 3: point = *f; f++ ; break;
	         }
            if ( point > seuil) pr_put(source_pixrect , x, y, 1);
        }
    }
    else {  
 
         /* methode du report d'erreur */

	for ( x= 0 ; x < dir_desc[no].ncolonne ; x++) err1[x]=err2[x]=0;
	switch (dir_desc[no].type) {
	    case -1:
	    case 0: b = (unsigned char *) image; break;
	    case 1: s = (short *) image; break;
	    case 2: i = (int *) image; break;
	    case 3: f = (float *) image; break;
	}
	for ( y = 0 ; y < dir_desc[no].nligne ; y++){
	    for ( x = 0 ; x < dir_desc[no].ncolonne; x++){
		switch (dir_desc[no].type){
		    case -1:
		    case 0: point = (float) *b; b++;  break;
		    case 1: point = (float) *s; s++;  break;
		    case 2: point = (float) *i; i++;  break;
		    case 3: point = *f; f++; break;
                }
		rr = point + err1[x];
		if ( rr > seuil ) {
		    pr_put( source_pixrect, x, y, 1);
		    e = rr - dir_desc[no].mmax;
		}
                else e = rr -dir_desc[no].mmin;
                xx = x + 1;
                ff = e * 0.375;
                err1[xx] = err1[xx] + ff;
                err2[xx] = e * 0.25;
                err2[x] = err2[x] + ff;
	    }
            err1 = err2;
            for (xx = 0; xx < dir_desc[no].ncolonne ; xx++) err2[xx]= 0;
	}
    }
    pw_write(pw, 0, 0, dir_desc[no].ncolonne, dir_desc[no].nligne,
             PIX_SRC, source_pixrect, 0, 0);
    free(source_pixrect);
}

/*****************************************************************************/

unsigned char diff_3 (val)
    unsigned char val;
{
    unsigned char i, mini, minpreced;

    i = 0;  mini = 255;	minpreced = 0;
    do{
	minpreced = mini;
	mini = (val>code3[i] ? val-code3[i] : code3[i]-val);
	i++;
    } while (mini <= minpreced && i!=8);
    if (i!=8) return (i-2);
    else return (mini<minpreced ? i-1 : i-2);
}

/*****************************************************************************/

unsigned char diff_2 (val)
    unsigned char val;
{
    unsigned char i, mini, minpreced;

    i = 0;  mini = 255;	minpreced = 0;
    do{
	minpreced = mini;
	mini = (val>code2[i] ? val-code2[i] : code2[i]-val);
	i++;
    } while (mini <= minpreced && i!=4);
    if (i!=4) return (i-2);
    else return (mini<minpreced ? i-1 : i-2);
}

/*****************************************************************************/
/*                							     */
/* nom      : affiche_image_couleur					     */
/*									     */
/* fonction : affiche une image RGB (3 plans) en couleur dans un canvas	     */
/*									     */
/* entrees  : unsigned char *r	        : pointeur sur le plan-image R	     */
/*	    : unsigned char *g		: pointeur sur le plan-image G	     */
/*	    : unsigned char *b		: pointeur sur le plan-image B	     */
/*									     */
/* globales : description_memoire dir_desc				     */
/*	      int index_image[6]					     */
/*	      unsigned char colormap[3][256]				     */
/*									     */
/* return   : neant						             */
/*								             */
/* routines : write_erreur						     */
/*								             */
/*****************************************************************************/

affiche_image_couleur (r, g, b)
    
    unsigned char *r, *g, *b;

{
    register int i, j;
    unsigned char usr, usb, usg;
    unsigned char *d;
    unsigned char *br, *bg, *bb;  /* les 3 plans RGB de bytes */
    short *sr, *sg, *sb;          /* les 3 plans RGB de short */
    int *ir, *ig, *ib;            /* les 3 plans RGB d'int    */
    float *fr, *fg, *fb;          /* les 3 plans RGB de float */
    float rfacteur, gfacteur, bfacteur; /* facteurs pour conversion en bytes */
    float rmin, gmin, bmin;       /* minimum des 3 plans RGB  */

    Canvas can;
    Scrollbar barvert, barhoriz;
    Pixwin *pw;
    struct pixrect *source_pixrect;

    can = (Canvas)ouvrir_fenetre (&pw, 3); /*indique il y a les statistiques*/
                                   /* pour les 3 plans dans le panneau info */
    if ((source_pixrect = mem_create(dir_desc[index_image[0]].ncolonne,
    dir_desc[index_image[0]].nligne, 8)) == NULL) {
        write_erreur(3);
        return;
    }
    pw_setcmsname (pw,"couleur");
    pw_putcolormap (pw,0,256,colormap[0],colormap[1],colormap[2]); 
    window_set (can, CANVAS_RETAINED, TRUE,
                WIN_VERTICAL_SCROLLBAR, barvert = scrollbar_create(0),
                WIN_HORIZONTAL_SCROLLBAR, barhoriz = scrollbar_create(0), 0);
    scrollbar_paint_clear (barvert);
    scrollbar_paint_clear (barhoriz);

    d = (unsigned char *) mpr_d(source_pixrect)->md_image;

    if (dir_desc[index_image[0]].type == 0 &&
        dir_desc[index_image[2]].type == 0 &&
        dir_desc[index_image[4]].type == 0) {
        /* les 3 plans (RGB) sont deja de type unsigned char */
        for (j=0; j<dir_desc[index_image[0]].nligne; j++){
            for (i=0; i<dir_desc[index_image[0]].ncolonne; i++) {
            /* calcul de la valeur composee de 3 bits R, 3 bits G, 2 bits B */
                *d = (unsigned char) 
                (diff_3(*r) << 5) + (diff_3(*g) << 2) + (diff_2(*b));
                d++; r++; g++; b++;
            }
            if (dir_desc[index_image[0]].ncolonne & 1) d++;
        }
    }
    else {
        /* on initialise les poiteurs de type correspondant au 3 plans (RGB) */
        switch ( dir_desc[index_image[0]].type) {
            /* plan R */
	    case -1:
	    case 0: br = (unsigned char *) r; break;
	    case 1: sr = (short *) r; break;
	    case 2: ir = (int *) r; break;
            case 3: fr = (float *) r; break;
        }
        switch ( dir_desc[index_image[2]].type) {
            /* plan G */
	    case -1:
	    case 0: bg = (unsigned char *) g; break;
	    case 1: sg = (short *) g; break;
	    case 2: ig = (int *) g; break;
            case 3: fg = (float *) g; break;
        }
        switch ( dir_desc[index_image[4]].type) {
            /* plan B */
	    case -1:
	    case 0: bb = (unsigned char *) b; break;
	    case 1: sb = (short *) b; break;
	    case 2: ib = (int *) b; break;
            case 3: fb = (float *) b; break;
        }
        /* facteur et minimum pour la conversion en byte des 3 plans (RGB) */
        rfacteur = MAXBYTE / (dir_desc[index_image[0]].mmax -
                             dir_desc[index_image[0]].mmin); 
        rmin = dir_desc[index_image[0]].mmin;
        gfacteur = MAXBYTE / (dir_desc[index_image[2]].mmax -
                             dir_desc[index_image[2]].mmin); 
        gmin = dir_desc[index_image[2]].mmin;
        bfacteur = MAXBYTE / (dir_desc[index_image[4]].mmax -
                             dir_desc[index_image[4]].mmin); 
        bmin = dir_desc[index_image[4]].mmin;
        for (j=0; j<dir_desc[index_image[0]].nligne; j++){
            for (i=0; i<dir_desc[index_image[0]].ncolonne; i++) {
                switch (dir_desc[index_image[0]].type) {
                /* plan R */
                    case -1:
                    case 0 : usr = (unsigned char) (*br - rmin) * rfacteur;
                         br++;  break;
                    case 1 : usr = (unsigned char) (*sr - rmin) * rfacteur;
                         sr++;  break;
                    case 2 : usr = (unsigned char) (*ir - rmin) * rfacteur;
                         ir++;  break;
                    case 3 : usr = (unsigned char) (*fr - rmin) * rfacteur;
                         fr++;  break;
                }
                switch (dir_desc[index_image[2]].type) {
                /* plan G */
                    case -1:
                    case 0 : usg = (unsigned char) (*bg - gmin) * gfacteur;
                         bg++;  break;
                    case 1 : usg = (unsigned char) (*sg - gmin) * gfacteur;
                         sg++;  break;
                    case 2 : usg = (unsigned char) (*ig - gmin) * gfacteur;
                         ig++;  break;
                    case 3 : usg = (unsigned char) (*fg - gmin) * gfacteur;
                         fg++;  break;
                }
                switch (dir_desc[index_image[4]].type) {
                /* plan B*/
                    case -1:
                    case 0 : usb = (unsigned char) (*bb - bmin) * bfacteur;
                         bb++;  break;
                    case 1 : usb = (unsigned char) (*sb - bmin) * bfacteur;
                         sb++;  break;
                    case 2 : usb = (unsigned char) (*ib - bmin) * bfacteur;
                         ib++;  break;
                    case 3 : usb = (unsigned char) (*fb - bmin) * bfacteur;
                         fb++;  break;
                }
		/*calcul de la valeur composee de 3 bits R,3 bits G,2 bits B*/
                *d = (unsigned char) 
                (diff_3(usr) << 5) + (diff_3(usg) << 2) + (diff_2(usb));
                d++;
            }
            if (dir_desc[index_image[0]].ncolonne & 1) d++;
	}
    }
    pw_write (pw, 0, 0, dir_desc[index_image[0]].ncolonne,
	dir_desc[index_image[0]].nligne, PIX_SRC, source_pixrect, 0, 0);
}

/*****************************************************************************/
/*                							     */
/* nom      : affiche_couleur_floyd					     */
/*									     */
/* fonction : affiche une image RGB (3 plans) en couleur dans un canvas	     */
/*									     */
/* entrees  : unsigned char *r	        : pointeur sur le plan-image R	     */
/*	    : unsigned char *g		: pointeur sur le plan-image G	     */
/*	    : unsigned char *b		: pointeur sur le plan-image B	     */
/*									     */
/* globales : description_memoire dir_desc				     */
/*	      int index_image[6]					     */
/*	      unsigned char colormap[3][256]				     */
/*									     */
/* return   : neant						             */
/*								             */
/* routines : write_erreur						     */
/*								             */
/*****************************************************************************/

affiche_couleur_floyd (r, g, b)
    
    unsigned char *r, *g, *b;

{
    register int i, j;
    unsigned char usr, usb, usg, vr, vg, vb;
    unsigned char *d, rcode, gcode, bcode;
    short ss, err;
    short *r_err, *g_err, *b_err, *r_err_next, *g_err_next, *b_err_next;
    short *temp, *rt, *gt, *bt, *rtn, *gtn, *btn;

    unsigned char *br, *bg, *bb;  /* les 3 plans RGB de bytes */
    short *sr, *sg, *sb;          /* les 3 plans RGB de short */
    int *ir, *ig, *ib;            /* les 3 plans RGB d'int    */
    float *fr, *fg, *fb;          /* les 3 plans RGB de float */
    float rfacteur, gfacteur, bfacteur; /* facteurs pour conversion en bytes */
    float rmin, gmin, bmin;       /* minimum des 3 plans RGB  */

    Canvas can;
    Scrollbar barvert, barhoriz;
    Pixwin *pw;
    struct pixrect *source_pixrect;

    can = (Canvas)ouvrir_fenetre (&pw, 3); /*indique il y a les statistiques*/
                                   /* pour les 3 plans dans le panneau info */
    if ((source_pixrect = mem_create(dir_desc[index_image[0]].ncolonne,
    dir_desc[index_image[0]].nligne, 8)) == NULL) {
        write_erreur(3);
        return;
    }
    pw_setcmsname (pw,"couleur");
    pw_putcolormap (pw,0,256,colormap[0],colormap[1],colormap[2]); 
    window_set (can, CANVAS_RETAINED, TRUE,
                WIN_VERTICAL_SCROLLBAR, barvert = scrollbar_create(0),
                WIN_HORIZONTAL_SCROLLBAR, barhoriz = scrollbar_create(0), 0);
    scrollbar_paint_clear (barvert);
    scrollbar_paint_clear (barhoriz);

    d = (unsigned char *) mpr_d(source_pixrect)->md_image;

    rt = r_err = (short *)
	malloc((dir_desc[index_image[0]].ncolonne + 1) * sizeof(*r_err));
    gt = g_err = (short *)
	malloc((dir_desc[index_image[0]].ncolonne + 1) * sizeof(*g_err));
    bt = b_err = (short *)
	malloc((dir_desc[index_image[0]].ncolonne + 1) * sizeof(*b_err));
    rtn = r_err_next = (short *)
	malloc((dir_desc[index_image[0]].ncolonne + 1) * sizeof(*r_err));
    gtn = g_err_next = (short *)
	malloc((dir_desc[index_image[0]].ncolonne + 1) * sizeof(*g_err));
    btn = b_err_next = (short *)	
	malloc((dir_desc[index_image[0]].ncolonne + 1) * sizeof(*b_err));
    for (i=0; i<=dir_desc[index_image[0]].ncolonne; i++)
	*r_err = *g_err = *b_err = *r_err_next = *g_err_next = *b_err_next = 0;

    if (dir_desc[index_image[0]].type == 0 &&
        dir_desc[index_image[2]].type == 0 &&
        dir_desc[index_image[4]].type == 0) {
        /* les 3 plans (RGB) sont deja de type unsigned char */
        for (j=0; j<dir_desc[index_image[0]].nligne; j++){
	    r_err = rt;  r_err_next = rtn;
	    g_err = gt;  g_err_next = gtn;
	    b_err = bt;  b_err_next = btn;
            for (i=0; i<dir_desc[index_image[0]].ncolonne; i++) {
		vr = (unsigned char)( (ss = (short)*r + *r_err) > 255 ?
		    255 : (ss < 0 ? 0 : ss) );
		vg = (unsigned char)( (ss = (short)*g + *g_err) > 255 ?
		    255 : (ss < 0 ? 0 : ss) );
		vb = (unsigned char)( (ss = (short)*b + *b_err) > 255 ?
		    255 : (ss < 0 ? 0 : ss) );
		*r_err = *g_err = *b_err = 0;
		rcode = diff_3 (vr);
		gcode = diff_3 (vg);
		bcode = diff_2 (vb);
                *d = (unsigned char) (rcode << 5) + (gcode << 2) + bcode;
		err = (short)(vr - code3[rcode]);
		*(r_err+1) += *(r_err_next) = (3 * err)>>3;
		*(r_err_next+1) += err>>2;
		err = (short)(vg - code3[gcode]);
		*(g_err+1) += *(g_err_next) = (3 * err)>>3;
		*(g_err_next+1) += err>>2;
		err = (short)(vb - code2[bcode]);
		*(b_err+1) += *(b_err_next) = (3 * err)>>3;
		*(b_err_next+1) += err>>2;
                d++; r++; g++; b++;
		r_err++;  g_err++;  b_err++;
		r_err_next++;  g_err_next++;  b_err_next++;
            }
	    temp = rt;  rt = rtn;  rtn = temp;
	    temp = gt;  gt = gtn;  gtn = temp;
	    temp = bt;  bt = btn;  btn = temp;
            if (dir_desc[index_image[0]].ncolonne & 1) d++;
        }
    }
    else {
        /* on initialise les poiteurs de type correspondant au 3 plans (RGB) */
        switch ( dir_desc[index_image[0]].type) {
            /* plan R */
	    case -1:
	    case 0: br = (unsigned char *) r; break;
	    case 1: sr = (short *) r; break;
	    case 2: ir = (int *) r; break;
            case 3: fr = (float *) r; break;
        }
        switch ( dir_desc[index_image[2]].type) {
            /* plan G */
	    case -1:
	    case 0: bg = (unsigned char *) g; break;
	    case 1: sg = (short *) g; break;
	    case 2: ig = (int *) g; break;
            case 3: fg = (float *) g; break;
        }
        switch ( dir_desc[index_image[4]].type) {
            /* plan B */
	    case -1:
	    case 0: bb = (unsigned char *) b; break;
	    case 1: sb = (short *) b; break;
	    case 2: ib = (int *) b; break;
            case 3: fb = (float *) b; break;
        }
        /* facteur et minimum pour la conversion en byte des 3 plans (RGB) */
        rfacteur = MAXBYTE / (dir_desc[index_image[0]].mmax -
                             dir_desc[index_image[0]].mmin); 
        rmin = dir_desc[index_image[0]].mmin;
        gfacteur = MAXBYTE / (dir_desc[index_image[2]].mmax -
                             dir_desc[index_image[2]].mmin); 
        gmin = dir_desc[index_image[2]].mmin;
        bfacteur = MAXBYTE / (dir_desc[index_image[4]].mmax -
                             dir_desc[index_image[4]].mmin); 
        bmin = dir_desc[index_image[4]].mmin;
        for (j=0; j<dir_desc[index_image[0]].nligne; j++){
	    r_err = rt;  r_err_next = rtn;
	    g_err = gt;  g_err_next = gtn;
	    b_err = bt;  b_err_next = btn;
            for (i=0; i<dir_desc[index_image[0]].ncolonne; i++) {
               switch (dir_desc[index_image[0]].type) {
                /* plan R */
                    case -1:
                    case 0 : usr = (unsigned char) (*br - rmin) * rfacteur;
                         br++;  break;
                    case 1 : usr = (unsigned char) (*sr - rmin) * rfacteur;
                         sr++;  break;
                    case 2 : usr = (unsigned char) (*ir - rmin) * rfacteur;
                         ir++;  break;
                    case 3 : usr = (unsigned char) (*fr - rmin) * rfacteur;
                         fr++;  break;
                }
                switch (dir_desc[index_image[2]].type) {
                /* plan G */
                    case -1:
                    case 0 : usg = (unsigned char) (*bg - gmin) * gfacteur;
                         bg++;  break;
                    case 1 : usg = (unsigned char) (*sg - gmin) * gfacteur;
                         sg++;  break;
                    case 2 : usg = (unsigned char) (*ig - gmin) * gfacteur;
                         ig++;  break;
                    case 3 : usg = (unsigned char) (*fg - gmin) * gfacteur;
                         fg++;  break;
                }
                switch (dir_desc[index_image[4]].type) {
                /* plan B*/
                    case -1:
                    case 0 : usb = (unsigned char) (*bb - bmin) * bfacteur;
                         bb++;  break;
                    case 1 : usb = (unsigned char) (*sb - bmin) * bfacteur;
                         sb++;  break;
                    case 2 : usb = (unsigned char) (*ib - bmin) * bfacteur;
                         ib++;  break;
                    case 3 : usb = (unsigned char) (*fb - bmin) * bfacteur;
                         fb++;  break;
                }
		vr = (unsigned char)( (ss = (short)usr + *r_err) > 255 ?
		    255 : (ss < 0 ? 0 : ss) );
		vg = (unsigned char)( (ss = (short)usg + *g_err) > 255 ?
		    255 : (ss < 0 ? 0 : ss) );
		vb = (unsigned char)( (ss = (short)usb + *b_err) > 255 ?
		    255 : (ss < 0 ? 0 : ss) );
		*r_err = *g_err = *b_err = 0;
		rcode = diff_3 (vr);
		gcode = diff_3 (vg);
		bcode = diff_2 (vb);
                *d = (unsigned char) (rcode << 5) + (gcode << 2) + bcode;
		err = (short)(vr - code3[rcode]);
		*(r_err+1) += *(r_err_next) = (3 * err)>>3;
		*(r_err_next+1) += err>>2;
		err = (short)(vg - code3[gcode]);
		*(g_err+1) += *(g_err_next) = (3 * err)>>3;
		*(g_err_next+1) += err>>2;
		err = (short)(vb - code2[bcode]);
		*(b_err+1) += *(b_err_next) = (3 * err)>>3;
		*(b_err_next+1) += err>>2;
                d++;
		r_err++;  g_err++;  b_err++;
		r_err_next++;  g_err_next++;  b_err_next++;
            }
	    temp = rt;  rt = rtn;  rtn = temp;
	    temp = gt;  gt = gtn;  gtn = temp;
	    temp = bt;  bt = btn;  btn = temp;
            if (dir_desc[index_image[0]].ncolonne & 1) d++;
        }
    }
    pw_write (pw, 0, 0, dir_desc[index_image[0]].ncolonne,
	dir_desc[index_image[0]].nligne, PIX_SRC, source_pixrect, 0, 0);
    free(rt);  free(gt);  free(bt);
    free(rtn);  free(gtn);  free(btn);
}

/*****************************************************************************/
/*									     */
/* nom      : proc_gris_lin						     */
/*									     */
/* fonction : declanche l'affichage d'une image par niveaux de gris lineaire */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : description_memoire dir_desc				     */
/*	      int index_memoire[6]					     */
/*	      char *buf							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : fromto							     */
/*	      write_erreur						     */
/*	      write_master						     */
/*	      affiche_image_color					     */
/*									     */
/*****************************************************************************/

caddr_t proc_gris_lin (m, mi)

    Menu m;
    Menu_item mi;

{
    if (flag_bother){
	hproc_gris_lin();
	return;
    }
    if (flag_help) hproc_gris_lin();
    if (!flag_creer){
	sprintf (buf, mastertabs[8]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO) 
	index_image[0] = macro_cour->from[0];
    else
	fromto (FROM, DEFAUT);
    if (flag_break) interruption();
    else{
	if (flag_creer){
	    struct commande *com;
	    com = (struct commande *)new_commande (&macro_cour);
	    sprintf (com->nom, "DISSIMGLI");
	    com->code = 10;
	    com->from[0] = index_image[0];
	    sprintf (buf, "DISSIMGLI FROM %d\n", index_image[0]);
	    write_macro (buf);	
	}
	else {
	    sprintf (buf, "Image %d\n", index_image[0]);
	    write_master (buf);
	    if (dir_image[index_image[0]].image == NULL) {
		write_erreur(1);
		return;
	    }
	    if (descr_file (flag_debug) >= 2) {
		affiche_image_color (dir_image[index_image[0]].image, LIN);
	    }
	}
    }
}

/*****************************************************************************/
/*									     */
/* nom      : proc_gris_log						     */
/*									     */
/* fonction : declanche l'affichage d'une image par niveaux de gris logaritm.*/
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : description_memoire dir_desc				     */
/*	      int index_memoire[6]					     */
/*	      char *buf							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : fromto							     */
/*	      write_erreur						     */
/*	      write_master						     */
/*	      affiche_image_color					     */
/*									     */
/*****************************************************************************/

caddr_t proc_gris_log (m, mi)

    Menu m;
    Menu_item mi;

{
    if (flag_bother){
	hproc_gris_log();
	return;
    }
    if (flag_help) hproc_gris_log();
    if (!flag_creer){
	sprintf (buf, mastertabs[9]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO) 
	index_image[0] = macro_cour->from[0];
    else
	if (descr_file (flag_debug) >= 2)
	    fromto (FROM, DEFAUT);
	else {
	    flag_break = TRUE;
	    write_erreur(30);
	}
    if (flag_break) interruption();
    else {
	if (flag_creer){
	    struct commande *com;
	    com = (struct commande *)new_commande (&macro_cour);
	    sprintf (com->nom, "DISSIMGLO");
	    com->code = 11;
	    com->from[0] = index_image[0];
	    sprintf (buf, "DISSIMGLO FROM %d\n", index_image[0]);
	    write_macro (buf);	
	}	
	else {
	    sprintf (buf, "Image %d\n", index_image[0]);
	    write_master (buf);
	    if (dir_image[index_image[0]].image == NULL) {
		write_erreur(1);
		return;
	    }
	    if (descr_file (flag_debug) >= 2) {
		affiche_image_color (dir_image[index_image[0]].image, LOG);
		descr_file (flag_debug);
	    }
	    else write_erreur(30);
	}
    }
}

/*****************************************************************************/
/*									     */
/* nom      : proc_couleur_rgb						     */
/*									     */
/* fonction : declanche l'affichage d'une image couleur RGB		     */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : description_memoire dir_desc				     */
/*	      int index_memoire[6]					     */
/*	      char *buf							     */
/*									     */
/* return : neant                                     		     */
/*									     */
/* routines : fromto							     */
/*	      write_erreur						     */
/*	      write_master						     */
/*	      affiche_image_couleur					     */
/*									     */
/*****************************************************************************/

caddr_t proc_couleur_rgb (m, mi)
 
    Menu m;
    Menu_item mi;

{
    int mode;


    mode = (int) menu_get (mi, MENU_VALUE);
    if (flag_bother){
	if (mode == 0) hproc_couleur_rgb();
	else hproc_rgb_reporterreur();
	return;
    }
    if (flag_help) {
	if (mode == 0) hproc_couleur_rgb();
	else hproc_rgb_reporterreur();
    }
    if (!flag_creer){
	if (mode == 0) sprintf (buf, mastertabs[10]);
	else sprintf (buf, mastertabs[11]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO) {
	index_image[0] = macro_cour->from[0];
	index_image[2] = macro_cour->from[1];
	index_image[4] = macro_cour->from[2];
    }
    else
	fromto (FROM, RGB);
    if (flag_break) interruption();
    else {
	if (!flag_creer) {
	    sprintf (buf, "Image %d %d %d\n", 
		    index_image[0], index_image[2], index_image[4]);
	    write_master (buf);
	    if (
	    dir_desc[index_image[0]].nligne!=dir_desc[index_image[2]].nligne ||
	    dir_desc[index_image[2]].nligne!=dir_desc[index_image[4]].nligne ||
	    dir_desc[index_image[4]].nligne!=dir_desc[index_image[0]].nligne ||
	    dir_desc[index_image[0]].ncolonne!=dir_desc[index_image[2]].ncolonne ||
	    dir_desc[index_image[2]].ncolonne!=dir_desc[index_image[4]].ncolonne ||
	    dir_desc[index_image[4]].ncolonne!=dir_desc[index_image[0]].ncolonne) {
		write_erreur(2);
		return;
	    }
	    if (dir_image[index_image[0]].image == NULL) {
		write_erreur(4);
		return;
	    }
	    if (dir_image[index_image[2]].image == NULL) {
		write_erreur(5);
		return;
	    }
	    if (dir_image[index_image[4]].image == NULL) {
		write_erreur(6);
		return;
	    }
	}
	if (mode == 0){
	    if (flag_creer){
		struct commande *com;
		com = (struct commande *)new_commande (&macro_cour);
		sprintf (com->nom, "ARGB\0");
		com->code = 12;
		com->from[0] = index_image[0];
		com->from[1] = index_image[2];
		com->from[2] = index_image[4];
		sprintf (buf, "DISSIMRDI FROM %d %d %d\n", 
			index_image[0], index_image[2], index_image[4]);
		write_macro (buf);	
	    }
	    else affiche_image_couleur (dir_image[index_image[0]].image,
					dir_image[index_image[2]].image,
				    dir_image[index_image[4]].image);
	}
	else{
	    if (flag_creer){
		struct commande *com;
		com = (struct commande *)new_commande (&macro_cour);
		sprintf (com->nom, "ARGBFS\0");
		com->code = 13;
		com->from[0] = index_image[0];
		com->from[1] = index_image[2];
		com->from[2] = index_image[4];
		sprintf (buf, "DISSIMRFS FROM %d %d %d\n", 
			index_image[0], index_image[2], index_image[4]);
		write_macro (buf);	
	    }
	    else affiche_couleur_floyd (dir_image[index_image[0]].image,
					dir_image[index_image[2]].image,
					dir_image[index_image[4]].image);
	}
    }
}

/*****************************************************************************/
/*									     */
/* nom      : proc_report_erreur					     */
/*									     */
/* fonction : declanche l'affichage d'une image noir/blaanc par		     */
/*	      Floyd-Steinberg						     */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : description_memoire dir_desc				     */
/*	      int index_memoire[6]					     */
/*	      char *buf							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : fromto							     */
/*	      write_erreur						     */
/*	      write_master						     */
/*	      affiche_image						     */
/*									     */
/*****************************************************************************/

caddr_t proc_report_erreur (m, mi)
    Menu m;
    Menu_item mi;

{

    if (flag_bother){
	hproc_report_erreur();
	return;
    }
    if (flag_help) hproc_report_erreur();	
    if (!flag_creer){
	sprintf (buf, mastertabs[12]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO) 
	index_image[0] = macro_cour->from[0];
    else
	fromto (FROM, DEFAUT);
    if (flag_break) interruption();
    else {
	if (flag_creer){
	    struct commande *com;
	    com = (struct commande *)new_commande (&macro_cour);
	    sprintf (com->nom, "ABWFS\0");
	    com->code = 15;
	    com->from[0] = index_image[0];
	    sprintf (buf, "DISSIMFST FROM %d\n", index_image[0]);
	    write_macro (buf);	
	}
	else {
	    sprintf (buf, "Image %d\n", index_image[0]);
	    write_master (buf);
	    if (dir_image[index_image[0]].image == NULL) {
		write_erreur(1);
		return;
	    }
	    affiche_image (2, index_image[0], dir_desc[index_image[0]].mu);
	}
    }
}

/*****************************************************************************/
/*									     */
/* nom      : proc_seuil						     */
/*									     */
/* fonction : declanche l'affichage d'une image noir/blanc par		     */
/*	      simple application d'un seuil				     */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : description_memoire dir_desc				     */
/*	      int index_memoire[6]					     */
/*	      char *buf							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : fromto							     */
/*	      write_erreur						     */
/*	      write_master						     */
/*	      affiche_image						     */
/*									     */
/*****************************************************************************/

caddr_t proc_seuil (m, mi)

    Menu m;
    Menu_item mi;

{
    if (flag_bother){
	hproc_seuil();
	return;
    }
    if (flag_help) hproc_seuil();
    if (!flag_creer){
	sprintf (buf, mastertabs[13]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO) 
	index_image[0] = macro_cour->from[0];
    else
	fromto (FROM, DEFAUT);
    if (flag_break) interruption();
    else {
	if (flag_creer){
	    struct commande *com;
	    com = (struct commande *)new_commande (&macro_cour);
	    sprintf (com->nom, "DISSIMTHR");
	    com->code = 14;
	    com->from[0] = index_image[0];
	    sprintf (buf, "DISSIMTHR FROM %d\n", index_image[0]);
	    write_macro (buf);	
	}
	else {
	    sprintf (buf, "Image %d\n", index_image[0]);
	    write_master (buf);
	    if (dir_image[index_image[0]].image == NULL) {
		write_erreur(1);
		return;
	    }
	    affiche_image(1, index_image[0], dir_desc[index_image[0]].mu);
	}
    }
}
