/************************* MPEG-2 NBC Audio Decoder **************************
 *                                                                           *
 "This software module was originally developed by 
 Fraunhofer Gesellschaft IIS / University of Erlangen (UER)
 and edited by
 Takashi Koike (Sony Corporation)
 in the course of 
 development of the MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 
 14496-1,2 and 3. This software module is an implementation of a part of one or more 
 MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 
 Audio standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio 
 standards free license to this software module or modifications thereof for use in 
 hardware or software products claiming conformance to the MPEG-2 NBC/MPEG-4
 Audio  standards. Those intending to use this software module in hardware or 
 software products are advised that this use may infringe existing patents. 
 The original developer of this software module and his/her company, the subsequent 
 editors and their companies, and ISO/IEC have no liability for use of this software 
 module or modifications thereof in an implementation. Copyright is not released for 
 non MPEG-2 NBC/MPEG-4 Audio conforming products.The original developer
 retains full right to use the code for his/her  own purpose, assign or donate the 
 code to a third party and to inhibit third party from using the code for non 
 MPEG-2 NBC/MPEG-4 Audio conforming products. This copyright notice must
 be included in all copies or derivative works." 
 Copyright(c)1996.
 *                                                                           *
 ****************************************************************************/

/* CREATED BY :  Bernhard Grill -- June-96  */

/* 28-Aug-1996  NI: added "NO_SYNCWORD" to enum TRANSPORT_STREAM */

#ifndef _TF_MAIN_H_INCLUDED
#define _TF_MAIN_H_INCLUDED

#include "bitstream.h"
#include "block.h"
#include "interface.h"
typedef struct
{
  int	    islong;			/* true if long block */
  int	    nsbk;			/* sub-blocks (SB) per block */
  int	    bins_per_bk;		/* coef's per block */
  int	    sfb_per_bk;			/* sfb per block */
  int	    bins_per_sbk[MAX_SBK];	/* coef's per SB */
  int	    sfb_per_sbk[MAX_SBK];	/* sfb per SB */
  int	    sectbits[MAX_SBK];
  short   *sbk_sfb_top[MAX_SBK];	/* top coef per sfb per SB */
  short   *sfb_width_short;		/* sfb width for short blocks */
  short   bk_sfb_top[200];		/* cum version of above */
  int	    num_groups;
  short   group_len[8];
  short   group_offs[8];
  int    shortFssWidth;
  int    longFssGroups;
} Info;

/* select different pre-/post- processing modules TK */
enum PP_MOD_SELECT { NONE=0x0, AAC_PP=0x1 };

/* select different T/F modules */
enum TF_MOD_SELECT { VM_TF_SOURCE=0x1, MDCT_AAC=0x2, MDCT_UER=0x4, QMF_MDCT_SONY=0x8, LOW_DELAY_UNH=0x10 };

/* select different Q&C modules */ /* YB : 970825 */
typedef enum _QC_MOD_SELECT { 
  VM_QC_SOURCE=0x1, AAC_QC=0x2, MDCT_VALUES_16BIT=0x4, UER_QC=0x8, NTT_VQ=0x10 ,AAC_SCALEABLE=0x20, AAC_BSAC=0x40
} QC_MOD_SELECT;

/* name the audio channels */
enum CHANN_ASS { 
  MONO_CHAN=0,
  LEFT_CHAN=0, 
  RIGHT_CHAN=1,
  MAX_CHANNELS
};

enum TF_LAYER { 
  MAX_MED_LAYER=4,
  HIGH_LAYER=4,
  MAX_TF_LAYER=5
};

/* audio channel configuration coding */
enum CH_CONFIG { CHC_MONO, CHC_DUAL, CHC_JOINT_DUAL, CHC_5CHAN, CHC_MODES };

/* transport layer type */ /* added "NO_SYNCWORD" by NI (28 Aug. 1996) */
enum TRANSPORT_STREAM { NO_TSTREAM, AAC_RAWDATA_TSTREAM, LENINFO_TSTREAM,
		        NO_SYNCWORD};

enum SR_CODING { SR8000, SR11025, SR12000, SR16000, SR22050, SR24000, SR32000, SR44100, SR48000, SR96000, MAX_SAMPLING_RATES };

typedef enum  { 
  ONLY_LONG_WINDOW, 
  LONG_SHORT_WINDOW, 
  ONLY_SHORT_WINDOW,
  SHORT_LONG_WINDOW,
  SHORT_MEDIUM_WINDOW,
  MEDIUM_LONG_WINDOW,
  LONG_MEDIUM_WINDOW,
  MEDIUM_SHORT_WINDOW,
  ONLY_MEDIUM_WINDOW,
  
  LONG_START_WINDOW,
  EIGHT_SHORT_WINDOW,
  LONG_STOP_WINDOW,
  NUM_WIN_SEQ        
} WINDOW_TYPE ;    

enum AAC_WINDOW_SEQUENCE { /* TK */
  ONLY_LONG_SEQUENCE = ONLY_LONG_WINDOW,
  LONG_START_SEQUENCE = LONG_SHORT_WINDOW,
  EIGHT_SHORT_SEQUENCE = ONLY_SHORT_WINDOW,
  LONG_STOP_SEQUENCE = SHORT_LONG_WINDOW
};

enum WIN_SWITCH_MODE {
  STATIC_LONG,
  STATIC_MEDIUM,
  STATIC_SHORT,
  LS_STARTSTOP_SEQUENCE,
  LM_STARTSTOP_SEQUENCE,
  MS_STARTSTOP_SEQUENCE,
  LONG_SHORT_SEQUENCE,
  LONG_MEDIUM_SEQUENCE,
  MEDIUM_SHORT_SEQUENCE,
  LONG_MEDIUM_SHORT_SEQUENCE,
  FFT_PE_WINDOW_SWITCHING
};

enum AAC_BIT_STREAM_TYPE { 
  SCALEABLE,
  NOT_SCALEABLE
};
enum CORE_CODEC { CC_G729, CC_G723_63, CC_G723_53, CC_FS1016, CC_CELP_MPEG4_50, CC_CELP_MPEG4_60, CC_CELP_MPEG4_80, CC_PAR_MPEG4, MAX_CC_CORE_CODEC ,NO_CORE};
enum _MAX { MAX_GRANULES = 3 ,
	    NSFB_LONG  = 49,
	    NSFB_SHORT= 14,
	    MAX_SHORT_IN_LONG_BLOCK= 8,
	    MAX_SHORT_WINDOWS = 8
};

/* if static memory allocation is used, this value tells the max. nr of 
   audio channels to be supported */
#define MAX_TIME_CHANNELS (MAX_CHANNELS)

/* max. number of scale factor bands */
#define MAX_SCFAC_BANDS ((NSFB_SHORT+1)*MAX_SHORT_IN_LONG_BLOCK)

void buffer2freq(                    /* Input: Time signal              */
  double           p_in_data[],      /* Output: MDCT cofficients        */
  double           p_out_mdct[],
  double           p_overlap[],
  WINDOW_TYPE block_type,
  Window_shape     wfun_select,      /* offers the possibility to select different window functions */
  int              nlong,            /* shift length for long windows   */
  int              nmed,             /* shift length for medium windows */
  int              nshort,           /* shift length for short windows  */
  Mdct_in          overlap_select,   /* select mdct input *TK*          */
                                     /* switch (overlap_select) {       */
                                     /* case OVERLAPPED:                */
                                     /*   p_in_data[]                   */
                                     /*   = overlapped signal           */
                                     /*         (bufferlength: nlong)   */
                                     /* case NON_OVERLAPPED:            */
                                     /*   p_in_data[]                   */
                                     /*   = non overlapped signal       */
                                     /*         (bufferlength: 2*nlong) */
  int              num_short_win,    /* number of short windows to      */
                                     /* transform                       */
  int              save_window       /* save window information         */
);


void freq2buffer(
  double           p_in_data[],     /* Input: MDCT coefficients                */
  double           p_out_data[],    /* Output:time domain reconstructed signal */
  double           p_overlap[],  
  WINDOW_TYPE block_type,
  int              nlong,           /* shift length for long windows   */
  int              nmed,            /* shift length for medium windows */
  int              nshort,          /* shift length for short windows  */
  Window_shape     wfun_select,     /* offers the possibility to select different window functions */
  Window_shape     wfun_select_prev, /* YB : 971113 */
  Imdct_out	   overlap_select,   /* select imdct output *TK*	*/
                                     /* switch (overlap_select) {       */
                                     /* case OVERLAPPED:                */
                                     /*   p_out_data[]                  */
                                     /*   = overlapped and added signal */
                                     /*         (bufferlength: nlong)   */
                                     /* case NON_OVERLAPPED:            */
                                     /*   p_out_data[]                  */
                                     /*   = non overlapped signal       */
                                     /*         (bufferlength: 2*nlong) */
  int              num_short_win     /* number of short windows to      */
                                     /* transform                       */
);

void imdct(double in_data[], double out_data[], int len);

void fft( double in[], double out[], int len );

void aacScaleableDecodeInit( void );

void  aacScaleableDecode( 
  BsBitStream *fixed_stream,
  BsBitStream *gc_WRstream[],
  WINDOW_TYPE block_type[MAX_TIME_CHANNELS],
  int    *decodedBits,
  double *spectral_line_vector[MAX_TF_LAYER][MAX_TIME_CHANNELS],
  int    block_size_samples,
  int output_select,
  Info **  sfbInfo ,
  int numChannels,long int samplRate
);

#endif	/* #ifndef _TF_MAIN_H_INCLUDED */


