head	1.7;
access;
symbols
	Distribution_06:1.5
	IRT_02:1.4.2.1
	Philips_01:1.4.1.1
	D6Base:1.4
	Distribution_05:1.4
	Distribution_04:1.4
	Distribution_03:1.4
	Samsung_01:1.4
	IRT_01:1.4
	TI_01:1.4
	Distribution_01a:1.4
	Distribution_02:1.4
	Distribution_00:1.1
	Distribution_01:1.4;
locks; strict;
comment	@ * @;


1.7
date	96.02.12.07.13.35;	author rowlands;	state Exp;
branches;
next	1.6;

1.6
date	96.02.12.05.51.17;	author rowlands;	state Exp;
branches;
next	1.5;

1.5
date	96.01.20.17.13.10;	author rowlands;	state Exp;
branches;
next	1.4;

1.4
date	95.04.06.04.29.39;	author rowlands;	state Exp;
branches
	1.4.1.0
	1.4.2.0
	1.4.3.0;
next	1.3;

1.3
date	95.04.06.03.32.04;	author rowlands;	state Exp;
branches;
next	1.2;

1.2
date	95.04.06.02.07.35;	author rowlands;	state Exp;
branches;
next	1.1;

1.1
date	95.04.06.02.06.11;	author rowlands;	state Exp;
branches;
next	;

1.4.1.0
date	95.11.06.04.11.24;	author rowlands;	state Exp;
branches;
next	1.4.1.1;

1.4.1.1
date	95.11.06.04.12.25;	author rowlands;	state Exp;
branches;
next	;

1.4.2.0
date	95.11.06.04.16.46;	author rowlands;	state Exp;
branches;
next	1.4.2.1;

1.4.2.1
date	95.11.06.04.19.12;	author rowlands;	state Exp;
branches;
next	;

1.4.3.0
date	95.11.06.04.22.37;	author rowlands;	state Exp;
branches;
next	1.4.3.1;

1.4.3.1
date	96.01.19.04.40.26;	author rowlands;	state Exp;
branches;
next	;


desc
@MPEG-2 public C encoder
@


1.7
log
@Release following Munich meeting
@
text
@/**********************************************************************
 * ISO MPEG Audio Subgroup Software Simulation Group (1996)
 * ISO 13818-3 MPEG-2 Audio Multichannel Encoder
 *
 * $Id: lingual.c 1.6 1996/02/12 05:51:17 rowlands Exp $
 *
 * $Log: lingual.c $
 * Revision 1.4.2.1  1995/11/06  04:19:12  rowlands
 * Received from Uwe Felderhoff (IRT)
 *
 * Revision 1.5  1995/08/14  08:03:03  tenkate
 * ML-LSF added Warner ten Kate 7/8/95 (Philips)
 * change alloc and sblimit into allocml and mlsblimit where appropriate
 * ml_sb_sample_swap() ml_sb_sample_shift() and pick_scale_ml_2() added.
 **********************************************************************/

#define VERY_FAST_FILTER  1	/* JMZ */

#define LOWPASS 20

#include "common.h"
#include "encoder.h"

/************************************************************************/
/*
/* read_samples()
/*
/* PURPOSE:  reads the PCM samples from a file to the buffer
/*
/*  SEMANTICS:
/* Reads #samples_read# number of shorts from #musicin# filepointer
/* into #sample_buffer[]#.  Returns the number of samples read.
/*
/************************************************************************/

unsigned long read_samples_ml(FILE *musicin, long int *sample_buffer, long unsigned int num_samples, long unsigned int frame_size, int *byte_per_sample, int *aiff)
{
unsigned long samples_read;
static unsigned long samples_to_read;
static char init = TRUE;
short pcm_sample_buffer[8064];        /*for correct reading of pcm-data*/
int i;

if (init) 
{
	samples_to_read = num_samples;
	init = FALSE;
}
if (samples_to_read >= frame_size)
	samples_read = frame_size;
else
	samples_read = samples_to_read;
if((*aiff==1) &&(*byte_per_sample !=2))
{
if ((samples_read = fread(sample_buffer, *byte_per_sample, (int)samples_read, musicin)) == 0)
	if (verbosity >= 2) printf("Hit end of audio data\n");
}
else
{
if ((samples_read = fread(pcm_sample_buffer, sizeof(short), (int)samples_read, musicin)) == 0)
	if (verbosity >= 2) printf("Hit end of audio data\n");
for(i = 0; i < samples_read; ++i) /* replace 5760 by 'samples_read' WtK 7/8/95 */
	sample_buffer[i] = pcm_sample_buffer[i];
}

samples_to_read -= samples_read;
if (samples_read < frame_size && samples_read > 0) 
{
	if (verbosity >= 2) printf("Insufficient PCM input for one frame - fillout with zeros\n");
	for (; samples_read < frame_size; sample_buffer[samples_read++] = 0);
	samples_to_read = 0;
}
return(samples_read);
}

 
/************************************************************************/
/*
/* get_audio_ml()
/*
/* PURPOSE:  reads a frame of audio data from a file to the buffer,
/*   aligns the data for future processing, and separates the
/*   left and right channels
/*
/*  SEMANTICS:
/* Calls read_samples() to read a frame of audio data from filepointer
/* #musicin# to #insampl[]#.  The data is shifted to make sure the data
/* is centered for the 1024pt window to be used by the psychoacoustic model,
/* and to compensate for the 256 sample delay from the filter bank. For
/* stereo, the channels are also demultiplexed into #buffer[0][]# and
/* #buffer[1][]#
/*
/************************************************************************/
unsigned long
get_audio_ml(
	FILE *musicin_ml,
	double (*buffer)[1152],
	long unsigned int num_samples,
	IFF_AIFF *aiff_ptr,
	frame_params *fr_ps,
	int *aiff,
	int *byte_per_sample,
	double (*buffer_matr)[1152]
) {
int  j, ch;
long insamp[8064];
unsigned long samples_read;
int  n_ml_ch = fr_ps->header->multiling_ch;
	
	samples_read = read_samples_ml(musicin_ml, insamp, num_samples, (unsigned long) 1152*n_ml_ch, byte_per_sample, aiff);
	for(j=0; j<1152; j++) 
	  for (ch=0;ch<n_ml_ch;ch++)
	    buffer_matr[7+ch][j] = buffer[7+ch][j] = insamp[(n_ml_ch*j)+ch]; /*WtK 7/8/95 */

return(samples_read);
}

/************************************************************************
/*
/* I_encode_scale  (Layer I)
/* II_encode_scale (Layer II)
/*
/* PURPOSE:The encoded scalar factor information is arranged and
/* queued into the output fifo to be transmitted.
/*
/* For Layer II, the three scale factors associated with
/* a given subband and channel are transmitted in accordance
/* with the scfsi, which is transmitted first.
/*
/************************************************************************/
 
 
void II_sample_encoding_ml(unsigned int (*sbband)[3][12][32], unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
{
   unsigned int temp;
   unsigned int i,j,k,s,x,y;
   int n_ml_ch       = fr_ps->header->multiling_ch;
   int lsf           = fr_ps->header->multiling_fs;
   int mlsblimit     = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;
   
for (s=0;s<3;s++)
  for (j=0;j<((lsf==1)?6:12);j+=3)
    for (i=0;i<mlsblimit;i++)
      for (k = 7; k < 7+n_ml_ch; k++)
	if (bit_alloc[k][i]) 
	{
		if ((*allocml)[i][bit_alloc[k][i]].group == 3) 
		{
			for (x = 0; x < 3; x++)
			putbits(bs,sbband[k][s][j+x][i],
                                    (*allocml)[i][bit_alloc[k][i]].bits);
		}
		else 
		{
			y =(*allocml)[i][bit_alloc[k][i]].steps;
			temp = 	sbband[k][s][j][i] +
				sbband[k][s][j+1][i] * y +
				sbband[k][s][j+2][i] * y * y;
			putbits(bs,temp,(*allocml)[i][bit_alloc[k][i]].bits);
		}
	}
}

void II_encode_bit_alloc_ml(unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
{
   int i,k;
   int n_ml_ch       = fr_ps->header->multiling_ch;
   int mlsblimit     = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;
   
  for (i=0;i<mlsblimit;i++)
  {
	for(k = 7; k < 7+n_ml_ch; ++k)
	{        
		putbits(bs, bit_alloc[k][i], (*allocml)[i][0].bits);
	}
  }	
}


void ml_sb_sample_swap (int ch0, int ch1, double subsample[14][3][12][SBLIMIT])
/* Function is called if MultiLingual LSF applies.                   */
/* It organizes subband samples from 3 sub frames of 12 samples each */
/* into 6 sub frames of 6 samples each. Subframes 3, 4 and 5 are at  */
/* sample indices 6..11 in subframes 0,1,2 respectively.             */
/* WtK 7/8/95                                                        */
{
int    ch,sb,ss;
double hlp[6];

for (ch=ch0;ch<ch1;ch++)
  for (sb=0;sb<SBLIMIT;sb++)
    for (ss=0;ss<6;ss++) {
      hlp[ss]                    = subsample[ch][2][  ss][sb];
      subsample[ch][2][  ss][sb] = subsample[ch][1][  ss][sb];
      subsample[ch][1][  ss][sb] = subsample[ch][0][6+ss][sb];
      subsample[ch][0][6+ss][sb] = subsample[ch][1][6+ss][sb];
      subsample[ch][1][6+ss][sb] = hlp[ss];
    }
}

void ml_sb_sample_shift (int ch0, int ch1,double subsample[14][3][12][SBLIMIT])
/* In case of MultiLingual LSF this function is called.             */
/* It shifts the second part in the sub frames into the first part. */
/* The first part is shifted into the second part to be used by     */
/* pick_scale_ml_2()                                                */
/* WtK 7/8/95                                                       */
{
int    ch,sb,p,ss;
double hlp[6];

for (ch=ch0;ch<ch1;ch++)
  for (sb=0;sb<SBLIMIT;sb++)
    for (p=0;p<2;p++)
      for (ss=0;ss<6;ss++) {
        hlp[ss]                    = subsample[ch][p][  ss][sb];
	subsample[ch][p][ss][sb]   = subsample[ch][p][ss+6][sb];
	subsample[ch][p][ss+6][sb] = hlp[ss];
      }
}

void pick_scale_ml_2(frame_params *fr_ps, double subsample[14][3][12][SBLIMIT], double (*max_sc)[32])
/* pick largest max_sc of odd and even half of frame in case of LSF ML. */
/* This improves the psychoacoustic result:                             */
/* The masked threshold is calculated over 2 LSF frames; consequently,  */
/* the signal level should also be determined over those 2 frames in    */
/* order to obtain a fair estimate of the SMR.                          */
/* WtK , 7/8/95                                                         */
{
  int k,i,p,j;
  int maxi;
  double maxs,mods;
  int n_ml_ch   = fr_ps->header->multiling_ch;
  int mlsblimit = fr_ps->mlsblimit;
  int ml_fs     = fr_ps->header->multiling_fs;

 if ( (n_ml_ch>0) && (ml_fs==1) ) {
    for (k=7; k<7+n_ml_ch; k++) {
       for (i=0;i<mlsblimit;i++) {
	   maxs = subsample[k][0][0][i]; if (maxs<0) maxs = -maxs;
	   for (p=0;p<3;p++) for (j=6;j<12;j++) {
              mods = subsample[k][p][j][i]; if (mods<0) mods = -mods;
	      if (mods>maxs) maxs = mods;
	   }
           for (j=SCALE_RANGE-1,maxi=0;j>=0;j--)
	    if (maxs < multiple[j]) {
	      maxi = j;
	      break;
	   }
	   if (multiple[maxi]>max_sc[k][i]) max_sc[k][i] = multiple[maxi];
       }
    }
 }
}
@


1.6
log
@Added verbosity switch to control text output.
@
text
@d2 2
a3 3
 * Copyright (c) 1995 MPEG/audio software simulation group
 * All Rights Reserved
 * $Id: lingual.c 1.5 1996/01/20 17:13:10 rowlands Exp rowlands $
d5 1
a5 3
 * MPEG/audio coding/decoding software, work in progress
 *   NOT for public distribution until verified and approved by the
 *   MPEG/audio committee.
a7 6
 * Revision 1.5  1996/01/20 17:13:10  rowlands
 * Moved Merged into main trunk
 *
 * Revision 1.4.3.1  1996/01/19  04:40:26  rowlands
 * Merged
 *
d9 1
a9 4
 * Received from Uwe Felderhoff
 *
 * Revision 1.4.1.1  1995/11/06  04:12:25  rowlands
 * Received from Warner ten Kate
d12 1
a12 1
 * ML-LSF added WtK 7/8/95
a14 4
 *
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
@


1.5
log
@Moved Merged into main trunk
@
text
@d4 1
a4 1
 * $Id: lingual.c 1.4.3.1 1996/01/19 04:40:26 rowlands Exp $
d11 3
d72 1
a72 1
	printf("Hit end of audio data\n");
d77 1
a77 1
	printf("Hit end of audio data\n");
d85 1
a85 1
	printf("Insufficient PCM input for one frame - fillout with zeros\n");
@


1.4
log
@Added header and RCS info to initial revision.
@
text
@d4 1
a4 1
 * $Id$
d10 18
a27 1
 * $Log$
d75 1
a75 1
for(i = 0; i < 5760; ++i) 
d118 1
a118 1
int j, i;
d121 1
a121 3
int lay;
layer *info = fr_ps->header;
int n_ml_ch = info->multiling_ch;
a122 3
	lay = info->lay;
/* JMZ 16/03/1995 MODIFICATIONS */
	/*samples_read = read_samples_ml(musicin_ml, insamp, 1152*n_ml_ch, (unsigned long) 1152*n_ml_ch, byte_per_sample, aiff);*/
d125 2
a126 3
	{
			buffer[7+0][j] 		= insamp[n_ml_ch*j];
			buffer_matr[7+0][j]	= insamp[n_ml_ch*j+0];
a127 39
		if (n_ml_ch >1)
			{
			buffer[7+1][j] 		= insamp[n_ml_ch*j+1];
			buffer_matr[7+1][j]	= insamp[n_ml_ch*j+1];

			}
		if (n_ml_ch >2)
			{
			buffer[7+2][j] 		= insamp[n_ml_ch*j+2];
			buffer_matr[7+2][j] 	= insamp[n_ml_ch*j+2];

			}
		if (n_ml_ch >3)
			{
			buffer[7+3][j] 		= insamp[n_ml_ch*j+3];
			buffer_matr[7+3][j] 	= insamp[n_ml_ch*j+3];

			}
		if (n_ml_ch >4)
			{
			buffer[7+4][j] 		= insamp[n_ml_ch*j+4];
			buffer_matr[7+4][j] 	= insamp[n_ml_ch*j+4];

			}
		if (n_ml_ch >5)
			{
			buffer[7+5][j] 		= insamp[n_ml_ch*j+5];
			buffer_matr[7+5][j] 	= insamp[n_ml_ch*j+5];

			}
		if (n_ml_ch >6)
			{
			buffer[7+6][j] 		= insamp[n_ml_ch*j+6];
			buffer_matr[7+6][j] 	= insamp[n_ml_ch*j+6];

			}

	/* Remplacer les "if" par un for (i=0;i<n_ml_ch...) */
	}
a146 4
             	                           	/*24/02/1995 JMZ Multilingual */
             	                       		/*24/02/1995 JMZ Multilingual */
             	       
                     
d149 5
a153 7
   unsigned int i,j,k,s,x,y, l, m;
   int stereo	= fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
   int jsboundmc = fr_ps->jsboundmc;
   al_table *alloc = fr_ps->alloc;
   int n_ml_ch = fr_ps->header->multiling_ch;
d156 3
a158 5
for (j=0;j<12;j+=3)
for (i=0;i<sblimit;i++)
for (m = 7; m < 7+n_ml_ch; m++)
{
	k=m;
d161 1
a161 1
		if ((*alloc)[i][bit_alloc[k][i]].group == 3) 
d165 1
a165 1
                                    (*alloc)[i][bit_alloc[k][i]].bits);
d169 1
a169 1
			y =(*alloc)[i][bit_alloc[k][i]].steps;
d173 1
a173 2
			putbits(bs,temp,(*alloc)[i][bit_alloc[k][i]].bits);

a176 1
}
a178 3
             	                       		/*24/02/1995 JMZ Multilingual */
             	       
                     
d180 7
a186 10
   int i,k, l, m;
   int stereo	   = fr_ps->stereomc;
   int sblimit     = fr_ps->sblimit;
   int jsboundmc   = fr_ps->jsboundmc;
   int n_ml_ch     = fr_ps->header->multiling_ch;
   al_table *alloc = fr_ps->alloc;
   int ll;
 
for (i=0;i<sblimit;i++)
{
d189 1
a189 2
		putbits(bs, bit_alloc[k][i], (*alloc)[i][0].bits);

d191 1
a191 1
}	
d195 74
@


1.4.3.0
log
@Branch for merging IRT_02 and Philips_01
@
text
@d4 1
a4 1
 * $Id: lingual.c 1.4 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 4
 * $Log: lingual.c $
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
@


1.4.3.1
log
@Merged
@
text
@d4 1
a4 1
 * $Id: lingual.c 1.4.1.1 1995/11/06 04:12:25 rowlands Exp $
a10 11
 * Revision 1.4.2.1  1995/11/06  04:19:12  rowlands
 * Received from Uwe Felderhoff
 *
 * Revision 1.4.1.1  1995/11/06  04:12:25  rowlands
 * Received from Warner ten Kate
 *
 * Revision 1.5  1995/08/14  08:03:03  tenkate
 * ML-LSF added WtK 7/8/95
 * change alloc and sblimit into allocml and mlsblimit where appropriate
 * ml_sb_sample_swap() ml_sb_sample_shift() and pick_scale_ml_2() added.
 *
d61 1
a61 1
for(i = 0; i < samples_read; ++i) /* replace 5760 by 'samples_read' WtK 7/8/95 */
d104 1
a104 1
int  j, ch;
d107 3
a109 1
int  n_ml_ch = fr_ps->header->multiling_ch;
d111 3
d116 3
a118 2
	  for (ch=0;ch<n_ml_ch;ch++)
	    buffer_matr[7+ch][j] = buffer[7+ch][j] = insamp[(n_ml_ch*j)+ch]; /*WtK 7/8/95 */
d120 39
d178 4
d184 7
a190 5
   unsigned int i,j,k,s,x,y;
   int n_ml_ch       = fr_ps->header->multiling_ch;
   int lsf           = fr_ps->header->multiling_fs;
   int mlsblimit     = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;
d193 5
a197 3
  for (j=0;j<((lsf==1)?6:12);j+=3)
    for (i=0;i<mlsblimit;i++)
      for (k = 7; k < 7+n_ml_ch; k++)
d200 1
a200 1
		if ((*allocml)[i][bit_alloc[k][i]].group == 3) 
d204 1
a204 1
                                    (*allocml)[i][bit_alloc[k][i]].bits);
d208 1
a208 1
			y =(*allocml)[i][bit_alloc[k][i]].steps;
d212 2
a213 1
			putbits(bs,temp,(*allocml)[i][bit_alloc[k][i]].bits);
d217 1
d220 3
d224 10
a233 7
   int i,k;
   int n_ml_ch       = fr_ps->header->multiling_ch;
   int mlsblimit     = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;
   
  for (i=0;i<mlsblimit;i++)
  {
d236 2
a237 1
		putbits(bs, bit_alloc[k][i], (*allocml)[i][0].bits);
d239 1
a239 1
  }	
a242 74
void ml_sb_sample_swap (int ch0, int ch1, double subsample[14][3][12][SBLIMIT])
/* Function is called if MultiLingual LSF applies.                   */
/* It organizes subband samples from 3 sub frames of 12 samples each */
/* into 6 sub frames of 6 samples each. Subframes 3, 4 and 5 are at  */
/* sample indices 6..11 in subframes 0,1,2 respectively.             */
/* WtK 7/8/95                                                        */
{
int    ch,sb,ss;
double hlp[6];

for (ch=ch0;ch<ch1;ch++)
  for (sb=0;sb<SBLIMIT;sb++)
    for (ss=0;ss<6;ss++) {
      hlp[ss]                    = subsample[ch][2][  ss][sb];
      subsample[ch][2][  ss][sb] = subsample[ch][1][  ss][sb];
      subsample[ch][1][  ss][sb] = subsample[ch][0][6+ss][sb];
      subsample[ch][0][6+ss][sb] = subsample[ch][1][6+ss][sb];
      subsample[ch][1][6+ss][sb] = hlp[ss];
    }
}

void ml_sb_sample_shift (int ch0, int ch1,double subsample[14][3][12][SBLIMIT])
/* In case of MultiLingual LSF this function is called.             */
/* It shifts the second part in the sub frames into the first part. */
/* The first part is shifted into the second part to be used by     */
/* pick_scale_ml_2()                                                */
/* WtK 7/8/95                                                       */
{
int    ch,sb,p,ss;
double hlp[6];

for (ch=ch0;ch<ch1;ch++)
  for (sb=0;sb<SBLIMIT;sb++)
    for (p=0;p<2;p++)
      for (ss=0;ss<6;ss++) {
        hlp[ss]                    = subsample[ch][p][  ss][sb];
	subsample[ch][p][ss][sb]   = subsample[ch][p][ss+6][sb];
	subsample[ch][p][ss+6][sb] = hlp[ss];
      }
}

void pick_scale_ml_2(frame_params *fr_ps, double subsample[14][3][12][SBLIMIT], double (*max_sc)[32])
/* pick largest max_sc of odd and even half of frame in case of LSF ML. */
/* This improves the psychoacoustic result:                             */
/* The masked threshold is calculated over 2 LSF frames; consequently,  */
/* the signal level should also be determined over those 2 frames in    */
/* order to obtain a fair estimate of the SMR.                          */
/* WtK , 7/8/95                                                         */
{
  int k,i,p,j;
  int maxi;
  double maxs,mods;
  int n_ml_ch   = fr_ps->header->multiling_ch;
  int mlsblimit = fr_ps->mlsblimit;
  int ml_fs     = fr_ps->header->multiling_fs;

 if ( (n_ml_ch>0) && (ml_fs==1) ) {
    for (k=7; k<7+n_ml_ch; k++) {
       for (i=0;i<mlsblimit;i++) {
	   maxs = subsample[k][0][0][i]; if (maxs<0) maxs = -maxs;
	   for (p=0;p<3;p++) for (j=6;j<12;j++) {
              mods = subsample[k][p][j][i]; if (mods<0) mods = -mods;
	      if (mods>maxs) maxs = mods;
	   }
           for (j=SCALE_RANGE-1,maxi=0;j>=0;j--)
	    if (maxs < multiple[j]) {
	      maxi = j;
	      break;
	   }
	   if (multiple[maxi]>max_sc[k][i]) max_sc[k][i] = multiple[maxi];
       }
    }
 }
}
@


1.4.2.0
log
@Branch for Felderhoff
@
text
@d4 1
a4 1
 * $Id: lingual.c 1.4 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 4
 * $Log: lingual.c $
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
@


1.4.2.1
log
@Received from Uwe Felderhoff
@
text
@@


1.4.1.0
log
@Branch for ten Kate
@
text
@d4 1
a4 1
 * $Id: lingual.c 1.4 1995/04/06 04:29:39 rowlands Exp $
d10 1
a10 4
 * $Log: lingual.c $
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
@


1.4.1.1
log
@Received from Warner ten Kate
@
text
@d4 1
a4 1
 * $Id: lingual.c,v 1.5 1995/08/14 08:03:03 tenkate Exp $
d10 1
a10 6
 * $Log: lingual.c,v $
 * Revision 1.5  1995/08/14  08:03:03  tenkate
 * ML-LSF added WtK 7/8/95
 * change alloc and sblimit into allocml and mlsblimit where appropriate
 * ml_sb_sample_swap() ml_sb_sample_shift() and pick_scale_ml_2() added.
 *
d61 1
a61 1
for(i = 0; i < samples_read; ++i) /* replace 5760 by 'samples_read' WtK 7/8/95 */
d104 1
a104 1
int  j, ch;
d107 3
a109 1
int  n_ml_ch = fr_ps->header->multiling_ch;
d111 3
d116 3
a118 2
	  for (ch=0;ch<n_ml_ch;ch++)
	    buffer_matr[7+ch][j] = buffer[7+ch][j] = insamp[(n_ml_ch*j)+ch]; /*WtK 7/8/95 */
d120 39
d178 4
d184 7
a190 5
   unsigned int i,j,k,s,x,y;
   int n_ml_ch       = fr_ps->header->multiling_ch;
   int lsf           = fr_ps->header->multiling_fs;
   int mlsblimit     = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;
d193 3
a195 3
for (j=0;j<((lsf==1)?6:12);j+=3)
for (i=0;i<mlsblimit;i++)
for (k = 7; k < 7+n_ml_ch; k++)
d197 1
d200 1
a200 1
		if ((*allocml)[i][bit_alloc[k][i]].group == 3) 
d204 1
a204 1
                                    (*allocml)[i][bit_alloc[k][i]].bits);
d208 1
a208 1
			y =(*allocml)[i][bit_alloc[k][i]].steps;
d212 1
a212 1
			putbits(bs,temp,(*allocml)[i][bit_alloc[k][i]].bits);
d220 3
d224 10
a233 7
   int i,k;
   int n_ml_ch       = fr_ps->header->multiling_ch;
   int mlsblimit     = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;
   
  for (i=0;i<mlsblimit;i++)
  {
d236 1
a236 1
		putbits(bs, bit_alloc[k][i], (*allocml)[i][0].bits);
d239 1
a239 1
  }	
a242 74
void ml_sb_sample_swap (int ch0, int ch1, double subsample[14][3][12][SBLIMIT])
/* Function is called if MultiLingual LSF applies.                   */
/* It organizes subband samples from 3 sub frames of 12 samples each */
/* into 6 sub frames of 6 samples each. Subframes 3, 4 and 5 are at  */
/* sample indices 6..11 in subframes 0,1,2 respectively.             */
/* WtK 7/8/95                                                        */
{
int    ch,sb,ss;
double hlp[6];

for (ch=ch0;ch<ch1;ch++)
  for (sb=0;sb<SBLIMIT;sb++)
    for (ss=0;ss<6;ss++) {
      hlp[ss]                    = subsample[ch][2][  ss][sb];
      subsample[ch][2][  ss][sb] = subsample[ch][1][  ss][sb];
      subsample[ch][1][  ss][sb] = subsample[ch][0][6+ss][sb];
      subsample[ch][0][6+ss][sb] = subsample[ch][1][6+ss][sb];
      subsample[ch][1][6+ss][sb] = hlp[ss];
    }
}

void ml_sb_sample_shift (int ch0, int ch1,double subsample[14][3][12][SBLIMIT])
/* In case of MultiLingual LSF this function is called.             */
/* It shifts the second part in the sub frames into the first part. */
/* The first part is shifted into the second part to be used by     */
/* pick_scale_ml_2()                                                */
/* WtK 7/8/95                                                       */
{
int    ch,sb,p,ss;
double hlp[6];

for (ch=ch0;ch<ch1;ch++)
  for (sb=0;sb<SBLIMIT;sb++)
    for (p=0;p<2;p++)
      for (ss=0;ss<6;ss++) {
        hlp[ss]                    = subsample[ch][p][  ss][sb];
	subsample[ch][p][ss][sb]   = subsample[ch][p][ss+6][sb];
	subsample[ch][p][ss+6][sb] = hlp[ss];
      }
}

void pick_scale_ml_2(frame_params *fr_ps, double subsample[14][3][12][SBLIMIT], double (*max_sc)[32])
/* pick largest max_sc of odd and even half of frame in case of LSF ML. */
/* This improves the psychoacoustic result:                             */
/* The masked threshold is calculated over 2 LSF frames; consequently,  */
/* the signal level should also be determined over those 2 frames in    */
/* order to obtain a fair estimate of the SMR.                          */
/* WtK , 7/8/95                                                         */
{
  int k,i,p,j;
  int maxi;
  double maxs,mods;
  int n_ml_ch   = fr_ps->header->multiling_ch;
  int mlsblimit = fr_ps->mlsblimit;
  int ml_fs     = fr_ps->header->multiling_fs;

 if ( (n_ml_ch>0) && (ml_fs==1) ) {
    for (k=7; k<7+n_ml_ch; k++) {
       for (i=0;i<mlsblimit;i++) {
	   maxs = subsample[k][0][0][i]; if (maxs<0) maxs = -maxs;
	   for (p=0;p<3;p++) for (j=6;j<12;j++) {
              mods = subsample[k][p][j][i]; if (mods<0) mods = -mods;
	      if (mods>maxs) maxs = mods;
	   }
           for (j=SCALE_RANGE-1,maxi=0;j>=0;j--)
	    if (maxs < multiple[j]) {
	      maxi = j;
	      break;
	   }
	   if (multiple[maxi]>max_sc[k][i]) max_sc[k][i] = multiple[maxi];
       }
    }
 }
}
@


1.3
log
@Hand-fixes after protoize
@
text
@d2 11
a12 3
Copyright (c) 1995 MPEG/audio software simulation group, All Rights Reserved
lingual.c
**********************************************************************/
@


1.2
log
@Processed with protoize
@
text
@d82 11
a92 2
unsigned long get_audio_ml(FILE *musicin_ml, long int (*buffer)[1152], long unsigned int num_samples, IFF_AIFF *aiff_ptr, frame_params *fr_ps, int *aiff, int *byte_per_sample, double (*buffer_matr)[1152])
{
@


1.1
log
@Initial revision
@
text
@d24 1
a24 7
unsigned long read_samples_ml(musicin, sample_buffer, num_samples, frame_size,
						 byte_per_sample, aiff)
FILE 		*musicin;
long 		sample_buffer[8064];
unsigned long 	num_samples, frame_size;
int 		*byte_per_sample;
int 		*aiff;
d82 1
a82 10
unsigned long get_audio_ml(musicin_ml, buffer, num_samples,
		aiff_ptr, fr_ps, aiff, byte_per_sample,buffer_matr)
FILE 		*musicin_ml;
long 		buffer[14][1152];
unsigned 	long num_samples;
IFF_AIFF 	*aiff_ptr;
frame_params 	*fr_ps;
int 		*aiff;
int 		*byte_per_sample;
double 		buffer_matr[14][1152];
d157 5
a161 5
void II_sample_encoding_ml(sbband, bit_alloc, fr_ps, bs)
unsigned int 	sbband[14][3][12][SBLIMIT];	/*24/02/1995 JMZ Multilingual */
unsigned int 	bit_alloc[14][SBLIMIT];		/*24/02/1995 JMZ Multilingual */
frame_params 	*fr_ps;
Bit_stream_struc *bs;
d199 4
a202 4
void II_encode_bit_alloc_ml(bit_alloc, fr_ps, bs)
unsigned int 	bit_alloc[14][SBLIMIT];		/*24/02/1995 JMZ Multilingual */
frame_params 	*fr_ps;
Bit_stream_struc *bs;
@
