head	1.10;
access;
symbols
	FTZ_05:1.9.1.1
	Distribution_06:1.9
	M_FTZ_04_Philips_01:1.8.3.2
	Philips_01:1.8.2.1
	FTZ_04:1.8.1.1
	D6Base:1.8
	Distribution_05:1.7.1.2
	FTZ_03:1.7.1.1
	Distribution_04:1.7
	Distribution_03:1.6
	FTZ_02:1.5.1.1
	Samsung_01:1.3.3.1
	IRT_01:1.3.2.1
	TI_01:1.3.1.4
	Distribution_01a:1.4
	Dist02_Sam_Merge:1.3.3.2
	Distribution_02:1.5
	IRT_TI_Merge:1.3.2.2
	Distribution_00:1.1
	Distribution_01:1.3;
locks; strict;
comment	@ * @;


1.10
date	96.02.12.07.13.06;	author rowlands;	state Exp;
branches;
next	1.9;

1.9
date	96.01.20.17.02.20;	author rowlands;	state Exp;
branches
	1.9.1.1;
next	1.8;

1.8
date	95.11.05.17.42.05;	author rowlands;	state Exp;
branches
	1.8.1.0
	1.8.2.0
	1.8.3.0;
next	1.7;

1.7
date	95.06.22.01.23.00;	author rowlands;	state Exp;
branches
	1.7.1.0;
next	1.6;

1.6
date	95.06.19.03.14.11;	author rowlands;	state Exp;
branches;
next	1.5;

1.5
date	95.06.16.08.49.22;	author rowlands;	state Exp;
branches
	1.5.1.0;
next	1.4;

1.4
date	95.06.16.06.19.08;	author rowlands;	state Exp;
branches;
next	1.3;

1.3
date	95.04.06.05.01.42;	author rowlands;	state Exp;
branches
	1.3.1.0
	1.3.2.0
	1.3.3.0;
next	1.2;

1.2
date	95.04.06.04.56.00;	author rowlands;	state Exp;
branches;
next	1.1;

1.1
date	95.04.06.04.33.53;	author rowlands;	state Exp;
branches;
next	;

1.3.1.0
date	95.05.23.02.34.26;	author rowlands;	state Exp;
branches;
next	1.3.1.1;

1.3.1.1
date	95.06.14.04.37.41;	author rowlands;	state Exp;
branches;
next	1.3.1.2;

1.3.1.2
date	95.06.15.18.20.12;	author rowlands;	state Exp;
branches;
next	1.3.1.3;

1.3.1.3
date	95.06.16.02.03.48;	author rowlands;	state Exp;
branches;
next	1.3.1.4;

1.3.1.4
date	95.06.16.03.11.37;	author rowlands;	state Exp;
branches;
next	;

1.3.2.0
date	95.06.16.03.22.45;	author rowlands;	state Exp;
branches;
next	1.3.2.1;

1.3.2.1
date	95.06.16.03.27.20;	author rowlands;	state Exp;
branches;
next	1.3.2.2;

1.3.2.2
date	95.06.16.06.10.31;	author rowlands;	state Exp;
branches;
next	;

1.3.3.0
date	95.06.16.07.55.13;	author rowlands;	state Exp;
branches;
next	1.3.3.1;

1.3.3.1
date	95.06.16.08.00.46;	author rowlands;	state Exp;
branches;
next	1.3.3.2;

1.3.3.2
date	95.06.16.08.42.59;	author rowlands;	state Exp;
branches;
next	;

1.5.1.0
date	95.06.17.21.22.47;	author rowlands;	state Exp;
branches;
next	1.5.1.1;

1.5.1.1
date	95.06.17.21.23.56;	author rowlands;	state Exp;
branches;
next	1.5.1.2;

1.5.1.2
date	95.06.17.21.27.02;	author rowlands;	state Exp;
branches;
next	1.5.1.3;

1.5.1.3
date	95.06.19.00.44.31;	author rowlands;	state Exp;
branches;
next	;

1.7.1.0
date	95.07.14.00.23.53;	author rowlands;	state Exp;
branches;
next	1.7.1.1;

1.7.1.1
date	95.07.14.06.12.46;	author rowlands;	state Exp;
branches;
next	1.7.1.2;

1.7.1.2
date	95.07.14.06.17.20;	author rowlands;	state Exp;
branches;
next	;

1.8.1.0
date	95.11.05.19.20.26;	author rowlands;	state Exp;
branches;
next	1.8.1.1;

1.8.1.1
date	95.11.05.19.24.24;	author rowlands;	state Exp;
branches;
next	;

1.8.2.0
date	95.11.05.19.26.28;	author rowlands;	state Exp;
branches;
next	1.8.2.1;

1.8.2.1
date	95.11.05.19.28.58;	author rowlands;	state Exp;
branches;
next	;

1.8.3.0
date	95.11.05.22.35.35;	author rowlands;	state Exp;
branches;
next	1.8.3.1;

1.8.3.1
date	95.11.05.22.50.42;	author rowlands;	state Exp;
branches;
next	1.8.3.2;

1.8.3.2
date	95.11.06.04.04.21;	author rowlands;	state Exp;
branches;
next	;

1.9.1.1
date	96.01.20.17.28.45;	author rowlands;	state Exp;
branches;
next	1.9.1.2;

1.9.1.2
date	96.01.20.20.11.31;	author rowlands;	state Exp;
branches;
next	1.9.1.3;

1.9.1.3
date	96.01.21.08.18.13;	author rowlands;	state Exp;
branches;
next	1.9.1.4;

1.9.1.4
date	96.01.29.03.36.47;	author rowlands;	state Exp;
branches;
next	;


desc
@MPEG-2 public C decoder
@


1.10
log
@Release following Munich meeting
@
text
@/**********************************************************************
 * ISO MPEG Audio Subgroup Software Simulation Group (1996)
 * ISO 13818-3 MPEG-2 Audio Multichannel Decoder
 *
 * $Id: decode.c 1.9.1.4 1996/01/29 03:36:47 rowlands Exp $
 *
 * $Log: decode.c $
 * Revision 1.9.1.4  1996/01/29  03:36:47  rowlands
 * Fixed problem with dynamic crosstalk in 2/2 configuration
 * Fixed bug in dynamic crosstalk for 3/1 configuration.
 *
 * Revision 1.9.1.1  1996/01/20  17:28:45  rowlands
 * Received from Ralf Schwalbe (Telekom FTZ) - includes prediction
 *
 * Revision 1.7.1.3  1995/08/14  08:12:10  tenkate
 * ML-LSF added Warner ten Kate 7/8/95 (Philips)
 * change "alloc" and "sblimit" into "allocml" and
 * "mlsblimit" where appropriate.
 *
 * Revision 1.7.1.1  1995/07/14  06:12:46  rowlands
 * Updated dynamic crosstalk from FTZ: revision FTZ_03
 *
 * Revision 1.3.3.1  1995/06/16  08:00:46  rowlands
 * Input from Sang Wook Kim (Samsung AIT)
 *
 * Revision 1.3.2.1  1995/06/16  03:27:20  rowlands
 * Corrected prediction select syntax according to IS
 * Added dematrixing procedure 2. Corrected dematrix weighting values.
 *
 **********************************************************************/

/**********************************************************************
 *   date   programmers                comment                        *
 * 2/25/91  Douglas Wong        start of version 1.0 records          *
 * 3/06/91  Douglas Wong        rename setup.h to dedef.h             *
 *                              removed extraneous variables          *
 *                              removed window_samples (now part of   *
 *                              filter_samples)                       *
 * 3/07/91  Davis Pan           changed output file to "codmusic"     *
 * 5/10/91  Vish (PRISM)        Ported to Macintosh and Unix.         *
 *                              Incorporated new "out_fifo()" which   *
 *                              writes out last incomplete buffer.    *
 *                              Incorporated all AIFF routines which  *
 *                              are also compatible with SUN.         *
 *                              Incorporated user interface for       *
 *                              specifying sound file names.          *
 *                              Also incorporated user interface for  *
 *                              writing AIFF compatible sound files.  *
 * 27jun91  dpwe (Aware)        Added musicout and &sample_frames as  *
 *                              args to out_fifo (were glob refs).    *
 *                              Used new 'frame_params' struct.       *
 *                              Clean,simplify, track clipped output  *
 *                              and total bits/frame received.        *
 * 7/10/91  Earle Jennings      changed to floats to FLOAT            *
 *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           *
 *          Don H. Lee,                                               *
 *          Peter W. Farrett                                          *
 *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   *
 *                              newly introduced functions are        *
 *                              buffer_CRC and recover_CRC_error      *
 *                              Additions and revisions are marked    *
 *                              with "dhl" for clarity                *
 * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   *
 *                              important fixes involved changing     *
 *                              16-bit ints to long or unsigned in    *
 *                              bit alloc routines for quant of 65535 *
 *                              and passing proper function args.     *
 *                              Removed "Other Joint Stereo" option   *
 *                              and made bitrate be total channel     *
 *                              bitrate, irrespective of the mode.    *
 *                              Fixed many small bugs & reorganized.  *
 **********************************************************************
 *                                                                    *
 *                                                                    *
 *  MPEG/audio Phase 2 coding/decoding multichannel                   *
 *                                                                    *
 *  Version 1.0                                                       *
 *                                                                    *
 *  7/27/93        Susanne Ritscher,  IRT Munich                      *
 *                                                                    *
 *                  thanks to                                         *
 *                  Ralf Schwalbe,    Telekom FTZ Berlin              *
 *                  Heiko Purnhagen,  Uni Hannover                    *
 *                                                                    *
 *  Version 2.0                                                       *
 *                                                                    *
 *  8/27/93        Susanne Ritscher, IRT Munich                       *
 *                 Channel-Switching is working                       *
 *                                                                    *
 *  Version 2.1                                                       *
 *                                                                    *
 *  9/1/93         Susanne Ritscher,  IRT Munich                      *
 *                 all channels normalized                            *
 *                                                                    *
 *  Version 3.0                                                       *
 *                                                                    *
 *  06/16/94       Ralf Schwalbe, Telekom FTZ Berlin                  *
 *                 all sources and variables adapted due to MPEG-2 -  *
 *                 DIS from March 1994                                *
 *                  - dematrix and denormalize procedure              *
 *                  - new tc - allocation (0-7)                       *
 *                  - some new structures and variables as a basis    *
 *                    for further decoding modes                      *
 **********************************************************************
 *								      *
 *  Version 1.0                                                       *
 *                                                                    *
 *  11/04/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                  - decoding tc-allocation                          *
 *                  - some new subroutines, globale variables and     *
 *                    structures (important to handle the ext. bitst.)*
 *                  - changed all functions to ANSI-C funktion header *
 *		    - corrected some bugs to decode bitstreams > 512kB*
 *								      *
 *  Version 1.1                                                       *
 *                                                                    *
 *  12/07/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                  - decoding extension bitstream                    *
 *                                                                    *
 *  Version 1.1.1                                                     *
 *                 Ralf Schwalbe, Telekom FTZ Berlin                  *
 *                  - fixed some bugs                                 *
 *                                                                    *
 *  Version 1.2                                                       *
 *                                                                    *
 *  6/21/95       Ralf Schwalbe, Deutsche Telekom FTZ Berlin          *
 *            	    - decoding dynamic crosstalk                      *
 *                  - decoding phantom center                         * 
 *                  - decoding MPEG1 compatible part only (stereo)    *
 *                  - corrected some settings and bugs                *
 *                                                                    * 
 *  7/12/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin          *
 *		    - corrected dynamic crosstalk 		      *
 *		    - 3/2,3/1,3/0,2/1, channel configurations         *
 *                    are working                                     *
 *		  						      *
 * 10/31/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin	      *
 *		    - decoding of LFE-channel is working  	      *
 *		    - corrected any settings and bugs		      *
 *		    - corrected table-switch for channel mode < 3/2   *
 *		      and tc-allocation / dyn-crosstalk		      *
 *		    - still a problem with compl. bitstream 18/19     *
 *								      *	
 * 01/12/96	  Ralf Schwalbe, Deutsche Telekom TZ Darmstadt	      *
 *		    - decoder prediction installed		      *
 *		    - problem with compl. bitstream 19 solved,        *
 *		    - still a problem with compl. bitstream 19        *
 *                                                                    *         
 **********************************************************************/

/**********************************************************************
 *                                                                    *
 *  06/06/95       Yeon Bae Thomas Kim,  Samsung AIT                  *
 *                 ancillary data is working                          *
 *								      *
 **********************************************************************/
 /*********************************************************************/

#include        "common.h"
#include        "decoder.h"

/***************************************************************
/*
/* This module contains the core of the decoder ie all the
/* computational routines. (Layer I and II only)
/* Functions are common to both layer unless
/* otherwise specified.
/*
/***************************************************************/

/*****************************************************************
/*
/* The following routines decode the system information
/*
/****************************************************************/

/************************* Layer II  ****************************/

void decode_info(Bit_stream_struc *bs,
		 frame_params *fr_ps)
{
   layer *hdr = fr_ps->header;

   hdr->version = get1bit(bs);
   hdr->lay = 4-getbits(bs,2);
   hdr->error_protection = !get1bit(bs); /* error protect. TRUE/FALSE */
   hdr->bitrate_index = getbits(bs,4);
   hdr->sampling_frequency = getbits(bs,2);
   hdr->padding = get1bit(bs);
   hdr->extension = get1bit(bs);
   hdr->mode = getbits(bs,2);
   hdr->mode_ext = getbits(bs,2);
   hdr->copyright = get1bit(bs);
   hdr->original = get1bit(bs);
   hdr->emphasis = getbits(bs,2);
}



/**********************************************************************/
/*																	  */
/*  7.7.93 Susanne Ritscher Systeminformation for multi-channel       */
/* 27.5.94 Ralf Schwalbe    Systeminformation and names due to		  */
/*					MPEG 2 DIS from March 1994  */					                        
/*								*/
/**********************************************************************/

void mc_header(Bit_stream_struc *bs,
	       frame_params *fr_ps)
{
   layer *hdr = fr_ps->header;
   hdr->ext_bit_stream_present = get1bit(bs);
   if( hdr->ext_bit_stream_present == 1)
   {		
	hdr->n_ad_bytes =  getbits(bs,8);
	hdr->ad_bytes_crc_info = hdr->n_ad_bytes;
   }
   hdr->center = getbits(bs, 2);
   hdr->surround = getbits(bs,2);
   hdr->lfe = get1bit(bs);
   hdr->audio_mix = get1bit(bs);     /* large or small room  R.S. */
   hdr->dematrix_procedure = getbits(bs,2);
   hdr->no_of_multi_lingual_ch = getbits(bs,3);
   hdr->multi_lingual_fs = get1bit(bs);
   hdr->multi_lingual_layer = get1bit(bs);
   hdr->copyright_ident_bit = get1bit(bs);
   hdr->copyright_ident_start = get1bit(bs);

   read_mpeg2_part = 1;
}

/* R.S. prediction table MPEG-2 IS November, 1995 */
int pred_coef_table[5][16] = {{6,4,4,4,2,2,2,0,4,4,4,2,2,2,2,0},
			      {4,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0},
			      {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
			      {4,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0},
			      {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}};


void mc_composite_status_info(Bit_stream_struc *bs,
			      frame_params *fr_ps)
{
   layer *hdr = fr_ps->header;
   int sbgr, j, pci;


   hdr->tc_sbgr_select = get1bit(bs);
   hdr->dyn_cross_on = get1bit(bs);
   hdr->mc_prediction_on = get1bit(bs);

   if(hdr->tc_sbgr_select == 1)
   {
	hdr->tc_allocation = getbits(bs,fr_ps->alloc_bits);
	/* tc_allocation is valid for all sbgr R.S. */
	for(sbgr = 0; sbgr < 12; sbgr++)   
		hdr->tc_alloc[sbgr] = hdr->tc_allocation;
   }
   else
   {
	hdr->tc_allocation = 0;
	for(sbgr = 0; sbgr < 12; sbgr++)
		hdr->tc_alloc[sbgr] = getbits(bs,fr_ps->alloc_bits);
   }

   if( hdr->dyn_cross_on == 1)
   {
		hdr->dyn_cross_LR = get1bit(bs);
		for(sbgr = 0; sbgr < 12; sbgr++)
			hdr->dyn_cross_mode[sbgr] = getbits(bs,fr_ps->dyn_cross_bits);
   }
   else
		for(sbgr = 0; sbgr < 12; sbgr++)
			hdr->dyn_cross_mode[sbgr] = 0;

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
if(hdr->mc_prediction_on)
   for(sbgr = 0; sbgr < 12; sbgr++)
	for(pci=0; pci < 4; pci++)
	   hdr->mc_predsi[sbgr][pci] = 0;

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

   if( hdr->mc_prediction_on == 1)
   {
	  for(sbgr = 0; sbgr < 8; sbgr++) 
	  {  
		if( (hdr->mc_prediction[sbgr] = get1bit(bs)) == 1 )
		{
/* R.S. read from npredcoef-table max number of coef. for 3/2 configuration */
/* and then the predsi info -> 0    : no prediction    */
/*			    -> 1..4 : 1..4 coefficient */
		    for(pci=0; pci< pred_coef_table[prog_mode][hdr->dyn_cross_mode[sbgr]] ; pci++)
			hdr->mc_predsi[sbgr][pci] = getbits(bs,2);
		}
	  }
   }
}


/* 15.6.1994 R.S. read header from extension bitstream */
int mc_ext_header(Bit_stream_struc *bs)
{
	int i;
	int bit_idx,byte_idx;

	if( read_ext_header == 0 )
	{
		read_ext_header = 1;
		info.ext_syncword = local_getbits(&bs_ext, 12);
		if( info.ext_syncword != EXT_SYNCWORD )
		{
			printf("\nWrong syncword in extern bitstream ! \n");
			ext_error=1;
			return(0);
		}
		else /* decoding extern bitstream */
		{
			info.ext_crc_check = local_getbits(&bs_ext, 16);
			info.ext_length = local_getbits(&bs_ext, 11);
			info.reserved_bit = local_get1bit(&bs_ext);

			bit_idx = bs_ext.buf_bit_idx;
			byte_idx = bs_ext.buf_byte_idx;
#ifdef EXTENSION_CRC_CHECK
			for( i = 0; i < 14; i++)
				info.ext_crc_bits[i] = look_ahead(&bs_ext, 8);
			info.ext_crc_bits[14] = look_ahead(&bs_ext, 4);
			bs_ext.buf_bit_idx = bit_idx;
			bs_ext.buf_byte_idx = byte_idx;		
			if( mc_ext_error_check() == 0 )
				return(0);   	     /* false  */
  			else    return(1);           /* true   */
#endif
		}
	}
	return(1);
}

/*******************************************************************
/*
/* The bit allocation information is decoded. Layer I
/* has 4 bit per subband whereas Layer II is Ws and bit rate
/* dependent.
/*
/********************************************************************/

/**************************** Layer II *************/

void II_decode_bitalloc(Bit_stream_struc *bs,
			unsigned int bit_alloc[5][SBLIMIT],	
			frame_params *fr_ps,
			int *l,
			int *m  /* l = 0 or 2 , m = 2 or <= 5 */)
{
   int i,j,c,sbgr;
   /* int stereo = fr_ps->stereo; */ /* not used for mc - decoding */
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;

   /* 10/31/95 Ralf Schwalbe LFE */
   if(info.lfe)
	info.lfe_alloc = (char) getbits(bs,(*alloc)[0][0].bits);

   for (i=0;i<jsbound;i++)
     if( info.dyn_cross_on == 0 || read_mpeg2_part == 0)
	for (j=*l;j<*m;j++)
	{
		 if((fr_ps->header->center != 3) || (i < 12) || (j !=2))
		 	bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);
		 else
			 bit_alloc[j][i] = 0;
	}
     else  /* dyn. cross mode */
     {
	if(i == 0) sbgr = 0;
	else
	   for(c = 1; c < 12; c++)
	   {
	      if((sb_groups[c-1] < i) && (i <= sb_groups[c]))
	      {
		sbgr = c;  /* search the valid subband group */
		break;
	       }
	    }
        /* 6/21/95 Ralf Schwalbe build in dyn. crosstalk mode */
	switch(info.dyn_cross_mode[sbgr])  
	{
	   case 0 :  for (j=*l;j<*m;j++)
		     {
			if((fr_ps->header->center != 3) || (i < 12) || (j !=2))
				bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);
			else
				bit_alloc[j][i] = 0;
		     }
		     break;

	   case 1 :    /* always 2 transmission channels */
	   case 2 :
	   case 3 :
	   case 8 :
	   case 9 :
	   case 10:  /* 19.10.95 R.S. switch to the right channel conf. table */
		     if(fr_ps->dyn_cross_bits != 4)
		     {
			if(fr_ps->dyn_cross_bits == 1)   /* for channel mode 3/0 and 2/1 */
			{
			    if(info.center == 1)    /* 3/0 */
			    {
			    if((info.tc_alloc[sbgr] == 1) || (info.tc_alloc[sbgr] == 7))
				bit_alloc[2][i] = bit_alloc[0][i];
			    if((info.tc_alloc[sbgr] == 2) || (info.tc_alloc[sbgr] == 6))
				bit_alloc[2][i] = bit_alloc[1][i];
			    else
				if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
				else	bit_alloc[2][i] = bit_alloc[0][i];
			    }
			    else   /* 2/1 */
			    {
				if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
				else	bit_alloc[2][i] = bit_alloc[0][i];
			    }
			}
			if(fr_ps->dyn_cross_bits == 3)   /* for channel mode 3/1 and 2/2 */
			{
			    if(info.dyn_cross_mode[sbgr] == 1)
			    	bit_alloc[2][i] = (char) getbits(bs,(*alloc)[i][0].bits);
			    else
			    { /* T2 not transmitted */
				if (
		/* 2/2 mode */		fr_ps->header->surround == 2 ||
		/* 3/1 mode */		fr_ps->header->tc_alloc[sbgr] == 1 ||
					fr_ps->header->tc_alloc[sbgr] != 2 && !fr_ps->header->dyn_cross_LR
				)
					bit_alloc[2][i] = bit_alloc[0][i];	/* C, L or Ls from L0 */
				else
					bit_alloc[2][i] = bit_alloc[1][i];	/* C, R or Rs from RO */
			    }

			    if(info.dyn_cross_mode[sbgr] == 2)
			    	bit_alloc[3][i] = (char) getbits(bs,(*alloc)[i][0].bits);
			    else
			    { /* T3 not transmitted */
				if (
		/* 2/2 mode */		fr_ps->header->surround == 2 ||
		/* 3/1 mode */		fr_ps->header->tc_alloc[sbgr] == 4 ||
					fr_ps->header->tc_alloc[sbgr] != 3 && fr_ps->header->dyn_cross_LR
				)
					bit_alloc[3][i] = bit_alloc[1][i];	/* S, R or Rs from R0 */
				else
					bit_alloc[3][i] = bit_alloc[0][i];	/* S, L or Ls from LO */
			    }
			} 
		     }
		     else
		     for (j = *l; j < *m ; j++)
		     {
			if((fr_ps->header->center != 3) || (i < 12) || (j !=2))
			    if( j < 4 )
				bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);
			    else
			    {
				if(info.dyn_cross_mode[sbgr] == 1)  bit_alloc[j][i] = bit_alloc[1][i];
				if(info.dyn_cross_mode[sbgr] == 8)  bit_alloc[j][i] = bit_alloc[3][i];
				if(info.dyn_cross_mode[sbgr] == 10) bit_alloc[j][i] = bit_alloc[2][i];
				if(info.dyn_cross_mode[sbgr] == 2)
				{ 
					bit_alloc[4][i] = bit_alloc[3][i];
					bit_alloc[3][i] = bit_alloc[0][i];
				}
				if(info.dyn_cross_mode[sbgr] == 9)
				{ 
					bit_alloc[4][i] = bit_alloc[3][i];
					bit_alloc[3][i] = bit_alloc[2][i];
				}
				if(info.dyn_cross_mode[sbgr] == 3)
				{
					bit_alloc[4][i] = bit_alloc[3][i];
					bit_alloc[3][i] = bit_alloc[2][i];
					if((info.tc_alloc[sbgr] == 1) || (info.tc_alloc[sbgr] == 7))
						bit_alloc[2][i] = bit_alloc[0][i];
					if((info.tc_alloc[sbgr] == 2) || (info.tc_alloc[sbgr] == 6))
						bit_alloc[2][i] = bit_alloc[1][i];
					else
						if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
				 		else		       bit_alloc[2][i] = bit_alloc[0][i];
				}
				/* easier to read the SCF/SCFSI */
			    }
			else
				bit_alloc[j][i] = 0;
		     }
		     break;

	   case 4 :    /* always 1 transmission channel */
	   case 5 :
	   case 6 :
	   case 11:
	   case 12:
	   case 13:
 	   case 14:  j = 2;  /* for phantom center R.S. */
		     if(fr_ps->dyn_cross_bits == 3)
		     {
			bit_alloc[2][i] = (char) getbits(bs,(*alloc)[i][0].bits);
			bit_alloc[3][i] = bit_alloc[2][i];
		     }
		     else
		     if((fr_ps->header->center != 3) || (i < 12) || (j !=2))
		     {
			    bit_alloc[2][i] = (char) getbits(bs,(*alloc)[i][0].bits);
			    if(info.dyn_cross_mode[sbgr] == 4)
			    {
				bit_alloc[3][i] = bit_alloc[0][i];
				bit_alloc[4][i] = bit_alloc[1][i];
			    }
			    if(info.dyn_cross_mode[sbgr] == 5)
			    {
				bit_alloc[3][i] = bit_alloc[2][i];
				if((info.tc_alloc[sbgr] == 1) || (info.tc_alloc[sbgr] == 7))
					bit_alloc[2][i] = bit_alloc[0][i];
				if((info.tc_alloc[sbgr] == 2) || (info.tc_alloc[sbgr] == 6))
					bit_alloc[2][i] = bit_alloc[1][i];
				else
					if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
					else		       bit_alloc[2][i] = bit_alloc[0][i];
				
				bit_alloc[4][i] = bit_alloc[1][i];
			    }
			    if(info.dyn_cross_mode[sbgr] == 6)
			    {
				bit_alloc[4][i] = bit_alloc[2][i];
				bit_alloc[3][i] = bit_alloc[2][i];
				if((info.tc_alloc[sbgr] == 1) || (info.tc_alloc[sbgr] == 7))
					bit_alloc[2][i] = bit_alloc[0][i];
				if((info.tc_alloc[sbgr] == 2) || (info.tc_alloc[sbgr] == 6))
					bit_alloc[2][i] = bit_alloc[1][i];
				else
					if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
					else		       bit_alloc[2][i] = bit_alloc[0][i];
				bit_alloc[3][i] = bit_alloc[0][i];
			    }
			    if(info.dyn_cross_mode[sbgr] == 11)
			    {
				bit_alloc[3][i] = bit_alloc[2][i];
				bit_alloc[4][i] = bit_alloc[1][i];
			    }
			    if(info.dyn_cross_mode[sbgr] == 12)
			    {
				bit_alloc[4][i] = bit_alloc[2][i];
				bit_alloc[3][i] = bit_alloc[0][i];
			    }
			    if(info.dyn_cross_mode[sbgr] == 13)
			    {
				bit_alloc[3][i] = bit_alloc[2][i];
				bit_alloc[4][i] = bit_alloc[2][i];
				if((info.tc_alloc[sbgr] == 1) || (info.tc_alloc[sbgr] == 7))
					bit_alloc[2][i] = bit_alloc[0][i];
				if((info.tc_alloc[sbgr] == 2) || (info.tc_alloc[sbgr] == 6))
					bit_alloc[2][i] = bit_alloc[1][i];
				else
					if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
					else		       bit_alloc[2][i] = bit_alloc[0][i];
			    }
			    if(info.dyn_cross_mode[sbgr] == 14)
			    {
				bit_alloc[3][i] = bit_alloc[2][i];
				bit_alloc[4][i] = bit_alloc[2][i];
			    }
			    break;
			    /* easier to read the SCF/SCFSI */
		     }
		     else
		     {
			bit_alloc[2][i] = 0;
			bit_alloc[3][i] = 0;
			bit_alloc[4][i] = 0;
		     } 
		      break;

	   case 7 :  /* no transmission channel */
			bit_alloc[3][i] = bit_alloc[0][i];
			bit_alloc[4][i] = bit_alloc[1][i];
			if((info.tc_alloc[sbgr] == 1) || (info.tc_alloc[sbgr] == 7))
				bit_alloc[2][i] = bit_alloc[0][i];
			if((info.tc_alloc[sbgr] == 2) || (info.tc_alloc[sbgr] == 6))
				bit_alloc[2][i] = bit_alloc[1][i];
			else
				if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
				else		       bit_alloc[2][i] = bit_alloc[0][i];
			break;
	}
     }
   for (i=jsbound;i<sblimit;i++)   /* expand to 2 channels */
	  bit_alloc[0][i] = bit_alloc[1][i] = (char) getbits(bs,(*alloc)[i][0].bits);

   for (i=sblimit;i<SBLIMIT;i++) for (j=*l;j<*m;j++)
	  bit_alloc[j][i] = 0;
}

void II_decode_bitalloc_ml(Bit_stream_struc *bs,
			   unsigned int bit_alloc_ml[5][SBLIMIT],	
			   frame_params *fr_ps,
			   int *m)
{
   int i,j;
   int mlsblimit = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;

   /* JR: no dynamic crosstalk for multilingual channels */
   /* JR: no phantom center coding for multilingual channels */
   /* JR: no joint coding for multilingual channels */
   /* JR: they're really simple, aren't they? */

   for (i=0;i<mlsblimit;i++)
    for (j=0;j<*m;j++) 
     bit_alloc_ml[j][i] = (char) getbits(bs,(*allocml)[i][0].bits);
   for (i=mlsblimit;i<SBLIMIT;i++) 
    for (j=0;j<*m;j++) 
     bit_alloc_ml[j][i] = 0;
}

/*****************************************************************
/*
/* The following two functions implement the layer II
/* format of scale factor extraction. Layer I involves reading
/* 6 bit per subband as scale factor. Layer II requires reading
/* first the scfsi which in turn indicate the number of scale factors
/* transmitted.
/*   Layer II : II_decode_scale
/*
/*************************** Layer II stuff ***************************/
/* 28.9.93 R.S. reading of the prediction coefficients */
/* 03.6.94 R.S. read pred-coef. due to MPEG 2 - DIS    */
/**********************************************************************/
/* JMZ 09/03/1995 Multilingual adaptations , WtK 7/8/95               */
/**********************************************************************/

void II_decode_scale(Bit_stream_struc *bs,
		     unsigned int scfsi[5][SBLIMIT], 		
		     unsigned int bit_alloc[5][SBLIMIT],	
		     unsigned int scale_index[5][3][SBLIMIT],	
		     frame_params *fr_ps,
		     int *l, 
		     int *m)
{
   int i,j;
   int px,pci;
   /* int stereo  = fr_ps->stereo; */ /* not used for mc - decoding */
   int sblimit = fr_ps->sblimit;

   for (i=0;i<sblimit;i++) 
   {
	for (j=*l;j<*m;j++)   /* 2 bit scfsi */
   	{
		if (bit_alloc[j][i]) 
		{
	  		scfsi[j][i] = (char) getbits(bs,2);
	  	}
		else scfsi[j][i] = 4;
	 }
    }
    for (i=sblimit;i<SBLIMIT;i++) 
    {
	 for (j=*l;j<*m;j++)
		scfsi[j][i] = 4;
    }
    /* 31/10/95 Ralf Schwalbe LFE */
    if(info.lfe)
      if(info.lfe_alloc)
	info.lfe_scf = getbits(bs,6);

   /* 3.6.94 R.S. read the prediction coefficients in the mc - part */
   if(*m > 2)
	if (fr_ps->header->mc_prediction_on == 1)
	{
	  for(i = 0; i < 8; i++)
	  {
		 if(fr_ps->header->mc_prediction[i] == 1)
		 {
			for(px = 0; px < pred_coef_table[prog_mode][fr_ps->header->dyn_cross_mode[i]]; px++)
				if(fr_ps->header->mc_predsi[i][px] != 0) /*predictors are transfered*/
				{
				  fr_ps->header->mc_delay_comp[i][px] = getbits(bs,3);
				  for(pci = 0; pci < fr_ps->header->mc_predsi[i][px]; pci++)
					  fr_ps->header->mc_pred_coeff[i][px][pci] = getbits(bs,8);
				}
				else /* no prediction coef. */
				{
					fr_ps->header->mc_pred_coeff[i][px][0] = 127;     /* Index 127 -> 0.0 */
					fr_ps->header->mc_delay_comp[i][px] = 0;
				}
		 }
	  }
   }
	     
   for (i = 0; i < sblimit; i++) 
   {
      for (j = *l; j < *m; j++) {
	  if (bit_alloc[j][i])
	      switch (scfsi[j][i]) {
			/* all three scale factors transmitted */
			case 0 : scale_index[j][0][i] = getbits(bs,6);
			         scale_index[j][1][i] = getbits(bs,6);
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
			/* scale factor 1 & 3 transmitted */
			case 1 : scale_index[j][0][i] =
				 scale_index[j][1][i] = getbits(bs,6);
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
			/* scale factor 1 & 2 transmitted */
			case 3 : scale_index[j][0][i] = getbits(bs,6);
				 scale_index[j][1][i] =
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
			/* only one scale factor transmitted */
			case 2 : scale_index[j][0][i] =
				 scale_index[j][1][i] =
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
			default : scale_index[j][0][i] =
				  scale_index[j][1][i] =
				  scale_index[j][2][i] = SCALE_RANGE-1;
				  break;
	      }
	  else {
		scale_index[j][0][i] = scale_index[j][1][i] =
		scale_index[j][2][i] = SCALE_RANGE-1;
	  }
      }
   }

   for (i=sblimit;i<SBLIMIT;i++)
   { 
	for (j=*l;j<*m;j++) {
		 scale_index[j][0][i] = scale_index[j][1][i] =
		 scale_index[j][2][i] = SCALE_RANGE-1;
	}
   }
}

/**********************************************************************/
/* JMZ 15/03/1995 Multilingual                                        */
/**********************************************************************/

void II_decode_scale_ml(Bit_stream_struc *bs,
		        unsigned int scfsi[5][SBLIMIT], 		
		        unsigned int bit_alloc[5][SBLIMIT],	
		        unsigned int scale_index[5][3][SBLIMIT],	
		        frame_params *fr_ps,
		        int *m)
{
   int i,j;
   int px,pci;
   int mlsblimit = fr_ps->mlsblimit;


   for (i=0;i<mlsblimit;i++) for (j=0;j<*m;j++)   /* 2 bit scfsi */
	if (bit_alloc[j][i]) 
		{
	  	scfsi[j][i] = (char) getbits(bs,2);
	  	}
	else scfsi[j][i] = 4;
   for (i=mlsblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++)
	scfsi[j][i] = 4;

   for (i = 0; i < mlsblimit; i++) for (j = 0; j < *m; j++) {
	  if (bit_alloc[j][i])
	    switch (scfsi[j][i]) {
		 /* all three scale factors transmitted */
		 case 0 : scale_index[j][0][i] = getbits(bs,6);
			  scale_index[j][1][i] = getbits(bs,6);
			  scale_index[j][2][i] = getbits(bs,6);
			  break;
		 /* scale factor 1 & 3 transmitted */
		 case 1 : scale_index[j][0][i] =
			  scale_index[j][1][i] = getbits(bs,6);
			  scale_index[j][2][i] = getbits(bs,6);
			  break;
	         /* scale factor 1 & 2 transmitted */
		 case 3 : scale_index[j][0][i] = getbits(bs,6);
			  scale_index[j][1][i] =
			  scale_index[j][2][i] = getbits(bs,6);
         		  break;
		 /* only one scale factor transmitted */
	         case 2 : scale_index[j][0][i] =
		          scale_index[j][1][i] =
		          scale_index[j][2][i] = getbits(bs,6);
         		  break;
		 default : scale_index[j][0][i] =
		           scale_index[j][1][i] =
		           scale_index[j][2][i] = SCALE_RANGE-1;
         		   break;
          }
          else {
                          scale_index[j][0][i] = scale_index[j][1][i] =
	                  scale_index[j][2][i] = SCALE_RANGE-1;
	  }
   }

   for (i=mlsblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++) {
		          scale_index[j][0][i] = scale_index[j][1][i] =
		          scale_index[j][2][i] = SCALE_RANGE-1;
   }
}

/**************************************************************
/*
/* The following two routines take care of reading the
/* compressed sample from the bit stream for layer 2.
/* For layer 1, read the number of bits as indicated
/* by the bit_alloc information. For layer 2, if grouping is
/* indicated for a particular subband, then the sample size has
/* to be read from the bits_group and the merged samples has
/* to be decompose into the three distinct samples. Otherwise,
/* it is the same for as layer one.
/*
/*************************** Layer II stuff ************************/

void II_buffer_sample(Bit_stream_struc *bs,
		      unsigned int sample[5][3][SBLIMIT],
		      unsigned int bit_alloc[5][SBLIMIT],
		      frame_params *fr_ps)
{
   int i,j,k,m;
   int stereo = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;

   for (i=0;i<sblimit;i++) for (j= 0;j<((i<jsbound)? stereo:1);j++) {
	   if (bit_alloc[j][i])
	   {
		 /* check for grouping in subband */
		 if ((*alloc)[i][bit_alloc[j][i]].group==3)
	 	 {
			for (m=0;m<3;m++)
			{
			  k = (*alloc)[i][bit_alloc[j][i]].bits;
			  sample[j][m][i] = (unsigned int) getbits(bs,k);
			 }
		 }
		 else
		 {    /* bit_alloc = 3, 5, 9 */
		   unsigned int nlevels, c=0;

		   nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
		   k=(*alloc)[i][bit_alloc[j][i]].bits;
		   c = (unsigned int) getbits(bs, k);

		   for (k=0;k<3;k++)
		   {
			 sample[j][k][i] = c % nlevels;
			 c /= nlevels;
		   }
		 }
	   }
	   else
	   {      /* for no sample transmitted */
		 for (k=0;k<3;k++) sample[j][k][i] = 0;
	   }
	   if(stereo == 2 && i>= jsbound)  /* joint stereo : copy L to R */
		  for (k=0;k<3;k++) sample[1][k][i] = sample[0][k][i];
   }
   for (i = sblimit; i < SBLIMIT; i++)
	 for (j = 0; j < stereo; j++)
		for (k = 0; k < 3; k++)
		   sample[j][k][i] = 0;
}

/******************** mc - layer2 stuff ******************************/
/* 19.10.93 R.S. */

void II_buffer_samplemc(Bit_stream_struc *bs,
			unsigned int sample[5][3][SBLIMIT],
			unsigned int bit_alloc[5][SBLIMIT],
			frame_params *fr_ps,
			int gr)
{
   int i,j,k,m,sbgr,l;
   unsigned int nlevels, c=0;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   /* 31/10/95 Ralf Schwalbe LFE */
   if(info.lfe)
	info.lfe_spl[gr] = (unsigned int) getbits(bs,(*alloc)[0][info.lfe_alloc].bits);

   for (i = 0; i < sblimit; i++)
   {
	  if( i == 0) sbgr = 0 ;
	  else
	     for(l = 1; l < 12; l++)
		if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
		{
		   sbgr = l; break;
		}

	 for (j = 2; j < channels; j++)
	 {
	   if (bit_alloc[j][i])
	   {
		 if(fr_ps->header->dyn_cross_on == 0)
		 {
			/* check for grouping in subband */
			if ((*alloc)[i][bit_alloc[j][i]].group==3)
			{
				for (m=0;m<3;m++)
				{
					k = (*alloc)[i][bit_alloc[j][i]].bits;
					sample[j][m][i] = (unsigned int) getbits(bs,k);
				}
			}
			else
			{    /* bit_alloc = 3, 5, 9 */
			  nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
			  k=(*alloc)[i][bit_alloc[j][i]].bits;
			  c = (unsigned int) getbits(bs, k);
			  for (k=0;k<3;k++)
			  {
				sample[j][k][i] = c % nlevels;
				c /= nlevels;
			  }
			}
		 }
		 else       /* 15.02.1995 Ralf Schwalbe dyn-cross mode on */
		 {
		   if(	/* test if this channel is transmitted in this dyn_cross_mode */
			(fr_ps->header->dyn_cross_mode[sbgr]==0) ||
			fr_ps->dyn_cross_bits == 4 && (
				(fr_ps->header->dyn_cross_mode[sbgr]==1  && j!=4) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==2  && j!=3) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==3  && j!=2) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==4  && j==2) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==5  && j==3) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==6  && j==4) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==8  && j!=4) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==9  && j!=3) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==10 && j!=4) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==11 && j==2) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==12 && j==2) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==13 && j==3) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==14 && j==2)
			) ||
			fr_ps->dyn_cross_bits == 3 && (
				(fr_ps->header->dyn_cross_mode[sbgr]==1  && j==2) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==2  && j==3) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==4  && j==2)
			)
		   )
		   {
		  	if ((*alloc)[i][bit_alloc[j][i]].group==3)
			{
				for (m=0;m<3;m++)
				{
				    k = (*alloc)[i][bit_alloc[j][i]].bits;
				    sample[j][m][i] = (unsigned int) getbits(bs,k);
				}
			 }
			 else
			 {    /* bit_alloc = 3, 5, 9 */
			 	nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
				k=(*alloc)[i][bit_alloc[j][i]].bits;
				c = (unsigned int) getbits(bs, k);
				for (k=0;k<3;k++)
				{
					sample[j][k][i] = c % nlevels;
					c /= nlevels;
				}
			  }
		   }
		 }    /* end if dyn-cross on */
	   } 
	   else   /* if bit_alloc = 0 -> no sample transmitted */
	   	 for (k=0;k<3;k++) sample[j][k][i] = 0;
	 }  /* for channel loop */
   }  /* for sblimit loop */

   for (i = sblimit; i < SBLIMIT; i++)
	 for (j = 2; j < channels; j++)
		for (k = 0; k < 3; k++)  sample[j][k][i] = 0;
}

/***************************************************************/
/* 09/03/1995 JMZ Multilingual */

/***************************************************************/
/* 15/03/1995 JMZ */

void II_buffer_sample_ml(Bit_stream_struc *bs,
			 unsigned int sample_ml[5][3][SBLIMIT],
			 unsigned int bit_alloc_ml[5][SBLIMIT],
			 frame_params *fr_ps,
			 int *n_ml_ch)
{
   int i,j,k,m,sbgr,l;
   unsigned int nlevels, c=0;
   int mlsblimit = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;

   for (i = 0; i < mlsblimit; i++)
   {
	 for (j = 0; j < *n_ml_ch; j++)
	 {
	   if (bit_alloc_ml[j][i])
	   {
		/* JR: no dynamic crosstalk for multilingual channels */
		/* check for grouping in subband */
		if ((*allocml)[i][bit_alloc_ml[j][i]].group==3)
		{

			for (m=0;m<3;m++)
			{
				k = (*allocml)[i][bit_alloc_ml[j][i]].bits;
				sample_ml[j][m][i] = (unsigned int) getbits(bs,k);
			}

		}
		else
		{    /* bit_alloc = 3, 5, 9 */
		  nlevels = (*allocml)[i][bit_alloc_ml[j][i]].steps;
		  k=(*allocml)[i][bit_alloc_ml[j][i]].bits;
		  c = (unsigned int) getbits(bs, k);

		  for (k=0;k<3;k++)
		  {
			sample_ml[j][k][i] = c % nlevels;
			c /= nlevels;
		  }
		}
	   }
	   else
	   {      /* for no sample transmitted */
		 for (k=0;k<3;k++) sample_ml[j][k][i] = 0;
	   }
	 }
   }

   for (i = mlsblimit; i < SBLIMIT; i++)
	 for (j = 0; j < *n_ml_ch; j++)
		for (k = 0; k < 3; k++)
		   sample_ml[j][k][i] = 0;
}

/**************************************************************
/*
/*   Restore the compressed sample to a factional number.
/*   first complement the MSB of the sample
/*    for layer I :
/*    Use s = (s' + 2^(-nb+1) ) * 2^nb / (2^nb-1)
/*   for Layer II :
/*   Use the formula s = s' * c + d
/*
/**************************************************************/

static double c[17] = { 1.33333333333, 1.60000000000, 1.14285714286,
						1.77777777777, 1.06666666666, 1.03225806452,
						1.01587301587, 1.00787401575, 1.00392156863,
						1.00195694716, 1.00097751711, 1.00048851979,
						1.00024420024, 1.00012208522, 1.00006103888,
						1.00003051851, 1.00001525902 };

static double d[17] = { 0.500000000, 0.500000000, 0.250000000, 0.500000000,
						0.125000000, 0.062500000, 0.031250000, 0.015625000,
						0.007812500, 0.003906250, 0.001953125, 0.0009765625,
						0.00048828125, 0.00024414063, 0.00012207031,
						0.00006103516, 0.00003051758 };

/************************** Layer II stuff ************************/

void II_dequantize_sample(unsigned int sample[5][3][SBLIMIT],
			  unsigned int bit_alloc[5][SBLIMIT],
			  double fraction[5][SBLIMIT][3][12],
			  frame_params *fr_ps,
			  int *z)
{
   int i, j, k, x;
   int stereo = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   for (i=0;i<sblimit;i++)  for (j=0;j<3;j++) for (k = 0; k < stereo ; k++)
	 if (bit_alloc[k][i])
	 {
	   /* locate MSB in the sample */
	   x = 0;
#ifndef MSDOS
	   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
#else
	   /* microsoft C thinks an int is a short */
	   while (( (unsigned long) (1L<<(long)x) <
				(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)
			  ) && ( x < 16) ) x++;
#endif

	   /* MSB inversion */
	   if (((sample[k][j][i] >> (x-1)) & 1) == 1)
		  fraction[k][i][j][*z] = 0.0;
	   else  fraction[k][i][j][*z] = -1.0;

	   /* Form a 2's complement sample */
	   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
							(double) (1L<<(x-1));

	   /* Dequantize the sample */
	   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
	   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
	 }
	 else fraction[k][i][j][*z] = 0.0;

   for (i=sblimit;i<SBLIMIT;i++)
	  for (j=0;j<3;j++)
		 for(k = 0; k < stereo; k++)
			 fraction[k][i][j][*z] = 0.0;
}


/************************** MC Layer II stuff ************************/

void II_dequantize_samplemc(unsigned int sample[5][3][SBLIMIT],
			    unsigned int bit_alloc[5][SBLIMIT],
			    double fraction[5][SBLIMIT][3][12],
			    frame_params *fr_ps,
			    int *z)
{
   int i, j, k, x,sbgr,l;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   for (i = 0; i < sblimit; i++)
   {
	if( i == 0) sbgr = 0 ;
	else
	   for(l = 1; l < 12; l++)
		if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
		{
		    sbgr = l; break;
		}
	for (j = 0; j < 3; j++)
	   for ( k = 2; k < channels; k++)
		if (bit_alloc[k][i])
		{
		  if (fr_ps->header->dyn_cross_on == 0)
		  {
		  /* locate MSB in the sample */
		   x = 0;
#ifndef MSDOS
		   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
#else
		   /* microsoft C thinks an int is a short */
		   while (( (unsigned long) (1L<<(long)x) <
			(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)) && ( x < 16) ) x++;
#endif
		   /* MSB inversion */
		   if (((sample[k][j][i] >> (x-1)) & 1) == 1)
			 fraction[k][i][j][*z] = 0.0;
		   else  fraction[k][i][j][*z] = -1.0;

		   /* Form a 2's complement sample */
		   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
						(double) (1L<<(x-1));

		   /* Dequantize the sample */
		   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
		   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
		  }
		  else   /* 21.07.94 Ralf Schwalbe dyn. cross mode */
		  {
		   if(((fr_ps->header->dyn_cross_mode[sbgr]==0) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==1  && k!=4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==2  && k!=3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==3  && k!=2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==8  && k!=4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==9  && k!=3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==10 && k!=4)) &&
			fr_ps->dyn_cross_bits == 4 )
		   {
			x = 0;
#ifndef MSDOS
			while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
#else
			/* microsoft C thinks an int is a short */
			while (( (unsigned long) (1L<<(long)x) <
			(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)) && ( x < 16) ) x++;
#endif
			/* MSB inversion */
			if (((sample[k][j][i] >> (x-1)) & 1) == 1)
			      fraction[k][i][j][*z] = 0.0;
			else  fraction[k][i][j][*z] = -1.0;

			/* Form a 2's complement sample */
			fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
						(double) (1L<<(x-1));

			/* Dequantize the sample */
			fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
			fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
		   }  /* end if 2-channel dyn-cross mode */

		   if(((fr_ps->header->dyn_cross_mode[sbgr]==4  && k==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==5  && k==3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==6  && k==4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==11 && k==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==12 && k==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==13 && k==3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==14 && k==2)) ||
			fr_ps->dyn_cross_bits != 4) 
		   {
			if((fr_ps->dyn_cross_bits == 3 && fr_ps->header->dyn_cross_mode[sbgr] == 3) ||
			   (fr_ps->dyn_cross_bits == 1 && fr_ps->header->dyn_cross_mode[sbgr] == 1))
			{
				/* no samples to dequantize */
			}
			else
			{
			x = 0;
#ifndef MSDOS
			while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
#else
			/* microsoft C thinks an int is a short */
			while (( (unsigned long) (1L<<(long)x) <
			(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)) && ( x < 16) ) x++;
#endif
			/* MSB inversion */
			if (((sample[k][j][i] >> (x-1)) & 1) == 1)
			      fraction[k][i][j][*z] = 0.0;
			else  fraction[k][i][j][*z] = -1.0;

			/* Form a 2's complement sample */
			fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
						(double) (1L<<(x-1));

			/* Dequantize the sample */
			fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
			fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
			} /* end if ..bits */
		   }   /* end if 1-channel dyn-cross mode */
		  } /* end if dyn-cross on */
		} /* if bit_alloc */
	  	else fraction[k][i][j][*z] = 0.0;
   }
   for (i = sblimit; i < SBLIMIT; i++)
	  for (j = 0; j < 3; j++)
		 for(k = 2; k < channels; k++)
			 fraction[k][i][j][*z] = 0.0;
}

/*************************************************************************/
/* JMZ 09/03/1995 Multilingual */

void II_dequantize_sample_ml(unsigned int sample_ml[5][3][SBLIMIT],
			     unsigned int bit_alloc_ml[5][SBLIMIT],
			     double fraction_ml[5][SBLIMIT][3][12],
			     frame_params *fr_ps,
			     int *n_ml_ch,
			     int *z)
{
   int i, j, k, x,sbgr,l;
   int mlsblimit = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;

   for (i = 0; i < mlsblimit; i++)
   {
	  for (j = 0; j < 3; j++)
		 for ( k = 0; k < *n_ml_ch; k++)
			if (bit_alloc_ml[k][i])
			{
			  /* JR: ditto */
			  /* locate MSB in the sample */
			   x = 0;
#ifndef MSDOS
			   while ((1L<<x) < (*allocml)[i][bit_alloc_ml[k][i]].steps) x++;
#else
			   /* microsoft C thinks an int is a short */
			   while (( (unsigned long) (1L<<(long)x) <
				(unsigned long)( (*allocml)[i][bit_alloc_ml[k][i]].steps)
			   ) && ( x < 16) ) x++;
#endif
			   /* MSB inversion */
			   if (((sample_ml[k][j][i] >> (x-1)) & 1) == 1)
					fraction_ml[k][i][j][*z] = 0.0;
			   else  fraction_ml[k][i][j][*z] = -1.0;

			   /* Form a 2's complement sample */
			   fraction_ml[k][i][j][*z] += (double) (sample_ml[k][j][i] & ((1<<(x-1))-1)) /
							(double) (1L<<(x-1));

			   /* Dequantize the sample */
			   fraction_ml[k][i][j][*z] += d[(*allocml)[i][bit_alloc_ml[k][i]].quant];
			   fraction_ml[k][i][j][*z] *= c[(*allocml)[i][bit_alloc_ml[k][i]].quant];
			} /* if bit_alloc */
			else fraction_ml[k][i][j][*z] = 0.0;
   }
   for (i = mlsblimit; i < SBLIMIT; i++)
	  for (j = 0; j < 3; j++)
		 for(k = 0; k < *n_ml_ch; k++)
			 fraction_ml[k][i][j][*z] = 0.0;
}

/**************************************************************************
II_lfe_calc();  R.Schwalbe 
**************************************************************************/
void II_lfe_calc(frame_params *fr_ps)
{
   int x,i;
   al_table *alloc = fr_ps->alloc;

   for(i = 0; i < 12; i++)
   {
	x = 0;
#ifndef MSDOS
   	while ((1L<<x) < (*alloc)[0][info.lfe_alloc].steps) x++;
#else
   	/* microsoft C thinks an int is a short */
   	while (( (unsigned long) (1L<<(long)x) <
   	(unsigned long)( (*alloc)[0][info.lfe_alloc].steps)) && ( x < 16) ) x++;
#endif
   	/* MSB inversion */
   	if (((info.lfe_spl[i] >> (x-1)) & 1) == 1)
     		info.lfe_spl_fraction[i] = 0.0;
   	else 	info.lfe_spl_fraction[i] = -1.0;

   	/* Form a 2's complement sample */
   	info.lfe_spl_fraction[i] += (double) (info.lfe_spl[i] & ((1<<(x-1))-1)) /
	 			(double) (1L<<(x-1));

   	/* Dequantize the sample */
   	info.lfe_spl_fraction[i] += d[(*alloc)[0][info.lfe_alloc].quant];
   	info.lfe_spl_fraction[i] *= c[(*alloc)[0][info.lfe_alloc].quant];

   	/* Denormalize the sample */
   	info.lfe_spl_fraction[i] *= multiple[info.lfe_scf];
    }
}

/************************************************************
/*
/*   Restore the original value of the sample ie multiply
/*    the fraction value by its scalefactor.
/*
/************************* Layer II Stuff **********************/

void II_denormalize_sample(double fraction[5][SBLIMIT][3][12],
			   unsigned int scale_index[5][3][SBLIMIT],
			   frame_params *fr_ps,
			   int x,
			   int *z)
{
   int i,j,k;
   int stereo = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;

   for (i=0;i<sblimit;i++)
	for (j = 0;j < stereo; j++)
	{
	  fraction[j][i][0][*z] *= multiple[scale_index[j][x][i]];
	  fraction[j][i][1][*z] *= multiple[scale_index[j][x][i]];
	  fraction[j][i][2][*z] *= multiple[scale_index[j][x][i]];
	}
}

/************************* MC Layer II Stuff **********************/

void II_denormalize_samplemc(double fraction[5][SBLIMIT][3][12],
			     unsigned int scale_index[5][3][SBLIMIT],
			     frame_params *fr_ps,
			     int x,
			     int *z)
{
   int i,j,k,sbgr,l,bl=0;
   int sblimit = fr_ps->sblimit;

   for (i = 0; i < sblimit; i++)
   {
	if( i == 0) sbgr = 0 ;
	else
	        for(l = 1; l < 12; l++)
		     if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
		     {
			sbgr = l; break;
		     }
	if(fr_ps->header->dyn_cross_on == 0)
		for (j = 2; j < channels; j++)
		{
			fraction[j][i][0][*z] *= multiple[scale_index[j][x][i]];
			fraction[j][i][1][*z] *= multiple[scale_index[j][x][i]];
			fraction[j][i][2][*z] *= multiple[scale_index[j][x][i]];
		}
	else
		switch(fr_ps->header->dyn_cross_mode[sbgr])
		{
		  case 0 : 	for (j = 2; j < channels; j++)
				{
				fraction[j][i][0][*z] *= multiple[scale_index[j][x][i]];
				fraction[j][i][1][*z] *= multiple[scale_index[j][x][i]];
				fraction[j][i][2][*z] *= multiple[scale_index[j][x][i]];
				}
			  	break;

		  case 1 :      /* t2 = c, t3 = ls, t4 from t1(R0) */
				for(bl = 0; bl < 3; bl++)
				{
					         /* C from T2 */
				    if(fr_ps->dyn_cross_bits == 4)
				    {
					fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								   * multiple[scale_index[4][x][i]];
				    }
				    else
				    {
					if(fr_ps->dyn_cross_bits == 3)
					{
					  fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
					    if (
			/* 2/2 mode */		fr_ps->header->surround == 2 ||
			/* 3/1 mode */		fr_ps->header->tc_alloc[sbgr] == 4 ||
						fr_ps->header->tc_alloc[sbgr] != 3 && fr_ps->header->dyn_cross_LR
					    ) /* S, R or Rs from R0 */
						fraction[3][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								   	   * multiple[scale_index[3][x][i]];
					    else     /* S, L or Ls from L0 */
						fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								   	   * multiple[scale_index[3][x][i]];
					}
					else
					{
					    if(fr_ps->dyn_cross_bits == 1)
					    {		
						if(fr_ps->header->tc_alloc[sbgr] == 0)
							if(fr_ps->header->dyn_cross_LR)  /* S from R0 */ 
								fraction[2][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								 		  	   * multiple[scale_index[2][x][i]];
					    	else     /* S from L0 */
							fraction[2][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
										   	   * multiple[scale_index[2][x][i]];
						if(fr_ps->header->tc_alloc[sbgr] == 1)
							fraction[2][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
										   * multiple[scale_index[2][x][i]];
						if(fr_ps->header->tc_alloc[sbgr] == 2)
							fraction[2][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
										   * multiple[scale_index[2][x][i]];
					    }
					}
				    }
				}
				break;

		  case 2 :	/* t2 = C, t3 from t0(LO), t4 = Rs */
				for(bl = 0; bl < 3; bl++)
				{
						  /* C from T2 */
				    if(fr_ps->dyn_cross_bits == 4)
				    {
					fraction[2][i][bl][*z] = fraction[2][i][bl][*z] * multiple[scale_index[2][x][i]];
					fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								   * multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];
				    }	
				    if(fr_ps->dyn_cross_bits == 3)
				    {   /* R.S. die Samples sind in diesem Fall noch nicht umsortiert */
					fraction[3][i][bl][*z] = fraction[3][i][bl][*z] * multiple[scale_index[3][x][i]];
					if (
			/* 2/2 mode */		fr_ps->header->surround == 2 ||
			/* 3/1 mode */		fr_ps->header->tc_alloc[sbgr] == 1 ||
						fr_ps->header->tc_alloc[sbgr] != 2 && !fr_ps->header->dyn_cross_LR
					) /* C, L or Ls from L0 */
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
							  * multiple[scale_index[2][x][i]];
					else	/* C, R or Rs from RO */
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
							  * multiple[scale_index[2][x][i]];
				    }
				}
				break;

		  case 3 :	/* t2 = from L0 or R0, t3 = Ls, t4 = Rs */
				for(bl = 0; bl < 3; bl++)
				{
				    if(fr_ps->dyn_cross_bits == 4)
				    {
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];

					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]]; 
					fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];
				    }
				    if(fr_ps->dyn_cross_bits == 3)
				    {
					if (
			/* 2/2 mode */		fr_ps->header->surround == 2 ||
			/* 3/1 mode */		fr_ps->header->tc_alloc[sbgr] == 1 ||
						fr_ps->header->tc_alloc[sbgr] != 2 && !fr_ps->header->dyn_cross_LR
					) /* C, L or Ls from L0 */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C, R or Rs from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];

					if (
			/* 2/2 mode */		fr_ps->header->surround == 2 ||
			/* 3/1 mode */		fr_ps->header->tc_alloc[sbgr] == 4 ||
						fr_ps->header->tc_alloc[sbgr] != 3 && fr_ps->header->dyn_cross_LR
					) /* S, R or Rs from R0 */
						fraction[3][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								   	   * multiple[scale_index[3][x][i]];
					    else     /* S, L or Ls from L0 */
						fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								   	   * multiple[scale_index[3][x][i]];
				    }
				}
				break;

		  case 4 :	/* t2 = C, t3 from t0(LO), t4 = from t1(R0) */
				for(bl = 0; bl < 3; bl++)
				{
						  /* C from T2 */
				    if(fr_ps->dyn_cross_bits == 4)
				    {
					fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
					fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								   * multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								   * multiple[scale_index[4][x][i]];
				    }
				    if(fr_ps->dyn_cross_bits == 3)
				    {
					fraction[3][i][bl][*z] = fraction[2][i][bl][*z];
					fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];
				    }
				}
				break;

		  case 5 :	/* t2 = from L0 or R0, t3 = Ls, t4 = from t1(R0) */
				for(bl = 0; bl < 3; bl++)
				{
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];

					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								   * multiple[scale_index[4][x][i]];
				}
				break;

		  case 6 :	/* t2 = from L0 or R0, t3 from t0(L0), t4 = Rs */
				for(bl = 0; bl < 3; bl++)
				{
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];

					fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
									  * multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];
				}
				break;
		  case 7 :	/* t2 = from L0 or R0, t3 from t0(L0), t4 = from t1(R0) */
				for(bl = 0; bl < 3; bl++)
				{
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
					fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								   * multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								   * multiple[scale_index[4][x][i]];
				}
				break;


		  case 8 :	/* t2 = C, t3 = Ls, t4 = from t3(Ls) */
				for(bl = 0; bl < 3; bl++)
				{
							  /* C from T2 */
					fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
					fraction[4][i][bl][*z]  = fraction[3][i][bl][*z];
					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];
				}
				break;

		  case 9 :      /* t2 = C, t3 from t2(C), t4 = Rs */
				for(bl = 0; bl < 3; bl++)
				{
						  /* C from T2 */
					fraction[3][i][bl][*z] = fraction[2][i][bl][*z];
					fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];
				}
				break;

		  case 10 :	/* t2 = C, t3 = Ls, t4 from t2(C) */
				for(bl = 0; bl < 3; bl++)
				{
						  /* C from T2 */
					fraction[4][i][bl][*z]  = fraction[2][i][bl][*z];
					fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];
				}
				break;

		  case 11 :	/* t2 = C, t3 from t2(C), t4 from t1(R0) */
				for(bl = 0; bl < 3; bl++)
				{
					fraction[3][i][bl][*z]  = fraction[2][i][bl][*z];
					fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[4][x][i]];
				}
				break;

		  case 12 :	/* t2 = C, t3 from t0(L0), t4 from t2(C) */
				for(bl = 0; bl < 3; bl++)
				{
					fraction[4][i][bl][*z]  = fraction[2][i][bl][*z];
					fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
					fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];
				}
				break;

		  case 13 :	/* t2 from L0 or R0, t3 = Ls, t4 from t3(Ls) */
				for(bl = 0; bl < 3; bl++)
				{
					if(fr_ps->header->dyn_cross_LR)  /* C from RO */
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
									 * multiple[scale_index[2][x][i]];
					else	/* C from LO */
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
									 * multiple[scale_index[2][x][i]];	
					fraction[4][i][bl][*z]  = fraction[3][i][bl][*z];
					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];
				}
				break;

		  case 14 :	/* t2 = C, t3 from t2(C), t4 from t2(C) */
				for(bl = 0; bl < 3; bl++)
				{
					fraction[4][i][bl][*z]  = fraction[2][i][bl][*z];
					fraction[3][i][bl][*z]  = fraction[2][i][bl][*z];
					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];
							  /* C from T2 */
					fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
						
				}
				break;

		} /* end switch */
   } /* for sblimit */
}

/*************************************************************/
/* JMZ 09/03/1995 Multilingual */

void II_denormalize_sample_ml(double fraction_ml[5][SBLIMIT][3][12],
			      unsigned int scale_index_ml[5][3][SBLIMIT],
			      frame_params *fr_ps,
			      int x,
			      int *n_ml_ch,
			      int *z)
{
   int i,j;
   int mlsblimit = fr_ps->mlsblimit;

   for (i = 0; i < mlsblimit; i++)
    for (j = 0; j < *n_ml_ch; j++)
     {
       fraction_ml[j][i][0][*z] *= multiple[scale_index_ml[j][x][i]];
       fraction_ml[j][i][1][*z] *= multiple[scale_index_ml[j][x][i]];
       fraction_ml[j][i][2][*z] *= multiple[scale_index_ml[j][x][i]];
     }
}

/*****************************************************************
/*
/* The following are the subband synthesis routines. They apply
/* to both layer I and layer II stereo or mono. The user has to
/* decide what parameters are to be passed to the routines.
/*
/***************************************************************/

/*************************************************************
/*
/*   Pass the subband sample through the synthesis window
/*
/**************************************************************/

/* create in synthesis filter */

void create_syn_filter(double filter[64][SBLIMIT])
{
   register int i,k;

   for (i=0; i<64; i++)
      for (k=0; k<32; k++) {
		 if ((filter[i][k] = 1e9*cos((double)((PI64*i+PI4)*(2*k+1)))) >= 0)
			modf(filter[i][k]+0.5, &filter[i][k]);
         else
            modf(filter[i][k]-0.5, &filter[i][k]);
		 filter[i][k] *= 1e-9;
	  }
}

/***************************************************************
/*
/*   Window the restored sample
/*
/***************************************************************/

/* read in synthesis window */

void read_syn_window(double window[HAN_SIZE])
{
   int i,j[4];
   FILE *fp;
   double f[4];
   char t[150];

   if (!(fp = OpenTableFile("dewindow") )) {
	  printf("Please check synthesis window table 'dewindow'\n");
	  exit(1);
   }
   for (i=0;i<512;i+=4) {
		fgets(t,150, fp);
	  sscanf(t,"D[%d] = %lf D[%d] = %lf D[%d] = %lf D[%d] = %lf\n",
			 j, f,j+1,f+1,j+2,f+2,j+3,f+3);
	  if (i==j[0]) {
		 window[i] = f[0];
		 window[i+1] = f[1];
		 window[i+2] = f[2];
		 window[i+3] = f[3];
	  }
	  else {
		 printf("Check index in synthesis window table\n");
			exit(1);
	  }
	  fgets(t,80,fp);
   }
   fclose(fp);
}


int SubBandSynthesis (double *bandPtr,
		      int channel,
		      long *samples)
{
    long foo;
    register int i,j,k;
    register double *bufOffsetPtr, sum;
    static int init = 1;
    typedef double NN[64][32];
    static NN *filter;
    typedef double BB[5][2*HAN_SIZE]; 
    static BB *buf;
    static int bufOffset = 64;
    static double *window;
    int clip = 0;               /* count & return how many samples clipped */

    if (init) {
		buf = (BB *) mem_alloc(sizeof(BB),"BB");
		filter = (NN *) mem_alloc(sizeof(NN), "NN");
		create_syn_filter(*filter);
		window = (double *) mem_alloc(sizeof(double) * HAN_SIZE, "WIN");
		read_syn_window(window);
		bufOffset = 64;
		init = 0;
	}
	if (channel == 0) bufOffset = (bufOffset - 64) & 0x3ff;
	bufOffsetPtr = &((*buf)[channel][bufOffset]);

	for (i=0; i<64; i++)
	{
		sum = 0;
		for (k=0; k<32; k++)
			sum += bandPtr[k] * (*filter)[i][k];
		bufOffsetPtr[i] = sum;
	}

	/*  S(i,j) = D(j+32i) * U(j+32i+((i+1)>>1)*64)  */
	/*  samples(i,j) = MWindow(j+32i) * bufPtr(j+32i+((i+1)>>1)*64)  */
	for (j=0; j<32; j++)
	{
        sum = 0;
		for (i=0; i<16; i++)
		{
			k = j + (i<<5);
            sum += window[k] * (*buf) [channel] [( (k + ( ((i+1)>>1) <<6) ) +
                                                  bufOffset) & 0x3ff];
        }

/*   {long foo = (sum > 0) ? sum * SCALE + 0.5 : sum * SCALE - 0.5; */
/*   {long foo = sum * SCALE;  */
     
	 foo = floor(sum * SCALE + 0.5);
	 if (foo >= (long) SCALE)      {samples[j] = SCALE-1; ++clip;}
	 else if (foo < (long) -SCALE) {samples[j] =-SCALE;  ++clip;}
	 else                           samples[j] = foo;
 
    }
    return(clip);
}

int SubBandSynthesis_ml (double *bandPtr,
		         int channel,
		         long *samples)
{
    long foo;
    register int i,j,k;
    register double *bufOffsetPtr, sum;
    static int init = 1;
    typedef double NN[64][32];
    static NN *filter;
    typedef double BB[5][2*HAN_SIZE]; 
    static BB *buf;
    static int bufOffset = 64;
    static double *window;
    int clip = 0;               /* count & return how many samples clipped */

    if (init) {
		buf = (BB *) mem_alloc(sizeof(BB),"BB");
		filter = (NN *) mem_alloc(sizeof(NN), "NN");
		create_syn_filter(*filter);
		window = (double *) mem_alloc(sizeof(double) * HAN_SIZE, "WIN");
		read_syn_window(window);
		bufOffset = 64;
		init = 0;
	}
	if (channel == 0) bufOffset = (bufOffset - 64) & 0x3ff;
	bufOffsetPtr = &((*buf)[channel][bufOffset]);

	for (i=0; i<64; i++)
	{
		sum = 0;
		for (k=0; k<32; k++)
			sum += bandPtr[k] * (*filter)[i][k];
		bufOffsetPtr[i] = sum;
	}

	/*  S(i,j) = D(j+32i) * U(j+32i+((i+1)>>1)*64)  */
	/*  samples(i,j) = MWindow(j+32i) * bufPtr(j+32i+((i+1)>>1)*64)  */
	for (j=0; j<32; j++)
	{
        sum = 0;
		for (i=0; i<16; i++)
		{
			k = j + (i<<5);
            sum += window[k] * (*buf) [channel] [( (k + ( ((i+1)>>1) <<6) ) +
                                                  bufOffset) & 0x3ff];
        }

/*   {long foo = (sum > 0) ? sum * SCALE + 0.5 : sum * SCALE - 0.5; */
/*   {long foo = sum * SCALE;  */
     
	 foo = floor(sum * SCALE + 0.5);
	 if (foo >= (long) SCALE)      {samples[j] = SCALE-1; ++clip;}
	 else if (foo < (long) -SCALE) {samples[j] =-SCALE;  ++clip;}
	 else                           samples[j] = foo;
 
    }
    return(clip);
}


void out_fifo(long pcm_sample[5][3][SBLIMIT],
	      int num,
	      frame_params *fr_ps,
	      int done,
	      FILE *outFile,
	      unsigned long *psampFrames,
	      int ch)
{
   int i,j,l;
static short int outsamp[1600];
static long k = 0;

  if( (mpeg == 1) && (frameNum == 1) ) 
  /* 6.4.1995 R.S. do nothing to avoid a spike in the first decoded 24 ms  */;
  else		
   if (!done)
      for (i=0;i<num;i++) for (j=0;j<SBLIMIT;j++) 
      {
         (*psampFrames)++;
         for (l = 0; l < ch; l++)
	 {
            if (!(k%1600) && k) 
	    {
               fwrite(outsamp,2,1600,outFile);
	       k = 0;
	    }
	    outsamp[k++] = pcm_sample[l][i][j];
	}
      }
   else 
   {
      fwrite(outsamp,2,(int)k,outFile);
	  k = 0;
   }
}

void out_fifo_ml(long pcm_sample[5][3][SBLIMIT],
	         int num,
	         frame_params *fr_ps,
	         int done,
	         FILE *outFile,
	         unsigned long *psampFrames)
{
   int i,j,l;
   int n_ml_ch = fr_ps->header->no_of_multi_lingual_ch;
   static short int outsamp[1600];
   static long k = 0;

   if (!done)
      for (i=0;i<num;i++) for (j=0;j<SBLIMIT;j++) {
         (*psampFrames)++;
         for (l=0; l<n_ml_ch; l++) {
            if (!(k%1600) && k) {
               fwrite(outsamp,2,1600,outFile);
			   k = 0;
			}
			outsamp[k++] = pcm_sample[l][i][j];
		 }

      }
   else {
      fwrite(outsamp,2,(int)k,outFile);
	  k = 0;
   }
}

/*************************************************/
/* JMZ 10/03/1995 Multilingual */

/* JMZ 10/03/1995 Multilingual */
/*************************************************/

void  buffer_CRC(Bit_stream_struc  *bs,
		 unsigned int  *old_crc)
{
   *old_crc = getbits(bs, 16);
}

void  recover_CRC_error(long pcm_sample[5][3][SBLIMIT],
			int error_count,
			frame_params *fr_ps,
			FILE *outFile,
			unsigned long *psampFrames,
			int ch)
{
   int  stereo = fr_ps->stereo;
   int  num, done, i;
   int  samplesPerFrame, samplesPerSlot;
   layer  *hdr = fr_ps->header;
   long  offset;
   short  *temp;

   num = 3;
   if (hdr->lay == 1) num = 1;

   samplesPerSlot = SBLIMIT * num * stereo;
   samplesPerFrame = samplesPerSlot * 32;

   if (error_count == 1) {   /* replicate previous error_free frame */
      done = 1;
	  /* flush out fifo */
	  out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames, ch);
	  /* go back to the beginning of the previous frame */
	  offset = sizeof(short int) * samplesPerFrame;
      fseek(outFile, -offset, SEEK_CUR);
      done = 0;
      for (i = 0; i < 12; i++) {
		 fread(pcm_sample, 2, samplesPerSlot, outFile);
		 out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames, ch);
      }
   }
   else{   /* mute the frame */
      temp = (short*) pcm_sample;
      done = 0;
      for (i = 0; i < 2*3*SBLIMIT; i++)
         *temp++ = MUTE;   /* MUTE value is in decoder.h */
      for (i = 0; i < 12; i++)
         out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames, ch);
   }
}


/**************************************************************/
/* routines for dematrix2_filter */


static double	dematrix2_filter_coeff[3][4] = {
	/* a0    b0     b1   b2 */
	{ 295, 2048, -1394, 521},	/* 44.1 kHz */
	{ 294, 2048, -1388, 520},	/* 48 kHz */
	{ 486, 2048,  -471, 370}	/* 32 kHz */
};

/*
 * init_dematrix2_filter_state()
 *
 *	This routine initializes the state vector of the dematrix
 *	procedure 2 filter to zero. The state should be initialized:
 *	- at startup
 *	- whenever the previous frame did not use dematrix procedure 2
 *	- whenever the sample rate changes
 */
void
init_dematrix2_filter_state(
	double	state[3]
) {
	state[0] = 0.0;
	state[1] = 0.0;
	state[2] = 0.0;
}

/*
 * dematrix2_filter()
 *	This routine accepts one sample of the mono surround signal,
 *	and produces one sample of the filtered signal for dematrix
 *	procedure 2.
 */
double
dematrix2_filter(
	frame_params *fr_ps,
	double	state[3],
	double	sample
) {
#ifndef	DISABLE_DEMATRIX2_FILTER
	int	sfreq = fr_ps->header->sampling_frequency;
	double	filteredSample;

	state[2] = state[1];
	state[1] = state[0];

	state[0] = (
		sample -
		dematrix2_filter_coeff[sfreq][2] * state[1] -
		dematrix2_filter_coeff[sfreq][3] * state[2]
	) / dematrix2_filter_coeff[sfreq][1];

	filteredSample = dematrix2_filter_coeff[sfreq][0] * (
		state[0] + 2 * state[1] + state[2]
	);

	return(filteredSample);
#else
	return(sample);
#endif
}

/*******************************************************/
/* prediction corrected, Heiko Purnhagen 08-nov-94 */
/*******************************************************/

/* this is only a local function */
double predict (double pred_buf[2][8][36+PREDDEL], 
		frame_params *fr_ps,
		int sb, 
		int jj, 
		int j,
		int ch,
		int idx) 
{
  int i;
  double t;

  t = 0;
  for (i=0; i<fr_ps->header->mc_predsi[sb][idx]; i++)
    t += pred_buf[ch][sb][PREDDEL+3*jj+j-i-fr_ps->header->mc_delay_comp[sb][idx]]
      * (fr_ps->header->mc_pred_coeff[sb][idx][i] - 127) * STEP;
  return t;
}


/**************************************************************/
/* JMZ 09/03/1995 Multilingual modifications */

void dematricing(double pcm_sample[5][SBLIMIT][3][12], 
			frame_params *fr_ps,
			double dematrix2_filter_state[3],
			double pred_buf[2][8][36+PREDDEL])
{
  double matr1;   /* normalizing factor */
  double matr2;   /* matricing factor   */
  double matr3;   /* matricing factor   */
  int i, j, jj, k, tc_alloc, l, sbgr = 0 ;
  layer *info = fr_ps->header;
  double tmp_sample, filtered_sample;
  
  /* JMZ 09/03/1995 Multilingual */
  int n_ml_ch = info->no_of_multi_lingual_ch;

  switch(info->dematrix_procedure)
  {

	/* factors according to International Standard */

	  case 0:
	  case 2: matr1 = 1 + sqrt(2.0);	/* factor for L and R   */
		  matr2 = sqrt(2.0) * matr1;	/* factor for C */
		  matr3 = sqrt(2.0) * matr1;	/* factor for Ls, Rs */
		  break;
	  case 1: matr1 = (1.5 + 0.5*sqrt(2.0));/* factor for L, R      */
		  matr2 = sqrt(2.0) * matr1;	/* factor for C         */
		  matr3 = 2 * matr1;		/* factor for Ls, Rs  */
		  break;
	  case 3: matr1 = 1.0;
		  matr2 = 1.0;
		  matr3 = 1.0;
		  break;
  }

  for (jj=0; jj<12; jj++)
  for( j = 0; j < 3; ++j)
   {
	for(k = 0; k < SBLIMIT; k ++)
	{
	    if(fr_ps->header->tc_sbgr_select == 1)
		tc_alloc = fr_ps->header->tc_allocation; /* one tc_alloc is valid for all sbgr */
	    else
	    {
		if(k == 0) sbgr = 0;
		else
			for(l = 1; l < 12; l++)
			{
				if((sb_groups[l-1] < k) && (k <= sb_groups[l]))
				{
					sbgr = l;  /* search the valid subband group */
					break;
				}
			}
			tc_alloc = fr_ps->header->tc_alloc[sbgr]; /* no prediction, but different tc_alloc's
									per subband*/
	    }  /* else tc_sbgr_select == 0 */

	    if((fr_ps->header->surround == 2) && (mc_channel == 3))
	    {    
		if( (fr_ps->header->mc_prediction_on & fr_ps->header->mc_prediction[k]) && (k < 8) )
		    switch(fr_ps->header->dyn_cross_mode[k])   /* if prediction on in sb */
		    {
			case 0: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1);
			    	pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2)
					 	         + predict(pred_buf,fr_ps,k,jj,j,1,3);
			    	pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,4)
						         + predict(pred_buf,fr_ps,k,jj,j,1,5);
				break;
			
			case 1: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1);
			    	pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2)
					 	         + predict(pred_buf,fr_ps,k,jj,j,1,3);
			    	break;
			
			case 2: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1);
			    	pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2)
						         + predict(pred_buf,fr_ps,k,jj,j,1,3);
				break;
			
			case 3: pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
					 	         + predict(pred_buf,fr_ps,k,jj,j,1,1);
			    	pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2)
						         + predict(pred_buf,fr_ps,k,jj,j,1,3);
				break;
			
			case 4: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1);
			    	break;
			
			case 5: pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
					 	         + predict(pred_buf,fr_ps,k,jj,j,1,1);
			    	break;
			
			case 6: pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
						         + predict(pred_buf,fr_ps,k,jj,j,1,1);
				break;

			case 8: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1);
				tmp_sample = predict(pred_buf,fr_ps,k,jj,j,0,2) + predict(pred_buf,fr_ps,k,jj,j,1,3);
			    	pcm_sample[3][k][j][jj] += tmp_sample;
				pcm_sample[4][k][j][jj] += tmp_sample;
			    	break;

			case 9: tmp_sample = predict(pred_buf,fr_ps,k,jj,j,0,0) + predict(pred_buf,fr_ps,k,jj,j,1,1);
				pcm_sample[2][k][j][jj] += tmp_sample;
				pcm_sample[3][k][j][jj] += tmp_sample;
			    	pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2)
						         + predict(pred_buf,fr_ps,k,jj,j,1,3);
				break;

		       case 10: tmp_sample = predict(pred_buf,fr_ps,k,jj,j,0,0) + predict(pred_buf,fr_ps,k,jj,j,1,1);
				pcm_sample[2][k][j][jj] += tmp_sample;
			    	pcm_sample[4][k][j][jj] += tmp_sample;
				pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2)
						         + predict(pred_buf,fr_ps,k,jj,j,1,3);
			    	break;

		       case 11: tmp_sample = predict(pred_buf,fr_ps,k,jj,j,0,0) + predict(pred_buf,fr_ps,k,jj,j,1,1);
				pcm_sample[2][k][j][jj] += tmp_sample;
				pcm_sample[3][k][j][jj] += tmp_sample;
			    	break;

		       case 12: tmp_sample = predict(pred_buf,fr_ps,k,jj,j,0,0) + predict(pred_buf,fr_ps,k,jj,j,1,1);
				pcm_sample[2][k][j][jj] += tmp_sample;
				pcm_sample[4][k][j][jj] += tmp_sample;
			    	break;

		       case 13: tmp_sample = predict(pred_buf,fr_ps,k,jj,j,0,0) + predict(pred_buf,fr_ps,k,jj,j,1,1);
				pcm_sample[3][k][j][jj] += tmp_sample;
				pcm_sample[4][k][j][jj] += tmp_sample;
			    	break;

		       case 14: tmp_sample = predict(pred_buf,fr_ps,k,jj,j,0,0) + predict(pred_buf,fr_ps,k,jj,j,1,1);
				pcm_sample[2][k][j][jj] += tmp_sample;
				pcm_sample[3][k][j][jj] += tmp_sample;
				pcm_sample[4][k][j][jj] += tmp_sample;
			    	break;					

		     }  /* switch prediction end */  

	    	switch(tc_alloc)
	    	{
		 case 0:
			if (fr_ps->header->dematrix_procedure == 2) {
			    filtered_sample =
				dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
			    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
			    pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
			}
			else if (fr_ps->header->dematrix_procedure != 3) {
			    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			    pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
			}
			break;

		 case 1:
			if (fr_ps->header->dematrix_procedure == 2) {
				filtered_sample =
					dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
				tmp_sample = pcm_sample[2][k][j][jj]; /* L */
				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
				pcm_sample[0][k][j][jj] = tmp_sample;
			}
			else {
				tmp_sample = pcm_sample[2][k][j][jj]; /* L */
				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
				pcm_sample[0][k][j][jj] = tmp_sample;
			}
			break;

		 case 2:
			if (fr_ps->header->dematrix_procedure == 2) {
				filtered_sample =
					dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
				tmp_sample = pcm_sample[2][k][j][jj]; /* R */
				pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
				pcm_sample[1][k][j][jj] = tmp_sample;
			}
			else {
				tmp_sample = pcm_sample[2][k][j][jj]; /* R */
				pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				pcm_sample[1][k][j][jj] = tmp_sample;
			}
			break;

		 case 3:
			tmp_sample = pcm_sample[3][k][j][jj];  /* L in T3 */
			pcm_sample[3][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[3][k][j][jj] - pcm_sample[2][k][j][jj];
			pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
			pcm_sample[0][k][j][jj] = tmp_sample;
			break;

		 case 4:
			tmp_sample = pcm_sample[4][k][j][jj];  /* R in T4 */
			pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			pcm_sample[4][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[4][k][j][jj] - pcm_sample[2][k][j][jj];
			pcm_sample[1][k][j][jj] = tmp_sample;
			break;

		 case 5:
			tmp_sample = pcm_sample[3][k][j][jj];
			pcm_sample[3][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[3][k][j][jj] - pcm_sample[2][k][j][jj];
			pcm_sample[0][k][j][jj] = tmp_sample;
			tmp_sample = pcm_sample[4][k][j][jj];
			pcm_sample[4][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[4][k][j][jj] - pcm_sample[2][k][j][jj];
			pcm_sample[1][k][j][jj] = tmp_sample;
			break;

		 case 6:
			tmp_sample = pcm_sample[2][k][j][jj];  /* R in T2 */
			pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
			pcm_sample[1][k][j][jj] = tmp_sample;
			tmp_sample = pcm_sample[3][k][j][jj];  /* L in T3 */
			pcm_sample[3][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[3][k][j][jj] - pcm_sample[2][k][j][jj];
			pcm_sample[0][k][j][jj] = tmp_sample;
			break;

		 case 7:
			tmp_sample = pcm_sample[2][k][j][jj];
			pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			pcm_sample[0][k][j][jj] = tmp_sample;
			tmp_sample = pcm_sample[4][k][j][jj];
			pcm_sample[4][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[4][k][j][jj] - pcm_sample[2][k][j][jj];
			pcm_sample[1][k][j][jj] = tmp_sample;
			break;

		} /* switch end loop*/
	    }
	    else  /* if(surround == 1) */
	     if( fr_ps->header->dematrix_procedure != 3 )
	     {	 
		if(((fr_ps->header->surround == 1) || mc_channel == 1) || (fr_ps->header->surround == 3))  
						/* R.S channel modes 3/1; 2/1; 2/2; 3/0; 30/20 */
		    switch(tc_alloc)
		    {
			 case 0: 
				if(mc_channel == 2 && fr_ps->header->center == 1)   /* 3/1 */
				{
				    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			    	    pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				}
				else           
				   if(mc_channel == 2 && fr_ps->header->center == 0)   /* 2/2 */
				   {
				        pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];
			    	        pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[3][k][j][jj];
				    }
				if(mc_channel == 1 || mc_channel == 3)     /* 2/1 and 3/0 */
				{
				     pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj]; 
			    	     pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj];
				}
				break;

			 case 1:
				tmp_sample = pcm_sample[2][k][j][jj]; /* L */
				if(mc_channel == 2)
				{
				    if(fr_ps->header->center == 0)	/* 2/2 mode */
				    {	
				       pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[3][k][j][jj];
				       pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];
				       pcm_sample[0][k][j][jj] = tmp_sample;
				    }
				    else	/* 3/1 mode */
				    {
				       pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				       pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				       pcm_sample[0][k][j][jj] = tmp_sample;
				    }
				}
				else
				    if(mc_channel == 1 || mc_channel == 3)     /* 2/1 and 3/0 */
				    {
					pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];
					pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj];
				    	pcm_sample[0][k][j][jj] = tmp_sample;
				    }
				break;

			 case 2: 
				tmp_sample = pcm_sample[2][k][j][jj]; /* R */
				if(mc_channel == 2)
				{
				    if(fr_ps->header->center == 0)	/* 2/2 mode */
				    {
				       pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];
				       pcm_sample[3][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[3][k][j][jj];
				       pcm_sample[1][k][j][jj] = tmp_sample;
				    }
				    else	/* 3/1 mode */
				    {
				       pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				       pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				       pcm_sample[1][k][j][jj] = tmp_sample;
				    }
				}
				else
				    if(mc_channel == 1 || mc_channel == 3)        /* 2/1 and 3/0 */
				    {
					pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj];
				    	pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];
				    	pcm_sample[1][k][j][jj] = tmp_sample;
				    }
				break;

			 case 3: 
				tmp_sample = pcm_sample[3][k][j][jj];  /* L in T3 */
				if(fr_ps->header->center == 0)	/* 2/2 mode */
				{
				   tmp_sample = pcm_sample[2][k][j][jj];
				   pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];
				   pcm_sample[0][k][j][jj] = tmp_sample;
				   tmp_sample = pcm_sample[3][k][j][jj];
				   pcm_sample[3][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[3][k][j][jj];
				   pcm_sample[1][k][j][jj] = tmp_sample;
			 	}
				else
				{
				   pcm_sample[3][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[3][k][j][jj] - pcm_sample[2][k][j][jj];
				   pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				   pcm_sample[0][k][j][jj] = tmp_sample;
				}
				break;

			 case 4:
				tmp_sample = pcm_sample[3][k][j][jj];  /* R in T3 */
				pcm_sample[3][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[3][k][j][jj] - pcm_sample[2][k][j][jj];
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				pcm_sample[1][k][j][jj] = tmp_sample;
				break;
		    }   /* switch end */
		}
	}     /* for k < sblimit loop */
      }     /* for j < 3 loop */

/* denormalized signals */
      if( fr_ps->header->dematrix_procedure != 3 ) 		/* dematrixing */
	  for (jj=0; jj<12; jj++)
		for( j = 0; j < 3; ++j)
			for(k = 0; k < SBLIMIT; k ++)
			{   /* Lo / Ro */
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] * matr1;
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] * matr1;

			 if(fr_ps->header->dematrix_procedure != 1)  /* matrix 0 and 2, since C, Ls, Rs, and S all use the same value */
			   	/* surround channels */
				if(fr_ps->header->surround == 3)
				       pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;
				else   
			        {
				    for(l = 2; l < channels; l++)
				       pcm_sample[l][k][j][jj] = pcm_sample[l][k][j][jj] * matr2;
				}
			 else   /* matrix 1 */
				if(fr_ps->header->surround == 3)
				       pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;
				else   
			 	if(mc_channel == 3)   /* R.S. matr2 = C */
				{
				    pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;
				    pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr3;
				    pcm_sample[4][k][j][jj] = pcm_sample[4][k][j][jj] * matr3;
				}
				else
				{
				    if(mc_channel == 2)
					if(fr_ps->header->surround == 2)
					{
					   pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr3;  
					   pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr3;
					}
					else
					   if(fr_ps->header->surround != 3)  /* R.S. 2/0 + 2/0  surround == 1 */
					   {
					   	pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;
				    	   	pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr3;
					   }
				    else  /* mc_channel == 1 */
					if((mc_channel == 1) && (fr_ps->header->center != 0))  /* 2/1 */
					   pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr3; 	
					else   /* 3/0 */
					   pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;
				}
			}
}

/* JMZ 09/03/1995 Multilingual , WtK 7/8/95 */
void dematricing_ml(double pcm_sample_ml[5][SBLIMIT][3][12], 
		    frame_params *fr_ps) 
/* unweighting the signals */		    
{
  double matr1;   /* normalizing factor */
  int i, j, jj, k;

  layer *info = fr_ps->header;
  int n_ml_ch = info->no_of_multi_lingual_ch;

  int lsf     = info->multi_lingual_fs;
  int encoder_weights_ml = 0;
  
  switch(info->dematrix_procedure) /* ######## */
  {
    /* factors according to Committee Draft and telefax 10/20/93 */
    /* by E.Schroeder, DTB Hannover.  01/14/94, SR               */
   
      case 0: matr1 = 2.42797851625;
	      break;
      case 1: matr1 = 1.5 + (0.5 * 1.41632080078125);
	      break;
      case 2: matr1 = 2.42797851625;
	      break;
      case 3: matr1 = 1.0;
	      break;
  }

/* no weighting is occurring in encoder; so skip the unweighting ! */
if (encoder_weights_ml) 
 if( fr_ps->header->dematrix_procedure != 3 )
    for (jj=0;jj<( (lsf==0) ? 12 : 6 );jj++)
      for (j=0;j<3;++j)
	for (i=0;i<SBLIMIT;i++)
	  for (k=0;k<n_ml_ch;k++)
	    pcm_sample_ml[k][i][j][jj] *= matr1;
}
		
/***********************************************************************
 *
 * ancillaryDecode
 *
 * Purpose : decode ancillary data
 *
 ***********************************************************************/

void ancillaryDecode(fr_ps,bs,pp)
frame_params *fr_ps;
Bit_stream_struc *bs;
long pp;
{

	int bitsPerSlot;
    	int samplesPerFrame;
	int bit_rate;
	int avg_slots_per_frame;
	int Slot_for_ThisFrame;
	int whole_SpF;
	int usedAdb;
	int adbNumberStart;
	int l;
	int AncillaryUse = 0;
	long p1;
	char anc[150];
	extern int anc_index;
				 
	register int i;
				      
				       
	double frac_SpF;
	double slot_lag;
	layer *info = fr_ps->header;
					    
	if (info->lay == 1) { bitsPerSlot = 32; samplesPerFrame = 384;  }
	else               { bitsPerSlot = 8;  samplesPerFrame = 1152; }
							      
	bit_rate = bitrate[info->lay-1][info->bitrate_index];
								   
	avg_slots_per_frame = ((double)samplesPerFrame /
			  s_freq[info->sampling_frequency]) *
			    ((double)bit_rate / (double)bitsPerSlot);
	whole_SpF = (int) avg_slots_per_frame;
	Slot_for_ThisFrame = avg_slots_per_frame + info->padding;

	p1 = sstell(bs) - pp;

	if(p1 <= Slot_for_ThisFrame*8-8) {

		if(p1 % 8) {
			l = getbits(bs,8-(p1%8));
			p1 += (8 - (p1 % 8));
		}
		while(p1 < Slot_for_ThisFrame*8-8)
		{
			l = getbits(bs,8);
			p1 += 8;
		}
		l =  getbits(bs,8);
		if(l && (AncillaryUse==0))
			AncillaryUse = 1;
		if(AncillaryUse){
			anc[anc_index++] = (char)l;
			fprintf(stderr,"\t\t>>>>  %c  <<<<\n", (char)l);
		}
	}
}

@


1.9
log
@Moved merged FTZ_04 and Philips_01 into main trunk
@
text
@d2 2
a3 3
 * Copyright (c) 1995 MPEG/audio software simulation group
 * All Rights Reserved
 * $Id: decode.c 1.8.3.2 1995/11/06 04:04:21 rowlands Exp $
d5 1
a5 3
 * MPEG/audio coding/decoding software, work in progress
 *   NOT for public distribution until verified and approved by the
 *   MPEG/audio committee.
d8 3
a10 2
 * Revision 1.8.3.2  1995/11/06  04:04:21  rowlands
 * Merged FTZ_04 and Philips_01
d12 2
a13 2
 * Revision 1.8.3.1  1995/11/05  22:50:42  rowlands
 * Merged FTZ_04 and Philips_01 using #ifdefs
d16 1
a16 1
 * ML-LSF added WtK 7/8/95
a19 3
 * Revision 1.7.1.2  1995/07/14  06:17:20  rowlands
 * Merged changes in FTZ_03 and Distribution_04.
 *
a22 21
 * Revision 1.7.1.0  1995/07/14  00:23:53  rowlands
 * Branch for FTZ dynamic crosstalk
 *
 * Revision 1.7  1995/06/22  01:23:00  rowlands
 * Merged FTZ dynamic crosstalk
 *
 * Revision 1.6  1995/06/19  03:14:11  rowlands
 * Moved merged FTZ/Distribution_02 into main RC trunk.
 *
 * Revision 1.5.1.3  1995/06/19  00:44:31  rowlands
 * Merged old and new functionality.
 *
 * Revision 1.5.1.2  1995/06/17  21:27:02  rowlands
 * Merged with Distribution_02, marked by flag _FTZ
 *
 * Revision 1.5  1995/06/16  08:49:22  rowlands
 * Moved merged IRT/Samsung/TI into main revision control trunk.
 *
 * Revision 1.3.3.2  1995/06/16  08:42:59  rowlands
 * Merged and tested revisions 1.4 and 1.3.3.1
 *
d24 1
a24 1
 * Input from Samsung AIT.
a25 6
 * Revision 1.4  1995/06/16  06:19:08  rowlands
 * Moved merged IRT/TI into main revision control trunk.
 *
 * Revision 1.3.2.2  1995/06/16  06:10:31  rowlands
 * Merged and tested revisions 1.3.1.4 and 1.3.2.1 .
 *
a27 5
 *
 * Revision 1.3.2.0  1995/06/16  03:22:45  rowlands
 * Created branch for IRT
 *
 * Revision 1.3.1.4  1995/06/16  03:11:37  rowlands
a29 9
 * Revision 1.3.1.0  1995/05/23  02:34:26  rowlands
 * Created branch for TI
 *
 * Revision 1.3  1995/04/06  05:01:42  rowlands
 * Ran decoder through protoize to convert to ANSI C.
 *
 * Revision 1.2  1995/04/06  04:56:00  rowlands
 * Added header, RCS info and cleaned up prototypes in initial revision.
 *
a32 2
 * VERSION 2.5                                                        *
 *   changes made since last update:                                  *
d106 1
a106 1
 *  Version 1.0 Shareware                                             *
d115 1
a115 1
 *  Version 1.1 Shareware                                             *
d120 1
a120 1
 *  Version 1.1.1 Shareware                                           *
d124 1
a124 1
 *  Version 1.2 Shareware                                             *
d144 4
d232 7
a238 6
/* R.S. prediction table MPEG-2 IS March 29, 1995 */
int pred_coef_table[3][16] = {
	{2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},	/* 1 multichannel channel - 3/0, 2/1 */
	{4,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0},	/* 2 multichannel channels - 3/1, 2/2 */
	{6,4,4,4,2,2,2,0,4,4,4,2,2,2,2,0}	/* 3 multichannel channels - 3/2 */
};
d286 1
a286 1
	  {  /* new sbgr < 8 */
d292 2
a293 5

/* JR: updated according to IS. Number of prediction coefficients depends on	*/
/* number of multichannel channels and dynamic crosstalk mode			*/
   		  for(pci=0; pci< pred_coef_table[mc_channel - 1][hdr->dyn_cross_mode[sbgr]] ; pci++)
			 hdr->mc_predsi[sbgr][pci] = getbits(bs,2);
d426 12
a437 13
			    if(info.dyn_cross_mode[sbgr] == 3)
			    {
   			    	if((info.tc_alloc[sbgr] == 1) || (info.tc_alloc[sbgr] == 7))
				    bit_alloc[2][i] = bit_alloc[0][i];
			    	if((info.tc_alloc[sbgr] == 2) || (info.tc_alloc[sbgr] == 6))
				    bit_alloc[2][i] = bit_alloc[1][i];
			    	else
				    if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
					else	bit_alloc[2][i] = bit_alloc[0][i];

				if(info.dyn_cross_LR)  bit_alloc[3][i] = bit_alloc[1][i];
					else	bit_alloc[3][i] = bit_alloc[0][i];
			    	
d439 3
d443 9
a451 16
			    {
			    	bit_alloc[2][i] = (char) getbits(bs,(*alloc)[i][0].bits); 
			    	if(info.dyn_cross_mode[sbgr] == 1)  
					if(info.dyn_cross_LR)  bit_alloc[3][i] = bit_alloc[1][i];
					else	bit_alloc[3][i] = bit_alloc[0][i];
			    	if(info.dyn_cross_mode[sbgr] == 2) 
			    	{
			    	    bit_alloc[3][i] = bit_alloc[2][i];
			    	    if((info.tc_alloc[sbgr] == 1) || (info.tc_alloc[sbgr] == 7))
				        bit_alloc[2][i] = bit_alloc[0][i];
			    	    if((info.tc_alloc[sbgr] == 2) || (info.tc_alloc[sbgr] == 6))
				    	bit_alloc[2][i] = bit_alloc[1][i];
			    	    else
				    	if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
					    else    bit_alloc[2][i] = bit_alloc[0][i];
			    	}
d455 1
a455 1
		     else	
a666 1

d673 22
a694 1
   /* R.S. not included in Shareware */
a877 1
			int *mc_ch,
a883 1
   int channels = *mc_ch;
a918 1

d928 23
a950 8
		   if(((fr_ps->header->dyn_cross_mode[sbgr]==0) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==1  && j!=4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==2  && j!=3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==3  && j!=2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==8  && j!=4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==9  && j!=3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==10 && j!=4)) &&
			fr_ps->dyn_cross_bits == 4) 
d971 1
a971 44
		   }  /* end if 2 channel-dyn cross */

		   if(((fr_ps->header->dyn_cross_mode[sbgr]==4  && j==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==5  && j==3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==6  && j==4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==11 && j==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==12 && j==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==13 && j==3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==14 && j==2)) || 
			fr_ps->dyn_cross_bits != 4)  
		   {
			if((fr_ps->dyn_cross_bits == 3 && fr_ps->header->dyn_cross_mode[sbgr] == 3) ||
			   (fr_ps->dyn_cross_bits == 1 && fr_ps->header->dyn_cross_mode[sbgr] == 1))
			{
				/* no samples to read, do nothing */
			}
			else
			{
			    if((fr_ps->dyn_cross_bits == 3 || fr_ps->dyn_cross_bits == 1) && j == 3)
			    {
				/* do nothing, only one channel to read for mode 3/1 with dyn_cross */
			    }
			    else	
			    if((*alloc)[i][bit_alloc[j][i]].group==3)
			    {
				for (m=0;m<3;m++)
				{
				    k = (*alloc)[i][bit_alloc[j][i]].bits;
				    sample[j][m][i] = (unsigned int) getbits(bs,k);
				}
			    }
			    else
			    {    /* bit_alloc = 3, 5, 9 */
				nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
				k=(*alloc)[i][bit_alloc[j][i]].bits;
				c = (unsigned int) getbits(bs, k);
				for (k=0;k<3;k++)
				{
					sample[j][k][i] = c % nlevels;
					c /= nlevels;
				}
			    }
			}  /* end if ..bits */
		   }  /* end if 1 channel dyn-cross mode */
a1123 1
			    int *mc_ch,
a1128 1
   int	channels = *mc_ch;
a1247 1

a1299 1

a1335 1

a1367 1
			     int *mc_ch,
a1371 1
   int channels = *mc_ch;
d1389 1
a1389 1
	else  
d1415 11
a1425 3
					    fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];        
					    fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								   * multiple[scale_index[3][x][i]];
d1429 16
a1444 3
					    if(fr_ps->dyn_cross_bits == 1)	
						fraction[2][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								   * multiple[scale_index[2][x][i]];
d1463 6
a1468 2
					fraction[3][i][bl][*z] = fraction[2][i][bl][*z] * multiple[scale_index[3][x][i]];
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
d1470 2
a1471 2
								  * multiple[scale_index[2][x][i]];
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
d1473 1
a1473 8
								  * multiple[scale_index[2][x][i]];
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
d1486 1
d1503 6
a1508 5
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
d1510 1
a1510 2
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
d1513 11
a1523 6
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
					fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
									  * multiple[scale_index[3][x][i]];
					
d1555 1
d1579 1
d1602 1
a1612 1

d1694 1
a1695 2
					fraction[4][i][bl][*z]  = fraction[2][i][bl][*z];

a1697 1

d1700 1
a1858 1

a1985 1

d2106 23
d2135 2
a2136 1
			double dematrix2_filter_state[3])
d2193 85
a2277 1
		/* channel mode 3/2 */
a2528 1

a2566 4




@


1.9.1.1
log
@Received from Ralf Schwalbe - includes prediction
@
text
@d4 1
a4 1
 * $Id: decode.c 1.7.1.2 1995/07/14 06:17:20 rowlands Exp $
d11 11
a191 4
 * 01/12/96	  Ralf Schwalbe, Deutsche Telekom TZ Darmstadt	      *
 *		    - decoder prediction installed		      *
 *		    - problem with compl. bitstream 19 solved,        *
 *		    - still a problem with compl. bitstream 19        *
d276 6
a281 6
/* R.S. prediction table MPEG-2 IS November, 1995 */
int pred_coef_table[5][16] = {{6,4,4,4,2,2,2,0,4,4,4,2,2,2,2,0},
			      {4,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0},
			      {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
			      {4,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0},
			      {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}};
a282 1

d329 1
a329 1
	  {  
d335 5
a339 2
		    for(pci=0; pci< pred_coef_table[prog_mode][hdr->dyn_cross_mode[sbgr]] ; pci++)
			hdr->mc_predsi[sbgr][pci] = getbits(bs,2);
d651 4
a654 6
/************15/03/1995 TEST**********/
void II_decode_bitalloc_test(Bit_stream_struc *bs,
			unsigned int bit_alloc[5][SBLIMIT],	
			frame_params *fr_ps,
			int *l,
			int *m  )
d656 3
a658 5
   int i,j,c,sbgr;
   /* int stereo = fr_ps->stereo; */ /* not used for mc - decoding */
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;
d660 4
a663 7
   for (i=0;i<jsbound;i++)
/* JR: no dynamic crosstalk for multilingual channels */
	for (j=0;j<*m;j++)
	{
		/* JR: no phantom center coding for multilingual channels */
	 	bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);
	}
d665 6
a670 5
/* JR: no joint coding for multilingual channels */
/* JR: they're really simple, aren't they? */

   for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++)
	  bit_alloc[j][i] = 0;
d686 1
a686 1
/* JMZ 09/03/1995 Multilingual adaptations */
d710 1
d716 1
a716 1
		scfsi[j][i] = 0;
d718 1
d725 1
a725 22
   if(*m > 2)
	if (fr_ps->header->mc_prediction_on == 1)
	{
	  for(i = 0; i < 8; i++)
	  {
		 if(fr_ps->header->mc_prediction[i] == 1)
		 {
			for(px = 0; px < pred_coef_table[prog_mode][fr_ps->header->dyn_cross_mode[i]]; px++)
				if(fr_ps->header->mc_predsi[i][px] != 0) /*predictors are transfered*/
				{
				  fr_ps->header->mc_delay_comp[i][px] = getbits(bs,3);
				  for(pci = 0; pci < fr_ps->header->mc_predsi[i][px]; pci++)
					  fr_ps->header->mc_pred_coeff[i][px][pci] = getbits(bs,8);
				}
				else /* no prediction coef. */
				{
					fr_ps->header->mc_pred_coeff[i][px][0] = 127;     /* Index 127 -> 0.0 */
					fr_ps->header->mc_delay_comp[i][px] = 0;
				}
		 }
	  }
   }
d734 3
a736 3
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);
				  break;
d739 3
a741 3
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);
				  break;
d743 4
a746 4
			case 3 :scale_index[j][0][i] = getbits(bs,6);
				scale_index[j][1][i] =
				scale_index[j][2][i] =  getbits(bs,6);
				break;
d749 7
a755 4
				scale_index[j][1][i] =
				scale_index[j][2][i] = getbits(bs,6);
				break;
			default : break;
d774 1
a774 1
/* JMZ 15/03/1995 Multilingual TEST */
d777 6
a782 7
void II_decode_scale_test(Bit_stream_struc *bs,
		     unsigned int scfsi[5][SBLIMIT], 		
		     unsigned int bit_alloc[5][SBLIMIT],	
		     unsigned int scale_index[5][3][SBLIMIT],	
		     frame_params *fr_ps,
		     int *l, 
		     int *m)
d786 1
a786 2
   /* int stereo  = fr_ps->stereo; */ /* not used for mc - decoding */
   int sblimit = fr_ps->sblimit;
d789 1
a789 1
   for (i=0;i<sblimit;i++) for (j=0;j<*m;j++)   /* 2 bit scfsi */
a792 1

d794 3
a796 2
	 for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++)
		scfsi[j][i] = 0;
d798 1
a798 5

   /* 3.6.94 R.S. read the prediction coefficients in the mc - part */
   /* R.S. not included in Shareware */
	
   for (i = 0; i < sblimit; i++) for (j = 0; j < *m; j++) {
d800 1
a800 1
	  switch (scfsi[j][i]) {
d803 3
a805 4
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);

				  break;
d808 8
a815 10
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);

				  break;
	 /* scale factor 1 & 2 transmitted */
		case 3 :scale_index[j][0][i] = getbits(bs,6);
				scale_index[j][1][i] =
				scale_index[j][2][i] =  getbits(bs,6);

		  break;
d817 12
a828 10
	 case 2 : scale_index[j][0][i] =
		  scale_index[j][1][i] =
		  scale_index[j][2][i] = getbits(bs,6);

		  break;
		 default : break;
      }
      else {
	 scale_index[j][0][i] = scale_index[j][1][i] =
	 scale_index[j][2][i] = SCALE_RANGE-1;
d831 4
a834 3
   for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++) {
		 scale_index[j][0][i] = scale_index[j][1][i] =
		 scale_index[j][2][i] = SCALE_RANGE-1;
d909 1
d916 1
a931 1
	
a940 1

d952 1
a969 1
		  
d1045 62
d1186 1
d1192 1
a1193 1
   
d1209 1
d1312 54
d1435 1
d1440 1
d1484 3
a1486 8
					  fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
					    if(fr_ps->header->dyn_cross_LR)  /* S from R0 */ 
						fraction[3][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								   	   * multiple[scale_index[3][x][i]];
					    else     /* S from L0 */
						fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								   	   * multiple[scale_index[3][x][i]];
					  
d1490 3
a1492 16
					    if(fr_ps->dyn_cross_bits == 1)
					    {		
						if(fr_ps->header->tc_alloc[sbgr] == 0)
							if(fr_ps->header->dyn_cross_LR)  /* S from R0 */ 
								fraction[2][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								 		  	   * multiple[scale_index[2][x][i]];
					    	else     /* S from L0 */
							fraction[2][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
										   	   * multiple[scale_index[2][x][i]];
						if(fr_ps->header->tc_alloc[sbgr] == 1)
							fraction[2][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
										   * multiple[scale_index[2][x][i]];
						if(fr_ps->header->tc_alloc[sbgr] == 2)
							fraction[2][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
										   * multiple[scale_index[2][x][i]];
					    }
d1547 1
a1547 1
					
d1610 1
a1610 1
					
d1633 1
a1633 1
					
d1655 1
a1655 1
					
d1737 1
d1739 1
a1739 1
					fraction[3][i][bl][*z]  = fraction[2][i][bl][*z];
d1742 1
a1744 1
						
d1755 6
a1760 11
/*************************************************************/
/* JMZ 15/03/1995 TEST */
/*************************************************************************/
/* JMZ 09/03/1995 Multilingual */

void II_dequantize_sample_test(unsigned int sample[5][3][SBLIMIT],
			    unsigned int bit_alloc[5][SBLIMIT],
			    double fraction[5][SBLIMIT][3][12],
			    frame_params *fr_ps,
			    int *n_ml_ch,
			    int *z)
d1762 2
a1763 3
   int i, j, k, x,sbgr,l;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;
d1765 7
a1771 36
   for (i = 0; i < sblimit; i++)
   {
	  for (j = 0; j < 3; j++)
		 for ( k = 0; k < *n_ml_ch; k++)
			if (bit_alloc[k][i])
			{
			  /* JR: ditto */
			  /* locate MSB in the sample */
			   x = 0;
#ifndef MSDOS
			   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
#else
			   /* microsoft C thinks an int is a short */
			   while (( (unsigned long) (1L<<(long)x) <
				(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)
			   ) && ( x < 16) ) x++;
#endif
			   /* MSB inversion */
			   if (((sample[k][j][i] >> (x-1)) & 1) == 1)
					fraction[k][i][j][*z] = 0.0;
			   else  fraction[k][i][j][*z] = -1.0;

			   /* Form a 2's complement sample */
			   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
							(double) (1L<<(x-1));

			   /* Dequantize the sample */
			   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
			   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
			} /* if bit_alloc */
			else fraction[k][i][j][*z] = 0.0;
   }
   for (i = sblimit; i < SBLIMIT; i++)
	  for (j = 0; j < 3; j++)
		 for(k = 0; k < *n_ml_ch; k++)
			 fraction[k][i][j][*z] = 0.0;
a1773 80

void II_denormalize_sample_test(double fraction[5][SBLIMIT][3][12],
			     unsigned int scale_index[5][3][SBLIMIT],
			     frame_params *fr_ps,
			     int x,
			     int *n_ml_ch,
			     int *z)
{
   int i,j,k,sbgr,l,bl=0;
   int sblimit = fr_ps->sblimit;

   for (i = 0; i < sblimit; i++)
   {
	if(fr_ps->header->dyn_cross_on == 0)
		for (j = 0; j < *n_ml_ch; j++)
		{
			fraction[j][i][0][*z] *= multiple[scale_index[j][x][i]];
			fraction[j][i][1][*z] *= multiple[scale_index[j][x][i]];
			fraction[j][i][2][*z] *= multiple[scale_index[j][x][i]];
		}
	/************** R.S. ***************/
 
   } /* for sblimit */
}

void II_buffer_sample_test(Bit_stream_struc *bs,
			unsigned int sample[5][3][SBLIMIT],
			unsigned int bit_alloc[5][SBLIMIT],
			frame_params *fr_ps,
			int *n_ml_ch)
{
   int i,j,k,m,sbgr,l;
   unsigned int nlevels, c=0;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   for (i = 0; i < sblimit; i++)
   {
	 for (j = 0; j < *n_ml_ch; j++)
	 {
	   if (bit_alloc[j][i])
	   {
		/* JR: no dynamic crosstalk for multilingual channels */
		/* check for grouping in subband */
		if ((*alloc)[i][bit_alloc[j][i]].group==3)
		{

			for (m=0;m<3;m++)
			{
				k = (*alloc)[i][bit_alloc[j][i]].bits;
				sample[j][m][i] = (unsigned int) getbits(bs,k);
			}

		}
		else
		{    /* bit_alloc = 3, 5, 9 */
		  nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
		  k=(*alloc)[i][bit_alloc[j][i]].bits;
		  c = (unsigned int) getbits(bs, k);

		  for (k=0;k<3;k++)
		  {
			sample[j][k][i] = c % nlevels;
			c /= nlevels;
		  }
		}
	   }
	   else
	   {      /* for no sample transmitted */
		 for (k=0;k<3;k++) sample[j][k][i] = 0;
	   }
	 }
   }

   for (i = sblimit; i < SBLIMIT; i++)
	 for (j = 0; j < *n_ml_ch; j++)
		for (k = 0; k < 3; k++)
		   sample[j][k][i] = 0;
}

d1903 4
a1906 3
int SubBandSynthesis_test (double *bandPtr,
		      int channel,
		      long *samples)
d2001 6
a2006 6
void out_fifo_test(long pcm_sample[5][3][SBLIMIT],
	      int num,
	      frame_params *fr_ps,
	      int done,
	      FILE *outFile,
	      unsigned long *psampFrames)
d2031 1
a2151 3
/*******************************************************/
/* prediction corrected, Heiko Purnhagen 08-nov-94 */
/*******************************************************/
a2152 20
/* this is only a local function */
double predict (double pred_buf[2][8][36+PREDDEL], 
		frame_params *fr_ps,
		int sb, 
		int jj, 
		int j,
		int ch,
		int idx) 
{
  int i;
  double t;

  t = 0;
  for (i=0; i<fr_ps->header->mc_predsi[sb][idx]; i++)
    t += pred_buf[ch][sb][PREDDEL+3*jj+j-i-fr_ps->header->mc_delay_comp[sb][idx]]
      * (fr_ps->header->mc_pred_coeff[sb][idx][i] - 127) * STEP;
  return t;
}


d2158 1
a2158 3
			double dematrix2_filter_state[3],
			double pred_buf[2][8][36+PREDDEL])
			
d2215 1
a2215 85
		if( (fr_ps->header->mc_prediction_on & fr_ps->header->mc_prediction[k]) && (k < 8) )
		    switch(fr_ps->header->dyn_cross_mode[k])   /* if prediction on in sb */
		    {
			case 0: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1);
			    	pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2)
					 	         + predict(pred_buf,fr_ps,k,jj,j,1,3);
			    	pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,4)
						         + predict(pred_buf,fr_ps,k,jj,j,1,5);
				break;
			
			case 1: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1);
			    	pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2)
					 	         + predict(pred_buf,fr_ps,k,jj,j,1,3);
			    	break;
			
			case 2: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1);
			    	pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2)
						         + predict(pred_buf,fr_ps,k,jj,j,1,3);
				break;
			
			case 3: pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
					 	         + predict(pred_buf,fr_ps,k,jj,j,1,1);
			    	pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2)
						         + predict(pred_buf,fr_ps,k,jj,j,1,3);
				break;
			
			case 4: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1);
			    	break;
			
			case 5: pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
					 	         + predict(pred_buf,fr_ps,k,jj,j,1,1);
			    	break;
			
			case 6: pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
						         + predict(pred_buf,fr_ps,k,jj,j,1,1);
				break;

			case 8: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)
			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1);
				tmp_sample = predict(pred_buf,fr_ps,k,jj,j,0,2) + predict(pred_buf,fr_ps,k,jj,j,1,3);
			    	pcm_sample[3][k][j][jj] += tmp_sample;
				pcm_sample[4][k][j][jj] += tmp_sample;
			    	break;

			case 9: tmp_sample = predict(pred_buf,fr_ps,k,jj,j,0,0) + predict(pred_buf,fr_ps,k,jj,j,1,1);
				pcm_sample[2][k][j][jj] += tmp_sample;
				pcm_sample[3][k][j][jj] += tmp_sample;
			    	pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2)
						         + predict(pred_buf,fr_ps,k,jj,j,1,3);
				break;

		       case 10: tmp_sample = predict(pred_buf,fr_ps,k,jj,j,0,0) + predict(pred_buf,fr_ps,k,jj,j,1,1);
				pcm_sample[2][k][j][jj] += tmp_sample;
			    	pcm_sample[4][k][j][jj] += tmp_sample;
				pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2)
						         + predict(pred_buf,fr_ps,k,jj,j,1,3);
			    	break;

		       case 11: tmp_sample = predict(pred_buf,fr_ps,k,jj,j,0,0) + predict(pred_buf,fr_ps,k,jj,j,1,1);
				pcm_sample[2][k][j][jj] += tmp_sample;
				pcm_sample[3][k][j][jj] += tmp_sample;
			    	break;

		       case 12: tmp_sample = predict(pred_buf,fr_ps,k,jj,j,0,0) + predict(pred_buf,fr_ps,k,jj,j,1,1);
				pcm_sample[2][k][j][jj] += tmp_sample;
				pcm_sample[4][k][j][jj] += tmp_sample;
			    	break;

		       case 13: tmp_sample = predict(pred_buf,fr_ps,k,jj,j,0,0) + predict(pred_buf,fr_ps,k,jj,j,1,1);
				pcm_sample[3][k][j][jj] += tmp_sample;
				pcm_sample[4][k][j][jj] += tmp_sample;
			    	break;

		       case 14: tmp_sample = predict(pred_buf,fr_ps,k,jj,j,0,0) + predict(pred_buf,fr_ps,k,jj,j,1,1);
				pcm_sample[2][k][j][jj] += tmp_sample;
				pcm_sample[3][k][j][jj] += tmp_sample;
				pcm_sample[4][k][j][jj] += tmp_sample;
			    	break;					

		     }  /* switch prediction end */  

d2468 4
a2471 3
void dematricing_test(double pcm_sample[5][SBLIMIT][3][12], 
			frame_params *fr_ps, 
			double pred_buf[2][8][36+PREDDEL]) 
d2474 2
a2475 3
  double matr2;   /* matricing factor   */
  double matr3;   /* matricing factor   */
  int i, j, jj, k, tc_alloc, l, sbgr = 0 ;
a2476 3
  double tmp_sample;
  
  /* JMZ 09/03/1995 Multilingual */
d2479 4
a2482 1
  switch(info->dematrix_procedure)
d2484 11
a2494 21

	/* factors according to Committee Draft and telefax 10/20/93 */
	/* by E.Schroeder, DTB Hannover.  01/14/94, SR               */

	  case 0: matr1 = 2.42797851625;			    	/* factor for L and R   */
		  matr2 = 2 + 1.41632080078125;			    /* factor for C, Ls, Rs */
		  matr3 = matr2;	/* 09/03/1995 JMZ Multilingual */ /* factor for C, Ls, Rs */
		  break;
	  case 1: matr1 = 1.5 + (0.5 * 1.41632080078125);	/* factor for L, R      */
		  /* 6/21/95 Ralf Schwalbe corr. matr2/3 */
		  matr2 = 2 * (1.5 + 0.5 * (1.41632080078125));   /* Ls, Rs  */
		  matr3 = 1.41632080078125 * (1.5 + 0.5*(1.41632080078125));	/* factor for C         */
		  break;
	  case 2: matr1 = 2.42797851625;			    	/* factor for L and R   */
		  matr2 = 2 + 1.41632080078125;			    /* factor for C, Ls, Rs */
		  matr3 = matr2;
		  break;
	  case 3: matr1 = 1.0;
		  matr2 = 1.0;
		  matr3 = matr2;	/* 09/03/1995 JMZ Multilingual */ 
		  break;
d2497 8
a2504 15


/* denormalized signals */
	if( fr_ps->header->dematrix_procedure != 3 ) 		/* dematrixing */
	  for (jj=0; jj<12; jj++)
		for( j = 0; j < 3; ++j)
			for(k = 0; k < SBLIMIT; k ++)
			{   /* Lo / Ro */
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] * matr1;
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] * matr1;
				pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr1;
				pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr1;
				pcm_sample[4][k][j][jj] = pcm_sample[4][k][j][jj] * matr1;

			}
@


1.9.1.2
log
@Merged Distribution_06 and FTZ_05
@
text
@d4 1
a4 1
 * $Id: decode.c 1.9.1.1 1996/01/20 17:28:45 rowlands Exp $
a10 17
 * Revision 1.9.1.1  1996/01/20  17:28:45  rowlands
 * Received from Ralf Schwalbe - includes prediction
 *
 * Revision 1.9  1996/01/20  17:02:20  rowlands
 * Moved merged FTZ_04 and Philips_01 into main trunk
 *
 * Revision 1.8.3.2  1995/11/06  04:04:21  rowlands
 * Merged FTZ_04 and Philips_01
 *
 * Revision 1.8.3.1  1995/11/05  22:50:42  rowlands
 * Merged FTZ_04 and Philips_01 using #ifdefs
 *
 * Revision 1.7.1.3  1995/08/14  08:12:10  tenkate
 * ML-LSF added WtK 7/8/95
 * change "alloc" and "sblimit" into "allocml" and
 * "mlsblimit" where appropriate.
 *
d642 6
a647 4
void II_decode_bitalloc_ml(Bit_stream_struc *bs,
			   unsigned int bit_alloc_ml[5][SBLIMIT],	
			   frame_params *fr_ps,
			   int *m)
d649 5
a653 3
   int i,j;
   int mlsblimit = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;
d655 7
a661 4
   /* JR: no dynamic crosstalk for multilingual channels */
   /* JR: no phantom center coding for multilingual channels */
   /* JR: no joint coding for multilingual channels */
   /* JR: they're really simple, aren't they? */
d663 5
a667 6
   for (i=0;i<mlsblimit;i++)
    for (j=0;j<*m;j++) 
     bit_alloc_ml[j][i] = (char) getbits(bs,(*allocml)[i][0].bits);
   for (i=mlsblimit;i<SBLIMIT;i++) 
    for (j=0;j<*m;j++) 
     bit_alloc_ml[j][i] = 0;
d683 1
a683 1
/* JMZ 09/03/1995 Multilingual adaptations , WtK 7/8/95               */
a706 1
		else scfsi[j][i] = 4;
d712 1
a712 1
		scfsi[j][i] = 4;
d750 3
a752 3
			         scale_index[j][1][i] = getbits(bs,6);
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
d755 3
a757 3
				 scale_index[j][1][i] = getbits(bs,6);
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
d759 4
a762 4
			case 3 : scale_index[j][0][i] = getbits(bs,6);
				 scale_index[j][1][i] =
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
d765 4
a768 7
				 scale_index[j][1][i] =
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
			default : scale_index[j][0][i] =
				  scale_index[j][1][i] =
				  scale_index[j][2][i] = SCALE_RANGE-1;
				  break;
d787 1
a787 1
/* JMZ 15/03/1995 Multilingual                                        */
d790 7
a796 6
void II_decode_scale_ml(Bit_stream_struc *bs,
		        unsigned int scfsi[5][SBLIMIT], 		
		        unsigned int bit_alloc[5][SBLIMIT],	
		        unsigned int scale_index[5][3][SBLIMIT],	
		        frame_params *fr_ps,
		        int *m)
d800 2
a801 1
   int mlsblimit = fr_ps->mlsblimit;
d804 1
a804 1
   for (i=0;i<mlsblimit;i++) for (j=0;j<*m;j++)   /* 2 bit scfsi */
d808 1
d810 2
a811 3
	else scfsi[j][i] = 4;
   for (i=mlsblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++)
	scfsi[j][i] = 4;
d813 5
a817 1
   for (i = 0; i < mlsblimit; i++) for (j = 0; j < *m; j++) {
d819 1
a819 1
	    switch (scfsi[j][i]) {
d822 4
a825 3
			  scale_index[j][1][i] = getbits(bs,6);
			  scale_index[j][2][i] = getbits(bs,6);
			  break;
d828 10
a837 8
			  scale_index[j][1][i] = getbits(bs,6);
			  scale_index[j][2][i] = getbits(bs,6);
			  break;
	         /* scale factor 1 & 2 transmitted */
		 case 3 : scale_index[j][0][i] = getbits(bs,6);
			  scale_index[j][1][i] =
			  scale_index[j][2][i] = getbits(bs,6);
         		  break;
d839 10
a848 12
	         case 2 : scale_index[j][0][i] =
		          scale_index[j][1][i] =
		          scale_index[j][2][i] = getbits(bs,6);
         		  break;
		 default : scale_index[j][0][i] =
		           scale_index[j][1][i] =
		           scale_index[j][2][i] = SCALE_RANGE-1;
         		   break;
          }
          else {
                          scale_index[j][0][i] = scale_index[j][1][i] =
	                  scale_index[j][2][i] = SCALE_RANGE-1;
d851 3
a853 4

   for (i=mlsblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++) {
		          scale_index[j][0][i] = scale_index[j][1][i] =
		          scale_index[j][2][i] = SCALE_RANGE-1;
d949 1
d959 1
d988 1
a1063 62

/***************************************************************/
/* 09/03/1995 JMZ Multilingual */

/***************************************************************/
/* 15/03/1995 JMZ */

void II_buffer_sample_ml(Bit_stream_struc *bs,
			 unsigned int sample_ml[5][3][SBLIMIT],
			 unsigned int bit_alloc_ml[5][SBLIMIT],
			 frame_params *fr_ps,
			 int *n_ml_ch)
{
   int i,j,k,m,sbgr,l;
   unsigned int nlevels, c=0;
   int mlsblimit = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;

   for (i = 0; i < mlsblimit; i++)
   {
	 for (j = 0; j < *n_ml_ch; j++)
	 {
	   if (bit_alloc_ml[j][i])
	   {
		/* JR: no dynamic crosstalk for multilingual channels */
		/* check for grouping in subband */
		if ((*allocml)[i][bit_alloc_ml[j][i]].group==3)
		{

			for (m=0;m<3;m++)
			{
				k = (*allocml)[i][bit_alloc_ml[j][i]].bits;
				sample_ml[j][m][i] = (unsigned int) getbits(bs,k);
			}

		}
		else
		{    /* bit_alloc = 3, 5, 9 */
		  nlevels = (*allocml)[i][bit_alloc_ml[j][i]].steps;
		  k=(*allocml)[i][bit_alloc_ml[j][i]].bits;
		  c = (unsigned int) getbits(bs, k);

		  for (k=0;k<3;k++)
		  {
			sample_ml[j][k][i] = c % nlevels;
			c /= nlevels;
		  }
		}
	   }
	   else
	   {      /* for no sample transmitted */
		 for (k=0;k<3;k++) sample_ml[j][k][i] = 0;
	   }
	 }
   }

   for (i = mlsblimit; i < SBLIMIT; i++)
	 for (j = 0; j < *n_ml_ch; j++)
		for (k = 0; k < 3; k++)
		   sample_ml[j][k][i] = 0;
}

d1149 1
a1164 1
		  /* locate MSB in the sample */
a1266 52
/*************************************************************************/
/* JMZ 09/03/1995 Multilingual */

void II_dequantize_sample_ml(unsigned int sample_ml[5][3][SBLIMIT],
			     unsigned int bit_alloc_ml[5][SBLIMIT],
			     double fraction_ml[5][SBLIMIT][3][12],
			     frame_params *fr_ps,
			     int *n_ml_ch,
			     int *z)
{
   int i, j, k, x,sbgr,l;
   int mlsblimit = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;

   for (i = 0; i < mlsblimit; i++)
   {
	  for (j = 0; j < 3; j++)
		 for ( k = 0; k < *n_ml_ch; k++)
			if (bit_alloc_ml[k][i])
			{
			  /* JR: ditto */
			  /* locate MSB in the sample */
			   x = 0;
#ifndef MSDOS
			   while ((1L<<x) < (*allocml)[i][bit_alloc_ml[k][i]].steps) x++;
#else
			   /* microsoft C thinks an int is a short */
			   while (( (unsigned long) (1L<<(long)x) <
				(unsigned long)( (*allocml)[i][bit_alloc_ml[k][i]].steps)
			   ) && ( x < 16) ) x++;
#endif
			   /* MSB inversion */
			   if (((sample_ml[k][j][i] >> (x-1)) & 1) == 1)
					fraction_ml[k][i][j][*z] = 0.0;
			   else  fraction_ml[k][i][j][*z] = -1.0;

			   /* Form a 2's complement sample */
			   fraction_ml[k][i][j][*z] += (double) (sample_ml[k][j][i] & ((1<<(x-1))-1)) /
							(double) (1L<<(x-1));

			   /* Dequantize the sample */
			   fraction_ml[k][i][j][*z] += d[(*allocml)[i][bit_alloc_ml[k][i]].quant];
			   fraction_ml[k][i][j][*z] *= c[(*allocml)[i][bit_alloc_ml[k][i]].quant];
			} /* if bit_alloc */
			else fraction_ml[k][i][j][*z] = 0.0;
   }
   for (i = mlsblimit; i < SBLIMIT; i++)
	  for (j = 0; j < 3; j++)
		 for(k = 0; k < *n_ml_ch; k++)
			 fraction_ml[k][i][j][*z] = 0.0;
}

d1303 1
d1464 1
a1464 1

d1527 1
a1527 1

d1550 1
a1550 1

d1572 1
d1671 11
a1681 6
void II_denormalize_sample_ml(double fraction_ml[5][SBLIMIT][3][12],
			      unsigned int scale_index_ml[5][3][SBLIMIT],
			      frame_params *fr_ps,
			      int x,
			      int *n_ml_ch,
			      int *z)
d1683 3
a1685 2
   int i,j;
   int mlsblimit = fr_ps->mlsblimit;
d1687 36
a1722 7
   for (i = 0; i < mlsblimit; i++)
    for (j = 0; j < *n_ml_ch; j++)
     {
       fraction_ml[j][i][0][*z] *= multiple[scale_index_ml[j][x][i]];
       fraction_ml[j][i][1][*z] *= multiple[scale_index_ml[j][x][i]];
       fraction_ml[j][i][2][*z] *= multiple[scale_index_ml[j][x][i]];
     }
d1725 80
d1934 3
a1936 3
int SubBandSynthesis_ml (double *bandPtr,
		         int channel,
		         long *samples)
d2031 6
a2036 6
void out_fifo_ml(long pcm_sample[5][3][SBLIMIT],
	         int num,
	         frame_params *fr_ps,
	         int done,
	         FILE *outFile,
	         unsigned long *psampFrames)
d2212 1
d2605 4
a2608 4
/* JMZ 09/03/1995 Multilingual , WtK 7/8/95 */
void dematricing_ml(double pcm_sample_ml[5][SBLIMIT][3][12], 
		    frame_params *fr_ps) 
/* unweighting the signals */		    
d2611 3
a2613 2
  int i, j, jj, k;

d2615 3
d2620 1
a2620 4
  int lsf     = info->multi_lingual_fs;
  int encoder_weights_ml = 0;
  
  switch(info->dematrix_procedure) /* ######## */
d2622 21
a2642 11
    /* factors according to Committee Draft and telefax 10/20/93 */
    /* by E.Schroeder, DTB Hannover.  01/14/94, SR               */
   
      case 0: matr1 = 2.42797851625;
	      break;
      case 1: matr1 = 1.5 + (0.5 * 1.41632080078125);
	      break;
      case 2: matr1 = 2.42797851625;
	      break;
      case 3: matr1 = 1.0;
	      break;
d2645 15
a2659 8
/* no weighting is occurring in encoder; so skip the unweighting ! */
if (encoder_weights_ml) 
 if( fr_ps->header->dematrix_procedure != 3 )
    for (jj=0;jj<( (lsf==0) ? 12 : 6 );jj++)
      for (j=0;j<3;++j)
	for (i=0;i<SBLIMIT;i++)
	  for (k=0;k<n_ml_ch;k++)
	    pcm_sample_ml[k][i][j][jj] *= matr1;
d2661 4
@


1.9.1.3
log
@Fixed bug in dynamic crosstalk for 3/1 configuration.
@
text
@d4 1
a4 1
 * $Id: decode.c 1.9.1.2 1996/01/20 20:11:31 rowlands Exp rowlands $
a10 3
 * Revision 1.9.1.2  1996/01/20  20:11:31  rowlands
 * Merged Distribution_06 and FTZ_05
 *
d480 13
a492 9
			    if(info.dyn_cross_mode[sbgr] == 2 || info.dyn_cross_mode[sbgr] == 3 )
			    { /* T2 not transmitted */
				if (
					fr_ps->header->tc_alloc[sbgr] == 2 ||
					fr_ps->header->tc_alloc[sbgr] != 1 && fr_ps->header->dyn_cross_LR
				) /* C from R0 */
					bit_alloc[2][i] = bit_alloc[1][i];
				else	/* C from LO */
					bit_alloc[2][i] = bit_alloc[0][i];
d495 16
a510 11
			    	bit_alloc[2][i] = (char) getbits(bs,(*alloc)[i][0].bits);

			    if(info.dyn_cross_mode[sbgr] == 1 || info.dyn_cross_mode[sbgr] == 3 )
			    { /* T3 not transmitted */
				if (
					fr_ps->header->tc_alloc[sbgr] == 4 ||
					fr_ps->header->tc_alloc[sbgr] != 3 && fr_ps->header->dyn_cross_LR
				) /* S from R0 */
					bit_alloc[3][i] = bit_alloc[1][i];
				else	/* S from LO */
					bit_alloc[3][i] = bit_alloc[0][i];
a511 2
			    else
			    	bit_alloc[3][i] = (char) getbits(bs,(*alloc)[i][0].bits);
d987 8
a994 23
		   if(	/* test if this channel is transmitted in this dyn_cross_mode */
			(fr_ps->header->dyn_cross_mode[sbgr]==0) ||
			fr_ps->dyn_cross_bits == 4 && (
				(fr_ps->header->dyn_cross_mode[sbgr]==1  && j!=4) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==2  && j!=3) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==3  && j!=2) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==4  && j==2) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==5  && j==3) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==6  && j==4) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==8  && j!=4) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==9  && j!=3) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==10 && j!=4) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==11 && j==2) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==12 && j==2) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==13 && j==3) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==14 && j==2)
			) ||
			fr_ps->dyn_cross_bits == 3 && (
				(fr_ps->header->dyn_cross_mode[sbgr]==1  && j==2) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==2  && j==3) ||
				(fr_ps->header->dyn_cross_mode[sbgr]==4  && j==2)
			)
		   )
d1015 44
a1058 1
		   }
d1503 1
a1503 4
					    if (
						fr_ps->header->tc_alloc[sbgr] == 4 ||
						fr_ps->header->tc_alloc[sbgr] != 3 && fr_ps->header->dyn_cross_LR
					    ) /* S from R0 */
d1509 1
d1547 5
a1551 5
					fraction[3][i][bl][*z] = fraction[3][i][bl][*z] * multiple[scale_index[3][x][i]];
					if (
						fr_ps->header->tc_alloc[sbgr] == 2 ||
						fr_ps->header->tc_alloc[sbgr] != 1 && fr_ps->header->dyn_cross_LR
					) /* C from R0 */
d1553 8
a1560 4
							  * multiple[scale_index[2][x][i]];
					else	/* C from LO */
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
							  * multiple[scale_index[2][x][i]];
a1572 1
					else
d1589 8
a1596 4
					if (
						fr_ps->header->tc_alloc[sbgr] == 2 ||
						fr_ps->header->tc_alloc[sbgr] != 1 && fr_ps->header->dyn_cross_LR
					) /* C from R0 */
d1602 3
a1604 10

					if (
						fr_ps->header->tc_alloc[sbgr] == 4 ||
						fr_ps->header->tc_alloc[sbgr] != 3 && fr_ps->header->dyn_cross_LR
					) /* S from R0 */
						fraction[3][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								   	   * multiple[scale_index[3][x][i]];
					    else     /* S from L0 */
						fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								   	   * multiple[scale_index[3][x][i]];
a1635 1
					else
a1658 1
					else
a1680 1
					else
@


1.9.1.4
log
@Fixed problem with dynamic crosstalk in 2/2 configuration
@
text
@d4 1
a4 1
 * $Id: decode.c 1.9.1.3 1996/01/21 08:18:13 rowlands Exp rowlands $
a10 3
 * Revision 1.9.1.3  1996/01/21  08:18:13  rowlands
 * Fixed bug in dynamic crosstalk for 3/1 configuration.
 *
d483 1
a483 3
			    if(info.dyn_cross_mode[sbgr] == 1)
			    	bit_alloc[2][i] = (char) getbits(bs,(*alloc)[i][0].bits);
			    else
d486 6
a491 7
		/* 2/2 mode */		fr_ps->header->surround == 2 ||
		/* 3/1 mode */		fr_ps->header->tc_alloc[sbgr] == 1 ||
					fr_ps->header->tc_alloc[sbgr] != 2 && !fr_ps->header->dyn_cross_LR
				)
					bit_alloc[2][i] = bit_alloc[0][i];	/* C, L or Ls from L0 */
				else
					bit_alloc[2][i] = bit_alloc[1][i];	/* C, R or Rs from RO */
d493 2
d496 1
a496 3
			    if(info.dyn_cross_mode[sbgr] == 2)
			    	bit_alloc[3][i] = (char) getbits(bs,(*alloc)[i][0].bits);
			    else
d499 1
a499 2
		/* 2/2 mode */		fr_ps->header->surround == 2 ||
		/* 3/1 mode */		fr_ps->header->tc_alloc[sbgr] == 4 ||
d501 4
a504 4
				)
					bit_alloc[3][i] = bit_alloc[1][i];	/* S, R or Rs from R0 */
				else
					bit_alloc[3][i] = bit_alloc[0][i];	/* S, L or Ls from LO */
d506 2
d510 1
a510 1
		     else
d1444 1
a1444 1
	else
d1472 1
a1472 2
			/* 2/2 mode */		fr_ps->header->surround == 2 ||
			/* 3/1 mode */		fr_ps->header->tc_alloc[sbgr] == 4 ||
d1474 1
a1474 1
					    ) /* S, R or Rs from R0 */
d1477 1
a1477 1
					    else     /* S, L or Ls from L0 */
d1519 6
a1524 4
			/* 2/2 mode */		fr_ps->header->surround == 2 ||
			/* 3/1 mode */		fr_ps->header->tc_alloc[sbgr] == 1 ||
						fr_ps->header->tc_alloc[sbgr] != 2 && !fr_ps->header->dyn_cross_LR
					) /* C, L or Ls from L0 */
a1526 3
					else	/* C, R or Rs from RO */
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
							  * multiple[scale_index[2][x][i]];
d1557 6
a1562 4
			/* 2/2 mode */		fr_ps->header->surround == 2 ||
			/* 3/1 mode */		fr_ps->header->tc_alloc[sbgr] == 1 ||
						fr_ps->header->tc_alloc[sbgr] != 2 && !fr_ps->header->dyn_cross_LR
					) /* C, L or Ls from L0 */
a1564 3
						else	/* C, R or Rs from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
d1567 1
a1567 2
			/* 2/2 mode */		fr_ps->header->surround == 2 ||
			/* 3/1 mode */		fr_ps->header->tc_alloc[sbgr] == 4 ||
d1569 1
a1569 1
					) /* S, R or Rs from R0 */
d1572 1
a1572 1
					    else     /* S, L or Ls from L0 */
@


1.8
log
@Distribution_06 base
@
text
@d4 1
a4 1
 * $Id: decode.c 1.7.1.2 1995/07/14 06:17:20 rowlands Exp $
d11 11
d184 8
d296 4
a299 6
	if( mc_channel == 1)
		hdr->tc_allocation = getbits(bs,2);
	else
		hdr->tc_allocation = getbits(bs,3);/* tc_allocation is valid for */
		for(sbgr = 0; sbgr < 12; sbgr++)   /* all sbgr R.S. */
			hdr->tc_alloc[sbgr] = hdr->tc_allocation;
d304 2
a305 6
	if( mc_channel == 1)
		for(sbgr = 0; sbgr < 12; sbgr++)
			hdr->tc_alloc[sbgr] = getbits(bs, 2);
	else
		for(sbgr = 0; sbgr < 12; sbgr++)
			hdr->tc_alloc[sbgr] = getbits(bs, 3);
d312 1
a312 1
			hdr->dyn_cross_mode[sbgr] = getbits(bs,4 /*##### fix this */);
d319 1
d407 4
a410 1
 
d449 2
a450 2
	   case 10:  
 		      for (j = *l; j < *m ; j++)
d452 57
d552 9
a560 3
 	   case 14:   
		      if((fr_ps->header->center != 3) || (i < 12) || (j !=2))
		      {
d628 2
a629 1
		     }
d651 4
a654 6
/************15/03/1995 TEST**********/
void II_decode_bitalloc_test(Bit_stream_struc *bs,
			unsigned int bit_alloc[5][SBLIMIT],	
			frame_params *fr_ps,
			int *l,
			int *m  )
d656 3
a658 5
   int i,j,c,sbgr;
   /* int stereo = fr_ps->stereo; */ /* not used for mc - decoding */
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;
d660 4
a663 7
   for (i=0;i<jsbound;i++)
/* JR: no dynamic crosstalk for multilingual channels */
	for (j=0;j<*m;j++)
	{
		/* JR: no phantom center coding for multilingual channels */
	 	bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);
	}
d665 6
a670 5
/* JR: no joint coding for multilingual channels */
/* JR: they're really simple, aren't they? */

   for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++)
	  bit_alloc[j][i] = 0;
d686 1
a686 1
/* JMZ 09/03/1995 Multilingual adaptations */
d710 1
d716 1
a716 1
		scfsi[j][i] = 0;
d719 4
a725 1
	
d734 3
a736 3
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);
				  break;
d739 3
a741 3
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);
				  break;
d743 4
a746 4
			case 3 :scale_index[j][0][i] = getbits(bs,6);
				scale_index[j][1][i] =
				scale_index[j][2][i] =  getbits(bs,6);
				break;
d749 7
a755 4
				scale_index[j][1][i] =
				scale_index[j][2][i] = getbits(bs,6);
				break;
			default : break;
d774 1
a774 1
/* JMZ 15/03/1995 Multilingual TEST */
d777 6
a782 7
void II_decode_scale_test(Bit_stream_struc *bs,
		     unsigned int scfsi[5][SBLIMIT], 		
		     unsigned int bit_alloc[5][SBLIMIT],	
		     unsigned int scale_index[5][3][SBLIMIT],	
		     frame_params *fr_ps,
		     int *l, 
		     int *m)
d786 1
a786 2
   /* int stereo  = fr_ps->stereo; */ /* not used for mc - decoding */
   int sblimit = fr_ps->sblimit;
d789 1
a789 1
   for (i=0;i<sblimit;i++) for (j=0;j<*m;j++)   /* 2 bit scfsi */
a792 1

d794 3
a796 2
	 for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++)
		scfsi[j][i] = 0;
d798 1
a798 5

   /* 3.6.94 R.S. read the prediction coefficients in the mc - part */
   /* R.S. not included in Shareware */
	
   for (i = 0; i < sblimit; i++) for (j = 0; j < *m; j++) {
d800 1
a800 1
	  switch (scfsi[j][i]) {
d803 3
a805 4
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);

				  break;
d808 8
a815 10
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);

				  break;
	 /* scale factor 1 & 2 transmitted */
		case 3 :scale_index[j][0][i] = getbits(bs,6);
				scale_index[j][1][i] =
				scale_index[j][2][i] =  getbits(bs,6);

		  break;
d817 12
a828 10
	 case 2 : scale_index[j][0][i] =
		  scale_index[j][1][i] =
		  scale_index[j][2][i] = getbits(bs,6);

		  break;
		 default : break;
      }
      else {
	 scale_index[j][0][i] = scale_index[j][1][i] =
	 scale_index[j][2][i] = SCALE_RANGE-1;
d831 4
a834 3
   for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++) {
		 scale_index[j][0][i] = scale_index[j][1][i] =
		 scale_index[j][2][i] = SCALE_RANGE-1;
d909 2
a910 1
			int *mc_ch)
d916 1
d918 4
d932 1
a932 1
	 for (j = 2; j < *mc_ch; j++)
d960 1
a960 1
		 else       /* 6/21/95 Ralf Schwalbe dyn. crosstalk mode on */
d962 8
a969 8
		   if((fr_ps->header->dyn_cross_mode[sbgr]==0) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==1  && j!=4) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==2  && j!=3) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==3  && j!=2) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==8  && j!=4) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==9  && j!=3) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==10 && j!=4)) 
		  
d992 8
a999 7
		   if((fr_ps->header->dyn_cross_mode[sbgr]==4  && j==2) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==5  && j==3) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==6  && j==4) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==11 && j==2) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==12 && j==2) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==13 && j==3) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==14 && j==2)) 
d1001 2
a1002 1
			if ((*alloc)[i][bit_alloc[j][i]].group==3)
d1004 11
d1020 3
a1022 3
			}
			else
			{    /* bit_alloc = 3, 5, 9 */
d1031 2
a1032 1
			}
d1042 1
a1042 1
	 for (j = 2; j < *mc_ch; j++)
a1045 1

d1050 1
a1050 1
/* 15/03/1995 JMZ TEST */
d1052 5
a1056 5
void II_buffer_sample_test(Bit_stream_struc *bs,
			unsigned int sample[5][3][SBLIMIT],
			unsigned int bit_alloc[5][SBLIMIT],
			frame_params *fr_ps,
			int *n_ml_ch)
d1060 2
a1061 2
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;
d1063 1
a1063 1
   for (i = 0; i < sblimit; i++)
d1067 1
a1067 1
	   if (bit_alloc[j][i])
d1071 1
a1071 1
		if ((*alloc)[i][bit_alloc[j][i]].group==3)
d1076 2
a1077 2
				k = (*alloc)[i][bit_alloc[j][i]].bits;
				sample[j][m][i] = (unsigned int) getbits(bs,k);
d1083 2
a1084 2
		  nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
		  k=(*alloc)[i][bit_alloc[j][i]].bits;
d1089 1
a1089 1
			sample[j][k][i] = c % nlevels;
d1096 1
a1096 1
		 for (k=0;k<3;k++) sample[j][k][i] = 0;
d1101 1
a1101 1
   for (i = sblimit; i < SBLIMIT; i++)
d1104 1
a1104 1
		   sample[j][k][i] = 0;
d1192 1
d1196 9
a1204 9
	  if( i == 0) sbgr = 0 ;
	  else
		for(l = 1; l < 12; l++)
			if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
			{
				sbgr = l; break;
			}
	  for (j = 0; j < 3; j++)
	   for ( k = 2; k < *mc_ch; k++)
d1216 1
a1216 2
			(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)
		   ) && ( x < 16) ) x++;
d1220 1
a1220 1
				fraction[k][i][j][*z] = 0.0;
d1231 1
a1231 1
		  else   /* 6/21/95 Ralf Schwalbe dyn. crosstalk mode */
d1233 8
a1240 7
		   if((fr_ps->header->dyn_cross_mode[sbgr]==0) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==1  && k!=4) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==2  && k!=3) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==3  && k!=2) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==8  && k!=4) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==9  && k!=3) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==10 && k!=4)) 
d1264 8
a1271 7
		   if((fr_ps->header->dyn_cross_mode[sbgr]==4  && k==2) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==5  && k==3) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==6  && k==4) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==11 && k==2) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==12 && k==2) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==13 && k==3) ||
		      (fr_ps->header->dyn_cross_mode[sbgr]==14 && k==2)) 
d1273 7
d1300 1
d1308 1
a1308 1
		 for(k = 2; k < *mc_ch; k++)
d1316 6
a1321 6
void II_dequantize_sample_test(unsigned int sample[5][3][SBLIMIT],
			    unsigned int bit_alloc[5][SBLIMIT],
			    double fraction[5][SBLIMIT][3][12],
			    frame_params *fr_ps,
			    int *n_ml_ch,
			    int *z)
d1324 2
a1325 2
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;
d1327 1
a1327 1
   for (i = 0; i < sblimit; i++)
d1331 1
a1331 1
			if (bit_alloc[k][i])
d1337 1
a1337 1
			   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
d1341 1
a1341 1
				(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)
d1345 3
a1347 3
			   if (((sample[k][j][i] >> (x-1)) & 1) == 1)
					fraction[k][i][j][*z] = 0.0;
			   else  fraction[k][i][j][*z] = -1.0;
d1350 1
a1350 1
			   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
d1354 2
a1355 2
			   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
			   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
d1357 1
a1357 1
			else fraction[k][i][j][*z] = 0.0;
d1359 1
a1359 1
   for (i = sblimit; i < SBLIMIT; i++)
d1362 1
a1362 1
			 fraction[k][i][j][*z] = 0.0;
d1365 38
d1440 1
d1445 6
a1450 6
	  else
		for(l = 1; l < 12; l++)
			if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
			{
				sbgr = l; break;
			}
d1452 1
a1452 1
		for (j = 2; j < *mc_ch; j++)
a1457 1
	/* 7/12/95 Ralf Schwalbe dyn. crosstalk mode */
d1461 1
a1461 1
		  case 0 : 	for (j = 2; j < *mc_ch; j++)
d1473 2
d1479 16
d1502 2
d1508 18
d1532 3
a1534 1
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7)) /* L from L0 */
d1537 1
a1537 1
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6)) /* R from R0 */
d1550 20
d1577 2
d1584 7
d1597 1
a1597 1
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7)) /* L from L0 */
d1600 1
a1600 1
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6)) /* R from R0 */
d1620 1
a1620 1
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7)) /* L from L0 */
d1623 1
a1623 1
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6)) /* R from R0 */
d1642 1
a1642 1
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7)) /* L from L0 */
d1645 1
a1645 1
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6)) /* R from R0 */
d1737 1
d1739 4
a1742 1
					fraction[3][i][bl][*z]  = fraction[2][i][bl][*z];
a1744 2
					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];
a1751 1

d1755 6
a1760 9
/*************************************************************/
/* JMZ 15/03/1995 TEST */

void II_denormalize_sample_test(double fraction[5][SBLIMIT][3][12],
			     unsigned int scale_index[5][3][SBLIMIT],
			     frame_params *fr_ps,
			     int x,
			     int *n_ml_ch,
			     int *z)
d1762 2
a1763 2
   int i,j,k,sbgr,l,bl=0;
   int sblimit = fr_ps->sblimit;
d1765 7
a1771 12
   for (i = 0; i < sblimit; i++)
   {
	if(fr_ps->header->dyn_cross_on == 0)
		for (j = 0; j < *n_ml_ch; j++)
		{
			fraction[j][i][0][*z] *= multiple[scale_index[j][x][i]];
			fraction[j][i][1][*z] *= multiple[scale_index[j][x][i]];
			fraction[j][i][2][*z] *= multiple[scale_index[j][x][i]];
		}
	/************** R.S. ***************/
 
   } /* for sblimit */
d1903 4
a1906 3
int SubBandSynthesis_test (double *bandPtr,
		      int channel,
		      long *samples)
d2001 6
a2006 6
void out_fifo_test(long pcm_sample[5][3][SBLIMIT],
	      int num,
	      frame_params *fr_ps,
	      int done,
	      FILE *outFile,
	      unsigned long *psampFrames)
d2158 1
a2158 2
			double dematrix2_filter_state[3],
			double pred_buf[2][8][36+PREDDEL]) 
d2468 4
a2471 3
void dematricing_test(double pcm_sample[5][SBLIMIT][3][12], 
			frame_params *fr_ps, 
			double pred_buf[2][8][36+PREDDEL]) 
d2474 2
a2475 3
  double matr2;   /* matricing factor   */
  double matr3;   /* matricing factor   */
  int i, j, jj, k, tc_alloc, l, sbgr = 0 ;
a2476 3
  double tmp_sample;
  
  /* JMZ 09/03/1995 Multilingual */
d2479 4
a2482 1
  switch(info->dematrix_procedure)
d2484 11
a2494 21

	/* factors according to Committee Draft and telefax 10/20/93 */
	/* by E.Schroeder, DTB Hannover.  01/14/94, SR               */

	  case 0: matr1 = 2.42797851625;			    	/* factor for L and R   */
		  matr2 = 2 + 1.41632080078125;			    /* factor for C, Ls, Rs */
		  matr3 = matr2;	/* 09/03/1995 JMZ Multilingual */ /* factor for C, Ls, Rs */
		  break;
	  case 1: matr1 = 1.5 + (0.5 * 1.41632080078125);	/* factor for L, R      */
		  /* 6/21/95 Ralf Schwalbe corr. matr2/3 */
		  matr2 = 2 * (1.5 + 0.5 * (1.41632080078125));   /* Ls, Rs  */
		  matr3 = 1.41632080078125 * (1.5 + 0.5*(1.41632080078125));	/* factor for C         */
		  break;
	  case 2: matr1 = 2.42797851625;			    	/* factor for L and R   */
		  matr2 = 2 + 1.41632080078125;			    /* factor for C, Ls, Rs */
		  matr3 = matr2;
		  break;
	  case 3: matr1 = 1.0;
		  matr2 = 1.0;
		  matr3 = matr2;	/* 09/03/1995 JMZ Multilingual */ 
		  break;
d2497 8
a2504 15


/* denormalized signals */
	if( fr_ps->header->dematrix_procedure != 3 ) 		/* dematrixing */
	  for (jj=0; jj<12; jj++)
		for( j = 0; j < 3; ++j)
			for(k = 0; k < SBLIMIT; k ++)
			{   /* Lo / Ro */
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] * matr1;
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] * matr1;
				pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr1;
				pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr1;
				pcm_sample[4][k][j][jj] = pcm_sample[4][k][j][jj] * matr1;

			}
@


1.8.3.0
log
@Branch for merging FTZ_04 and Philips_01
@
text
@d4 1
a4 1
 * $Id: decode.c 1.8 1995/11/05 17:42:05 rowlands Exp $
a10 3
 * Revision 1.8  1995/11/05  17:42:05  rowlands
 * Distribution_06 base
 *
@


1.8.3.1
log
@Merged FTZ_04 and Philips_01 using #ifdefs
@
text
@d4 1
a4 1
 * $Id: decode.c,v 1.7.1.3 1995/08/14 08:12:10 tenkate Exp $
d10 3
a12 5
 * $Log: decode.c,v $
 * Revision 1.7.1.3  1995/08/14  08:12:10  tenkate
 * ML-LSF added WtK 7/8/95
 * change "alloc" and "sblimit" into "allocml" and
 * "mlsblimit" where appropriate.
a175 10
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
 *		  						      *
 * 10/31/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin	      *
 *		    - decoding of LFE-channel is working  	      *
 *		    - corrected any settings and bugs		      *
 *		    - corrected table-switch for channel mode < 3/2   *
 *		      and tc-allocation / dyn-crosstalk		      *
 *		    - still a problem with compl. bitstream 18/19     *
 *								      *	
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a279 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a285 6
#elif	defined(DIFF_2)				/* =========================== */
	hdr->tc_allocation = getbits(bs,fr_ps->alloc_bits);
	/* tc_allocation is valid for all sbgr R.S. */
	for(sbgr = 0; sbgr < 12; sbgr++)   
		hdr->tc_alloc[sbgr] = hdr->tc_allocation;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a289 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a295 4
#elif	defined(DIFF_2)				/* =========================== */
	for(sbgr = 0; sbgr < 12; sbgr++)
		hdr->tc_alloc[sbgr] = getbits(bs,fr_ps->alloc_bits);
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a301 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a302 3
#elif	defined(DIFF_2)				/* =========================== */
			hdr->dyn_cross_mode[sbgr] = getbits(bs,fr_ps->dyn_cross_bits);
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a308 3
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
if(hdr->mc_prediction_on)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a395 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a396 6
#elif	defined(DIFF_2)				/* =========================== */
   /* 10/31/95 Ralf Schwalbe LFE */
   if(info.lfe)
	info.lfe_alloc = (char) getbits(bs,(*alloc)[0][0].bits);

#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a434 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a436 3
#elif	defined(DIFF_2)				/* =========================== */
	   case 10:  /* 19.10.95 R.S. switch to the right channel conf. table */
		     if(fr_ps->dyn_cross_bits != 4)
a437 58
			if(fr_ps->dyn_cross_bits == 1)   /* for channel mode 3/0 and 2/1 */
			{
			    if(info.center == 1)    /* 3/0 */
			    {
			    if((info.tc_alloc[sbgr] == 1) || (info.tc_alloc[sbgr] == 7))
				bit_alloc[2][i] = bit_alloc[0][i];
			    if((info.tc_alloc[sbgr] == 2) || (info.tc_alloc[sbgr] == 6))
				bit_alloc[2][i] = bit_alloc[1][i];
			    else
				if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
				else	bit_alloc[2][i] = bit_alloc[0][i];
			    }
			    else   /* 2/1 */
			    {
				if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
				else	bit_alloc[2][i] = bit_alloc[0][i];
			    }
			}
			if(fr_ps->dyn_cross_bits == 3)   /* for channel mode 3/1 and 2/2 */
			{
			    if(info.dyn_cross_mode[sbgr] == 3)
			    {
   			    	if((info.tc_alloc[sbgr] == 1) || (info.tc_alloc[sbgr] == 7))
				    bit_alloc[2][i] = bit_alloc[0][i];
			    	if((info.tc_alloc[sbgr] == 2) || (info.tc_alloc[sbgr] == 6))
				    bit_alloc[2][i] = bit_alloc[1][i];
			    	else
				    if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
					else	bit_alloc[2][i] = bit_alloc[0][i];

				if(info.dyn_cross_LR)  bit_alloc[3][i] = bit_alloc[1][i];
					else	bit_alloc[3][i] = bit_alloc[0][i];
			    	
			    }
			    else
			    {
			    	bit_alloc[2][i] = (char) getbits(bs,(*alloc)[i][0].bits); 
			    	if(info.dyn_cross_mode[sbgr] == 1)  
					if(info.dyn_cross_LR)  bit_alloc[3][i] = bit_alloc[1][i];
					else	bit_alloc[3][i] = bit_alloc[0][i];
			    	if(info.dyn_cross_mode[sbgr] == 2) 
			    	{
			    	    bit_alloc[3][i] = bit_alloc[2][i];
			    	    if((info.tc_alloc[sbgr] == 1) || (info.tc_alloc[sbgr] == 7))
				        bit_alloc[2][i] = bit_alloc[0][i];
			    	    if((info.tc_alloc[sbgr] == 2) || (info.tc_alloc[sbgr] == 6))
				    	bit_alloc[2][i] = bit_alloc[1][i];
			    	    else
				    	if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
					    else    bit_alloc[2][i] = bit_alloc[0][i];
			    	}
			    }
			} 
		     }
		     else	
		     for (j = *l; j < *m ; j++)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
		     {
a480 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a483 11
#elif	defined(DIFF_2)				/* =========================== */
 	   case 14:  j = 2;  /* for phantom center R.S. */
		     if(fr_ps->dyn_cross_bits == 3)
		     {
			bit_alloc[2][i] = (char) getbits(bs,(*alloc)[i][0].bits);
			bit_alloc[3][i] = bit_alloc[2][i];
		     }
		     else
		     if((fr_ps->header->center != 3) || (i < 12) || (j !=2))
		     {
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a550 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a551 4
#elif	defined(DIFF_2)				/* =========================== */
		     } 
		      break;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a572 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a578 6
#elif	defined(DIFF_3)				/* =========================== */
void II_decode_bitalloc_ml(Bit_stream_struc *bs,
			   unsigned int bit_alloc_ml[5][SBLIMIT],	
			   frame_params *fr_ps,
			   int *m)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a579 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a595 5
#elif	defined(DIFF_3)				/* =========================== */
   int i,j;
   int mlsblimit = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a596 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a598 13
#elif	defined(DIFF_3)				/* =========================== */
   /* JR: no dynamic crosstalk for multilingual channels */
   /* JR: no phantom center coding for multilingual channels */
   /* JR: no joint coding for multilingual channels */
   /* JR: they're really simple, aren't they? */

   for (i=0;i<mlsblimit;i++)
    for (j=0;j<*m;j++) 
     bit_alloc_ml[j][i] = (char) getbits(bs,(*allocml)[i][0].bits);
   for (i=mlsblimit;i<SBLIMIT;i++) 
    for (j=0;j<*m;j++) 
     bit_alloc_ml[j][i] = 0;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a613 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a614 3
#elif	defined(DIFF_3)				/* =========================== */
/* JMZ 09/03/1995 Multilingual adaptations , WtK 7/8/95               */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a637 3
#if	defined(DIFF_3)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
		else scfsi[j][i] = 4;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a642 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a643 3
#elif	defined(DIFF_3)				/* =========================== */
		scfsi[j][i] = 4;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a644 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a645 6
#elif	defined(DIFF_2)				/* =========================== */
    /* 31/10/95 Ralf Schwalbe LFE */
    if(info.lfe)
      if(info.lfe_alloc)
	info.lfe_scf = getbits(bs,6);
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a648 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a649 1
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a657 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a660 5
#elif	defined(DIFF_3)				/* =========================== */
			         scale_index[j][1][i] = getbits(bs,6);
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a662 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a665 5
#elif	defined(DIFF_3)				/* =========================== */
				 scale_index[j][1][i] = getbits(bs,6);
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a666 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a670 6
#elif	defined(DIFF_3)				/* =========================== */
			case 3 : scale_index[j][0][i] = getbits(bs,6);
				 scale_index[j][1][i] =
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a672 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a676 9
#elif	defined(DIFF_3)				/* =========================== */
				 scale_index[j][1][i] =
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
			default : scale_index[j][0][i] =
				  scale_index[j][1][i] =
				  scale_index[j][2][i] = SCALE_RANGE-1;
				  break;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a694 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a695 3
#elif	defined(DIFF_3)				/* =========================== */
/* JMZ 15/03/1995 Multilingual                                        */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a697 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a704 8
#elif	defined(DIFF_3)				/* =========================== */
void II_decode_scale_ml(Bit_stream_struc *bs,
		        unsigned int scfsi[5][SBLIMIT], 		
		        unsigned int bit_alloc[5][SBLIMIT],	
		        unsigned int scale_index[5][3][SBLIMIT],	
		        frame_params *fr_ps,
		        int *m)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a707 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a709 3
#elif	defined(DIFF_3)				/* =========================== */
   int mlsblimit = fr_ps->mlsblimit;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a711 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a712 3
#elif	defined(DIFF_3)				/* =========================== */
   for (i=0;i<mlsblimit;i++) for (j=0;j<*m;j++)   /* 2 bit scfsi */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a715 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a716 1
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a717 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a719 3
#elif	defined(DIFF_2)				/* =========================== */
	 for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++)
		scfsi[j][i] = 0;
a720 5
#elif	defined(DIFF_3)				/* =========================== */
	else scfsi[j][i] = 4;
   for (i=mlsblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++)
	scfsi[j][i] = 4;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a721 2
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */

a725 9
#elif	defined(DIFF_2)				/* =========================== */
   /* 3.6.94 R.S. read the prediction coefficients in the mc - part */
   /* R.S. not included in Shareware */
	
   for (i = 0; i < sblimit; i++) for (j = 0; j < *m; j++) {
#elif	defined(DIFF_3)				/* =========================== */
   
   for (i = 0; i < mlsblimit; i++) for (j = 0; j < *m; j++) {
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a726 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a727 3
#elif	defined(DIFF_3)				/* =========================== */
	    switch (scfsi[j][i]) {
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a729 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a733 5
#elif	defined(DIFF_3)				/* =========================== */
			  scale_index[j][1][i] = getbits(bs,6);
			  scale_index[j][2][i] = getbits(bs,6);
			  break;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a735 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a745 10
#elif	defined(DIFF_3)				/* =========================== */
			  scale_index[j][1][i] = getbits(bs,6);
			  scale_index[j][2][i] = getbits(bs,6);
			  break;
	         /* scale factor 1 & 2 transmitted */
		 case 3 : scale_index[j][0][i] = getbits(bs,6);
			  scale_index[j][1][i] =
			  scale_index[j][2][i] = getbits(bs,6);
         		  break;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a746 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a756 14
#elif	defined(DIFF_3)				/* =========================== */
	         case 2 : scale_index[j][0][i] =
		          scale_index[j][1][i] =
		          scale_index[j][2][i] = getbits(bs,6);
         		  break;
		 default : scale_index[j][0][i] =
		           scale_index[j][1][i] =
		           scale_index[j][2][i] = SCALE_RANGE-1;
         		   break;
          }
          else {
                          scale_index[j][0][i] = scale_index[j][1][i] =
	                  scale_index[j][2][i] = SCALE_RANGE-1;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a758 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a761 5
#elif	defined(DIFF_3)				/* =========================== */
   for (i=mlsblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++) {
		          scale_index[j][0][i] = scale_index[j][1][i] =
		          scale_index[j][2][i] = SCALE_RANGE-1;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a835 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a836 3
#elif	defined(DIFF_2)				/* =========================== */
			int gr)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a842 6
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
   /* 31/10/95 Ralf Schwalbe LFE */
   if(info.lfe)
	info.lfe_spl[gr] = (unsigned int) getbits(bs,(*alloc)[0][info.lfe_alloc].bits);

#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a852 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a853 4
#elif	defined(DIFF_2)				/* =========================== */
	
	 for (j = 2; j < channels; j++)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a861 3
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */

#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a872 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a873 1
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a880 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a881 3
#elif	defined(DIFF_2)				/* =========================== */
		 else       /* 15.02.1995 Ralf Schwalbe dyn-cross mode on */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a882 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a889 10
#elif	defined(DIFF_2)				/* =========================== */
		   if(((fr_ps->header->dyn_cross_mode[sbgr]==0) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==1  && j!=4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==2  && j!=3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==3  && j!=2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==8  && j!=4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==9  && j!=3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==10 && j!=4)) &&
			fr_ps->dyn_cross_bits == 4) 
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a912 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a919 10
#elif	defined(DIFF_2)				/* =========================== */
		   if(((fr_ps->header->dyn_cross_mode[sbgr]==4  && j==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==5  && j==3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==6  && j==4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==11 && j==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==12 && j==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==13 && j==3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==14 && j==2)) || 
			fr_ps->dyn_cross_bits != 4)  
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a920 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a921 3
#elif	defined(DIFF_2)				/* =========================== */
			if((fr_ps->dyn_cross_bits == 3 && fr_ps->header->dyn_cross_mode[sbgr] == 3) ||
			   (fr_ps->dyn_cross_bits == 1 && fr_ps->header->dyn_cross_mode[sbgr] == 1))
a922 14
				/* no samples to read, do nothing */
			}
			else
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
			{
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
			    if((fr_ps->dyn_cross_bits == 3 || fr_ps->dyn_cross_bits == 1) && j == 3)
			    {
				/* do nothing, only one channel to read for mode 3/1 with dyn_cross */
			    }
			    else	
			    if((*alloc)[i][bit_alloc[j][i]].group==3)
			    {
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a927 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a930 5
#elif	defined(DIFF_2)				/* =========================== */
			    }
			    else
			    {    /* bit_alloc = 3, 5, 9 */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a938 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a939 4
#elif	defined(DIFF_2)				/* =========================== */
			    }
			}  /* end if ..bits */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a948 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a949 3
#elif	defined(DIFF_2)				/* =========================== */
	 for (j = 2; j < channels; j++)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a951 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1014 65
#elif	defined(DIFF_3)				/* =========================== */


/***************************************************************/
/* 09/03/1995 JMZ Multilingual */

/***************************************************************/
/* 15/03/1995 JMZ */

void II_buffer_sample_ml(Bit_stream_struc *bs,
			 unsigned int sample_ml[5][3][SBLIMIT],
			 unsigned int bit_alloc_ml[5][SBLIMIT],
			 frame_params *fr_ps,
			 int *n_ml_ch)
{
   int i,j,k,m,sbgr,l;
   unsigned int nlevels, c=0;
   int mlsblimit = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;

   for (i = 0; i < mlsblimit; i++)
   {
	 for (j = 0; j < *n_ml_ch; j++)
	 {
	   if (bit_alloc_ml[j][i])
	   {
		/* JR: no dynamic crosstalk for multilingual channels */
		/* check for grouping in subband */
		if ((*allocml)[i][bit_alloc_ml[j][i]].group==3)
		{

			for (m=0;m<3;m++)
			{
				k = (*allocml)[i][bit_alloc_ml[j][i]].bits;
				sample_ml[j][m][i] = (unsigned int) getbits(bs,k);
			}

		}
		else
		{    /* bit_alloc = 3, 5, 9 */
		  nlevels = (*allocml)[i][bit_alloc_ml[j][i]].steps;
		  k=(*allocml)[i][bit_alloc_ml[j][i]].bits;
		  c = (unsigned int) getbits(bs, k);

		  for (k=0;k<3;k++)
		  {
			sample_ml[j][k][i] = c % nlevels;
			c /= nlevels;
		  }
		}
	   }
	   else
	   {      /* for no sample transmitted */
		 for (k=0;k<3;k++) sample_ml[j][k][i] = 0;
	   }
	 }
   }

   for (i = mlsblimit; i < SBLIMIT; i++)
	 for (j = 0; j < *n_ml_ch; j++)
		for (k = 0; k < 3; k++)
		   sample_ml[j][k][i] = 0;
}

#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1093 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1094 1
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1100 3
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
   
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1102 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1111 11
#elif	defined(DIFF_2)				/* =========================== */
	if( i == 0) sbgr = 0 ;
	else
	   for(l = 1; l < 12; l++)
		if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
		{
		    sbgr = l; break;
		}
	for (j = 0; j < 3; j++)
	   for ( k = 2; k < channels; k++)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1115 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1116 1
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1122 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1124 3
#elif	defined(DIFF_2)				/* =========================== */
			(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)) && ( x < 16) ) x++;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1127 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1128 3
#elif	defined(DIFF_2)				/* =========================== */
			 fraction[k][i][j][*z] = 0.0;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1138 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1139 3
#elif	defined(DIFF_2)				/* =========================== */
		  else   /* 21.07.94 Ralf Schwalbe dyn. cross mode */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1140 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1147 10
#elif	defined(DIFF_2)				/* =========================== */
		   if(((fr_ps->header->dyn_cross_mode[sbgr]==0) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==1  && k!=4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==2  && k!=3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==3  && k!=2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==8  && k!=4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==9  && k!=3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==10 && k!=4)) &&
			fr_ps->dyn_cross_bits == 4 )
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1170 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1177 10
#elif	defined(DIFF_2)				/* =========================== */
		   if(((fr_ps->header->dyn_cross_mode[sbgr]==4  && k==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==5  && k==3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==6  && k==4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==11 && k==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==12 && k==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==13 && k==3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==14 && k==2)) ||
			fr_ps->dyn_cross_bits != 4) 
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1178 9
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
			if((fr_ps->dyn_cross_bits == 3 && fr_ps->header->dyn_cross_mode[sbgr] == 3) ||
			   (fr_ps->dyn_cross_bits == 1 && fr_ps->header->dyn_cross_mode[sbgr] == 1))
			{
				/* no samples to dequantize */
			}
			else
			{
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1198 3
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
			} /* end if ..bits */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1205 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1206 3
#elif	defined(DIFF_2)				/* =========================== */
		 for(k = 2; k < channels; k++)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1209 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1219 17
#elif	defined(DIFF_2)				/* =========================== */
/**************************************************************************
II_lfe_calc();  R.Schwalbe 
**************************************************************************/
void II_lfe_calc(frame_params *fr_ps)
#elif	defined(DIFF_3)				/* =========================== */

/*************************************************************************/
/* JMZ 09/03/1995 Multilingual */

void II_dequantize_sample_ml(unsigned int sample_ml[5][3][SBLIMIT],
			     unsigned int bit_alloc_ml[5][SBLIMIT],
			     double fraction_ml[5][SBLIMIT][3][12],
			     frame_params *fr_ps,
			     int *n_ml_ch,
			     int *z)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1220 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1223 8
#elif	defined(DIFF_2)				/* =========================== */
   int x,i;
   al_table *alloc = fr_ps->alloc;
#elif	defined(DIFF_3)				/* =========================== */
   int i, j, k, x,sbgr,l;
   int mlsblimit = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1224 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1225 5
#elif	defined(DIFF_2)				/* =========================== */
   for(i = 0; i < 12; i++)
#elif	defined(DIFF_3)				/* =========================== */
   for (i = 0; i < mlsblimit; i++)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1226 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1233 11
#elif	defined(DIFF_2)				/* =========================== */
	x = 0;
#elif	defined(DIFF_3)				/* =========================== */
	  for (j = 0; j < 3; j++)
		 for ( k = 0; k < *n_ml_ch; k++)
			if (bit_alloc_ml[k][i])
			{
			  /* JR: ditto */
			  /* locate MSB in the sample */
			   x = 0;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1234 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1235 5
#elif	defined(DIFF_2)				/* =========================== */
   	while ((1L<<x) < (*alloc)[0][info.lfe_alloc].steps) x++;
#elif	defined(DIFF_3)				/* =========================== */
			   while ((1L<<x) < (*allocml)[i][bit_alloc_ml[k][i]].steps) x++;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1236 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1240 10
#elif	defined(DIFF_2)				/* =========================== */
   	/* microsoft C thinks an int is a short */
   	while (( (unsigned long) (1L<<(long)x) <
   	(unsigned long)( (*alloc)[0][info.lfe_alloc].steps)) && ( x < 16) ) x++;
#elif	defined(DIFF_3)				/* =========================== */
			   /* microsoft C thinks an int is a short */
			   while (( (unsigned long) (1L<<(long)x) <
				(unsigned long)( (*allocml)[i][bit_alloc_ml[k][i]].steps)
			   ) && ( x < 16) ) x++;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1241 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1245 5
#elif	defined(DIFF_2)				/* =========================== */
   	/* MSB inversion */
   	if (((info.lfe_spl[i] >> (x-1)) & 1) == 1)
     		info.lfe_spl_fraction[i] = 0.0;
   	else 	info.lfe_spl_fraction[i] = -1.0;
a1246 15
   	/* Form a 2's complement sample */
   	info.lfe_spl_fraction[i] += (double) (info.lfe_spl[i] & ((1<<(x-1))-1)) /
	 			(double) (1L<<(x-1));

   	/* Dequantize the sample */
   	info.lfe_spl_fraction[i] += d[(*alloc)[0][info.lfe_alloc].quant];
   	info.lfe_spl_fraction[i] *= c[(*alloc)[0][info.lfe_alloc].quant];
#elif	defined(DIFF_3)				/* =========================== */
			   /* MSB inversion */
			   if (((sample_ml[k][j][i] >> (x-1)) & 1) == 1)
					fraction_ml[k][i][j][*z] = 0.0;
			   else  fraction_ml[k][i][j][*z] = -1.0;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */

#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1249 10
#elif	defined(DIFF_2)				/* =========================== */
   	/* Denormalize the sample */
   	info.lfe_spl_fraction[i] *= multiple[info.lfe_scf];
    }
}
#elif	defined(DIFF_3)				/* =========================== */
			   /* Form a 2's complement sample */
			   fraction_ml[k][i][j][*z] += (double) (sample_ml[k][j][i] & ((1<<(x-1))-1)) /
							(double) (1L<<(x-1));
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1250 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1261 13
#elif	defined(DIFF_3)				/* =========================== */
			   /* Dequantize the sample */
			   fraction_ml[k][i][j][*z] += d[(*allocml)[i][bit_alloc_ml[k][i]].quant];
			   fraction_ml[k][i][j][*z] *= c[(*allocml)[i][bit_alloc_ml[k][i]].quant];
			} /* if bit_alloc */
			else fraction_ml[k][i][j][*z] = 0.0;
   }
   for (i = mlsblimit; i < SBLIMIT; i++)
	  for (j = 0; j < 3; j++)
		 for(k = 0; k < *n_ml_ch; k++)
			 fraction_ml[k][i][j][*z] = 0.0;
}
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1294 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1295 1
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1303 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1309 8
#elif	defined(DIFF_2)				/* =========================== */
	else
	        for(l = 1; l < 12; l++)
		     if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
		     {
			sbgr = l; break;
		     }
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1310 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1311 3
#elif	defined(DIFF_2)				/* =========================== */
		for (j = 2; j < channels; j++)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1316 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1317 1
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1320 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1321 3
#elif	defined(DIFF_2)				/* =========================== */
		  case 0 : 	for (j = 2; j < channels; j++)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1332 4
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
				    if(fr_ps->dyn_cross_bits == 4)
				    {
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1336 18
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
				    }
				    else
				    {
					if(fr_ps->dyn_cross_bits == 3)
					{
					    fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];        
					    fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								   * multiple[scale_index[3][x][i]];
					}
					else
					{
					    if(fr_ps->dyn_cross_bits == 1)	
						fraction[2][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								   * multiple[scale_index[2][x][i]];
					}
				    }
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1343 4
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
				    if(fr_ps->dyn_cross_bits == 4)
				    {
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1347 20
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
				    }	
				    if(fr_ps->dyn_cross_bits == 3)
				    {   /* R.S. die Samples sind in diesem Fall noch nicht umsortiert */
					fraction[3][i][bl][*z] = fraction[2][i][bl][*z] * multiple[scale_index[3][x][i]];
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
				    }
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1353 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1354 5
#elif	defined(DIFF_2)				/* =========================== */
				    if(fr_ps->dyn_cross_bits == 4)
				    {
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1356 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1357 3
#elif	defined(DIFF_2)				/* =========================== */
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1366 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1367 3
#elif	defined(DIFF_2)				/* =========================== */
					
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1369 22
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
				    }
				    if(fr_ps->dyn_cross_bits == 3)
				    {
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
					fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
									  * multiple[scale_index[3][x][i]];
					
				    }
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1376 4
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
				    if(fr_ps->dyn_cross_bits == 4)
				    {
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1381 9
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
				    }
				    if(fr_ps->dyn_cross_bits == 3)
				    {
					fraction[3][i][bl][*z] = fraction[2][i][bl][*z];
					fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];
				    }
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1387 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1388 3
#elif	defined(DIFF_2)				/* =========================== */
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1390 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1391 3
#elif	defined(DIFF_2)				/* =========================== */
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1400 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1401 3
#elif	defined(DIFF_2)				/* =========================== */
					
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1410 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1411 3
#elif	defined(DIFF_2)				/* =========================== */
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1413 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1414 3
#elif	defined(DIFF_2)				/* =========================== */
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1423 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1424 3
#elif	defined(DIFF_2)				/* =========================== */
					
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1432 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1433 3
#elif	defined(DIFF_2)				/* =========================== */
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1435 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1436 3
#elif	defined(DIFF_2)				/* =========================== */
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1445 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1446 3
#elif	defined(DIFF_2)				/* =========================== */
					
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1529 4
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1531 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1533 3
#elif	defined(DIFF_2)				/* =========================== */
						
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1540 4
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
/*************************************************************/
/* JMZ 09/03/1995 Multilingual */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1542 4
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
/* JMZ 15/03/1995 TEST */
/*************************************************************************/
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1544 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1553 7
#elif	defined(DIFF_2)				/* =========================== */
void II_dequantize_sample_test(unsigned int sample[5][3][SBLIMIT],
			    unsigned int bit_alloc[5][SBLIMIT],
			    double fraction[5][SBLIMIT][3][12],
			    frame_params *fr_ps,
			    int *n_ml_ch,
			    int *z)
a1554 50
   int i, j, k, x,sbgr,l;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   for (i = 0; i < sblimit; i++)
   {
	  for (j = 0; j < 3; j++)
		 for ( k = 0; k < *n_ml_ch; k++)
			if (bit_alloc[k][i])
			{
			  /* JR: ditto */
			  /* locate MSB in the sample */
			   x = 0;
#ifndef MSDOS
			   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
#else
			   /* microsoft C thinks an int is a short */
			   while (( (unsigned long) (1L<<(long)x) <
				(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)
			   ) && ( x < 16) ) x++;
#endif
			   /* MSB inversion */
			   if (((sample[k][j][i] >> (x-1)) & 1) == 1)
					fraction[k][i][j][*z] = 0.0;
			   else  fraction[k][i][j][*z] = -1.0;

			   /* Form a 2's complement sample */
			   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
							(double) (1L<<(x-1));

			   /* Dequantize the sample */
			   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
			   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
			} /* if bit_alloc */
			else fraction[k][i][j][*z] = 0.0;
   }
   for (i = sblimit; i < SBLIMIT; i++)
	  for (j = 0; j < 3; j++)
		 for(k = 0; k < *n_ml_ch; k++)
			 fraction[k][i][j][*z] = 0.0;
}


void II_denormalize_sample_test(double fraction[5][SBLIMIT][3][12],
			     unsigned int scale_index[5][3][SBLIMIT],
			     frame_params *fr_ps,
			     int x,
			     int *n_ml_ch,
			     int *z)
{
a1571 94
void II_buffer_sample_test(Bit_stream_struc *bs,
			unsigned int sample[5][3][SBLIMIT],
			unsigned int bit_alloc[5][SBLIMIT],
			frame_params *fr_ps,
			int *n_ml_ch)
#elif	defined(DIFF_3)				/* =========================== */
void II_denormalize_sample_ml(double fraction_ml[5][SBLIMIT][3][12],
			      unsigned int scale_index_ml[5][3][SBLIMIT],
			      frame_params *fr_ps,
			      int x,
			      int *n_ml_ch,
			      int *z)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
{
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
   int i,j,k,sbgr,l,bl=0;
   int sblimit = fr_ps->sblimit;
#elif	defined(DIFF_2)				/* =========================== */
   int i,j,k,m,sbgr,l;
   unsigned int nlevels, c=0;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   for (i = 0; i < sblimit; i++)
   {
	 for (j = 0; j < *n_ml_ch; j++)
	 {
	   if (bit_alloc[j][i])
	   {
		/* JR: no dynamic crosstalk for multilingual channels */
		/* check for grouping in subband */
		if ((*alloc)[i][bit_alloc[j][i]].group==3)
		{

			for (m=0;m<3;m++)
			{
				k = (*alloc)[i][bit_alloc[j][i]].bits;
				sample[j][m][i] = (unsigned int) getbits(bs,k);
			}

		}
		else
		{    /* bit_alloc = 3, 5, 9 */
		  nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
		  k=(*alloc)[i][bit_alloc[j][i]].bits;
		  c = (unsigned int) getbits(bs, k);

		  for (k=0;k<3;k++)
		  {
			sample[j][k][i] = c % nlevels;
			c /= nlevels;
		  }
		}
	   }
	   else
	   {      /* for no sample transmitted */
		 for (k=0;k<3;k++) sample[j][k][i] = 0;
	   }
	 }
   }
#elif	defined(DIFF_3)				/* =========================== */
   int i,j;
   int mlsblimit = fr_ps->mlsblimit;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */

#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
   for (i = 0; i < sblimit; i++)
   {
	if(fr_ps->header->dyn_cross_on == 0)
		for (j = 0; j < *n_ml_ch; j++)
		{
			fraction[j][i][0][*z] *= multiple[scale_index[j][x][i]];
			fraction[j][i][1][*z] *= multiple[scale_index[j][x][i]];
			fraction[j][i][2][*z] *= multiple[scale_index[j][x][i]];
		}
	/************** R.S. ***************/
 
   } /* for sblimit */
#elif	defined(DIFF_2)				/* =========================== */
   for (i = sblimit; i < SBLIMIT; i++)
	 for (j = 0; j < *n_ml_ch; j++)
		for (k = 0; k < 3; k++)
		   sample[j][k][i] = 0;
#elif	defined(DIFF_3)				/* =========================== */
   for (i = 0; i < mlsblimit; i++)
    for (j = 0; j < *n_ml_ch; j++)
     {
       fraction_ml[j][i][0][*z] *= multiple[scale_index_ml[j][x][i]];
       fraction_ml[j][i][1][*z] *= multiple[scale_index_ml[j][x][i]];
       fraction_ml[j][i][2][*z] *= multiple[scale_index_ml[j][x][i]];
     }
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
}

a1700 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1703 5
#elif	defined(DIFF_3)				/* =========================== */
int SubBandSynthesis_ml (double *bandPtr,
		         int channel,
		         long *samples)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1797 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1803 8
#elif	defined(DIFF_3)				/* =========================== */
void out_fifo_ml(long pcm_sample[5][3][SBLIMIT],
	         int num,
	         frame_params *fr_ps,
	         int done,
	         FILE *outFile,
	         unsigned long *psampFrames)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a1954 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a1956 4
#elif	defined(DIFF_2)				/* =========================== */
			double dematrix2_filter_state[3])
			
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a2265 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a2268 6
#elif	defined(DIFF_3)				/* =========================== */
/* JMZ 09/03/1995 Multilingual , WtK 7/8/95 */
void dematricing_ml(double pcm_sample_ml[5][SBLIMIT][3][12], 
		    frame_params *fr_ps) 
/* unweighting the signals */		    
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a2270 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a2273 3
#elif	defined(DIFF_3)				/* =========================== */
  int i, j, jj, k;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a2274 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a2277 1
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a2278 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a2279 5
#elif	defined(DIFF_3)				/* =========================== */
  int lsf     = info->multi_lingual_fs;
  int encoder_weights_ml = 0;
  
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a2281 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a2302 13
#elif	defined(DIFF_3)				/* =========================== */
    /* factors according to Committee Draft and telefax 10/20/93 */
    /* by E.Schroeder, DTB Hannover.  01/14/94, SR               */
   
      case 0: matr1 = 2.42797851625;
	      break;
      case 1: matr1 = 1.5 + (0.5 * 1.41632080078125);
	      break;
      case 2: matr1 = 2.42797851625;
	      break;
      case 3: matr1 = 1.0;
	      break;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a2304 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a2319 10
#elif	defined(DIFF_3)				/* =========================== */
/* no weighting is occurring in encoder; so skip the unweighting ! */
if (encoder_weights_ml) 
 if( fr_ps->header->dematrix_procedure != 3 )
    for (jj=0;jj<( (lsf==0) ? 12 : 6 );jj++)
      for (j=0;j<3;++j)
	for (i=0;i<SBLIMIT;i++)
	  for (k=0;k<n_ml_ch;k++)
	    pcm_sample_ml[k][i][j][jj] *= matr1;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
@


1.8.3.2
log
@Merged FTZ_04 and Philips_01
@
text
@d4 1
a4 1
 * $Id: decode.c 1.8.3.1 1995/11/05 22:50:42 rowlands Exp rowlands $
d10 1
a10 4
 * $Log: decode.c $
 * Revision 1.8.3.1  1995/11/05  22:50:42  rowlands
 * Merged FTZ_04 and Philips_01 using #ifdefs
 *
d178 1
d187 1
d292 8
d304 1
d309 8
d319 1
d326 3
d330 1
d337 1
d339 1
d427 3
d434 1
d473 4
d536 1
d581 5
d595 1
d663 3
d668 1
d690 8
d702 1
d704 18
d725 1
d727 4
d742 1
d758 3
d762 1
d786 1
d788 1
d794 3
d798 1
d800 1
d802 1
d807 1
d811 3
d822 5
d830 1
d833 5
d841 1
d843 6
d853 1
d856 6
d869 1
d888 3
d892 1
d895 9
d910 1
d914 4
d919 1
d922 3
d926 1
d930 3
d934 8
d945 1
d947 13
d961 1
d963 3
d967 1
d970 6
d979 1
d982 12
d1002 1
d1004 12
d1028 1
d1031 5
a1035 1

d1039 1
d1114 3
a1116 1
			int *mc_ch,
d1118 1
a1123 1
   int channels = *mc_ch;
d1125 1
d1130 1
d1141 4
d1146 1
d1155 3
d1169 1
d1171 1
d1179 3
d1183 1
d1185 9
d1202 2
d1226 9
d1243 1
d1245 3
d1254 1
d1256 1
d1264 1
d1270 5
d1278 1
d1287 3
d1292 1
d1302 3
d1306 1
d1309 1
d1311 1
d1316 64
d1437 1
d1517 1
d1519 1
a1524 1
   int	channels = *mc_ch;
d1526 3
d1531 11
d1551 1
d1556 1
d1558 1
d1565 4
d1570 1
d1574 3
d1578 1
d1589 3
d1593 1
d1595 9
d1612 1
d1636 9
d1653 1
d1655 1
d1663 1
d1684 1
d1686 1
d1694 3
d1698 1
d1702 1
d1707 16
d1729 1
d1731 1
d1733 7
d1742 1
d1744 5
d1750 1
d1752 1
d1755 10
d1770 1
d1772 5
d1778 1
d1780 1
d1783 9
d1794 1
d1796 1
d1798 18
d1819 1
d1821 1
d1823 9
d1834 1
d1836 1
d1838 12
d1860 1
a1861 38

/**************************************************************************
II_lfe_calc();  R.Schwalbe 
**************************************************************************/
void II_lfe_calc(frame_params *fr_ps)
{
   int x,i;
   al_table *alloc = fr_ps->alloc;

   for(i = 0; i < 12; i++)
   {
	x = 0;
#ifndef MSDOS
   	while ((1L<<x) < (*alloc)[0][info.lfe_alloc].steps) x++;
#else
   	/* microsoft C thinks an int is a short */
   	while (( (unsigned long) (1L<<(long)x) <
   	(unsigned long)( (*alloc)[0][info.lfe_alloc].steps)) && ( x < 16) ) x++;
#endif
   	/* MSB inversion */
   	if (((info.lfe_spl[i] >> (x-1)) & 1) == 1)
     		info.lfe_spl_fraction[i] = 0.0;
   	else 	info.lfe_spl_fraction[i] = -1.0;

   	/* Form a 2's complement sample */
   	info.lfe_spl_fraction[i] += (double) (info.lfe_spl[i] & ((1<<(x-1))-1)) /
	 			(double) (1L<<(x-1));

   	/* Dequantize the sample */
   	info.lfe_spl_fraction[i] += d[(*alloc)[0][info.lfe_alloc].quant];
   	info.lfe_spl_fraction[i] *= c[(*alloc)[0][info.lfe_alloc].quant];

   	/* Denormalize the sample */
   	info.lfe_spl_fraction[i] *= multiple[info.lfe_scf];
    }
}


d1894 1
d1896 1
a1900 1
   int channels = *mc_ch;
d1905 8
d1919 1
d1921 3
d1925 1
d1931 3
d1937 3
d1941 1
d1953 1
d1956 1
d1961 1
d1978 1
d1986 1
d1989 1
d1994 1
d2013 1
d2020 3
d2026 1
d2029 3
d2033 1
d2043 1
d2045 3
d2050 1
d2071 1
d2079 1
d2082 1
d2088 1
d2096 1
d2103 3
d2107 1
d2110 3
d2114 1
d2124 1
d2126 3
d2138 3
d2142 1
d2145 3
d2149 1
d2159 1
d2161 3
d2172 3
d2176 1
d2179 3
d2183 1
d2193 1
d2195 3
d2279 1
d2281 1
a2281 2
					fraction[4][i][bl][*z]  = fraction[2][i][bl][*z];

d2284 1
a2284 1

d2287 6
d2300 1
d2303 1
d2305 98
d2409 1
d2411 47
d2460 1
d2462 19
d2488 1
d2620 5
a2624 1

d2628 1
d2723 8
d2737 1
d2889 4
d2894 2
d3205 5
d3214 1
d3217 5
d3223 1
a3223 1

d3225 5
d3231 1
d3233 1
d3237 2
a3238 1
  switch(info->dematrix_procedure) /* ######## */
d3240 23
d3274 1
d3277 17
d3302 1
@


1.8.2.0
log
@Branch for ten Kate
@
text
@d4 1
a4 1
 * $Id: decode.c 1.8 1995/11/05 17:42:05 rowlands Exp $
a10 3
 * Revision 1.8  1995/11/05  17:42:05  rowlands
 * Distribution_06 base
 *
@


1.8.2.1
log
@Received from Warner ten Kate
@
text
@d4 1
a4 1
 * $Id: decode.c,v 1.7.1.3 1995/08/14 08:12:10 tenkate Exp $
d10 3
a12 5
 * $Log: decode.c,v $
 * Revision 1.7.1.3  1995/08/14  08:12:10  tenkate
 * ML-LSF added WtK 7/8/95
 * change "alloc" and "sblimit" into "allocml" and
 * "mlsblimit" where appropriate.
d573 6
a578 4
void II_decode_bitalloc_ml(Bit_stream_struc *bs,
			   unsigned int bit_alloc_ml[5][SBLIMIT],	
			   frame_params *fr_ps,
			   int *m)
d580 5
a584 3
   int i,j;
   int mlsblimit = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;
d586 7
a592 4
   /* JR: no dynamic crosstalk for multilingual channels */
   /* JR: no phantom center coding for multilingual channels */
   /* JR: no joint coding for multilingual channels */
   /* JR: they're really simple, aren't they? */
d594 5
a598 6
   for (i=0;i<mlsblimit;i++)
    for (j=0;j<*m;j++) 
     bit_alloc_ml[j][i] = (char) getbits(bs,(*allocml)[i][0].bits);
   for (i=mlsblimit;i<SBLIMIT;i++) 
    for (j=0;j<*m;j++) 
     bit_alloc_ml[j][i] = 0;
d614 1
a614 1
/* JMZ 09/03/1995 Multilingual adaptations , WtK 7/8/95               */
a637 1
		else scfsi[j][i] = 4;
d643 1
a643 1
		scfsi[j][i] = 4;
d658 3
a660 3
			         scale_index[j][1][i] = getbits(bs,6);
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
d663 3
a665 3
				 scale_index[j][1][i] = getbits(bs,6);
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
d667 4
a670 4
			case 3 : scale_index[j][0][i] = getbits(bs,6);
				 scale_index[j][1][i] =
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
d673 4
a676 7
				 scale_index[j][1][i] =
				 scale_index[j][2][i] = getbits(bs,6);
				 break;
			default : scale_index[j][0][i] =
				  scale_index[j][1][i] =
				  scale_index[j][2][i] = SCALE_RANGE-1;
				  break;
d695 1
a695 1
/* JMZ 15/03/1995 Multilingual                                        */
d698 7
a704 6
void II_decode_scale_ml(Bit_stream_struc *bs,
		        unsigned int scfsi[5][SBLIMIT], 		
		        unsigned int bit_alloc[5][SBLIMIT],	
		        unsigned int scale_index[5][3][SBLIMIT],	
		        frame_params *fr_ps,
		        int *m)
d708 2
a709 1
   int mlsblimit = fr_ps->mlsblimit;
d712 1
a712 1
   for (i=0;i<mlsblimit;i++) for (j=0;j<*m;j++)   /* 2 bit scfsi */
d716 1
d718 2
a719 3
	else scfsi[j][i] = 4;
   for (i=mlsblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++)
	scfsi[j][i] = 4;
d721 5
a725 2
   
   for (i = 0; i < mlsblimit; i++) for (j = 0; j < *m; j++) {
d727 1
a727 1
	    switch (scfsi[j][i]) {
d730 4
a733 3
			  scale_index[j][1][i] = getbits(bs,6);
			  scale_index[j][2][i] = getbits(bs,6);
			  break;
d736 10
a745 8
			  scale_index[j][1][i] = getbits(bs,6);
			  scale_index[j][2][i] = getbits(bs,6);
			  break;
	         /* scale factor 1 & 2 transmitted */
		 case 3 : scale_index[j][0][i] = getbits(bs,6);
			  scale_index[j][1][i] =
			  scale_index[j][2][i] = getbits(bs,6);
         		  break;
d747 10
a756 12
	         case 2 : scale_index[j][0][i] =
		          scale_index[j][1][i] =
		          scale_index[j][2][i] = getbits(bs,6);
         		  break;
		 default : scale_index[j][0][i] =
		           scale_index[j][1][i] =
		           scale_index[j][2][i] = SCALE_RANGE-1;
         		   break;
          }
          else {
                          scale_index[j][0][i] = scale_index[j][1][i] =
	                  scale_index[j][2][i] = SCALE_RANGE-1;
d759 3
a761 3
   for (i=mlsblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++) {
		          scale_index[j][0][i] = scale_index[j][1][i] =
		          scale_index[j][2][i] = SCALE_RANGE-1;
d958 1
a958 1
/* 15/03/1995 JMZ */
d960 5
a964 5
void II_buffer_sample_ml(Bit_stream_struc *bs,
			 unsigned int sample_ml[5][3][SBLIMIT],
			 unsigned int bit_alloc_ml[5][SBLIMIT],
			 frame_params *fr_ps,
			 int *n_ml_ch)
d968 2
a969 2
   int mlsblimit = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;
d971 1
a971 1
   for (i = 0; i < mlsblimit; i++)
d975 1
a975 1
	   if (bit_alloc_ml[j][i])
d979 1
a979 1
		if ((*allocml)[i][bit_alloc_ml[j][i]].group==3)
d984 2
a985 2
				k = (*allocml)[i][bit_alloc_ml[j][i]].bits;
				sample_ml[j][m][i] = (unsigned int) getbits(bs,k);
d991 2
a992 2
		  nlevels = (*allocml)[i][bit_alloc_ml[j][i]].steps;
		  k=(*allocml)[i][bit_alloc_ml[j][i]].bits;
d997 1
a997 1
			sample_ml[j][k][i] = c % nlevels;
d1004 1
a1004 1
		 for (k=0;k<3;k++) sample_ml[j][k][i] = 0;
d1009 1
a1009 1
   for (i = mlsblimit; i < SBLIMIT; i++)
d1012 1
a1012 1
		   sample_ml[j][k][i] = 0;
d1214 6
a1219 6
void II_dequantize_sample_ml(unsigned int sample_ml[5][3][SBLIMIT],
			     unsigned int bit_alloc_ml[5][SBLIMIT],
			     double fraction_ml[5][SBLIMIT][3][12],
			     frame_params *fr_ps,
			     int *n_ml_ch,
			     int *z)
d1222 2
a1223 2
   int mlsblimit = fr_ps->mlsblimit;
   al_table *allocml = fr_ps->allocml;
d1225 1
a1225 1
   for (i = 0; i < mlsblimit; i++)
d1229 1
a1229 1
			if (bit_alloc_ml[k][i])
d1235 1
a1235 1
			   while ((1L<<x) < (*allocml)[i][bit_alloc_ml[k][i]].steps) x++;
d1239 1
a1239 1
				(unsigned long)( (*allocml)[i][bit_alloc_ml[k][i]].steps)
d1243 3
a1245 3
			   if (((sample_ml[k][j][i] >> (x-1)) & 1) == 1)
					fraction_ml[k][i][j][*z] = 0.0;
			   else  fraction_ml[k][i][j][*z] = -1.0;
d1248 1
a1248 1
			   fraction_ml[k][i][j][*z] += (double) (sample_ml[k][j][i] & ((1<<(x-1))-1)) /
d1252 2
a1253 2
			   fraction_ml[k][i][j][*z] += d[(*allocml)[i][bit_alloc_ml[k][i]].quant];
			   fraction_ml[k][i][j][*z] *= c[(*allocml)[i][bit_alloc_ml[k][i]].quant];
d1255 1
a1255 1
			else fraction_ml[k][i][j][*z] = 0.0;
d1257 1
a1257 1
   for (i = mlsblimit; i < SBLIMIT; i++)
d1260 1
a1260 1
			 fraction_ml[k][i][j][*z] = 0.0;
d1545 9
a1553 6
void II_denormalize_sample_ml(double fraction_ml[5][SBLIMIT][3][12],
			      unsigned int scale_index_ml[5][3][SBLIMIT],
			      frame_params *fr_ps,
			      int x,
			      int *n_ml_ch,
			      int *z)
d1555 2
a1556 2
   int i,j;
   int mlsblimit = fr_ps->mlsblimit;
d1558 12
a1569 7
   for (i = 0; i < mlsblimit; i++)
    for (j = 0; j < *n_ml_ch; j++)
     {
       fraction_ml[j][i][0][*z] *= multiple[scale_index_ml[j][x][i]];
       fraction_ml[j][i][1][*z] *= multiple[scale_index_ml[j][x][i]];
       fraction_ml[j][i][2][*z] *= multiple[scale_index_ml[j][x][i]];
     }
d1701 3
a1703 3
int SubBandSynthesis_ml (double *bandPtr,
		         int channel,
		         long *samples)
d1798 6
a1803 6
void out_fifo_ml(long pcm_sample[5][3][SBLIMIT],
	         int num,
	         frame_params *fr_ps,
	         int done,
	         FILE *outFile,
	         unsigned long *psampFrames)
d2266 3
a2268 4
/* JMZ 09/03/1995 Multilingual , WtK 7/8/95 */
void dematricing_ml(double pcm_sample_ml[5][SBLIMIT][3][12], 
		    frame_params *fr_ps) 
/* unweighting the signals */		    
d2271 3
a2273 1
  int i, j, jj, k;
d2275 3
d2279 1
a2279 3
  int lsf     = info->multi_lingual_fs;
  int encoder_weights_ml = 0;
  
d2282 21
a2302 11
    /* factors according to Committee Draft and telefax 10/20/93 */
    /* by E.Schroeder, DTB Hannover.  01/14/94, SR               */
   
      case 0: matr1 = 2.42797851625;
	      break;
      case 1: matr1 = 1.5 + (0.5 * 1.41632080078125);
	      break;
      case 2: matr1 = 2.42797851625;
	      break;
      case 3: matr1 = 1.0;
	      break;
d2305 15
a2319 8
/* no weighting is occurring in encoder; so skip the unweighting ! */
if (encoder_weights_ml) 
 if( fr_ps->header->dematrix_procedure != 3 )
    for (jj=0;jj<( (lsf==0) ? 12 : 6 );jj++)
      for (j=0;j<3;++j)
	for (i=0;i<SBLIMIT;i++)
	  for (k=0;k<n_ml_ch;k++)
	    pcm_sample_ml[k][i][j][jj] *= matr1;
@


1.8.1.0
log
@Branch for Schwalbe
@
text
@d4 1
a4 1
 * $Id: decode.c 1.8 1995/11/05 17:42:05 rowlands Exp $
a10 3
 * Revision 1.8  1995/11/05  17:42:05  rowlands
 * Distribution_06 base
 *
@


1.8.1.1
log
@Received from Ralf Schwalbe
@
text
@d4 1
a4 1
 * $Id: decode.c 1.7.1.2 1995/07/14 06:17:20 rowlands Exp $
d11 3
a175 8
 *		  						      *
 * 10/31/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin	      *
 *		    - decoding of LFE-channel is working  	      *
 *		    - corrected any settings and bugs		      *
 *		    - corrected table-switch for channel mode < 3/2   *
 *		      and tc-allocation / dyn-crosstalk		      *
 *		    - still a problem with compl. bitstream 18/19     *
 *								      *	
d280 6
a285 4
	hdr->tc_allocation = getbits(bs,fr_ps->alloc_bits);
	/* tc_allocation is valid for all sbgr R.S. */
	for(sbgr = 0; sbgr < 12; sbgr++)   
		hdr->tc_alloc[sbgr] = hdr->tc_allocation;
d290 6
a295 2
	for(sbgr = 0; sbgr < 12; sbgr++)
		hdr->tc_alloc[sbgr] = getbits(bs,fr_ps->alloc_bits);
d302 1
a302 1
			hdr->dyn_cross_mode[sbgr] = getbits(bs,fr_ps->dyn_cross_bits);
a308 1
if(hdr->mc_prediction_on)
d396 1
a396 4
   /* 10/31/95 Ralf Schwalbe LFE */
   if(info.lfe)
	info.lfe_alloc = (char) getbits(bs,(*alloc)[0][0].bits);

d435 2
a436 2
	   case 10:  /* 19.10.95 R.S. switch to the right channel conf. table */
		     if(fr_ps->dyn_cross_bits != 4)
a437 57
			if(fr_ps->dyn_cross_bits == 1)   /* for channel mode 3/0 and 2/1 */
			{
			    if(info.center == 1)    /* 3/0 */
			    {
			    if((info.tc_alloc[sbgr] == 1) || (info.tc_alloc[sbgr] == 7))
				bit_alloc[2][i] = bit_alloc[0][i];
			    if((info.tc_alloc[sbgr] == 2) || (info.tc_alloc[sbgr] == 6))
				bit_alloc[2][i] = bit_alloc[1][i];
			    else
				if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
				else	bit_alloc[2][i] = bit_alloc[0][i];
			    }
			    else   /* 2/1 */
			    {
				if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
				else	bit_alloc[2][i] = bit_alloc[0][i];
			    }
			}
			if(fr_ps->dyn_cross_bits == 3)   /* for channel mode 3/1 and 2/2 */
			{
			    if(info.dyn_cross_mode[sbgr] == 3)
			    {
   			    	if((info.tc_alloc[sbgr] == 1) || (info.tc_alloc[sbgr] == 7))
				    bit_alloc[2][i] = bit_alloc[0][i];
			    	if((info.tc_alloc[sbgr] == 2) || (info.tc_alloc[sbgr] == 6))
				    bit_alloc[2][i] = bit_alloc[1][i];
			    	else
				    if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
					else	bit_alloc[2][i] = bit_alloc[0][i];

				if(info.dyn_cross_LR)  bit_alloc[3][i] = bit_alloc[1][i];
					else	bit_alloc[3][i] = bit_alloc[0][i];
			    	
			    }
			    else
			    {
			    	bit_alloc[2][i] = (char) getbits(bs,(*alloc)[i][0].bits); 
			    	if(info.dyn_cross_mode[sbgr] == 1)  
					if(info.dyn_cross_LR)  bit_alloc[3][i] = bit_alloc[1][i];
					else	bit_alloc[3][i] = bit_alloc[0][i];
			    	if(info.dyn_cross_mode[sbgr] == 2) 
			    	{
			    	    bit_alloc[3][i] = bit_alloc[2][i];
			    	    if((info.tc_alloc[sbgr] == 1) || (info.tc_alloc[sbgr] == 7))
				        bit_alloc[2][i] = bit_alloc[0][i];
			    	    if((info.tc_alloc[sbgr] == 2) || (info.tc_alloc[sbgr] == 6))
				    	bit_alloc[2][i] = bit_alloc[1][i];
			    	    else
				    	if(info.dyn_cross_LR)  bit_alloc[2][i] = bit_alloc[1][i];
					    else    bit_alloc[2][i] = bit_alloc[0][i];
			    	}
			    }
			} 
		     }
		     else	
		     for (j = *l; j < *m ; j++)
		     {
d481 3
a483 9
 	   case 14:  j = 2;  /* for phantom center R.S. */
		     if(fr_ps->dyn_cross_bits == 3)
		     {
			bit_alloc[2][i] = (char) getbits(bs,(*alloc)[i][0].bits);
			bit_alloc[3][i] = bit_alloc[2][i];
		     }
		     else
		     if((fr_ps->header->center != 3) || (i < 12) || (j !=2))
		     {
d551 1
a551 2
		     } 
		      break;
a644 4
    /* 31/10/95 Ralf Schwalbe LFE */
    if(info.lfe)
      if(info.lfe_alloc)
	info.lfe_scf = getbits(bs,6);
d646 1
d649 1
d836 1
a836 1
			int gr)
a842 4
   /* 31/10/95 Ralf Schwalbe LFE */
   if(info.lfe)
	info.lfe_spl[gr] = (unsigned int) getbits(bs,(*alloc)[0][info.lfe_alloc].bits);

d853 1
a853 2
	
	 for (j = 2; j < channels; j++)
a861 1

d873 1
d881 1
a881 1
		 else       /* 15.02.1995 Ralf Schwalbe dyn-cross mode on */
d883 7
a889 8
		   if(((fr_ps->header->dyn_cross_mode[sbgr]==0) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==1  && j!=4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==2  && j!=3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==3  && j!=2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==8  && j!=4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==9  && j!=3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==10 && j!=4)) &&
			fr_ps->dyn_cross_bits == 4) 
d913 7
a919 8
		   if(((fr_ps->header->dyn_cross_mode[sbgr]==4  && j==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==5  && j==3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==6  && j==4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==11 && j==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==12 && j==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==13 && j==3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==14 && j==2)) || 
			fr_ps->dyn_cross_bits != 4)  
d921 1
a921 2
			if((fr_ps->dyn_cross_bits == 3 && fr_ps->header->dyn_cross_mode[sbgr] == 3) ||
			   (fr_ps->dyn_cross_bits == 1 && fr_ps->header->dyn_cross_mode[sbgr] == 1))
a922 11
				/* no samples to read, do nothing */
			}
			else
			{
			    if((fr_ps->dyn_cross_bits == 3 || fr_ps->dyn_cross_bits == 1) && j == 3)
			    {
				/* do nothing, only one channel to read for mode 3/1 with dyn_cross */
			    }
			    else	
			    if((*alloc)[i][bit_alloc[j][i]].group==3)
			    {
d928 3
a930 3
			    }
			    else
			    {    /* bit_alloc = 3, 5, 9 */
d939 1
a939 2
			    }
			}  /* end if ..bits */
d949 1
a949 1
	 for (j = 2; j < channels; j++)
d952 63
d1094 1
a1100 1
   
d1103 9
a1111 9
	if( i == 0) sbgr = 0 ;
	else
	   for(l = 1; l < 12; l++)
		if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
		{
		    sbgr = l; break;
		}
	for (j = 0; j < 3; j++)
	   for ( k = 2; k < channels; k++)
d1116 1
d1123 2
a1124 1
			(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)) && ( x < 16) ) x++;
d1128 1
a1128 1
			 fraction[k][i][j][*z] = 0.0;
d1139 1
a1139 1
		  else   /* 21.07.94 Ralf Schwalbe dyn. cross mode */
d1141 7
a1147 8
		   if(((fr_ps->header->dyn_cross_mode[sbgr]==0) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==1  && k!=4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==2  && k!=3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==3  && k!=2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==8  && k!=4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==9  && k!=3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==10 && k!=4)) &&
			fr_ps->dyn_cross_bits == 4 )
d1171 7
a1177 8
		   if(((fr_ps->header->dyn_cross_mode[sbgr]==4  && k==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==5  && k==3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==6  && k==4) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==11 && k==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==12 && k==2) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==13 && k==3) ||
		       (fr_ps->header->dyn_cross_mode[sbgr]==14 && k==2)) ||
			fr_ps->dyn_cross_bits != 4) 
a1178 7
			if((fr_ps->dyn_cross_bits == 3 && fr_ps->header->dyn_cross_mode[sbgr] == 3) ||
			   (fr_ps->dyn_cross_bits == 1 && fr_ps->header->dyn_cross_mode[sbgr] == 1))
			{
				/* no samples to dequantize */
			}
			else
			{
a1198 1
			} /* end if ..bits */
d1206 1
a1206 1
		 for(k = 2; k < channels; k++)
d1210 10
a1219 4
/**************************************************************************
II_lfe_calc();  R.Schwalbe 
**************************************************************************/
void II_lfe_calc(frame_params *fr_ps)
d1221 2
a1222 1
   int x,i;
d1225 1
a1225 1
   for(i = 0; i < 12; i++)
d1227 7
a1233 1
	x = 0;
d1235 1
a1235 1
   	while ((1L<<x) < (*alloc)[0][info.lfe_alloc].steps) x++;
d1237 4
a1240 3
   	/* microsoft C thinks an int is a short */
   	while (( (unsigned long) (1L<<(long)x) <
   	(unsigned long)( (*alloc)[0][info.lfe_alloc].steps)) && ( x < 16) ) x++;
d1242 4
a1245 4
   	/* MSB inversion */
   	if (((info.lfe_spl[i] >> (x-1)) & 1) == 1)
     		info.lfe_spl_fraction[i] = 0.0;
   	else 	info.lfe_spl_fraction[i] = -1.0;
d1247 3
a1249 3
   	/* Form a 2's complement sample */
   	info.lfe_spl_fraction[i] += (double) (info.lfe_spl[i] & ((1<<(x-1))-1)) /
	 			(double) (1L<<(x-1));
d1251 10
a1260 7
   	/* Dequantize the sample */
   	info.lfe_spl_fraction[i] += d[(*alloc)[0][info.lfe_alloc].quant];
   	info.lfe_spl_fraction[i] *= c[(*alloc)[0][info.lfe_alloc].quant];

   	/* Denormalize the sample */
   	info.lfe_spl_fraction[i] *= multiple[info.lfe_scf];
    }
a1262 1

d1295 1
d1304 6
a1309 6
	else
	        for(l = 1; l < 12; l++)
		     if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
		     {
			sbgr = l; break;
		     }
d1311 1
a1311 1
		for (j = 2; j < channels; j++)
d1317 1
d1321 1
a1321 1
		  case 0 : 	for (j = 2; j < channels; j++)
a1332 2
				    if(fr_ps->dyn_cross_bits == 4)
				    {
a1336 16
				    }
				    else
				    {
					if(fr_ps->dyn_cross_bits == 3)
					{
					    fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];        
					    fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								   * multiple[scale_index[3][x][i]];
					}
					else
					{
					    if(fr_ps->dyn_cross_bits == 1)	
						fraction[2][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								   * multiple[scale_index[2][x][i]];
					}
				    }
a1343 2
				    if(fr_ps->dyn_cross_bits == 4)
				    {
a1347 18
				    }	
				    if(fr_ps->dyn_cross_bits == 3)
				    {   /* R.S. die Samples sind in diesem Fall noch nicht umsortiert */
					fraction[3][i][bl][*z] = fraction[2][i][bl][*z] * multiple[scale_index[3][x][i]];
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
				    }
d1354 1
a1354 3
				    if(fr_ps->dyn_cross_bits == 4)
				    {
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
d1357 1
a1357 1
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
d1367 1
a1367 1
					
a1369 20
				    }
				    if(fr_ps->dyn_cross_bits == 3)
				    {
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
					fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
									  * multiple[scale_index[3][x][i]];
					
				    }
a1376 2
				    if(fr_ps->dyn_cross_bits == 4)
				    {
a1381 7
				    }
				    if(fr_ps->dyn_cross_bits == 3)
				    {
					fraction[3][i][bl][*z] = fraction[2][i][bl][*z];
					fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];
				    }
d1388 1
a1388 1
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
d1391 1
a1391 1
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
d1401 1
a1401 1
					
d1411 1
a1411 1
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
d1414 1
a1414 1
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
d1424 1
a1424 1
					
d1433 1
a1433 1
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
d1436 1
a1436 1
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
d1446 1
a1446 1
					
d1530 2
a1533 3
							  /* C from T2 */
					fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
						
d1541 1
a1546 2
/*************************************************************************/
/* JMZ 09/03/1995 Multilingual */
a1547 50
void II_dequantize_sample_test(unsigned int sample[5][3][SBLIMIT],
			    unsigned int bit_alloc[5][SBLIMIT],
			    double fraction[5][SBLIMIT][3][12],
			    frame_params *fr_ps,
			    int *n_ml_ch,
			    int *z)
{
   int i, j, k, x,sbgr,l;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   for (i = 0; i < sblimit; i++)
   {
	  for (j = 0; j < 3; j++)
		 for ( k = 0; k < *n_ml_ch; k++)
			if (bit_alloc[k][i])
			{
			  /* JR: ditto */
			  /* locate MSB in the sample */
			   x = 0;
#ifndef MSDOS
			   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
#else
			   /* microsoft C thinks an int is a short */
			   while (( (unsigned long) (1L<<(long)x) <
				(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)
			   ) && ( x < 16) ) x++;
#endif
			   /* MSB inversion */
			   if (((sample[k][j][i] >> (x-1)) & 1) == 1)
					fraction[k][i][j][*z] = 0.0;
			   else  fraction[k][i][j][*z] = -1.0;

			   /* Form a 2's complement sample */
			   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
							(double) (1L<<(x-1));

			   /* Dequantize the sample */
			   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
			   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
			} /* if bit_alloc */
			else fraction[k][i][j][*z] = 0.0;
   }
   for (i = sblimit; i < SBLIMIT; i++)
	  for (j = 0; j < 3; j++)
		 for(k = 0; k < *n_ml_ch; k++)
			 fraction[k][i][j][*z] = 0.0;
}


a1571 55
void II_buffer_sample_test(Bit_stream_struc *bs,
			unsigned int sample[5][3][SBLIMIT],
			unsigned int bit_alloc[5][SBLIMIT],
			frame_params *fr_ps,
			int *n_ml_ch)
{
   int i,j,k,m,sbgr,l;
   unsigned int nlevels, c=0;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   for (i = 0; i < sblimit; i++)
   {
	 for (j = 0; j < *n_ml_ch; j++)
	 {
	   if (bit_alloc[j][i])
	   {
		/* JR: no dynamic crosstalk for multilingual channels */
		/* check for grouping in subband */
		if ((*alloc)[i][bit_alloc[j][i]].group==3)
		{

			for (m=0;m<3;m++)
			{
				k = (*alloc)[i][bit_alloc[j][i]].bits;
				sample[j][m][i] = (unsigned int) getbits(bs,k);
			}

		}
		else
		{    /* bit_alloc = 3, 5, 9 */
		  nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
		  k=(*alloc)[i][bit_alloc[j][i]].bits;
		  c = (unsigned int) getbits(bs, k);

		  for (k=0;k<3;k++)
		  {
			sample[j][k][i] = c % nlevels;
			c /= nlevels;
		  }
		}
	   }
	   else
	   {      /* for no sample transmitted */
		 for (k=0;k<3;k++) sample[j][k][i] = 0;
	   }
	 }
   }

   for (i = sblimit; i < SBLIMIT; i++)
	 for (j = 0; j < *n_ml_ch; j++)
		for (k = 0; k < 3; k++)
		   sample[j][k][i] = 0;
}

d1955 2
a1956 2
			double dematrix2_filter_state[3])
			
@


1.7
log
@Merged FTZ dynamic crosstalk
@
text
@d4 1
a4 1
 * $Id: decode.c 1.6 1995/06/19 03:14:11 rowlands Exp $
d11 12
d168 6
a173 5
 *                                                                    *     
 *  6/21/95       Ralf Schwalbe, Deutsche Telekom FTZ Berlin/FZ144    *
 *                 Tel: +49 30 6708 2406                              *
 *                 Fax: +49 30 6774 539                               *
 *		  						      *
d1314 1
a1314 1
	/* 6/21/95 Ralf Schwalbe dyn. crosstalk mode */
d1329 1
d1333 1
a1333 1
								  * multiple[scale_index[4][x][i]];
d1340 2
a1341 1
					fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
d1343 1
a1343 1
								  * multiple[scale_index[3][x][i]];
d1348 1
a1348 1
		  case 3 :	/* t2 = from L or R, t3 = Ls, t4 = Rs */
d1351 1
a1351 2

					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
d1354 1
a1354 1
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
d1364 1
d1373 1
d1376 3
a1378 3
								  * multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z]  = fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]]
								  * multiple[scale_index[4][x][i]];
d1382 1
a1382 1
		  case 5 :	/* t2 = from L or R, t3 = Ls, t4 = from t1(R0) */
d1385 1
a1385 1
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
d1388 1
a1388 1
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
d1398 1
d1401 1
a1401 1
								  * multiple[scale_index[4][x][i]];
d1405 1
a1405 1
		  case 6 :	/* t2 = from L or R, t3 from t0(L0), t4 = Rs */
d1408 1
a1408 1
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
d1411 1
a1411 1
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
d1421 1
d1423 1
a1423 1
								  * multiple[scale_index[3][x][i]];
d1427 1
a1427 1
		  case 7 :	/* t2 = from L or R, t3 from t0(L0), t4 = from t1(R0) */
d1430 1
a1430 1
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
d1433 1
a1433 1
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
d1443 1
d1445 1
a1445 1
								  * multiple[scale_index[3][x][i]];
d1447 1
a1447 1
								  * multiple[scale_index[4][x][i]];
d1455 1
d1463 1
a1463 1
		  case 9 :      /* t2 = c, t3 from t2(C), t4 = Rs */
d1466 2
a1467 1
					fraction[3][i][bl][*z]  = fraction[2][i][bl][*z];
d1474 1
a1474 1
		  case 10 :	/* t2 = c, t3 = Ls, t4 from t2(C) */
d1477 1
d1507 1
a1507 1
		  case 13 :	/* t2 from L or R, t3 = Ls, t4 from t3(Ls) */
d1512 1
a1512 1
								  * multiple[scale_index[2][x][i]];
d1515 1
a1515 1
								  * multiple[scale_index[2][x][i]];	
d1527 2
a1530 13
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];
d1987 26
a2012 24
  {
		for(k = 0; k < SBLIMIT; k ++)
		{
		   if(fr_ps->header->tc_sbgr_select == 1)
		   {
			  tc_alloc = fr_ps->header->tc_allocation; /* one tc_alloc is valid for all sbgr */
		   }
		   else
		   {
			  if(k == 0) sbgr = 0;
			  else
				 for(l = 1; l < 12; l++)
				 {
					if((sb_groups[l-1] < k) && (k <= sb_groups[l]))
					{
						sbgr = l;  /* search the valid subband group */
						break;
					}
				 }
				 tc_alloc = fr_ps->header->tc_alloc[sbgr]; /* no prediction, but different tc_alloc's
									      per subband*/
		   }  /* else tc_sbgr_select == 0 */
		switch(tc_alloc)
		{
a2013 3
			/* if prediction on */
			/****************** R.S ***************/

a2026 3
			/* if prediction on */
			/****************** R.S ***************/

a2043 3
			/* if prediction on */
			/****************** R.S ***************/
			
a2060 3
			/* if prediction on */
			/****************** R.S ***************/

a2067 3
			/* if prediction on */
			/****************** R.S ***************/

a2074 3
			/* if prediction on */
			/****************** R.S ***************/

a2083 3
			/* if prediction on */
			/****************** R.S ***************/

a2092 3
			/* if prediction on */
			/****************** R.S ***************/

d2102 106
d2209 1
a2209 1
	}     /* for j < 3 loop */
d2212 1
a2212 1
	if( fr_ps->header->dematrix_procedure != 3 ) 		/* dematrixing */
d2219 40
a2258 3
				pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;
				pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr3;
				pcm_sample[4][k][j][jj] = pcm_sample[4][k][j][jj] * matr3;
@


1.7.1.0
log
@Branch for FTZ dynamic crosstalk
@
text
@d4 1
a4 1
 * $Id: decode.c 1.7 1995/06/22 01:23:00 rowlands Exp $
a10 3
 * Revision 1.7  1995/06/22  01:23:00  rowlands
 * Merged FTZ dynamic crosstalk
 *
@


1.7.1.1
log
@Updated dynamic crosstalk from FTZ: revision FTZ_03
@
text
@d4 1
a4 1
 * $Id: decode.c 1.6 1995/06/19 03:14:11 rowlands Exp $
d11 3
d159 1
a159 6
 *                                                                    * 
 *  7/12/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin          *
 *		    - corrected dynamic crosstalk 		      *
 *		    - 3/2,3/1,3/0,2/1, channel configurations         *
 *                    are working                                     *
 *                                                                    *         
d1304 1
a1304 1
	/* 7/12/95 Ralf Schwalbe dyn. crosstalk mode */
d1308 1
a1308 1
		  case 0 : 	for (j = 2; j < channels; j++)
a1318 1
					         /* C from T2 */
d1322 1
a1322 1
								   * multiple[scale_index[4][x][i]];
d1329 1
a1329 2
						  /* C from T2 */
					fraction[2][i][bl][*z] = fraction[2][i][bl][*z] * multiple[scale_index[2][x][i]];
d1331 1
a1331 1
								   * multiple[scale_index[3][x][i]];
d1336 1
a1336 1
		  case 3 :	/* t2 = from L0 or R0, t3 = Ls, t4 = Rs */
d1339 2
a1340 4
					if(fr_ps->header->dyn_cross_LR)  /* C from RO */
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]]) 
									  * multiple[scale_index[2][x][i]];
					else	/* C from LO */
d1342 11
a1352 1
									  * multiple[scale_index[2][x][i]];
a1360 1
						  /* C from T2 */
d1363 3
a1365 3
								   * multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								   * multiple[scale_index[4][x][i]];
d1369 1
a1369 1
		  case 5 :	/* t2 = from L0 or R0, t3 = Ls, t4 = from t1(R0) */
d1372 4
a1375 1
					if(fr_ps->header->dyn_cross_LR)  /* C from RO */
d1377 8
a1384 4
									  * multiple[scale_index[2][x][i]];
					else	/* C from LO */
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
									  * multiple[scale_index[2][x][i]];
d1387 1
a1387 1
								   * multiple[scale_index[4][x][i]];
d1391 1
a1391 1
		  case 6 :	/* t2 = from L0 or R0, t3 from t0(L0), t4 = Rs */
d1394 4
a1397 1
					if(fr_ps->header->dyn_cross_LR)  /* C from RO */
d1399 8
a1406 4
									  * multiple[scale_index[2][x][i]];
					else	/* C from LO */
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
									  * multiple[scale_index[2][x][i]];
d1408 1
a1408 1
									  * multiple[scale_index[3][x][i]];
d1412 1
a1412 1
		  case 7 :	/* t2 = from L0 or R0, t3 from t0(L0), t4 = from t1(R0) */
d1415 4
a1418 1
					if(fr_ps->header->dyn_cross_LR)  /* C from RO */
d1420 8
a1427 4
									  * multiple[scale_index[2][x][i]];
					else	/* C from LO */
						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
									  * multiple[scale_index[2][x][i]];
d1429 1
a1429 1
								   * multiple[scale_index[3][x][i]];
d1431 1
a1431 1
								   * multiple[scale_index[4][x][i]];
a1438 1
							  /* C from T2 */
d1446 1
a1446 1
		  case 9 :      /* t2 = C, t3 from t2(C), t4 = Rs */
d1449 1
a1449 2
						  /* C from T2 */
					fraction[3][i][bl][*z] = fraction[2][i][bl][*z];
d1456 1
a1456 1
		  case 10 :	/* t2 = C, t3 = Ls, t4 from t2(C) */
a1458 1
						  /* C from T2 */
d1488 1
a1488 1
		  case 13 :	/* t2 from L0 or R0, t3 = Ls, t4 from t3(Ls) */
d1493 1
a1493 1
									 * multiple[scale_index[2][x][i]];
d1496 1
a1496 1
									 * multiple[scale_index[2][x][i]];	
d1510 13
a1522 3
							  /* C from T2 */
					fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];
						
d1979 33
a2011 16
   {
	for(k = 0; k < SBLIMIT; k ++)
	{
	    if(fr_ps->header->tc_sbgr_select == 1)
		tc_alloc = fr_ps->header->tc_allocation; /* one tc_alloc is valid for all sbgr */
	    else
	    {
		if(k == 0) sbgr = 0;
		else
			for(l = 1; l < 12; l++)
			{
				if((sb_groups[l-1] < k) && (k <= sb_groups[l]))
				{
					sbgr = l;  /* search the valid subband group */
					break;
				}
d2013 1
a2013 11
			tc_alloc = fr_ps->header->tc_alloc[sbgr]; /* no prediction, but different tc_alloc's
									per subband*/
	    }  /* else tc_sbgr_select == 0 */
	    if((fr_ps->header->surround == 2) && (mc_channel == 3))
	    {    
	    	
	    	switch(tc_alloc)
	    	{
		 case 0:
			if(fr_ps->header->dematrix_procedure != 3)
			{
d2020 17
a2036 4
			tmp_sample = pcm_sample[2][k][j][jj]; /* L */
			pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
			pcm_sample[0][k][j][jj] = tmp_sample;
d2040 17
a2056 4
			tmp_sample = pcm_sample[2][k][j][jj]; /* R */
			pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
			pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			pcm_sample[1][k][j][jj] = tmp_sample;
d2060 3
d2070 3
d2080 3
d2092 3
d2104 3
a2115 106
	    }
	    else  /* if(surround == 1) */
	     if( fr_ps->header->dematrix_procedure != 3 )
	     {	 
		if(((fr_ps->header->surround == 1) || mc_channel == 1) || (fr_ps->header->surround == 3))  
						/* R.S channel modes 3/1; 2/1; 2/2; 3/0; 30/20 */
		    switch(tc_alloc)
		    {
			 case 0: 
				if(mc_channel == 2 && fr_ps->header->center == 1)   /* 3/1 */
				{
				    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			    	    pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				}
				else           
				   if(mc_channel == 2 && fr_ps->header->center == 0)   /* 2/2 */
				   {
				        pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];
			    	        pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[3][k][j][jj];
				    }
				if(mc_channel == 1 || mc_channel == 3)     /* 2/1 and 3/0 */
				{
				     pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj]; 
			    	     pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj];
				}
				break;

			 case 1:
				tmp_sample = pcm_sample[2][k][j][jj]; /* L */
				if(mc_channel == 2)
				{
				    if(fr_ps->header->center == 0)	/* 2/2 mode */
				    {	
				       pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[3][k][j][jj];
				       pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];
				       pcm_sample[0][k][j][jj] = tmp_sample;
				    }
				    else	/* 3/1 mode */
				    {
				       pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				       pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				       pcm_sample[0][k][j][jj] = tmp_sample;
				    }
				}
				else
				    if(mc_channel == 1 || mc_channel == 3)     /* 2/1 and 3/0 */
				    {
					pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];
					pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj];
				    	pcm_sample[0][k][j][jj] = tmp_sample;
				    }
				break;

			 case 2: 
				tmp_sample = pcm_sample[2][k][j][jj]; /* R */
				if(mc_channel == 2)
				{
				    if(fr_ps->header->center == 0)	/* 2/2 mode */
				    {
				       pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];
				       pcm_sample[3][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[3][k][j][jj];
				       pcm_sample[1][k][j][jj] = tmp_sample;
				    }
				    else	/* 3/1 mode */
				    {
				       pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				       pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				       pcm_sample[1][k][j][jj] = tmp_sample;
				    }
				}
				else
				    if(mc_channel == 1 || mc_channel == 3)        /* 2/1 and 3/0 */
				    {
					pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj];
				    	pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];
				    	pcm_sample[1][k][j][jj] = tmp_sample;
				    }
				break;

			 case 3: 
				tmp_sample = pcm_sample[3][k][j][jj];  /* L in T3 */
				if(fr_ps->header->center == 0)	/* 2/2 mode */
				{
				   tmp_sample = pcm_sample[2][k][j][jj];
				   pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];
				   pcm_sample[0][k][j][jj] = tmp_sample;
				   tmp_sample = pcm_sample[3][k][j][jj];
				   pcm_sample[3][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[3][k][j][jj];
				   pcm_sample[1][k][j][jj] = tmp_sample;
			 	}
				else
				{
				   pcm_sample[3][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[3][k][j][jj] - pcm_sample[2][k][j][jj];
				   pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				   pcm_sample[0][k][j][jj] = tmp_sample;
				}
				break;

			 case 4:
				tmp_sample = pcm_sample[3][k][j][jj];  /* R in T3 */
				pcm_sample[3][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[3][k][j][jj] - pcm_sample[2][k][j][jj];
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				pcm_sample[1][k][j][jj] = tmp_sample;
				break;
		    }   /* switch end */
		}
d2117 1
a2117 1
      }     /* for j < 3 loop */
d2120 1
a2120 1
      if( fr_ps->header->dematrix_procedure != 3 ) 		/* dematrixing */
d2127 3
a2129 40
			 if(fr_ps->header->dematrix_procedure == 0)  /* matrix 0 */
			   	/* surround channels */
				if(fr_ps->header->surround == 3)
				       pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;
				else   
			        {
				    for(l = 2; l < channels; l++)
				       pcm_sample[l][k][j][jj] = pcm_sample[l][k][j][jj] * matr2;
				}
			 else   /* matrix 1 */
				if(fr_ps->header->surround == 3)
				       pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;
				else   
			 	if(mc_channel == 3)   /* R.S. matr2 = C */
				{
				    pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;
				    pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr3;
				    pcm_sample[4][k][j][jj] = pcm_sample[4][k][j][jj] * matr3;
				}
				else
				{
				    if(mc_channel == 2)
					if(fr_ps->header->surround == 2)
					{
					   pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr3;  
					   pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr3;
					}
					else
					   if(fr_ps->header->surround != 3)  /* R.S. 2/0 + 2/0  surround == 1 */
					   {
					   	pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;
				    	   	pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr3;
					   }
				    else  /* mc_channel == 1 */
					if((mc_channel == 1) && (fr_ps->header->center != 0))  /* 2/1 */
					   pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr3; 	
					else   /* 3/0 */
					   pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;
				}

a2131 1

@


1.7.1.2
log
@Merged changes in FTZ_03 and Distribution_04.
@
text
@d4 1
a4 1
 * $Id: decode.c 1.7.1.1 1995/07/14 06:09:48 rowlands Exp $
a10 9
 * Revision 1.7.1.1  1995/07/14  06:12:46  rowlands
 * Updated dynamic crosstalk from FTZ: revision FTZ_03
 *
 * Revision 1.7.1.0  1995/07/14  00:23:53  rowlands
 * Branch for FTZ dynamic crosstalk
 *
 * Revision 1.7  1995/06/22  01:23:00  rowlands
 * Merged FTZ dynamic crosstalk
 *
d162 4
d1310 1
a1310 1
		  case 0 : 	for (j = 2; j < *mc_ch; j++)
d1343 4
a1346 1
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7)) /* L from L0 */
d1348 1
a1348 12
								  * multiple[scale_index[2][x][i]];
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6)) /* R from R0 */
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];

d1369 4
a1372 1
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7)) /* L from L0 */
d1374 1
a1374 12
								  * multiple[scale_index[2][x][i]];
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6)) /* R from R0 */
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];

d1384 4
a1387 1
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7)) /* L from L0 */
d1389 1
a1389 12
								  * multiple[scale_index[2][x][i]];
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6)) /* R from R0 */
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];

d1398 4
a1401 1
					if((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7)) /* L from L0 */
d1403 1
a1403 12
								  * multiple[scale_index[2][x][i]];
					if((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6)) /* R from R0 */
						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
					else
						if(fr_ps->header->dyn_cross_LR)  /* C from RO */
							fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])
								  * multiple[scale_index[2][x][i]];
						else	/* C from LO */
							fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])
								  * multiple[scale_index[2][x][i]];

d1487 2
d1491 1
a1491 2
					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];
					fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];
a1967 1

d1970 1
a1970 1
		/* channel mode 3/2 */
d1974 2
a1975 7
			if (fr_ps->header->dematrix_procedure == 2) {
			    filtered_sample =
				dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
			    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
			    pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
			}
			else if (fr_ps->header->dematrix_procedure != 3) {
d1982 4
a1985 14
			if (fr_ps->header->dematrix_procedure == 2) {
				filtered_sample =
					dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
				tmp_sample = pcm_sample[2][k][j][jj]; /* L */
				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
				pcm_sample[0][k][j][jj] = tmp_sample;
			}
			else {
				tmp_sample = pcm_sample[2][k][j][jj]; /* L */
				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
				pcm_sample[0][k][j][jj] = tmp_sample;
			}
d1989 4
a1992 14
			if (fr_ps->header->dematrix_procedure == 2) {
				filtered_sample =
					dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
				tmp_sample = pcm_sample[2][k][j][jj]; /* R */
				pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
				pcm_sample[1][k][j][jj] = tmp_sample;
			}
			else {
				tmp_sample = pcm_sample[2][k][j][jj]; /* R */
				pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				pcm_sample[1][k][j][jj] = tmp_sample;
			}
d2154 1
a2154 2

			 if(fr_ps->header->dematrix_procedure != 1)  /* matrix 0 and 2, since C, Ls, Rs, and S all use the same value */
d2193 1
d2196 1
@


1.6
log
@Moved merged FTZ/Distribution_02 into main RC trunk.
@
text
@d4 1
a4 1
 * $Id: decode.c 1.5.1.3 1995/06/19 00:44:31 rowlands Exp $
d11 3
d133 1
a133 1
 *  04/11/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
d142 1
a142 1
 *  07/12/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
d149 9
a157 1
 *  13/06/95       Ralf Schwalbe,  Telekom FTZ Berlin                 *
d160 1
a160 1
 *								      *
d320 1
a320 1
int mc_ext_header(void)
d402 2
a403 2

	switch(info.dyn_cross_mode[sbgr])  /* 21.05.95 Ralf Schwalbe dyn. cross mode */
d419 40
a458 1
	   case 10:
d465 82
a546 2
 	   case 14:   printf(" Decoding of dynamic crosstalk is available in the next version (July95)/n");
		      printf(" Ask Ralf Schwalbe (FTZ Berlin) for a new shareware version. /n");
d820 1
a820 1
			int *mc_channel)
d837 1
a837 1
	 for (j = 2; j < *mc_channel; j++)
d865 1
a865 1
		 else       /* 15.05.1995 Ralf Schwalbe dyn-cross mode on */
d867 8
a874 1
		   if(fr_ps->header->dyn_cross_mode[sbgr]==0) 		  
d895 1
a895 1
		   } 
d897 29
a925 1
		  }    
d933 1
a933 1
	 for (j = 2; j < *mc_channel; j++)
d1078 1
a1078 1
			    int *mc_channel,
d1095 1
a1095 1
	   for ( k = 2; k < *mc_channel; k++)
d1123 1
a1123 1
		  else   /* 21.05.95 Ralf Schwalbe dyn. cross mode */
d1125 7
a1131 1
		   if(fr_ps->header->dyn_cross_mode[sbgr]==0) 
d1153 32
a1184 2
		   }  
		  } 
d1190 1
a1190 1
		 for(k = 2; k < *mc_channel; k++)
d1279 1
a1279 1
			     int *mc_channel,
d1295 1
a1295 1
		for (j = 2; j < *mc_channel; j++)
d1301 2
a1302 1
	else  /* 10.6.94 R.S. not ready yet */
d1305 1
a1305 1
		  case 0 : 	for (j = 2; j < *mc_channel; j++)
d1313 210
d1527 1
d2156 3
a2158 2
		  matr2 = 0.5 * (1.5 + 0.5 * (1.41632080078125));   /* Ls, Rs  */
		  matr3 = 0.5 + (0.75 * 1.41632080078125);	/* factor for C         */
@


1.5
log
@Moved merged IRT/Samsung/TI into main revision control trunk.
@
text
@d4 1
a4 1
 * $Id: decode.c 1.3.3.2 1995/06/16 08:42:59 rowlands Exp $
d11 9
d130 2
a131 6
 *  07/12/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                 Tel: +49 30 6708 2406                              *
 *                 Fax: +49 30 6774 539                               *
 *								      *
 *  04/11/94	   Ralf Schwalbe. Telekom FTZ Berlin                  *
 *                  - decoding extension bitstream                    *
d140 7
d158 1
a228 1
   
d230 1
d233 6
a238 9
/* R.S. prediction table MPEG-2 DIS March 25, 1994 */
int pred_coef_table[8][14] = {{4,3,3,2,2,1,1,0,4,3,3,2,2,2},
			      {3,2,2,2,1,1,1,0,3,3,3,2,2,2},
			      {3,2,2,2,1,1,1,0,3,3,3,2,2,2},
			      {4,3,3,2,2,1,1,0,4,3,3,2,2,2},
			      {4,3,3,2,2,1,1,0,4,3,3,2,2,2},
			      {4,3,3,2,2,1,1,0,4,3,3,2,2,2},
			      {3,2,2,2,1,1,1,0,3,3,3,2,2,2},
			      {3,2,2,2,1,1,1,0,3,3,3,2,2,2}};
d253 3
a255 1
   
d258 1
a258 4
			{
			hdr->tc_alloc[sbgr] = 0;
			
			}
d262 2
a263 2
   
		hdr->tc_allocation = 0;
d265 3
a267 1
			{
a268 2
			
			}
d275 1
a275 1
			hdr->dyn_cross_mode[sbgr] = getbits(bs,4);
d280 1
d297 4
a300 2
		 if(hdr->tc_sbgr_select == 1)
   		  for(pci=0; pci< pred_coef_table[hdr->tc_allocation][hdr->dyn_cross_mode[sbgr]] ; pci++)
a301 4
		 else
		  for(pci=0; pci< pred_coef_table[hdr->tc_alloc[sbgr]][hdr->dyn_cross_mode[sbgr]] ; pci++)
			 hdr->mc_predsi[sbgr][pci] = getbits(bs,2);
		 
d307 1
a321 1
/*			skip_ext_bits(&bs_ext, (info.ext_length - 12)); */
d329 13
a341 5
			/*bit_idx = bs->buf_bit_idx;*/
			/*byte_idx = bs->buf_byte_idx;*/
			/*if( mc_ext_error_check() == 0 )*/
			/*	return(0);               *//* false  */
  			/*else  return(1);               *//* true   */
d371 1
a371 2
   {
     if( info.dyn_cross_on == 0)
a374 1
		 	{
a375 1
		 	}
d377 1
a377 1
		 bit_alloc[j][i] = 0;
d379 39
a417 2
     /* else */  /* dyn. cross talk */
                 /* R.S. not included in shareware */     
d419 1
a419 3
 

	
d441 1
a441 1
     if( info.dyn_cross_on == 0)
d444 2
a445 7
		 if((fr_ps->header->center != 3) || (i < 12) || (j !=2))
		 	{
		 	bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);

		 	}
		 else
		 bit_alloc[j][i] = 0;
a446 2
     /* else */  /* dyn. cross talk */
                 /* R.S. not included in shareware */     
d448 2
a449 3
	
   for (i=jsbound;i<sblimit;i++)   /* expand to 2 channels */
	  bit_alloc[0][i] = bit_alloc[1][i] = (char) getbits(bs,(*alloc)[i][0].bits);
d486 1
a486 1
   for (j=*l;j<*m;j++)   /* 2 bit scfsi */
d488 1
a488 1
	if (bit_alloc[j][i]) 
d490 1
a490 1
	  	scfsi[j][i] = (char) getbits(bs,2);
d492 4
a495 5
	  }
	  
	  }
	 for (i=sblimit;i<SBLIMIT;i++) 
	 {
d498 1
a498 1
	}
d507 1
a507 2
   
   for (j = *l; j < *m; j++) {
d509 1
a509 2
	  {
	  switch (scfsi[j][i]) {
d531 4
a534 7
			}
			
		}
      else {
	 scale_index[j][0][i] = scale_index[j][1][i] =
	 scale_index[j][2][i] = SCALE_RANGE-1;
	 
d536 1
d538 1
a538 1
   }
d541 1
a541 2
		 scale_index[j][2][i] = SCALE_RANGE-1;
   for (j=*l;j<*m;j++) {
d544 1
a545 1
   }
d648 1
a648 1
		 	{
d654 1
a654 2

		   }
a715 1

a720 1

d735 24
a758 9
		 /*else*/       /* 21.07.94 Ralf Schwalbe dyn. cross mode */
				/* R.S. not included in shareware */
	   }
	   else
	   {      /* for no sample transmitted */
		 for (k=0;k<3;k++) sample[j][k][i] = 0;
	   }
	 }
   }
d760 7
d769 1
a769 2
		for (k = 0; k < 3; k++)
		   sample[j][k][i] = 0;
d772 1
d796 6
a801 4
		 if(fr_ps->header->dyn_cross_on == 0)
		 {
			/* check for grouping in subband */
			if ((*alloc)[i][bit_alloc[j][i]].group==3)
d803 3
d807 6
a812 5
				for (m=0;m<3;m++)
				{
					k = (*alloc)[i][bit_alloc[j][i]].bits;
					sample[j][m][i] = (unsigned int) getbits(bs,k);
				}
d814 6
a819 16
			}
			else
			{    /* bit_alloc = 3, 5, 9 */
			  nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
			  k=(*alloc)[i][bit_alloc[j][i]].bits;
			  c = (unsigned int) getbits(bs, k);

			  for (k=0;k<3;k++)
			  {
				sample[j][k][i] = c % nlevels;
				c /= nlevels;
			  }
			}
		 }
		 /*else*/       /* 21.07.94 Ralf Schwalbe dyn. cross mode */
				/* R.S. not included in shareware */
d930 7
a936 7
		 for ( k = 2; k < *mc_channel; k++)
			if (bit_alloc[k][i])
			{
			  if (fr_ps->header->dyn_cross_on == 0)
			  {
			  /* locate MSB in the sample */
			   x = 0;
d938 1
a938 1
			   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
d940 4
a943 4
			   /* microsoft C thinks an int is a short */
			   while (( (unsigned long) (1L<<(long)x) <
				(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)
			   ) && ( x < 16) ) x++;
d945 4
a948 4
			   /* MSB inversion */
			   if (((sample[k][j][i] >> (x-1)) & 1) == 1)
					fraction[k][i][j][*z] = 0.0;
			   else  fraction[k][i][j][*z] = -1.0;
d950 3
a952 3
			   /* Form a 2's complement sample */
			   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
							(double) (1L<<(x-1));
d954 32
a985 9
			   /* Dequantize the sample */
			   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
			   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
			  }
			  /* else */   /* 21.07.94 Ralf Schwalbe dyn. cross mode */
			  	       /* R.S. not included in shareware */		  
			  
			} /* if bit_alloc */
			else fraction[k][i][j][*z] = 0.0;
d1014 1
a1014 2
			  if (fr_ps->header->dyn_cross_on == 0)
			  {
a1036 3
			  }
			  /* else */   /* 21.07.94 Ralf Schwalbe dyn. cross mode */
			  	       /* R.S. not included in shareware */		  
d1100 12
a1111 2
	/************** R.S. ***************/
 
a1241 3
#ifdef FAST_FILTER
	/* R.S. not included in shareware */
#else
a1248 1
#endif
a1301 3
#ifdef FAST_FILTER
	/* R.S. not included in shareware */
#else
a1308 1
#endif
a1334 1

d1340 2
a1341 1
	      unsigned long *psampFrames)
d1344 2
a1345 4
   int stereo = fr_ps->stereo;
   int mc_channel = fr_ps->mc_channel;
   static short int outsamp[1600];
   static long k = 0;
d1347 3
d1351 2
a1352 1
      for (i=0;i<num;i++) for (j=0;j<SBLIMIT;j++) {
d1354 4
a1357 2
         for (l=0; l<stereo + mc_channel; l++) {
            if (!(k%1600) && k) {
d1359 4
a1362 4
			   k = 0;
			}
			outsamp[k++] = pcm_sample[l][i][j];
		 }
d1364 2
a1365 1
   else {
a1378 2
   int stereo = fr_ps->stereo;
   int mc_channel = fr_ps->mc_channel;
d1401 1
d1418 2
a1419 1
			unsigned long *psampFrames)
d1437 1
a1437 1
	  out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames);
d1444 1
a1444 1
		 out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames);
d1453 1
a1453 1
         out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames);
a1713 1

@


1.5.1.0
log
@Created branch for Telekom FTZ
@
text
@d4 1
a4 1
 * $Id: decode.c 1.5 1995/06/16 08:49:22 rowlands Exp $
a10 3
 * Revision 1.5  1995/06/16  08:49:22  rowlands
 * Moved merged IRT/Samsung/TI into main revision control trunk.
 *
@


1.5.1.1
log
@Input from Telekom FTZ
@
text
@d2 44
a45 3
Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved
decode.c
**********************************************************************/
a46 5
 * MPEG/audio coding/decoding software, work in progress              *
 *   NOT for public distribution until verified and approved by the   *
 *   MPEG/audio committee.  For further information, please contact   *
 *   Davis Pan, 508-493-2241, e-mail: pan@@gauss.enet.dec.com          *
 *                                                                    *
d124 6
a129 2
 *  04/11/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                  - decoding tc-allocation                          *
a135 2
 *  07/12/94       Ralf Schwalbe, Telekom FTZ Berlin                  *
 *                  - decoding extension bitstream                    *
d137 1
a137 5
 *  Version 1.1.1 Shareware                                           *
 *                 Ralf Schwalbe, Telekom FTZ Berlin                  *
 *                  - fixed some bugs                                 *
 *                                                                    *
 *  13/06/95       Ralf Schwalbe,  Telekom FTZ Berlin                 *
d143 6
a148 1
 /*********************************************************************/
d219 2
a220 1
   read_mpeg2_part = 1;
d223 9
a231 6
/* R.S. prediction table MPEG-2 IS March 29, 1995 */
int pred_coef_table[5][16] = {{6,4,4,4,2,2,2,0,4,4,4,2,2,2,2,0},
			      {4,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0},
			      {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
			      {4,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0},
			      {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}};
d239 1
d246 1
a246 3
	if( mc_channel == 1)
		hdr->tc_allocation = getbits(bs,2);
	else
d248 5
a252 2
	for(sbgr = 0; sbgr < 12; sbgr++)   /* all sbgr R.S. */
		hdr->tc_alloc[sbgr] = hdr->tc_allocation;
d256 2
a257 2
	hdr->tc_allocation = 0;
	if( mc_channel == 1)
d259 1
a259 3
			hdr->tc_alloc[sbgr] = getbits(bs, 2);
	else
		for(sbgr = 0; sbgr < 12; sbgr++)
d261 2
d274 26
a301 1

d303 1
a303 2
int mc_ext_header(Bit_stream_struc *bs)

d316 1
d324 5
a328 12
			bit_idx = bs->buf_bit_idx;
			byte_idx = bs->buf_byte_idx;
#ifdef EXTENSION_CRC_CHECK
			for( i = 0; i < 14; i++)
				info.ext_crc_bits[i] = look_ahead(&bs_ext, 8);
			info.ext_crc_bits[i] = look_ahead(&bs_ext, 4);
			bs->buf_bit_idx = bit_idx;
			bs->buf_byte_idx = byte_idx;		
			if( mc_ext_error_check() == 0 )
				return(0);   	     /* false  */
  			else    return(1);           /* true   */
#endif
d345 1
a345 1
			unsigned int bit_alloc[5][SBLIMIT],
d356 1
d358 2
a359 1
     if( info.dyn_cross_on == 0 || read_mpeg2_part == 0)
d363 3
a365 1
		 bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);
d369 4
a372 12
     else  /* dyn. cross mode */
     {
	if(i == 0) sbgr = 0;
	else
	   for(c = 1; c < 12; c++)
	   {
	      if((sb_groups[c-1] < i) && (i <= sb_groups[c]))
	      {
		sbgr = c;  /* search the valid subband group */
		break;
	       }
	    }
d374 24
a397 1
	switch(info.dyn_cross_mode[sbgr])  /* 21.05.95 Ralf Schwalbe dyn. cross mode */
d399 3
a401 8
	   case 0 :  for (j=*l;j<*m;j++)
		     {
			if((fr_ps->header->center != 3) || (i < 12) || (j !=2))
				bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);
			else
				bit_alloc[j][i] = 0;
		     }
		     break;
d403 3
a405 15
	   case 1 :    /* always 2 transmission channels */
	   case 2 :
	   case 3 :
	   case 8 :
	   case 9 :
	   case 10:
	   case 4 :    /* always 1 transmission channel */
	   case 5 :
	   case 6 :
	   case 11:
	   case 12:
	   case 13:
 	   case 14:   printf(" Decoding of dynamic crosstalk is available in the next version (July95)/n");
		      printf(" Ask Ralf Schwalbe (FTZ Berlin) for a new shareware version. /n");
			break;
d407 4
a410 1
     }
d414 1
a414 1
   for (i=sblimit;i<SBLIMIT;i++) for (j=*l;j<*m;j++)
d431 2
d435 3
a437 3
		     unsigned int scfsi[5][SBLIMIT], 
		     unsigned int bit_alloc[5][SBLIMIT],
		     unsigned int scale_index[5][3][SBLIMIT],
d447 16
a462 4
   for (i=0;i<sblimit;i++) for (j=*l;j<*m;j++)   /* 2 bit scfsi */
	  if (bit_alloc[j][i]) scfsi[j][i] = (char) getbits(bs,2);
   for (i=sblimit;i<SBLIMIT;i++) for (j=*l;j<*m;j++)
	  scfsi[j][i] = 0;
d464 9
a472 1
   for (i = 0; i < sblimit; i++) for (j = *l; j < *m; j++) {
d474 1
d476 75
d553 3
a555 2
				  scale_index[j][1][i] = getbits(bs,6);
				  scale_index[j][2][i] = getbits(bs,6);
d559 3
a561 2
				  scale_index[j][1][i] = getbits(bs,6);
				  scale_index[j][2][i] = getbits(bs,6);
d564 4
a567 3
	 case 3 : scale_index[j][0][i] = getbits(bs,6);
				  scale_index[j][1][i] =
				  scale_index[j][2][i] =  getbits(bs,6);
d573 1
d582 1
a582 1
   for (i=sblimit;i<SBLIMIT;i++) for (j=*l;j<*m;j++) {
d617 3
a619 2
		   for (m=0;m<3;m++)
		   {
d622 2
d632 1
d660 1
a660 1
			int *mc_ch)
d677 1
a677 1
	 for (j = 2; j < *mc_ch; j++)
d692 1
d699 1
d707 40
a746 1
		 else       /* 15.05.1995 Ralf Schwalbe dyn-cross mode on */
d748 2
a749 3
		   if(fr_ps->header->dyn_cross_mode[sbgr]==0) 		  
		   {
		  	if ((*alloc)[i][bit_alloc[j][i]].group==3)
d751 1
d754 2
a755 2
				    k = (*alloc)[i][bit_alloc[j][i]].bits;
				    sample[j][m][i] = (unsigned int) getbits(bs,k);
d757 12
a768 11
			 }
			 else
			 {    /* bit_alloc = 3, 5, 9 */
			 	nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
				k=(*alloc)[i][bit_alloc[j][i]].bits;
				c = (unsigned int) getbits(bs, k);
				for (k=0;k<3;k++)
				{
					sample[j][k][i] = c % nlevels;
					c /= nlevels;
				}
d770 11
a780 1
		   } 
a781 7
		  }    
	   } 
	   else   /* if bit_alloc = 0 -> no sample transmitted */
	   	 for (k=0;k<3;k++) sample[j][k][i] = 0;
	 }  /* for channel loop */
   }  /* for sblimit loop */

d783 3
a785 2
	 for (j = 2; j < *mc_ch; j++)
		for (k = 0; k < 3; k++)  sample[j][k][i] = 0;
d867 1
a867 1
			    int *mc_ch,
d876 15
a890 14
	if( i == 0) sbgr = 0 ;
	else
	   for(l = 1; l < 12; l++)
		if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
		{
		    sbgr = l; break;
		}
	for (j = 0; j < 3; j++)
	   for ( k = 2; k < *mc_ch; k++)
		if (bit_alloc[k][i])
		{
		  if (fr_ps->header->dyn_cross_on == 0)
		  {
		   x = 0;
d892 1
a892 1
		   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
d894 4
a897 3
		   /* microsoft C thinks an int is a short */
		   while (( (unsigned long) (1L<<(long)x) <
			(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)) && ( x < 16) ) x++;
d899 22
a920 2
		   /* MSB inversion */
		   if (((sample[k][j][i] >> (x-1)) & 1) == 1)
d922 1
a922 1
		   else  fraction[k][i][j][*z] = -1.0;
a923 3
		   /* Form a 2's complement sample */
		   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
						(double) (1L<<(x-1));
d925 24
a948 9
		   /* Dequantize the sample */
		   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
		   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
		  }
		  else   /* 21.05.95 Ralf Schwalbe dyn. cross mode */
		  {
		   if(fr_ps->header->dyn_cross_mode[sbgr]==0) 
		   {
			x = 0;
d950 1
a950 1
			while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
d952 4
a955 3
			/* microsoft C thinks an int is a short */
			while (( (unsigned long) (1L<<(long)x) <
			(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)) && ( x < 16) ) x++;
d957 4
a960 4
			/* MSB inversion */
			if (((sample[k][j][i] >> (x-1)) & 1) == 1)
			      fraction[k][i][j][*z] = 0.0;
			else  fraction[k][i][j][*z] = -1.0;
d962 3
a964 3
			/* Form a 2's complement sample */
			fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
						(double) (1L<<(x-1));
d966 8
a973 7
			/* Dequantize the sample */
			fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
			fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
		   }  
		  } 
		} /* if bit_alloc */
	  	else fraction[k][i][j][*z] = 0.0;
d977 1
a977 1
		 for(k = 2; k < *mc_ch; k++)
a980 1

d1013 1
a1013 1
			     int *mc_ch,
d1022 6
a1027 6
	else
	        for(l = 1; l < 12; l++)
		     if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
		     {
			sbgr = l; break;
		     }
d1029 1
a1029 1
		for (j = 2; j < *mc_ch; j++)
d1035 25
a1059 2
	else  /* 10.6.94 R.S. not ready yet */
		switch(fr_ps->header->dyn_cross_mode[sbgr])
d1061 6
a1066 9
		  case 0 : 	for (j = 2; j < *mc_ch; j++)
				{
				fraction[j][i][0][*z] *= multiple[scale_index[j][x][i]];
				fraction[j][i][1][*z] *= multiple[scale_index[j][x][i]];
				fraction[j][i][2][*z] *= multiple[scale_index[j][x][i]];
				}
			  	break;

		} /* end switch */
d1149 1
a1149 1
    typedef double BB[5][2*HAN_SIZE];
d1167 3
d1177 1
d1203 15
d1219 50
d1274 1
a1274 2
	      unsigned long *psampFrames,
	      int ch)
d1277 4
a1280 4
   /*int stereo = fr_ps->stereo;
   int mc_channel = fr_ps->mc_channel;*/
static short int outsamp[1600];
static long k = 0;
a1281 3
  if( (mpeg == 1) && (frameNum == 1) ) 
  /* 6.4.1995 R.S. do nothing to avoid a spike in the first decoded 24 ms  */;
  else		
d1283 1
a1283 2
      for (i=0;i<num;i++) for (j=0;j<SBLIMIT;j++) 
      {
d1285 2
a1286 4
         for (l = 0; l < ch; l++)
	 {
            if (!(k%1600) && k) 
	    {
d1288 4
a1291 4
	       k = 0;
	    }
	    outsamp[k++] = pcm_sample[l][i][j];
	}
d1293 1
a1293 2
   else 
   {
d1299 38
d1347 1
a1347 2
			unsigned long *psampFrames,
			int ch)
d1365 1
a1365 1
	  out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames, ch);
d1372 1
a1372 1
		 out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames, ch);
d1381 1
a1381 1
         out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames, ch);
d1385 69
d1455 3
a1457 1
		 frame_params *fr_ps) 
d1464 4
a1467 1
  double tmp_sample;
d1472 1
a1472 2
	/* factors according to Committee Draft and telefax 10/20/93 */
	/* by E.Schroeder, DTB Hannover.  01/14/94, SR               */
d1474 4
a1477 2
	  case 0: matr1 = 2.42797851625;			    	/* factor for L and R   */
		  matr2 = 2 + 1.41632080078125;			    /* factor for C, Ls, Rs */
d1479 3
a1481 3
	  case 1: matr1 = 1.5 + (0.5 * 1.41632080078125);	/* factor for L, R      */
		  matr2 = 0.5 * (1.5 + 0.5 * (1.41632080078125));   /* Ls, Rs  */
		  matr3 = 0.5 + (0.75 * 1.41632080078125);	/* factor for C         */
a1482 5
	  case 2: matr1 = 2.42797851625;			    	/* factor for L and R   */
		  matr2 = 2 + 1.41632080078125;			    /* factor for C, Ls, Rs */
		  printf("NOT DONE MATRIX 2 !!\n");
		  exit(0);
		  break;
d1485 1
d1519 7
a1525 2
			if(fr_ps->header->dematrix_procedure != 3)
			{
d1535 14
a1548 4
			tmp_sample = pcm_sample[2][k][j][jj]; /* L */
			pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
			pcm_sample[0][k][j][jj] = tmp_sample;
d1555 14
a1568 4
			tmp_sample = pcm_sample[2][k][j][jj]; /* R */
			pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
			pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			pcm_sample[1][k][j][jj] = tmp_sample;
a1638 2
			 if(fr_ps->header->dematrix_procedure != 1)
			 {  /* surround channels */
a1639 6
				pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr2;
				pcm_sample[4][k][j][jj] = pcm_sample[4][k][j][jj] * matr2;
			 }
			 else
			 {
				pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;
d1643 130
a1772 2
			 }
		 }
@


1.5.1.2
log
@Merged with Distribution_02, marked by flag _FTZ
@
text
@a1 44
#ifndef _FTZ
 * Copyright (c) 1995 MPEG/audio software simulation group
 * All Rights Reserved
 * $Id: decode.c 1.5 1995/06/16 08:49:22 rowlands Exp $
 *
 * MPEG/audio coding/decoding software, work in progress
 *   NOT for public distribution until verified and approved by the
 *   MPEG/audio committee.
 *
 * $Log: decode.c $
 * Revision 1.5  1995/06/16  08:49:22  rowlands
 * Moved merged IRT/Samsung/TI into main revision control trunk.
 *
 * Revision 1.3.3.2  1995/06/16  08:42:59  rowlands
 * Merged and tested revisions 1.4 and 1.3.3.1
 *
 * Revision 1.3.3.1  1995/06/16  08:00:46  rowlands
 * Input from Samsung AIT.
 *
 * Revision 1.4  1995/06/16  06:19:08  rowlands
 * Moved merged IRT/TI into main revision control trunk.
 *
 * Revision 1.3.2.2  1995/06/16  06:10:31  rowlands
 * Merged and tested revisions 1.3.1.4 and 1.3.2.1 .
 *
 * Revision 1.3.2.1  1995/06/16  03:27:20  rowlands
 * Corrected prediction select syntax according to IS
 *
 * Revision 1.3.2.0  1995/06/16  03:22:45  rowlands
 * Created branch for IRT
 *
 * Revision 1.3.1.4  1995/06/16  03:11:37  rowlands
 * Added dematrixing procedure 2. Corrected dematrix weighting values.
 *
 * Revision 1.3.1.0  1995/05/23  02:34:26  rowlands
 * Created branch for TI
 *
 * Revision 1.3  1995/04/06  05:01:42  rowlands
 * Ran decoder through protoize to convert to ANSI C.
 *
 * Revision 1.2  1995/04/06  04:56:00  rowlands
 * Added header, RCS info and cleaned up prototypes in initial revision.
 *
#else _FTZ
d4 1
a4 5
#endif _FTZ
 **********************************************************************/
#ifndef _FTZ

#endif _FTZ
a5 1
#ifdef _FTZ
a10 1
#endif _FTZ
a87 8
#ifndef _FTZ
 *  07/12/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                 Tel: +49 30 6708 2406                              *
 *                 Fax: +49 30 6774 539                               *
 *								      *
 *  04/11/94	   Ralf Schwalbe. Telekom FTZ Berlin                  *
 *                  - decoding extension bitstream                    *
#else _FTZ
a89 1
#endif _FTZ
d96 1
a96 5
#ifndef _FTZ
 *                                                                    *
#endif _FTZ
 *  07/12/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
#ifdef _FTZ
a103 1
#endif _FTZ
a108 8
#ifndef _FTZ
/**********************************************************************
 *                                                                    *
 *  06/06/95       Yeon Bae Thomas Kim,  Samsung AIT                  *
 *                 ancillary data is working                          *
 *								      *
 **********************************************************************/
#else _FTZ
a109 1
#endif _FTZ
a179 4
#ifndef _FTZ
   

#else _FTZ
a180 1
#endif _FTZ
a182 11
#ifndef _FTZ
/* R.S. prediction table MPEG-2 DIS March 25, 1994 */
int pred_coef_table[8][14] = {{4,3,3,2,2,1,1,0,4,3,3,2,2,2},
			      {3,2,2,2,1,1,1,0,3,3,3,2,2,2},
			      {3,2,2,2,1,1,1,0,3,3,3,2,2,2},
			      {4,3,3,2,2,1,1,0,4,3,3,2,2,2},
			      {4,3,3,2,2,1,1,0,4,3,3,2,2,2},
			      {4,3,3,2,2,1,1,0,4,3,3,2,2,2},
			      {3,2,2,2,1,1,1,0,3,3,3,2,2,2},
			      {3,2,2,2,1,1,1,0,3,3,3,2,2,2}};
#else _FTZ
a188 1
#endif _FTZ
a195 3
#ifndef _FTZ

#endif _FTZ
a201 3
#ifndef _FTZ
   
#else _FTZ
a204 1
#endif _FTZ
d206 1
a206 6
		for(sbgr = 0; sbgr < 12; sbgr++)   /* all sbgr R.S. */
#ifndef _FTZ
			{
			hdr->tc_alloc[sbgr] = 0;
			
#else _FTZ
a207 3
#endif _FTZ
			}
#ifndef _FTZ
a208 1
#endif _FTZ
d211 1
a211 5
#ifndef _FTZ
   
#endif _FTZ
		hdr->tc_allocation = 0;
#ifdef _FTZ
a212 1
#endif _FTZ
a213 3
#ifndef _FTZ
			{
#else _FTZ
a216 1
#endif _FTZ
a217 5
#ifndef _FTZ
			
#endif _FTZ
			}
#ifndef _FTZ
a218 1
#endif _FTZ
a228 29
#ifndef _FTZ
/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
   for(sbgr = 0; sbgr < 12; sbgr++)
	for(pci=0; pci < 4; pci++)
	   hdr->mc_predsi[sbgr][pci] = 0;

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

   if( hdr->mc_prediction_on == 1)
   {
	  for(sbgr = 0; sbgr < 8; sbgr++) 
	  {  /* new sbgr < 8 */
		if( (hdr->mc_prediction[sbgr] = get1bit(bs)) == 1 )
		{
/* R.S. read from npredcoef-table max number of coef. for 3/2 configuration */
/* and then the predsi info -> 0    : no prediction    */
/*			    -> 1..4 : 1..4 coefficient */
		 if(hdr->tc_sbgr_select == 1)
   		  for(pci=0; pci< pred_coef_table[hdr->tc_allocation][hdr->dyn_cross_mode[sbgr]] ; pci++)
			 hdr->mc_predsi[sbgr][pci] = getbits(bs,2);
		 else
		  for(pci=0; pci< pred_coef_table[hdr->tc_alloc[sbgr]][hdr->dyn_cross_mode[sbgr]] ; pci++)
			 hdr->mc_predsi[sbgr][pci] = getbits(bs,2);
		 
#endif _FTZ
		}
#ifndef _FTZ
	  }
   }
a229 1
#endif _FTZ
a230 1
#ifdef _FTZ
a231 1
#endif _FTZ
a232 3
#ifndef _FTZ
int mc_ext_header(void)
#else _FTZ
a234 1
#endif _FTZ
a246 3
#ifndef _FTZ
/*			skip_ext_bits(&bs_ext, (info.ext_length - 12)); */
#endif _FTZ
a253 7
#ifndef _FTZ
			/*bit_idx = bs->buf_bit_idx;*/
			/*byte_idx = bs->buf_byte_idx;*/
			/*if( mc_ext_error_check() == 0 )*/
			/*	return(0);               *//* false  */
  			/*else  return(1);               *//* true   */
#else _FTZ
a265 1
#endif _FTZ
d282 1
a282 1
			unsigned int bit_alloc[5][SBLIMIT],	
a292 3
#ifndef _FTZ
 
#endif _FTZ
a293 4
#ifndef _FTZ
   {
     if( info.dyn_cross_on == 0)
#else _FTZ
a294 1
#endif _FTZ
d298 1
a298 7
#ifndef _FTZ
		 	{
#endif _FTZ
		 	bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);
#ifndef _FTZ
		 	}
#endif _FTZ
a301 4
#ifndef _FTZ
     /* else */  /* dyn. cross talk */
                 /* R.S. not included in shareware */     
#else _FTZ
d312 2
a313 4
#endif _FTZ
	}
#ifndef _FTZ
 
a314 17
	
   for (i=jsbound;i<sblimit;i++)   /* expand to 2 channels */
	  bit_alloc[0][i] = bit_alloc[1][i] = (char) getbits(bs,(*alloc)[i][0].bits);

   for (i=sblimit;i<SBLIMIT;i++) for (j=*l;j<*m;j++)
	  bit_alloc[j][i] = 0;
#endif _FTZ
}

#ifndef _FTZ
/************15/03/1995 TEST**********/
void II_decode_bitalloc_test(Bit_stream_struc *bs,
			unsigned int bit_alloc[5][SBLIMIT],	
			frame_params *fr_ps,
			int *l,
			int *m  )
#else _FTZ
d316 1
a316 13
#endif _FTZ
{
#ifndef _FTZ
   int i,j,c,sbgr;
   /* int stereo = fr_ps->stereo; */ /* not used for mc - decoding */
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;

   for (i=0;i<jsbound;i++)
     if( info.dyn_cross_on == 0)
	for (j=0;j<*m;j++)
#else _FTZ
d318 6
a323 18
#endif _FTZ
	{
		 if((fr_ps->header->center != 3) || (i < 12) || (j !=2))
#ifndef _FTZ
		 	{
#endif _FTZ
		 	bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);
#ifndef _FTZ

		 	}
#endif _FTZ
		 else
		 bit_alloc[j][i] = 0;
	}
#ifndef _FTZ
     /* else */  /* dyn. cross talk */
                 /* R.S. not included in shareware */     
#else _FTZ
a324 1
#endif _FTZ
a325 3
#ifndef _FTZ
	
#else _FTZ
a342 1
#endif _FTZ
a345 3
#ifndef _FTZ
   for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++)
#else _FTZ
a346 1
#endif _FTZ
a362 4
#ifndef _FTZ
/* JMZ 09/03/1995 Multilingual adaptations */
/**********************************************************************/
#endif _FTZ
d365 3
a367 3
		     unsigned int scfsi[5][SBLIMIT], 		
		     unsigned int bit_alloc[5][SBLIMIT],	
		     unsigned int scale_index[5][3][SBLIMIT],	
a376 16
#ifndef _FTZ
   for (i=0;i<sblimit;i++) 
   {
   for (j=*l;j<*m;j++)   /* 2 bit scfsi */
   	{
	if (bit_alloc[j][i]) 
		{
	  	scfsi[j][i] = (char) getbits(bs,2);
	  	}
	  }
	  
	  }
	 for (i=sblimit;i<SBLIMIT;i++) 
	 {
	 for (j=*l;j<*m;j++)
#else _FTZ
d380 1
a380 5
#endif _FTZ
		scfsi[j][i] = 0;
#ifndef _FTZ
	}
#endif _FTZ
a381 11
#ifndef _FTZ

   /* 3.6.94 R.S. read the prediction coefficients in the mc - part */
   /* R.S. not included in Shareware */
	
	     
   for (i = 0; i < sblimit; i++) 
   {
   
   for (j = *l; j < *m; j++) {
#else _FTZ
a382 1
#endif _FTZ
a383 3
#ifndef _FTZ
	  {
#endif _FTZ
a384 86
			/* all three scale factors transmitted */
			case 0 : scale_index[j][0][i] = getbits(bs,6);
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);
				  break;
			/* scale factor 1 & 3 transmitted */
			case 1 : scale_index[j][0][i] =
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);
				  break;
			/* scale factor 1 & 2 transmitted */
			case 3 :scale_index[j][0][i] = getbits(bs,6);
				scale_index[j][1][i] =
				scale_index[j][2][i] =  getbits(bs,6);
				break;
			/* only one scale factor transmitted */
			case 2 : scale_index[j][0][i] =
				scale_index[j][1][i] =
				scale_index[j][2][i] = getbits(bs,6);
				break;
			default : break;
			}
#ifndef _FTZ
			
		}
#endif _FTZ
      else {
	 scale_index[j][0][i] = scale_index[j][1][i] =
	 scale_index[j][2][i] = SCALE_RANGE-1;
#ifndef _FTZ
	 
#endif _FTZ
	  }
   }
#ifndef _FTZ
   }
   for (i=sblimit;i<SBLIMIT;i++)
   { 
		 scale_index[j][2][i] = SCALE_RANGE-1;
   for (j=*l;j<*m;j++) {
#else _FTZ
   for (i=sblimit;i<SBLIMIT;i++) for (j=*l;j<*m;j++) {
#endif _FTZ
		 scale_index[j][0][i] = scale_index[j][1][i] =
		 scale_index[j][2][i] = SCALE_RANGE-1;
   }
   }
#ifndef _FTZ
}
#endif _FTZ

#ifndef _FTZ
/**********************************************************************/
/* JMZ 15/03/1995 Multilingual TEST */
/**********************************************************************/

void II_decode_scale_test(Bit_stream_struc *bs,
		     unsigned int scfsi[5][SBLIMIT], 		
		     unsigned int bit_alloc[5][SBLIMIT],	
		     unsigned int scale_index[5][3][SBLIMIT],	
		     frame_params *fr_ps,
		     int *l, 
		     int *m)
{
   int i,j;
   int px,pci;
   /* int stereo  = fr_ps->stereo; */ /* not used for mc - decoding */
   int sblimit = fr_ps->sblimit;


   for (i=0;i<sblimit;i++) for (j=0;j<*m;j++)   /* 2 bit scfsi */
	if (bit_alloc[j][i]) 
		{
	  	scfsi[j][i] = (char) getbits(bs,2);

	  	}
	 for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++)
		scfsi[j][i] = 0;


   /* 3.6.94 R.S. read the prediction coefficients in the mc - part */
   /* R.S. not included in Shareware */
	
   for (i = 0; i < sblimit; i++) for (j = 0; j < *m; j++) {
	  if (bit_alloc[j][i])
	  switch (scfsi[j][i]) {
d387 2
a388 3
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);

d392 2
a393 3
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);

d396 3
a398 4
		case 3 :scale_index[j][0][i] = getbits(bs,6);
				scale_index[j][1][i] =
				scale_index[j][2][i] =  getbits(bs,6);

a403 1

d412 1
a412 1
   for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++) {
a417 1
#endif _FTZ
d447 2
a448 5
#ifndef _FTZ
		 	{
#endif _FTZ
			for (m=0;m<3;m++)
			{
a450 3
			 }
#ifndef _FTZ

a451 1
#endif _FTZ
a458 3
#ifndef _FTZ

#endif _FTZ
a485 3
#ifndef _FTZ
			int *mc_channel)
#else _FTZ
a486 1
#endif _FTZ
a502 3
#ifndef _FTZ
	 for (j = 2; j < *mc_channel; j++)
#else _FTZ
a503 1
#endif _FTZ
a517 3
#ifndef _FTZ

#endif _FTZ
a523 3
#ifndef _FTZ

#endif _FTZ
a530 29
#ifndef _FTZ
		 /*else*/       /* 21.07.94 Ralf Schwalbe dyn. cross mode */
				/* R.S. not included in shareware */
	   }
	   else
	   {      /* for no sample transmitted */
		 for (k=0;k<3;k++) sample[j][k][i] = 0;
	   }
	 }
   }

   for (i = sblimit; i < SBLIMIT; i++)
	 for (j = 2; j < *mc_channel; j++)
		for (k = 0; k < 3; k++)
		   sample[j][k][i] = 0;
}

/***************************************************************/
/* 09/03/1995 JMZ Multilingual */

/***************************************************************/
/* 15/03/1995 JMZ TEST */

void II_buffer_sample_test(Bit_stream_struc *bs,
			unsigned int sample[5][3][SBLIMIT],
			unsigned int bit_alloc[5][SBLIMIT],
			frame_params *fr_ps,
			int *n_ml_ch)
#else _FTZ
d532 1
a532 10
#endif _FTZ
{
#ifndef _FTZ
   int i,j,k,m,sbgr,l;
   unsigned int nlevels, c=0;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   for (i = 0; i < sblimit; i++)
#else _FTZ
d534 2
a535 12
#endif _FTZ
   {
#ifndef _FTZ
	 for (j = 0; j < *n_ml_ch; j++)
	 {
	   if (bit_alloc[j][i])
	   {
		 if(fr_ps->header->dyn_cross_on == 0)
		 {
			/* check for grouping in subband */
#endif _FTZ
			if ((*alloc)[i][bit_alloc[j][i]].group==3)
a536 3
#ifndef _FTZ

#endif _FTZ
d539 2
a540 2
					k = (*alloc)[i][bit_alloc[j][i]].bits;
					sample[j][m][i] = (unsigned int) getbits(bs,k);
d542 11
a552 16
#ifndef _FTZ

#endif _FTZ
			}
			else
			{    /* bit_alloc = 3, 5, 9 */
			  nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
			  k=(*alloc)[i][bit_alloc[j][i]].bits;
			  c = (unsigned int) getbits(bs, k);
#ifndef _FTZ

#endif _FTZ
			  for (k=0;k<3;k++)
			  {
				sample[j][k][i] = c % nlevels;
				c /= nlevels;
d554 1
a554 6
			}
		 }
#ifndef _FTZ
		 /*else*/       /* 21.07.94 Ralf Schwalbe dyn. cross mode */
				/* R.S. not included in shareware */
#else _FTZ
d556 2
a557 12
#endif _FTZ
	   }
#ifndef _FTZ
	   else
	   {      /* for no sample transmitted */
		 for (k=0;k<3;k++) sample[j][k][i] = 0;
#endif _FTZ
	   }
#ifndef _FTZ
	 }
   }
#else _FTZ
a561 1
#endif _FTZ
a563 5
#ifndef _FTZ
	 for (j = 0; j < *n_ml_ch; j++)
		for (k = 0; k < 3; k++)
		   sample[j][k][i] = 0;
#else _FTZ
a565 1
#endif _FTZ
a646 3
#ifndef _FTZ
			    int *mc_channel,
#else _FTZ
a647 1
#endif _FTZ
d656 8
a663 11
	  if( i == 0) sbgr = 0 ;
	  else
		for(l = 1; l < 12; l++)
			if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
			{
				sbgr = l; break;
			}
	  for (j = 0; j < 3; j++)
#ifndef _FTZ
		 for ( k = 2; k < *mc_channel; k++)
#else _FTZ
d665 5
a669 9
#endif _FTZ
			if (bit_alloc[k][i])
			{
			  if (fr_ps->header->dyn_cross_on == 0)
			  {
#ifndef _FTZ
			  /* locate MSB in the sample */
#endif _FTZ
			   x = 0;
d671 1
a671 1
			   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
d673 2
a674 6
			   /* microsoft C thinks an int is a short */
			   while (( (unsigned long) (1L<<(long)x) <
#ifndef _FTZ
				(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)
			   ) && ( x < 16) ) x++;
#else _FTZ
a675 1
#endif _FTZ
d677 2
a678 23
			   /* MSB inversion */
			   if (((sample[k][j][i] >> (x-1)) & 1) == 1)
					fraction[k][i][j][*z] = 0.0;
			   else  fraction[k][i][j][*z] = -1.0;

			   /* Form a 2's complement sample */
			   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
							(double) (1L<<(x-1));

			   /* Dequantize the sample */
			   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
			   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
			  }
#ifndef _FTZ
			  /* else */   /* 21.07.94 Ralf Schwalbe dyn. cross mode */
			  	       /* R.S. not included in shareware */		  
			  
			} /* if bit_alloc */
			else fraction[k][i][j][*z] = 0.0;
   }
   for (i = sblimit; i < SBLIMIT; i++)
	  for (j = 0; j < 3; j++)
		 for(k = 2; k < *mc_channel; k++)
d680 1
a680 1
}
d682 3
d686 4
a689 10
/*************************************************************************/
/* JMZ 09/03/1995 Multilingual */

void II_dequantize_sample_test(unsigned int sample[5][3][SBLIMIT],
			    unsigned int bit_alloc[5][SBLIMIT],
			    double fraction[5][SBLIMIT][3][12],
			    frame_params *fr_ps,
			    int *n_ml_ch,
			    int *z)
#else _FTZ
d691 1
a691 9
#endif _FTZ
{
#ifndef _FTZ
   int i, j, k, x,sbgr,l;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   for (i = 0; i < sblimit; i++)
#else _FTZ
d693 2
a694 12
#endif _FTZ
   {
#ifndef _FTZ
	  for (j = 0; j < 3; j++)
		 for ( k = 0; k < *n_ml_ch; k++)
			if (bit_alloc[k][i])
			{
			  if (fr_ps->header->dyn_cross_on == 0)
			  {
			  /* locate MSB in the sample */
#endif _FTZ
			   x = 0;
d696 1
a696 1
			   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
d698 2
a699 6
			   /* microsoft C thinks an int is a short */
			   while (( (unsigned long) (1L<<(long)x) <
#ifndef _FTZ
				(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)
			   ) && ( x < 16) ) x++;
#else _FTZ
a700 1
#endif _FTZ
d702 4
a705 4
			   /* MSB inversion */
			   if (((sample[k][j][i] >> (x-1)) & 1) == 1)
					fraction[k][i][j][*z] = 0.0;
			   else  fraction[k][i][j][*z] = -1.0;
d707 3
a709 3
			   /* Form a 2's complement sample */
			   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
							(double) (1L<<(x-1));
d711 4
a714 8
			   /* Dequantize the sample */
			   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
			   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
			  }
#ifndef _FTZ
			  /* else */   /* 21.07.94 Ralf Schwalbe dyn. cross mode */
			  	       /* R.S. not included in shareware */		  
#else _FTZ
d716 2
a717 3
#endif _FTZ
			} /* if bit_alloc */
			else fraction[k][i][j][*z] = 0.0;
a720 3
#ifndef _FTZ
		 for(k = 0; k < *n_ml_ch; k++)
#else _FTZ
a721 1
#endif _FTZ
a724 1
#ifdef _FTZ
a725 1
#endif _FTZ
a757 3
#ifndef _FTZ
			     int *mc_channel,
#else _FTZ
a758 1
#endif _FTZ
d767 6
a772 6
	  else
		for(l = 1; l < 12; l++)
			if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
			{
				sbgr = l; break;
			}
a773 3
#ifndef _FTZ
		for (j = 2; j < *mc_channel; j++)
#else _FTZ
a774 1
#endif _FTZ
a779 19
#ifndef _FTZ
	/************** R.S. ***************/
 
   } /* for sblimit */
}

/*************************************************************/
/* JMZ 09/03/1995 Multilingual */

/*************************************************************/
/* JMZ 15/03/1995 TEST */

void II_denormalize_sample_test(double fraction[5][SBLIMIT][3][12],
			     unsigned int scale_index[5][3][SBLIMIT],
			     frame_params *fr_ps,
			     int x,
			     int *n_ml_ch,
			     int *z)
#else _FTZ
d782 1
a782 8
#endif _FTZ
{
#ifndef _FTZ
   int i,j,k,sbgr,l,bl=0;
   int sblimit = fr_ps->sblimit;

   for (i = 0; i < sblimit; i++)
#else _FTZ
d784 5
a788 14
#endif _FTZ
   {
#ifndef _FTZ
	if(fr_ps->header->dyn_cross_on == 0)
		for (j = 0; j < *n_ml_ch; j++)
		{
#endif _FTZ
			fraction[j][i][0][*z] *= multiple[scale_index[j][x][i]];
			fraction[j][i][1][*z] *= multiple[scale_index[j][x][i]];
			fraction[j][i][2][*z] *= multiple[scale_index[j][x][i]];
		}
#ifndef _FTZ
	/************** R.S. ***************/
#else _FTZ
d790 1
a790 3
#endif _FTZ
 
#ifdef _FTZ
a791 1
#endif _FTZ
d874 1
a874 1
    typedef double BB[5][2*HAN_SIZE]; 
a891 5
#ifndef _FTZ
#ifdef FAST_FILTER
	/* R.S. not included in shareware */
#else
#endif _FTZ
a898 3
#ifndef _FTZ
#endif
#endif _FTZ
a923 17
#ifndef _FTZ
int SubBandSynthesis_test (double *bandPtr,
		      int channel,
		      long *samples)
{
    long foo;
    register int i,j,k;
    register double *bufOffsetPtr, sum;
    static int init = 1;
    typedef double NN[64][32];
    static NN *filter;
    typedef double BB[5][2*HAN_SIZE]; 
    static BB *buf;
    static int bufOffset = 64;
    static double *window;
    int clip = 0;               /* count & return how many samples clipped */
#endif _FTZ
a924 52
#ifndef _FTZ
    if (init) {
		buf = (BB *) mem_alloc(sizeof(BB),"BB");
		filter = (NN *) mem_alloc(sizeof(NN), "NN");
		create_syn_filter(*filter);
		window = (double *) mem_alloc(sizeof(double) * HAN_SIZE, "WIN");
		read_syn_window(window);
		bufOffset = 64;
		init = 0;
	}
	if (channel == 0) bufOffset = (bufOffset - 64) & 0x3ff;
	bufOffsetPtr = &((*buf)[channel][bufOffset]);

#ifdef FAST_FILTER
	/* R.S. not included in shareware */
#else
	for (i=0; i<64; i++)
	{
		sum = 0;
		for (k=0; k<32; k++)
			sum += bandPtr[k] * (*filter)[i][k];
		bufOffsetPtr[i] = sum;
	}
#endif

	/*  S(i,j) = D(j+32i) * U(j+32i+((i+1)>>1)*64)  */
	/*  samples(i,j) = MWindow(j+32i) * bufPtr(j+32i+((i+1)>>1)*64)  */
	for (j=0; j<32; j++)
	{
        sum = 0;
		for (i=0; i<16; i++)
		{
			k = j + (i<<5);
            sum += window[k] * (*buf) [channel] [( (k + ( ((i+1)>>1) <<6) ) +
                                                  bufOffset) & 0x3ff];
        }

/*   {long foo = (sum > 0) ? sum * SCALE + 0.5 : sum * SCALE - 0.5; */
/*   {long foo = sum * SCALE;  */
     
	 foo = floor(sum * SCALE + 0.5);
	 if (foo >= (long) SCALE)      {samples[j] = SCALE-1; ++clip;}
	 else if (foo < (long) -SCALE) {samples[j] =-SCALE;  ++clip;}
	 else                           samples[j] = foo;
 
    }
    return(clip);
}



#endif _FTZ
a929 3
#ifndef _FTZ
	      unsigned long *psampFrames)
#else _FTZ
a931 1
#endif _FTZ
a933 4
#ifndef _FTZ
   int stereo = fr_ps->stereo;
   int mc_channel = fr_ps->mc_channel;
#else _FTZ
d936 2
a937 3
#endif _FTZ
   static short int outsamp[1600];
   static long k = 0;
a938 1
#ifdef _FTZ
a941 1
#endif _FTZ
a942 24
#ifndef _FTZ
      for (i=0;i<num;i++) for (j=0;j<SBLIMIT;j++) {
         (*psampFrames)++;
         for (l=0; l<stereo + mc_channel; l++) {
            if (!(k%1600) && k) {
               fwrite(outsamp,2,1600,outFile);
			   k = 0;
			}
			outsamp[k++] = pcm_sample[l][i][j];
		 }
      }
   else {
      fwrite(outsamp,2,(int)k,outFile);
	  k = 0;
   }
}

void out_fifo_test(long pcm_sample[5][3][SBLIMIT],
	      int num,
	      frame_params *fr_ps,
	      int done,
	      FILE *outFile,
	      unsigned long *psampFrames)
#else _FTZ
d944 1
a944 13
#endif _FTZ
{
#ifndef _FTZ
   int i,j,l;
   int stereo = fr_ps->stereo;
   int mc_channel = fr_ps->mc_channel;
   int n_ml_ch = fr_ps->header->no_of_multi_lingual_ch;
   static short int outsamp[1600];
   static long k = 0;

   if (!done)
      for (i=0;i<num;i++) for (j=0;j<SBLIMIT;j++) {
#endif _FTZ
a945 4
#ifndef _FTZ
         for (l=0; l<n_ml_ch; l++) {
            if (!(k%1600) && k) {
#else _FTZ
a949 1
#endif _FTZ
d951 4
a954 7
			   k = 0;
			}
			outsamp[k++] = pcm_sample[l][i][j];
		 }
#ifndef _FTZ

#endif _FTZ
a955 3
#ifndef _FTZ
   else {
#else _FTZ
a957 1
#endif _FTZ
a962 8
#ifndef _FTZ
/*************************************************/
/* JMZ 10/03/1995 Multilingual */

/* JMZ 10/03/1995 Multilingual */
/*************************************************/

#endif _FTZ
a972 3
#ifndef _FTZ
			unsigned long *psampFrames)
#else _FTZ
a974 1
#endif _FTZ
a991 3
#ifndef _FTZ
	  out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames);
#else _FTZ
a992 1
#endif _FTZ
a998 3
#ifndef _FTZ
		 out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames);
#else _FTZ
a999 1
#endif _FTZ
a1007 3
#ifndef _FTZ
         out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames);
#else _FTZ
a1008 1
#endif _FTZ
a1011 71
#ifndef _FTZ

/**************************************************************/
/* routines for dematrix2_filter */


static double	dematrix2_filter_coeff[3][4] = {
	/* a0    b0     b1   b2 */
	{ 295, 2048, -1394, 521},	/* 44.1 kHz */
	{ 294, 2048, -1388, 520},	/* 48 kHz */
	{ 486, 2048,  -471, 370}	/* 32 kHz */
};

/*
 * init_dematrix2_filter_state()
 *
 *	This routine initializes the state vector of the dematrix
 *	procedure 2 filter to zero. The state should be initialized:
 *	- at startup
 *	- whenever the previous frame did not use dematrix procedure 2
 *	- whenever the sample rate changes
 */
void
init_dematrix2_filter_state(
	double	state[3]
) {
	state[0] = 0.0;
	state[1] = 0.0;
	state[2] = 0.0;
}

/*
 * dematrix2_filter()
 *	This routine accepts one sample of the mono surround signal,
 *	and produces one sample of the filtered signal for dematrix
 *	procedure 2.
 */
double
dematrix2_filter(
	frame_params *fr_ps,
	double	state[3],
	double	sample
) {
#ifndef	DISABLE_DEMATRIX2_FILTER
	int	sfreq = fr_ps->header->sampling_frequency;
	double	filteredSample;

	state[2] = state[1];
	state[1] = state[0];

	state[0] = (
		sample -
		dematrix2_filter_coeff[sfreq][2] * state[1] -
		dematrix2_filter_coeff[sfreq][3] * state[2]
	) / dematrix2_filter_coeff[sfreq][1];

	filteredSample = dematrix2_filter_coeff[sfreq][0] * (
		state[0] + 2 * state[1] + state[2]
	);

	return(filteredSample);
#else
	return(sample);
#endif
}


/**************************************************************/
/* JMZ 09/03/1995 Multilingual modifications */

#endif _FTZ
a1012 5
#ifndef _FTZ
			frame_params *fr_ps,
			double dematrix2_filter_state[3],
			double pred_buf[2][8][36+PREDDEL]) 
#else _FTZ
a1013 1
#endif _FTZ
a1019 3
#ifndef _FTZ
  double tmp_sample, filtered_sample;
#else _FTZ
a1020 5
#endif _FTZ
  
#ifndef _FTZ
  /* JMZ 09/03/1995 Multilingual */
  int n_ml_ch = info->no_of_multi_lingual_ch;
a1021 1
#endif _FTZ
a1024 3
#ifndef _FTZ
	/* factors according to International Standard */
#else _FTZ
a1026 1
#endif _FTZ
a1027 6
#ifndef _FTZ
	  case 0:
	  case 2: matr1 = 1 + sqrt(2.0);	/* factor for L and R   */
		  matr2 = sqrt(2.0) * matr1;	/* factor for C */
		  matr3 = sqrt(2.0) * matr1;	/* factor for Ls, Rs */
#else _FTZ
a1029 1
#endif _FTZ
a1030 5
#ifndef _FTZ
	  case 1: matr1 = (1.5 + 0.5*sqrt(2.0));/* factor for L, R      */
		  matr2 = sqrt(2.0) * matr1;	/* factor for C         */
		  matr3 = 2 * matr1;		/* factor for Ls, Rs  */
#else _FTZ
a1033 1
#endif _FTZ
a1034 1
#ifdef _FTZ
a1039 1
#endif _FTZ
a1041 3
#ifndef _FTZ
		  matr3 = 1.0;
#endif _FTZ
a1074 9
#ifndef _FTZ
			if (fr_ps->header->dematrix_procedure == 2) {
			    filtered_sample =
				dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
			    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
			    pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
			}
			else if (fr_ps->header->dematrix_procedure != 3) {
#else _FTZ
a1076 1
#endif _FTZ
d1086 4
a1089 20
#ifndef _FTZ
			if (fr_ps->header->dematrix_procedure == 2) {
				filtered_sample =
					dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
#endif _FTZ
				tmp_sample = pcm_sample[2][k][j][jj]; /* L */
#ifndef _FTZ
				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
				pcm_sample[0][k][j][jj] = tmp_sample;
			}
			else {
				tmp_sample = pcm_sample[2][k][j][jj]; /* L */
#endif _FTZ
				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
				pcm_sample[0][k][j][jj] = tmp_sample;
#ifndef _FTZ
			}
#endif _FTZ
d1096 4
a1099 20
#ifndef _FTZ
			if (fr_ps->header->dematrix_procedure == 2) {
				filtered_sample =
					dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
#endif _FTZ
				tmp_sample = pcm_sample[2][k][j][jj]; /* R */
#ifndef _FTZ
				pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
				pcm_sample[1][k][j][jj] = tmp_sample;
			}
			else {
				tmp_sample = pcm_sample[2][k][j][jj]; /* R */
#endif _FTZ
				pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				pcm_sample[1][k][j][jj] = tmp_sample;
#ifndef _FTZ
			}
#endif _FTZ
a1169 1
#ifdef _FTZ
a1171 1
#endif _FTZ
a1172 1
#ifdef _FTZ
a1178 1
#endif _FTZ
d1182 2
a1183 132
#ifndef _FTZ
			}
}


void dematricing_test(double pcm_sample[5][SBLIMIT][3][12], 
			frame_params *fr_ps, 
			double pred_buf[2][8][36+PREDDEL]) 
{
  double matr1;   /* normalizing factor */
  double matr2;   /* matricing factor   */
  double matr3;   /* matricing factor   */
  int i, j, jj, k, tc_alloc, l, sbgr = 0 ;
  layer *info = fr_ps->header;
  double tmp_sample;
  
  /* JMZ 09/03/1995 Multilingual */
  int n_ml_ch = info->no_of_multi_lingual_ch;

  switch(info->dematrix_procedure)
  {

	/* factors according to Committee Draft and telefax 10/20/93 */
	/* by E.Schroeder, DTB Hannover.  01/14/94, SR               */

	  case 0: matr1 = 2.42797851625;			    	/* factor for L and R   */
		  matr2 = 2 + 1.41632080078125;			    /* factor for C, Ls, Rs */
		  matr3 = matr2;	/* 09/03/1995 JMZ Multilingual */ /* factor for C, Ls, Rs */
		  break;
	  case 1: matr1 = 1.5 + (0.5 * 1.41632080078125);	/* factor for L, R      */
		  matr2 = 0.5 * (1.5 + 0.5 * (1.41632080078125));   /* Ls, Rs  */
		  matr3 = 0.5 + (0.75 * 1.41632080078125);	/* factor for C         */
		  break;
	  case 2: matr1 = 2.42797851625;			    	/* factor for L and R   */
		  matr2 = 2 + 1.41632080078125;			    /* factor for C, Ls, Rs */
		  matr3 = matr2;
		  break;
	  case 3: matr1 = 1.0;
		  matr2 = 1.0;
		  matr3 = matr2;	/* 09/03/1995 JMZ Multilingual */ 
		  break;
  }



/* denormalized signals */
	if( fr_ps->header->dematrix_procedure != 3 ) 		/* dematrixing */
	  for (jj=0; jj<12; jj++)
		for( j = 0; j < 3; ++j)
			for(k = 0; k < SBLIMIT; k ++)
			{   /* Lo / Ro */
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] * matr1;
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] * matr1;
				pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr1;
				pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr1;
				pcm_sample[4][k][j][jj] = pcm_sample[4][k][j][jj] * matr1;

			}
}




		
/***********************************************************************
 *
 * ancillaryDecode
 *
 * Purpose : decode ancillary data
 *
 ***********************************************************************/

void ancillaryDecode(fr_ps,bs,pp)
frame_params *fr_ps;
Bit_stream_struc *bs;
long pp;
{

	int bitsPerSlot;
    	int samplesPerFrame;
	int bit_rate;
	int avg_slots_per_frame;
	int Slot_for_ThisFrame;
	int whole_SpF;
	int usedAdb;
	int adbNumberStart;
	int l;
	int AncillaryUse = 0;
	long p1;
	char anc[150];
	extern int anc_index;
				 
	register int i;
				      
				       
	double frac_SpF;
	double slot_lag;
	layer *info = fr_ps->header;
					    
	if (info->lay == 1) { bitsPerSlot = 32; samplesPerFrame = 384;  }
	else               { bitsPerSlot = 8;  samplesPerFrame = 1152; }
							      
	bit_rate = bitrate[info->lay-1][info->bitrate_index];
								   
	avg_slots_per_frame = ((double)samplesPerFrame /
			  s_freq[info->sampling_frequency]) *
			    ((double)bit_rate / (double)bitsPerSlot);
	whole_SpF = (int) avg_slots_per_frame;
	Slot_for_ThisFrame = avg_slots_per_frame + info->padding;

	p1 = sstell(bs) - pp;

	if(p1 <= Slot_for_ThisFrame*8-8) {

		if(p1 % 8) {
			l = getbits(bs,8-(p1%8));
			p1 += (8 - (p1 % 8));
		}
		while(p1 < Slot_for_ThisFrame*8-8)
		{
			l = getbits(bs,8);
			p1 += 8;
		}
		l =  getbits(bs,8);
		if(l && (AncillaryUse==0))
			AncillaryUse = 1;
		if(AncillaryUse){
			anc[anc_index++] = (char)l;
			fprintf(stderr,"\t\t>>>>  %c  <<<<\n", (char)l);
#endif _FTZ
		}
	}
@


1.5.1.3
log
@Merged old and new functionality.
@
text
@d2 1
d5 1
a5 1
 * $Id: decode.c 1.5.1.2 1995/06/17 21:27:02 rowlands Exp rowlands $
a11 3
 * Revision 1.5.1.2  1995/06/17  21:27:02  rowlands
 * Merged with Distribution_02, marked by flag _FTZ
 *
d45 4
d50 1
d52 1
d54 7
d138 8
d148 1
d155 1
d157 1
d159 1
d167 1
d173 1
d180 1
d182 1
d253 2
d256 1
d258 1
d261 11
d273 6
a278 5
int pred_coef_table[3][16] = {
	{2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},	/* 1 multichannel channel - 3/0, 2/1 */
	{4,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0},	/* 2 multichannel channels - 3/1, 2/2 */
	{6,4,4,4,2,2,2,0,4,4,4,2,2,2,2,0}	/* 3 multichannel channels - 3/2 */
};
d286 1
d288 1
d295 3
d301 1
d304 9
a312 1
			hdr->tc_alloc[sbgr] = hdr->tc_allocation;
d314 1
d317 5
a321 1
	hdr->tc_allocation = 0;
d323 1
d325 3
d331 1
d333 5
d339 1
d345 1
a345 1
			hdr->dyn_cross_mode[sbgr] = getbits(bs,4 /*##### fix this */);
d350 1
a350 1

d367 2
a368 4

/* JR: updated according to IS. Number of prediction coefficients depends on	*/
/* number of multichannel channels and dynamic crosstalk mode			*/
   		  for(pci=0; pci< pred_coef_table[mc_channel - 1][hdr->dyn_cross_mode[sbgr]] ; pci++)
d370 5
d376 1
d380 1
d382 1
d384 1
d386 1
d388 4
d404 3
d414 9
a422 3

			bit_idx = bs_ext.buf_bit_idx;
			byte_idx = bs_ext.buf_byte_idx;
d426 3
a428 3
			info.ext_crc_bits[14] = look_ahead(&bs_ext, 4);
			bs_ext.buf_bit_idx = bit_idx;
			bs_ext.buf_byte_idx = byte_idx;		
d433 1
d461 1
d463 1
d465 4
d470 1
d474 3
d478 3
d482 1
a482 1
			 bit_alloc[j][i] = 0;
d484 4
d498 4
a501 2
	       }
	    }
d503 1
a503 28
	switch(info.dyn_cross_mode[sbgr])  /* 21.05.95 Ralf Schwalbe dyn. cross mode */
	{
	   case 0 :  for (j=*l;j<*m;j++)
		     {
			if((fr_ps->header->center != 3) || (i < 12) || (j !=2))
				bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);
			else
				bit_alloc[j][i] = 0;
		     }
		     break;

	   case 1 :    /* always 2 transmission channels */
	   case 2 :
	   case 3 :
	   case 8 :
	   case 9 :
	   case 10:
	   case 4 :    /* always 1 transmission channel */
	   case 5 :
	   case 6 :
	   case 11:
	   case 12:
	   case 13:
 	   case 14:   printf(" Decoding of dynamic crosstalk is available in the next version (July95)/n");
		      printf(" Ask Ralf Schwalbe (FTZ Berlin) for a new shareware version. /n");
			break;
	}
     }
d509 1
d512 1
d519 3
d523 1
d531 1
a531 1
/* JR: no dynamic crosstalk for multilingual channels */
d533 3
d537 11
a547 2
		/* JR: no phantom center coding for multilingual channels */
	 	bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);
d549 6
d556 23
a578 2
/* JR: no joint coding for multilingual channels */
/* JR: they're really simple, aren't they? */
d580 1
d582 3
d601 1
d604 1
d619 1
d622 1
a622 1
	for (j=*l;j<*m;j++)   /* 2 bit scfsi */
d624 1
a624 1
		if (bit_alloc[j][i]) 
d626 1
a626 1
	  		scfsi[j][i] = (char) getbits(bs,2);
d628 5
a632 4
	 }
    }
    for (i=sblimit;i<SBLIMIT;i++) 
    {
d634 5
d640 3
a642 1
    }
d644 1
d652 5
a656 1
      for (j = *l; j < *m; j++) {
d658 4
a661 1
	      switch (scfsi[j][i]) {
d683 11
a693 4
	      }
	  else {
		scale_index[j][0][i] = scale_index[j][1][i] =
		scale_index[j][2][i] = SCALE_RANGE-1;
a694 1
      }
d696 2
a697 1

d700 5
a704 1
	for (j=*l;j<*m;j++) {
a706 1
	}
d708 2
d711 1
d713 1
d785 1
d815 3
a817 1
	 	 {
d823 4
a826 1
		 }
d834 1
d836 1
d864 1
d866 3
d885 1
d887 3
d898 1
d904 3
d913 1
d915 1
d923 10
a932 24
		 else       /* 15.05.1995 Ralf Schwalbe dyn-cross mode on */
		 {
		   if(fr_ps->header->dyn_cross_mode[sbgr]==0) 		  
		   {
		  	if ((*alloc)[i][bit_alloc[j][i]].group==3)
			{
				for (m=0;m<3;m++)
				{
				    k = (*alloc)[i][bit_alloc[j][i]].bits;
				    sample[j][m][i] = (unsigned int) getbits(bs,k);
				}
			 }
			 else
			 {    /* bit_alloc = 3, 5, 9 */
			 	nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
				k=(*alloc)[i][bit_alloc[j][i]].bits;
				c = (unsigned int) getbits(bs, k);
				for (k=0;k<3;k++)
				{
					sample[j][k][i] = c % nlevels;
					c /= nlevels;
				}
			  }
		   } 
a933 7
		  }    
	   } 
	   else   /* if bit_alloc = 0 -> no sample transmitted */
	   	 for (k=0;k<3;k++) sample[j][k][i] = 0;
	 }  /* for channel loop */
   }  /* for sblimit loop */

d936 2
a937 1
		for (k = 0; k < 3; k++)  sample[j][k][i] = 0;
a939 1

d951 3
d955 1
d962 3
d966 1
d971 7
a977 4
		/* JR: no dynamic crosstalk for multilingual channels */
		/* check for grouping in subband */
		if ((*alloc)[i][bit_alloc[j][i]].group==3)
		{
d979 9
a987 4
			for (m=0;m<3;m++)
			{
				k = (*alloc)[i][bit_alloc[j][i]].bits;
				sample[j][m][i] = (unsigned int) getbits(bs,k);
d989 6
d996 12
a1007 6
		}
		else
		{    /* bit_alloc = 3, 5, 9 */
		  nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
		  k=(*alloc)[i][bit_alloc[j][i]].bits;
		  c = (unsigned int) getbits(bs, k);
d1009 1
a1009 6
		  for (k=0;k<3;k++)
		  {
			sample[j][k][i] = c % nlevels;
			c /= nlevels;
		  }
		}
d1011 1
d1015 1
d1017 1
d1020 6
d1028 1
d1032 4
d1117 1
d1119 3
d1138 13
a1150 7
	   for ( k = 2; k < *mc_channel; k++)
		if (bit_alloc[k][i])
		{
		  if (fr_ps->header->dyn_cross_on == 0)
		  {
		  /* locate MSB in the sample */
		   x = 0;
d1152 1
a1152 1
		   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
d1154 6
a1159 28
		   /* microsoft C thinks an int is a short */
		   while (( (unsigned long) (1L<<(long)x) <
			(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)
		   ) && ( x < 16) ) x++;
#endif
		   /* MSB inversion */
		   if (((sample[k][j][i] >> (x-1)) & 1) == 1)
				fraction[k][i][j][*z] = 0.0;
		   else  fraction[k][i][j][*z] = -1.0;

		   /* Form a 2's complement sample */
		   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
						(double) (1L<<(x-1));

		   /* Dequantize the sample */
		   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
		   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
		  }
		  else   /* 21.05.95 Ralf Schwalbe dyn. cross mode */
		  {
		   if(fr_ps->header->dyn_cross_mode[sbgr]==0) 
		   {
			x = 0;
#ifndef MSDOS
			while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
#else
			/* microsoft C thinks an int is a short */
			while (( (unsigned long) (1L<<(long)x) <
d1161 1
d1163 4
a1166 4
			/* MSB inversion */
			if (((sample[k][j][i] >> (x-1)) & 1) == 1)
			      fraction[k][i][j][*z] = 0.0;
			else  fraction[k][i][j][*z] = -1.0;
d1168 3
a1170 3
			/* Form a 2's complement sample */
			fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
						(double) (1L<<(x-1));
d1172 10
a1181 7
			/* Dequantize the sample */
			fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
			fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
		   }  
		  } 
		} /* if bit_alloc */
	  	else fraction[k][i][j][*z] = 0.0;
d1199 3
d1203 1
d1209 3
d1213 1
d1218 2
a1219 1
			  /* JR: ditto */
d1221 1
d1228 1
d1231 3
d1247 7
d1259 1
d1261 3
d1267 3
d1302 1
d1304 3
d1322 1
d1324 3
d1332 3
a1334 12
	else  /* 10.6.94 R.S. not ready yet */
		switch(fr_ps->header->dyn_cross_mode[sbgr])
		{
		  case 0 : 	for (j = 2; j < *mc_channel; j++)
				{
				fraction[j][i][0][*z] *= multiple[scale_index[j][x][i]];
				fraction[j][i][1][*z] *= multiple[scale_index[j][x][i]];
				fraction[j][i][2][*z] *= multiple[scale_index[j][x][i]];
				}
			  	break;

		} /* end switch */
d1350 4
d1355 1
d1360 3
d1364 1
d1368 1
d1373 1
d1375 3
d1379 3
d1482 5
d1494 3
d1522 1
d1538 1
d1540 1
d1553 3
d1563 1
d1590 2
d1597 3
d1602 1
d1605 9
a1613 2
static short int outsamp[1600];
static long k = 0;
d1615 1
d1619 1
d1621 2
a1622 2
      for (i=0;i<num;i++) for (j=0;j<SBLIMIT;j++) 
      {
d1624 2
a1625 4
         for (l = 0; l < ch; l++)
	 {
            if (!(k%1600) && k) 
	    {
d1627 4
a1630 4
	       k = 0;
	    }
	    outsamp[k++] = pcm_sample[l][i][j];
	}
d1632 1
a1632 2
   else 
   {
d1644 3
d1648 1
d1650 2
d1658 1
d1660 1
d1663 6
d1674 1
d1676 1
d1678 1
d1680 4
d1689 1
a1689 1

d1696 1
d1707 3
d1712 1
d1730 3
d1734 1
d1741 3
d1745 1
d1754 3
d1758 1
d1762 1
d1832 1
d1834 1
d1838 3
d1847 1
d1849 3
d1853 1
d1857 1
d1861 1
d1863 4
d1868 1
d1873 4
d1878 1
d1882 5
d1888 7
d1897 1
d1899 1
d1933 1
d1941 4
d1954 1
d1958 1
d1960 1
d1967 1
d1971 1
d1973 1
d1980 1
d1984 1
d1986 1
d1993 1
d1997 1
d1999 1
d2070 4
d2075 8
d2085 2
d2215 1
@


1.4
log
@Moved merged IRT/TI into main revision control trunk.
@
text
@d4 1
a4 1
 * $Id: decode.c 1.3.2.2 1995/06/16 06:10:31 rowlands Exp $
d11 9
d140 6
a145 1
 /*********************************************************************/
d1698 74
@


1.3
log
@Ran decoder through protoize to convert to ANSI C.
@
text
@d4 1
a4 1
 * $Id: decode.c,v 1.2 1995/04/06 04:56:00 rowlands Exp rowlands $
d10 19
a28 1
 * $Log: decode.c,v $
d276 3
d1368 1
d1370 65
d1438 2
a1439 1
			frame_params *fr_ps, 
d1447 1
a1447 1
  double tmp_sample;
d1455 1
a1455 2
	/* factors according to Committee Draft and telefax 10/20/93 */
	/* by E.Schroeder, DTB Hannover.  01/14/94, SR               */
d1457 4
a1460 3
	  case 0: matr1 = 2.42797851625;			    	/* factor for L and R   */
		  matr2 = 2 + 1.41632080078125;			    /* factor for C, Ls, Rs */
		  matr3 = matr2;	/* 09/03/1995 JMZ Multilingual */ /* factor for C, Ls, Rs */
d1462 3
a1464 3
	  case 1: matr1 = 1.5 + (0.5 * 1.41632080078125);	/* factor for L, R      */
		  matr2 = 0.5 * (1.5 + 0.5 * (1.41632080078125));   /* Ls, Rs  */
		  matr3 = 0.5 + (0.75 * 1.41632080078125);	/* factor for C         */
a1465 5
	  case 2: matr1 = 2.42797851625;			    	/* factor for L and R   */
		  matr2 = 2 + 1.41632080078125;			    /* factor for C, Ls, Rs */
		  printf("NOT DONE MATRIX 2 !!\n");
		  exit(0);
		  break;
d1468 1
a1468 1
		  matr3 = matr2;	/* 09/03/1995 JMZ Multilingual */ 
d1502 7
a1508 2
			if(fr_ps->header->dematrix_procedure != 3)
			{
d1518 14
a1531 4
			tmp_sample = pcm_sample[2][k][j][jj]; /* L */
			pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
			pcm_sample[0][k][j][jj] = tmp_sample;
d1538 14
a1551 4
			tmp_sample = pcm_sample[2][k][j][jj]; /* R */
			pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
			pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			pcm_sample[1][k][j][jj] = tmp_sample;
d1660 1
a1660 2
		  printf("NOT DONE MATRIX 2 !!\n");
		  exit(0);
@


1.3.3.0
log
@Created branch for Samsung
@
text
@d4 1
a4 1
 * $Id: decode.c 1.3 1995/04/06 05:01:42 rowlands Exp $
d10 1
a10 4
 * $Log: decode.c $
 * Revision 1.3  1995/04/06  05:01:42  rowlands
 * Ran decoder through protoize to convert to ANSI C.
 *
@


1.3.3.1
log
@Input from Samsung AIT.
@
text
@d4 1
a4 1
 * $Id: decode.c,v 1.3 1995/04/06 05:01:42 rowlands Exp $
d10 1
a10 1
 * $Log: decode.c,v $
d116 1
a116 6
/**********************************************************************
 *                                                                    *
 *  06/06/95       Yeon Bae Thomas Kim,  Samsung AIT                  *
 *                 ancillary data is working                          *
 *								      *
 **********************************************************************/
a1579 74




		
/***********************************************************************
 *
 * ancillaryDecode
 *
 * Purpose : decode ancillary data
 *
 ***********************************************************************/

void ancillaryDecode(fr_ps,bs,pp)
frame_params *fr_ps;
Bit_stream_struc *bs;
long pp;
{

	int bitsPerSlot;
    	int samplesPerFrame;
	int bit_rate;
	int avg_slots_per_frame;
	int Slot_for_ThisFrame;
	int whole_SpF;
	int usedAdb;
	int adbNumberStart;
	int l;
	int AncillaryUse = 0;
	long p1;
	char anc[150];
	extern int anc_index;
				 
	register int i;
				      
				       
	double frac_SpF;
	double slot_lag;
	layer *info = fr_ps->header;
					    
	if (info->lay == 1) { bitsPerSlot = 32; samplesPerFrame = 384;  }
	else               { bitsPerSlot = 8;  samplesPerFrame = 1152; }
							      
	bit_rate = bitrate[info->lay-1][info->bitrate_index];
								   
	avg_slots_per_frame = ((double)samplesPerFrame /
			  s_freq[info->sampling_frequency]) *
			    ((double)bit_rate / (double)bitsPerSlot);
	whole_SpF = (int) avg_slots_per_frame;
	Slot_for_ThisFrame = avg_slots_per_frame + info->padding;

	p1 = sstell(bs) - pp;

	if(p1 <= Slot_for_ThisFrame*8-8) {

		if(p1 % 8) {
			l = getbits(bs,8-(p1%8));
			p1 += (8 - (p1 % 8));
		}
		while(p1 < Slot_for_ThisFrame*8-8)
		{
			l = getbits(bs,8);
			p1 += 8;
		}
		l =  getbits(bs,8);
		if(l && (AncillaryUse==0))
			AncillaryUse = 1;
		if(AncillaryUse){
			anc[anc_index++] = (char)l;
			fprintf(stderr,"\t\t>>>>  %c  <<<<\n", (char)l);
		}
	}
}

@


1.3.3.2
log
@Merged and tested revisions 1.4 and 1.3.3.1
@
text
@d4 1
a4 1
 * $Id: decode.c 1.3.3.2 1995/06/16 08:32:13 rowlands Exp $
d10 1
a10 22
 * $Log: decode.c $
 * Revision 1.3.3.1  1995/06/16  08:00:46  rowlands
 * Input from Samsung AIT.
 *
 * Revision 1.4  1995/06/16  06:19:08  rowlands
 * Moved merged IRT/TI into main revision control trunk.
 *
 * Revision 1.3.2.2  1995/06/16  06:10:31  rowlands
 * Merged and tested revisions 1.3.1.4 and 1.3.2.1 .
 *
 * Revision 1.3.2.1  1995/06/16  03:27:20  rowlands
 * Corrected prediction select syntax according to IS
 *
 * Revision 1.3.2.0  1995/06/16  03:22:45  rowlands
 * Created branch for IRT
 *
 * Revision 1.3.1.4  1995/06/16  03:11:37  rowlands
 * Added dematrixing procedure 2. Corrected dematrix weighting values.
 *
 * Revision 1.3.1.0  1995/05/23  02:34:26  rowlands
 * Created branch for TI
 *
a265 3
		 else
		  for(pci=0; pci< pred_coef_table[hdr->tc_alloc[sbgr]][hdr->dyn_cross_mode[sbgr]] ; pci++)
			 hdr->mc_predsi[sbgr][pci] = getbits(bs,2);
a1354 1

a1355 65
/* routines for dematrix2_filter */


static double	dematrix2_filter_coeff[3][4] = {
	/* a0    b0     b1   b2 */
	{ 295, 2048, -1394, 521},	/* 44.1 kHz */
	{ 294, 2048, -1388, 520},	/* 48 kHz */
	{ 486, 2048,  -471, 370}	/* 32 kHz */
};

/*
 * init_dematrix2_filter_state()
 *
 *	This routine initializes the state vector of the dematrix
 *	procedure 2 filter to zero. The state should be initialized:
 *	- at startup
 *	- whenever the previous frame did not use dematrix procedure 2
 *	- whenever the sample rate changes
 */
void
init_dematrix2_filter_state(
	double	state[3]
) {
	state[0] = 0.0;
	state[1] = 0.0;
	state[2] = 0.0;
}

/*
 * dematrix2_filter()
 *	This routine accepts one sample of the mono surround signal,
 *	and produces one sample of the filtered signal for dematrix
 *	procedure 2.
 */
double
dematrix2_filter(
	frame_params *fr_ps,
	double	state[3],
	double	sample
) {
#ifndef	DISABLE_DEMATRIX2_FILTER
	int	sfreq = fr_ps->header->sampling_frequency;
	double	filteredSample;

	state[2] = state[1];
	state[1] = state[0];

	state[0] = (
		sample -
		dematrix2_filter_coeff[sfreq][2] * state[1] -
		dematrix2_filter_coeff[sfreq][3] * state[2]
	) / dematrix2_filter_coeff[sfreq][1];

	filteredSample = dematrix2_filter_coeff[sfreq][0] * (
		state[0] + 2 * state[1] + state[2]
	);

	return(filteredSample);
#else
	return(sample);
#endif
}


/**************************************************************/
d1359 1
a1359 2
			frame_params *fr_ps,
			double dematrix2_filter_state[3],
d1367 1
a1367 1
  double tmp_sample, filtered_sample;
d1375 2
a1376 1
	/* factors according to International Standard */
d1378 3
a1380 4
	  case 0:
	  case 2: matr1 = 1 + sqrt(2.0);	/* factor for L and R   */
		  matr2 = sqrt(2.0) * matr1;	/* factor for C */
		  matr3 = sqrt(2.0) * matr1;	/* factor for Ls, Rs */
d1382 3
a1384 3
	  case 1: matr1 = (1.5 + 0.5*sqrt(2.0));/* factor for L, R      */
		  matr2 = sqrt(2.0) * matr1;	/* factor for C         */
		  matr3 = 2 * matr1;		/* factor for Ls, Rs  */
d1386 5
d1393 1
a1393 1
		  matr3 = 1.0;
d1427 2
a1428 7
			if (fr_ps->header->dematrix_procedure == 2) {
			    filtered_sample =
				dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
			    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
			    pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
			}
			else if (fr_ps->header->dematrix_procedure != 3) {
d1438 4
a1441 14
			if (fr_ps->header->dematrix_procedure == 2) {
				filtered_sample =
					dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
				tmp_sample = pcm_sample[2][k][j][jj]; /* L */
				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
				pcm_sample[0][k][j][jj] = tmp_sample;
			}
			else {
				tmp_sample = pcm_sample[2][k][j][jj]; /* L */
				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
				pcm_sample[0][k][j][jj] = tmp_sample;
			}
d1448 4
a1451 14
			if (fr_ps->header->dematrix_procedure == 2) {
				filtered_sample =
					dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
				tmp_sample = pcm_sample[2][k][j][jj]; /* R */
				pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
				pcm_sample[1][k][j][jj] = tmp_sample;
			}
			else {
				tmp_sample = pcm_sample[2][k][j][jj]; /* R */
				pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				pcm_sample[1][k][j][jj] = tmp_sample;
			}
d1560 2
a1561 1
		  matr3 = matr2;
@


1.3.2.0
log
@Created branch for IRT
@
text
@d4 1
a4 1
 * $Id: decode.c 1.3 1995/04/06 05:01:42 rowlands Exp $
d10 1
a10 4
 * $Log: decode.c $
 * Revision 1.3  1995/04/06  05:01:42  rowlands
 * Ran decoder through protoize to convert to ANSI C.
 *
@


1.3.2.1
log
@Corrected prediction select syntax according to IS
@
text
@d4 1
a4 1
 * $Id: decode.c,v 1.3 1995/04/06 05:01:42 rowlands Exp $
d10 1
a10 5
 * $Log: decode.c,v $
 * 
 * Revision 1.3.2.0  1995/06/16  03:22:45  rowlands
 * Created branch for IRT
 *
a259 3
			 hdr->mc_predsi[sbgr][pci] = getbits(bs,2);
		 else
		  for(pci=0; pci< pred_coef_table[hdr->tc_alloc[sbgr]][hdr->dyn_cross_mode[sbgr]] ; pci++)
@


1.3.2.2
log
@Merged and tested revisions 1.3.1.4 and 1.3.2.1 .
@
text
@d4 1
a4 1
 * $Id: decode.c 1.3.2.1 1995/06/16 03:27:20 rowlands Exp $
d10 2
a11 4
 * $Log: decode.c $
 * Revision 1.3.2.1  1995/06/16  03:27:20  rowlands
 * Corrected prediction select syntax according to IS
 *
a14 6
 * Revision 1.3.1.4  1995/06/16  03:11:37  rowlands
 * Added dematrixing procedure 2. Corrected dematrix weighting values.
 *
 * Revision 1.3.1.0  1995/05/23  02:34:26  rowlands
 * Created branch for TI
 *
a1356 1

a1357 65
/* routines for dematrix2_filter */


static double	dematrix2_filter_coeff[3][4] = {
	/* a0    b0     b1   b2 */
	{ 295, 2048, -1394, 521},	/* 44.1 kHz */
	{ 294, 2048, -1388, 520},	/* 48 kHz */
	{ 486, 2048,  -471, 370}	/* 32 kHz */
};

/*
 * init_dematrix2_filter_state()
 *
 *	This routine initializes the state vector of the dematrix
 *	procedure 2 filter to zero. The state should be initialized:
 *	- at startup
 *	- whenever the previous frame did not use dematrix procedure 2
 *	- whenever the sample rate changes
 */
void
init_dematrix2_filter_state(
	double	state[3]
) {
	state[0] = 0.0;
	state[1] = 0.0;
	state[2] = 0.0;
}

/*
 * dematrix2_filter()
 *	This routine accepts one sample of the mono surround signal,
 *	and produces one sample of the filtered signal for dematrix
 *	procedure 2.
 */
double
dematrix2_filter(
	frame_params *fr_ps,
	double	state[3],
	double	sample
) {
#ifndef	DISABLE_DEMATRIX2_FILTER
	int	sfreq = fr_ps->header->sampling_frequency;
	double	filteredSample;

	state[2] = state[1];
	state[1] = state[0];

	state[0] = (
		sample -
		dematrix2_filter_coeff[sfreq][2] * state[1] -
		dematrix2_filter_coeff[sfreq][3] * state[2]
	) / dematrix2_filter_coeff[sfreq][1];

	filteredSample = dematrix2_filter_coeff[sfreq][0] * (
		state[0] + 2 * state[1] + state[2]
	);

	return(filteredSample);
#else
	return(sample);
#endif
}


/**************************************************************/
d1361 1
a1361 2
			frame_params *fr_ps,
			double dematrix2_filter_state[3],
d1369 1
a1369 1
  double tmp_sample, filtered_sample;
d1377 2
a1378 1
	/* factors according to International Standard */
d1380 3
a1382 4
	  case 0:
	  case 2: matr1 = 1 + sqrt(2.0);	/* factor for L and R   */
		  matr2 = sqrt(2.0) * matr1;	/* factor for C */
		  matr3 = sqrt(2.0) * matr1;	/* factor for Ls, Rs */
d1384 3
a1386 3
	  case 1: matr1 = (1.5 + 0.5*sqrt(2.0));/* factor for L, R      */
		  matr2 = sqrt(2.0) * matr1;	/* factor for C         */
		  matr3 = 2 * matr1;		/* factor for Ls, Rs  */
d1388 5
d1395 1
a1395 1
		  matr3 = 1.0;
d1429 2
a1430 7
			if (fr_ps->header->dematrix_procedure == 2) {
			    filtered_sample =
				dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
			    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
			    pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
			}
			else if (fr_ps->header->dematrix_procedure != 3) {
d1440 4
a1443 14
			if (fr_ps->header->dematrix_procedure == 2) {
				filtered_sample =
					dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
				tmp_sample = pcm_sample[2][k][j][jj]; /* L */
				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
				pcm_sample[0][k][j][jj] = tmp_sample;
			}
			else {
				tmp_sample = pcm_sample[2][k][j][jj]; /* L */
				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
				pcm_sample[0][k][j][jj] = tmp_sample;
			}
d1450 4
a1453 14
			if (fr_ps->header->dematrix_procedure == 2) {
				filtered_sample =
					dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
				tmp_sample = pcm_sample[2][k][j][jj]; /* R */
				pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
				pcm_sample[1][k][j][jj] = tmp_sample;
			}
			else {
				tmp_sample = pcm_sample[2][k][j][jj]; /* R */
				pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				pcm_sample[1][k][j][jj] = tmp_sample;
			}
d1562 2
a1563 1
		  matr3 = matr2;
@


1.3.1.0
log
@Created branch for TI
@
text
@d4 1
a4 1
 * $Id: decode.c,v 1.3 1995/04/06 05:01:42 rowlands Exp $
a10 3
 * Revision 1.3  1995/04/06  05:01:42  rowlands
 * Ran decoder through protoize to convert to ANSI C.
 *
@


1.3.1.1
log
@Added routines and data structures for dematrix procedure 2.
Generalized the dematrixing routine a little bit to handle the
new cases.
@
text
@d4 1
a4 1
 * $Id: decode.c,v 1.3.1.0 1995/05/23 02:34:26 rowlands Exp rowlands $
a10 3
 * Revision 1.3.1.0  1995/05/23  02:34:26  rowlands
 * Created branch for TI
 *
a1349 1

a1350 58
/* routines for dematrix2_filter */


static double	dematrix2_filter_coeff[3][4] = {
	/* a0    b0     b1   b2 */
	{ 295, 2048, -1394, 521},	/* 44.1 kHz */
	{ 294, 2048, -1388, 520},	/* 48 kHz */
	{ 486, 2048,  -471, 370}	/* 32 kHz */
};

/*
 * init_dematrix2_filter_state()
 *
 *	This routine initializes the state vector of the dematrix
 *	procedure 2 filter to zero. The state should be initialized:
 *	- at startup
 *	- whenever the previous frame did not use dematrix procedure 2
 *	- whenever the sample rate changes
 */
void
init_dematrix2_filter_state(
	double	state[3]
) {
	state[0] = 0.0;
	state[1] = 0.0;
	state[2] = 0.0;
}

/*
 * dematrix2_filter()
 *	This routine accepts one sample of the mono surround signal,
 *	and produces one sample of the filtered signal for dematrix
 *	procedure 2.
 */
double
dematrix2_filter(
	frame_params *fr_ps,
	double	state[3],
	double	sample
) {
	int	sfreq = fr_ps->header->sampling_frequency;

	state[2] = state[1];
	state[1] = state[0];

	state[0] = (
		sample -
		dematrix2_filter_coeff[sfreq][2] * state[1] -
		dematrix2_filter_coeff[sfreq][3] * state[2]
	) / dematrix2_filter_coeff[sfreq][1];

	return dematrix2_filter_coeff[sfreq][0] * (
		state[0] + 2 * state[1] + state[2]
	);
}


/**************************************************************/
d1354 1
a1354 2
			frame_params *fr_ps,
			double dematrix2_filter_state[3],
d1362 1
a1362 1
  double tmp_sample, filtered_sample;
d1383 2
a1384 1
		  matr3 = matr2;
d1422 2
a1423 7
			if (fr_ps->header->dematrix_procedure == 2) {
			    filtered_sample =
				dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
			    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
			    pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
			}
			else if (fr_ps->header->dematrix_procedure != 3) {
d1433 4
a1436 14
			if (fr_ps->header->dematrix_procedure == 2) {
				filtered_sample =
					dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
				tmp_sample = pcm_sample[2][k][j][jj]; /* L */
				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
				pcm_sample[0][k][j][jj] = tmp_sample;
			}
			else {
				tmp_sample = pcm_sample[2][k][j][jj]; /* L */
				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
				pcm_sample[0][k][j][jj] = tmp_sample;
			}
d1443 4
a1446 14
			if (fr_ps->header->dematrix_procedure == 2) {
				filtered_sample =
					dematrix2_filter(fr_ps, dematrix2_filter_state, (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0);
				tmp_sample = pcm_sample[2][k][j][jj]; /* R */
				pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - filtered_sample;
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + filtered_sample;
				pcm_sample[1][k][j][jj] = tmp_sample;
			}
			else {
				tmp_sample = pcm_sample[2][k][j][jj]; /* R */
				pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
				pcm_sample[1][k][j][jj] = tmp_sample;
			}
d1555 2
a1556 1
		  matr3 = matr2;
@


1.3.1.2
log
@Fixed channel weighting for downmix procedures 0,1,3. Still need to
check dematrix procedure 2.
@
text
@d4 1
a4 1
 * $Id: decode.c 1.3.1.1 1995/06/14 04:37:41 rowlands Exp rowlands $
d10 1
a10 6
 * $Log: decode.c $
 * Revision 1.3.1.1  1995/06/14  04:37:41  rowlands
 * Added routines and data structures for dematrix procedure 2.
 * Generalized the dematrixing routine a little bit to handle the
 * new cases.
 *
d1433 2
a1434 1
	/* factors according to International Standard */
d1436 3
a1438 4
	  case 0:
	  case 2: matr1 = 1 + sqrt(2.0);	/* factor for L and R   */
		  matr2 = sqrt(2.0) * matr1;	/* factor for C */
		  matr3 = sqrt(2.0) * matr1;	/* factor for Ls, Rs */
d1440 3
a1442 3
	  case 1: matr1 = (1.5 + 0.5*sqrt(2.0));/* factor for L, R      */
		  matr2 = sqrt(2.0) * matr1;	/* factor for C         */
		  matr3 = 2 * matr1;		/* factor for Ls, Rs  */
d1444 4
d1450 1
a1450 1
		  matr3 = 1.0;
@


1.3.1.3
log
@Modified dematrix2_filter() procedure to get debug output
@
text
@d4 1
a4 1
 * $Id: decode.c 1.3.1.2 1995/06/15 18:20:12 rowlands Exp rowlands $
a10 4
 * Revision 1.3.1.2  1995/06/15  18:20:12  rowlands
 * Fixed channel weighting for downmix procedures 0,1,3. Still need to
 * check dematrix procedure 2.
 *
a1399 1
#ifndef	DISABLE_DEMATRIX2_FILTER
a1400 1
	double	filteredSample;
d1411 1
a1411 1
	filteredSample = dematrix2_filter_coeff[sfreq][0] * (
a1413 5

	return(filteredSample);
#else
	return(sample);
#endif
@


1.3.1.4
log
@Added dematrixing procedure 2. Corrected dematrix weighting values.
@
text
@d4 1
a4 1
 * $Id: decode.c 1.3.1.3 1995/06/16 02:03:48 rowlands Exp rowlands $
d11 9
@


1.2
log
@Added header, RCS info and cleaned up prototypes in initial revision.
@
text
@d4 1
a4 1
 * $Id$
d10 4
a13 1
 * $Log$
a265 1

@


1.1
log
@Initial revision
@
text
@d2 11
a12 3
Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved
decode.c
**********************************************************************/
a13 5
 * MPEG/audio coding/decoding software, work in progress              *
 *   NOT for public distribution until verified and approved by the   *
 *   MPEG/audio committee.  For further information, please contact   *
 *   Davis Pan, 508-493-2241, e-mail: pan@@gauss.enet.dec.com          *
 *                                                                    *
d262 1
a262 1
int mc_ext_header(Bit_stream_struc *bs)
d284 2
a285 2
			bit_idx = bs->buf_bit_idx;
			byte_idx = bs->buf_byte_idx;
@
