/**********************************************************************
 * Copyright (c) 1995 MPEG/audio software simulation group
 * All Rights Reserved
 * $Id: decode.c,v 1.3 1995/04/06 05:01:42 rowlands Exp $
 *
 * MPEG/audio coding/decoding software, work in progress
 *   NOT for public distribution until verified and approved by the
 *   MPEG/audio committee.
 *
 * $Log: decode.c,v $
 * Revision 1.3  1995/04/06  05:01:42  rowlands
 * Ran decoder through protoize to convert to ANSI C.
 *
 * Revision 1.2  1995/04/06  04:56:00  rowlands
 * Added header, RCS info and cleaned up prototypes in initial revision.
 *
 **********************************************************************/

/**********************************************************************
 * VERSION 2.5                                                        *
 *   changes made since last update:                                  *
 *   date   programmers                comment                        *
 * 2/25/91  Douglas Wong        start of version 1.0 records          *
 * 3/06/91  Douglas Wong        rename setup.h to dedef.h             *
 *                              removed extraneous variables          *
 *                              removed window_samples (now part of   *
 *                              filter_samples)                       *
 * 3/07/91  Davis Pan           changed output file to "codmusic"     *
 * 5/10/91  Vish (PRISM)        Ported to Macintosh and Unix.         *
 *                              Incorporated new "out_fifo()" which   *
 *                              writes out last incomplete buffer.    *
 *                              Incorporated all AIFF routines which  *
 *                              are also compatible with SUN.         *
 *                              Incorporated user interface for       *
 *                              specifying sound file names.          *
 *                              Also incorporated user interface for  *
 *                              writing AIFF compatible sound files.  *
 * 27jun91  dpwe (Aware)        Added musicout and &sample_frames as  *
 *                              args to out_fifo (were glob refs).    *
 *                              Used new 'frame_params' struct.       *
 *                              Clean,simplify, track clipped output  *
 *                              and total bits/frame received.        *
 * 7/10/91  Earle Jennings      changed to floats to FLOAT            *
 *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           *
 *          Don H. Lee,                                               *
 *          Peter W. Farrett                                          *
 *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   *
 *                              newly introduced functions are        *
 *                              buffer_CRC and recover_CRC_error      *
 *                              Additions and revisions are marked    *
 *                              with "dhl" for clarity                *
 * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   *
 *                              important fixes involved changing     *
 *                              16-bit ints to long or unsigned in    *
 *                              bit alloc routines for quant of 65535 *
 *                              and passing proper function args.     *
 *                              Removed "Other Joint Stereo" option   *
 *                              and made bitrate be total channel     *
 *                              bitrate, irrespective of the mode.    *
 *                              Fixed many small bugs & reorganized.  *
 **********************************************************************
 *                                                                    *
 *                                                                    *
 *  MPEG/audio Phase 2 coding/decoding multichannel                   *
 *                                                                    *
 *  Version 1.0                                                       *
 *                                                                    *
 *  7/27/93        Susanne Ritscher,  IRT Munich                      *
 *                                                                    *
 *                  thanks to                                         *
 *                  Ralf Schwalbe,    Telekom FTZ Berlin              *
 *                  Heiko Purnhagen,  Uni Hannover                    *
 *                                                                    *
 *  Version 2.0                                                       *
 *                                                                    *
 *  8/27/93        Susanne Ritscher, IRT Munich                       *
 *                 Channel-Switching is working                       *
 *                                                                    *
 *  Version 2.1                                                       *
 *                                                                    *
 *  9/1/93         Susanne Ritscher,  IRT Munich                      *
 *                 all channels normalized                            *
 *                                                                    *
 *  Version 3.0                                                       *
 *                                                                    *
 *  06/16/94       Ralf Schwalbe, Telekom FTZ Berlin                  *
 *                 all sources and variables adapted due to MPEG-2 -  *
 *                 DIS from March 1994                                *
 *                  - dematrix and denormalize procedure              *
 *                  - new tc - allocation (0-7)                       *
 *                  - some new structures and variables as a basis    *
 *                    for further decoding modes                      *
 **********************************************************************
 *								      *
 *  Version 1.0 Shareware                                             *
 *                                                                    *
 *  07/12/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                 Tel: +49 30 6708 2406                              *
 *                 Fax: +49 30 6774 539                               *
 *								      *
 *  04/11/94	   Ralf Schwalbe. Telekom FTZ Berlin                  *
 *                  - decoding extension bitstream                    *
 *                  - some new subroutines, globale variables and     *
 *                    structures (important to handle the ext. bitst.)*
 *                  - changed all functions to ANSI-C funktion header *
 *		    - corrected some bugs to decode bitstreams > 512kB*
 *								      *
 *  Version 1.1 Shareware                                             *
 *                                                                    *
 *  07/12/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                 Tel: +49 30 6708 2406                              *
 *                 Fax: +49 30 6774 539                               *
 *								      *
 **********************************************************************/

 /*********************************************************************/

#include        "common.h"
#include        "decoder.h"

/***************************************************************
/*
/* This module contains the core of the decoder ie all the
/* computational routines. (Layer I and II only)
/* Functions are common to both layer unless
/* otherwise specified.
/*
/***************************************************************/

/*****************************************************************
/*
/* The following routines decode the system information
/*
/****************************************************************/

/************************* Layer II  ****************************/

void decode_info(Bit_stream_struc *bs,
		 frame_params *fr_ps)
{
   layer *hdr = fr_ps->header;

   hdr->version = get1bit(bs);
   hdr->lay = 4-getbits(bs,2);
   hdr->error_protection = !get1bit(bs); /* error protect. TRUE/FALSE */
   hdr->bitrate_index = getbits(bs,4);
   hdr->sampling_frequency = getbits(bs,2);
   hdr->padding = get1bit(bs);
   hdr->extension = get1bit(bs);
   hdr->mode = getbits(bs,2);
   hdr->mode_ext = getbits(bs,2);
   hdr->copyright = get1bit(bs);
   hdr->original = get1bit(bs);
   hdr->emphasis = getbits(bs,2);
}



/**********************************************************************/
/*																	  */
/*  7.7.93 Susanne Ritscher Systeminformation for multi-channel       */
/* 27.5.94 Ralf Schwalbe    Systeminformation and names due to		  */
/*					MPEG 2 DIS from March 1994  */					                        
/*								*/
/**********************************************************************/

void mc_header(Bit_stream_struc *bs,
	       frame_params *fr_ps)
{
   layer *hdr = fr_ps->header;
   hdr->ext_bit_stream_present = get1bit(bs);
   if( hdr->ext_bit_stream_present == 1)
   {		
	hdr->n_ad_bytes =  getbits(bs,8);
	hdr->ad_bytes_crc_info = hdr->n_ad_bytes;
   }
   hdr->center = getbits(bs, 2);
   hdr->surround = getbits(bs,2);
   hdr->lfe = get1bit(bs);
   hdr->audio_mix = get1bit(bs);     /* large or small room  R.S. */
   hdr->dematrix_procedure = getbits(bs,2);
   hdr->no_of_multi_lingual_ch = getbits(bs,3);
   hdr->multi_lingual_fs = get1bit(bs);
   hdr->multi_lingual_layer = get1bit(bs);
   hdr->copyright_ident_bit = get1bit(bs);
   hdr->copyright_ident_start = get1bit(bs);
   

}

/* R.S. prediction table MPEG-2 DIS March 25, 1994 */
int pred_coef_table[8][14] = {{4,3,3,2,2,1,1,0,4,3,3,2,2,2},
			      {3,2,2,2,1,1,1,0,3,3,3,2,2,2},
			      {3,2,2,2,1,1,1,0,3,3,3,2,2,2},
			      {4,3,3,2,2,1,1,0,4,3,3,2,2,2},
			      {4,3,3,2,2,1,1,0,4,3,3,2,2,2},
			      {4,3,3,2,2,1,1,0,4,3,3,2,2,2},
			      {3,2,2,2,1,1,1,0,3,3,3,2,2,2},
			      {3,2,2,2,1,1,1,0,3,3,3,2,2,2}};

void mc_composite_status_info(Bit_stream_struc *bs,
			      frame_params *fr_ps)
{
   layer *hdr = fr_ps->header;
   int sbgr, j, pci;


   hdr->tc_sbgr_select = get1bit(bs);
   hdr->dyn_cross_on = get1bit(bs);
   hdr->mc_prediction_on = get1bit(bs);

   if(hdr->tc_sbgr_select == 1)
   {
   
		hdr->tc_allocation = getbits(bs,3);/* tc_allocation is valid for */
		for(sbgr = 0; sbgr < 12; sbgr++)   /* all sbgr R.S. */
			{
			hdr->tc_alloc[sbgr] = 0;
			
			}
   }
   else
   {
   
		hdr->tc_allocation = 0;
		for(sbgr = 0; sbgr < 12; sbgr++)
			{
			hdr->tc_alloc[sbgr] = getbits(bs, 3);
			
			}
   }

   if( hdr->dyn_cross_on == 1)
   {
		hdr->dyn_cross_LR = get1bit(bs);
		for(sbgr = 0; sbgr < 12; sbgr++)
			hdr->dyn_cross_mode[sbgr] = getbits(bs,4);
   }
   else
		for(sbgr = 0; sbgr < 12; sbgr++)
			hdr->dyn_cross_mode[sbgr] = 0;
/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
   for(sbgr = 0; sbgr < 12; sbgr++)
	for(pci=0; pci < 4; pci++)
	   hdr->mc_predsi[sbgr][pci] = 0;

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

   if( hdr->mc_prediction_on == 1)
   {
	  for(sbgr = 0; sbgr < 8; sbgr++) 
	  {  /* new sbgr < 8 */
		if( (hdr->mc_prediction[sbgr] = get1bit(bs)) == 1 )
		{
/* R.S. read from npredcoef-table max number of coef. for 3/2 configuration */
/* and then the predsi info -> 0    : no prediction    */
/*			    -> 1..4 : 1..4 coefficient */
		 if(hdr->tc_sbgr_select == 1)
   		  for(pci=0; pci< pred_coef_table[hdr->tc_allocation][hdr->dyn_cross_mode[sbgr]] ; pci++)
			 hdr->mc_predsi[sbgr][pci] = getbits(bs,2);
		 
		}
	  }
   }
}

/* 15.6.1994 R.S. read header from extension bitstream */
int mc_ext_header(void)
{
	int i;
	int bit_idx,byte_idx;

	if( read_ext_header == 0 )
	{
		read_ext_header = 1;
		info.ext_syncword = local_getbits(&bs_ext, 12);
		if( info.ext_syncword != EXT_SYNCWORD )
		{
			printf("\nWrong syncword in extern bitstream ! \n");
			ext_error=1;
/*			skip_ext_bits(&bs_ext, (info.ext_length - 12)); */
			return(0);
		}
		else /* decoding extern bitstream */
		{
			info.ext_crc_check = local_getbits(&bs_ext, 16);
			info.ext_length = local_getbits(&bs_ext, 11);
			info.reserved_bit = local_get1bit(&bs_ext);
			/*bit_idx = bs->buf_bit_idx;*/
			/*byte_idx = bs->buf_byte_idx;*/
			/*if( mc_ext_error_check() == 0 )*/
			/*	return(0);               *//* false  */
  			/*else  return(1);               *//* true   */
		}
	}
	return(1);
}

/*******************************************************************
/*
/* The bit allocation information is decoded. Layer I
/* has 4 bit per subband whereas Layer II is Ws and bit rate
/* dependent.
/*
/********************************************************************/

/**************************** Layer II *************/

void II_decode_bitalloc(Bit_stream_struc *bs,
			unsigned int bit_alloc[5][SBLIMIT],	
			frame_params *fr_ps,
			int *l,
			int *m  /* l = 0 or 2 , m = 2 or <= 5 */)
{
   int i,j,c,sbgr;
   /* int stereo = fr_ps->stereo; */ /* not used for mc - decoding */
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;

 
   for (i=0;i<jsbound;i++)
   {
     if( info.dyn_cross_on == 0)
	for (j=*l;j<*m;j++)
	{
		 if((fr_ps->header->center != 3) || (i < 12) || (j !=2))
		 	{
		 	bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);
		 	}
		 else
		 bit_alloc[j][i] = 0;
	}
     /* else */  /* dyn. cross talk */
                 /* R.S. not included in shareware */     
	}
 

	
   for (i=jsbound;i<sblimit;i++)   /* expand to 2 channels */
	  bit_alloc[0][i] = bit_alloc[1][i] = (char) getbits(bs,(*alloc)[i][0].bits);

   for (i=sblimit;i<SBLIMIT;i++) for (j=*l;j<*m;j++)
	  bit_alloc[j][i] = 0;
}

/************15/03/1995 TEST**********/
void II_decode_bitalloc_test(Bit_stream_struc *bs,
			unsigned int bit_alloc[5][SBLIMIT],	
			frame_params *fr_ps,
			int *l,
			int *m  )
{
   int i,j,c,sbgr;
   /* int stereo = fr_ps->stereo; */ /* not used for mc - decoding */
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;

   for (i=0;i<jsbound;i++)
     if( info.dyn_cross_on == 0)
	for (j=0;j<*m;j++)
	{
		 if((fr_ps->header->center != 3) || (i < 12) || (j !=2))
		 	{
		 	bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);

		 	}
		 else
		 bit_alloc[j][i] = 0;
	}
     /* else */  /* dyn. cross talk */
                 /* R.S. not included in shareware */     

	
   for (i=jsbound;i<sblimit;i++)   /* expand to 2 channels */
	  bit_alloc[0][i] = bit_alloc[1][i] = (char) getbits(bs,(*alloc)[i][0].bits);

   for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++)
	  bit_alloc[j][i] = 0;
}

/*****************************************************************
/*
/* The following two functions implement the layer II
/* format of scale factor extraction. Layer I involves reading
/* 6 bit per subband as scale factor. Layer II requires reading
/* first the scfsi which in turn indicate the number of scale factors
/* transmitted.
/*   Layer II : II_decode_scale
/*
/*************************** Layer II stuff ***************************/
/* 28.9.93 R.S. reading of the prediction coefficients */
/* 03.6.94 R.S. read pred-coef. due to MPEG 2 - DIS    */
/**********************************************************************/
/* JMZ 09/03/1995 Multilingual adaptations */
/**********************************************************************/

void II_decode_scale(Bit_stream_struc *bs,
		     unsigned int scfsi[5][SBLIMIT], 		
		     unsigned int bit_alloc[5][SBLIMIT],	
		     unsigned int scale_index[5][3][SBLIMIT],	
		     frame_params *fr_ps,
		     int *l, 
		     int *m)
{
   int i,j;
   int px,pci;
   /* int stereo  = fr_ps->stereo; */ /* not used for mc - decoding */
   int sblimit = fr_ps->sblimit;

   for (i=0;i<sblimit;i++) 
   {
   for (j=*l;j<*m;j++)   /* 2 bit scfsi */
   	{
	if (bit_alloc[j][i]) 
		{
	  	scfsi[j][i] = (char) getbits(bs,2);
	  	}
	  }
	  
	  }
	 for (i=sblimit;i<SBLIMIT;i++) 
	 {
	 for (j=*l;j<*m;j++)
		scfsi[j][i] = 0;
	}


   /* 3.6.94 R.S. read the prediction coefficients in the mc - part */
   /* R.S. not included in Shareware */
	
	     
   for (i = 0; i < sblimit; i++) 
   {
   
   for (j = *l; j < *m; j++) {
	  if (bit_alloc[j][i])
	  {
	  switch (scfsi[j][i]) {
			/* all three scale factors transmitted */
			case 0 : scale_index[j][0][i] = getbits(bs,6);
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);
				  break;
			/* scale factor 1 & 3 transmitted */
			case 1 : scale_index[j][0][i] =
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);
				  break;
			/* scale factor 1 & 2 transmitted */
			case 3 :scale_index[j][0][i] = getbits(bs,6);
				scale_index[j][1][i] =
				scale_index[j][2][i] =  getbits(bs,6);
				break;
			/* only one scale factor transmitted */
			case 2 : scale_index[j][0][i] =
				scale_index[j][1][i] =
				scale_index[j][2][i] = getbits(bs,6);
				break;
			default : break;
			}
			
		}
      else {
	 scale_index[j][0][i] = scale_index[j][1][i] =
	 scale_index[j][2][i] = SCALE_RANGE-1;
	 
	  }
   }
   }
   for (i=sblimit;i<SBLIMIT;i++)
   { 
		 scale_index[j][2][i] = SCALE_RANGE-1;
   for (j=*l;j<*m;j++) {
		 scale_index[j][0][i] = scale_index[j][1][i] =
		 scale_index[j][2][i] = SCALE_RANGE-1;
   }
   }
}

/**********************************************************************/
/* JMZ 15/03/1995 Multilingual TEST */
/**********************************************************************/

void II_decode_scale_test(Bit_stream_struc *bs,
		     unsigned int scfsi[5][SBLIMIT], 		
		     unsigned int bit_alloc[5][SBLIMIT],	
		     unsigned int scale_index[5][3][SBLIMIT],	
		     frame_params *fr_ps,
		     int *l, 
		     int *m)
{
   int i,j;
   int px,pci;
   /* int stereo  = fr_ps->stereo; */ /* not used for mc - decoding */
   int sblimit = fr_ps->sblimit;


   for (i=0;i<sblimit;i++) for (j=0;j<*m;j++)   /* 2 bit scfsi */
	if (bit_alloc[j][i]) 
		{
	  	scfsi[j][i] = (char) getbits(bs,2);

	  	}
	 for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++)
		scfsi[j][i] = 0;


   /* 3.6.94 R.S. read the prediction coefficients in the mc - part */
   /* R.S. not included in Shareware */
	
   for (i = 0; i < sblimit; i++) for (j = 0; j < *m; j++) {
	  if (bit_alloc[j][i])
	  switch (scfsi[j][i]) {
		 /* all three scale factors transmitted */
		 case 0 : scale_index[j][0][i] = getbits(bs,6);
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);

				  break;
		 /* scale factor 1 & 3 transmitted */
		 case 1 : scale_index[j][0][i] =
				scale_index[j][1][i] = getbits(bs,6);
				scale_index[j][2][i] = getbits(bs,6);

				  break;
	 /* scale factor 1 & 2 transmitted */
		case 3 :scale_index[j][0][i] = getbits(bs,6);
				scale_index[j][1][i] =
				scale_index[j][2][i] =  getbits(bs,6);

		  break;
		 /* only one scale factor transmitted */
	 case 2 : scale_index[j][0][i] =
		  scale_index[j][1][i] =
		  scale_index[j][2][i] = getbits(bs,6);

		  break;
		 default : break;
      }
      else {
	 scale_index[j][0][i] = scale_index[j][1][i] =
	 scale_index[j][2][i] = SCALE_RANGE-1;
	  }
   }
   for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<*m;j++) {
		 scale_index[j][0][i] = scale_index[j][1][i] =
		 scale_index[j][2][i] = SCALE_RANGE-1;
   }
}

/**************************************************************
/*
/* The following two routines take care of reading the
/* compressed sample from the bit stream for layer 2.
/* For layer 1, read the number of bits as indicated
/* by the bit_alloc information. For layer 2, if grouping is
/* indicated for a particular subband, then the sample size has
/* to be read from the bits_group and the merged samples has
/* to be decompose into the three distinct samples. Otherwise,
/* it is the same for as layer one.
/*
/*************************** Layer II stuff ************************/

void II_buffer_sample(Bit_stream_struc *bs,
		      unsigned int sample[5][3][SBLIMIT],
		      unsigned int bit_alloc[5][SBLIMIT],
		      frame_params *fr_ps)
{
   int i,j,k,m;
   int stereo = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;

   for (i=0;i<sblimit;i++) for (j= 0;j<((i<jsbound)? stereo:1);j++) {
	   if (bit_alloc[j][i])
	   {
		 /* check for grouping in subband */
		 if ((*alloc)[i][bit_alloc[j][i]].group==3)
		 	{
			for (m=0;m<3;m++)
			{
			  k = (*alloc)[i][bit_alloc[j][i]].bits;
			  sample[j][m][i] = (unsigned int) getbits(bs,k);
			 }

		   }
		 else
		 {    /* bit_alloc = 3, 5, 9 */
		   unsigned int nlevels, c=0;

		   nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
		   k=(*alloc)[i][bit_alloc[j][i]].bits;
		   c = (unsigned int) getbits(bs, k);

		   for (k=0;k<3;k++)
		   {
			 sample[j][k][i] = c % nlevels;
			 c /= nlevels;
		   }
		 }
	   }
	   else
	   {      /* for no sample transmitted */
		 for (k=0;k<3;k++) sample[j][k][i] = 0;
	   }
	   if(stereo == 2 && i>= jsbound)  /* joint stereo : copy L to R */
		  for (k=0;k<3;k++) sample[1][k][i] = sample[0][k][i];
   }
   for (i = sblimit; i < SBLIMIT; i++)
	 for (j = 0; j < stereo; j++)
		for (k = 0; k < 3; k++)
		   sample[j][k][i] = 0;
}

/******************** mc - layer2 stuff ******************************/
/* 19.10.93 R.S. */

void II_buffer_samplemc(Bit_stream_struc *bs,
			unsigned int sample[5][3][SBLIMIT],
			unsigned int bit_alloc[5][SBLIMIT],
			frame_params *fr_ps,
			int *mc_channel)
{
   int i,j,k,m,sbgr,l;
   unsigned int nlevels, c=0;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   for (i = 0; i < sblimit; i++)
   {
	  if( i == 0) sbgr = 0 ;
	  else
	     for(l = 1; l < 12; l++)
		if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
		{
		   sbgr = l; break;
		}

	 for (j = 2; j < *mc_channel; j++)
	 {
	   if (bit_alloc[j][i])
	   {
		 if(fr_ps->header->dyn_cross_on == 0)
		 {
			/* check for grouping in subband */
			if ((*alloc)[i][bit_alloc[j][i]].group==3)
			{

				for (m=0;m<3;m++)
				{
					k = (*alloc)[i][bit_alloc[j][i]].bits;
					sample[j][m][i] = (unsigned int) getbits(bs,k);
				}

			}
			else
			{    /* bit_alloc = 3, 5, 9 */
			  nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
			  k=(*alloc)[i][bit_alloc[j][i]].bits;
			  c = (unsigned int) getbits(bs, k);

			  for (k=0;k<3;k++)
			  {
				sample[j][k][i] = c % nlevels;
				c /= nlevels;
			  }
			}
		 }
		 /*else*/       /* 21.07.94 Ralf Schwalbe dyn. cross mode */
				/* R.S. not included in shareware */
	   }
	   else
	   {      /* for no sample transmitted */
		 for (k=0;k<3;k++) sample[j][k][i] = 0;
	   }
	 }
   }

   for (i = sblimit; i < SBLIMIT; i++)
	 for (j = 2; j < *mc_channel; j++)
		for (k = 0; k < 3; k++)
		   sample[j][k][i] = 0;
}

/***************************************************************/
/* 09/03/1995 JMZ Multilingual */

/***************************************************************/
/* 15/03/1995 JMZ TEST */

void II_buffer_sample_test(Bit_stream_struc *bs,
			unsigned int sample[5][3][SBLIMIT],
			unsigned int bit_alloc[5][SBLIMIT],
			frame_params *fr_ps,
			int *n_ml_ch)
{
   int i,j,k,m,sbgr,l;
   unsigned int nlevels, c=0;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   for (i = 0; i < sblimit; i++)
   {
	 for (j = 0; j < *n_ml_ch; j++)
	 {
	   if (bit_alloc[j][i])
	   {
		 if(fr_ps->header->dyn_cross_on == 0)
		 {
			/* check for grouping in subband */
			if ((*alloc)[i][bit_alloc[j][i]].group==3)
			{

				for (m=0;m<3;m++)
				{
					k = (*alloc)[i][bit_alloc[j][i]].bits;
					sample[j][m][i] = (unsigned int) getbits(bs,k);
				}

			}
			else
			{    /* bit_alloc = 3, 5, 9 */
			  nlevels = (*alloc)[i][bit_alloc[j][i]].steps;
			  k=(*alloc)[i][bit_alloc[j][i]].bits;
			  c = (unsigned int) getbits(bs, k);

			  for (k=0;k<3;k++)
			  {
				sample[j][k][i] = c % nlevels;
				c /= nlevels;
			  }
			}
		 }
		 /*else*/       /* 21.07.94 Ralf Schwalbe dyn. cross mode */
				/* R.S. not included in shareware */
	   }
	   else
	   {      /* for no sample transmitted */
		 for (k=0;k<3;k++) sample[j][k][i] = 0;
	   }
	 }
   }

   for (i = sblimit; i < SBLIMIT; i++)
	 for (j = 0; j < *n_ml_ch; j++)
		for (k = 0; k < 3; k++)
		   sample[j][k][i] = 0;
}

/**************************************************************
/*
/*   Restore the compressed sample to a factional number.
/*   first complement the MSB of the sample
/*    for layer I :
/*    Use s = (s' + 2^(-nb+1) ) * 2^nb / (2^nb-1)
/*   for Layer II :
/*   Use the formula s = s' * c + d
/*
/**************************************************************/

static double c[17] = { 1.33333333333, 1.60000000000, 1.14285714286,
						1.77777777777, 1.06666666666, 1.03225806452,
						1.01587301587, 1.00787401575, 1.00392156863,
						1.00195694716, 1.00097751711, 1.00048851979,
						1.00024420024, 1.00012208522, 1.00006103888,
						1.00003051851, 1.00001525902 };

static double d[17] = { 0.500000000, 0.500000000, 0.250000000, 0.500000000,
						0.125000000, 0.062500000, 0.031250000, 0.015625000,
						0.007812500, 0.003906250, 0.001953125, 0.0009765625,
						0.00048828125, 0.00024414063, 0.00012207031,
						0.00006103516, 0.00003051758 };

/************************** Layer II stuff ************************/

void II_dequantize_sample(unsigned int sample[5][3][SBLIMIT],
			  unsigned int bit_alloc[5][SBLIMIT],
			  double fraction[5][SBLIMIT][3][12],
			  frame_params *fr_ps,
			  int *z)
{
   int i, j, k, x;
   int stereo = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   for (i=0;i<sblimit;i++)  for (j=0;j<3;j++) for (k = 0; k < stereo ; k++)
	 if (bit_alloc[k][i])
	 {
	   /* locate MSB in the sample */
	   x = 0;
#ifndef MSDOS
	   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
#else
	   /* microsoft C thinks an int is a short */
	   while (( (unsigned long) (1L<<(long)x) <
				(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)
			  ) && ( x < 16) ) x++;
#endif

	   /* MSB inversion */
	   if (((sample[k][j][i] >> (x-1)) & 1) == 1)
		  fraction[k][i][j][*z] = 0.0;
	   else  fraction[k][i][j][*z] = -1.0;

	   /* Form a 2's complement sample */
	   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
							(double) (1L<<(x-1));

	   /* Dequantize the sample */
	   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
	   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
	 }
	 else fraction[k][i][j][*z] = 0.0;

   for (i=sblimit;i<SBLIMIT;i++)
	  for (j=0;j<3;j++)
		 for(k = 0; k < stereo; k++)
			 fraction[k][i][j][*z] = 0.0;
}


/************************** MC Layer II stuff ************************/

void II_dequantize_samplemc(unsigned int sample[5][3][SBLIMIT],
			    unsigned int bit_alloc[5][SBLIMIT],
			    double fraction[5][SBLIMIT][3][12],
			    frame_params *fr_ps,
			    int *mc_channel,
			    int *z)
{
   int i, j, k, x,sbgr,l;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   for (i = 0; i < sblimit; i++)
   {
	  if( i == 0) sbgr = 0 ;
	  else
		for(l = 1; l < 12; l++)
			if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
			{
				sbgr = l; break;
			}
	  for (j = 0; j < 3; j++)
		 for ( k = 2; k < *mc_channel; k++)
			if (bit_alloc[k][i])
			{
			  if (fr_ps->header->dyn_cross_on == 0)
			  {
			  /* locate MSB in the sample */
			   x = 0;
#ifndef MSDOS
			   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
#else
			   /* microsoft C thinks an int is a short */
			   while (( (unsigned long) (1L<<(long)x) <
				(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)
			   ) && ( x < 16) ) x++;
#endif
			   /* MSB inversion */
			   if (((sample[k][j][i] >> (x-1)) & 1) == 1)
					fraction[k][i][j][*z] = 0.0;
			   else  fraction[k][i][j][*z] = -1.0;

			   /* Form a 2's complement sample */
			   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
							(double) (1L<<(x-1));

			   /* Dequantize the sample */
			   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
			   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
			  }
			  /* else */   /* 21.07.94 Ralf Schwalbe dyn. cross mode */
			  	       /* R.S. not included in shareware */		  
			  
			} /* if bit_alloc */
			else fraction[k][i][j][*z] = 0.0;
   }
   for (i = sblimit; i < SBLIMIT; i++)
	  for (j = 0; j < 3; j++)
		 for(k = 2; k < *mc_channel; k++)
			 fraction[k][i][j][*z] = 0.0;
}


/*************************************************************************/
/* JMZ 09/03/1995 Multilingual */

void II_dequantize_sample_test(unsigned int sample[5][3][SBLIMIT],
			    unsigned int bit_alloc[5][SBLIMIT],
			    double fraction[5][SBLIMIT][3][12],
			    frame_params *fr_ps,
			    int *n_ml_ch,
			    int *z)
{
   int i, j, k, x,sbgr,l;
   int sblimit = fr_ps->sblimit;
   al_table *alloc = fr_ps->alloc;

   for (i = 0; i < sblimit; i++)
   {
	  for (j = 0; j < 3; j++)
		 for ( k = 0; k < *n_ml_ch; k++)
			if (bit_alloc[k][i])
			{
			  if (fr_ps->header->dyn_cross_on == 0)
			  {
			  /* locate MSB in the sample */
			   x = 0;
#ifndef MSDOS
			   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;
#else
			   /* microsoft C thinks an int is a short */
			   while (( (unsigned long) (1L<<(long)x) <
				(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)
			   ) && ( x < 16) ) x++;
#endif
			   /* MSB inversion */
			   if (((sample[k][j][i] >> (x-1)) & 1) == 1)
					fraction[k][i][j][*z] = 0.0;
			   else  fraction[k][i][j][*z] = -1.0;

			   /* Form a 2's complement sample */
			   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /
							(double) (1L<<(x-1));

			   /* Dequantize the sample */
			   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];
			   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];
			  }
			  /* else */   /* 21.07.94 Ralf Schwalbe dyn. cross mode */
			  	       /* R.S. not included in shareware */		  
			} /* if bit_alloc */
			else fraction[k][i][j][*z] = 0.0;
   }
   for (i = sblimit; i < SBLIMIT; i++)
	  for (j = 0; j < 3; j++)
		 for(k = 0; k < *n_ml_ch; k++)
			 fraction[k][i][j][*z] = 0.0;
}

/************************************************************
/*
/*   Restore the original value of the sample ie multiply
/*    the fraction value by its scalefactor.
/*
/************************* Layer II Stuff **********************/

void II_denormalize_sample(double fraction[5][SBLIMIT][3][12],
			   unsigned int scale_index[5][3][SBLIMIT],
			   frame_params *fr_ps,
			   int x,
			   int *z)
{
   int i,j,k;
   int stereo = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;

   for (i=0;i<sblimit;i++)
	for (j = 0;j < stereo; j++)
	{
	  fraction[j][i][0][*z] *= multiple[scale_index[j][x][i]];
	  fraction[j][i][1][*z] *= multiple[scale_index[j][x][i]];
	  fraction[j][i][2][*z] *= multiple[scale_index[j][x][i]];
	}
}

/************************* MC Layer II Stuff **********************/

void II_denormalize_samplemc(double fraction[5][SBLIMIT][3][12],
			     unsigned int scale_index[5][3][SBLIMIT],
			     frame_params *fr_ps,
			     int x,
			     int *mc_channel,
			     int *z)
{
   int i,j,k,sbgr,l,bl=0;
   int sblimit = fr_ps->sblimit;

   for (i = 0; i < sblimit; i++)
   {
	if( i == 0) sbgr = 0 ;
	  else
		for(l = 1; l < 12; l++)
			if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
			{
				sbgr = l; break;
			}
	if(fr_ps->header->dyn_cross_on == 0)
		for (j = 2; j < *mc_channel; j++)
		{
			fraction[j][i][0][*z] *= multiple[scale_index[j][x][i]];
			fraction[j][i][1][*z] *= multiple[scale_index[j][x][i]];
			fraction[j][i][2][*z] *= multiple[scale_index[j][x][i]];
		}
	/************** R.S. ***************/
 
   } /* for sblimit */
}

/*************************************************************/
/* JMZ 09/03/1995 Multilingual */

/*************************************************************/
/* JMZ 15/03/1995 TEST */

void II_denormalize_sample_test(double fraction[5][SBLIMIT][3][12],
			     unsigned int scale_index[5][3][SBLIMIT],
			     frame_params *fr_ps,
			     int x,
			     int *n_ml_ch,
			     int *z)
{
   int i,j,k,sbgr,l,bl=0;
   int sblimit = fr_ps->sblimit;

   for (i = 0; i < sblimit; i++)
   {
	if(fr_ps->header->dyn_cross_on == 0)
		for (j = 0; j < *n_ml_ch; j++)
		{
			fraction[j][i][0][*z] *= multiple[scale_index[j][x][i]];
			fraction[j][i][1][*z] *= multiple[scale_index[j][x][i]];
			fraction[j][i][2][*z] *= multiple[scale_index[j][x][i]];
		}
	/************** R.S. ***************/
 
   } /* for sblimit */
}

/*****************************************************************
/*
/* The following are the subband synthesis routines. They apply
/* to both layer I and layer II stereo or mono. The user has to
/* decide what parameters are to be passed to the routines.
/*
/***************************************************************/

/*************************************************************
/*
/*   Pass the subband sample through the synthesis window
/*
/**************************************************************/

/* create in synthesis filter */

void create_syn_filter(double filter[64][SBLIMIT])
{
   register int i,k;

   for (i=0; i<64; i++)
      for (k=0; k<32; k++) {
		 if ((filter[i][k] = 1e9*cos((double)((PI64*i+PI4)*(2*k+1)))) >= 0)
			modf(filter[i][k]+0.5, &filter[i][k]);
         else
            modf(filter[i][k]-0.5, &filter[i][k]);
		 filter[i][k] *= 1e-9;
	  }
}

/***************************************************************
/*
/*   Window the restored sample
/*
/***************************************************************/

/* read in synthesis window */

void read_syn_window(double window[HAN_SIZE])
{
   int i,j[4];
   FILE *fp;
   double f[4];
   char t[150];

   if (!(fp = OpenTableFile("dewindow") )) {
	  printf("Please check synthesis window table 'dewindow'\n");
	  exit(1);
   }
   for (i=0;i<512;i+=4) {
		fgets(t,150, fp);
	  sscanf(t,"D[%d] = %lf D[%d] = %lf D[%d] = %lf D[%d] = %lf\n",
			 j, f,j+1,f+1,j+2,f+2,j+3,f+3);
	  if (i==j[0]) {
		 window[i] = f[0];
		 window[i+1] = f[1];
		 window[i+2] = f[2];
		 window[i+3] = f[3];
	  }
	  else {
		 printf("Check index in synthesis window table\n");
			exit(1);
	  }
	  fgets(t,80,fp);
   }
   fclose(fp);
}


int SubBandSynthesis (double *bandPtr,
		      int channel,
		      long *samples)
{
    long foo;
    register int i,j,k;
    register double *bufOffsetPtr, sum;
    static int init = 1;
    typedef double NN[64][32];
    static NN *filter;
    typedef double BB[5][2*HAN_SIZE]; 
    static BB *buf;
    static int bufOffset = 64;
    static double *window;
    int clip = 0;               /* count & return how many samples clipped */

    if (init) {
		buf = (BB *) mem_alloc(sizeof(BB),"BB");
		filter = (NN *) mem_alloc(sizeof(NN), "NN");
		create_syn_filter(*filter);
		window = (double *) mem_alloc(sizeof(double) * HAN_SIZE, "WIN");
		read_syn_window(window);
		bufOffset = 64;
		init = 0;
	}
	if (channel == 0) bufOffset = (bufOffset - 64) & 0x3ff;
	bufOffsetPtr = &((*buf)[channel][bufOffset]);

#ifdef FAST_FILTER
	/* R.S. not included in shareware */
#else
	for (i=0; i<64; i++)
	{
		sum = 0;
		for (k=0; k<32; k++)
			sum += bandPtr[k] * (*filter)[i][k];
		bufOffsetPtr[i] = sum;
	}
#endif

	/*  S(i,j) = D(j+32i) * U(j+32i+((i+1)>>1)*64)  */
	/*  samples(i,j) = MWindow(j+32i) * bufPtr(j+32i+((i+1)>>1)*64)  */
	for (j=0; j<32; j++)
	{
        sum = 0;
		for (i=0; i<16; i++)
		{
			k = j + (i<<5);
            sum += window[k] * (*buf) [channel] [( (k + ( ((i+1)>>1) <<6) ) +
                                                  bufOffset) & 0x3ff];
        }

/*   {long foo = (sum > 0) ? sum * SCALE + 0.5 : sum * SCALE - 0.5; */
/*   {long foo = sum * SCALE;  */
     
	 foo = floor(sum * SCALE + 0.5);
	 if (foo >= (long) SCALE)      {samples[j] = SCALE-1; ++clip;}
	 else if (foo < (long) -SCALE) {samples[j] =-SCALE;  ++clip;}
	 else                           samples[j] = foo;
 
    }
    return(clip);
}

int SubBandSynthesis_test (double *bandPtr,
		      int channel,
		      long *samples)
{
    long foo;
    register int i,j,k;
    register double *bufOffsetPtr, sum;
    static int init = 1;
    typedef double NN[64][32];
    static NN *filter;
    typedef double BB[5][2*HAN_SIZE]; 
    static BB *buf;
    static int bufOffset = 64;
    static double *window;
    int clip = 0;               /* count & return how many samples clipped */

    if (init) {
		buf = (BB *) mem_alloc(sizeof(BB),"BB");
		filter = (NN *) mem_alloc(sizeof(NN), "NN");
		create_syn_filter(*filter);
		window = (double *) mem_alloc(sizeof(double) * HAN_SIZE, "WIN");
		read_syn_window(window);
		bufOffset = 64;
		init = 0;
	}
	if (channel == 0) bufOffset = (bufOffset - 64) & 0x3ff;
	bufOffsetPtr = &((*buf)[channel][bufOffset]);

#ifdef FAST_FILTER
	/* R.S. not included in shareware */
#else
	for (i=0; i<64; i++)
	{
		sum = 0;
		for (k=0; k<32; k++)
			sum += bandPtr[k] * (*filter)[i][k];
		bufOffsetPtr[i] = sum;
	}
#endif

	/*  S(i,j) = D(j+32i) * U(j+32i+((i+1)>>1)*64)  */
	/*  samples(i,j) = MWindow(j+32i) * bufPtr(j+32i+((i+1)>>1)*64)  */
	for (j=0; j<32; j++)
	{
        sum = 0;
		for (i=0; i<16; i++)
		{
			k = j + (i<<5);
            sum += window[k] * (*buf) [channel] [( (k + ( ((i+1)>>1) <<6) ) +
                                                  bufOffset) & 0x3ff];
        }

/*   {long foo = (sum > 0) ? sum * SCALE + 0.5 : sum * SCALE - 0.5; */
/*   {long foo = sum * SCALE;  */
     
	 foo = floor(sum * SCALE + 0.5);
	 if (foo >= (long) SCALE)      {samples[j] = SCALE-1; ++clip;}
	 else if (foo < (long) -SCALE) {samples[j] =-SCALE;  ++clip;}
	 else                           samples[j] = foo;
 
    }
    return(clip);
}



void out_fifo(long pcm_sample[5][3][SBLIMIT],
	      int num,
	      frame_params *fr_ps,
	      int done,
	      FILE *outFile,
	      unsigned long *psampFrames)
{
   int i,j,l;
   int stereo = fr_ps->stereo;
   int mc_channel = fr_ps->mc_channel;
   static short int outsamp[1600];
   static long k = 0;

   if (!done)
      for (i=0;i<num;i++) for (j=0;j<SBLIMIT;j++) {
         (*psampFrames)++;
         for (l=0; l<stereo + mc_channel; l++) {
            if (!(k%1600) && k) {
               fwrite(outsamp,2,1600,outFile);
			   k = 0;
			}
			outsamp[k++] = pcm_sample[l][i][j];
		 }
      }
   else {
      fwrite(outsamp,2,(int)k,outFile);
	  k = 0;
   }
}

void out_fifo_test(long pcm_sample[5][3][SBLIMIT],
	      int num,
	      frame_params *fr_ps,
	      int done,
	      FILE *outFile,
	      unsigned long *psampFrames)
{
   int i,j,l;
   int stereo = fr_ps->stereo;
   int mc_channel = fr_ps->mc_channel;
   int n_ml_ch = fr_ps->header->no_of_multi_lingual_ch;
   static short int outsamp[1600];
   static long k = 0;

   if (!done)
      for (i=0;i<num;i++) for (j=0;j<SBLIMIT;j++) {
         (*psampFrames)++;
         for (l=0; l<n_ml_ch; l++) {
            if (!(k%1600) && k) {
               fwrite(outsamp,2,1600,outFile);
			   k = 0;
			}
			outsamp[k++] = pcm_sample[l][i][j];
		 }

      }
   else {
      fwrite(outsamp,2,(int)k,outFile);
	  k = 0;
   }
}

/*************************************************/
/* JMZ 10/03/1995 Multilingual */

/* JMZ 10/03/1995 Multilingual */
/*************************************************/

void  buffer_CRC(Bit_stream_struc  *bs,
		 unsigned int  *old_crc)
{
   *old_crc = getbits(bs, 16);
}

void  recover_CRC_error(long pcm_sample[5][3][SBLIMIT],
			int error_count,
			frame_params *fr_ps,
			FILE *outFile,
			unsigned long *psampFrames)
{
   int  stereo = fr_ps->stereo;
   int  num, done, i;
   int  samplesPerFrame, samplesPerSlot;
   layer  *hdr = fr_ps->header;
   long  offset;
   short  *temp;

   num = 3;
   if (hdr->lay == 1) num = 1;

   samplesPerSlot = SBLIMIT * num * stereo;
   samplesPerFrame = samplesPerSlot * 32;

   if (error_count == 1) {   /* replicate previous error_free frame */
      done = 1;
	  /* flush out fifo */
	  out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames);
	  /* go back to the beginning of the previous frame */
	  offset = sizeof(short int) * samplesPerFrame;
      fseek(outFile, -offset, SEEK_CUR);
      done = 0;
      for (i = 0; i < 12; i++) {
		 fread(pcm_sample, 2, samplesPerSlot, outFile);
		 out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames);
      }
   }
   else{   /* mute the frame */
      temp = (short*) pcm_sample;
      done = 0;
      for (i = 0; i < 2*3*SBLIMIT; i++)
         *temp++ = MUTE;   /* MUTE value is in decoder.h */
      for (i = 0; i < 12; i++)
         out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames);
   }
}

/**************************************************************/
/* JMZ 09/03/1995 Multilingual modifications */

void dematricing(double pcm_sample[5][SBLIMIT][3][12], 
			frame_params *fr_ps, 
			double pred_buf[2][8][36+PREDDEL]) 
{
  double matr1;   /* normalizing factor */
  double matr2;   /* matricing factor   */
  double matr3;   /* matricing factor   */
  int i, j, jj, k, tc_alloc, l, sbgr = 0 ;
  layer *info = fr_ps->header;
  double tmp_sample;
  
  /* JMZ 09/03/1995 Multilingual */
  int n_ml_ch = info->no_of_multi_lingual_ch;

  switch(info->dematrix_procedure)
  {

	/* factors according to Committee Draft and telefax 10/20/93 */
	/* by E.Schroeder, DTB Hannover.  01/14/94, SR               */

	  case 0: matr1 = 2.42797851625;			    	/* factor for L and R   */
		  matr2 = 2 + 1.41632080078125;			    /* factor for C, Ls, Rs */
		  matr3 = matr2;	/* 09/03/1995 JMZ Multilingual */ /* factor for C, Ls, Rs */
		  break;
	  case 1: matr1 = 1.5 + (0.5 * 1.41632080078125);	/* factor for L, R      */
		  matr2 = 0.5 * (1.5 + 0.5 * (1.41632080078125));   /* Ls, Rs  */
		  matr3 = 0.5 + (0.75 * 1.41632080078125);	/* factor for C         */
		  break;
	  case 2: matr1 = 2.42797851625;			    	/* factor for L and R   */
		  matr2 = 2 + 1.41632080078125;			    /* factor for C, Ls, Rs */
		  printf("NOT DONE MATRIX 2 !!\n");
		  exit(0);
		  break;
	  case 3: matr1 = 1.0;
		  matr2 = 1.0;
		  matr3 = matr2;	/* 09/03/1995 JMZ Multilingual */ 
		  break;
  }

  for (jj=0; jj<12; jj++)
  for( j = 0; j < 3; ++j)
  {
		for(k = 0; k < SBLIMIT; k ++)
		{
		   if(fr_ps->header->tc_sbgr_select == 1)
		   {
			  tc_alloc = fr_ps->header->tc_allocation; /* one tc_alloc is valid for all sbgr */
		   }
		   else
		   {
			  if(k == 0) sbgr = 0;
			  else
				 for(l = 1; l < 12; l++)
				 {
					if((sb_groups[l-1] < k) && (k <= sb_groups[l]))
					{
						sbgr = l;  /* search the valid subband group */
						break;
					}
				 }
				 tc_alloc = fr_ps->header->tc_alloc[sbgr]; /* no prediction, but different tc_alloc's
									      per subband*/
		   }  /* else tc_sbgr_select == 0 */
		switch(tc_alloc)
		{
		 case 0:
			/* if prediction on */
			/****************** R.S ***************/

			if(fr_ps->header->dematrix_procedure != 3)
			{
			    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			    pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
			}
			break;

		 case 1:
			/* if prediction on */
			/****************** R.S ***************/

			tmp_sample = pcm_sample[2][k][j][jj]; /* L */
			pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
			pcm_sample[0][k][j][jj] = tmp_sample;
			break;

		 case 2:
			/* if prediction on */
			/****************** R.S ***************/
			
			tmp_sample = pcm_sample[2][k][j][jj]; /* R */
			pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
			pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			pcm_sample[1][k][j][jj] = tmp_sample;
			break;

		 case 3:
			/* if prediction on */
			/****************** R.S ***************/

			tmp_sample = pcm_sample[3][k][j][jj];  /* L in T3 */
			pcm_sample[3][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[3][k][j][jj] - pcm_sample[2][k][j][jj];
			pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
			pcm_sample[0][k][j][jj] = tmp_sample;
			break;

		 case 4:
			/* if prediction on */
			/****************** R.S ***************/

			tmp_sample = pcm_sample[4][k][j][jj];  /* R in T4 */
			pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			pcm_sample[4][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[4][k][j][jj] - pcm_sample[2][k][j][jj];
			pcm_sample[1][k][j][jj] = tmp_sample;
			break;

		 case 5:
			/* if prediction on */
			/****************** R.S ***************/

			tmp_sample = pcm_sample[3][k][j][jj];
			pcm_sample[3][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[3][k][j][jj] - pcm_sample[2][k][j][jj];
			pcm_sample[0][k][j][jj] = tmp_sample;
			tmp_sample = pcm_sample[4][k][j][jj];
			pcm_sample[4][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[4][k][j][jj] - pcm_sample[2][k][j][jj];
			pcm_sample[1][k][j][jj] = tmp_sample;
			break;

		 case 6:
			/* if prediction on */
			/****************** R.S ***************/

			tmp_sample = pcm_sample[2][k][j][jj];  /* R in T2 */
			pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];
			pcm_sample[1][k][j][jj] = tmp_sample;
			tmp_sample = pcm_sample[3][k][j][jj];  /* L in T3 */
			pcm_sample[3][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[3][k][j][jj] - pcm_sample[2][k][j][jj];
			pcm_sample[0][k][j][jj] = tmp_sample;
			break;

		 case 7:
			/* if prediction on */
			/****************** R.S ***************/

			tmp_sample = pcm_sample[2][k][j][jj];
			pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
			pcm_sample[0][k][j][jj] = tmp_sample;
			tmp_sample = pcm_sample[4][k][j][jj];
			pcm_sample[4][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[4][k][j][jj] - pcm_sample[2][k][j][jj];
			pcm_sample[1][k][j][jj] = tmp_sample;
			break;

		} /* switch end loop*/
	}     /* for k < sblimit loop */
	}     /* for j < 3 loop */

/* denormalized signals */
	if( fr_ps->header->dematrix_procedure != 3 ) 		/* dematrixing */
	  for (jj=0; jj<12; jj++)
		for( j = 0; j < 3; ++j)
			for(k = 0; k < SBLIMIT; k ++)
			{   /* Lo / Ro */
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] * matr1;
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] * matr1;
				pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;
				pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr3;
				pcm_sample[4][k][j][jj] = pcm_sample[4][k][j][jj] * matr3;

			}
}


void dematricing_test(double pcm_sample[5][SBLIMIT][3][12], 
			frame_params *fr_ps, 
			double pred_buf[2][8][36+PREDDEL]) 
{
  double matr1;   /* normalizing factor */
  double matr2;   /* matricing factor   */
  double matr3;   /* matricing factor   */
  int i, j, jj, k, tc_alloc, l, sbgr = 0 ;
  layer *info = fr_ps->header;
  double tmp_sample;
  
  /* JMZ 09/03/1995 Multilingual */
  int n_ml_ch = info->no_of_multi_lingual_ch;

  switch(info->dematrix_procedure)
  {

	/* factors according to Committee Draft and telefax 10/20/93 */
	/* by E.Schroeder, DTB Hannover.  01/14/94, SR               */

	  case 0: matr1 = 2.42797851625;			    	/* factor for L and R   */
		  matr2 = 2 + 1.41632080078125;			    /* factor for C, Ls, Rs */
		  matr3 = matr2;	/* 09/03/1995 JMZ Multilingual */ /* factor for C, Ls, Rs */
		  break;
	  case 1: matr1 = 1.5 + (0.5 * 1.41632080078125);	/* factor for L, R      */
		  matr2 = 0.5 * (1.5 + 0.5 * (1.41632080078125));   /* Ls, Rs  */
		  matr3 = 0.5 + (0.75 * 1.41632080078125);	/* factor for C         */
		  break;
	  case 2: matr1 = 2.42797851625;			    	/* factor for L and R   */
		  matr2 = 2 + 1.41632080078125;			    /* factor for C, Ls, Rs */
		  printf("NOT DONE MATRIX 2 !!\n");
		  exit(0);
		  break;
	  case 3: matr1 = 1.0;
		  matr2 = 1.0;
		  matr3 = matr2;	/* 09/03/1995 JMZ Multilingual */ 
		  break;
  }



/* denormalized signals */
	if( fr_ps->header->dematrix_procedure != 3 ) 		/* dematrixing */
	  for (jj=0; jj<12; jj++)
		for( j = 0; j < 3; ++j)
			for(k = 0; k < SBLIMIT; k ++)
			{   /* Lo / Ro */
				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] * matr1;
				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] * matr1;
				pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr1;
				pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr1;
				pcm_sample[4][k][j][jj] = pcm_sample[4][k][j][jj] * matr1;

			}
}
