<?php
$Path = dirname(__FILE__);

// --- TreeGrid.dll loading ---
$Win = strtoupper(substr(PHP_OS, 0, 3)) === 'WIN';
if (!extension_loaded('ffi')) {
   if ($Win) dl('php_ffi.dll');
   else dl('ffi.so');
   }
if (!extension_loaded('ffi')) {// Error
   echo '<Grid><IO Result="-1" Message="Error: PHP "ffi" extension is not loaded&#x0A;Copy ' . ($Win?"php_ffi.dll":"ffi.so") . ' to your php extensions directory"/></Grid>';
   exit();
   }
$TreeGrid = new ffi ("[lib='$Path/../../Server/TreeGrid.".($Win?"dll":"so")."']
   int CreateGridA(char* Data, char* Layout, char* Defaults, char *Text, char* Bonus, char *Bonus2);
   int UpdateGridA(int Index, char* Bonus);
	int FindGridA(char *Cfg);
	void DeleteGrid(int Index);
	void Clear();
	void FreeStringA(char *String);
	char* GetBodyA(int Index, char* Cfg);
	char* GetPageA(int Index, char* Cfg);
	int SaveA(int Index, char* Input);
	int SaveToFileA(int Index, char* FileName, int Type);
	char* GetDataA(int Index);
   char* LastErrorA();
   ");
// --- Commandline parameters reading ---
$Function = array_key_exists("Function",$_REQUEST) ? $_REQUEST["Function"] : "";
$File = array_key_exists("File",$_REQUEST) ? $_REQUEST["File"] : "";
$Def = array_key_exists("Def",$_REQUEST) ? $_REQUEST["Def"] : "";
$Data = array_key_exists("Data",$_REQUEST) ? $_REQUEST["Data"] : ""; if(get_magic_quotes_gpc()) $Data = stripslashes($Data);
$Bonus = array_key_exists("Bonus",$_REQUEST) ? $_REQUEST["Bonus"] : ""; if(get_magic_quotes_gpc()) $Bonus = stripslashes($Bonus);

// --- calling main function ---
switch($Function){
   case "LoadBody" : echo FuncLoadBody($File,$Def,$Data,$Bonus); break;
   case "LoadPage" : echo FuncLoadPage($File,$Def,$Data,$Bonus); break;
   case "Save" : echo FuncSave($File,$Def,$Data,$Bonus); break;
   default: Error(-3,"Error: Unknown function");
   }

// -----------------------------------------------------------------------------
function Error($num, $mess){
global $TreeGrid;
$Err = $TreeGrid->LastErrorA();
echo '<Grid><IO Result="'.$num.'" Message="'.$mess.($Err!=null?"&#x0A;&#x0A;".htmlentities($Err):"").'"/></Grid>';
exit();
}
// -----------------------------------------------------------------------------
// Creates and returns index of the new grid
function GetIndex($File,$Def,$Cfg,$Bonus){
global $TreeGrid, $Path;
$ID = (array_key_exists("REMOTE_HOST",$_SERVER) ? str_replace(":","_",$_SERVER["REMOTE_HOST"]) : "") . $File;
if(file_exists("$Path/../ServerDLL/tmp/$ID")) {
   $Index = $TreeGrid->CreateGridA("$Path/../ServerDLL/tmp/$ID","$Path/../ServerDLL/$Def","$Path/../../Grid/Defaults.xml","$Path/../../Grid/Text.xml",$Bonus,$Cfg);
   }
else {
   $Index = $TreeGrid->CreateGridA("$Path/../ServerDLL/$File","$Path/../ServerDLL/$Def","$Path/../../Grid/Defaults.xml","$Path/../../Grid/Text.xml",$Bonus,null);
   }
return $Index;
}

// -----------------------------------------------------------------------------
// Returns grid's body
function FuncLoadBody($File,$Def,$Data,$Bonus){
global $TreeGrid, $Path;
$Index = GetIndex($File,$Def,"",$Bonus);
if($Index<0) Error(-1,"Server DLL Error: TreeGrid data not found or server has not permission to read them&#x0A;Data are located at /Examples/ServerDLL/");
$Ret = $TreeGrid->GetBodyA($Index,$Data);
$ID = (array_key_exists("REMOTE_HOST",$_SERVER) ? str_replace(":","_",$_SERVER["REMOTE_HOST"]) : "") . $File;
$TreeGrid->SaveToFileA($Index,"$Path/../ServerDLL/tmp/$ID",0);
return $Ret;
}
// -----------------------------------------------------------------------------
// Returns one grid's page
function FuncLoadPage($File,$Def,$Data,$Bonus){
global $TreeGrid, $Path;
$Index = GetIndex($File,$Def,$Data,$Bonus);
if($Index<0) Error(-1,"Server DLL Error: TreeGrid data not found");
$Ret = $TreeGrid->GetPageA($Index,$Data);
if($Ret=="") Error(-3,"Server DLL Error: Configuration changed, you need to reload grid!");
return $Ret;
}
// -----------------------------------------------------------------------------
// Saves data to grid
function FuncSave($File,$Def,$Data,$Bonus){
global $TreeGrid, $Path;
$Index = GetIndex($File,$Def,$Data,$Bonus);
if($Index<0) Error(-1,"Server DLL Error: TreeGrid data not found");
$Ret = $TreeGrid->SaveA($Index,$Data);
if($Ret<0) Error($Ret,"Server DLL Error: Changes were not saved");
$ID = (array_key_exists("REMOTE_HOST",$_SERVER) ? str_replace(":","_",$_SERVER["REMOTE_HOST"]) : "") . $File;
$TreeGrid->SaveToFileA($Index,"$Path/../ServerDLL/tmp/$ID",0);
if($Ret>0) Error(0,"Server DLL Warning: Not all data were successfully saved !");
Error(0,"");
}
// -----------------------------------------------------------------------------
?>