/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseLongData;
import java.io.IOException;
import java.io.InputStream;

public class BaseInputStreamWrapper
extends InputStream
implements BaseLongData {
    private static String footprint = "$Revision:   1.12.1.0  $";
    BaseConnection connection;
    Object synchronizer;
    InputStream is;
    boolean closed = false;
    long numTotalBytesInStream;
    long numBytesReturned = 0L;
    long maxBytesToReturn = Long.MAX_VALUE;
    boolean isOutputStream = true;
    BaseExceptions exceptions;

    BaseInputStreamWrapper(InputStream inputStream, long l, BaseConnection baseConnection, BaseExceptions baseExceptions) {
        this.is = inputStream;
        this.exceptions = baseExceptions;
        this.numTotalBytesInStream = l;
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
    }

    public int available() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            int n = this.is.available();
            Object var3_3 = null;
            return n;
        }
    }

    public void close() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.is.close();
                this.closed = true;
            }
        }
    }

    public long length() {
        return this.numTotalBytesInStream;
    }

    public synchronized void mark(int n) {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.is.mark(n);
            }
        }
    }

    public boolean markSupported() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                boolean bl = this.is.markSupported();
                Object var3_3 = null;
                return bl;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            if (this.numBytesReturned == this.maxBytesToReturn) {
                return -1;
            }
            int n = this.is.read();
            if (this.numTotalBytesInStream != -1L) {
                boolean bl = false;
                if (n != -1) {
                    ++this.numBytesReturned;
                    if (this.numBytesReturned > this.numTotalBytesInStream) {
                        return -2;
                    }
                } else if (this.numBytesReturned != this.numTotalBytesInStream) {
                    return -2;
                }
                if (!bl) return n;
                return -2;
            }
            if (n <= -1) return n;
            ++this.numBytesReturned;
            return n;
        }
    }

    public int read(byte[] byArray) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            int n = this.read(byArray, 0, byArray.length);
            Object var4_4 = null;
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            if (this.numBytesReturned >= this.maxBytesToReturn) {
                return -1;
            }
            if (byArray.length - n < n2) {
                throw new IOException(this.exceptions.getException(6066).getMessage());
            }
            if (this.numBytesReturned + (long)n2 > this.maxBytesToReturn) {
                n2 = new Long(this.maxBytesToReturn - this.numBytesReturned).intValue();
            }
            int n3 = this.is.read(byArray, n, n2);
            if (this.numTotalBytesInStream != -1L) {
                boolean bl = false;
                if (n3 != -1) {
                    this.numBytesReturned += (long)n3;
                    if (this.numBytesReturned > this.numTotalBytesInStream) {
                        return -2;
                    }
                } else if (this.numBytesReturned != this.numTotalBytesInStream) {
                    return -2;
                }
                if (!bl) return n3;
                return -2;
            }
            if (n3 <= -1) return n3;
            this.numBytesReturned += (long)n3;
            return n3;
        }
    }

    public synchronized void reset() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            this.is.reset();
        }
    }

    void setIsInputStream() {
        this.isOutputStream = false;
    }

    public long skip(long l) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            long l2 = this.is.skip(l);
            Object var6_4 = null;
            return l2;
        }
    }

    void validateClosedState() throws IOException {
        if (this.closed || this.connection != null && this.connection.isClosed()) {
            throw new IOException(this.exceptions.getException(6010).getMessage());
        }
    }
}

