/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseConnectionProperties;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplStatement;
import com.microsoft.jdbc.base.BaseWarnings;
import com.microsoft.util.UtilDebug;
import java.sql.SQLException;

public abstract class BaseImplConnection {
    private static String footprint = "$Revision:   1.23.1.0.1.1  $";
    public static final int ERIS_NOT_SUPPORTED = 0;
    public static final int ERIS_SQL_92 = 1;
    public static final int ERIS_EMPTY_VALUES_LIST = 2;
    public static final int ERIS_DEFAULT_VALUES_LIST = 3;
    private int references = 0;
    public BaseConnectionProperties connectProps;
    protected boolean readOnlyMode;
    public BaseWarnings warnings;
    public BaseExceptions exceptions;
    public UtilDebug debug;
    public char quotingChar = (char)34;

    public void addReference() {
        ++this.references;
    }

    public void addWarning(int n, String string, int n2) {
        this.warnings.add(n, string, n2);
    }

    public abstract void close() throws SQLException;

    protected abstract void commitTransaction() throws SQLException;

    protected abstract BaseImplStatement createImplStatement(int var1, int var2) throws SQLException;

    public boolean enableCancelBasedQueryTimeout() {
        return false;
    }

    protected String getCatalog() throws SQLException {
        return null;
    }

    public int getEmptyRowInsertSyntax() {
        return 0;
    }

    public int getReferenceCount() {
        return this.references;
    }

    protected int getTransactionIsolation() throws SQLException {
        return 0;
    }

    public int mapJavaTypeToSQLType(int n) {
        switch (n) {
            case 1010: {
                return 1;
            }
            case 1008: {
                return 2;
            }
            case 1009: {
                return -7;
            }
            case 1001: {
                return -6;
            }
            case 1003: {
                return 5;
            }
            case 1004: {
                return 4;
            }
            case 1005: {
                return -5;
            }
            case 1006: {
                return 7;
            }
            case 1007: {
                return 8;
            }
            case 1002: {
                return -2;
            }
            case 1011: {
                return 91;
            }
            case 1012: {
                return 92;
            }
            case 1013: {
                return 93;
            }
            case 1020: {
                return 2004;
            }
            case 1021: {
                return 2005;
            }
        }
        return 0;
    }

    public abstract void open() throws SQLException;

    public void removeReference() throws SQLException {
        --this.references;
    }

    public void reset() throws SQLException {
    }

    protected abstract void rollbackTransaction() throws SQLException;

    protected void setCatalog(String string) throws SQLException {
    }

    public void setReadOnly(boolean bl) {
        this.readOnlyMode = bl;
    }

    protected void setTransactionIsolation(int n) throws SQLException {
    }

    protected final void setup(BaseConnectionProperties baseConnectionProperties, BaseWarnings baseWarnings, BaseExceptions baseExceptions) {
        this.connectProps = baseConnectionProperties;
        this.warnings = baseWarnings;
        this.exceptions = baseExceptions;
        this.readOnlyMode = false;
    }

    protected abstract void startManualTransactionMode() throws SQLException;

    protected abstract void stopManualTransactionMode() throws SQLException;

    public boolean supportsSelectStarCommaColumn() {
        return true;
    }
}

