/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.operators.Operator;
import unity.query.LQExprNode;
import unity.query.LQTreeConstants;
import unity.relational.Relation;
import unity.util.StringFunc;

public abstract class LQNode
implements LQTreeConstants {
    protected int type;
    protected LQNode parent;
    protected ArrayList children;
    protected Object content;
    protected Object reference;
    protected Relation outputRelation;
    protected long memorySizeTuples;
    protected Operator op;

    public LQNode() {
        this.type = -1;
        this.parent = null;
        this.outputRelation = null;
    }

    public LQNode(LQNode n) {
        this.type = n.type;
        this.children = new ArrayList(n.children);
        this.parent = n.parent;
        this.content = n.content;
        this.reference = n.reference;
    }

    public void setOperator(Operator o) {
        this.op = o;
    }

    public Operator getOperator() {
        return this.op;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setMemorySizeTuples(long l) {
        this.memorySizeTuples = l;
    }

    public void setType(int t) {
        this.type = t;
    }

    public int getType() {
        return this.type;
    }

    public LQNode getParent() {
        return this.parent;
    }

    public void setParent(LQNode parent) {
        this.parent = parent;
    }

    public boolean hasChildren() {
        return this.getNumChildren() != 0;
    }

    public int getNumChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    public LQNode getChild(int index) {
        return index >= this.getNumChildren() || index < 0 ? null : (LQNode)this.children.get(index);
    }

    public LQNode getChild() {
        if (this.children != null) {
            return (LQNode)this.children.get(0);
        }
        return null;
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public int indexOfChild(LQNode child) {
        return this.children == null ? -1 : this.children.indexOf(child);
    }

    public boolean containsChild(LQNode child) {
        return this.children == null ? false : this.children.contains(child);
    }

    public void addChild(LQNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    public void removeChild(int index) {
        if (this.children != null && index < this.children.size()) {
            this.children.remove(index);
        }
    }

    public void removeChild(LQNode n) {
        if (this.children != null) {
            this.children.remove(n);
        }
    }

    public void removeChild() {
        if (this.children != null) {
            this.children.remove(0);
        }
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object ref) {
        this.reference = ref;
    }

    public void replaceChild(LQNode oldChild, LQNode newChild) {
        int idx = this.indexOfChild(oldChild);
        if (idx == -1) {
            return;
        }
        this.children.set(idx, newChild);
    }

    public void setChild(int idx, LQNode newChild) {
        this.children.set(idx, newChild);
    }

    public ArrayList getRequiredFields() {
        ArrayList a = new ArrayList();
        ArrayList b = null;
        int i = 0;
        while (i < this.children.size()) {
            b = ((LQNode)this.children.get(i)).getRequiredFields();
            a.addAll(b);
            ++i;
        }
        return a;
    }

    public int numTuples() {
        return 0;
    }

    public int tupleSize() {
        return 0;
    }

    public Relation getOutputRelation() {
        return this.outputRelation;
    }

    public String stripDBAttr(String attribute) {
        int index = attribute.substring(0, attribute.lastIndexOf(".")).lastIndexOf(".");
        return attribute.substring(index + 1);
    }

    public String stripDBTable(String table) {
        return table.substring(table.lastIndexOf(".") + 1, table.length());
    }

    public abstract String generateSQL();

    public abstract Operator buildOperator(Operator[] var1) throws SQLException;

    public void print(int k) {
        System.out.println(String.valueOf(StringFunc.spaces(3 * k)) + this.content + " type " + this.type);
        ++k;
        int i = 0;
        while (i < this.getNumChildren()) {
            this.getChild(i).print(k);
            ++i;
        }
    }

    public static ArrayList getAllExprNodes(LQNode node) {
        ArrayList<LQNode> a = new ArrayList<LQNode>();
        if (node instanceof LQExprNode && node.type == 100) {
            a.add(node);
        } else if (node instanceof LQExprNode && node.type == 103) {
            a.addAll(LQNode.getAllExprNodes(node.getChild(0)));
        } else {
            int i = 0;
            while (i < node.getNumChildren()) {
                a.addAll(LQNode.getAllExprNodes(node.getChild(i)));
                ++i;
            }
        }
        return a;
    }
}

