/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import unity.operators.MergeSort;
import unity.operators.Operator;
import unity.operators.SortEliminator;
import unity.predicates.SortComparator;
import unity.query.LQNode;
import unity.relational.Relation;

public class LQDupElimNode
extends LQNode {
    public LQDupElimNode() {
        this.type = 16;
    }

    public String generateSQL() {
        return "DISTINCT";
    }

    public String toString() {
        return this.generateSQL();
    }

    public Operator buildOperator(Operator[] children) throws SQLException {
        int numInputTuples;
        this.outputRelation = new Relation(children[0].getOutputRelation());
        boolean[] ascDesc = new boolean[this.outputRelation.getNumAttributes()];
        int[] attrLocs = new int[this.outputRelation.getNumAttributes()];
        int i = 0;
        while (i < this.outputRelation.getNumAttributes()) {
            attrLocs[i] = i;
            ascDesc[i] = true;
            ++i;
        }
        SortComparator sorter = new SortComparator(attrLocs, ascDesc);
        int bfr = 2;
        int bsize = numInputTuples = this.getChild(0).numTuples();
        MergeSort mergeSortOp = new MergeSort(children[0], bsize, bfr, sorter);
        SortEliminator eliminator = new SortEliminator(mergeSortOp, sorter);
        return eliminator;
    }

    public int numTuples() {
        int numTuples = ((LQNode)this.children.get(0)).numTuples();
        return numTuples;
    }

    public int tupleSize() {
        if (this.getNumChildren() == 1) {
            return ((LQNode)this.children.get(0)).tupleSize();
        }
        return 0;
    }
}

