/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver;

import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseConnectionProperties;
import com.microsoft.jdbc.base.BaseDriverPropertyInfos;
import com.microsoft.jdbc.base.BaseEscapeTranslator;
import com.microsoft.jdbc.base.BaseImplConnection;
import com.microsoft.jdbc.base.BaseImplDatabaseMetaData;
import com.microsoft.jdbc.sqlserver.SQLServerEscapeTranslator;
import com.microsoft.jdbc.sqlserver.SQLServerImplConnection;
import com.microsoft.jdbc.sqlserver.SQLServerImplDatabaseMetaData;
import com.microsoft.jdbc.sqlserver.tds.TDSDTCRequest;
import java.sql.SQLException;

public class SQLServerConnection
extends BaseConnection {
    private static String footprint = "$Revision:   1.11.1.1  $";
    SQLServerImplConnection implConnection = null;
    SQLServerImplDatabaseMetaData databaseMetaData = null;
    int maxPrecision = -1;
    Boolean sendStringParametersAsUnicode = null;

    public BaseEscapeTranslator createEscapeTranslator() throws SQLException {
        return new SQLServerEscapeTranslator();
    }

    protected BaseImplConnection createImplConnection(BaseConnectionProperties baseConnectionProperties) {
        if (this.sendStringParametersAsUnicode == null) {
            String string = baseConnectionProperties.get("sendStringParametersAsUnicode");
            this.sendStringParametersAsUnicode = string == null || !string.equalsIgnoreCase("false") ? new Boolean(true) : new Boolean(false);
        }
        this.implConnection = new SQLServerImplConnection(this);
        return this.implConnection;
    }

    public BaseImplDatabaseMetaData createImplDatabaseMetaData(BaseConnectionProperties baseConnectionProperties) throws SQLException {
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new SQLServerImplDatabaseMetaData(baseConnectionProperties);
        }
        return this.databaseMetaData;
    }

    public TDSDTCRequest createTDSDTCRequest() {
        return new TDSDTCRequest(this.implConnection.conn, this.implConnection.reader, this.implConnection.writer);
    }

    protected void getImplPropertyInfo(BaseDriverPropertyInfos baseDriverPropertyInfos) {
        baseDriverPropertyInfos.put("user", "Login ID", "", null, true);
        baseDriverPropertyInfos.put("password", "Login Password", "", null, true);
        baseDriverPropertyInfos.put("databaseName", "Database name", "", null, false);
        baseDriverPropertyInfos.put("serverName", "Server name", "", null, true);
        baseDriverPropertyInfos.put("portNumber", "Port number", "1433", null, false);
        String[] stringArray = new String[]{"cursor", "direct"};
        baseDriverPropertyInfos.put("selectMethod", "Select Method", "direct", stringArray, false);
        String[] stringArray2 = new String[]{"false", "true"};
        baseDriverPropertyInfos.put("sendStringParametersAsUnicode", "Send UCS2 String Parameters As Unicode", "true", stringArray2, false);
        baseDriverPropertyInfos.put("programName", "Name of the application program", "", null, false);
        baseDriverPropertyInfos.put("hostProcess", "Workstation process ID number", "0", null, false);
        baseDriverPropertyInfos.put("netAddress", "Workstation's network interface card address", "000000000000", null, false);
        baseDriverPropertyInfos.put("WSID", "Workstation's ID", "", null, false);
    }
}

