//
//  XTTableInfo.h
//  XTads
//
//  Created by Rune Berg on 30/10/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTTextTableBlock.h"
#import "XTTextTableBlockCaption.h"


//NS_ASSUME_NONNULL_BEGIN

@interface XTTableInfo : NSObject

- (void)noteMaxContentRectWidth:(CGFloat)width
					  forColumn:(NSInteger)column;

- (void)noteMinContentRectWidth:(CGFloat)width
					  forColumn:(NSInteger)column
						 forRow:(NSInteger)row;

- (CGFloat)minContentRectWidthForColumn:(NSInteger)column;

- (void)noteMinContentRectHeight:(CGFloat)height
						  forRow:(NSInteger)row;

- (void)noteTotalBoundsForTextTableBlock:(XTTextTableBlock *)textTableBlock
								   width:(CGFloat)width
								  height:(CGFloat)height;

- (void)noteBoundsRectForTextTableBlock:(XTTextTableBlock *)textTableBlock
								  width:(CGFloat)width
								 height:(CGFloat)height;

- (void)noteHorizRulerWidthAsPoints:(CGFloat)width
						  forColumn:(NSInteger)column;

- (void)noteMinCaptionContentRectWidth:(CGFloat)width;

- (CGFloat)contectRectWidthForTextTableBlock:(XTTextTableBlock *)textTableBlock
								 usableWidth:(CGFloat)usableWidth;

- (CGFloat)contectRectWidthForTextTableBlockCaption:(XTTextTableBlockCaption *)textTableBlock
										usableWidth:(CGFloat)usableWidth;

- (CGFloat)contentRectXForTextTableBlock:(XTTextTableBlock *)textTableBlock
								 originX:(CGFloat)originX
							 usableWidth:(CGFloat)usableWidth;

- (CGFloat)contectRectHeightForTextTableBlock:(XTTextTableBlock *)textTableBlock
								visibleHeight:(CGFloat)visibleHeight;

- (CGFloat)totalTableWidth;

- (void)clear;

- (void)clearForRecalcOfTables;

@end

//NS_ASSUME_NONNULL_END
