/* The Easy Death Module:
 *	This module is standard in my games.  All it does is take the old
 * Would you like to restore, quit, restart? prompt and makes it into this:
 * Would you like to (r)estore, (q)uit, re(s)tart?  This allows the player
 * to enter 'q' instead of the full 'quit' etc.
 * 	Thus, the player can continue on after dying with very little break
 * in the game's flow, except to perhaps read a humorous death message.
 * Please note that both with and without this module, WADV.T provides for
 * undo'ing after death.  If you have a dislike for this feature, it is a
 * simple matter to just remove the offending code.  If you want my advice,
 * however, I'd suggest not inconveniencing the player.  While this module
 * isn't quite the LucasArts method of no death at all, it comes very close.
 */

replace die: function
{
    "\b*** You have died ***\b";
    scoreRank();
    "\bYou may restore a saved game, start over, undo the
	last move, or quit. ";
    while ( 1 )
    {
        local resp;

	"\nPlease enter (R)ESTORE, RE(S)TART, (U)NDO, or (Q)UIT: >";
        resp := upper(input());     /* get input, convert to uppercase */
        if ( resp = 'RESTORE' or resp = 'R')
	{
	    resp := askfile( 'File to restore' );       /* find filename */
	    if ( resp = nil ) "Restore failed. ";
	    else if ( restore( resp )) "Restore failed. ";
	    else
	    {
		Me.location.lookAround(true);
		scoreStatus();
		abort;
	    }
	}
        else if ( resp = 'RESTART' or resp = 'S')
	{
	    scoreStatus();
            restart();
	}
	else if ( resp = 'UNDO' or resp = 'U')
	{
	    if (undo())
	    {
		"(Undoing one command)\b";
		Me.location.lookAround(true);
		scoreStatus();
		abort;
	    }
	    else
		"Sorry, no undo information is available.";
	}
	else if ( resp = 'QUIT' or resp = 'Q')
        {
	    terminate();
            quit();
	    abort;
        }
    }
}
