#include <adv.t>
#include <std.t>
#include <askabout.t>


/* This program is Copyright (c) 1994 David Allen.  It may be freely
   distributed as long as you leave my name and copyright notice on it.
   I'd really like your comments and feedback; send e-mail to
   allen@viewlogic.com, or send us-mail to David Allen, 10 O'Moore Ave,
   Maynard, MA 01754. */


/* This is a simple game with four rooms, some items and some actors.  It
   is intended to show how actors can keep track of the location of items
   and tell you when you ask them.  See the askabout.t and askabout.doc 
   files for more information. */


/* Have to add aaInit() to preinit, copied from adv.t */
replace preinit: function {
   local o;
   global.lamplist := [];
   o := firstobj();
   while (o <> nil) {
      if (o.islamp) global.lamplist := global.lamplist + o;
      o := nextobj (o); }
   initSearch();
   aaInit(); }


/* Some generic rooms */


class biffsturf: object; /* This is to mark rooms which Biff knows */


startroom: room
   sdesc = "North Mall" thedesc = "the north end of the mall"
   ldesc = {
      "You're standing in a standard American mall.  There are
      boring stores in all directions, and crowds of boring people.
      The corridor leads south from here.  There is an interesting
      store to the north. ";

      /* Since this is the startroom, the first time thru, start daemon */
      if (not self.isseen) notify (muffy, &actorDaemon, 0); }
   south = southmall
   north = store;


southmall: room
   sdesc = "South Mall" thedesc = "the south end of the mall"
   ldesc = "You're standing in a standard American mall.  There are
      boring stores in all directions, and crowds of boring people.
      The corridor leads north from here. "
   north = startroom;


store: room, biffsturf
   sdesc = "Store" thedesc = "the store in the north end of the mall"
   ldesc = "You are in a generic mall store.  There is a smaller showroom
      to the north; the entrance to the mall is south. "
   noun = 'store'
   north = showroom
   south = startroom;


showroom: room, biffsturf
   sdesc = "Showroom" thedesc = "the showroom in the store"
   ldesc = "This is the showroom for the store.  The exit is to the south. "
   noun = 'showroom' 'room' adjective = 'show'
   south = store;


/* Some decorations and items */


fountain: decoration
   sdesc = "fountain"
   ldesc = "It is a fountain, the kind you often find in malls. "
   heredesc = "There is a fountain here. "
   noun = 'fountain'
   location = southmall;


bench: fixeditem
   sdesc = "bench"
   ldesc = "It is a bench, the kind you often find in malls. "
   heredesc = "There is a bench here. "
   noun = 'bench'
   location = startroom;


register: fixeditem
   sdesc = "cash register"
   ldesc = "It is a cash register, the kind you often find in mall stores. "
   heredesc = "There is a cash register on the counter. "
   noun = 'register' adjective = 'cash'
   location = store;


trinket: item
   sdesc = "trinket"
   ldesc = "It is a trinket, the kind you often find in mall stores. "
   heredesc = "There is a trinket for sale here. "
   noun = 'trinket'
   location = showroom;


/* Two actors */


biff: Actor
   sdesc = "Biff" thedesc = "Biff" adesc = "Biff" noun = 'biff' 'boy'
   ldest = "Biff is a teenage boy, the kind you often find in malls.  He
      works in the store. "
   aaTurfClass = biffsturf
   location = store;


muffy: Actor
   sdesc = "Muffy" thedesc = "Muffy" adesc = "Muffy" noun = 'muffy' 'girl'
   ldest = "Muffy is a teenage girl, the kind you often find in malls. "
   location = startroom
   tcount = 0
   /* Wander to random room once per three turns */
   actorDaemon = {
      local dir, dirnum, tries, newloc;
      tcount++; if (tcount < 3) return; else tcount := 0;
      for (tries:=1; tries<50; tries++) {
         dirnum := rand (6);
         dir := [&north &south &east &west &up &down][dirnum];
         if (proptype (self.location, dir) = 2) {
            newloc := self.location.(dir);
            if (self.location = Me.location) {
               self.sdesc; " leaves to the ";
               say (['north' 'south' 'east' 'west' 'up' 'down'][dirnum]);
               ". "; }
            self.moveInto (newloc);
            if (self.location = Me.location)
               "<<self.sdesc>> wanders into the room. ";
            return; } } };
