/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// UndoCache.cpp : implementation file
//

#include "stdafx.h"
#include "WinAce.h"
#include "UndoCache.h"


// CUndoCache

CUndoCache::CUndoCache(int maxUndoLevel = 5)
{
	UndoArray = new CFile* [ maxUndoLevel+1 ];
	max = maxUndoLevel;
	current = 0;
	for ( int count=0; count < maxUndoLevel+1; count++ )
	{
		UndoArray[count]=NULL;
	}
}

	void CUndoCache::Push( CFile *file )
	{
		if ( UndoArray[current]!= NULL )
		{
			UndoArray[current]->Close();
			delete UndoArray[current];
		}

		UndoArray[current] = file;
		current++;
		if ( current > max )
		{
			current = 0;
			if (UndoArray[current] != NULL )
			{
				UndoArray[current]->Close();
				delete UndoArray[current];
				UndoArray[current]=NULL;
			}
		}
	}

	bool CUndoCache::IsEmpty()
	{
		if ( current != 0 )
		{
			if ( UndoArray[current-1] ==NULL )
				return true;
		}
		else
		{
			if ( UndoArray[max] == NULL )
				return true;
		}

		return false;
	}

	void CUndoCache::Empty()
	{
	 for ( int count=0; count < max+1; count++ )
	 {
	    if ( UndoArray[count] != NULL )
		{
			UndoArray[count]->Close();
			delete UndoArray[count];
		}
	 		UndoArray[count]=NULL;
	 }	
	 
	}

	CFile *CUndoCache::Pop( )
	{
		CFile *Payload = NULL;
		if ( current != 0 )
		{
			Payload = UndoArray[current-1];
			UndoArray[current-1]=NULL;
			current--;
		}
		else
		{
			Payload = UndoArray[max];
			UndoArray[max]=NULL;
			current = max;
		}
		return Payload;
	}

CUndoCache::~CUndoCache()
{
	Empty();
	delete UndoArray;
}


// CUndoCache member functions
