/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/

// ObjectList.cpp: implementation of the CObjectList class.
//
//////////////////////////////////////////////////////////////////////
#include "StdAfx.h"

#include "MessageList.h"
#include "ObjectList.h"
#include "RuntimeError.h"
#include "OutputStream.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMPLEMENT_SERIAL( CObjectList, CObject, 1);

CObjectList::CObjectList( CParser *parser)
{
	ObjectList.SetSize(1000);
	Descriptions.SetSize(1000);
	ShortDescription.SetSize(1000);
	LastObject = 0;
	this->parser = parser;
}

CObjectList::~CObjectList()
{
	for ( int count = 0; count< LastObject; count ++) delete ObjectList[count];

}

CObjectDef *CObjectList::GetObject(int ObjectNo)
{
	if ( ObjectNo > LastObject )
	{
		throw ( new CRuntimeError( _T("Attempt To Access an Unknown Object - "),ObjectNo));
	}
	return ObjectList[ObjectNo];
}

void CObjectList::SetObject( int ObjNo,CObjectDef *ObjDef)
{
	ObjectList[ObjNo]=ObjDef;
	LastObject++;
	
}

void CObjectList::SetObjectDesc( int ObjNum, CString ObjectDesc )
{
	Descriptions[ObjNum]=ObjectDesc;
}

int CObjectList::Get( int Obj )
{
	CString Desc;
	CObjectDef *Def;


	Desc = ShortDescription[Obj];
	Def = GetObject( Obj );

	if ( (Def->Location == OBJ_CARRIED) || ( Def->Location == OBJ_WORN ) )
	{
		SysMsgs->PrintMessage(25,Desc,parser );
		return -1;
	}

	if ( Def->Location != Flags->GetFlag( 38 ) ) //flag 38 is the current location
	{
		SysMsgs->PrintMessage(26,_T(""),parser);
		return -1;
	}

	if ( ((Flags->WeightCarried)+Def->ObjWeight)>(Flags->GetFlag(52)))
	{
		Desc = Desc;
		SysMsgs->PrintMessage(43,Desc,parser);
		return -1;
	}

	if ((Flags->ObjectsCarried)==(Flags->GetFlag(37)))
	{
		SysMsgs->PrintMessage(27,_T(""),parser);
		return -1;
	}

	Def->Location = OBJ_CARRIED;
	Flags->ObjectsCarried++;
	Flags->WeightCarried+=Def->ObjWeight;
	Flags->SetFlag( 1, Flags->ObjectsCarried );

	SysMsgs->PrintMessage(36,Desc,parser);
	COutputStream Out; Out.WriteLine(_T(""));
	
	return 1;
}

int CObjectList::Drop( int Obj )
{
	CString Desc;
	CObjectDef *Def;

	Desc = ShortDescription[Obj];
	Def = GetObject( Obj );

	if ( Def->Location == OBJ_WORN )
	{
		SysMsgs->PrintMessage(24,Desc,parser);
		return -1;
	}

	if ( (Def->Location == Flags->GetFlag(38)) )
	{
		Desc = Desc;
		SysMsgs->PrintMessage(49,Desc,parser);
		return -1;
	}

	if ( Def->Location != OBJ_CARRIED )
	{
		SysMsgs->PrintMessage(28,_T(""),parser);
		return -1;
	}

	Flags->WeightCarried-=Def->ObjWeight;
	Flags->ObjectsCarried --;
	Flags->SetFlag(1, Flags->ObjectsCarried );
	Def->Location=Flags->GetFlag(38);

	SysMsgs->PrintMessage(39,Desc,parser );
	COutputStream Out; Out.WriteLine(_T(" "));
	return 1;
}





void CObjectList::Serialize( CArchive &ar )
{
	unsigned int counter=0;
	wchar_t String[255];
	CString newSteing;
	if ( ar.IsStoring() )
	{
		ar << LastObject;
		for ( int count=0; count < LastObject; count++)
		{
			ar<<Descriptions[count];
			ObjectList[count]->Serialize( ar );
		}
	}
	else
	{
		ar >> LastObject;
		Descriptions.SetSize(LastObject);
		
		ObjectList.SetSize( LastObject);
		ShortDescription.SetSize( LastObject );
		for ( int count=0; count < LastObject; count++)
		{
			ar>>Descriptions[count];
			Descriptions[count]=Descriptions[count].Left( Descriptions[count].GetLength()-1 );
			wcscpy(String,Descriptions[count].GetBuffer());
			for ( counter=0; (( counter< wcslen(String) )&& ( String[counter] != ' ' )); counter++ );
			ShortDescription[count] = String+(counter+1);	
			ObjectList[count]=new CObjectDef;
			ObjectList[count]->Serialize( ar );
		}
		MaxObjects=LastObject;
	}
}

void CObjectList::GameSerialize( CArchive &ar )
{
	int count;

	for ( count=0; count<LastObject; count ++ )
		{
			ObjectList[count]->GameSerialize( ar );
		}
}

CString CObjectList::GetObjectDesc(int ObjNo)
{
	if ( ObjNo > LastObject )
	{
		throw ( new CRuntimeError( _T("Attempt To Access an Unknown Object - Long Description")));
	}
	return Descriptions[ObjNo];
}

CString CObjectList::GetObjectDescShort( int ObjNo )
{
	if ( ObjNo > LastObject )
	{
		throw ( new CRuntimeError( _T("Attempt To Access an Unknown Object's - Short Description")));
	}
	return ShortDescription[ObjNo];
}

void CObjectList::Reset(void)
{
	int count=0;
	for( count=0; count<MaxObjects; count++)
	{
		GetObject(count)->SetLocation(GetObject(count)->StartLocation);
		GetObject(count)->Worn = FALSE;
	}
}

void CObjectList::ListAt( int LocNo )
{
	int count;
	bool none=true;
	CObjectDef *Object;
	CString temp;
	COutputStream OutStream;

//	SysMsgs->PrintMessage(9,"");
	for ( count=0; count<MaxObjects; count++ )
	{
		Object = GetObject( count );

		if ( (Object->Location == LocNo ) )
		{
			if ( !none )
				SysMsgs->PrintMessage(46,_T(""),parser); // print ,
			temp = GetObjectDesc( count );
			temp.MakeLower();
			temp=temp;
			OutStream.Write( temp );
			// printf("%s",temp); // print description
		
			if ( Object->Location == OBJ_WORN )
			{
				SysMsgs->PrintMessage(10,_T(""),parser); //print (worn)
			}
			
			none=false;
		}
	}
	if ( none )
		SysMsgs->PrintMessage(11,_T(""),parser); //print nothing at all.
	else
		SysMsgs->PrintMessage(48,_T(""),parser); //print .
	
}


void CObjectList::ListCarried(void)
{
	int count;
	bool none=true;
	CObjectDef *Object;
	CString temp;
	COutputStream OutStream;


	SysMsgs->PrintMessage(9,_T(""),parser);
	for ( count=0; count<MaxObjects; count++ )
	{
		Object = GetObject( count );

		if ( (Object->Location == OBJ_CARRIED) || (Object->Location == OBJ_WORN ) )
		{
			if ( !none )
				SysMsgs->PrintMessage(46,_T(""),parser); // print ,
			temp = GetObjectDesc( count );
			temp.MakeLower();
			temp=temp;
			OutStream.Write( temp );
			//printf("%s",temp); // print description
		
			if ( Object->Location == OBJ_WORN )
			{
				SysMsgs->PrintMessage(10,_T(""),parser); //print (worn)
			}
			
			none=false;
		}
	}
	if ( none )
		SysMsgs->PrintMessage(11,_T(""),parser); //print nothing at all.
	else
		SysMsgs->PrintMessage(48,_T(""),parser); //print .
}

void CObjectList::SetCurrentObject( void )
{
	int count;
	CObjectDef *Object;

	for ( count =0; count <MaxObjects; count ++ )
	{
		Object = GetObject( count ); //Retrieve the objects details
		if ( Object->Noun == Flags->GetFlag( FL_NOUN1 ) ) //will need to also scan noun2?
		{
			Flags->SetFlag( FL_CURRENT_OBJECT , count );
			Flags->SetFlag( 54, Object-> Location );
			Flags->SetFlag( 55, Object->ObjWeight);
			Flags->SetFlag( 57,0);
			Flags->SetFlag( 56,0); 
			if ( Object->Wearable ) Flags->SetFlag( 57, 128 );
			if ( Object->Container ) Flags->SetFlag( 56,128 );
			return;
		}
	}
	//will also need to check NOUN2 ... but as the parser dosnt parse it yet i wont .. yet
}

void CObjectList::SetCurrentObject( int ObjNo )
{
	CObjectDef *Object;

	Object = GetObject( ObjNo );
	Flags->SetFlag( FL_CURRENT_OBJECT , ObjNo );
	Flags->SetFlag( 54, Object-> Location );
	Flags->SetFlag( 55, Object-> ObjWeight);
	Flags->SetFlag( 57,0);
	Flags->SetFlag( 56,0); 
	if ( Object->Wearable ) Flags->SetFlag( 57, 128 );
	if ( Object->Container ) Flags->SetFlag( 56,128 );
	return;
}   //will also need to check NOUN


int CObjectList::GetObject(int Noun, int Adjective, int start)
{
	int count;
	CObjectDef *Object;
	if ( Noun == -1 ) return -1;

	for ( count =start; count <MaxObjects; count ++ )
	{
		Object = GetObject( count ); //Retrieve the objects details
		if ( Object->Noun == Noun ) //will need to also scan noun2?
		{
			if ( (Object->Adjective == Adjective) || ( Object->Adjective == -1 ) )
			return count;
		}
	}

	return -1;
}

int CObjectList::Wear( int ObjNum )
{

	CString Desc;
	CObjectDef *Def;

	
	Def = GetObject( ObjNum );
	Desc = ShortDescription[ObjNum];

	if ( Def->Location == Flags->GetFlag( 38 )  )
	{
		SysMsgs->PrintMessage(49,Desc,parser);
		return -1;
	}

	if ( Def->Location == OBJ_WORN )
	{
		Desc = Desc + _T(".");
		SysMsgs->PrintMessage( 29, Desc,parser );
		return -1;
	}

	if ( Def->Location != OBJ_CARRIED )
	{
		SysMsgs->PrintMessage( 28,_T(""),parser);
		return -1;
	}

	if ( !Def->Wearable )
	{
		SysMsgs->PrintMessage( 40, Desc,parser );
		return -1;
	}

	SysMsgs->PrintMessage( 37, Desc ,parser);
	Flags->ObjectsCarried --;
	Flags->SetFlag(1, Flags->ObjectsCarried );
	Def->Location = OBJ_WORN;

	return 1;
};


int CObjectList::Remove( int ObjNum )
{

	CString Desc;
	CObjectDef *Def;

	
	Def = GetObject( ObjNum );
	Desc = ShortDescription[ObjNum];

	if ( (Def->Location == Flags->GetFlag( 38 )) || (Def->Location == OBJ_CARRIED ) )
	{
		SysMsgs->PrintMessage(50,Desc,parser);
		return -1;
	}

	if ( Def->Location != OBJ_WORN )
	{
		Desc  = Desc;
		SysMsgs->PrintMessage( 23, Desc,parser );
		return -1;
	}

	if ( !Def->Wearable )
	{
		SysMsgs->PrintMessage( 41,Desc,parser);
		return -1;
	}

	if ( Flags->GetFlag( 1 ) >= Flags->GetFlag(37) )
	{
		SysMsgs->PrintMessage( 42, Desc,parser );
		return -1;
	}

	SysMsgs->PrintMessage( 38, Desc,parser );
	Flags->ObjectsCarried ++;
	Flags->SetFlag(1, Flags->ObjectsCarried );
	Def->Location=OBJ_CARRIED;

	return 1;
}



bool CObjectList::validate(int ObjectNum)
{

	if ( ObjectNum > LastObject )
		return false;

	return true;
}



int CObjectList::ObjectsCarried()
{
    int count;
	bool none=true;
	CObjectDef *Object;
	CString temp;
	int NumberCarried = 0;

	for ( count=0; count<MaxObjects; count++ )
	{
		Object = GetObject( count );

		if ( (Object->Location == OBJ_CARRIED))
		{
			NumberCarried++;
		}
	}
	return NumberCarried;
}

void CObjectList::BodgeRoom255(int location)
{
	int count;
	CObjectDef *Object;
	for ( count=0; count<MaxObjects; count++ )
	{
		Object = GetObject( count );

		if ( (Object->Location == 255) )
		{
			Object->Location = location;
		}
	}
}

int CObjectList::GetObjectCount()
{
	return LastObject;
}
