/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// ObjectDef.cpp: implementation of the CObjectDef class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "ObjectDef.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMPLEMENT_SERIAL( CObjectDef, CObject, 1)

CObjectDef::CObjectDef()
{
	
}

CObjectDef::~CObjectDef()
{

}

void CObjectDef::SetWeight(int Weight)
{
	ObjWeight = Weight;
}

int CObjectDef::GetWeight()
{
	return ObjWeight;
}


int CObjectDef::GetLocation()
{
	return Location;
}

void CObjectDef::SetLocation(int NewLocation)
{
	Location = NewLocation;
}

void CObjectDef::Serialize( CArchive &ar )
{
	if ( ar.IsStoring() )
	{
		ar << Adjective << Container << StartLocation << ObjWeight
		   << Noun << Wearable;
	}
	else
	{
		int intContainer, intWearable;
		ar >> Adjective >> Container >> StartLocation >> ObjWeight
		   >> Noun >> Wearable;
//		Container=intContainer;
//		Wearable=intWearable;
	}
}

void CObjectDef::GameSerialize( CArchive &ar )
{
	if (ar.IsStoring())
	{
		ar << Location << ContainedBy;
	}
	else
	{
		ar >> Location >> ContainedBy;
	}
}


bool CObjectDef::Absent(int CurrentLocation)
{
if ((Location != CurrentLocation) && ( Location != OBJ_CARRIED ) && ( Location != OBJ_WORN ) )
	return true;
else
	return false;


}
