/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// OutputStream.h: interface for the COutputStream class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OUTPUTSTREAM_H__8DBFD761_FB15_11D1_AD08_00805F36B9D5__INCLUDED_)
#define AFX_OUTPUTSTREAM_H__8DBFD761_FB15_11D1_AD08_00805F36B9D5__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

//#include "afx.h"
#include "Event.h"
class CWinAceView;

class COutputStream
{
public:
	void clearEvents();
	void addStart();
	int getFontSze();
	CString getFontName();
	void flush();
	void AddQuit( CString prompt );
	void AddEnd( CString prompt);
	void AddPause( int seconds );
	void AddFinish();
	void AddWaitKey( );
	CEvent getNextEvent();
	bool empty();
	void SetView( CWinAceView *newView);
	void ClearHTML( );
	void AddHTML(CString);
	void ClearScreen();
	void Write( CString Text );
	void WriteLine( CString Text  );
	void WriteDesc( CString Description,int ScreenMode );
	void StartWrite();
	void RawWrite( CString Text );
	void EndWrite();

	CString FormatString( CString Text );

	void SetFont( CString fontName, int pointSz );

	COutputStream();
	COutputStream( CWinAceView *);
	~COutputStream();

private:
	CString colour;
	static CWinAceView *p_view;
	static CString face;
	static int size;

	static CList < CEvent, CEvent > eventList;

};

#endif // !defined(AFX_OUTPUTSTREAM_H__8DBFD761_FB15_11D1_AD08_00805F36B9D5__INCLUDED_)
