/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
#ifndef _VOCAB
#define _VOCAB

#include "afx.h"

#define V_VERB		1
#define V_NOUN		2
#define V_ADJECTIVE	3
#define V_ADVERB		4
#define V_PREPOSITION	5
#define V_PRONOUN		6
#define V_CONJUGATION 7

class CVocabEntry : public CObject
{
	DECLARE_SERIAL( CVocabEntry )

	CArray < CString, CString > WordList;
	bool Contains ( CString );
	void Add( CString Word ) { WordList.Add( Word ); }
	virtual void Serialize( CArchive &ar );
	~CVocabEntry(){ WordList.RemoveAll();}
};


class CVocab : public CObject
{
	DECLARE_SERIAL( CVocab );

public:
	CVocab( void );
	~CVocab( void );
	int GetVerb( CString  );
	int GetNoun( CString  );
	int GetAdjective( CString );
	int GetAdverb ( CString );
	int GetPreposition( CString );
	int GetPronoun ( CString );
	int GetConjugation( CString );

	void SetVerb( CString, int );
	void SetNoun( CString, int );
	void SetAdjective( CString, int );
	void SetAdverb( CString, int );
	void SetPreposition( CString, int );
	void SetPronoun( CString, int );
	void SetConjugation( CString, int );

	virtual void Serialize( CArchive & ar );
	

private:
	//THESE ARE DUMMY FUNCTIONS / STRUCTURES!

	CArray <CVocabEntry , CVocabEntry > Verbs;
	CArray <CVocabEntry , CVocabEntry > Nouns;
	CArray <CVocabEntry , CVocabEntry > Adjectives;
	CArray <CVocabEntry , CVocabEntry > Adverbs;
	CArray <CVocabEntry , CVocabEntry > Prepositions;
	CArray <CVocabEntry , CVocabEntry > Pronouns;
	CArray <CVocabEntry , CVocabEntry > Conjugations;
};

#endif
