/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// AdvMap.h: interface for the CAdvMap class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ADVMAP_H__94E53303_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_)
#define AFX_ADVMAP_H__94E53303_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "RuntimeError.h"

class CAdvLocation : public CObject
{
DECLARE_SERIAL( CAdvLocation )

public:
	int Connection[15];
	CString Description;
	CAdvLocation(){ for (int i=0; i<15; i++) Connection[i]=-1; };
	virtual void Serialize( CArchive &ar );
};


class CAdvMap  : public CObject
{
	DECLARE_SERIAL( CAdvMap )

public:
	bool validate( int LocationNo );
	CString GetDescription( int location );
	int MapLocation( int location, int verb );
	void SetConnection( int location, int verb, int connection ){ LocationConn[location].Connection[verb]=connection; };
	void SetDescription( int location, CString Description){ LocationConn[location].Description = Description; };
	CAdvMap();
	virtual ~CAdvMap();
	void Output( void );
	virtual void Serialize( CArchive &ar );

	int MaxLocation;

private:
	CArray < CAdvLocation, CAdvLocation > LocationConn;
	

};

#endif // !defined(AFX_ADVMAP_H__94E53303_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_)
