/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
#pragma once
//#include "CompilerDlg.h"
#include "states.h"
#include "FlagTable.h"
#include "ObjectList.h"
#include "cparser.hpp"
//#include "condactsarray.h"
//#include "cvocab.hpp"
//#include "..\WinAce\ccondact.hpp"
//#include "cpstack.hpp"
#include "condacts.h"
//#include "MessageList.h"
//#include "ObjectDef.h"
#include "ProcessTable.h"
#include "AdvMap.h"
#include "CompilerDlg.h"
#include "acecompiler.h"

class CAceCompiler
{
public:
	CAceCompiler(void);
	~CAceCompiler(void);
	int GetVocab();
	int GetWordType( CString );

	int GetSysMsgs();
	int GetStdMsgs();
	int GetObjectText();
	int GetLocationText();
	int GetConnections();
	int GetObjectDefs();
	int GetProcessTables();
	int GetCondActNum( char * );
	char *my_fgets( char *string, int count, FILE *stream );
	bool check_for_lnk( char *string );
	void print_error( wchar_t *error_text, CString Param1 = _T(""));
	bool CheckParam( int type, CString Param1, wchar_t *output );
	int SourceLine; // Holds Current Source Line.

	CVocab Vocabulary;				//The vocabulary Object
	CMessageList SysMsgs , StdMsgs;	//Messages
	CObjectList ObjectList;			//Objects
	CAdvMap Locations;				//Locations
	CProcessTable* Tables[1024];		//Process Tables
	int ProcessTableCount;		//Count of the number of the above!!
	bool BlanksOK;			//blanks ignored or not!!
	char filename[255];
	int Registered;
	int Debug;

	FILE *InFile;
	// Get The PArty Started!!
	bool Compile(wchar_t * InputFilename, wchar_t * OutputFilename, bool debugVersion, CCompilerDlg * ParentWnd);
protected:
	CCompilerDlg *dlg;
};
