#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>


highscoreBoard : Component,InitObject 'high score highscore scoreboard/display/board*scores' 'highscore board'
	@arcade	
	"The highscore board is hung prominently on the wall. It is a source
	of envy and admiration among the dedicated players at this arcade.
	Anyone can register their high scores by putting their prize tickets into
	the machine, but only the top 10 players will ever show up on the board.
	The current top 10 players are:\b
	<center><<topPlayersList>></center>
	\b"
	
	specialDesc = "The highscore board is hanging prominently on the south wall. "
	
	topPlayersList {
		"<TABLE border=1 width=25%><TR><TD>";
		"<TABLE width=100%>";
		"<TR><TD><TD><TD><B>NAME</B><TD align=center><B>SCORE</B><TD>";
		
		local playerScoreWasOutput = nil;
		for(local i=1; i<=10 && i<=topPlayers.length; ++i) {
			local pname = topPlayers[i][1];
			local pscore = topPlayers[i][2];			
			if(!playerScoreWasOutput && pscore < playerScore) {
				outputTopPlayerRow(i,gPlayerChar.properName,playerScore);
				playerScoreWasOutput = true;
			} else {
				outputTopPlayerRow(i,pname,pscore);
			}
		}
		
		"</TABLE>";
		"</TABLE>";
	}
	outputTopPlayerRow(ix,name,score) {
		"<TR><TD width=10%><TD><<ix>>. <TD><<name>><TD align=center><<score>><TD width=10%>";
	}


	topPlayers = nil
	numWinningTickets = nil

	execute {
		numWinningTickets = countAllOfType(WinningTicket);
		topPlayers = [
			[player2.nickname,numWinningTickets-videoGameGlobalInfo.countGamesInBasement],
			['RedDragon',numWinningTickets-videoGameGlobalInfo.countGamesInBasement-1],
			['Nerfherder',numWinningTickets-videoGameGlobalInfo.countGamesInBasement-1],
			['Zarf',numWinningTickets-videoGameGlobalInfo.countGamesInBasement-1],
			['Cobalt',numWinningTickets-videoGameGlobalInfo.countGamesInBasement-2],
			['HighTower',numWinningTickets-videoGameGlobalInfo.countGamesInBasement-2],
			['RAM',numWinningTickets-videoGameGlobalInfo.countGamesInBasement-3],
			['MasterBlaster',numWinningTickets-videoGameGlobalInfo.countGamesInBasement-3],
			['l337',numWinningTickets-videoGameGlobalInfo.countGamesInBasement-3],
			['Pacmaster',numWinningTickets-videoGameGlobalInfo.countGamesInBasement-3]
			];
			
			for(local i=topPlayers.length; i<42; ++i)
				topPlayers += [['',numWinningTickets-4]];
			for(local i=topPlayers.length; i<94; ++i)
				topPlayers += [['',numWinningTickets-5]];
			for(local i=topPlayers.length; i<239; ++i)
				topPlayers += [['',numWinningTickets-6]];
	}	
	
		
	playerName = nil
	playerScore = 0
	
	// This returns true if the player's score is high enough that they are on the board.
	playerOnBoard {
		return playerScore > topPlayers[10][2];
	}
	playerRanking {
		for(local i=1; i<=topPlayers.length; ++i) {
			local pscore = topPlayers[i][2];			
			if(pscore < playerScore) {
				return i;
			}
		}
		return topPlayers.length+1;
	}
	
	iobjFor(PutIn) {
		verify() {
			if(gDobj!=nil && !gDobj.ofKind(WinningTicket)) {
				illogical('{You/he} can\'t put {that dobj/him} in there. ');
			}
		}
		action() {
			gDobj.moveInto(nil);
			++playerScore;
			
			"The ticket zips into the ticket feeder with a <q>FWIP</q> and is gone. ";
			
			if(playerScore==1) {
				"The highscore display changes to read <q>Please enter your name as you would
				like it to be displayed on the highscore board.</q>.\b";
				do {
					gPlayerChar.properName = inputManager.getInputLine(nil,{:"YOUR NAME: "});
					"\b";
					
					if(gPlayerChar.properName==nil || gPlayerChar.properName=='') {
						"Please input your name as you want it displayed on the highscore board.\n";
					}
				} while(gPlayerChar.properName==nil || gPlayerChar.properName=='');
			} else {
				"When the display prompts you, you enter <q><<gPlayerChar.properName>></q> for
				your name again.\b ";
			}
			
			"For a few seconds the display changes again to say
			<q>You have achieved rank <<playerRanking>>.</q> and then reverts back
			to displaying the top 10. ";
			
			if(!playerOnBoard) {
				"Sadly, your score is still too low to be listed on the board. ";
			}
			
			"\b";

			if(playerScore==numWinningTickets) {
				"You have beaten everyone in the arcade!
				You have won every ticket that it is possible to win. And since you won
				them first, no one else will ever beat your high score.
				Well, they could if the owner were to buy more games. Perhaps you should
				burn the building down so that no one else will ever beat your score?
				... No, that would burn up the scoreboard too. In any case, that sort
				of behavior would be frowned upon by the other gamers. No, you're better
				than that. You can beat any game. BRING 'EM ON!\b ";
			
				achieve.awardPointsOnce();
				endGame('*** YOU HAVE WON (EVERYTHING) ***');
			}
			
			// This is not currently possible to attain because all games are required in order to win.
			if(playerRanking()==1) {
				"You have beaten everyone in the arcade!
				You have not won every ticket that it is possible to win,
				but you are in first place.
				Perhaps you should burn the building down so that no one else will ever
				beat your score?
				... No, that would burn up the scoreboard too. In any case, that sort
				of behavior would be frowned upon by the other gamers. No, you're better
				than that. You can beat any game. BRING 'EM ON!\b ";
			
				achieve.awardPointsOnce();
				endGame('*** YOU HAVE BEATEN EVERYONE ***');
			}
		}
	}
	
	iobjFor(FeedInto) asIobjFor(PutIn)
	iobjFor(PutOn) asIobjFor(PutIn)
	
	achieve : Achievement {+1 "putting last ticket in highscore board";}
;

+ highscoreBoardFeeder : Component 'slot (ticket) feeder' 'ticket feeder'
	"The feeder is nothing more than a little slot in the highscore board where people
	feed in the tickets they have won. There is also a small keyboard beneath it that
	allows people to enter in their names. "

	iobjFor(PutIn) {
		verify() {}
		check() {}
		action() {
			nestedAction(PutIn,gDobj,highscoreBoard);
		}
	}	
;
+ highscoreBoardKeyboard : Component 'small keyboard' 'keyboard'
	"The keyboard is only active after a player puts their first ticket into the feeder.
	It is used to enter in the player's name. "
;

