\ actions.f for advtr.f  Leo Wong 27 June 02003 fyj +
\ These are 8000-- in advent.for
\ Most go to 2011-12, but some go elsewhere
\ Will keep a reference to the Fortran line numbers
\ It may be that the words should return spk, but for now they set spk
\ and return nothing.  Names in quotes to prevent collisions

0 VALUE spk

\ Routines for performing the various action verbs

\ Statement numbers in this section are 8000 for intransitive verbs,
\ 9000 for transitive verbs, plus ten times the verb number.  Many
\ intransitive verbs use the transitive code, and some verbs use code
\ for other verbs, as noted below.

\ Random intransitive verbs come here. Clear obj just in case (see
\ "attack").
: "what" \ 8000
   word1 S"  What?" a5toa1 CR TYPE
   0 TO obj loc2600 ;

DEFER "discard9024"

\ Fill.  Bottle must be empty, and some liquid available.  (Vase is
\ nasty.)
: "fill9222"
   29 TO spk
   loc liqloc 0= IF 144 TO spk THEN
   loc liqloc 0= vase toting? 0= OR
   IF loc2011
   ELSE 145 rspeak  2 vase prop ! -1 vase fixed ! "discard9024" THEN ;

: "fill" \ 9220
   obj vase =
   IF "fill9222" 
   ELSE obj 0<> obj bottle <> AND IF loc2011
   ELSE obj 0= bottle here? 0= AND IF "what"
   ELSE 107 TO spk
      loc liqloc 0= IF 106 TO spk THEN
      liq IF 105 TO spk THEN
      spk 107 =
      IF loc cond @ 4 mod 2/ 2* bottle prop !
         liq TO k
         bottle toting? IF -1 k place ! THEN
         k oil = IF 108 TO spk THEN
      THEN
      loc2011
   THEN THEN THEN  ;

\ Carry 8010 8012 9010 9018 9017 9016 9013 9015 9014

: "carry9014"
   db? IF ." carry9014 " THEN
   obj bird =  obj cage = OR  bird prop @ AND
   IF bird cage + obj - loc carry-object THEN
   obj loc carry-object
   liq TO k
   obj bottle =  k AND IF -1 k place ! THEN
   loc2009 ;

: "carry9015"
   db? IF ." carry9015 " THEN
   1 bird prop ! "carry9014" ;

: "carry9013"
   db? IF ." carry9013 " THEN
   cage toting? IF "carry9015" ELSE 27 rspeak loc2012 THEN ;

: "carry9016"
   db? IF ." carry9016 " THEN
   obj bird <>  bird prop @ OR IF "carry9014" ELSE
   rod toting? not IF "carry9013" ELSE  26 rspeak loc2012 THEN THEN ;

: "carry9017"
   db? IF ." carry9017 " THEN
   holdng 7 < IF "carry9016" ELSE 92 rspeak loc2012 THEN ;

: "carry9018"
   db? IF ." carry9018 " THEN
   bottle TO obj
   "carry9017" ;

\ Carry an object.  Special cases for bird and cage (if bird in cage,
\ can't take one without the other.  Liquids are also special, since
\ they depend on status of bottle.  Also various side effect, etc.

: "carry-t" \ 9010
    db? IF ." carry-t " THEN
    obj toting? IF loc2011 EXIT THEN
    25 TO spk 
    obj plant =  plant prop @ 0> 0= AND IF 115 TO spk THEN 
    obj bear =  bear prop @ 1 = AND IF 169 TO spk THEN 
    obj chain =  bear prop @ AND IF 170 to spk THEN 
    obj fixed @ IF loc2011 EXIT THEN 
    obj water <> obj oil <> AND IF "carry9017" EXIT THEN
    bottle here?  liq obj = AND IF "carry9018" EXIT THEN 
    bottle TO obj
    bottle toting? bottle prop @ 1 = AND IF "fill" EXIT THEN 
    bottle prop @ 1 <> IF 105 TO spk THEN 
    bottle toting? 0= IF 104 TO spk THEN  
    loc2011 ;

\ Carry, no object given yet.  ok if only one object present
: "carry-i"  \ 8010 
   db? IF ." carry-i " THEN
   loc atloc @ ?DUP 0=  IF "what" EXIT THEN link @ IF "what" EXIT THEN 
   6 1 DO I dloc @ loc = dflag 1 > AND IF "what" UNLOOP EXIT THEN LOOP 
   loc atloc @ TO obj
   "carry-t" ;
   
\ Say 9030 9032 9035
\ Echo word2 ( or word1 if no word2 ) Say what?, etc.
\ Magic words override.
: "say" \ 9030
   word2 COUNT DUP IF word1 puts ELSE 2DROP THEN 
   word1 COUNT -1 vocab 0=
   62 OVER =  OVER 65 = OR  OVER 71 = OR  SWAP 2025 = OR
   IF 0 word2 C!  0 TO obj loc2630  \ 9035
   ELSE word1 s$ '"' a5toa1 CR s$ 'Okay, "' TYPE TYPE
   loc2012 THEN ; \ 9032

\ Lock, unlock 8040 9040 9043 9046 9048 9049

\ Clam/oyster
: "clam/oyster"  \ 9046 goes to 2011
   0 TO k
   obj oyster = IF 1 TO k THEN
   124 k + TO spk
   obj toting? IF 120 k + TO spk THEN
   trident toting? not IF 122 k + TO spk THEN
   verb lock = IF 61 TO spk THEN
   spk 124 =
   IF clam destroy-object  oyster loc drop-object 
      pearl 105  drop-object THEN ;
   
\ Chain 9048 9049 goes to 2011
: "lock-chain"  \ 9049 goes to 2011
   172 TO spk
   chain prop @ IF 34 TO spk THEN
   loc chain plac @ <> IF 173 TO spk THEN
   172 spk <>
   IF 2 chain prop !  chain toting? IF chain loc drop-object THEN
      -1 chain fixed ! THEN ;

: "unlock-chain" \ goes to 2011
    171 TO spk  
    bear prop @ 0= IF 41 TO spk THEN
    chain prop @ 0= IF 37 TO spk THEN
    spk 171 =
    IF 0 chain prop ! 0 chain fixed !
       bear prop @ 3 <> IF 2 bear prop ! THEN
       2 bear prop @ - bear fixed ! THEN ;

: "chain"  \ 9048 goes to 2011
   verb lock = IF "lock-chain" ELSE "unlock-chain" THEN ;

: "lock9043" \ goes to 2010
   34 grate prop @ + TO k
   1 grate prop !
   verb lock = IF 0 grate prop ! THEN
   k grate prop @ 2* + TO k ;

: "lock-t"  \ 9040
   obj clam = IF "clam/oyster" loc2011 EXIT THEN
   obj door = IF 111 TO spk THEN
   obj door = door prop @ 1 = AND IF 54 TO spk THEN
   obj cage = IF 32 TO spk THEN
   obj keys = IF 55 TO spk THEN
   obj grate = obj chain = OR IF 31 TO spk THEN
   spk 31 <> keys here? not OR IF loc2011 EXIT THEN
   obj chain = IF "chain" loc2011 EXIT THEN
   closng
   IF 130 TO k  panic not IF 15 TO clock2 THEN 
      TRUE TO panic
   ELSE "lock9043" THEN  loc2010 ;

\ Lock, unlock, no object given assume various things if present
: "lock-i" \ 8040
   28 TO spk
   clam here? IF clam TO obj THEN
   oyster here? IF oyster TO obj THEN
   door at? IF door TO obj THEN
   grate at? IF grate TO obj THEN
   obj chain here? AND IF "what" EXIT THEN
   chain here? IF chain TO obj THEN
   obj 0= IF loc2011 EXIT THEN
   "lock-t" ;

\ Light lamp 9070
: "on"
   lamp here? not IF loc2011 EXIT THEN
   184 TO spk
   limit 0< IF loc2011 EXIT THEN
   1 lamp prop !  39 rspeak  wzdark IF describe-loc EXIT THEN
   loc2012 ;
   
\ Lamp off 9080
: "off"
   lamp here? not
   IF loc2011
   ELSE  0 lamp prop !  40 rspeak 
         dark? IF 16 rspeak THEN loc2012 THEN ;

\ Wave 9090
\ No effect unless waving rod at fissure
: "wave"  \ 9090
   obj toting? not obj rod <> rod2 toting? not OR and IF 29 TO spk THEN
   obj rod <> fissure at? not OR obj toting? not OR closng OR
   IF loc2011
   ELSE 1 fissure prop @ - fissure prop !
        fissure 2 fissure prop @ - pspeak
        loc2012
   THEN ;
      

\ Attack 9120 9121 9122 9124 9125 9126
\ Assume target is unambiguous.  "Throw" also links here.  Attackable
\ object fall into two categories: enemies (snake, dwarf, etc.) and
\ others (bird, clam).  Ambiguous if two enemies, or if no enemies but
\ two others.

: "attack9126"
   101 1
   DO I TO obj
      I place @ DUP dragon plac @ = SWAP dragon fixd @ = OR
      IF I k move-object THEN LOOP
   k TO loc  null TO k  newloc8 ;

: "attack" \ 9120 9121
   db? IF ." attack" THEN
   0 6 1
   DO loc I dloc @ = dflag 1 > AND IF DROP I LEAVE THEN LOOP
   obj 0= IF
     IF dwarf TO obj THEN
     snake here? IF obj 100 * snake + TO obj THEN
     dragon at? dragon prop @ 0= AND IF obj 100 * dragon + TO obj THEN
     troll at? IF obj 100 * troll + TO obj THEN
     bear here? bear prop @ 0= AND IF obj 100 * bear + TO obj THEN
     obj 100 > IF "what" EXIT THEN ELSE DROP THEN
     obj bird = 
        IF 137 TO spk  \ "attack-bird"  9124
           closed IF loc2011 EXIT THEN
           bird destroy-object  0 bird prop !
           snake place @ snake plac @ = IF tally2 1+ TO tally2 THEN
          45 TO spk
        THEN
     obj 0= IF 44 TO spk THEN   \ 9125
     obj clam = obj oyster = OR IF 150 TO spk THEN
     obj snake = IF 46 TO spk THEN
     obj dwarf = IF 49 TO spk THEN
     obj dwarf = closed AND IF death-by-dwarfs EXIT THEN
     obj dragon = IF 167 TO spk THEN
     obj troll = IF 157 TO spk THEN
     obj bear = IF 165 bear prop @ 1+ 2/ + TO spk THEN
     obj dragon <> dragon prop @ OR IF loc2011 EXIT THEN
     \ Fun stuff for dragon.  If he insists on attacking it, win!
     \ Set prop to dead, move dragon to central loc (still fixed),
     \ move rug there (not fixed), and move him there, too.  Then do a
     \ null mtion to get new description
     49 rspeak 
     0 TO verb  0 TO obj
     getin
     word1 COUNT 2DUP supper 
     OVER C@ [CHAR] Y = >R S" YES" COMPARE 0= R> OR 0=
     IF loc2608 EXIT THEN
     dragon 1 pspeak 2 dragon prop !  0 rug prop !
     dragon plac @ dragon fixd @ + 2/ TO k
     dragon 100 + -1 move-object
     rug 100 + 0 move-object
     dragon k move-object
     rug k move-object
     "attack9126" ;

\ Pour 9130 9132
\ If no object, or object is a bottle, assume contents of bottle.
\ Special tests for pouring water or oil on plant or rusty door.
: "pour9132"
   0 door prop !
   obj oil = IF 1 door prop ! THEN
   door prop @ 113 + to spk ;

: "pour" \ 9130
   obj bottle = obj 0= OR IF liq TO obj THEN
   obj 0= IF "what" EXIT THEN
   obj toting? not IF loc2011 EXIT THEN
   78 TO spk
   obj oil <> obj water <> AND IF loc2011 EXIT THEN
   1 bottle prop !
   0 obj place !
   77 to spk
   plant at? door at? OR not IF loc2011 EXIT THEN
   door at?
   IF "pour9132" loc2011 
   ELSE 112 TO spk
      obj water = not IF loc2011 EXIT THEN
      plant plant prop @ 1+ pspeak
      plant prop @ 2 + 6 MOD plant prop !
      plant prop @ 2/ plant2 prop !
      null TO k  newloc8 THEN ;

\ Eat 8140 8142 8140
\ Intransitive: assume food if present, else ask what.
\ Transitive: food ok, somethings loose appetite, rest are ridiculous
: "eat-food" \ 8142
   food destroy-object  72 TO spk loc2011 ;

: "eat-i" \ 8140
    food here? IF  "eat-food" ELSE "what" THEN ;

: "eat-t" \ 9140
    obj food =
    IF "eat-food" ELSE
       obj bird = obj snake = OR obj clam = OR obj oyster = OR
       obj dwarf = OR obj dragon = OR obj troll = OR obj bear = OR
       IF 71 TO spk  THEN loc2011
    THEN ;    

\ Drink 9150
\ If no object, assume water and look for it here.  If water in in the
\ bottle, drink that.  Else mut be water at a water loc, so drink
\ stream.
: "drink"
    obj 0= loc liqloc water <> AND
    liq water <> bottle here? 0= OR AND 
    IF "what"
    ELSE obj obj water <> AND IF 110 TO spk THEN
       spk 110 = liq water <> OR bottle here? 0= OR 0=
       IF 1 bottle prop !  0 water place !  74 TO spk THEN loc2011
    THEN ;

: "rub" \ 9160
   obj lamp <> IF 76 TO spk THEN loc2011 ;

\ Throw 9170 9171 9172 9175 9176 9177 9178 
\ Same as discard unless axe.  Then same as attack except ignore bird,
\ and if dwarf is present then one might be killed (only way to do
\ so!).  Axe also special for dragon, bear, and troll. Treasures
\ special for troll.
: "throw9175"
   spk rspeak  axe loc drop-object null to k  newloc8 ;

: axe-at-dwarf  ( i -- )  \ 9172
   >R
   48 TO spk
   3 ran 0>  saved -1 = AND
   IF false R@ dseen !  0 R@ dloc ! 47 TO spk
      dkill 1+ DUP TO dkill 1 = IF 149 TO spk THEN THEN R> DROP
   "throw9175" ;

: axe-at-bear  \ 9176
   \ This will teach him to throw the axe at the bear!
   164 TO spk  axe loc drop-object -1 axe fixed !  1 axe prop !
   bear juggle-object  loc2011 ;

\ Feed 9210 9212 9213 9214 9215
\ If bird, no seed.  Snake, dragon, troll: quip.  If dwarf, make him
\ mad.  Bear, special

: "feed-bird" \ 9210
   100 TO spk ;

: "feed-snake/dragon/troll" \ 9212
   102 to spk
   obj dragon = dragon prop @ AND IF 100 TO spk THEN
   obj troll = IF 182 TO spk THEN
   obj snake <> closed OR bird here? 0= OR not
   IF 101 TO spk bird destroy-object  0 bird prop ! tally2 1+ TO tally2
      THEN ;

: "feed-nothing" \ 9215
   14 TO spk ;

: "feed-dwarf" \ 9213
    103 TO spk  dflag 1+ TO dflag ;

: "feed-bear" \ 9214
    bear prop @ 0= IF 102 TO spk THEN
    bear prop @ 3 = IF 110 TO spk THEN
    food here?
    IF food destroy-object  1 bear prop !  0 axe fixed !  0 axe prop !
       168 TO spk THEN ;
    
: "feed"  \ 9210
   obj bird =
   IF "feed-bird" 
   ELSE obj snake = obj dragon = OR obj troll = OR
     IF "feed-snake/dragon/troll"
   ELSE obj dwarf = IF food here? IF "feed-dwarf" THEN
   ELSE obj bear = IF "feed-bear"
   ELSE "feed-nothing" THEN THEN THEN THEN loc2011 ;

\ Discard object 9020 9021 9024 9025 9026 9027 9028
\ "Throw" also comes here for most objects.  Special cases for bird
\ (might attack snake or dragon) and cage (might constain bird) and
\ vase.  Drop coins at vending machine for extra batteries.

: "discard9021"
   db? IF ." discard9021 " THEN
   liq TO k
   obj k = IF bottle TO obj THEN
   obj bottle =  k AND IF 0 k place ! THEN
   obj cage = bird prop @ AND IF bird loc drop-object THEN
   obj bird = IF 0 bird prop ! THEN
   obj loc drop-object loc2012 ;

: "discard9026"
   163 rspeak
   troll 0 move-object
   troll 100 + 0 move-object
   troll2 troll plac @ move-object
   troll2 100 + troll fixd @ move-object
   chasm juggle-object
   2 troll prop !
   "discard9021" ;

: "discard9027"
   54 rspeak
   "discard9021" ;

: "discard9028"
    2 vase prop !
    pillow at? IF 0 vase prop ! THEN
    vase vase prop @ 1+ pspeak
    vase prop @ 0<> IF -1 vase fixed ! THEN
    "discard9021" ;

: "discard9025"
   154 rspeak
   bird destroy-object
   0 bird prop !
   snake place @ snake plac @ = IF tally2 1+ TO tally2 THEN
   loc2012 ;

: "discard" \ 9020
   rod2 toting?  obj rod = AND  rod toting? not AND
   IF rod2 TO obj THEN
   obj toting? not IF loc2011 EXIT THEN
   obj bird <>  snake here? not OR IF "discard9024" EXIT THEN
   30 rspeak
   closed IF death-by-dwarfs EXIT THEN
   snake destroy-object
   \ set prop for use by travel options
   1 snake prop !
   "discard9021" ;

: (9024)
   coins destroy-object
   batter loc drop-object
   batter 0 pspeak
   loc2012 ;

:NONAME  \ 9024
   obj coins <>  vend here? not OR not
   IF (9024)
   ELSE obj bird <> dragon at? not OR dragon prop @ OR not
   IF "discard9025" 
   ELSE obj bear <>  troll at? not OR not
   IF "discard9026"
   ELSE obj vase = loc pillow plac @ <> AND not
   IF "discard9027"
   ELSE "discard9028" THEN THEN THEN THEN ; IS "discard9024"

: "throw9177"
    \ But throwing food is another story
    bear TO obj
    "feed" ;

: "throw9178"
   \ Snarf a treasure for the troll  
    159 TO spk
    obj 0 drop-object
    troll 0 move-object
    troll 100 + 0 move-object
    troll2 troll plac @ drop-object
    troll2 100 + troll fixd @ drop-object
    chasm juggle-object
    loc2011 ;

: "throw"  \ 9170
   rod2 toting? obj rod = AND rod toting? 0= AND IF rod2 TO obj THEN
   obj toting? not IF loc2011 EXIT THEN
   obj 50 < 0= obj maxtrs > 0= AND
       troll at? AND IF "throw9178" EXIT THEN
   obj food = bear here? AND IF "throw9177" EXIT THEN
   obj axe <> IF "discard" EXIT THEN
   6 1 DO  \ Needn't check dflag if axe is here
       I dloc @ loc = IF I axe-at-dwarf UNLOOP EXIT THEN
       LOOP
   152 TO spk dragon at? dragon prop @ 0= AND IF "throw9175" EXIT THEN
   158 TO spk troll at? IF "throw9175" EXIT THEN
   bear here? bear prop @ 0= AND IF axe-at-bear EXIT THEN
   0 TO obj  "attack" ;

\ Quit 8180 8185
: "quit8180" \ 8180
   \ Intransitive only.  Verify intent and exit on request
   22 54 54 yesr TO gaveup ;

: "quit8185"
   gaveup IF ?score ELSE loc2012 THEN ;

: "quit" "quit8180" "quit8185" ;


\ Find.  Might be carrying it, or it might be here.  Else give caveat.
: "find" \ 9190 9192
   obj at? liq obj =  bottle at? AND OR K loc liqloc = Or
   IF 94 TO spk THEN
   6 1 do
     loc i dloc @ = dflag 2 > AND OBJ dwarf = AND
     IF 94 TO spk THEN
   LOOP
   closed IF 138 TO spk THEN
   obj toting? IF 24 TO spk THEN loc2011 ;
 
\ Inventory  If object, treat same as find, else report current burden.
: "inventory" \ 8200
   98 TO spk
   101 1 DO
      I bear <> I toting? AND
      IF spk 98 = IF 99 rspeak THEN
         FALSE TO blklin
         I -1 pspeak
         TRUE TO blklin
         0 TO spk
      THEN
   LOOP
   bear toting? IF 141 TO spk THEN loc2011 ;


 
\ Blast.  No effect unless you've got dynamite, which is a neat trick!
: "blast" \ 9230
   rod2 prop @ 0< closed 0= OR
   IF loc2011
   ELSE  133 TO bonus
      loc 115 = IF 134 TO bonus THEN
      rod2 here? IF 135 TO bonus THEN
      bonus rspeak
      ?score
   THEN ;

: "score" \ 8240
    TRUE TO scorng ?score ;

: "score8241"
    FALSE TO scorng
    CR ." If you were to quit now, you would score "
       score . ." out of a possible " mxscor . ." ."
    143 54 54 yesr TO gaveup
    "quit8185" ;

\ Fee Fie Foe Foo (and Fum).  Advance to next state if given in proper
\ order.  Look up word1 in Section 3 over vocab to determine which
\ word we've got.  Last word zips the eggs back to the gian room
\ (unless already there).
: "fffff8252"
   k to foobar
   k 4 <>
   IF loc2009
   ELSE 0 TO foobar
     eggs place @ eggs plac @ =
     eggs toting? loc eggs plac @ = AND OR
     IF loc2011
     ELSE
       \ Bring back troll if we steal the eggs back from him before
       \ crossing
       eggs place 0= troll place @ 0= AND troll prop @ 0= AND
       IF  1 troll prop ! THEN
       2 TO k
       eggs here? IF 1 TO k THEN
       loc eggs plac @ = IF 0 TO k THEN
       eggs eggs plac @ move-object
       eggs k pspeak
       loc2012 
     THEN
   THEN ;

: "fffff"  \ 8250
   word1 COUNT 3 vocab TO k
   42 TO spk
   foobar 1 k - =
   IF "fffff8252"
   ELSE 
      foobar IF 151 TO spk THEN loc2011 THEN ;

: "brief" \ 8260
   156 TO spk
   10000 TO abbnum
   3 TO detail loc2011 ;

\ Read.  Magazines in dwarfish, message we've seen, and ... oyster?

: "read-t" \ 9270
   dark?
   IF loc5190
   ELSE obj magzin = IF 190 TO spk THEN
      obj tablet = IF 196 TO spk THEN
      obj messag = IF 191 TO spk THEN
      obj oyster = 2 hinted @ AND
          oyster toting? AND IF 194 TO spk THEN
      obj oyster <>  2 hinted @  OR
      oyster toting? not OR closed not OR
      IF loc2011 
      ELSE 192 193 54 yesr 2 hinted ! loc2012 THEN
   THEN ;

: "read-i"  \ 8270
    magzin here? IF magzin TO obj THEN
    tablet here? IF obj 100 * tablet + TO obj THEN
    messag here? IF obj 100 * messag + TO obj THEN
    oyster toting? closed AND IF oyster TO obj THEN
    obj 100 > obj 0= OR dark? OR IF "what" ELSE "read-t" THEN ;

\ Break.  Only works for mirror in repository and, of course, the vase
: "break9282"
    198 TO spk
    vase toting? IF vase loc drop-object THEN
    2 vase prop !
    -1 vase fixed ! loc2011 ;

: "break"  \ 9280
   obj mirror = IF 148 TO spk THEN
   obj vase = vase prop @ 0= AND
   IF "break9282"
   ELSE
    obj mirror <> closed 0= OR 
    IF loc2011
    ELSE
     197 rspeak death-by-dwarfs
    THEN
  THEN ;
  

: "wake" \ 9290
   \ Only use to disturb the dwarfs
   obj dwarf <> closed 0= OR
      IF loc2011
      ELSE 199 rspeak death-by-dwarfs THEN ;

\ Suspend.  Offer to exit leaving things restartable, but requiring
\ a delay before restarting (so can't save the world before trying
\ something risky).  Upon rstarting, setup=-1 cause return to 8305
\ to pick up again.

: "suspend" \ 8300
    201 TO spk
    demo
    IF loc2011
    ELSE
      CR ." I can suspend your adventure for you so that you can "
         ." resume later, but"
      CR ." you will have to wait at least " latncy .
         ." minutes before continuing."
      200 54 54 yesr IF
        datime TO savet TO saved
        -1 TO setup
        ciao
      ELSE loc2012 THEN
    THEN ;

: "suspend8305"
    start TO yea
    3 TO setup
    null TO k
    newloc8 ;

: "hours" \ 8310
   \ Report current non-prime-time hours
    6 mspeak hours loc2012 ;
