/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.util.ArrayList;
import org.aspectj.apache.bcel.classfile.Signature;

public class GenericSignatureParser {
    private String inputString;
    private String[] tokenStream;
    private int tokenIndex = 0;

    public Signature.ClassSignature parseAsClassSignature(String sig) {
        this.inputString = sig;
        this.tokenStream = this.tokenize(sig);
        this.tokenIndex = 0;
        Signature.ClassSignature classSig = new Signature.ClassSignature();
        if (this.maybeEat("<")) {
            ArrayList<Signature.FormalTypeParameter> formalTypeParametersList = new ArrayList<Signature.FormalTypeParameter>();
            do {
                formalTypeParametersList.add(this.parseFormalTypeParameter());
            } while (!this.maybeEat(">"));
            classSig.formalTypeParameters = new Signature.FormalTypeParameter[formalTypeParametersList.size()];
            formalTypeParametersList.toArray(classSig.formalTypeParameters);
        }
        classSig.superclassSignature = this.parseClassTypeSignature();
        ArrayList<Signature.ClassTypeSignature> superIntSigs = new ArrayList<Signature.ClassTypeSignature>();
        while (this.tokenIndex < this.tokenStream.length) {
            superIntSigs.add(this.parseClassTypeSignature());
        }
        classSig.superInterfaceSignatures = new Signature.ClassTypeSignature[superIntSigs.size()];
        superIntSigs.toArray(classSig.superInterfaceSignatures);
        return classSig;
    }

    public Signature.MethodTypeSignature parseAsMethodSignature(String sig) {
        this.inputString = sig;
        this.tokenStream = this.tokenize(sig);
        this.tokenIndex = 0;
        Signature.FormalTypeParameter[] formals = new Signature.FormalTypeParameter[]{};
        Signature.TypeSignature[] params = new Signature.TypeSignature[]{};
        Signature.TypeSignature returnType = null;
        Signature.FieldTypeSignature[] throwsSigs = new Signature.FieldTypeSignature[]{};
        if (this.maybeEat("<")) {
            ArrayList<Signature.FormalTypeParameter> formalTypeParametersList = new ArrayList<Signature.FormalTypeParameter>();
            do {
                formalTypeParametersList.add(this.parseFormalTypeParameter());
            } while (!this.maybeEat(">"));
            formals = new Signature.FormalTypeParameter[formalTypeParametersList.size()];
            formalTypeParametersList.toArray(formals);
        }
        this.eat("(");
        ArrayList<Signature.TypeSignature> paramList = new ArrayList<Signature.TypeSignature>();
        while (!this.maybeEat(")")) {
            Signature.FieldTypeSignature fsig = this.parseFieldTypeSignature(true);
            if (fsig != null) {
                paramList.add(fsig);
                continue;
            }
            paramList.add(new Signature.BaseTypeSignature(this.eatIdentifier()));
        }
        params = new Signature.TypeSignature[paramList.size()];
        paramList.toArray(params);
        returnType = this.parseFieldTypeSignature(true);
        if (returnType == null) {
            returnType = new Signature.BaseTypeSignature(this.eatIdentifier());
        }
        ArrayList<Signature.FieldTypeSignature> throwsList = new ArrayList<Signature.FieldTypeSignature>();
        while (this.maybeEat("^")) {
            Signature.FieldTypeSignature fsig = this.parseFieldTypeSignature(false);
            throwsList.add(fsig);
        }
        throwsSigs = new Signature.FieldTypeSignature[throwsList.size()];
        throwsList.toArray(throwsSigs);
        return new Signature.MethodTypeSignature(formals, params, returnType, throwsSigs);
    }

    public Signature.FieldTypeSignature parseAsFieldSignature(String sig) {
        this.inputString = sig;
        this.tokenStream = this.tokenize(sig);
        this.tokenIndex = 0;
        return this.parseFieldTypeSignature(false);
    }

    private Signature.FormalTypeParameter parseFormalTypeParameter() {
        Signature.FormalTypeParameter ftp = new Signature.FormalTypeParameter();
        ftp.identifier = this.eatIdentifier();
        this.eat(":");
        ftp.classBound = this.parseFieldTypeSignature(true);
        if (ftp.classBound == null) {
            ftp.classBound = new Signature.ClassTypeSignature("Ljava/lang/Object;", "Ljava/lang/Object");
        }
        ArrayList<Signature.FieldTypeSignature> optionalBounds = new ArrayList<Signature.FieldTypeSignature>();
        while (this.maybeEat(":")) {
            optionalBounds.add(this.parseFieldTypeSignature(false));
        }
        ftp.interfaceBounds = new Signature.FieldTypeSignature[optionalBounds.size()];
        optionalBounds.toArray(ftp.interfaceBounds);
        return ftp;
    }

    private Signature.FieldTypeSignature parseFieldTypeSignature(boolean isOptional) {
        if (isOptional && !this.tokenStream[this.tokenIndex].startsWith("L") && !this.tokenStream[this.tokenIndex].startsWith("T") && !this.tokenStream[this.tokenIndex].startsWith("[")) {
            return null;
        }
        if (this.maybeEat("[")) {
            return this.parseArrayTypeSignature();
        }
        if (this.tokenStream[this.tokenIndex].startsWith("L")) {
            return this.parseClassTypeSignature();
        }
        if (this.tokenStream[this.tokenIndex].startsWith("T")) {
            return this.parseTypeVariableSignature();
        }
        throw new IllegalStateException("Expecting [,L, or T, but found " + this.tokenStream[this.tokenIndex] + " while unpacking " + this.inputString);
    }

    private Signature.ArrayTypeSignature parseArrayTypeSignature() {
        Signature.FieldTypeSignature fieldType = this.parseFieldTypeSignature(true);
        if (fieldType != null) {
            return new Signature.ArrayTypeSignature(fieldType);
        }
        return new Signature.ArrayTypeSignature(new Signature.BaseTypeSignature(this.eatIdentifier()));
    }

    private Signature.ClassTypeSignature parseClassTypeSignature() {
        Signature.SimpleClassTypeSignature outerType = null;
        Signature.SimpleClassTypeSignature[] nestedTypes = new Signature.SimpleClassTypeSignature[]{};
        StringBuffer ret = new StringBuffer();
        String identifier = this.eatIdentifier();
        ret.append(identifier);
        while (this.maybeEat("/")) {
            ret.append("/");
            ret.append(this.eatIdentifier());
        }
        identifier = ret.toString();
        while (!this.maybeEat(";")) {
            if (this.maybeEat(".")) {
                outerType = new Signature.SimpleClassTypeSignature(identifier);
                ArrayList<Signature.SimpleClassTypeSignature> nestedTypeList = new ArrayList<Signature.SimpleClassTypeSignature>();
                do {
                    ret.append(".");
                    Signature.SimpleClassTypeSignature sig = this.parseSimpleClassTypeSignature();
                    ret.append(sig.toString());
                    nestedTypeList.add(sig);
                } while (this.maybeEat("."));
                nestedTypes = new Signature.SimpleClassTypeSignature[nestedTypeList.size()];
                nestedTypeList.toArray(nestedTypes);
                continue;
            }
            if (this.tokenStream[this.tokenIndex].equals("<")) {
                ret.append("<");
                Signature.TypeArgument[] tArgs = this.maybeParseTypeArguments();
                int i = 0;
                while (i < tArgs.length) {
                    ret.append(tArgs[i].toString());
                    ++i;
                }
                ret.append(">");
                outerType = new Signature.SimpleClassTypeSignature(identifier, tArgs);
                ArrayList<Signature.SimpleClassTypeSignature> nestedTypeList = new ArrayList<Signature.SimpleClassTypeSignature>();
                while (this.maybeEat(".")) {
                    ret.append(".");
                    Signature.SimpleClassTypeSignature sig = this.parseSimpleClassTypeSignature();
                    ret.append(sig.toString());
                    nestedTypeList.add(sig);
                }
                nestedTypes = new Signature.SimpleClassTypeSignature[nestedTypeList.size()];
                nestedTypeList.toArray(nestedTypes);
                continue;
            }
            throw new IllegalStateException("Expecting .,<, or ;, but found " + this.tokenStream[this.tokenIndex] + " while unpacking " + this.inputString);
        }
        ret.append(";");
        if (outerType == null) {
            outerType = new Signature.SimpleClassTypeSignature(ret.toString());
        }
        return new Signature.ClassTypeSignature(ret.toString(), outerType, nestedTypes);
    }

    private Signature.SimpleClassTypeSignature parseSimpleClassTypeSignature() {
        String identifier = this.eatIdentifier();
        Signature.TypeArgument[] tArgs = this.maybeParseTypeArguments();
        if (tArgs != null) {
            return new Signature.SimpleClassTypeSignature(identifier, tArgs);
        }
        return new Signature.SimpleClassTypeSignature(identifier);
    }

    private Signature.TypeArgument parseTypeArgument() {
        boolean isPlus = false;
        boolean isMinus = false;
        if (this.maybeEat("*")) {
            return new Signature.TypeArgument();
        }
        if (this.maybeEat("+")) {
            isPlus = true;
        } else if (this.maybeEat("-")) {
            isMinus = true;
        }
        Signature.FieldTypeSignature sig = this.parseFieldTypeSignature(false);
        return new Signature.TypeArgument(isPlus, isMinus, sig);
    }

    private Signature.TypeArgument[] maybeParseTypeArguments() {
        if (this.maybeEat("<")) {
            ArrayList<Signature.TypeArgument> typeArgs = new ArrayList<Signature.TypeArgument>();
            do {
                Signature.TypeArgument arg = this.parseTypeArgument();
                typeArgs.add(arg);
            } while (!this.maybeEat(">"));
            Signature.TypeArgument[] tArgs = new Signature.TypeArgument[typeArgs.size()];
            typeArgs.toArray(tArgs);
            return tArgs;
        }
        return null;
    }

    private Signature.TypeVariableSignature parseTypeVariableSignature() {
        Signature.TypeVariableSignature tv = new Signature.TypeVariableSignature(this.eatIdentifier());
        this.eat(";");
        return tv;
    }

    private boolean maybeEat(String token) {
        if (this.tokenStream.length <= this.tokenIndex) {
            return false;
        }
        if (this.tokenStream[this.tokenIndex].equals(token)) {
            ++this.tokenIndex;
            return true;
        }
        return false;
    }

    private void eat(String token) {
        if (!this.tokenStream[this.tokenIndex].equals(token)) {
            throw new IllegalStateException("Expecting " + token + " but found " + this.tokenStream[this.tokenIndex] + " while unpacking " + this.inputString);
        }
        ++this.tokenIndex;
    }

    private String eatIdentifier() {
        return this.tokenStream[this.tokenIndex++];
    }

    public String[] tokenize(String signatureString) {
        char[] chars = signatureString.toCharArray();
        int index = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuffer identifier = new StringBuffer();
        boolean inParens = false;
        boolean inArray = false;
        boolean couldSeePrimitive = false;
        do {
            switch (chars[index]) {
                case '<': {
                    if (identifier.length() > 0) {
                        tokens.add(identifier.toString());
                    }
                    identifier = new StringBuffer();
                    tokens.add("<");
                    break;
                }
                case '>': {
                    if (identifier.length() > 0) {
                        tokens.add(identifier.toString());
                    }
                    identifier = new StringBuffer();
                    tokens.add(">");
                    break;
                }
                case ':': {
                    if (identifier.length() > 0) {
                        tokens.add(identifier.toString());
                    }
                    identifier = new StringBuffer();
                    tokens.add(":");
                    break;
                }
                case '/': {
                    if (identifier.length() > 0) {
                        tokens.add(identifier.toString());
                    }
                    identifier = new StringBuffer();
                    tokens.add("/");
                    couldSeePrimitive = false;
                    break;
                }
                case ';': {
                    if (identifier.length() > 0) {
                        tokens.add(identifier.toString());
                    }
                    identifier = new StringBuffer();
                    tokens.add(";");
                    couldSeePrimitive = true;
                    inArray = false;
                    break;
                }
                case '^': {
                    if (identifier.length() > 0) {
                        tokens.add(identifier.toString());
                    }
                    identifier = new StringBuffer();
                    tokens.add("^");
                    break;
                }
                case '+': {
                    tokens.add("+");
                    break;
                }
                case '-': {
                    tokens.add("-");
                    break;
                }
                case '*': {
                    tokens.add("*");
                    break;
                }
                case '.': {
                    if (identifier.length() > 0) {
                        tokens.add(identifier.toString());
                    }
                    identifier = new StringBuffer();
                    couldSeePrimitive = false;
                    tokens.add(".");
                    break;
                }
                case '(': {
                    tokens.add("(");
                    inParens = true;
                    couldSeePrimitive = true;
                    break;
                }
                case ')': {
                    tokens.add(")");
                    inParens = false;
                    break;
                }
                case '[': {
                    tokens.add("[");
                    couldSeePrimitive = true;
                    inArray = true;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    if ((inParens || inArray) && couldSeePrimitive && identifier.length() == 0) {
                        tokens.add(new String("" + chars[index]));
                    } else {
                        identifier.append(chars[index]);
                    }
                    inArray = false;
                    break;
                }
                case 'L': {
                    couldSeePrimitive = false;
                }
                default: {
                    identifier.append(chars[index]);
                }
            }
        } while (++index < chars.length);
        if (identifier.length() > 0) {
            tokens.add(identifier.toString());
        }
        String[] tokenArray = new String[tokens.size()];
        tokens.toArray(tokenArray);
        return tokenArray;
    }
}

